/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountCheckResult;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountUserLevelCollection;
import com.kingdee.eas.basedata.master.account.AccountUserLevelInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.Account_ControlCollection;
import com.kingdee.eas.basedata.master.account.Account_ControlFactory;
import com.kingdee.eas.basedata.master.account.Account_ControlInfo;
import com.kingdee.eas.basedata.master.account.AcctRefContrastException;
import com.kingdee.eas.basedata.master.account.IAccountFacade;
import com.kingdee.eas.basedata.master.account.IAccountRefContrast;
import com.kingdee.eas.basedata.master.account.IAccountTable;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.IAccount_Control;
import com.kingdee.eas.basedata.master.account.app.AcctRefContrastHelper;
import com.kingdee.eas.basedata.master.material.util.commonUtils;
import com.kingdee.eas.basedata.org.CUBDControlCollection;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.CUBDDispatchPattern;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.BizHasDealException;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.common.app.IBatchBizCheckBalance;
import com.kingdee.eas.common.app.IBatchBizHasDeal;
import com.kingdee.eas.common.app.IBatchBizReference;
import com.kingdee.eas.common.app.IBizCheckBalance;
import com.kingdee.eas.common.app.IBizHasDeal;
import com.kingdee.eas.common.app.IBizReference;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountTools {
    public static final String BENWEI = "11111111-1111-1111-1111-111111111111DEB58FDC";
    public static final String BAOGAO = "22222222-2222-2222-2222-222222222222DEB58FDC";
    private static Logger logger = Logger.getLogger(AccountTools.class);

    public static CtrlUnitInfo getSysCU() {
        CtrlUnitInfo sysCU = new CtrlUnitInfo();
        sysCU.setId(BOSUuid.read((String)"11111111-1111-1111-1111-111111111111CCE7AED4"));
        return sysCU;
    }

    public static boolean isStringEqual(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null && str2 != null && str2.trim().equals("")) {
            return true;
        }
        if (str1 != null && str1.trim().equals("") && str2 == null) {
            return true;
        }
        return str1 != null && str2 != null && str1.equals(str2);
    }

    public static AccountUserLevelInfo getAccountUserLevelInfoByLevel(int level, AccountUserLevelCollection userLevels) {
        for (int i = 0; i < userLevels.size(); ++i) {
            AccountUserLevelInfo levelInfo = userLevels.get(i);
            if (levelInfo.getLevel() != level) continue;
            return levelInfo;
        }
        return null;
    }

    public static boolean checkTableCanDeletedByCU(CtrlUnitInfo currentCU) {
        boolean result = true;
        return result;
    }

    public static boolean checkTableCanDeletedByCompany(CompanyOrgUnitInfo currentCompany) {
        boolean result = true;
        return result;
    }

    public static AccountTableInfo getDefaultAccountTableByCU(CtrlUnitInfo currentCtrlUnit) throws BOSException {
        AccountTableInfo tableInfo = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("destCU", (Object)currentCtrlUnit.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Boolean(false)));
        evi.getSelector().add("accountTableID.*");
        evi.getSelector().add("accountTableID.userLevel.*");
        SorterItemCollection sorters = evi.getSorter();
        SorterItemInfo sort = new SorterItemInfo("accountTableID.userLevel.level");
        sort.setSortType(SortType.ASCEND);
        sorters.add(sort);
        IAccount_Control acctCtrl = Account_ControlFactory.getRemoteInstance();
        Account_ControlCollection acctCtrlsCols = acctCtrl.getAccount_ControlCollection(evi);
        if (acctCtrlsCols != null && acctCtrlsCols.size() > 0) {
            tableInfo = acctCtrlsCols.get(0).getAccountTableID();
        }
        return tableInfo;
    }

    public static AccountTableInfo getDefaultAccountTableByCompany(CompanyOrgUnitInfo currentCompany) throws BOSException {
        AccountTableInfo tableInfo = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)currentCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Boolean(false)));
        evi.getSelector().add("accountTableID.*");
        evi.getSelector().add("accountTableID.userLevel.*");
        SorterItemCollection sorters = evi.getSorter();
        SorterItemInfo sort = new SorterItemInfo("accountTableID.userLevel.level");
        sort.setSortType(SortType.ASCEND);
        sorters.add(sort);
        IAccount_Control acctCtrl = Account_ControlFactory.getRemoteInstance();
        Account_ControlCollection acctCtrlsCols = acctCtrl.getAccount_ControlCollection(evi);
        if (acctCtrlsCols != null && acctCtrlsCols.size() > 0) {
            tableInfo = acctCtrlsCols.get(0).getAccountTableID();
        }
        return tableInfo;
    }

    public static CtrlUnitInfo getCurrentCU(Context ctx) {
        if (ctx == null) {
            return SysContext.getSysContext().getCurrentCtrlUnit();
        }
        return ContextUtil.getCurrentCtrlUnit((Context)ctx);
    }

    public static CompanyOrgUnitInfo getCurrentCompany(Context ctx) {
        if (ctx == null) {
            return SysContext.getSysContext().getCurrentFIUnit();
        }
        return ContextUtil.getCurrentFIUnit((Context)ctx);
    }

    public static Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    public static String getMLTime() {
        DateFormat sdf = BOSLocaleUtil.getDateFormat();
        String nowTime = sdf.format(AccountTools.getTime());
        return nowTime;
    }

    public static String formatTime(Date date) {
        DateFormat sdf = BOSLocaleUtil.getDateFormat();
        return sdf.format(date);
    }

    public static boolean checkAccountTableIsSelfConstructed(Context ctx, CompanyOrgUnitInfo company, AccountTableInfo info) throws BOSException {
        IAccount_Control acctCtrl = ctx == null ? Account_ControlFactory.getRemoteInstance() : Account_ControlFactory.getLocalInstance(ctx);
        if (company != null && info != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)company.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("srcCompany", null));
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)info.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Integer(0)));
            evi.setFilter(filter);
            Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
            if (acctCtrlCols != null && acctCtrlCols.size() == 1) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkAccountTableIsSelfConstructed(Context ctx, AccountTableInfo info) throws BOSException {
        IAccount_Control acctCtrl = ctx == null ? Account_ControlFactory.getRemoteInstance() : Account_ControlFactory.getLocalInstance(ctx);
        if (info != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)AccountTools.getCurrentCompany(ctx).getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("srcCompany", null));
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)info.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Integer(0)));
            evi.setFilter(filter);
            Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
            if (acctCtrlCols != null && acctCtrlCols.size() == 1) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkAccountTableIsSelfConstructed(Context ctx, AccountTableInfo info, CtrlUnitInfo cu) throws BOSException {
        IAccount_Control acctCtrl = ctx == null ? Account_ControlFactory.getRemoteInstance() : Account_ControlFactory.getLocalInstance(ctx);
        if (info != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("destCu", (Object)cu.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("srcCu", null));
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)info.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Integer(0)));
            evi.setFilter(filter);
            Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
            if (acctCtrlCols != null && acctCtrlCols.size() == 1) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkAccountTableIsSelfConstructed(Context ctx, AccountTableInfo info, CompanyOrgUnitInfo company) throws BOSException {
        IAccount_Control acctCtrl = ctx == null ? Account_ControlFactory.getRemoteInstance() : Account_ControlFactory.getLocalInstance(ctx);
        if (info != null && company != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)company.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("srcCompany", null));
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)info.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Integer(0)));
            evi.setFilter(filter);
            Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
            if (acctCtrlCols != null && acctCtrlCols.size() == 1) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkAccountTableHasAssignToChild(Context ctx, AccountTableInfo info) throws BOSException {
        IAccount_Control acctCtrl = ctx == null ? Account_ControlFactory.getRemoteInstance() : Account_ControlFactory.getLocalInstance(ctx);
        if (info != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            evi.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("srcCompany", null, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)info.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Integer(0)));
            Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
            if (acctCtrlCols != null && acctCtrlCols.size() == 0) {
                return false;
            }
        }
        return true;
    }

    public static CurrencyCollection getAllCurrency(Context ctx) throws BOSException {
        ICurrency currency = ctx == null ? CurrencyFactory.getRemoteInstance() : CurrencyFactory.getLocalInstance((Context)ctx);
        String oql = "select id,number,name where id not in('11111111-1111-1111-1111-111111111111DEB58FDC','22222222-2222-2222-2222-222222222222DEB58FDC')";
        return currency.getCurrencyCollection(oql);
    }

    public static boolean checkAccountHasReference(Context ctx, AccountViewInfo info) throws EASBizException, BOSException {
        boolean ret = false;
        if (info.getId() != null && info.getId().toString().length() > 0) {
            IAccountView acct = ctx == null ? AccountViewFactory.getRemoteInstance() : AccountViewFactory.getLocalInstance(ctx);
            ret = acct.isHasDeal((IObjectPK)new ObjectUuidPK(info.getId()));
        }
        return ret;
    }

    public static boolean checkAccountHasInferior(Context ctx, AccountViewInfo info) throws BOSException {
        IAccountView acct = ctx == null ? AccountViewFactory.getRemoteInstance() : AccountViewFactory.getLocalInstance(ctx);
        return acct.checkAccountHasInferior(info);
    }

    public static Account_ControlInfo getAcctCtrlInfo(Context ctx, AccountTableInfo info, CtrlUnitInfo destCu) throws BOSException {
        IAccount_Control acctCtrl = ctx == null ? Account_ControlFactory.getRemoteInstance() : Account_ControlFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        evi.getSelector().add("id");
        evi.getSelector().add("dc");
        evi.getSelector().add("currencyID");
        evi.getSelector().add("isQty");
        evi.getSelector().add("ac");
        evi.getSelector().add("acNotice");
        evi.getSelector().add("bw");
        evi.getSelector().add("control");
        evi.getSelector().add("isChangeCurrency");
        evi.getSelector().add("accountTableID");
        evi.getSelector().add("srcCu");
        evi.getSelector().add("destCu");
        evi.getSelector().add("isDefaultForRefer");
        if (info != null) {
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)info.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("destCu", (Object)destCu.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Integer(0)));
            Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
            if (acctCtrlCols != null && acctCtrlCols.size() > 0) {
                return acctCtrlCols.get(0);
            }
        }
        return null;
    }

    public static Account_ControlInfo getAcctCtrlInfo(Context ctx, AccountTableInfo info, CompanyOrgUnitInfo destCompany) throws BOSException {
        IAccount_Control acctCtrl = ctx == null ? Account_ControlFactory.getRemoteInstance() : Account_ControlFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        evi.getSelector().add("id");
        evi.getSelector().add("dc");
        evi.getSelector().add("currencyID");
        evi.getSelector().add("isQty");
        evi.getSelector().add("ac");
        evi.getSelector().add("acNotice");
        evi.getSelector().add("bw");
        evi.getSelector().add("control");
        evi.getSelector().add("isChangeCurrency");
        evi.getSelector().add("accountTableID");
        evi.getSelector().add("srcCompany");
        evi.getSelector().add("destCompany");
        evi.getSelector().add("isDefaultForRefer");
        if (info != null) {
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)info.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)destCompany.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Integer(0)));
            Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
            if (acctCtrlCols != null && acctCtrlCols.size() > 0) {
                return acctCtrlCols.get(0);
            }
        }
        return null;
    }

    public static Account_ControlInfo getAcctCtrlInfo(Context ctx, AccountTableInfo info, CtrlUnitInfo srcCu, CtrlUnitInfo destCu) throws BOSException {
        IAccount_Control acctCtrl = ctx == null ? Account_ControlFactory.getRemoteInstance() : Account_ControlFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        evi.getSelector().add("id");
        evi.getSelector().add("dc");
        evi.getSelector().add("currencyID");
        evi.getSelector().add("isQty");
        evi.getSelector().add("ac");
        evi.getSelector().add("acNotice");
        evi.getSelector().add("bw");
        evi.getSelector().add("control");
        evi.getSelector().add("isChangeCurrency");
        evi.getSelector().add("accountTableID");
        evi.getSelector().add("srcCu");
        evi.getSelector().add("destCu");
        evi.getSelector().add("isDefaultForRefer");
        if (info != null) {
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)info.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("srcCu", (Object)srcCu.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("destCu", (Object)destCu.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Integer(0)));
            Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
            if (acctCtrlCols != null && acctCtrlCols.size() > 0) {
                return acctCtrlCols.get(0);
            }
        }
        return null;
    }

    public static Account_ControlInfo getAcctCtrlInfo(Context ctx, AccountTableInfo info, CompanyOrgUnitInfo srcCompany, CompanyOrgUnitInfo destCompany) throws BOSException {
        IAccount_Control acctCtrl = ctx == null ? Account_ControlFactory.getRemoteInstance() : Account_ControlFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        evi.getSelector().add("id");
        evi.getSelector().add("dc");
        evi.getSelector().add("currencyID");
        evi.getSelector().add("isQty");
        evi.getSelector().add("ac");
        evi.getSelector().add("acNotice");
        evi.getSelector().add("bw");
        evi.getSelector().add("control");
        evi.getSelector().add("isChangeCurrency");
        evi.getSelector().add("accountTableID");
        evi.getSelector().add("srcCu");
        evi.getSelector().add("destCu");
        evi.getSelector().add("srcCompany");
        evi.getSelector().add("destCompany");
        evi.getSelector().add("isDefaultForRefer");
        if (info != null) {
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)info.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("srcCompany", (Object)srcCompany.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)destCompany.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Integer(0)));
            Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
            if (acctCtrlCols != null && acctCtrlCols.size() > 0) {
                return acctCtrlCols.get(0);
            }
        }
        return null;
    }

    public static Map getAcctCtrlInfoMap(Context ctx, AccountTableInfo info, CtrlUnitInfo srcCu, CtrlUnitCollection children) throws BOSException {
        IAccount_Control acctCtrl = ctx == null ? Account_ControlFactory.getRemoteInstance() : Account_ControlFactory.getLocalInstance(ctx);
        HashMap<String, Account_ControlInfo> acctCtrlInfoMap = new HashMap<String, Account_ControlInfo>();
        StringBuffer destCuId = new StringBuffer();
        for (int i = 0; i < children.size(); ++i) {
            String destCu = children.get(i).getId().toString();
            if (i > 0) {
                destCuId.append(",");
            }
            destCuId.append(destCu);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        evi.getSelector().add("id");
        evi.getSelector().add("dc");
        evi.getSelector().add("currencyID");
        evi.getSelector().add("isQty");
        evi.getSelector().add("ac");
        evi.getSelector().add("acNotice");
        evi.getSelector().add("bw");
        evi.getSelector().add("control");
        evi.getSelector().add("isChangeCurrency");
        evi.getSelector().add("accountTableID");
        evi.getSelector().add("srcCu");
        evi.getSelector().add("destCu");
        evi.getSelector().add("isDefaultForRefer");
        if (info != null) {
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)info.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("srcCu", (Object)srcCu.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("destCu", (Object)destCuId.toString(), CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Integer(0)));
            Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
            if (acctCtrlCols != null && acctCtrlCols.size() > 0) {
                for (int i = 0; i < acctCtrlCols.size(); ++i) {
                    Account_ControlInfo account_ControlInfo = acctCtrlCols.get(i);
                    if (acctCtrlInfoMap.containsKey(account_ControlInfo.getDestCu().getId().toString())) continue;
                    acctCtrlInfoMap.put(account_ControlInfo.getDestCu().getId().toString(), account_ControlInfo);
                }
                return acctCtrlInfoMap;
            }
        }
        return acctCtrlInfoMap;
    }

    public static Map getAcctCtrlInfoMap(Context ctx, AccountTableInfo info, CompanyOrgUnitInfo srcCompany, CompanyOrgUnitCollection children) throws BOSException {
        IAccount_Control acctCtrl = ctx == null ? Account_ControlFactory.getRemoteInstance() : Account_ControlFactory.getLocalInstance(ctx);
        HashMap<String, Account_ControlInfo> acctCtrlInfoMap = new HashMap<String, Account_ControlInfo>();
        StringBuffer destCompanyId = new StringBuffer();
        for (int i = 0; i < children.size(); ++i) {
            String destCompany = children.get(i).getId().toString();
            if (i > 0) {
                destCompanyId.append(",");
            }
            destCompanyId.append(destCompany);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        evi.getSelector().add("id");
        evi.getSelector().add("dc");
        evi.getSelector().add("currencyID");
        evi.getSelector().add("isQty");
        evi.getSelector().add("ac");
        evi.getSelector().add("acNotice");
        evi.getSelector().add("bw");
        evi.getSelector().add("control");
        evi.getSelector().add("isChangeCurrency");
        evi.getSelector().add("accountTableID");
        evi.getSelector().add("srcCompany");
        evi.getSelector().add("destCompany");
        evi.getSelector().add("isDefaultForRefer");
        if (info != null) {
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)info.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("srcCompany", (Object)srcCompany.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)destCompanyId.toString(), CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Integer(0)));
            Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
            if (acctCtrlCols != null && acctCtrlCols.size() > 0) {
                for (int i = 0; i < acctCtrlCols.size(); ++i) {
                    Account_ControlInfo account_ControlInfo = acctCtrlCols.get(i);
                    if (acctCtrlInfoMap.containsKey(account_ControlInfo.getDestCompany().getId().toString())) continue;
                    acctCtrlInfoMap.put(account_ControlInfo.getDestCompany().getId().toString(), account_ControlInfo);
                }
                return acctCtrlInfoMap;
            }
        }
        return acctCtrlInfoMap;
    }

    public static boolean checkAccountCanAdd(Context ctx, AccountViewInfo acctInfo) throws BOSException, EASBizException {
        boolean checkinfo = false;
        if (acctInfo != null && acctInfo.getUpper() == null) {
            if (acctInfo.getParent() == null) {
                if (acctInfo.getAccountTableID() != null && acctInfo.getCompanyID() != null) {
                    boolean isSelfAcctTbl = AccountTools.checkAccountTableIsSelfConstructed(ctx, acctInfo.getAccountTableID(), acctInfo.getCompanyID());
                    if (!isSelfAcctTbl) {
                        checkinfo = false;
                    } else {
                        return true;
                    }
                }
                if (!checkinfo) {
                    throw new AccountException(AccountException.CANNOTADDBYSUPERIOR);
                }
                return checkinfo;
            }
            String parentAcctId = acctInfo.getParent().getId().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("isUpperAllowCA");
            sic.add("gLevel");
            sic.add("level");
            IAccountView acct = ctx == null ? AccountViewFactory.getRemoteInstance() : AccountViewFactory.getLocalInstance(ctx);
            AccountViewInfo parent = acct.getAccountViewInfo((IObjectPK)new ObjectUuidPK(parentAcctId));
            if (parent != null) {
                if (!parent.isIsUpperAllowCA()) {
                    throw new AccountException(AccountException.CANNOTADDCHILDERS);
                }
                if (!AccountTools.checkAccountTableIsSelfConstructed(ctx, acctInfo.getAccountTableID(), acctInfo.getCompanyID())) {
                    if (!parent.isIsAllowCA()) {
                        throw new AccountException(AccountException.CANNOTADDCHILDERS);
                    }
                    if (parent.getGLevel() >= acctInfo.getLevel()) {
                        throw new AccountException(AccountException.ACCOUNTCANNOTADD);
                    }
                    if (acctInfo.getLevel() <= parent.getControlLevel()) {
                        throw new AccountException(AccountException.CANNOTADDUPPERLEVER);
                    }
                }
            }
        }
        return true;
    }

    public static CtrlUnitCollection getChildCu(Context ctx, CtrlUnitInfo currentCu) throws BOSException {
        ICtrlUnit cu = ctx != null ? CtrlUnitFactory.getLocalInstance((Context)ctx) : CtrlUnitFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)currentCu.getId().toString()));
        SorterItemInfo dsf = new SorterItemInfo("number");
        dsf.setSortType(SortType.ASCEND);
        evi.getSorter().add(dsf);
        evi.setFilter(filter);
        return cu.getCtrlUnitCollection(evi);
    }

    public static CompanyOrgUnitCollection getChildCompany(Context ctx, CompanyOrgUnitInfo currentCompany, boolean isDisplayAll, String filter) throws BOSException {
        return AccountTools.getChildCompany(ctx, currentCompany, isDisplayAll, filter, false);
    }

    public static CompanyOrgUnitCollection getChildCompany(Context ctx, CompanyOrgUnitInfo currentCompany, boolean isDisplayAll, String filter, boolean isDisplaySealUp) throws BOSException {
        IAccountFacade iAcctFacade = ctx == null ? AccountFacadeFactory.getRemoteInstance() : AccountFacadeFactory.getLocalInstance(ctx);
        return iAcctFacade.getChildCompanyWithSealUp(currentCompany, isDisplayAll, filter, isDisplaySealUp);
    }

    public static CompanyOrgUnitCollection getTopCompany(Context ctx) throws BOSException {
        ICompanyOrgUnit companyOrgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", null));
        SorterItemInfo dsf = new SorterItemInfo("number");
        dsf.setSortType(SortType.ASCEND);
        evi.getSorter().add(dsf);
        evi.setFilter(filter);
        return companyOrgUnit.getCompanyOrgUnitCollection(evi);
    }

    public static CompanyOrgUnitCollection getNotCUChildCompany(Context ctx, CompanyOrgUnitInfo currentCompany) throws BOSException {
        ICompanyOrgUnit companyOrgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)currentCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isCU", (Object)false));
        SorterItemInfo dsf = new SorterItemInfo("number");
        dsf.setSortType(SortType.ASCEND);
        evi.getSorter().add(dsf);
        evi.setFilter(filter);
        return companyOrgUnit.getCompanyOrgUnitCollection(evi);
    }

    public static boolean checkAccountTableCanAssign(Context ctx, CtrlUnitInfo child) throws EASBizException, BOSException {
        AccountTableInfo acctTblInfo;
        ICUBDControl cuBdCtrl = ctx == null ? CUBDControlFactory.getRemoteInstance() : CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo cuBdCtrlInfo = cuBdCtrl.getBDCtrlInfo((acctTblInfo = new AccountTableInfo()).getBOSType().toString(), child.getId().toString());
        return cuBdCtrlInfo != null && cuBdCtrlInfo.getDispatchPattern().equals((Object)CUBDDispatchPattern.DISPATCH);
    }

    public static boolean checkAccountTableCanAssign(Context ctx, CompanyOrgUnitInfo child) throws EASBizException, BOSException {
        AccountTableInfo acctTblInfo;
        ICUBDControl cuBdCtrl = ctx == null ? CUBDControlFactory.getRemoteInstance() : CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo cuBdCtrlInfo = cuBdCtrl.getBDCtrlInfo((acctTblInfo = new AccountTableInfo()).getBOSType().toString(), child.getCU().getId().toString());
        return cuBdCtrlInfo != null && cuBdCtrlInfo.getDispatchPattern().equals((Object)CUBDDispatchPattern.DISPATCH);
    }

    public static Map checkAccountTableCanAssignMap(Context ctx, CtrlUnitCollection children) throws BOSException {
        ICUBDControl cuBdCtrl = ctx == null ? CUBDControlFactory.getRemoteInstance() : CUBDControlFactory.getLocalInstance((Context)ctx);
        HashMap<String, Boolean> acctCtrlInfoMap = new HashMap<String, Boolean>();
        StringBuffer destCuId = new StringBuffer();
        for (int i = 0; i < children.size(); ++i) {
            String destCu = children.get(i).getId().toString();
            if (i > 0) {
                destCuId.append(",");
            }
            destCuId.append(destCu);
        }
        AccountTableInfo acctTblInfo = new AccountTableInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("BDBOSType", (Object)acctTblInfo.getBOSType().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)destCuId.toString(), CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        CUBDControlCollection col = cuBdCtrl.getCUBDControlCollection(viewInfo);
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                CUBDControlInfo cuBdCtrlInfo = col.get(i);
                String destCu = cuBdCtrlInfo.getCU().getId().toString();
                if (cuBdCtrlInfo.getDispatchPattern().equals((Object)CUBDDispatchPattern.DISPATCH)) {
                    acctCtrlInfoMap.put(destCu, Boolean.TRUE);
                    continue;
                }
                acctCtrlInfoMap.put(destCu, Boolean.FALSE);
            }
        } else {
            for (int i = 0; i < children.size(); ++i) {
                String destCu = children.get(i).getId().toString();
                acctCtrlInfoMap.put(destCu, Boolean.FALSE);
            }
        }
        return acctCtrlInfoMap;
    }

    public static Map checkAccountTableCanAssignMap(Context ctx, CompanyOrgUnitCollection children) throws BOSException {
        ICUBDControl cuBdCtrl = ctx == null ? CUBDControlFactory.getRemoteInstance() : CUBDControlFactory.getLocalInstance((Context)ctx);
        HashMap<String, Boolean> acctCtrlInfoMap = new HashMap<String, Boolean>();
        StringBuffer destCuId = new StringBuffer();
        for (int i = 0; i < children.size(); ++i) {
            String destCu = children.get(i).getCU().getId().toString();
            if (i > 0) {
                destCuId.append(",");
            }
            destCuId.append(destCu);
        }
        AccountTableInfo acctTblInfo = new AccountTableInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("BDBOSType", (Object)acctTblInfo.getBOSType().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)destCuId.toString(), CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        CUBDControlCollection col = cuBdCtrl.getCUBDControlCollection(viewInfo);
        CompanyOrgUnitInfo currentComany = null;
        String destCompany = null;
        block1: for (int i = 0; i < children.size(); ++i) {
            currentComany = children.get(i);
            destCompany = currentComany.getId().toString();
            acctCtrlInfoMap.put(destCompany, Boolean.FALSE);
            if (col == null || col.size() <= 0) continue;
            CUBDControlInfo cuBdCtrlInfo = null;
            for (int j = 0; j < col.size(); ++j) {
                cuBdCtrlInfo = col.get(j);
                if (!currentComany.getCU().getId().equals((Object)cuBdCtrlInfo.getCU().getId())) continue;
                if (!cuBdCtrlInfo.getDispatchPattern().equals((Object)CUBDDispatchPattern.DISPATCH)) continue block1;
                acctCtrlInfoMap.put(destCompany, Boolean.TRUE);
                continue block1;
            }
        }
        return acctCtrlInfoMap;
    }

    public static Account_ControlInfo getAcctCtrlInfo(Context ctx, AccountTableInfo info, CtrlUnitInfo destCu, boolean isDefaultForRefer) throws BOSException {
        IAccount_Control acctCtrl = ctx == null ? Account_ControlFactory.getRemoteInstance() : Account_ControlFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        evi.getSelector().add("id");
        evi.getSelector().add("dc");
        evi.getSelector().add("currencyID");
        evi.getSelector().add("isQty");
        evi.getSelector().add("ac");
        evi.getSelector().add("acNotice");
        evi.getSelector().add("bw");
        evi.getSelector().add("control");
        evi.getSelector().add("isChangeCurrency");
        evi.getSelector().add("accountTableID");
        evi.getSelector().add("srcCu");
        evi.getSelector().add("destCu");
        evi.getSelector().add("isDefaultForRefer");
        if (info != null) {
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)info.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("destCu", (Object)destCu.getId().toString()));
            if (isDefaultForRefer) {
                filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Integer(1)));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Integer(0)));
            }
            Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
            if (acctCtrlCols != null && acctCtrlCols.size() > 0) {
                return acctCtrlCols.get(0);
            }
        }
        return null;
    }

    public static Account_ControlInfo getAcctCtrlInfo(Context ctx, AccountTableInfo info, CompanyOrgUnitInfo destCompany, boolean isDefaultForRefer) throws BOSException {
        IAccount_Control acctCtrl = ctx == null ? Account_ControlFactory.getRemoteInstance() : Account_ControlFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        evi.getSelector().add("id");
        evi.getSelector().add("dc");
        evi.getSelector().add("currencyID");
        evi.getSelector().add("isQty");
        evi.getSelector().add("ac");
        evi.getSelector().add("acNotice");
        evi.getSelector().add("bw");
        evi.getSelector().add("control");
        evi.getSelector().add("isChangeCurrency");
        evi.getSelector().add("accountTableID");
        evi.getSelector().add("accountTableID.name");
        evi.getSelector().add("srcCompany");
        evi.getSelector().add("destCompany");
        evi.getSelector().add("isDefaultForRefer");
        if (info != null) {
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)info.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)destCompany.getId().toString()));
            if (isDefaultForRefer) {
                filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Integer(1)));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Integer(0)));
            }
            Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
            if (acctCtrlCols != null && acctCtrlCols.size() > 0) {
                return acctCtrlCols.get(0);
            }
        }
        return null;
    }

    public static synchronized Account_ControlCollection getAcctCtrlCollection(Context ctx, AccountTableInfo info, CompanyOrgUnitInfo destCompany) throws BOSException {
        IAccount_Control acctCtrl = ctx == null ? Account_ControlFactory.getRemoteInstance() : Account_ControlFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        evi.getSelector().add("id");
        evi.getSelector().add("dc");
        evi.getSelector().add("currencyID");
        evi.getSelector().add("isQty");
        evi.getSelector().add("ac");
        evi.getSelector().add("acNotice");
        evi.getSelector().add("bw");
        evi.getSelector().add("control");
        evi.getSelector().add("isChangeCurrency");
        evi.getSelector().add("accountTableID");
        evi.getSelector().add("accountTableID.name");
        evi.getSelector().add("srcCompany");
        evi.getSelector().add("destCompany");
        evi.getSelector().add("isDefaultForRefer");
        if (info != null) {
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)info.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)destCompany.getId().toString()));
            Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
            if (acctCtrlCols != null && acctCtrlCols.size() > 0) {
                return acctCtrlCols;
            }
        }
        return null;
    }

    public static boolean checkAccountCanDelete(Context ctx, CtrlUnitInfo currentCtrlUnit) {
        CtrlUnitInfo child = currentCtrlUnit;
        boolean checkinfo = false;
        AccountViewInfo acctInfo = new AccountViewInfo();
        try {
            ICUBDControl cuBdCtrl = ctx == null ? CUBDControlFactory.getRemoteInstance() : CUBDControlFactory.getLocalInstance((Context)ctx);
            CUBDControlInfo cuBdCtrlInfo = cuBdCtrl.getBDCtrlInfo(acctInfo.getBOSType().toString(), child.getId().toString());
            checkinfo = cuBdCtrlInfo.isIsSubordinateDeletable();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return checkinfo;
    }

    public static String getCuIdFromCompanyPK(Context ctx, IObjectPK companyPK) throws EASBizException, BOSException {
        String cuId = null;
        if (companyPK != null) {
            ICompanyOrgUnit company = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("CU");
            CompanyOrgUnitInfo comInfo = company.getCompanyOrgUnitInfo(companyPK, sic);
            if (comInfo != null) {
                return comInfo.getCU().getId().toString();
            }
        }
        return cuId;
    }

    public static AccountTableCollection getAllAccountTableByCU(Context ctx, CtrlUnitInfo currentCtrlUnit) throws BOSException {
        AccountTableCollection acctTbls = new AccountTableCollection();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("destCU", (Object)currentCtrlUnit.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Boolean(true)));
        evi.getSelector().add("accountTableID.id");
        evi.getSelector().add("accountTableID.number");
        evi.getSelector().add("accountTableID.name");
        IAccount_Control acctCtrl = ctx == null ? Account_ControlFactory.getRemoteInstance() : Account_ControlFactory.getLocalInstance(ctx);
        Account_ControlCollection acctCtrls = acctCtrl.getAccount_ControlCollection(evi);
        if (acctCtrls != null) {
            int count = acctCtrls.size();
            for (int i = 0; i < count; ++i) {
                acctTbls.add(acctCtrls.get(i).getAccountTableID());
            }
        }
        return acctTbls;
    }

    public static AccountTableCollection getAllAccountTableByCompany(Context ctx, CompanyOrgUnitInfo currentCompany) throws BOSException {
        AccountTableCollection acctTbls = new AccountTableCollection();
        ArrayList<String> tableIdList = new ArrayList<String>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)currentCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Boolean(true)));
        evi.getSelector().add("accountTableID.id");
        evi.getSelector().add("accountTableID.number");
        evi.getSelector().add("accountTableID.name");
        IAccount_Control acctCtrl = ctx == null ? Account_ControlFactory.getRemoteInstance() : Account_ControlFactory.getLocalInstance(ctx);
        Account_ControlCollection acctCtrls = acctCtrl.getAccount_ControlCollection(evi);
        if (acctCtrls != null) {
            int count = acctCtrls.size();
            for (int i = 0; i < count; ++i) {
                Account_ControlInfo acctCtrlInfo = acctCtrls.get(i);
                tableIdList.add(acctCtrlInfo.getAccountTableID().getId().toString());
            }
        }
        evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("userLevel.*"));
        IAccountTable iAccountTable = null;
        iAccountTable = ctx == null ? AccountTableFactory.getRemoteInstance() : AccountTableFactory.getLocalInstance(ctx);
        AccountTableCollection tableInfos = iAccountTable.getAccountTableCollection(evi);
        Iterator ter = tableInfos.iterator();
        while (ter.hasNext()) {
            AccountTableInfo tableInfo = (AccountTableInfo)ter.next();
            if (!tableIdList.contains(tableInfo.getId().toString())) continue;
            acctTbls.add(tableInfo);
        }
        return acctTbls;
    }

    public static AccountViewCollection getallAccountViewByCuAndTable(Context ctx, CtrlUnitInfo currentCu, AccountTableInfo acctTbl, FilterInfo userFilter, SelectorItemCollection selectors) throws BOSException {
        IAccountView acct = ctx != null ? AccountViewFactory.getLocalInstance(ctx) : AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)currentCu.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctTbl.getId().toString()));
        if (userFilter != null) {
            filter.mergeFilter(userFilter, "AND");
        }
        if (selectors != null) {
            int count = selectors.size();
            for (int i = 0; i < count; ++i) {
                evi.getSelector().add(selectors.get(i));
            }
        }
        evi.getSorter().add(new SorterItemInfo("number"));
        return acct.getAccountViewCollection(evi);
    }

    public static AccountViewCollection getallAccountViewByCompanyAndTable(Context ctx, CompanyOrgUnitInfo currentCompany, AccountTableInfo acctTbl, FilterInfo userFilter, SelectorItemCollection selectors) throws BOSException {
        IAccountView acct = ctx != null ? AccountViewFactory.getLocalInstance(ctx) : AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)currentCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctTbl.getId().toString()));
        if (userFilter != null) {
            filter.mergeFilter(userFilter, "AND");
        }
        if (selectors != null) {
            int count = selectors.size();
            for (int i = 0; i < count; ++i) {
                evi.getSelector().add(selectors.get(i));
            }
        }
        evi.getSorter().add(new SorterItemInfo("number"));
        return acct.getAccountViewCollection(evi);
    }

    public static ArrayList getAllUpperAcctIdByCuAndTbl(Context ctx, CtrlUnitInfo currentCu, AccountTableInfo acctTblInfo) throws BOSException {
        ArrayList<AccountViewInfo> upperIdList = new ArrayList<AccountViewInfo>();
        IAccountView acct = ctx == null ? AccountViewFactory.getRemoteInstance() : AccountViewFactory.getLocalInstance(ctx);
        AccountViewCollection acctCols = (AccountViewCollection)acct.getAllUpperAcctIdByCuAndTbl(currentCu, acctTblInfo);
        if (acctCols != null) {
            int count = acctCols.size();
            for (int i = 0; i < count; ++i) {
                if (acctCols.get(i) == null) continue;
                upperIdList.add(acctCols.get(i));
            }
        }
        return upperIdList;
    }

    public static ArrayList getAllUpperAcctIdByCompanyAndTbl(Context ctx, CompanyOrgUnitInfo currentCompany, AccountTableInfo acctTblInfo) throws BOSException {
        ArrayList<AccountViewInfo> upperIdList = new ArrayList<AccountViewInfo>();
        IAccountView acct = ctx == null ? AccountViewFactory.getRemoteInstance() : AccountViewFactory.getLocalInstance(ctx);
        AccountViewCollection acctCols = (AccountViewCollection)acct.getAllUpperAcctIdByCompanyAndTbl(currentCompany, acctTblInfo);
        if (acctCols != null) {
            int count = acctCols.size();
            for (int i = 0; i < count; ++i) {
                if (acctCols.get(i) == null) continue;
                upperIdList.add(acctCols.get(i));
            }
        }
        return upperIdList;
    }

    public static ArrayList getNotFreezeUpperIdByCompanyAndTbl(Context ctx, CompanyOrgUnitInfo currentCompany, AccountTableInfo acctTblInfo) throws BOSException {
        ArrayList<AccountViewInfo> upperIdList = new ArrayList<AccountViewInfo>();
        IAccountView acct = ctx == null ? AccountViewFactory.getRemoteInstance() : AccountViewFactory.getLocalInstance(ctx);
        AccountViewCollection acctCols = (AccountViewCollection)acct.getAllUpperAcctIdByCompanyAndTbl(currentCompany, acctTblInfo);
        if (acctCols != null) {
            int count = acctCols.size();
            for (int i = 0; i < count; ++i) {
                AccountViewInfo acctInfo = acctCols.get(i);
                if (acctInfo == null || acctInfo.isIsCFreeze()) continue;
                upperIdList.add(acctCols.get(i));
            }
        }
        return upperIdList;
    }

    public static Map getAllUpperAcctIdByCompanyAndTbl(Context ctx, List uncatchCompanyIDList, AccountTableInfo acctTblInfo) throws BOSException {
        Map upperIdListMap = new HashMap();
        IAccountView acct = ctx == null ? AccountViewFactory.getRemoteInstance() : AccountViewFactory.getLocalInstance(ctx);
        upperIdListMap = acct.batchGetAllUpperAcctIdByCompanysAndTbl(uncatchCompanyIDList, acctTblInfo.getId().toString());
        return upperIdListMap;
    }

    public static ArrayList getAllFIOrgByCU(Context ctx, CtrlUnitInfo cu) throws BOSException {
        ArrayList<String> fiOrgIdList = new ArrayList<String>();
        ICompanyOrgUnit fi = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cu.getId().toString()));
        evi.getSelector().add("id");
        CompanyOrgUnitCollection fiCols = fi.getCompanyOrgUnitCollection(evi);
        if (fiCols != null) {
            int count = fiCols.size();
            for (int i = 0; i < count; ++i) {
                fiOrgIdList.add(fiCols.get(i).getId().toString());
            }
        }
        return fiOrgIdList;
    }

    public static ArrayList getAllFIOrgByCompany(Context ctx, CompanyOrgUnitInfo company) throws BOSException {
        ArrayList<String> fiOrgIdList = new ArrayList<String>();
        ICompanyOrgUnit fi = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(company.getLongNumber() + "%"), CompareType.LIKE));
        evi.getSelector().add("id");
        CompanyOrgUnitCollection fiCols = fi.getCompanyOrgUnitCollection(evi);
        if (fiCols != null) {
            int count = fiCols.size();
            for (int i = 0; i < count; ++i) {
                fiOrgIdList.add(fiCols.get(i).getId().toString());
            }
        }
        return fiOrgIdList;
    }

    public static AccountTableCollection getAccountTableCollection() throws BOSException {
        ArrayList<String> tableIdList = new ArrayList<String>();
        IAccount_Control acctCtrl = Account_ControlFactory.getRemoteInstance();
        EntityViewInfo eviForCtrl = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
        eviForCtrl.setFilter(filter);
        eviForCtrl.getSelector().add("accountTableID.*");
        Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(eviForCtrl);
        if (acctCtrlCols != null) {
            int count = acctCtrlCols.size();
            for (int i = 0; i < count; ++i) {
                Account_ControlInfo acctCtrlInfo = acctCtrlCols.get(i);
                tableIdList.add(acctCtrlInfo.getAccountTableID().getId().toString());
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        SorterItemCollection sorters = evi.getSorter();
        sorters.add(new SorterItemInfo("number"));
        IAccountTable iAccountTable = AccountTableFactory.getRemoteInstance();
        AccountTableCollection tableInfos = iAccountTable.getAccountTableCollection(evi);
        AccountTableCollection tableInfosNew = new AccountTableCollection();
        Iterator ter = tableInfos.iterator();
        while (ter.hasNext()) {
            AccountTableInfo tableInfo = (AccountTableInfo)ter.next();
            if (!tableIdList.contains(tableInfo.getId().toString())) continue;
            tableInfosNew.add(tableInfo);
        }
        return tableInfosNew;
    }

    public static String getCurrentAcctTable(String companyID, String curAcctTableID, int periodYear, int periodNumber) throws BOSException, EASBizException {
        return AccountTools.getCurrentAcctTable(null, companyID, curAcctTableID, periodYear, periodNumber);
    }

    public static String getCurrentAcctTable(Context ctx, String companyID, String curAcctTableID, int periodYear, int periodNumber) throws BOSException, EASBizException {
        AccountRefContrastInfo info = (ctx == null ? AccountRefContrastFactory.getRemoteInstance() : AccountRefContrastFactory.getLocalInstance(ctx)).getLastAcctInfo(companyID, curAcctTableID, periodYear, periodNumber);
        return info == null ? null : info.getEnabledAcctTable().getId().toString();
    }

    public static void checkAcctTable(String companyID, AccountTableInfo acctTableInfo) throws BOSException, EASBizException {
        if (acctTableInfo == null || acctTableInfo.getId() == null || companyID == null || companyID.length() == 0) {
            return;
        }
        boolean result = AccountRefContrastFactory.getRemoteInstance().exists("where refType=1 and disabledAcctTable.id='" + acctTableInfo.getId().toString() + "' and company.id='" + companyID + "' and isEnabled = 1");
        if (result) {
            throw new AcctRefContrastException(AcctRefContrastException.ENABLEADISABLEACCTTABLE, new Object[]{acctTableInfo.getName()});
        }
    }

    public static void checkAcctTable(String companyID, String acctTableID) throws BOSException, EASBizException {
        if (companyID == null || companyID.length() == 0 || acctTableID == null || acctTableID.length() == 0) {
            return;
        }
        IAccount_Control acctCtrl = Account_ControlFactory.getRemoteInstance();
        if (acctCtrl.exists("select id where accountTableID='" + acctTableID + "' and destCompany='" + companyID + "' and srcCompany is not null")) {
            throw new AccountException(AccountException.MODIFYTYPEINTABLENOTSELF);
        }
    }

    public static void isHasBalance(Context ctx, BOSUuid objID, AccountViewInfo acctInfo) throws EASBizException, BOSException {
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)"9DA99827", IBizCheckBalance.class);
        }
        catch (EASDBException e) {
            throw new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e);
        }
        if (checkers == null || checkers.length == 0) {
            return;
        }
        ArrayList<BOSUuid> ids = new ArrayList<BOSUuid>();
        ids.add(objID);
        String orgPK = acctInfo.getCompanyID().getId().toString();
        String checkerName = "";
        try {
            for (int i = 0; i < checkers.length; ++i) {
                checkerName = checkers[i];
                ((IBatchBizCheckBalance)Class.forName(checkerName).newInstance()).checkHasBalance(ctx, ids, orgPK);
            }
        }
        catch (EASBizException e) {
            throw new AccountException(AccountException.DISABLEACCT_ERR, e, new Object[]{AcctRefContrastHelper.getSubSystemName(ctx, checkerName) + " " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())});
        }
        catch (Exception e) {
            throw new AccountException(AccountException.DISABLEACCT_ERR, e, new Object[]{checkerName + " : " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())});
        }
    }

    public static void isCUMoved(Context ctx, BOSUuid destCuID) throws EASBizException, BOSException {
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)"3525AA94", IBizHasDeal.class);
        }
        catch (EASDBException e) {
            throw new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e);
        }
        if (checkers == null || checkers.length == 0) {
            return;
        }
        String checkerName = "";
        try {
            for (int i = 0; i < checkers.length; ++i) {
                checkerName = checkers[i];
                ((IBizHasDeal)Class.forName(checkerName).newInstance()).checkHasDeal(ctx, destCuID);
            }
        }
        catch (EASBizException e) {
            throw new AccountException(AccountException.DISABLEACCT_ERR, e, new Object[]{AcctRefContrastHelper.getSubSystemName(ctx, checkerName) + " " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())});
        }
        catch (Exception e) {
            throw new AccountException(AccountException.DISABLEACCT_ERR, e, new Object[]{checkerName + " : " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())});
        }
    }

    public static void isCompanyMoved(Context ctx, BOSUuid destCompanyID) throws EASBizException, BOSException {
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)"3525AA94", IBizHasDeal.class);
        }
        catch (EASDBException e) {
            throw new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e);
        }
        if (checkers == null || checkers.length == 0) {
            return;
        }
        String checkerName = "";
        try {
            for (int i = 0; i < checkers.length; ++i) {
                checkerName = checkers[i];
                ((IBizHasDeal)Class.forName(checkerName).newInstance()).checkHasDeal(ctx, destCompanyID);
            }
        }
        catch (EASBizException e) {
            throw new AccountException(AccountException.DISABLEACCT_ERR, e, new Object[]{AcctRefContrastHelper.getSubSystemName(ctx, checkerName) + " " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())});
        }
        catch (Exception e) {
            throw new AccountException(AccountException.DISABLEACCT_ERR, e, new Object[]{checkerName + " : " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())});
        }
    }

    public static EntityViewInfo getAsstAccountReferenceFilter(CompanyOrgUnitInfo companyInfo) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String companyLongNumber = companyInfo.getLongNumber();
        String[] companyNumber = companyLongNumber.split("!");
        StringBuffer compareLongNumber = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < companyNumber.length; ++i) {
            if (i > 0) {
                sb.append("!");
                compareLongNumber.append(",");
            }
            sb.append(companyNumber[i]);
            compareLongNumber.append(sb.toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("company.longNumber", (Object)compareLongNumber.toString(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("assignCompany.longNumber", (Object)compareLongNumber.toString(), CompareType.INCLUDE));
        filter.setMaskString("#0 or #1");
        evi.setFilter(filter);
        return evi;
    }

    public static EntityViewInfo getAsstAccountReferenceFilter(CtrlUnitInfo cuInfo) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String cuLongNumber = cuInfo.getLongNumber();
        String[] cuNumber = cuLongNumber.split("!");
        StringBuffer compareLongNumber = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cuNumber.length; ++i) {
            if (i > 0) {
                sb.append("!");
                compareLongNumber.append(",");
            }
            sb.append(cuNumber[i]);
            compareLongNumber.append(sb.toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.longNumber", (Object)compareLongNumber.toString(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("assignCU.longNumber", (Object)compareLongNumber.toString(), CompareType.INCLUDE));
        filter.setMaskString("#0 or #1");
        evi.setFilter(filter);
        return evi;
    }

    public static BizCheckResult hasDeal(Context ctx, BOSUuid objID) throws BizHasDealException, EASBizException {
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)objID.getType().toString(), IBizHasDeal.class);
        }
        catch (EASDBException e) {
            throw new BizHasDealException(BizHasDealException.SQL_ERR, (Throwable)e);
        }
        if (checkers == null || checkers.length == 0) {
            return BizCheckResult.NOTFOUND;
        }
        for (int i = 0; i < checkers.length; ++i) {
            AccountCheckResult checkResult = AccountCheckResult.NOTFOUND;
            String checkerName = "";
            try {
                checkerName = checkers[i];
                Class<?> checkerClass = Class.forName(checkers[i]);
                IBizHasDeal checker = (IBizHasDeal)checkerClass.newInstance();
                if (checker != null) {
                    checkResult = checker.checkHasDeal(ctx, objID);
                }
            }
            catch (BizHasDealException e) {
                throw new AccountException(AccountException.ACCOUNTBIZ, e, new Object[]{AcctRefContrastHelper.getSubSystemName(ctx, checkerName) + " " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())});
            }
            catch (Exception e) {
                throw new BizHasDealException(BizHasDealException.CHECK_ERROR, (Throwable)e);
            }
            if (!checkResult.isFound()) continue;
            AccountCheckResult AccountCheckResult2 = new AccountCheckResult(checkResult, checkerName);
            return AccountCheckResult2;
        }
        return BizCheckResult.NOTFOUND;
    }

    public static BizCheckResult hasDeal(Context ctx, AccountViewCollection accountViewCollection) throws BizHasDealException, EASBizException {
        if (accountViewCollection == null || accountViewCollection.size() == 0) {
            return BizCheckResult.NOTFOUND;
        }
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)accountViewCollection.get(0).getId().getType().toString(), IBizHasDeal.class);
        }
        catch (EASDBException e) {
            throw new BizHasDealException(BizHasDealException.SQL_ERR, (Throwable)e);
        }
        if (checkers == null || checkers.length == 0) {
            return BizCheckResult.NOTFOUND;
        }
        ArrayList<String> idList = new ArrayList<String>();
        int count = accountViewCollection.size();
        for (int j = 0; j < count; ++j) {
            BOSUuid objID = accountViewCollection.get(j).getId();
            idList.add(objID.toString());
        }
        for (int i = 0; i < checkers.length; ++i) {
            AccountCheckResult checkResult = AccountCheckResult.NOTFOUND;
            String checkerName = "";
            try {
                checkerName = checkers[i];
                Class<?> checkerClass = Class.forName(checkers[i]);
                Object checker = checkerClass.newInstance();
                if (checker != null && checker instanceof IBatchBizHasDeal) {
                    checkResult = ((IBatchBizHasDeal)checker).checkHasDeal(ctx, idList, null);
                    if (!checkResult.isFound()) continue;
                    AccountCheckResult accountCheckResult = new AccountCheckResult(checkResult, checkerName);
                    return accountCheckResult;
                }
                if (checker == null || !(checker instanceof IBizHasDeal)) continue;
                int count2 = accountViewCollection.size();
                for (int j = 0; j < count2; ++j) {
                    BOSUuid objID = accountViewCollection.get(j).getId();
                    checkResult = ((IBizHasDeal)checker).checkHasDeal(ctx, objID);
                    if (!checkResult.isFound()) continue;
                    AccountCheckResult accountCheckResult = new AccountCheckResult(checkResult, checkerName);
                    return accountCheckResult;
                }
                continue;
            }
            catch (BizHasDealException e) {
                throw new AccountException(AccountException.ACCOUNTBIZ, e, new Object[]{AcctRefContrastHelper.getSubSystemName(ctx, checkerName) + " " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())});
            }
            catch (Exception e) {
                throw new BizHasDealException(BizHasDealException.CHECK_ERROR, (Throwable)e);
            }
        }
        return BizCheckResult.NOTFOUND;
    }

    public static BizCheckResult isReferenced(Context ctx, AccountViewCollection accountViewCollection) throws BizReferenceException {
        if (accountViewCollection == null || accountViewCollection.size() == 0) {
            return BizCheckResult.NOTFOUND;
        }
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)accountViewCollection.get(0).getId().getType().toString(), IBizReference.class);
        }
        catch (EASDBException e) {
            throw new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e);
        }
        if (checkers == null || checkers.length == 0) {
            return BizCheckResult.NOTFOUND;
        }
        ArrayList<String> idList = new ArrayList<String>();
        int count = accountViewCollection.size();
        for (int j = 0; j < count; ++j) {
            BOSUuid objID = accountViewCollection.get(j).getId();
            idList.add(objID.toString());
        }
        for (int i = 0; i < checkers.length; ++i) {
            BizCheckResult checkResult = BizCheckResult.NOTFOUND;
            try {
                Class<?> checkerClass = Class.forName(checkers[i]);
                Object checker = checkerClass.newInstance();
                if (checker != null && checker instanceof IBatchBizReference) {
                    checkResult = ((IBatchBizReference)checker).checkReferenced(ctx, idList, null);
                    if (!checkResult.isFound()) continue;
                    return checkResult;
                }
                if (checker == null || !(checker instanceof IBizReference)) continue;
                int count2 = accountViewCollection.size();
                for (int j = 0; j < count2; ++j) {
                    BOSUuid objID = accountViewCollection.get(j).getId();
                    checkResult = ((IBizReference)checker).checkReferenced(ctx, objID);
                    if (!checkResult.isFound()) continue;
                    return checkResult;
                }
                continue;
            }
            catch (BizReferenceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BizReferenceException(BizReferenceException.CHECK_ERROR, (Throwable)e);
            }
        }
        return BizCheckResult.NOTFOUND;
    }

    public static boolean getDefaultGLParam(Context ctx, String companyID, String key) throws BOSException, EASBizException {
        HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
        ObjectUuidPK comPK = null;
        if (companyID != null) {
            comPK = new ObjectUuidPK(companyID);
        }
        hmParamIn.put(key, comPK);
        IParamControl pc = ctx != null ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        if (hmAllParam.get(key) != null) {
            return Boolean.valueOf(hmAllParam.get(key).toString());
        }
        return true;
    }

    public static void checkCompanyAccountTable(Context ctx, CompanyOrgUnitInfo curCompany) throws BOSException, EASBizException {
        if (curCompany == null) {
            throw new RuntimeException("Company can not be null.");
        }
        if (curCompany.getAccountTable() == null) {
            throw new AccountException(AccountException.CURRENTCOMPANYHASNOSTARTACCOUNTTABLE);
        }
    }

    public static boolean checkisCompanyCurrentAccountTable(Context ctx, CompanyOrgUnitInfo curCompany, AccountTableInfo accountTable) throws BOSException, EASBizException {
        return curCompany.getAccountTable() != null && curCompany.getAccountTable().getId().equals((Object)accountTable.getId());
    }

    public static boolean checkHasEnableAccountTable(Context ctx, CompanyOrgUnitInfo curCompany) throws BOSException, EASBizException {
        return curCompany.getAccountTable() != null && !curCompany.getAccountTable().getId().equals((Object)"");
    }

    public static ArrayList getReferenceEntity(Context ctx) {
        ArrayList<String> referenceEntityList = new ArrayList<String>();
        String accountEntityName = "AccountView";
        String companyEntityName = "CompanyOrgUnit";
        String companyFieldName = "FCompanyID";
        Set filterEntitySet = AccountTools.getFilterEntitySet();
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectCollection entities = loader.getEntityCollection();
        boolean foundAccount = false;
        boolean foundComany = false;
        ArrayList<String> accountFieldList = new ArrayList<String>();
        ArrayList<String> companyFieldList = new ArrayList<String>();
        String referenceTableName = null;
        int ic = entities.size();
        for (int i = 0; i < ic; ++i) {
            EntityObjectInfo entity = entities.get(i);
            if (filterEntitySet.contains(entity.getName()) || entity.getTable() == null) continue;
            referenceTableName = entity.getTable().getName();
            PropertyCollection properties = entity.getPropertiesRuntime();
            foundAccount = false;
            foundComany = false;
            accountFieldList.clear();
            companyFieldList.clear();
            int cj = properties.size();
            for (int j = 0; j < cj; ++j) {
                PropertyInfo prop = properties.get(j);
                if (!(prop instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo linkprop = (LinkPropertyInfo)prop;
                RelationshipInfo relate = linkprop.getRelationship();
                EntityObjectInfo supplierObject = relate.getSupplierObject();
                if (supplierObject != null && supplierObject.getName().equals(accountEntityName)) {
                    foundAccount = true;
                    accountFieldList.add(linkprop.getMappingField().getName());
                }
                if (supplierObject == null || !supplierObject.getName().equals(companyEntityName)) continue;
                foundComany = true;
                companyFieldList.add(linkprop.getMappingField().getName());
            }
            if (!foundAccount || !foundComany) continue;
            Iterator companyIterator = companyFieldList.iterator();
            String currentCompanyFieldName = null;
            if (companyIterator.hasNext()) {
                currentCompanyFieldName = (String)companyIterator.next();
            }
            while (companyIterator.hasNext()) {
                if (!companyFieldName.equalsIgnoreCase((String)companyIterator.next())) continue;
                currentCompanyFieldName = companyFieldName;
                break;
            }
            String currentAccountFieldName2 = null;
            for (String currentAccountFieldName2 : accountFieldList) {
                referenceEntityList.add(referenceTableName);
                referenceEntityList.add(currentAccountFieldName2);
                referenceEntityList.add(currentCompanyFieldName);
            }
        }
        return referenceEntityList;
    }

    private static Set getFilterEntitySet() {
        HashSet<String> filterEntitySet = new HashSet<String>();
        filterEntitySet.add("AccountView");
        filterEntitySet.add("JournalSummary");
        filterEntitySet.add("DailyPurchaseExpBill");
        filterEntitySet.add("MarketActivityBill");
        return filterEntitySet;
    }

    public static void selectTableRow(KDTable table, int rowIndex, int colIndex) {
        table.getSelectManager().select(rowIndex, colIndex);
        table.scrollToVisible(rowIndex, colIndex);
    }

    public static AccountTableInfo getAccountTableByCompanyAndPeriod(Context ctx, String companyID, String periodID) throws BOSException, EASBizException {
        AccountTableInfo accountTable = null;
        if (companyID == null || companyID.trim().length() == 0 || periodID == null || periodID.trim().length() == 0) {
            return accountTable;
        }
        IAccountRefContrast accountRefContrast = null;
        accountRefContrast = ctx == null ? AccountRefContrastFactory.getRemoteInstance() : AccountRefContrastFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID));
        filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)new Integer(1)));
        view.setFilter(filter);
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("*");
        coll.add("enabledAcctTable.*");
        coll.add("disabledAcctTable.*");
        view.setSelector(coll);
        AccountRefContrastCollection accountRefContrastCollection = accountRefContrast.getAccountRefContrastCollection(view);
        if (accountRefContrastCollection == null || accountRefContrastCollection.size() == 0) {
            ICompanyOrgUnit companyOrgUnit = null;
            companyOrgUnit = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("accountTable.*");
            CompanyOrgUnitInfo companyOrgUnitInfo = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), selector);
            accountTable = companyOrgUnitInfo.getAccountTable();
            return accountTable;
        }
        AccountRefContrastInfo accountRefContrastInfo = accountRefContrastCollection.get(0);
        PeriodInfo enabledPeriod = accountRefContrastInfo.getEnabledPeriod();
        int compareResult = PeriodUtils.PeriodCompare((String)periodID, (String)enabledPeriod.getId().toString());
        accountTable = compareResult > 0 ? accountRefContrastInfo.getEnabledAcctTable() : accountRefContrastInfo.getDisabledAcctTable();
        return accountTable;
    }

    public static AccountViewCollection getAccountViewCollection(Context ctx, AccountTableInfo accountTableInfo, CompanyOrgUnitInfo company) throws BOSException {
        String acctTableId = accountTableInfo.getId().toString();
        String companyID = company.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)companyID));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctTableId));
        view.setFilter(filter);
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("id");
        view.setSelector(coll);
        IAccountView acct = ctx == null ? AccountViewFactory.getRemoteInstance() : AccountViewFactory.getLocalInstance(ctx);
        AccountViewCollection accountViewCollection = acct.getAccountViewCollection(view);
        return accountViewCollection;
    }

    public static boolean isInEnabledAcctRefContrast(Context ctx, AccountViewInfo acctInfo) throws BOSException, EASBizException {
        try {
            if (acctInfo == null || acctInfo.getId() == null) {
                return false;
            }
            String sql = "SELECT facctrefcontrastid FROM t_bd_acctrefcontrastentry WHERE fnewacctid = ? or FOldAcctID=?";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{acctInfo.getId().toString(), acctInfo.getId().toString()});
            if (rowSet == null || rowSet.size() <= 0) {
                return false;
            }
            while (rowSet.next()) {
                String acctrefId = rowSet.getString("facctrefcontrastid");
                AccountRefContrastInfo acctRefContrastInfo = AccountRefContrastFactory.getLocalInstance(ctx).getAccountRefContrastInfo((IObjectPK)new ObjectUuidPK(acctrefId));
                if (acctRefContrastInfo == null || !acctRefContrastInfo.isIsEnabled()) continue;
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void synInfeCashFlowProperties(Context ctx, AccountViewInfo acctInfo) throws BOSException, EASBizException {
        if (acctInfo == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("id");
        coll.add("companyID.*");
        view.setSelector(coll);
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("upper", (Object)acctInfo.getId().toString()));
        AccountViewCollection accountViewCollection = AccountViewFactory.getLocalInstance(ctx).getAccountViewCollection(view);
        if (accountViewCollection == null || accountViewCollection.size() == 0) {
            return;
        }
        StringBuffer companyIds = new StringBuffer();
        int count = accountViewCollection.size();
        for (int i = 0; i < count; ++i) {
            AccountViewInfo inferiorAcctInfo = accountViewCollection.get(i);
            String companyLongnumber = inferiorAcctInfo.getCompanyID().getLongNumber();
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)companyLongnumber));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(companyLongnumber + "!%"), CompareType.LIKE));
            filter.setMaskString("#0 or #1");
            CompanyOrgUnitCollection companyOrgUnitColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
            for (int j = 0; j < companyOrgUnitColl.size(); ++j) {
                if (j > 0 || !StringUtils.isEmpty((String)companyIds.toString())) {
                    companyIds.append(",");
                }
                companyIds.append("'").append(companyOrgUnitColl.get(j).getId().toString()).append("'");
            }
        }
        String borrowerMainCashFlowItemId = acctInfo.getBorrowerMainCashFlowItem() != null ? "'" + acctInfo.getBorrowerMainCashFlowItem().getId().toString() + "'" : null;
        String borrowerAttCashFlowItemId = acctInfo.getBorrowerAttCashFlowItem() != null ? "'" + acctInfo.getBorrowerAttCashFlowItem().getId().toString() + "'" : null;
        String lenderMainCashFlowItemId = acctInfo.getLenderMainCashFlowItem() != null ? "'" + acctInfo.getLenderMainCashFlowItem().getId().toString() + "'" : null;
        String lenderAttCashFlowItemId = acctInfo.getLenderAttCashFlowItem() != null ? "'" + acctInfo.getLenderAttCashFlowItem().getId().toString() + "'" : null;
        StringBuffer sql = new StringBuffer();
        boolean isNeedComma = false;
        sql.append("UPDATE T_BD_ACCOUNTVIEW SET ");
        if (borrowerMainCashFlowItemId != null && !"".equals(commonUtils.trim((String)borrowerMainCashFlowItemId))) {
            sql.append("FBorrowerMainCashFlowItemID=" + borrowerMainCashFlowItemId);
            isNeedComma = true;
        }
        if (borrowerAttCashFlowItemId != null && !"".equals(commonUtils.trim((String)borrowerAttCashFlowItemId))) {
            if (isNeedComma) {
                sql.append(",FBorrowerAttCashFlowItemID=" + borrowerAttCashFlowItemId);
            } else {
                sql.append("FBorrowerAttCashFlowItemID=" + borrowerAttCashFlowItemId);
                isNeedComma = true;
            }
        }
        if (lenderMainCashFlowItemId != null && !"".equals(commonUtils.trim((String)lenderMainCashFlowItemId))) {
            if (isNeedComma) {
                sql.append(",FLenderMainCashFlowItemID=" + lenderMainCashFlowItemId);
            } else {
                sql.append("FLenderMainCashFlowItemID=" + lenderMainCashFlowItemId);
                isNeedComma = true;
            }
        }
        if (lenderAttCashFlowItemId != null && !"".equals(commonUtils.trim((String)lenderAttCashFlowItemId))) {
            if (isNeedComma) {
                sql.append(",FLenderAttCashFlowItemID=" + lenderAttCashFlowItemId);
            } else {
                sql.append("FLenderAttCashFlowItemID=" + lenderAttCashFlowItemId);
                isNeedComma = true;
            }
        }
        if (isNeedComma) {
            sql.append(" WHERE FLONGNUMBER like '" + acctInfo.getLongNumber() + "%' and FAccountTableID ='" + acctInfo.getAccountTableID().getId().toString() + "' and  FCOMPANYID IN (" + companyIds.toString() + ")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    public static CompanyOrgUnitInfo getCUCompanyOrgUnitInfo(Context ctx, CompanyOrgUnitCollection companyOrgs) {
        CompanyOrgUnitInfo info = null;
        if (companyOrgs.size() == 0) {
            return null;
        }
        int length = companyOrgs.get(0).getLongNumber().split("!").length;
        int j = companyOrgs.size();
        for (int i = 0; i < j; ++i) {
            if (companyOrgs.get(i).getLongNumber().split("!").length > length) continue;
            length = companyOrgs.get(i).getLongNumber().split("!").length;
            info = companyOrgs.get(i);
        }
        String[] longNumber = info.getLongNumber().split("!");
        StringBuffer contrast = new StringBuffer(longNumber[0]);
        int i = 1;
        int l = longNumber.length;
        block4: while (i < l) {
            int c = companyOrgs.size();
            for (int j2 = 0; j2 < c; ++j2) {
                String[] compareNumber = companyOrgs.get(j2).getLongNumber().split("!");
                if (!longNumber[i].equals(compareNumber[i])) break block4;
            }
            contrast.append("!" + longNumber[i++]);
        }
        try {
            String oql = "select *,accountTable.*,accountPeriodType.* where longnumber = '" + contrast.toString() + "'";
            if (ctx == null) {
                return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo(oql);
            }
            return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(oql);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
        }
        return info;
    }

    public static String aryToStr(List idList, boolean isPs) {
        if (idList == null || idList.isEmpty()) {
            return "''";
        }
        StringBuilder receivers = new StringBuilder();
        if (isPs) {
            for (int i = 0; i < idList.size(); ++i) {
                receivers.append("?,");
            }
        } else {
            for (int i = 0; i < idList.size(); ++i) {
                receivers.append("'").append(idList.get(i).toString()).append("',");
            }
        }
        receivers.deleteCharAt(receivers.length() - 1);
        return receivers.toString();
    }

    public static boolean checkHasDealAllChildren(Context ctx, AccountViewInfo info) throws EASBizException, BOSException {
        boolean ret = false;
        if (info.getId() != null && info.getId().toString().length() > 0) {
            IAccountView acct = ctx == null ? AccountViewFactory.getRemoteInstance() : AccountViewFactory.getLocalInstance(ctx);
            ret = acct.isHasDealAllChildren((IObjectPK)new ObjectUuidPK(info.getId()));
        }
        return ret;
    }
}

