/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.InvalidEntityViewException;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCheckerFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCheckerInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastUtil;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AcctRefContrastException;
import com.kingdee.eas.basedata.master.account.IAccountRefContrastEntry;
import com.kingdee.eas.basedata.master.account.RefTypeEnum;
import com.kingdee.eas.basedata.master.account.app.AbstractAccountRefContrastControllerBean;
import com.kingdee.eas.basedata.master.account.app.AcctRefContrastHelper;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActGroupDetail;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.app.cache.OrgCacheFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AccountRefContrastControllerBean
extends AbstractAccountRefContrastControllerBean {
    private static final long serialVersionUID = -1615419080201601566L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.account.app.AccountRefContrastControllerBean");
    HashSet asstType = new HashSet();

    @Override
    protected void _enableNewAcctTable(Context ctx, String acctRefID) throws BOSException, EASBizException {
        String checkAccount;
        FilterInfo info;
        AccountRefContrastUtil util = new AccountRefContrastUtil();
        AccountRefContrastInfo acctRefInfo = (AccountRefContrastInfo)this._getLevel1AcctInfo(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)acctRefID)), util.getSelectors());
        String isLeafContastMsg = util.checkIsLeafContrast(acctRefInfo);
        if (!StringUtils.isEmpty((String)isLeafContastMsg)) {
            throw new BOSException(EASCommonResource.getString((String)"com.kingdee.eas.basedata.master.account.ACCOUNTAutoGenerateResource", (String)"CheckLeafContastMsg", (Locale)ctx.getLocale()) + isLeafContastMsg);
        }
        try {
            if (!RefTypeEnum.BUDGETACOUNTREF.equals((Object)acctRefInfo.getRefType()) && !RefTypeEnum.FINANCEPROFIT.equals((Object)acctRefInfo.getRefType())) {
                util.checkAsstActType(ctx, ContextUtil.getCurrentFIUnit((Context)ctx), acctRefInfo);
            }
        }
        catch (AccountException e) {
            logger.error((Object)e.getMessage(), (Throwable)((Object)e));
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (RefTypeEnum.BUDGETACOUNTREF.equals((Object)acctRefInfo.getRefType())) {
            try {
                info = new FilterInfo();
                info.getFilterItems().add(new FilterItemInfo("company.id", (Object)acctRefInfo.getCompany().getId().toString(), CompareType.EQUALS));
                info.getFilterItems().add(new FilterItemInfo("refType", (Object)RefTypeEnum.BUDGETACOUNTREF, CompareType.EQUALS));
                info.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)true, CompareType.EQUALS));
                info.getFilterItems().add(new FilterItemInfo("enabledAcctTable.id", (Object)acctRefInfo.getEnabledAcctTable().getId().toString(), CompareType.EQUALS));
                if (this.exists(ctx, info)) {
                    throw new AcctRefContrastException(AcctRefContrastException.DISABLEDACCTTABLEALREADYUSED);
                }
                util.checkCurrency(ctx, ContextUtil.getCurrentFIUnit((Context)ctx), acctRefInfo);
            }
            catch (AccountException e) {
                logger.error((Object)e.getMessage(), (Throwable)((Object)e));
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        if (RefTypeEnum.FINANCEPROFIT.equals((Object)acctRefInfo.getRefType())) {
            try {
                if (acctRefInfo.getStCompany() == null) {
                    throw new AcctRefContrastException(AcctRefContrastException.DEST_COMPANY_NOTNULL);
                }
                info = new FilterInfo();
                info.getFilterItems().add(new FilterItemInfo("company.id", (Object)acctRefInfo.getCompany().getId().toString(), CompareType.EQUALS));
                info.getFilterItems().add(new FilterItemInfo("stCompany.id", (Object)acctRefInfo.getStCompany().getId().toString(), CompareType.EQUALS));
                info.getFilterItems().add(new FilterItemInfo("refType", (Object)RefTypeEnum.FINANCEPROFIT, CompareType.EQUALS));
                info.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)true, CompareType.EQUALS));
                if (this.exists(ctx, info)) {
                    throw new AcctRefContrastException(AcctRefContrastException.DISABLEDACCTTABLEALREADYUSED);
                }
            }
            catch (AccountException e) {
                logger.error((Object)e.getMessage(), (Throwable)((Object)e));
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        AccountRefContrastCheckerInfo checkInfo = AccountRefContrastCheckerFactory.getLocalInstance(ctx).getDefaultValues(acctRefInfo.getCompany().getId()).get(0);
        if (RefTypeEnum.FINANCEPROFIT.equals((Object)acctRefInfo.getRefType()) && !StringUtils.isEmpty((String)(checkAccount = util.checkAccount(ctx, checkInfo, acctRefInfo)))) {
            throw util.getEASBizException(EASCommonResource.getString((String)"com.kingdee.eas.basedata.master.account.ACCOUNTAutoGenerateResource", (String)"8_AccountRefContrastUtil", (Locale)ctx.getLocale()) + checkAccount, null);
        }
        if (RefTypeEnum.NEWOLD.equals((Object)acctRefInfo.getRefType())) {
            util.checkAccountRefContrastInfo(ctx, acctRefInfo, acctRefInfo.getCompany(), checkInfo);
            if (AcctRefContrastHelper.isAcctRefAlreadyDisabled(ctx, acctRefInfo.getCompany().getId().toString(), acctRefID)) {
                throw new AcctRefContrastException(AcctRefContrastException.ENABLEADISABLEACCTTABLE, new Object[]{acctRefInfo.getEnabledAcctTable().getName()});
            }
            if (acctRefInfo.isIsEnabled()) {
                throw new AcctRefContrastException(AcctRefContrastException.ALREADYENABLED);
            }
            if (acctRefInfo.getCompany() != null && acctRefInfo.getCompany().isIsBizUnit()) {
                this.chkIsInAdjPeriod(ctx, acctRefInfo.getCompany().getId().toString());
            }
            if (ContextUtil.getCurrentFIUnit((Context)ctx).isIsBizUnit()) {
                AcctRefContrastHelper.enable(ctx, BOSUuid.read((String)acctRefID));
            }
            NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx).updateAccountTableInCompany(acctRefInfo.getCompany().getId().toString(), acctRefInfo.getEnabledAcctTable().getId().toString());
            AcctRefContrastHelper.updateContrastInfo1(ctx, acctRefInfo.getCompany().getId().toString(), acctRefID);
        } else {
            AcctRefContrastHelper.updateContrastInfo(ctx, acctRefInfo.getCompany().getId().toString(), acctRefID);
        }
    }

    @Override
    protected void _disableNewAcctTable(Context ctx, String acctRefID) throws BOSException, EASBizException {
        AccountRefContrastInfo acctRefInfo = (AccountRefContrastInfo)this._getLevel1AcctInfo(ctx, "select isEnabled,refType,company.id,company.isBizUnit,enabledAcctTable.id,enabledAcctTable.name,disabledAcctTable.id where id='" + acctRefID + "'");
        if (!acctRefInfo.isIsEnabled()) {
            throw new AcctRefContrastException(AcctRefContrastException.ALREADYDISABLED);
        }
        if (this.isExitNotSameLevel(ctx, acctRefID)) {
            // empty if block
        }
        if (RefTypeEnum.NEWOLD.equals((Object)acctRefInfo.getRefType())) {
            if (AcctRefContrastHelper.isAlreadyAssigned(ctx, acctRefInfo.getId().toString())) {
                throw new AcctRefContrastException(AcctRefContrastException.ALREADYASSIGN);
            }
            if (CompanyOrgUnitFactory.getLocalInstance((Context)ctx).exists("where id='" + acctRefInfo.getCompany().getId().toString() + "' and accountTable.id != '" + acctRefInfo.getEnabledAcctTable().getId().toString() + "'")) {
                throw new AcctRefContrastException(AcctRefContrastException.DIFDISABLEACCTTABLE, new Object[]{acctRefInfo.getEnabledAcctTable().getName()});
            }
            if (acctRefInfo.getCompany() != null && acctRefInfo.getCompany().isIsBizUnit()) {
                this.chkIsInAdjPeriod(ctx, acctRefInfo.getCompany().getId().toString());
            }
            DbUtil.execute((Context)ctx, (String)"UPDATE t_bd_acctrefcontrast set fisEnabled = 0, fenabledTime = null, fenabledperiodid = null where fid=?", (Object[])new Object[]{acctRefID});
            NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx).updateAccountTableInCompany(acctRefInfo.getCompany().getId().toString(), acctRefInfo.getDisabledAcctTable().getId().toString());
            if (ContextUtil.getCurrentFIUnit((Context)ctx).isIsBizUnit()) {
                AcctRefContrastHelper.disEnable(ctx, BOSUuid.read((String)acctRefID));
            }
        } else {
            DbUtil.execute((Context)ctx, (String)"UPDATE t_bd_acctrefcontrast set fisEnabled = 0, fenabledTime = null, fenabledperiodid = null where fid=?", (Object[])new Object[]{acctRefID});
        }
    }

    private IObjectCollection getCollectionNoChild(Context ctx, String oql) throws BOSException, EASBizException {
        IObjectCollection result = null;
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            result = this.getDAO(ctx, cn).getCollectionNoChild(new EntityViewInfo(oql));
        }
        catch (ParserException pe) {
            logger.error((Object)pe);
            throw new InvalidEntityViewException(pe.getMessage());
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return result == null || result.size() == 0 ? new AccountRefContrastCollection() : result;
    }

    @Override
    protected IObjectValue _getAcctInfo(Context ctx, String companyID, String curAcctTableID) throws BOSException, EASBizException {
        String oql = "select *,enabledPeriod.* where  company.id='" + companyID + "' and (enabledAcctTable.id='" + curAcctTableID + "' or disabledAcctTable.id='" + curAcctTableID + "') order by enabledPeriod.periodYear desc,enabledPeriod.periodNumber desc";
        IObjectCollection result = this.getCollectionNoChild(ctx, oql);
        AccountRefContrastUtil util = new AccountRefContrastUtil();
        IObjectValue value = null;
        if (result != null && result.size() > 0) {
            BOSUuid id = ((AccountRefContrastInfo)result.getObject(0)).getId();
            ObjectUuidPK pk = new ObjectUuidPK(id);
            value = this._getLevel1AcctInfo(ctx, (IObjectPK)pk, util.getSelectors());
        }
        return value == null ? null : value;
    }

    @Override
    protected IObjectValue _getLastAcctInfo(Context ctx, String companyID, String curAcctTableID, String periodID) throws BOSException, EASBizException {
        String oql = "select *,enabledAcctTable.*,disabledAcctTable.*,enabledPeriod.* where refType=1 and company.id='" + companyID + "' and isEnabled = 1 and enabledAcctTable.id='" + curAcctTableID + "' and enabledPeriod.id='" + periodID + "'";
        IObjectCollection result = this.getCollectionNoChild(ctx, oql);
        return result == null || result.size() == 0 ? null : result.getObject(0);
    }

    @Override
    protected IObjectValue _getLastAcctInfo(Context ctx, String companyID, String curAcctTableID, int periodYear, int periodNumber) throws BOSException, EASBizException {
        IObjectCollection lastRefCol = this.getCollectionNoChild(ctx, "select id,upper.id,enabledAcctTable.id,enabledAcctTable.number,disabledAcctTable.id,disabledAcctTable.number,enabledPeriod.id,enabledPeriod.number,enabledPeriod.periodNumber,enabledPeriod.periodYear where refType=1 and company.id='" + companyID + "' and isEnabled = 1 and enabledPeriod is not null order by enabledPeriod.periodYear desc,enabledPeriod.periodNumber desc");
        if (lastRefCol != null && lastRefCol.size() > 0) {
            String enabledAcctTableID = curAcctTableID;
            for (int i = 0; i < lastRefCol.size(); ++i) {
                AccountRefContrastInfo info = (AccountRefContrastInfo)lastRefCol.getObject(i);
                if (enabledAcctTableID.equals(info.getEnabledAcctTable().getId().toString()) && (periodYear > info.getEnabledPeriod().getPeriodYear() || periodYear == info.getEnabledPeriod().getPeriodYear() && periodNumber >= info.getEnabledPeriod().getPeriodNumber())) {
                    return info;
                }
                if (enabledAcctTableID.equals(info.getEnabledAcctTable().getId().toString())) {
                    enabledAcctTableID = info.getDisabledAcctTable().getId().toString();
                }
                if (i != lastRefCol.size() - 1) continue;
                AccountRefContrastInfo acctRefInfo = new AccountRefContrastInfo();
                AccountTableInfo newAcctTable = new AccountTableInfo();
                newAcctTable.setId(BOSUuid.read((String)enabledAcctTableID));
                acctRefInfo.setEnabledAcctTable(newAcctTable);
                return acctRefInfo;
            }
        }
        AccountRefContrastInfo acctRefInfo = new AccountRefContrastInfo();
        AccountTableInfo newAcctTable = new AccountTableInfo();
        newAcctTable.setId(BOSUuid.read((String)curAcctTableID));
        acctRefInfo.setEnabledAcctTable(newAcctTable);
        return acctRefInfo;
    }

    @Override
    protected IObjectValue _getLastAcctInfo(Context ctx, String companyID, String curAcctTableID) throws BOSException, EASBizException {
        String oql = "select id where refType=1 and company.id='" + companyID + "' and isEnabled = 1 and (enabledAcctTable.id='" + curAcctTableID + "' or disabledAcctTable.id='" + curAcctTableID + "') order by enabledPeriod.periodYear desc,enabledPeriod.periodNumber desc";
        IObjectCollection result = this.getCollectionNoChild(ctx, oql);
        AccountRefContrastUtil util = new AccountRefContrastUtil();
        IObjectValue value = null;
        if (result != null && result.size() > 0) {
            BOSUuid id = ((AccountRefContrastInfo)result.getObject(0)).getId();
            ObjectUuidPK pk = new ObjectUuidPK(id);
            value = this._getLevel1AcctInfo(ctx, (IObjectPK)pk, util.getSelectors());
        }
        return value == null ? null : value;
    }

    @Override
    protected IObjectValue _getLevel1AcctInfo(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        String selectorAcctHead = "";
        String selectorAcctEntry = "";
        for (int i = 0; i < selector.size(); ++i) {
            if (selector.get(i).getPropertyName().toUpperCase().startsWith("acctRefContrastEntry".toUpperCase())) {
                selectorAcctEntry = selectorAcctEntry + (selectorAcctEntry.length() == 0 ? "" : ",") + selector.get(i).getPropertyName().substring("acctRefContrastEntry".length() + 1);
                continue;
            }
            selectorAcctHead = selectorAcctHead + (selectorAcctHead.length() == 0 ? "" : ",") + selector.get(i).getPropertyName();
        }
        CoreBaseCollection result = this.getCollection(ctx, "select " + selectorAcctHead + " where id='" + pk.toString() + "'");
        if (result.size() == 0) {
            throw new ObjectNotFoundException("MissingRecord:");
        }
        AccountRefContrastInfo acctRefInfo = (AccountRefContrastInfo)result.getObject(0);
        String oql = "select " + selectorAcctEntry + " where acctRefContrast.id='" + pk.toString() + "'";
        AccountRefContrastEntryCollection acctRefCol = AccountRefContrastEntryFactory.getLocalInstance(ctx).getAccountRefContrastEntryCollection(oql);
        AsstActGroupDetailCollection coll = null;
        HashSet<String> list = new HashSet<String>();
        for (int i = 0; i < acctRefCol.size(); ++i) {
            if (acctRefCol.get(i).getNewAcct() == null) continue;
            AsstAccountInfo oldCaa = acctRefCol.get(i).getOldAcct().getCAA();
            AsstAccountInfo newCaa = acctRefCol.get(i).getNewAcct().getCAA();
            if (oldCaa != null) {
                list.add("'" + oldCaa.getId() + "'");
            }
            if (newCaa == null) continue;
            list.add("'" + newCaa.getId() + "'");
        }
        if (!list.isEmpty()) {
            String sql = "";
            sql = "select *,asstAccount.*,asstActType.* where asstAccount.id in(" + StringUtils.arrayToString((Object[])list.toArray(), (String)",") + ") order by asstAccount.number";
            IAsstActGroupDetail iAcctGroup = AsstActGroupDetailFactory.getLocalInstance((Context)ctx);
            coll = iAcctGroup.getAsstActGroupDetailCollection(sql);
            for (int i = 0; i < acctRefCol.size(); ++i) {
                AsstAccountInfo newCaa;
                AsstAccountInfo oldCaa = acctRefCol.get(i).getOldAcct().getCAA();
                AsstAccountInfo asstAccountInfo = newCaa = acctRefCol.get(i).getNewAcct() == null ? null : acctRefCol.get(i).getNewAcct().getCAA();
                if (oldCaa != null) {
                    oldCaa.getAsstActGpDt().clear();
                    oldCaa.getAsstActGpDt().addCollection(this.getAsstActGroupDetail(oldCaa, coll));
                }
                if (newCaa == null) continue;
                newCaa.getAsstActGpDt().clear();
                newCaa.getAsstActGpDt().addCollection(this.getAsstActGroupDetail(newCaa, coll));
            }
        }
        if (!this.asstType.isEmpty()) {
            IAsstActType iAsstType = AsstActTypeFactory.getLocalInstance((Context)ctx);
            DataBaseCollection asstActTypeColl = iAsstType.getDataBaseCollection("select *,asstActGpDt.* where id in (" + StringUtils.arrayToString((Object[])this.asstType.toArray(), (String)",") + ") order by number");
            this.setAsstActType(acctRefCol, asstActTypeColl);
        }
        acctRefInfo.getAcctRefContrastEntry().clear();
        acctRefInfo.getAcctRefContrastEntry().addCollection(acctRefCol);
        return acctRefInfo;
    }

    private void setAsstActType(AccountRefContrastEntryCollection acctRefCol, DataBaseCollection asstTypeColl) {
        int acctRefColCount = acctRefCol.size();
        for (int i = 0; i < acctRefColCount; ++i) {
            AsstActGroupDetailCollection newAsstAct;
            AsstActGroupDetailCollection oldAsstAct;
            if (acctRefCol.get(i).getNewAcct() == null) continue;
            AsstAccountInfo oldCaa = acctRefCol.get(i).getOldAcct().getCAA();
            AsstAccountInfo newCaa = acctRefCol.get(i).getNewAcct().getCAA();
            if (oldCaa != null && (oldAsstAct = oldCaa.getAsstActGpDt()) != null) {
                for (AsstActGroupDetailInfo asstActGroupInfo : oldAsstAct) {
                    asstActGroupInfo.setAsstActType(this.getAsstActTypeInfo(asstActGroupInfo, asstTypeColl));
                }
            }
            if (newCaa == null || (newAsstAct = newCaa.getAsstActGpDt()) == null) continue;
            for (AsstActGroupDetailInfo asstActGroupInfo : newAsstAct) {
                asstActGroupInfo.setAsstActType(this.getAsstActTypeInfo(asstActGroupInfo, asstTypeColl));
            }
        }
    }

    private AsstActTypeInfo getAsstActTypeInfo(AsstActGroupDetailInfo srcInfo, DataBaseCollection asstTypeColl) {
        int count = asstTypeColl.size();
        for (int i = 0; i < count; ++i) {
            if (srcInfo.getAsstActType() == null || srcInfo.getAsstActType().getId() == null || !srcInfo.getAsstActType().getId().equals((Object)asstTypeColl.get(i).getId())) continue;
            return (AsstActTypeInfo)asstTypeColl.get(i);
        }
        return null;
    }

    private AsstActGroupDetailCollection getAsstActGroupDetail(AsstAccountInfo info, AsstActGroupDetailCollection srcColl) {
        AsstActGroupDetailCollection coll = new AsstActGroupDetailCollection();
        for (int i = 0; i < srcColl.size(); ++i) {
            this.asstType.add("'" + srcColl.get(i).getAsstActType().getId() + "'");
            if (!info.getId().equals((Object)srcColl.get(i).getAsstAccount().getId())) continue;
            coll.add(srcColl.get(i));
        }
        return coll;
    }

    @Override
    protected IObjectValue _getLevel1AcctInfo(Context ctx, String oql) throws BOSException, EASBizException {
        String selectorAcctHead = "";
        String selectorAcctEntry = "";
        String acctHeadWhere = "";
        String acctEntryWhere = "";
        try {
            EntityViewInfo view = new EntityViewInfo(oql);
            SelectorItemCollection selector = view.getSelector();
            for (int i = 0; i < selector.size(); ++i) {
                if (selector.get(i).getPropertyName().toUpperCase().startsWith("acctRefContrastEntry".toUpperCase())) {
                    selectorAcctEntry = selectorAcctEntry + (selectorAcctEntry.length() == 0 ? "" : ",") + selector.get(i).getPropertyName().substring("acctRefContrastEntry".length() + 1);
                    continue;
                }
                selectorAcctHead = selectorAcctHead + (selectorAcctHead.length() == 0 ? "" : ",") + selector.get(i).getPropertyName();
            }
            FilterInfo filter = view.getFilter();
            for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                if (filter.getFilterItems().get(i).getPropertyName().toUpperCase().startsWith("acctRefContrastEntry".toUpperCase())) {
                    acctEntryWhere = acctEntryWhere + (acctEntryWhere.length() == 0 ? "" : ",") + filter.getFilterItems().get(i).toString();
                    continue;
                }
                acctHeadWhere = acctHeadWhere + (acctHeadWhere.length() == 0 ? "" : ",") + filter.getFilterItems().get(i).toString();
            }
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        CoreBaseCollection result = this.getCollection(ctx, "select " + selectorAcctHead + " where " + acctHeadWhere);
        if (result.size() == 0) {
            throw new ObjectNotFoundException("MissingRecord:");
        }
        AccountRefContrastInfo acctRefInfo = (AccountRefContrastInfo)result.getObject(0);
        AccountRefContrastEntryCollection acctRefCol = AccountRefContrastEntryFactory.getLocalInstance(ctx).getAccountRefContrastEntryCollection("select " + selectorAcctEntry + " where acctRefContrast.id='" + acctRefInfo.getId().toString() + "'-- and newAcct.level=1 and oldAcct.level=1 " + (acctEntryWhere.length() == 0 ? "" : " and " + acctEntryWhere));
        acctRefInfo.getAcctRefContrastEntry().clear();
        acctRefInfo.getAcctRefContrastEntry().addCollection(acctRefCol);
        return acctRefInfo;
    }

    private boolean isExitNotSameLevel(Context ctx, String id) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected void _clearRef(Context ctx, List list) throws BOSException, EASBizException {
        if (list == null) {
            return;
        }
        IAccountRefContrastEntry iAccountRefContrast = AccountRefContrastEntryFactory.getLocalInstance(ctx);
        for (int i = 0; i < list.size(); ++i) {
            AccountRefContrastEntryInfo info = (AccountRefContrastEntryInfo)list.get(i);
            if (info.getId() == null) continue;
            iAccountRefContrast.delete((IObjectPK)new ObjectUuidPK(info.getId().toString()));
        }
    }

    @Override
    protected void _saveRef(Context ctx, List list) throws BOSException, EASBizException {
        IAccountRefContrastEntry iAccountRefContrast = AccountRefContrastEntryFactory.getLocalInstance(ctx);
        for (int i = 0; i < list.size(); ++i) {
            AccountRefContrastEntryInfo info = (AccountRefContrastEntryInfo)list.get(i);
            if (info.getId() != null) {
                iAccountRefContrast.update((IObjectPK)new ObjectUuidPK(info.getId().toString()), (CoreBaseInfo)info);
                continue;
            }
            iAccountRefContrast.addnew((CoreBaseInfo)info);
        }
    }

    protected void _updateAccountTableInCompany(Context ctx, String companyId, String accountTableId) throws BOSException, EASBizException {
        if (!CompanyOrgUnitFactory.getLocalInstance((Context)ctx).exists("where id = '" + companyId + "'")) {
            throw new BOSException("id, " + companyId + ", is not a company unit's id");
        }
        if (accountTableId != null && !AccountTableFactory.getLocalInstance(ctx).exists("where id = '" + accountTableId + "'")) {
            throw new BOSException("id, " + accountTableId + ", is not an account table's id");
        }
        StringBuffer updateOUPartFI = new StringBuffer();
        if (accountTableId == null) {
            updateOUPartFI.append("update t_org_oupartfi set faccounttableid = null");
        } else {
            updateOUPartFI.append("update t_org_oupartfi set faccounttableid = '").append(accountTableId).append("'");
        }
        updateOUPartFI.append(" where funitid = '").append(companyId).append("'");
        StringBuffer updateCompany = new StringBuffer();
        if (accountTableId == null) {
            updateCompany.append("update t_org_company set faccounttableid = null");
        } else {
            updateCompany.append("update t_org_company set faccounttableid = '").append(accountTableId).append("'");
        }
        updateCompany.append(" where fid = '").append(companyId).append("'");
        Connection cn = null;
        Statement stmt = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.createStatement();
            stmt.addBatch(updateOUPartFI.toString());
            stmt.addBatch(updateCompany.toString());
            stmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        OrgCacheFactory.getOrgCache((Context)ctx).clearOrgCache();
    }

    @Override
    protected boolean _assign(Context ctx, BOSUuid acctrefContractId, IObjectCollection destCompanyColl, boolean isCopyCheck) throws BOSException {
        CompanyOrgUnitCollection orgColl = (CompanyOrgUnitCollection)destCompanyColl;
        boolean isAssign = false;
        AccountRefContrastUtil util = new AccountRefContrastUtil();
        isAssign = util.checkAssign(ctx, acctrefContractId, orgColl, isCopyCheck);
        return isAssign;
    }

    @Override
    protected boolean _unAssign(Context ctx, BOSUuid acctrefContractId, IObjectCollection destCompanyColl) throws BOSException {
        CompanyOrgUnitCollection orgColl = (CompanyOrgUnitCollection)destCompanyColl;
        boolean isUnAssign = false;
        AccountRefContrastUtil util = new AccountRefContrastUtil();
        isUnAssign = util.checkUnAssign(ctx, acctrefContractId, orgColl);
        return isUnAssign;
    }

    @Override
    protected IObjectCollection _getAssignCompanyOrgUnit(Context ctx, boolean isAssign, BOSUuid refID) throws BOSException {
        AccountRefContrastUtil util = new AccountRefContrastUtil();
        try {
            util.fixChildRef(ctx, util.getFi(ctx).getId().toString(), refID.toString());
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        CompanyOrgUnitCollection fiColl = new CompanyOrgUnitCollection();
        StringBuffer sql = new StringBuffer();
        BOSUuid fiId = ContextUtil.getCurrentFIUnit((Context)ctx).getId();
        if (!isAssign) {
            sql.append("SELECT b.fid ");
            sql.append("FROM   t_org_company a ");
            sql.append("       INNER JOIN t_org_company b ");
            sql.append("         ON a.fid = b.fparentid ");
            sql.append("WHERE  b.fid not IN (SELECT b.fcompanyid ");
            sql.append("          FROM   t_bd_acctrefcontrast a ");
            sql.append("                 INNER JOIN t_bd_acctrefcontrast b ");
            sql.append("                   ON a.fid = b.fupperid ");
            sql.append("          WHERE  a.fcompanyid = '" + fiId.toString() + "' ");
            sql.append("          AND a.fid = '" + refID.toString() + "') ");
            sql.append("AND a.fid = '" + fiId.toString() + "'");
        } else {
            sql.append("SELECT b.fid ");
            sql.append("FROM   t_org_company a ");
            sql.append("       INNER JOIN t_org_company b ");
            sql.append("         ON a.fid = b.fparentid ");
            sql.append("WHERE  b.fid IN (SELECT b.fcompanyid ");
            sql.append("          FROM   t_bd_acctrefcontrast a ");
            sql.append("                 INNER JOIN t_bd_acctrefcontrast b ");
            sql.append("                   ON a.fid = b.fupperid ");
            sql.append("          WHERE  a.fcompanyid = '" + fiId.toString() + "' ");
            sql.append("          AND a.fid = '" + refID.toString() + "') ");
            sql.append("AND a.fid = '" + fiId.toString() + "'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> list = new ArrayList<String>();
        try {
            while (rs.next()) {
                list.add("'" + rs.getString("FID") + "'");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (!list.isEmpty()) {
            fiColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection("select * where id in(" + StringUtils.arrayToString((Object[])list.toArray(), (String)",") + ") order by number");
        }
        return fiColl;
    }

    private void chkIsInAdjPeriod(Context ctx, String companyID) throws BOSException, EASBizException {
        String lastAdjustPeriod = this.getLastAdjustPeriod(ctx, companyID);
        if (lastAdjustPeriod == null || lastAdjustPeriod.trim().length() == 0) {
            throw new AcctRefContrastException(AcctRefContrastException.GLNOTINADJPERIOD);
        }
        int systemEnum = 6;
        String curPeriodId = this.getCurrentPeriod(ctx, systemEnum, companyID);
        if (curPeriodId != null && !lastAdjustPeriod.equals(curPeriodId)) {
            throw new AcctRefContrastException(AcctRefContrastException.GLNOTINADJPERIOD);
        }
        systemEnum = 14;
        curPeriodId = this.getCurrentPeriod(ctx, systemEnum, companyID);
        if (curPeriodId != null && !lastAdjustPeriod.equals(curPeriodId)) {
            throw new AcctRefContrastException(AcctRefContrastException.FANOTINADJPERIOD);
        }
        systemEnum = 32;
        curPeriodId = this.getCurrentPeriod(ctx, systemEnum, companyID);
        if (curPeriodId != null && !lastAdjustPeriod.equals(curPeriodId)) {
            throw new AcctRefContrastException(AcctRefContrastException.LCMNOTINADJPERIOD);
        }
        systemEnum = 7;
        curPeriodId = this.getCurrentPeriod(ctx, systemEnum, companyID);
        if (curPeriodId != null && !lastAdjustPeriod.equals(curPeriodId)) {
            throw new AcctRefContrastException(AcctRefContrastException.CASNOTINADJPERIOD);
        }
    }

    private String getCurrentPeriod(Context ctx, int systemEnum, String companyid) throws BOSException {
        String curPeriodId = null;
        String sql = " select b.fCurrentPeriodid  from t_bd_systemstatus a ,t_bd_systemstatusctrol b where a.fname=" + systemEnum + " and a.fid=b.fsystemstatusid and b.fcompanyid='" + companyid + "'";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (set.next()) {
                curPeriodId = set.getString("FCurrentPeriodID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return curPeriodId;
    }

    private String getLastAdjustPeriod(Context ctx, String companyid) throws BOSException {
        String lastAdjustPeriodId = null;
        int systemEnum = 6;
        String curPeriodId = this.getCurrentPeriod(ctx, systemEnum, companyid);
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid from T_BD_Period lap      ");
        sql.append(" where exists(                        ");
        sql.append(" select * from T_BD_Period cp         ");
        sql.append(" where cp.fid ='" + curPeriodId + "'  ");
        sql.append(" and cp.FTYPEID = lap.FTYPEID         ");
        sql.append(" and cp.FPERIODYEAR = lap.FPERIODYEAR ");
        sql.append(" )                                    ");
        sql.append(" and FISADJUSTPERIOD = 1              ");
        sql.append(" order by FNUMBER desc                ");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (set.next()) {
                lastAdjustPeriodId = set.getString("fid");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return lastAdjustPeriodId;
    }

    public boolean isStartSystem(Context ctx, int systemEnum, String companyid) throws BOSException {
        ISystemStatusCtrol ctrl = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        boolean isStart = false;
        String sql = " select fisstart from t_bd_systemstatus a ,t_bd_systemstatusctrol b where a.fname=" + systemEnum + " and a.fid=b.fsystemstatusid and b.fcompanyid='" + companyid + "'";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (set.next()) {
                isStart = set.getBoolean("fisstart");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return isStart;
    }

    @Override
    protected IObjectValue _getAcctInfoByDisabledAcctTable(Context ctx, String companyID, String disabledAccountTable) throws BOSException, EASBizException {
        String oql = "select id where refType=1 and isEnabled =1 and company.id='" + companyID + "' and  disabledAcctTable.id='" + disabledAccountTable + "' order by enabledPeriod.periodYear desc,enabledPeriod.periodNumber desc";
        IObjectCollection result = this.getCollectionNoChild(ctx, oql);
        AccountRefContrastUtil util = new AccountRefContrastUtil();
        IObjectValue value = null;
        if (result != null && result.size() > 0) {
            BOSUuid id = ((AccountRefContrastInfo)result.getObject(0)).getId();
            ObjectUuidPK pk = new ObjectUuidPK(id);
            value = this._getLevel1AcctInfo(ctx, (IObjectPK)pk, util.getSelectors());
        }
        return value == null ? null : value;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String oql = "select enabledAcctTable.name,disabledAcctTable.name where id='" + pk.toString() + "'";
        AccountRefContrastInfo acctRefInfo = this.getAccountRefContrastInfo(ctx, oql);
        StringBuffer strLog = new StringBuffer();
        strLog.append(acctRefInfo.getDisabledAcctTable().getName()).append("-");
        strLog.append(acctRefInfo.getEnabledAcctTable().getName());
        return strLog.toString();
    }
}

