/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountTypeCollection;
import com.kingdee.eas.basedata.master.account.AccountTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.app.AbstractAccountTypeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class AccountTypeControllerBean
extends AbstractAccountTypeControllerBean {
    public IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AccountTypeInfo accountTypeInfo = (AccountTypeInfo)model;
        ((ObjectBaseInfo)model).setCU(AccountTools.getCurrentCU(ctx));
        this._checkNumberBlank(ctx, (IObjectValue)accountTypeInfo);
        this._checkNameBlank(ctx, (IObjectValue)accountTypeInfo);
        AccountTypeInfo parentInfo = null;
        if (accountTypeInfo.getParent() != null) {
            parentInfo = super.getAccountTypeInfo(ctx, (IObjectPK)new ObjectUuidPK(accountTypeInfo.getParent().getId()));
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)accountTypeInfo);
        if (accountTypeInfo.getParent() == null) {
            return pk;
        }
        this.synchronizeParentInfo(ctx, accountTypeInfo, parentInfo, pk);
        return pk;
    }

    private void synchronizeParentInfo(Context ctx, AccountTypeInfo accountTypeInfo, AccountTypeInfo parentInfo, IObjectPK pk) throws BOSException, EASBizException {
        if (accountTypeInfo.getParent() != null && !accountTypeInfo.getParent().getId().toString().trim().equalsIgnoreCase(accountTypeInfo.getId().toString().trim()) && parentInfo != null && parentInfo.isIsLeaf()) {
            parentInfo.setIsLeaf(false);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(parentInfo.getId()), (IObjectValue)parentInfo);
            Connection cn = null;
            try {
                StringBuffer sql = new StringBuffer("UPDATE T_BD_AccountView SET FAccountTypeID='");
                sql.append(pk.toString().trim()).append("' WHERE FAccountTableID='");
                sql.append(parentInfo.getAccountTableID().getId().toString().trim());
                sql.append("' AND FAccountTypeID='");
                sql.append(parentInfo.getId().toString().trim()).append("' ");
                cn = EJBFactory.getConnection((Context)ctx);
                SQLUtils.execute((Connection)cn, (String)sql.toString());
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(cn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Connection)cn);
        }
    }

    public void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AccountTypeInfo accountTypeInfo = (AccountTypeInfo)model;
        AccountTypeInfo oldModel = super.getAccountTypeInfo(ctx, pk);
        ((ObjectBaseInfo)model).setCU(AccountTools.getCurrentCU(ctx));
        this._checkNumberBlank(ctx, (IObjectValue)accountTypeInfo);
        this._checkNameBlank(ctx, (IObjectValue)accountTypeInfo);
        if (!(oldModel.isIsLeaf() || oldModel.getNumber().trim().equalsIgnoreCase(accountTypeInfo.getNumber().trim()) && oldModel.getProperty().getValue() == accountTypeInfo.getProperty().getValue())) {
            throw new AccountException(AccountException.NOTEDITTYPENOTISLEAF);
        }
        IAccountView iAccountView = AccountViewFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountTypeID", (Object)pk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)accountTypeInfo.getAccountTableID().getId().toString()));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        SorterItemCollection sorterc = new SorterItemCollection();
        sorterc.add(new SorterItemInfo("number"));
        if (!(iAccountView.getPKList(filter, sorterc).length <= 0 || oldModel.getNumber().trim().equalsIgnoreCase(accountTypeInfo.getNumber().trim()) && oldModel.getProperty().getValue() == accountTypeInfo.getProperty().getValue())) {
            throw new AccountException(AccountException.NOTEDIT_BYREF);
        }
        if (!oldModel.getNumber().trim().equalsIgnoreCase(accountTypeInfo.getNumber().trim())) {
            this._checkNumberDup(ctx, (IObjectValue)accountTypeInfo);
        }
        AccountTypeInfo parentInfo = null;
        if (oldModel.getParent() != null && !oldModel.getParent().getId().equals((Object)oldModel.getId())) {
            parentInfo = super.getAccountTypeInfo(ctx, (IObjectPK)new ObjectUuidPK(accountTypeInfo.getParent().getId()));
        }
        super._update(ctx, pk, (IObjectValue)accountTypeInfo);
    }

    public void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AccountTypeInfo model = super.getAccountTypeInfo(ctx, pk);
        if (!model.isIsLeaf()) {
            throw new AccountException(AccountException.NOTDEL_NOTISLEAF);
        }
        String parentId = null;
        if (model.getParent() != null) {
            parentId = model.getParent().getId().toString();
        }
        boolean hasParent = false;
        if (parentId != null) {
            hasParent = this._hasParent(ctx, pk);
        }
        if (hasParent) {
            String sqlToGetAcctInfo = "SELECT TOP 1 FNumber FROM T_BD_ACCOUNTTYPE WHERE FID=?";
            IRowSet rsToGetAcctInfo = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAcctInfo, (Object[])new Object[]{parentId});
            String fparentnumber = null;
            try {
                if (rsToGetAcctInfo != null && rsToGetAcctInfo.next()) {
                    fparentnumber = rsToGetAcctInfo.getString("FNumber");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            String updateParent = " update T_BD_ACCOUNTTYPE set fnumber='$'||fnumber where fid=? ";
            DbUtil.execute((Context)ctx, (String)updateParent, (Object[])new Object[]{parentId});
            ObjectUuidPK pPk = new ObjectUuidPK(parentId);
            AccountTypeInfo parent = (AccountTypeInfo)this.getValue(ctx, (IObjectPK)pPk);
            parent.setIsLeaf(true);
            parent.setNumber(fparentnumber);
            parent.setId(BOSUuid.read((String)pk.toString()));
            super._update(ctx, pk, (IObjectValue)parent);
            String deleteSQL = "delete from t_bd_accounttype where fid = ?";
            DbUtil.execute((Context)ctx, (String)deleteSQL, (Object[])new Object[]{pPk.toString()});
            parentId = pk.toString();
            return;
        }
        IAccountView iAccountView = AccountViewFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountTypeID", (Object)pk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)model.getAccountTableID().getId().toString()));
        filter.setMaskString("#0 and #1");
        SorterItemCollection sorterc = new SorterItemCollection();
        sorterc.add(new SorterItemInfo("number"));
        if (iAccountView.getPKList(filter, sorterc).length > 0) {
            throw new AccountException(AccountException.BYACCOUNTREF);
        }
        super._delete(ctx, pk);
        if (model.getParent() == null) {
            return;
        }
        if (!model.getParent().getId().toString().trim().equalsIgnoreCase(model.getId().toString().trim())) {
            EntityViewInfo evi = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)model.getParent().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)model.getAccountTableID().getId().toString()));
            filter.setMaskString("#0 and #1");
            evi.setFilter(filter);
            if (super.getCollection(ctx, evi).size() == 0) {
                AccountTypeInfo parentInfo = super.getAccountTypeInfo(ctx, (IObjectPK)new ObjectUuidPK(model.getParent().getId()));
                parentInfo.setIsLeaf(true);
                super.update(ctx, (IObjectPK)new ObjectUuidPK(parentInfo.getId()), (CoreBaseInfo)parentInfo);
            }
        }
    }

    @Override
    protected boolean _hasParent(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sqlToGetAcctInfo = "SELECT TOP 1 FPARENTID FROM T_BD_ACCOUNTTYPE WHERE FID=?";
        IRowSet rsToGetAcctInfo = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAcctInfo, (Object[])new Object[]{pk.toString()});
        String parentId = null;
        try {
            if (rsToGetAcctInfo != null && rsToGetAcctInfo.next() && (parentId = rsToGetAcctInfo.getString("FPARENTID")) != null && parentId.length() > 0) {
                String sqlGetAccount;
                IRowSet rsTogetAccount;
                int count = 0;
                String sqlToCheckHasRefByAccount = "SELECT count(fid) count FROM T_BD_ACCOUNTTYPE WHERE FPARENTID=? ";
                IRowSet rsToCheckHasRefByAccount = DbUtil.executeQuery((Context)ctx, (String)sqlToCheckHasRefByAccount, (Object[])new Object[]{parentId});
                if (rsToCheckHasRefByAccount != null && rsToCheckHasRefByAccount.next()) {
                    count = rsToCheckHasRefByAccount.getInt("count");
                }
                if (count == 1 && (rsTogetAccount = DbUtil.executeQuery((Context)ctx, (String)(sqlGetAccount = "SELECT TOP 1 FId FROM T_BD_ACCOUNTVIEW WHERE FAccountTypeID=?"), (Object[])new Object[]{pk.toString()})) != null && rsTogetAccount.next()) {
                    return true;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AccountTypeInfo acctType = (AccountTypeInfo)model;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)acctType.getNumber().trim()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctType.getAccountTableID().getId().toString()));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        if (super.getCollection(ctx, evi).size() > 0) {
            throw new AccountException(AccountException.ACCOUNT_TYPE_DUPLICATED, new Object[]{acctType.getNumber()});
        }
    }

    private void setLevelAndLongNumber(Context ctx, AccountTypeInfo parentInfo, AccountTypeInfo model) throws BOSException {
        if (parentInfo == null || parentInfo == model) {
            model.setLevel(1);
            model.setLongNumber(model.getNumber());
        } else {
            model.setLevel(parentInfo.getLevel() + 1);
            model.setLongNumber(parentInfo.getLongNumber() + "." + model.getNumber());
        }
    }

    @Override
    protected IObjectCollection _getChildrenByID(Context ctx, IObjectPK parentID, IObjectPK accountTableID) throws BOSException, EASBizException {
        AccountTypeCollection ret = null;
        if (parentID == null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)accountTableID.toString().trim()));
            filter.setMaskString("#0 and #1");
            evi.setFilter(filter);
            evi.getSorter().add(new SorterItemInfo("longNumber"));
            evi.getSelector().add(new SelectorItemInfo("*"));
            evi.getSelector().add(new SelectorItemInfo("accountID.accountTableID"));
            ret = this.getAccountTypeCollection(ctx, evi);
        } else {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)parentID.toString().trim(), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)parentID.toString().trim()));
            evi.setFilter(filter);
            evi.getSorter().add(new SorterItemInfo("longNumber"));
            evi.getSelector().add(new SelectorItemInfo("*"));
            evi.getSelector().add(new SelectorItemInfo("accountID.accountTableID"));
            ret = this.getAccountTypeCollection(ctx, evi);
        }
        return ret;
    }

    @Override
    protected boolean _isReferencedByAccount(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean isRef = false;
        String sql = " SELECT count(fid) AS count from T_BD_AccountType WHERE FParentID='" + pk.toString().trim() + "'";
        isRef = this.Used(ctx, pk, sql);
        if (isRef) {
            return isRef;
        }
        sql = " SELECT count(fid) AS count from T_BD_AccountView WHERE FAccountTypeID='" + pk.toString().trim() + "'";
        isRef = this.Used(ctx, pk, sql);
        if (isRef) {
            return isRef;
        }
        return isRef;
    }

    private boolean Used(Context ctx, IObjectPK pk, String sql) throws BOSException, EASBizException {
        boolean isRef = false;
        PreparedStatement stmt = null;
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            if (rs.next() && rs.getInt("count") > 0) {
                isRef = true;
            }
        }
        catch (SQLException ex) {
            try {
                ex.printStackTrace();
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return isRef;
    }

    protected void checkLNForTree(Context ctx, TreeBaseInfo treeBaseInfo) throws BOSException, EASBizException, TreeBaseException {
    }
}

