/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.ORMEngine;
import com.kingdee.eas.base.core.fi.fa.basedata.BaseFaAlterModeFactory;
import com.kingdee.eas.base.core.fi.gl.GLFlagProcessFactory;
import com.kingdee.eas.base.core.fi.gl.app.AppHelper;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.message.util.StringUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.service.DataPermissionService;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountAssignErrorInfo;
import com.kingdee.eas.basedata.master.account.AccountAssignThreadLocalUtil;
import com.kingdee.eas.basedata.master.account.AccountCheckResult;
import com.kingdee.eas.basedata.master.account.AccountControlAttribute;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountCurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountDiffType;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountPLType;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastUtil;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountTypeFactory;
import com.kingdee.eas.basedata.master.account.AccountTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.Account_ControlCollection;
import com.kingdee.eas.basedata.master.account.Account_ControlFactory;
import com.kingdee.eas.basedata.master.account.Account_ControlInfo;
import com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum;
import com.kingdee.eas.basedata.master.account.AccrualDirectionEnum;
import com.kingdee.eas.basedata.master.account.AcctRefContrastException;
import com.kingdee.eas.basedata.master.account.HeadDetailException;
import com.kingdee.eas.basedata.master.account.IAccountRefContrast;
import com.kingdee.eas.basedata.master.account.IAccountRefContrastEntry;
import com.kingdee.eas.basedata.master.account.IAccountTable;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.IAccount_Control;
import com.kingdee.eas.basedata.master.account.app.AbstractAccountViewControllerBean;
import com.kingdee.eas.basedata.master.account.app.AccountRefContrastProcess;
import com.kingdee.eas.basedata.master.account.app.AccountViewDataImport;
import com.kingdee.eas.basedata.master.account.app.AcctRefContrastHelper;
import com.kingdee.eas.basedata.master.account.app.util.CommonServerUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstAccount;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.app.cache.OrgCacheFactory;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.BizHasDealException;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.tools.datatask.DatataskException;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.DatataskRunServerFactory;
import com.kingdee.eas.tools.datatask.IDatataskRunServer;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelDataReader;
import com.kingdee.eas.tools.datatask.runtime.FileFormatNotStandardException;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.PinYinHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.LowTimer;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class AccountViewControllerBean
extends AbstractAccountViewControllerBean {
    private static Logger logger = Logger.getLogger(AccountViewControllerBean.class);
    private AccountRefContrastUtil util = new AccountRefContrastUtil();
    public static final String RESOURCE = "com.kingdee.eas.basedata.master.account.AllAccountResource";
    private String checkerName = null;
    private BizCheckResult accountCheck = null;

    protected AccountViewInfo getParentAccount(Context ctx, AccountViewInfo vo, AccountTableInfo table) throws EASBizException, BOSException {
        AccountViewInfo parent = null;
        String parentNum = this.getParentNum(vo, table);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Number", (Object)parentNum, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)table.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)vo.getCompanyID().getId().toString()));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        AccountViewCollection accounts = this.getAccountsByDAO(ctx, evi);
        if (accounts != null && accounts.size() > 0) {
            if (accounts.size() > 1) {
                throw new AccountException(AccountException.PARENT_NOT_UNIQUE);
            }
            parent = accounts.get(0);
        }
        return parent;
    }

    protected IObjectPK addnewCM(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AccountViewInfo accountViewInfo = (AccountViewInfo)model;
        boolean isAddnewGrpAccount = accountViewInfo.getCompanyID() == null;
        super._checkNameBlank(ctx, (IObjectValue)accountViewInfo);
        super._checkNumberBlank(ctx, (IObjectValue)accountViewInfo);
        this._checkNumberDup(ctx, (IObjectValue)accountViewInfo);
        this.checkHelpCodeDup(ctx, accountViewInfo);
        AccountTableInfo table = null;
        IAccountTable iAccountTable = AccountTableFactory.getLocalInstance(ctx);
        table = iAccountTable.getAccountTableInfo((IObjectPK)new ObjectUuidPK(accountViewInfo.getAccountTableID().getId()));
        AccountViewInfo parentInfo = this.getParentAccount(ctx, accountViewInfo, table);
        accountViewInfo.setParent(parentInfo);
        this.checkParentIsFreezed(accountViewInfo);
        if (isAddnewGrpAccount) {
            if (parentInfo != null && parentInfo.getGLevel() == parentInfo.getLevel()) {
                throw new AccountException(AccountException.GA_BEYOUND_GCLEVEL);
            }
        } else if (parentInfo == null || parentInfo.getLevel() < parentInfo.getGLevel()) {
            throw new AccountException(AccountException.GA_NOT_ALLOW_CA_IN_GCLEVEL);
        }
        if (!isAddnewGrpAccount && parentInfo != null && !parentInfo.isIsAllowCA()) {
            throw new AccountException(AccountException.GA_NOT_ALLOW_CREATE_CA);
        }
        if (parentInfo != null && parentInfo.isIsLeaf() && this.isRealHasDeal(ctx, (IObjectPK)new ObjectUuidPK(parentInfo.getId()))) {
            this.setPropertiesByParentWithDeal(accountViewInfo, parentInfo);
        }
        if (parentInfo != null) {
            this.setPropertiesByParent(accountViewInfo, parentInfo);
        }
        this.setGroupCtronlProperties(table, parentInfo, accountViewInfo);
        this.checkParentIsFreezed(accountViewInfo);
        if (parentInfo != null) {
            accountViewInfo.setIsGFreeze(parentInfo.isIsGFreeze());
            accountViewInfo.setIsCFreeze(parentInfo.isIsCFreeze());
        } else {
            accountViewInfo.setIsGFreeze(false);
            accountViewInfo.setIsCFreeze(false);
        }
        accountViewInfo.setIsLeaf(true);
        if (isAddnewGrpAccount && parentInfo == null) {
            if (accountViewInfo.getGLevel() < 1) {
                throw new AccountException(AccountException.GALEVEL_IS_ZERO_ORG_NEGATIVE);
            }
        } else {
            accountViewInfo.setGLevel(parentInfo.getGLevel());
        }
        this.setLongName(parentInfo, accountViewInfo);
        this.checkCurrency(accountViewInfo);
        this.checkQuantity(accountViewInfo);
        if (isAddnewGrpAccount) {
            accountViewInfo.setCAA(accountViewInfo.getGAA());
        }
        if (isAddnewGrpAccount) {
            this.checkGroupAuxAccount(accountViewInfo);
        } else {
            this.checkCompanyAuxAccount(ctx, accountViewInfo);
        }
        this.checkPLType(ctx, accountViewInfo);
        IObjectPK pk = null;
        if (parentInfo != null && parentInfo.isIsLeaf()) {
            pk = new ObjectUuidPK(parentInfo.getId());
            AccountViewInfo temp = (AccountViewInfo)parentInfo.clone();
            temp.remove("Id");
            temp.setIsLeaf(false);
            temp.setIsGFreeze(false);
            temp.setIsCFreeze(false);
            IObjectPK temppk = super.innerAddnew(ctx, (IObjectValue)temp);
            parentInfo.setId(BOSUuid.read((String)temppk.toString()));
            accountViewInfo.setParent(parentInfo);
            accountViewInfo.setId(BOSUuid.read((String)pk.toString()));
            this.setInnerAddnewProperties(ctx, accountViewInfo, parentInfo);
            super._update(ctx, pk, (IObjectValue)accountViewInfo);
            if (!isAddnewGrpAccount) {
                AppHelper.copyAccountBalance((Context)ctx, (String)pk.toString(), (String)temppk.toString(), (String)accountViewInfo.getCompanyID().getId().toString());
            }
        } else {
            pk = super._addnew(ctx, (IObjectValue)accountViewInfo);
        }
        return pk;
    }

    protected void checkGroupAuxAccount(AccountViewInfo accountViewInfo) throws AccountException {
        if ((accountViewInfo.isAC() || accountViewInfo.isACNotice()) && accountViewInfo.getGAA() == null) {
            throw new AccountException(AccountException.ISGAC_MUSTHASGASST);
        }
    }

    protected void setPropertiesByParentWithDeal(AccountViewInfo account, AccountViewInfo parent) {
        if (parent != null) {
            account.setGLevel(parent.getGLevel());
            account.setGAA(parent.getGAA());
            account.setDC(parent.getDC());
            account.setAccountingcurrency(parent.getAccountingcurrency());
            account.setCurrencyID(parent.getCurrencyID());
            account.setIsChangeCurrency(parent.isIsChangeCurrency());
            account.setIsCashEquivalent(parent.isIsCashEquivalent());
            account.setIsBank(parent.isIsBank());
            account.setIsCash(parent.isIsCash());
            account.setIsCountAccrual(parent.isIsCountAccrual());
            account.setAccrualPer(parent.getAccrualPer());
            account.setIsQty(parent.isIsQty());
            account.setMeasureUnitGroupID(parent.getMeasureUnitGroupID());
            account.setMeasureUnitID(parent.getMeasureUnitID());
            account.setAC(parent.isAC());
            account.setACNotice(parent.isACNotice());
            account.setBw(parent.isBw());
            account.setCAA(parent.getCAA());
            account.setGAA(parent.getGAA());
            account.setControl(parent.getControl());
            account.setPLType(parent.getPLType());
        }
    }

    protected void setPropertiesByParent(AccountViewInfo account, AccountViewInfo parent) {
        if (parent.getAccountingcurrency() == AccountingCurrencyEnum.ONECURRENCY) {
            account.setAccountingcurrency(parent.getAccountingcurrency());
            account.setCurrencyID(parent.getCurrencyID());
        }
        if (parent.isIsQty()) {
            account.setIsQty(parent.isIsQty());
            account.setMeasureUnitGroupID(parent.getMeasureUnitGroupID());
        }
        if (parent.isAC()) {
            account.setAC(parent.isAC());
        }
        if (parent.isACNotice()) {
            account.setACNotice(parent.isACNotice());
        }
        if (parent.isBw()) {
            account.setBw(parent.isBw());
        }
        if (parent.isIsCountAccrual()) {
            account.setIsCountAccrual(parent.isIsCountAccrual());
        }
    }

    protected IObjectPK addnewDM(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AccountViewInfo accountViewInfo = (AccountViewInfo)model;
        this.checkCompany(accountViewInfo);
        super._checkNameBlank(ctx, (IObjectValue)accountViewInfo);
        super._checkNumberBlank(ctx, (IObjectValue)accountViewInfo);
        this._checkNumberDup(ctx, (IObjectValue)accountViewInfo);
        IAccountTable iAccountTable = AccountTableFactory.getLocalInstance(ctx);
        AccountTableInfo table = iAccountTable.getAccountTableInfo((IObjectPK)new ObjectUuidPK(accountViewInfo.getAccountTableID().getId()));
        this.checkHelpCodeDup(ctx, accountViewInfo);
        String parentNum = this.getParentNum(accountViewInfo, table);
        AccountViewInfo parentInfo = this.getParentAccount(ctx, accountViewInfo, table);
        this.checkParentIsFreezed(accountViewInfo);
        accountViewInfo.setParent(parentInfo);
        if (parentInfo != null) {
            accountViewInfo.setAccountTypeID(parentInfo.getAccountTypeID());
        }
        if (parentInfo != null && parentInfo.isIsLeaf() && this.isRealHasDeal(ctx, (IObjectPK)new ObjectUuidPK(parentInfo.getId()))) {
            this.setPropertiesByParentWithDeal(accountViewInfo, parentInfo);
        }
        if (parentInfo != null) {
            this.setPropertiesByParent(accountViewInfo, parentInfo);
        }
        this.checkAccountType(accountViewInfo);
        accountViewInfo.setIsGFreeze(false);
        accountViewInfo.setIsCFreeze(false);
        this.setLongName(parentInfo, accountViewInfo);
        this.checkCurrency(accountViewInfo);
        this.checkQuantity(accountViewInfo);
        this.checkCompanyAuxAccount(ctx, accountViewInfo);
        this.checkPLType(ctx, accountViewInfo);
        if (parentInfo != null) {
            accountViewInfo.setIsCash(parentInfo.isIsCash());
            accountViewInfo.setIsBank(parentInfo.isIsBank());
            accountViewInfo.setIsCashEquivalent(parentInfo.isIsCashEquivalent());
            accountViewInfo.setPLType(parentInfo.getPLType());
        }
        IObjectPK returnPK = null;
        BOSUuid originComapnyID = accountViewInfo.getCompanyID().getId();
        if (parentInfo == null) {
            CompanyOrgUnitCollection companys = this.getCompanysByAccountTable(ctx, (IObjectPK)new ObjectUuidPK(table.getId()));
            for (int i = 0; i < companys.size(); ++i) {
                accountViewInfo.setId(null);
                accountViewInfo.setCompanyID(companys.get(i));
                accountViewInfo.setCU(companys.get(i).getCU());
                if (companys.get(i).getId().toString().equals(originComapnyID.toString())) {
                    returnPK = super._addnew(ctx, (IObjectValue)accountViewInfo);
                    continue;
                }
                super._addnew(ctx, (IObjectValue)accountViewInfo);
            }
        } else {
            AccountViewCollection parents = this.getAccountsByNumber(ctx, (IObjectPK)new ObjectUuidPK(table.getId()), parentNum);
            for (int i = 0; i < parents.size(); ++i) {
                AccountViewInfo parent = parents.get(i);
                boolean isMe = parent.getCompanyID().getId().toString().equals(originComapnyID.toString());
                if (parentInfo.isIsLeaf()) {
                    ObjectUuidPK pk = new ObjectUuidPK(parent.getId());
                    AccountViewInfo temp = (AccountViewInfo)parent.clone();
                    temp.setId(null);
                    temp.setIsLeaf(false);
                    temp.setIsCFreeze(false);
                    IObjectPK temppk = super.innerAddnew(ctx, (IObjectValue)temp);
                    parent.setId(BOSUuid.read((String)temppk.toString()));
                    accountViewInfo.setParent(parent);
                    accountViewInfo.setId(BOSUuid.read((String)pk.toString()));
                    accountViewInfo.setCompanyID(parent.getCompanyID());
                    this.setInnerAddnewProperties(ctx, accountViewInfo, parent);
                    super.innerUpdate(ctx, (IObjectPK)pk, (IObjectValue)accountViewInfo);
                    AppHelper.copyAccountBalance((Context)ctx, (String)pk.toString(), (String)temppk.toString(), (String)accountViewInfo.getCompanyID().getId().toString());
                    if (!isMe) continue;
                    returnPK = pk;
                    continue;
                }
                BOSUuid id = BOSUuid.create((BOSObjectType)accountViewInfo.getBOSType());
                ObjectUuidPK pk = new ObjectUuidPK(id);
                accountViewInfo.setParent(parent);
                accountViewInfo.setId(id);
                accountViewInfo.setCompanyID(parent.getCompanyID());
                this.setInnerAddnewProperties(ctx, accountViewInfo, parent);
                super.innerAddnew(ctx, (IObjectPK)pk, (IObjectValue)accountViewInfo);
                if (!isMe) continue;
                returnPK = pk;
            }
        }
        return returnPK;
    }

    protected void checkCompanyAuxAccount(Context ctx, AccountViewInfo account) throws BOSException, EASBizException {
        IRowSet rowset;
        String sql;
        String caa;
        if (account.isAC()) {
            if (account.getCAA() == null) {
                throw new AccountException(AccountException.AC_MUST_HAS_GCA);
            }
            caa = account.getCAA().getId().toString();
            sql = "select FasstHGAttribute from t_bd_asstacttype  a  left join T_BD_AsstActTypeDefault b  on a.fid=b.fasstacttypeid where b.FCompanyID=? and b.fisaccountcussent=1 and  a.fid in ( select fasstacttypeid from t_bd_asstactgroupdetail where fasstaccountid =? )";
            rowset = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{account.getCompanyID().getId().toString(), caa});
            try {
                if (rowset == null || !rowset.next()) {
                    CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(account.getCompanyID().getId()));
                    throw new AccountException(AccountException.CAAMUSTASSTBUTE, new Object[]{account.getNumber(), companyOrgUnitInfo.getNumber()});
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        if (account.isACNotice()) {
            if (account.getCAA() == null) {
                throw new AccountException(AccountException.ACNOTICE_MUST_HAS_GCA);
            }
            caa = account.getCAA().getId().toString();
            sql = "select FasstHGAttribute from t_bd_asstacttype where  fid in ( select fasstacttypeid from t_bd_asstactgroupdetail where \tfasstaccountid =? )";
            rowset = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{caa});
            boolean hasCPS = false;
            try {
                while (rowset != null && rowset.next()) {
                    String asstHGAttribute = rowset.getString("FasstHGAttribute");
                    if (!"customer".equals(asstHGAttribute) && !"companyOrg".equals(asstHGAttribute) && !"provider".equals(asstHGAttribute)) continue;
                    hasCPS = true;
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            if (!hasCPS) {
                throw new AccountException(AccountException.CAAMUSTCSP, new Object[]{account.getNumber()});
            }
        }
    }

    protected CompanyOrgUnitCollection getCompanysByAccountTable(Context ctx, IObjectPK tablePK) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("acconttable.id", (Object)tablePK.toString()));
        ev.setFilter(filter);
        ev.getSelector().add("*");
        ev.getSelector().add("cu.id");
        CompanyOrgUnitCollection companys = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(ev);
        return companys;
    }

    protected void setInnerAddnewProperties(Context ctx, AccountViewInfo accountViewInfo, AccountViewInfo parentInfo) {
        accountViewInfo.setLevel(parentInfo.getLevel() + 1);
        accountViewInfo.setLongNumber(parentInfo.getLongNumber() + "!" + accountViewInfo.getNumber());
        accountViewInfo.setIsLeaf(true);
        UserInfo user = this.getUserInfo(ctx);
        accountViewInfo.setCreator(user);
        accountViewInfo.setLastUpdateUser(user);
        long time = new Date().getTime();
        accountViewInfo.setCreateTime(new Timestamp(time));
        accountViewInfo.setLastUpdateTime(new Timestamp(time));
    }

    protected void checkParentIsFreezed(AccountViewInfo accountViewInfo) throws AccountException {
        if (accountViewInfo.getParent() != null && (accountViewInfo.getParent().isIsCFreeze() || accountViewInfo.getParent().isIsGFreeze())) {
            throw new AccountException(AccountException.PARENT_FREEZED_NOT_ALLOW_ADDNEW_CHILD);
        }
    }

    protected void checkAccountType(AccountViewInfo accountViewInfo) throws AccountException {
        if (accountViewInfo.getAccountTypeID() == null) {
            throw new AccountException(AccountException.ACCOUNT_TYPE_IS_NULL);
        }
    }

    protected void checkCompany(AccountViewInfo accountViewInfo) throws AccountException {
    }

    protected int getEASModeValue(Context ctx) throws EASBizException, BOSException {
        return AccountUtils.getEASModeValue(ctx);
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo cuFilter = new FilterInfo();
        AccountViewInfo acctInfo = (AccountViewInfo)model;
        if (acctInfo.getCompanyID() != null) {
            cuFilter.getFilterItems().add(new FilterItemInfo("companyID", (Object)acctInfo.getCompanyID().getId().toString()));
        }
        if (acctInfo.getAccountTableID() != null) {
            cuFilter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctInfo.getAccountTableID().getId().toString()));
        }
        return cuFilter;
    }

    protected void setNumberFromCodingRule(Context ctx, DataBaseInfo caller, String orgId) throws BOSException, EASBizException {
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this._addnew(ctx, model, false);
    }

    private void checkDupName(Context ctx, AccountViewInfo acctInfo) throws BOSException, EASBizException {
        if (acctInfo == null || acctInfo.getCompanyID() == null || acctInfo.getAccountTableID() == null || acctInfo.getName() == null || acctInfo.getId() == null) {
            return;
        }
        String sql = "select id where companyID.id='" + acctInfo.getCompanyID().getId().toString() + "' and accountTableID.id='" + acctInfo.getAccountTableID().getId().toString() + "' and name='" + acctInfo.getName().trim().replaceAll("'", "''") + "' and level = " + (acctInfo.getLevel() < 1 ? 1 : acctInfo.getLevel()) + (acctInfo.getParent() != null ? " and parent.id = '" + acctInfo.getParent().getId().toString() + "'" : "") + (acctInfo.getId() != null ? " and id != '" + acctInfo.getId().toString() + "'" : "");
        if (AccountViewFactory.getLocalInstance(ctx).exists(sql)) {
            throw new AccountException(AccountException.NAMEALEADYEXIST, new Object[]{acctInfo.getName()});
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model, boolean isAssign) throws BOSException, EASBizException {
        AccountViewInfo acctInfo = (AccountViewInfo)model;
        if (!isAssign && !this.isCUBDAllowAddnew(ctx, acctInfo)) {
            throw new AccountException(AccountException.CUBD_CANNOT_ADDNEW);
        }
        AccountViewInfo parentInfo = null;
        if (acctInfo.getParent() != null && acctInfo.getParent().getId() != null && acctInfo.getParent().getId().toString().length() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("accountTypeID.property");
            sic.add("accountCurrency.*");
            parentInfo = this.getAccountViewInfo(ctx, (IObjectPK)new ObjectUuidPK(acctInfo.getParent().getId()), sic);
        }
        AccountViewInfo upperInfo = null;
        if (acctInfo.getUpper() != null && acctInfo.getUpper().getId() != null && acctInfo.getUpper().getId().toString().length() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("accountTypeID.property");
            sic.add("accountCurrency.*");
            upperInfo = this.getAccountViewInfo(ctx, (IObjectPK)new ObjectUuidPK(acctInfo.getUpper().getId()), sic);
            acctInfo.setUpper(upperInfo);
        }
        if (acctInfo != null) {
            AccountTools.checkAccountCanAdd(ctx, acctInfo);
        }
        this.attributeCheck(ctx, acctInfo, null, isAssign);
        this.setPropertiesWhenHasDeal(ctx, acctInfo, null, parentInfo);
        this.setPropertiesWhenHasInferior(ctx, acctInfo, null);
        this.setParentProperties(ctx, acctInfo, null, parentInfo);
        this.setUpperProperties(ctx, acctInfo, null, upperInfo, isAssign);
        this.setPropertiesAccordToOtherRule(ctx, acctInfo, null, isAssign);
        this.setHasUserProperty(ctx, acctInfo);
        IObjectPK pk = null;
        if (parentInfo != null && parentInfo.isIsLeaf() && acctInfo.getCompanyID().isIsBizUnit()) {
            boolean parentHasDeal;
            if ((parentInfo.getCAA() == null && acctInfo.getCAA() != null || parentInfo.getCAA() != null && acctInfo.getCAA() == null || parentInfo.getCAA() != null && acctInfo.getCAA() != null && !parentInfo.getCAA().getId().equals((Object)acctInfo.getCAA().getId())) && (parentHasDeal = this.isHasDeal(ctx, (IObjectPK)new ObjectUuidPK(parentInfo.getId()), false))) {
                throw new AccountException(AccountException.ACC_NOT_SAME, new Object[]{acctInfo.getCompanyID().getNumber(), parentInfo.getNumber(), acctInfo.getNumber(), parentInfo.getNumber()});
            }
            if (parentInfo.getCAA() != null) {
                String sql = "delete from T_BD_ACCOUNTASSTDFTVALUE where FACCOUNTID = ?";
                com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{parentInfo.getId().toString()});
            }
            pk = new ObjectUuidPK(parentInfo.getId());
            AccountViewInfo temp = (AccountViewInfo)parentInfo.clone();
            temp.setId(null);
            temp.setIsLeaf(false);
            temp.setHasUserProperty(false);
            AccountCurrencyCollection acctCuDetails = temp.getAccountCurrency();
            if (acctCuDetails != null) {
                int count = acctCuDetails.size();
                for (int i = 0; i < count; ++i) {
                    acctCuDetails.get(i).setAccountView(temp);
                    acctCuDetails.get(i).remove("id");
                }
            }
            parentInfo.setNumber(acctInfo.getNumber());
            super._update(ctx, pk, (IObjectValue)parentInfo);
            temp.setLastUpdateTime(new Timestamp(new Date().getTime()));
            IObjectPK temppk = super.innerAddnew(ctx, (IObjectValue)temp);
            String sqlToSynchronizeUpperId = "UPDATE T_BD_ACCOUNTVIEW SET FUPPERID=? WHERE FUPPERID=?";
            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sqlToSynchronizeUpperId, (Object[])new Object[]{temppk.toString(), pk.toString()});
            parentInfo.setId(BOSUuid.read((String)temppk.toString()));
            acctInfo.setParent(parentInfo);
            acctInfo.setId(BOSUuid.read((String)pk.toString()));
            this.setInnerAddnewProperties(ctx, acctInfo, parentInfo);
            super._update(ctx, pk, (IObjectValue)acctInfo);
            String updateUpper = "update t_bd_accountview set fupperid =? where fid=?";
            String updateUpperNull = "update t_bd_accountview set fupperid =null where fid=?";
            if (acctInfo.getUpper() == null) {
                com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)updateUpperNull, (Object[])new Object[]{acctInfo.getId().toString()});
            } else {
                com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)updateUpper, (Object[])new Object[]{acctInfo.getUpper().getId().toString(), acctInfo.getId().toString()});
            }
            ORMValueCacheService.getInstance().remove(ctx, acctInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(acctInfo.getId()));
            AppHelper.copyAccountBalance((Context)ctx, (String)pk.toString(), (String)temppk.toString(), (String)acctInfo.getCompanyID().getId().toString());
        } else {
            if (acctInfo.get("hasUserProperty") == null) {
                acctInfo.setHasUserProperty(false);
            }
            pk = super._addnew(ctx, (IObjectValue)acctInfo);
        }
        if (acctInfo.getControl() != AccountControlAttribute.NONE && (acctInfo.getControl() == AccountControlAttribute.AP || acctInfo.getControl() == AccountControlAttribute.AR)) {
            CommonServerUtils.isARAPAccount(ctx, acctInfo.getCompanyID().getId().toString(), acctInfo.getAccountTableID().getId().toString(), acctInfo.getId().toString(), acctInfo.getControl().getValue());
        }
        if (!isAssign) {
            this.checkIsInEnabledAcctref(ctx, pk);
            this.checkDupName(ctx, acctInfo);
        }
        this.handleAstInitClosed(ctx, acctInfo);
        PinYinHelper.generatePinYin((Context)ctx, (String)"com.kingdee.eas.basedata.master.account.app.AccountView", (String[])pk.toString().split(""));
        if (acctInfo.getCompanyID().isIsBizUnit() && acctInfo.isAC() && acctInfo.isIsLeaf()) {
            AccountViewCollection coll = new AccountViewCollection();
            coll.add(acctInfo);
            this.fixAcctCussentData(ctx, coll);
        }
        return pk;
    }

    protected void setPropertiesWhenHasInferior(Context ctx, AccountViewInfo acctInfo, AccountViewInfo oldAcctInfo) throws EASBizException, BOSException {
        if (oldAcctInfo == null || acctInfo.getId() == null || acctInfo.getId().toString().length() < 1) {
            return;
        }
        boolean isHasInferior = AccountTools.checkAccountHasInferior(ctx, acctInfo);
        boolean hasChanged = false;
        if (acctInfo.getHelpCode() == null && oldAcctInfo.getHelpCode() != null || acctInfo.getHelpCode() != null && oldAcctInfo.getHelpCode() == null || acctInfo.getHelpCode() != null && oldAcctInfo.getHelpCode() != null && !acctInfo.getHelpCode().equals(oldAcctInfo.getHelpCode())) {
            hasChanged = true;
        }
        if (!hasChanged) {
            return;
        }
    }

    protected void setPropertiesWhenHasDeal(Context ctx, AccountViewInfo info, AccountViewInfo oldAcctInfo, AccountViewInfo parentInfo) throws EASBizException, BOSException {
        AccountViewInfo parent;
        boolean hasChanged = false;
        AccountViewInfo acctInfoBeforeModify = null;
        if (info.getId() == null || info.getId().toString().length() < 1) {
            if (info.getParent() != null && info.getParent().isIsLeaf()) {
                acctInfoBeforeModify = parentInfo;
            }
        } else {
            acctInfoBeforeModify = oldAcctInfo;
        }
        if (acctInfoBeforeModify != null && (info.getDC().getValue() != acctInfoBeforeModify.getDC().getValue() || info.isIsCash() != acctInfoBeforeModify.isIsCash() || info.getControlLevel() != acctInfoBeforeModify.getControlLevel() || info.isIsBank() != acctInfoBeforeModify.isIsBank() || info.isIsCashEquivalent() != acctInfoBeforeModify.isIsCashEquivalent() || info.getPLType().getValue() != acctInfoBeforeModify.getPLType().getValue() || info.getCAA() == null && acctInfoBeforeModify.getCAA() != null || info.getCAA() != null && acctInfoBeforeModify.getCAA() == null || info.getCAA() != null && acctInfoBeforeModify.getCAA() != null && !info.getCAA().getId().toString().equals(acctInfoBeforeModify.getCAA().getId().toString()) || info.isIsQty() && !acctInfoBeforeModify.isIsQty() || info.isAC() && !acctInfoBeforeModify.isAC() || !info.getAccountTypeID().getId().toString().equals(acctInfoBeforeModify.getAccountTypeID().getId().toString()) || info.isACNotice() && !acctInfoBeforeModify.isACNotice() || info.isBw() && !acctInfoBeforeModify.isBw() || this.compareAccountCurrency(info, acctInfoBeforeModify) < 0 || !info.getDiffType().equals((Object)acctInfoBeforeModify.getDiffType()))) {
            hasChanged = true;
        }
        if (!hasChanged) {
            return;
        }
        boolean isReference = info.getId() == null || info.getId().toString().length() < 1 ? (info.getParent() != null && info.getParent().isIsLeaf() ? AccountTools.checkAccountHasReference(ctx, info.getParent()) : false) : (info.getRefId() != null && info.getRefId().equals("HASDEAL") ? true : AccountTools.checkAccountHasReference(ctx, info));
        if (isReference) {
            if (info.getControlLevel() < acctInfoBeforeModify.getControlLevel()) {
                throw new AccountException(AccountException.CONTROLLEVEL_ERR, new Object[]{info.getNumber(), new Integer(acctInfoBeforeModify.getControlLevel())});
            }
            if (info.getAccountTypeID() != null && acctInfoBeforeModify.getAccountTypeID() != null && !info.getAccountTypeID().getId().toString().equals(acctInfoBeforeModify.getAccountTypeID().getId().toString())) {
                throw new AccountException(AccountException.CANTALTERACCTTYPE);
            }
            if (!info.getDiffType().equals((Object)acctInfoBeforeModify.getDiffType())) {
                throw new AccountException(AccountException.DIFFTYPE_HASBIZ_CHECK);
            }
            AccountViewInfo standardInfo = acctInfoBeforeModify;
            info.setDC(standardInfo.getDC());
            info.setIsCash(standardInfo.isIsCash());
            info.setIsBank(standardInfo.isIsBank());
            info.setIsCashEquivalent(standardInfo.isIsCashEquivalent());
            info.setPLType(standardInfo.getPLType());
            info.setCAA(standardInfo.getCAA());
            if (!standardInfo.isIsQty()) {
                info.setIsQty(false);
            }
            if (!standardInfo.isAC()) {
                info.setAC(false);
            }
            if (!standardInfo.isBw()) {
                info.setBw(false);
            }
            if (info.getAccountingcurrency().getValue() < standardInfo.getAccountingcurrency().getValue()) {
                throw new AccountException(AccountException.ACCOUNTCURRENCYPOLICYWHENHASDEAL, new Object[]{info.getNumber()});
            }
            if (info.getAccountingcurrency().getValue() == standardInfo.getAccountingcurrency().getValue() && info.getAccountingcurrency() == AccountingCurrencyEnum.ONECURRENCY) {
                AccountCurrencyInfo acctCuDetailInfo;
                int i;
                int count;
                AccountCurrencyCollection acctCuDetails;
                ArrayList<String> currencyIdList = new ArrayList<String>();
                if (info.getAccountCurrency() != null) {
                    acctCuDetails = info.getAccountCurrency();
                    count = acctCuDetails.size();
                    for (i = 0; i < count; ++i) {
                        acctCuDetailInfo = acctCuDetails.get(i);
                        if (acctCuDetailInfo == null || acctCuDetailInfo.getCurrency().getId() == null || acctCuDetailInfo.getCurrency().getId().toString().length() <= 0) continue;
                        currencyIdList.add(acctCuDetailInfo.getCurrency().getId().toString());
                    }
                }
                if (standardInfo.getAccountCurrency() != null) {
                    acctCuDetails = standardInfo.getAccountCurrency();
                    count = acctCuDetails.size();
                    for (i = 0; i < count; ++i) {
                        String currencyId;
                        acctCuDetailInfo = acctCuDetails.get(i);
                        if (acctCuDetailInfo == null || acctCuDetailInfo.getCurrency().getId() == null || acctCuDetailInfo.getCurrency().getId().toString().length() <= 0 || currencyIdList.contains(currencyId = acctCuDetailInfo.getCurrency().getId().toString())) continue;
                        throw new AccountException(AccountException.ACCOUNTCURRENCYPOLICYWHENHASDEAL, new Object[]{info.getNumber()});
                    }
                }
            }
        }
        if (info.getParent() != null && (parent = acctInfoBeforeModify) != null && parent.getControlLevel() > info.getControlLevel()) {
            throw new AccountException(AccountException.CONTROLLEVEL_ERR, new Object[]{info.getNumber(), new Integer(parent.getControlLevel())});
        }
        if (info.getUpper() != null && info.getControlLevel() < acctInfoBeforeModify.getControlLevel()) {
            throw new AccountException(AccountException.CONTROLLEVEL_ERR, new Object[]{info.getNumber(), new Integer(acctInfoBeforeModify.getControlLevel())});
        }
    }

    protected int compareAccountCurrency(AccountViewInfo newInfo, AccountViewInfo oldInfo) {
        int result = 0;
        if (newInfo.getAccountingcurrency().getValue() > oldInfo.getAccountingcurrency().getValue()) {
            result = 1;
        } else if (newInfo.getAccountingcurrency().getValue() < oldInfo.getAccountingcurrency().getValue()) {
            result = -1;
        } else if (newInfo.getAccountingcurrency() == AccountingCurrencyEnum.ONECURRENCY) {
            int i;
            int size;
            AccountCurrencyCollection acctCurCols;
            ArrayList<String> newCurrencyIdList = new ArrayList<String>();
            ArrayList<String> oldCurrencyIdList = new ArrayList<String>();
            if (newInfo.getAccountCurrency() != null) {
                acctCurCols = newInfo.getAccountCurrency();
                size = acctCurCols.size();
                for (i = 0; i < size; ++i) {
                    newCurrencyIdList.add(acctCurCols.get(i).getCurrency().getId().toString());
                }
            }
            if (oldInfo.getAccountCurrency() != null) {
                acctCurCols = oldInfo.getAccountCurrency();
                size = acctCurCols.size();
                for (i = 0; i < size; ++i) {
                    oldCurrencyIdList.add(acctCurCols.get(i).getCurrency().getId().toString());
                }
            }
            result = newCurrencyIdList.size() == oldCurrencyIdList.size() && newCurrencyIdList.containsAll(oldCurrencyIdList) ? 0 : (newCurrencyIdList.containsAll(oldCurrencyIdList) ? 1 : (oldCurrencyIdList.containsAll(newCurrencyIdList) ? -1 : -2));
        }
        return result;
    }

    protected void setPropertiesAccordToOtherRule(Context ctx, AccountViewInfo acctInfo, AccountViewInfo oldAcctInfo, boolean isAssign) throws EASBizException, BOSException {
        this.checkAccountCurrency(ctx, acctInfo);
        this.checkQuantity(acctInfo);
        this.checkCompanyAuxAccount(ctx, acctInfo);
        this.checkAACM(ctx, acctInfo, oldAcctInfo, isAssign);
        this.checkPLType(ctx, acctInfo);
        this.checkDiffType(ctx, acctInfo);
    }

    private void checkDiffType(Context ctx, AccountViewInfo acctInfo) throws EASBizException, BOSException {
        AccountTypeInfo accountTypeInfo = null;
        accountTypeInfo = AccountTypeFactory.getLocalInstance(ctx).getAccountTypeInfo((IObjectPK)new ObjectUuidPK(acctInfo.getAccountTypeID().getId()));
        if (accountTypeInfo.getProperty() == AccountProperty.SUNYI) {
            if (AccountDiffType.EMPTY.equals((Object)acctInfo.getDiffType())) {
                throw new AccountException(AccountException.DIFFTYPE_SUNYI_CHECK);
            }
        } else if (accountTypeInfo.getProperty() == AccountProperty.BUDGET_RECEIPTS) {
            if (!AccountDiffType.INCOME.equals((Object)acctInfo.getDiffType())) {
                throw new AccountException(AccountException.DIFFTYPE_BUDGET_RECEIPTS_CHECK);
            }
        } else if (accountTypeInfo.getProperty() == AccountProperty.BUDGET_OUTLAYS) {
            if (!AccountDiffType.EXPENSE.equals((Object)acctInfo.getDiffType())) {
                throw new AccountException(AccountException.DIFFTYPE_BUDGET_OUTLAYS_CHECK);
            }
        } else if (!AccountDiffType.EMPTY.equals((Object)acctInfo.getDiffType())) {
            throw new AccountException(AccountException.DIFFTYPE_NORMAL_CHECK);
        }
    }

    protected void checkAccountCurrency(Context ctx, AccountViewInfo acctInfo) throws BOSException, EASBizException {
        Account_ControlInfo acctCtrlInfo;
        int i;
        if (acctInfo.getAccountingcurrency() == AccountingCurrencyEnum.ONECURRENCY && (acctInfo.getAccountCurrency() == null || acctInfo.getAccountCurrency().size() < 1)) {
            throw new AccountException(AccountException.MUSTHASCURRENCY, new Object[]{acctInfo.getNumber()});
        }
        ArrayList<String> currencyIdList = new ArrayList<String>();
        AccountCurrencyCollection acctCuDetails = acctInfo.getAccountCurrency();
        if (acctCuDetails != null) {
            int count = acctCuDetails.size();
            for (int i2 = 0; i2 < count; ++i2) {
                currencyIdList.add(acctCuDetails.get(i2).getCurrency().getId().toString());
            }
        }
        if (acctInfo.getId() != null && acctInfo.getId().toString().length() > 1) {
            try {
                String sqlToGetAccountingCurrency = "SELECT TOP 1 Fnumber FROM T_BD_ACCOUNTVIEW WHERE FPARENTID=? AND FAcctCurrency>?";
                IRowSet rsToGetAccountingCurrency = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetAccountingCurrency, (Object[])new Object[]{acctInfo.getId().toString(), new Integer(acctInfo.getAccountingcurrency().getValue())});
                if (rsToGetAccountingCurrency != null && rsToGetAccountingCurrency.next()) {
                    String number = rsToGetAccountingCurrency.getString("Fnumber");
                    throw new AccountException(AccountException.ACCOUNTCURRENCYPOLICYWITHPARENT, new Object[]{number});
                }
                sqlToGetAccountingCurrency = "SELECT TOP 1 Fnumber FROM T_BD_ACCOUNTVIEW WHERE FUPPERID=? AND FAcctCurrency>?";
                rsToGetAccountingCurrency = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetAccountingCurrency, (Object[])new Object[]{acctInfo.getId().toString(), new Integer(acctInfo.getAccountingcurrency().getValue())});
                if (rsToGetAccountingCurrency != null && rsToGetAccountingCurrency.next()) {
                    String number = rsToGetAccountingCurrency.getString("Fnumber");
                    throw new AccountException(AccountException.ACCTCURRENCYPOLICYWITHUPPER, new Object[]{number});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (acctInfo.getAccountingcurrency() == AccountingCurrencyEnum.ONECURRENCY) {
                String number;
                String currencyId;
                String sql = "SELECT DISTINCT ACCTCU.FCurrencyID,ACCT.FNUMBER FROM T_BD_ACCOUNTVIEW ACCT JOIN T_BD_ACCOUNTCURRENCY ACCTCU ON ACCT.FID=ACCTCU.FACCOUNTVIEWID WHERE ACCT.FPARENTID=?";
                IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{acctInfo.getId().toString()});
                if (rs != null) {
                    try {
                        while (rs.next()) {
                            currencyId = rs.getString("FCurrencyID");
                            number = rs.getString("Fnumber");
                            if (currencyIdList.contains(currencyId)) continue;
                            throw new AccountException(AccountException.ACCOUNTCURRENCYPOLICYWITHPARENT, new Object[]{number});
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                if ((rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)(sql = "SELECT DISTINCT ACCTCU.FCurrencyID ,ACCT.FNUMBER FROM T_BD_ACCOUNTVIEW ACCT JOIN T_BD_ACCOUNTCURRENCY ACCTCU ON ACCT.FID=ACCTCU.FACCOUNTVIEWID WHERE ACCT.FUPPERID=?"), (Object[])new Object[]{acctInfo.getId().toString()})) != null) {
                    try {
                        while (rs.next()) {
                            currencyId = rs.getString("FCurrencyID");
                            number = rs.getString("Fnumber");
                            if (currencyIdList.contains(currencyId)) continue;
                            throw new AccountException(AccountException.ACCTCURRENCYPOLICYWITHUPPER, new Object[]{number});
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
            }
        }
        if (acctInfo.getParent() != null && acctInfo.getAccountingcurrency().getValue() >= 1) {
            String queryCurrency = "SELECT tmp.currencycount AS COUNT, (SELECT facctcurrency FROM t_bd_accountview WHERE fid = '" + acctInfo.getParent().getId().toString() + "') AS facctcurrency FROM (SELECT count(a.fcurrencyid) as currencycount FROM t_bd_accountcurrency a WHERE a.faccountviewid ='" + acctInfo.getParent().getId().toString() + "' ";
            int size = acctInfo.getAccountCurrency().size();
            for (i = 0; i < size; ++i) {
                queryCurrency = queryCurrency + (i == 0 ? " and a.fcurrencyid IN ('" + acctInfo.getAccountCurrency().get(i).getCurrency().getId().toString() + "'" : " ,'" + acctInfo.getAccountCurrency().get(i).getCurrency().getId().toString() + "'");
                queryCurrency = queryCurrency + (i == size - 1 ? " ) " : "");
            }
            queryCurrency = queryCurrency + " ) tmp ";
            try {
                IRowSet hasCurrency = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)queryCurrency);
                if (hasCurrency.next()) {
                    int count = hasCurrency.getInt(1);
                    int accountingcurrency = hasCurrency.getInt(2);
                    if (accountingcurrency < 2 && count < acctInfo.getAccountCurrency().size()) {
                        throw new AccountException(AccountException.ACCOUNTCURRENCYPOLICYWITHPARENT, new Object[]{acctInfo.getNumber()});
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (acctInfo.getUpper() != null && acctInfo.getAccountingcurrency().getValue() >= 1) {
            String queryCurrency = "SELECT tmp.currencycount AS COUNT, (SELECT facctcurrency FROM t_bd_accountview WHERE fid = '" + acctInfo.getUpper().getId().toString() + "') AS facctcurrency FROM (SELECT count(a.fcurrencyid) as currencycount FROM t_bd_accountcurrency a WHERE a.faccountviewid ='" + acctInfo.getUpper().getId().toString() + "' ";
            int size = acctInfo.getAccountCurrency().size();
            for (i = 0; i < size; ++i) {
                queryCurrency = queryCurrency + (i == 0 ? " and a.fcurrencyid IN ('" + acctInfo.getAccountCurrency().get(i).getCurrency().getId().toString() + "'" : " ,'" + acctInfo.getAccountCurrency().get(i).getCurrency().getId().toString() + "'");
                queryCurrency = queryCurrency + (i == size - 1 ? " ) " : "");
            }
            queryCurrency = queryCurrency + " ) tmp ";
            try {
                IRowSet hasCurrency = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)queryCurrency);
                if (hasCurrency.next()) {
                    int count = hasCurrency.getInt(1);
                    int accountingcurrency = hasCurrency.getInt(2);
                    if (accountingcurrency < 2 && count < acctInfo.getAccountCurrency().size()) {
                        throw new AccountException(AccountException.ACCTCURRENCYPOLICYWITHUPPER, new Object[]{acctInfo.getNumber()});
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if ((acctCtrlInfo = AccountTools.getAcctCtrlInfo(ctx, acctInfo.getAccountTableID(), acctInfo.getCompanyID())) == null) {
            return;
        }
        if (acctCtrlInfo.getCurrencyID() == 1 && acctInfo.getUpper() != null && acctInfo.getAccountingcurrency().getValue() >= 1) {
            AccountViewInfo upper = acctInfo.getUpper();
            if (acctCtrlInfo.getCurrencyID() == 1) {
                int i3;
                if (acctInfo.getAccountingcurrency().getValue() != upper.getAccountingcurrency().getValue()) {
                    throw new AccountException(AccountException.ACCOUNTCURRENCYPOLICYWITHUPPER);
                }
                ArrayList<String> upperAcctCurrencyIdList = new ArrayList<String>();
                if (upper.getAccountCurrency() != null) {
                    AccountCurrencyCollection upperAcctCu = upper.getAccountCurrency();
                    int count = upperAcctCu.size();
                    for (int i4 = 0; i4 < count; ++i4) {
                        AccountCurrencyInfo acctCuDetailInfo = upperAcctCu.get(i4);
                        if (acctCuDetailInfo == null || acctCuDetailInfo.getCurrency().getId() == null || acctCuDetailInfo.getCurrency().getId().toString().length() <= 0) continue;
                        upperAcctCurrencyIdList.add(acctCuDetailInfo.getCurrency().getId().toString());
                    }
                }
                int count = currencyIdList.size();
                for (i3 = 0; i3 < count; ++i3) {
                    if (upperAcctCurrencyIdList.contains(currencyIdList.get(i3))) continue;
                    throw new AccountException(AccountException.ACCOUNTCURRENCYPOLICYWITHUPPER);
                }
                count = upperAcctCurrencyIdList.size();
                for (i3 = 0; i3 < count; ++i3) {
                    if (currencyIdList.contains(upperAcctCurrencyIdList.get(i3))) continue;
                    throw new AccountException(AccountException.ACCOUNTCURRENCYPOLICYWITHUPPER);
                }
            }
        }
    }

    protected void setUpperProperties(Context ctx, AccountViewInfo acctInfo, AccountViewInfo oldAcctInfo, AccountViewInfo upper, boolean isAssign) throws EASBizException, BOSException {
        if (oldAcctInfo == null && acctInfo.getUpper() == null || oldAcctInfo != null && oldAcctInfo.getUpper() == null) {
            return;
        }
        acctInfo.setNumber(upper.getNumber());
        acctInfo.setName(upper.getName());
        acctInfo.setAccountTypeID(upper.getAccountTypeID());
        acctInfo.setIsCash(upper.isIsCash());
        acctInfo.setIsBank(upper.isIsBank());
        acctInfo.setIsCashEquivalent(upper.isIsCashEquivalent());
        acctInfo.setGAA(upper.getCAA());
        acctInfo.setPLType(upper.getPLType());
        acctInfo.setDiffType(upper.getDiffType());
        if (acctInfo.getParent() == null && acctInfo.getCAA() == null && upper.getCAA() != null) {
            throw new AccountException(AccountException.CAANOTINCLUDEGAA, new Object[]{acctInfo.getNumber()});
        }
        if (acctInfo.getParent() == null && acctInfo.getCAA() == null) {
            acctInfo.setCAA(upper.getCAA());
        }
        acctInfo.setIsGFreeze(upper.isIsCFreeze());
        Account_ControlInfo acctCtrlInfo = AccountTools.getAcctCtrlInfo(ctx, acctInfo.getAccountTableID(), acctInfo.getCompanyID());
        if (acctCtrlInfo == null) {
            return;
        }
        if (acctCtrlInfo.getDc() == 1) {
            acctInfo.setDC(upper.getDC());
        }
        if (acctCtrlInfo.getControl() == 1) {
            acctInfo.setControl(upper.getControl());
        }
        if (acctCtrlInfo.getIsQty() == 1 && upper.isIsQty()) {
            acctInfo.setIsQty(true);
            if (acctInfo.getMeasureUnitGroupID() == null || acctInfo.getMeasureUnitGroupID().getId().toString().length() < 1) {
                acctInfo.setMeasureUnitGroupID(upper.getMeasureUnitGroupID());
            }
            if (acctInfo.getMeasureUnitID() == null || acctInfo.getMeasureUnitID().getId().toString().length() < 1) {
                acctInfo.setMeasureUnitID(upper.getMeasureUnitID());
            }
        }
        if (acctCtrlInfo.getAc() == 1 && upper.isAC()) {
            acctInfo.setAC(upper.isAC());
        }
        if (acctCtrlInfo.getAcNotice() == 1 && upper.isACNotice()) {
            acctInfo.setACNotice(upper.isACNotice());
        }
        if (acctCtrlInfo.getBw() == 1 && upper.isBw()) {
            acctInfo.setBw(upper.isBw());
        }
        if (acctCtrlInfo.getIsChangeCurrency() == 1 && upper.isIsChangeCurrency()) {
            acctInfo.setIsChangeCurrency(upper.isIsChangeCurrency());
        }
        if (acctCtrlInfo.getIsProfitCenter() == 1 && upper.isIsProfitCenter()) {
            acctInfo.setIsProfitCenter(upper.isIsProfitCenter());
        }
        if (isAssign) {
            return;
        }
        AccountViewCollection acctCol = null;
        if (!acctInfo.isIsLeaf()) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection seleColl = new SelectorItemCollection();
            seleColl.add(new SelectorItemInfo("borrowerMainCashFlowItem"));
            seleColl.add(new SelectorItemInfo("borrowerAttCashFlowItem"));
            seleColl.add(new SelectorItemInfo("lenderMainCashFlowItem"));
            seleColl.add(new SelectorItemInfo("lenderAttCashFlowItem"));
            seleColl.add(new SelectorItemInfo("upper.borrowerMainCashFlowItem"));
            seleColl.add(new SelectorItemInfo("upper.borrowerAttCashFlowItem"));
            seleColl.add(new SelectorItemInfo("upper.lenderMainCashFlowItem"));
            seleColl.add(new SelectorItemInfo("upper.lenderAttCashFlowItem"));
            viewInfo.setSelector(seleColl);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(acctInfo.getLongNumber() + "!%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctInfo.getAccountTableID().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)acctInfo.getCompanyID().getId().toString()));
            viewInfo.setFilter(filter);
            acctCol = this.getAccountsByDAO(ctx, viewInfo);
        }
    }

    protected void setParentProperties(Context ctx, AccountViewInfo accountViewInfo, AccountViewInfo oldAcctInfo, AccountViewInfo parent) throws EASBizException, BOSException {
        if (accountViewInfo.getParent() == null) {
            accountViewInfo.setLevel(1);
            accountViewInfo.setLongName(accountViewInfo.getName());
            accountViewInfo.setLongName(accountViewInfo.getName(locale_L1), locale_L1);
            accountViewInfo.setLongName(accountViewInfo.getName(locale_L2), locale_L2);
            accountViewInfo.setLongName(accountViewInfo.getName(locale_L3), locale_L3);
            accountViewInfo.setLongNumber(accountViewInfo.getNumber());
            return;
        }
        if (accountViewInfo.getId() == null || accountViewInfo.getId().toString().length() < 1 || !this.exists(ctx, (IObjectPK)new ObjectUuidPK(accountViewInfo.getId()))) {
            if (parent.isIsCFreeze()) {
                throw new AccountException(AccountException.PARENTISFROZEWHENADDNEW);
            }
        } else {
            if (parent.isIsCFreeze()) {
                accountViewInfo.setIsCFreeze(parent.isIsCFreeze());
            }
            if (parent.isIsGFreeze()) {
                accountViewInfo.setIsGFreeze(parent.isIsGFreeze());
            }
            if (parent.isIsParentFreeze() || parent.isIsSelfFreeze()) {
                accountViewInfo.setIsParentFreeze(parent.isIsParentFreeze() || parent.isIsSelfFreeze());
            }
        }
        accountViewInfo.setAccountTypeID(parent.getAccountTypeID());
        accountViewInfo.setIsCash(parent.isIsCash());
        accountViewInfo.setIsBank(parent.isIsBank());
        accountViewInfo.setIsCashEquivalent(parent.isIsCashEquivalent());
        if (parent.getControl().getValue() != 0) {
            accountViewInfo.setControl(parent.getControl());
        }
        accountViewInfo.setPLType(parent.getPLType());
        accountViewInfo.setParentAA(parent.getCAA());
        if (accountViewInfo.getUpper() == null && accountViewInfo.getCAA() == null) {
            accountViewInfo.setCAA(parent.getCAA());
        }
        if (accountViewInfo.getParentAA() != null && accountViewInfo.getCAA() == null) {
            accountViewInfo.setCAA(accountViewInfo.getParentAA());
        }
        accountViewInfo.setLongNumber(parent.getLongNumber() + "!" + accountViewInfo.getNumber());
        accountViewInfo.setLongName(parent.getLongName() + "_" + accountViewInfo.getName());
        accountViewInfo.setLongName(parent.getLongName(locale_L1) + "_" + accountViewInfo.getName(locale_L1), locale_L1);
        accountViewInfo.setLongName(parent.getLongName(locale_L2) + "_" + accountViewInfo.getName(locale_L2), locale_L2);
        accountViewInfo.setLongName(parent.getLongName(locale_L3) + "_" + accountViewInfo.getName(locale_L3), locale_L3);
        if (parent.isIsQty()) {
            // empty if block
        }
        if (parent.isAC()) {
            accountViewInfo.setAC(true);
        }
        if (parent.isBw()) {
            accountViewInfo.setBw(true);
        }
        if (parent.isIsChangeCurrency()) {
            accountViewInfo.setIsChangeCurrency(true);
        }
        if (parent.isIsProfitCenter()) {
            accountViewInfo.setIsProfitCenter(true);
        }
        accountViewInfo.setDiffType(parent.getDiffType());
        if (accountViewInfo.getAccrualDirection() == null && parent.getAccrualDirection() != AccrualDirectionEnum.NOCONTROL) {
            accountViewInfo.setAccrualDirection(parent.getAccrualDirection());
        }
    }

    protected void attributeCheck(Context ctx, AccountViewInfo accountViewInfo, AccountViewInfo oldAcctInfo, boolean isAssign) throws EASBizException, BOSException {
        boolean isSelfConstructed;
        if (!isAssign) {
            this.updateMLName(ctx, accountViewInfo, oldAcctInfo);
            super._checkNameBlank(ctx, (IObjectValue)accountViewInfo);
            super._checkNumberBlank(ctx, (IObjectValue)accountViewInfo);
            if (accountViewInfo.getAccountTypeID() == null) {
                throw new AccountException(AccountException.ACCOUNT_TYPE_CANNOT_NULL);
            }
            this.checkNumberIsAppropriate(ctx, accountViewInfo);
            this.checkHelpCodeDup(ctx, accountViewInfo);
        }
        this._checkNumberDup(ctx, (IObjectValue)accountViewInfo);
        if (oldAcctInfo != null) {
            String originalParentId = null;
            String parentId = null;
            originalParentId = oldAcctInfo.getId().toString();
            parentId = accountViewInfo.getId().toString();
            if (!AccountTools.isStringEqual(parentId, originalParentId)) {
                throw new AccountException(AccountException.PARENT_POSITION_NOT_ALLOW_CHANGED);
            }
            this.checkGLevel(ctx, accountViewInfo);
        }
        this.checkCashBankCashEquivalentCashFlow(ctx, accountViewInfo);
        if (oldAcctInfo != null && accountViewInfo != null && accountViewInfo.getAccountTypeID() != null && oldAcctInfo.getAccountTypeID() != null && !accountViewInfo.getAccountTypeID().getId().toString().equals(oldAcctInfo.getAccountTypeID().getId().toString()) && !(isSelfConstructed = AccountTools.checkAccountTableIsSelfConstructed(ctx, accountViewInfo.getAccountTableID(), accountViewInfo.getCompanyID()))) {
            throw new AccountException(AccountException.ACCOUNTTYPECANTCHANGE);
        }
        if (accountViewInfo != null && oldAcctInfo != null) {
            accountViewInfo.setIsGFreeze(oldAcctInfo.isIsGFreeze());
            accountViewInfo.setIsParentFreeze(oldAcctInfo.isIsParentFreeze());
            accountViewInfo.setIsSelfFreeze(oldAcctInfo.isIsSelfFreeze());
            accountViewInfo.setIsCFreeze(oldAcctInfo.isIsCFreeze());
        }
    }

    private void checkGLevel(Context ctx, AccountViewInfo accountViewInfo) throws BOSException, AccountException {
        try {
            String sql = "select top 1 FGLevel,FCompanyID from t_bd_accountview where FUpperID =? order by FGLevel asc";
            IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{accountViewInfo.getId().toString()});
            if (rs.next()) {
                int mixGLevel = rs.getInt("FGLevel");
                String companyId = rs.getString("FCompanyID");
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("where id='" + companyId + "'");
                if (accountViewInfo.getGLevel() > mixGLevel) {
                    throw new AccountException(AccountException.CHANGE_GLEVEL_GREATER_THAN_INFERIOR, new Object[]{accountViewInfo.getNumber(), company.getName()});
                }
            }
        }
        catch (AccountException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void checkAsstacttype(Context ctx, AccountViewInfo accountViewInfo) {
    }

    protected void checkNumberIsAppropriate(Context ctx, AccountViewInfo accountViewInfo) {
    }

    protected void checkNameIsAppropriate(Context ctx, AccountViewInfo account) throws EASBizException {
        if (account.getName() != null && account.getName() != null && (account.getName().indexOf("(") != -1 || account.getName().indexOf(")") != -1)) {
            throw new EASBizException(new NumericExceptionSubItem("01", ResourceBase.getString((String)"com.kingdee.eas.basedata.master.account.ACCOUNTAutoGenerateResource", (String)"74_AccountViewControllerBean", (Locale)ctx.getLocale())));
        }
    }

    protected boolean isLeafGAHasDirectChildCA(Context ctx, AccountViewInfo account) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)(account.getNumber().trim() + "%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("companyID", null, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)account.getAccountTableID().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)account.getId().toString(), CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2 and #3");
        return this._exists(ctx, filter);
    }

    protected void checkCurrency(AccountViewInfo accountViewInfo) throws BOSException, EASBizException {
        if (accountViewInfo.getAccountingcurrency() == AccountingCurrencyEnum.ONECURRENCY) {
            if (accountViewInfo.getCurrencyID() == null) {
                throw new AccountException(AccountException.MUSTHASCURRENCY, new Object[]{accountViewInfo.getNumber()});
            }
        } else {
            accountViewInfo.setCurrencyID(null);
        }
    }

    protected void checkQuantity(AccountViewInfo accountViewInfo) throws BOSException, EASBizException {
        if (accountViewInfo.isIsQty()) {
            if (accountViewInfo.getMeasureUnitGroupID() == null) {
                throw new AccountException(AccountException.ISQTY_MEASUREGROUP);
            }
            if (accountViewInfo.getMeasureUnitID() == null) {
                throw new AccountException(AccountException.ISQTY_MEASUREUNIT);
            }
        } else {
            accountViewInfo.setMeasureUnitGroupID(null);
            accountViewInfo.setMeasureUnitID(null);
        }
    }

    protected void checkNumberCanBeModified(AccountViewInfo newModel, AccountViewInfo oldModel) throws EASBizException {
        if (!oldModel.isIsLeaf() && !newModel.getNumber().equals(oldModel.getNumber())) {
            throw new AccountException(AccountException.ISQTY_MEASUREUNIT);
        }
    }

    protected void checkAACM(Context ctx, AccountViewInfo accountViewInfo, AccountViewInfo oldAcctInfo, boolean isAssign) throws BOSException, EASBizException {
        ObjectUuidPK pkParent;
        ObjectUuidPK pkCompany;
        ObjectUuidPK pkUpper;
        IAsstAccount iAsstAccount;
        if (accountViewInfo.getCAA() != null) {
            try {
                String fcontrolunitid;
                String sqlToGetInferiorParent = "SELECT c.fcontrolunitid from t_bd_asstactgroupdetail a,t_bd_asstacttype b ,t_bd_generalasstacttypegroup c where a.fasstacttypeid=b.fid and b.fglasstacttypegrpid=c.fid and a.fasstaccountid=? and c.fsharetactic=3 ";
                IRowSet rsToGetInferiorParent = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetInferiorParent, (Object[])new Object[]{accountViewInfo.getCAA().getId().toString()});
                if (rsToGetInferiorParent != null && rsToGetInferiorParent.next() && !(fcontrolunitid = rsToGetInferiorParent.getString("fcontrolunitid")).equalsIgnoreCase(accountViewInfo.getCU().getId().toString())) {
                    throw new AccountException(AccountException.CAAINCLUDENOTCUASST, new Object[]{accountViewInfo.getNumber()});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (accountViewInfo.getGAA() != null && accountViewInfo.getCAA() == null) {
            throw new AccountException(AccountException.CAANOTINCLUDEGAA, new Object[]{accountViewInfo.getNumber()});
        }
        if (accountViewInfo.getGAA() != null && accountViewInfo.getCAA() != null && !(iAsstAccount = AsstAccountFactory.getLocalInstance((Context)ctx)).compare((IObjectPK)(pkUpper = new ObjectUuidPK(accountViewInfo.getGAA().getId())), (IObjectPK)(pkCompany = new ObjectUuidPK(accountViewInfo.getCAA().getId())))) {
            throw new AccountException(AccountException.CAANOTINCLUDEGAA, new Object[]{accountViewInfo.getNumber()});
        }
        if (accountViewInfo.getParentAA() != null && accountViewInfo.getCAA() == null) {
            throw new AccountException(AccountException.CAANOTINCLUDEPARENTAA, new Object[]{accountViewInfo.getNumber()});
        }
        if (accountViewInfo.getParentAA() != null && accountViewInfo.getCAA() != null && !(iAsstAccount = AsstAccountFactory.getLocalInstance((Context)ctx)).compare((IObjectPK)(pkParent = new ObjectUuidPK(accountViewInfo.getParentAA().getId())), (IObjectPK)(pkCompany = new ObjectUuidPK(accountViewInfo.getCAA().getId())))) {
            if (!isAssign) {
                throw new AccountException(AccountException.CAANOTINCLUDEPARENTAA, new Object[]{accountViewInfo.getNumber()});
            }
            AsstAccountInfo asstAccountInfo = null;
            String sqlToGetDirectChild = "SELECT FCAA FROM T_BD_ACCOUNTVIEW WHERE FCAA IS NOT NULL AND FID = ?";
            IRowSet rsToGetDirectChild = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetDirectChild, (Object[])new Object[]{accountViewInfo.getParent().getId().toString()});
            try {
                if (rsToGetDirectChild.next()) {
                    String acctCaa = rsToGetDirectChild.getString("FCAA");
                    asstAccountInfo = new AsstAccountInfo();
                    asstAccountInfo.setId(BOSUuid.read((String)acctCaa));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            accountViewInfo.setCAA(asstAccountInfo);
        }
        boolean hasChanged = false;
        if (oldAcctInfo == null || EqualsUtil.equals((Object)accountViewInfo.getCAA(), (Object)oldAcctInfo.getCAA())) {
            return;
        }
        if (oldAcctInfo != null && accountViewInfo.getCAA() != null && oldAcctInfo.getCAA() == null || accountViewInfo.getCAA() == null && oldAcctInfo.getCAA() != null || accountViewInfo.getCAA() != null && oldAcctInfo.getCAA() != null && !accountViewInfo.getCAA().getId().toString().equals(oldAcctInfo.getCAA().getId().toString())) {
            String sql = "delete from T_BD_AsstActCashFlowItemMap where FAccountID = ?";
            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{accountViewInfo.getId().toString()});
        }
        if (oldAcctInfo != null && accountViewInfo.getCAA() != null && oldAcctInfo.getCAA() == null || accountViewInfo.getCAA() != null && oldAcctInfo.getCAA() != null && !accountViewInfo.getCAA().getId().toString().equals(oldAcctInfo.getCAA().getId().toString())) {
            hasChanged = true;
        }
        if (!hasChanged) {
            return;
        }
        if (oldAcctInfo != null && accountViewInfo.getId() != null && accountViewInfo.getId().toString().length() > 0) {
            this.checkChildAndInferiorAA(ctx, accountViewInfo);
        }
    }

    protected void checkChildAndInferiorAA(Context ctx, AccountViewInfo accountViewInfo) throws BOSException, EASBizException, AccountException {
        if (accountViewInfo == null || accountViewInfo.getId() == null) {
            return;
        }
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" select FAsstActTypeID from T_BD_AsstActGroupDetail ").append(" where FAsstAccountID  = ? ");
            StringBuffer asstActTypeIDSet = new StringBuffer();
            IRowSet rsToGetDirectChild = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{accountViewInfo.getCAA().getId().toString()});
            int asstActTypeIDCount = 0;
            String asstActTypeID = null;
            while (rsToGetDirectChild != null && rsToGetDirectChild.next()) {
                if (asstActTypeIDCount > 0) {
                    asstActTypeIDSet.append(",");
                }
                asstActTypeID = rsToGetDirectChild.getString("FAsstActTypeID");
                asstActTypeIDSet.append("'").append(asstActTypeID).append("'");
                ++asstActTypeIDCount;
            }
            if (asstActTypeIDCount == 0) {
                return;
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)accountViewInfo.getAccountTableID().getId().toString()));
            CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(accountViewInfo.getCompanyID().getId()));
            filter.getFilterItems().add(new FilterItemInfo("companyID.longNumber", (Object)companyOrgUnitInfo.getLongNumber()));
            filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(accountViewInfo.getLongNumber() + "!%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("companyID.longNumber", (Object)(companyOrgUnitInfo.getLongNumber() + "!%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(accountViewInfo.getLongNumber() + "%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("CAA", null, CompareType.NOTEQUALS));
            filter.setMaskString("#0 and ((#1 and #2) or (#3 and #4)) and #5");
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            view.setSelector(selector);
            SorterItemCollection coll = new SorterItemCollection();
            coll.add(new SorterItemInfo("companyID"));
            coll.add(new SorterItemInfo("number"));
            view.setSorter(coll);
            AccountViewCollection childAndInferiorAccountColl = this.getAccountViewCollection(ctx, view);
            if (childAndInferiorAccountColl == null || childAndInferiorAccountColl.size() == 0) {
                return;
            }
            StringBuffer childAndInferiorAccoutIDSet = new StringBuffer();
            AccountViewInfo childOrInferiorAccountInfo = null;
            int count = childAndInferiorAccountColl.size();
            for (int i = 0; i < count; ++i) {
                childOrInferiorAccountInfo = childAndInferiorAccountColl.get(i);
                if (i > 0) {
                    childAndInferiorAccoutIDSet.append(",");
                }
                childAndInferiorAccoutIDSet.append("'").append(childOrInferiorAccountInfo.getId().toString()).append("'");
            }
            StringBuffer checkChildAndInferiorAASQL = new StringBuffer();
            checkChildAndInferiorAASQL.append(" select fid from t_bd_accountview  ");
            checkChildAndInferiorAASQL.append(" where fid in(").append(childAndInferiorAccoutIDSet).append(") ");
            checkChildAndInferiorAASQL.append(" and fid not in( ");
            checkChildAndInferiorAASQL.append(" select av.fid  from t_bd_accountview av, T_BD_AsstActGroupDetail aagd ");
            checkChildAndInferiorAASQL.append(" where av.fcaa = aagd.FAsstAccountID and ");
            checkChildAndInferiorAASQL.append(" av.fid in (").append(childAndInferiorAccoutIDSet).append(") and ");
            checkChildAndInferiorAASQL.append(" aagd.FAsstActTypeID in (").append(asstActTypeIDSet).append(") ");
            checkChildAndInferiorAASQL.append(" group by av.fid  having count(*) =").append(asstActTypeIDCount).append(" ");
            checkChildAndInferiorAASQL.append(" ) ");
            IRowSet checkFailAccountIDSet = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)checkChildAndInferiorAASQL.toString());
            if (checkFailAccountIDSet != null && checkFailAccountIDSet.next()) {
                String checkFailAccountID = checkFailAccountIDSet.getString("fid");
                selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("companyid.number");
                AccountViewInfo checkFailAccountInfo = this.getAccountViewInfo(ctx, (IObjectPK)new ObjectUuidPK(checkFailAccountID), selector);
                throw new AccountException(AccountException.COPANYCAANOTINCLUDE, new Object[]{checkFailAccountInfo.getCompanyID().getNumber(), checkFailAccountInfo.getNumber(), accountViewInfo.getNumber()});
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected void checkInferiorAA(Context ctx, AccountViewInfo accountViewInfo) throws BOSException, EASBizException, AccountException {
        EntityViewInfo eviForInferior = new EntityViewInfo();
        eviForInferior.getSelector().add("number");
        eviForInferior.getSelector().add("CAA");
        eviForInferior.getSelector().add("accountTableID");
        eviForInferior.getSelector().add("CU.id");
        eviForInferior.getSelector().add("CU.number");
        eviForInferior.getSelector().add("companyID.id");
        eviForInferior.getSelector().add("companyID.number");
        FilterInfo filterForInferior = new FilterInfo();
        eviForInferior.setFilter(filterForInferior);
        filterForInferior.getFilterItems().add(new FilterItemInfo("upper", (Object)accountViewInfo.getId().toString()));
        AccountViewCollection inferiors = this.getAccountsByDAO(ctx, eviForInferior);
        if (inferiors != null) {
            int count = inferiors.size();
            for (int i = 0; i < count; ++i) {
                AccountViewInfo inferior = inferiors.get(i);
                if (inferior.getCAA() == null && accountViewInfo.getCAA() != null) {
                    inferior.setCAA(accountViewInfo.getCAA());
                    this.checkChildAA(ctx, inferior);
                    this.checkInferiorAA(ctx, inferior);
                    continue;
                }
                if (inferior.getCAA() == null || accountViewInfo.getCAA() == null) continue;
                IAsstAccount iAsstAccount = AsstAccountFactory.getLocalInstance((Context)ctx);
                ObjectUuidPK pkInferior = new ObjectUuidPK(inferior.getCAA().getId());
                ObjectUuidPK pkCompany = new ObjectUuidPK(accountViewInfo.getCAA().getId());
                if (iAsstAccount.compare((IObjectPK)pkCompany, (IObjectPK)pkInferior)) continue;
                throw new AccountException(AccountException.INFERIORACCTNOTINCLUDECAA, new Object[]{this.getCompanyNumber(ctx, inferior.getCompanyID()), inferior.getNumber(), accountViewInfo.getNumber()});
            }
        }
    }

    protected void checkChildAA(Context ctx, AccountViewInfo accountViewInfo) throws BOSException, EASBizException, AccountException {
        IAsstAccount iAsstAccount = AsstAccountFactory.getLocalInstance((Context)ctx);
        String sqlToGetDirectChild = "SELECT FNUMBER, FCAA FROM T_BD_ACCOUNTVIEW WHERE FCAA IS NOT NULL AND FPARENTID = ?";
        IRowSet rsToGetDirectChild = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetDirectChild, (Object[])new Object[]{accountViewInfo.getId().toString()});
        try {
            while (rsToGetDirectChild.next()) {
                String acctNumber = rsToGetDirectChild.getString("FNUMBER");
                String acctCaa = rsToGetDirectChild.getString("FCAA");
                if (iAsstAccount.compare((IObjectPK)new ObjectUuidPK(accountViewInfo.getCAA().getId()), (IObjectPK)new ObjectUuidPK(acctCaa))) continue;
                throw new AccountException(AccountException.CHILDACCTCAANOTINCLUDECAA, new Object[]{this.getCompanyNumber(ctx, accountViewInfo.getCompanyID()), acctNumber, accountViewInfo.getNumber()});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String sqlToGetChildNeedCheckAA = "SELECT CHILD.FNUMBER, CHILD.FCAA FROM T_BD_ACCOUNTVIEW CHILD INNER JOIN T_BD_ACCOUNTVIEW PARENT ON CHILD.FPARENTID = PARENT.FID WHERE CHILD.FNUMBER LIKE ? AND CHILD.FNUMBER != ? AND CHILD.FCompanyID = ? AND CHILD.FACCOUNTTABLEID = ? AND CHILD.FCAA IS NOT NULL AND PARENT.FCAA IS NULL";
        IRowSet rsToGetChildNeedCheckAA = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetChildNeedCheckAA, (Object[])new Object[]{accountViewInfo.getNumber() + "%", accountViewInfo.getNumber(), accountViewInfo.getCompanyID().getId().toString(), accountViewInfo.getAccountTableID().getId().toString()});
        try {
            while (rsToGetChildNeedCheckAA.next()) {
                String acctNumber = rsToGetChildNeedCheckAA.getString("FNUMBER");
                String acctCaa = rsToGetChildNeedCheckAA.getString("FCAA");
                if (iAsstAccount.compare((IObjectPK)new ObjectUuidPK(accountViewInfo.getCAA().getId()), (IObjectPK)new ObjectUuidPK(acctCaa))) continue;
                throw new AccountException(AccountException.CHILDACCTCAANOTINCLUDECAA, new Object[]{this.getCompanyNumber(ctx, accountViewInfo.getCompanyID()), acctNumber, accountViewInfo.getNumber()});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected String getCuNumber(Context ctx, CtrlUnitInfo specifyCu) {
        String cuNumber = specifyCu.getNumber();
        if (cuNumber == null || cuNumber.length() == 0) {
            String sqlToGetCuNumber = "SELECT TOP 1 FNUMBER FROM T_ORG_CTRLUNIT WHERE FID = ?";
            try {
                IRowSet rsToGetCuNumber = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetCuNumber, (Object[])new Object[]{specifyCu.getId().toString()});
                if (rsToGetCuNumber != null && rsToGetCuNumber.next()) {
                    cuNumber = rsToGetCuNumber.getString("FNUMBER");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cuNumber == null) {
            cuNumber = "";
        }
        return cuNumber;
    }

    protected String getCompanyNumber(Context ctx, CompanyOrgUnitInfo specifyCompany) {
        String companyNumber = specifyCompany.getNumber();
        if (companyNumber == null || companyNumber.length() == 0) {
            String sqlToGetCompanyNumber = "SELECT TOP 1 FNUMBER FROM T_ORG_Company WHERE FID = ?";
            try {
                IRowSet rsToGetCompanyNumber = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetCompanyNumber, (Object[])new Object[]{specifyCompany.getId().toString()});
                if (rsToGetCompanyNumber != null && rsToGetCompanyNumber.next()) {
                    companyNumber = rsToGetCompanyNumber.getString("FNUMBER");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (companyNumber == null) {
            companyNumber = "";
        }
        return companyNumber;
    }

    protected String getParentNum(AccountViewInfo model, AccountTableInfo table) {
        String num;
        block2: {
            int levelLen;
            int len;
            int index;
            block1: {
                num = null;
                index = 0;
                len = 0;
                levelLen = 0;
                if (!table.isIsUseSeparator()) break block1;
                index = model.getNumber().lastIndexOf(table.getSeparator());
                if (index <= 0) break block2;
                num = model.getNumber().substring(0, index);
                break block2;
            }
            for (int i = 0; i < table.getUserLevel().size(); ++i) {
                if ((len += table.getUserLevel().get(i).getLength()) != model.getNumber().length()) continue;
                index = i;
                levelLen = len - table.getUserLevel().get(i).getLength();
                num = model.getNumber().substring(0, levelLen);
                break;
            }
        }
        return num;
    }

    protected void checkAuxacct(Context ctx, AccountViewInfo aModel, AccountViewInfo cModel) throws BOSException, EASBizException {
        IAsstAccount iAsstAccount = AsstAccountFactory.getLocalInstance((Context)ctx);
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo orgUnitInfo = null;
        if (cModel.getCompanyID() != null) {
            orgUnitInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(cModel.getCompanyID().getId()));
        }
        if (orgUnitInfo != null) {
            if (orgUnitInfo.isIsGroup()) {
                ObjectUuidPK pkComm = null;
                ObjectUuidPK pkCompany = null;
                if (aModel.getGAA() != null) {
                    pkComm = new ObjectUuidPK(aModel.getGAA().getId());
                }
                if (cModel.getCAA() != null) {
                    pkCompany = new ObjectUuidPK(cModel.getCAA().getId());
                }
                if (!iAsstAccount.compare((IObjectPK)pkComm, pkCompany)) {
                    throw new AccountException(AccountException.NOT_INCLUDE_ASST, new Object[]{aModel.getNumber()});
                }
            } else {
                ObjectUuidPK pkComm = null;
                ObjectUuidPK pkCompany = null;
                if (cModel.getGAA() != null) {
                    pkComm = new ObjectUuidPK(cModel.getGAA().getId());
                }
                if (cModel.getCAA() != null) {
                    pkCompany = new ObjectUuidPK(cModel.getCAA().getId());
                }
                if (!iAsstAccount.compare((IObjectPK)pkComm, pkCompany)) {
                    throw new AccountException(AccountException.NOT_INCLUDE_ASST, new Object[]{aModel.getNumber()});
                }
            }
        } else {
            return;
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, IObjectPK companyID) throws BOSException, EASBizException {
        AccountViewInfo model = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("account", (Object)pk.toString().trim()));
        filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)companyID.toString().trim()));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("currencyID"));
        evi.getSelector().add(new SelectorItemInfo("companyID"));
        evi.getSelector().add(new SelectorItemInfo("account"));
        evi.getSelector().add(new SelectorItemInfo("accountTableID"));
        evi.getSelector().add(new SelectorItemInfo("accountTableID"));
        evi.getSelector().add(new SelectorItemInfo("GAA"));
        evi.getSelector().add(new SelectorItemInfo("CAA"));
        evi.getSelector().add(new SelectorItemInfo("measureUnitGroupID"));
        evi.getSelector().add(new SelectorItemInfo("measureUnitID"));
        evi.getSorter().add(new SorterItemInfo("number"));
        AccountViewCollection account_Companys = this.getAccountsByDAO(ctx, evi);
        if (account_Companys.size() > 0) {
            model = account_Companys.get(0);
        }
        return model;
    }

    @Override
    protected void _addAccountByCompany(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        switch (this.getEASModeValue(ctx)) {
            case 0: {
                break;
            }
            case 1: {
                this.copyAccountsByCompanyDM(ctx, companyPK);
            }
        }
    }

    protected void copyAccountsByCompanyDM(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        company = iCompanyOrgUnit.getCompanyOrgUnitInfo(companyPK);
        AccountTools.checkCompanyAccountTable(ctx, company);
        ObjectUuidPK tablePK = new ObjectUuidPK(company.getAccountTable().getId());
        AccountTableInfo table = this.getAccountTableInfo(ctx, (IObjectPK)tablePK);
        CompanyOrgUnitCollection companys = this.getCompanysByAccountTable(ctx, (IObjectPK)tablePK);
        CompanyOrgUnitInfo anyCompany = null;
        for (int i = 0; i < companys.size(); ++i) {
            if (companys.get(i).getId().toString().equals(companyPK.toString())) continue;
            anyCompany = companys.get(i);
        }
        if (anyCompany != null) {
            String sql = "select FID from t_bd_accountView where FAccountTableID=? and FCompanyID=? ORDER BY FNumber";
            IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{tablePK.toString(), anyCompany.getId().toString()});
            int count = 0;
            try {
                rs.last();
                count = rs.getRow();
                rs.first();
                rs.previous();
                for (int i = 0; i < count; ++i) {
                    if (!rs.next()) continue;
                    String parentnumber = null;
                    String id = rs.getString("FID");
                    AccountViewInfo account = (AccountViewInfo)super._getValue(ctx, (IObjectPK)new ObjectUuidPK(id));
                    account.remove("id");
                    account.setCompanyID(company);
                    account.setCU(company.getCU());
                    if (account.getParent() != null) {
                        parentnumber = this.getParentNum(account, table);
                        AccountViewInfo parent = this.getAccountByNumber(ctx, (IObjectPK)tablePK, companyPK, parentnumber);
                        account.setParent(parent);
                    }
                    this.innerAddnew(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.create((BOSObjectType)account.getBOSType())), (IObjectValue)account);
                }
            }
            catch (SQLException err) {
                throw new BOSException((Throwable)err);
            }
        }
    }

    @Override
    protected void _addAccountByCompany(Context ctx, IObjectValue companyInfo) throws BOSException, EASBizException {
    }

    protected boolean isObjectBaseInfoEqual(ObjectBaseInfo obj1, ObjectBaseInfo obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        return obj1 != null && obj2 != null && obj1.getId().toString().equals(obj2.getId().toString());
    }

    @Override
    protected void _updateCompanyAccout(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        switch (this.getEASModeValue(ctx)) {
            case 0: {
                this.updateCompanyAccoutCM(ctx, pk, model);
                break;
            }
            case 1: {
                this.updateCompanyAccoutDM(ctx, pk, model);
            }
        }
    }

    protected void updateCompanyAccoutCM(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AccountViewInfo account = (AccountViewInfo)model;
        AccountViewInfo oldModel = (AccountViewInfo)super._getValue(ctx, pk);
        String newNumber = account.getNumber();
        String newName = account.getName();
        super._checkNumberBlank(ctx, (IObjectValue)account);
        this._checkNumberDup(ctx, (IObjectValue)account);
        if (oldModel.getParent() != null) {
            AccountViewInfo parent = (AccountViewInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(oldModel.getParent().getId()));
            this.setPropertiesByParent(account, parent);
        }
        if (oldModel.getCompanyID() == null || oldModel.getLevel() <= oldModel.getGLevel()) {
            // empty if block
        }
        if (!this.isObjectBaseInfoEqual((ObjectBaseInfo)account.getCompanyID(), (ObjectBaseInfo)oldModel.getCompanyID())) {
            throw new AccountException(AccountException.COMPANY_BELONGED_NOT_ALLOW_MODIFIED);
        }
        IAccountTable iacctTable = AccountTableFactory.getLocalInstance(ctx);
        AccountTableInfo table = iacctTable.getAccountTableInfo((IObjectPK)new ObjectUuidPK(account.getAccountTableID().getId()));
        this.setGroupCtronlProperties(table, oldModel, account);
        account.setIsGFreeze(oldModel.isIsGFreeze());
        account.setIsCFreeze(oldModel.isIsCFreeze());
        this.checkParentNodeChanged(table, account, oldModel);
        if (!account.getName().equals(oldModel.getName())) {
            if (account.getParent() == null) {
                this.setLongName(ctx, null, account);
            } else {
                this.setLongName(ctx, (IObjectPK)new ObjectUuidPK(account.getParent().getId()), account);
            }
        }
        this._update(ctx, pk, (IObjectValue)account);
        if (!newName.equals(oldModel.getName())) {
            AccountViewInfo updatedModel = (AccountViewInfo)this._getValue(ctx, pk);
            this.commonSynchronizeLongName(ctx, oldModel, updatedModel, updatedModel.getCompanyID().getId().toString());
        }
        if (!newNumber.equals(oldModel.getNumber())) {
            this.commonSynchronizeNumber(ctx, newNumber, oldModel, oldModel.getCompanyID().getId().toString());
        }
    }

    protected void updateCompanyAccoutDM(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._updateDisperseModeAccount(ctx, pk, model);
    }

    protected AccountTableInfo commonUpdateCheck(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AccountViewInfo account = (AccountViewInfo)model;
        AccountViewInfo oldModel = (AccountViewInfo)super._getValue(ctx, pk);
        if (!this.isObjectBaseInfoEqual((ObjectBaseInfo)account.getCompanyID(), (ObjectBaseInfo)oldModel.getCompanyID())) {
            throw new AccountException(AccountException.COMPANY_BELONGED_NOT_ALLOW_MODIFIED);
        }
        super._checkNameBlank(ctx, (IObjectValue)account);
        account.setNumber(oldModel.getNumber());
        this.checkPLType(ctx, account);
        this.checkCurrency(account);
        this.checkQuantity(account);
        this.commonCheckImpRestrict(account, oldModel);
        this.checkHasDeal(ctx, account, oldModel);
        this.checkHasBizReferrence(ctx, account, oldModel);
        if (account.getHelpCode() != null && !account.getHelpCode().trim().equals("") && oldModel.getHelpCode() != null && !account.getHelpCode().equals(oldModel.getHelpCode())) {
            this.checkHelpCodeDup(ctx, account);
        }
        IAccountTable iacctTable = AccountTableFactory.getLocalInstance(ctx);
        AccountTableInfo table = iacctTable.getAccountTableInfo((IObjectPK)new ObjectUuidPK(oldModel.getAccountTableID().getId()));
        this.checkParentNodeChanged(table, account, oldModel);
        if (!account.getName().equals(oldModel.getName())) {
            if (account.getParent() == null) {
                this.setLongName(ctx, null, account);
            } else {
                this.setLongName(ctx, (IObjectPK)new ObjectUuidPK(account.getParent().getId()), account);
            }
        }
        return table;
    }

    protected void checkPLType(Context ctx, AccountViewInfo account) throws AccountException, EASBizException, BOSException {
        AccountTypeInfo accountTypeInfo = null;
        accountTypeInfo = AccountTypeFactory.getLocalInstance(ctx).getAccountTypeInfo((IObjectPK)new ObjectUuidPK(account.getAccountTypeID().getId()));
        if (accountTypeInfo.getProperty() == AccountProperty.SUNYI || accountTypeInfo.getProperty() == AccountProperty.EXPENSE || accountTypeInfo.getProperty() == AccountProperty.REVENUE || accountTypeInfo.getProperty() == AccountProperty.BUDGET_OUTLAYS || accountTypeInfo.getProperty() == AccountProperty.BUDGET_RECEIPTS) {
            if (account.getPLType() == AccountPLType.NONE) {
                throw new AccountException(AccountException.PLTYPE_ACCOUNT_MUST_PLTYPE, new Object[]{account.getNumber()});
            }
        } else if (account.getPLType() != AccountPLType.NONE && accountTypeInfo.getProperty() != AccountProperty.PROFIT_CENTER) {
            throw new AccountException(AccountException.NOPLTYPEMUSTNONEPLTYPE, new Object[]{account.getNumber()});
        }
    }

    protected void updateCM(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        boolean isAddnewGrpAccount;
        this.commonUpdateCheck(ctx, pk, model);
        AccountViewInfo account = (AccountViewInfo)model;
        boolean bl = isAddnewGrpAccount = account.getGLevel() >= account.getLevel();
        if (isAddnewGrpAccount) {
            this.checkGroupAuxAccount(account);
        } else {
            this.checkCompanyAuxAccount(ctx, account);
        }
        super._update(ctx, pk, model);
    }

    protected void updateDM(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkCompanyAuxAccount(ctx, (AccountViewInfo)model);
        this.commonUpdateCheck(ctx, pk, model);
        super._update(ctx, pk, model);
    }

    protected void commonCheckImpRestrict(AccountViewInfo newModel, AccountViewInfo oldModel) throws EASBizException {
        if (!oldModel.isIsLeaf()) {
            if (oldModel.getAccountingcurrency().getValue() == AccountingCurrencyEnum.ALLCURRENCY.getValue() && newModel.getAccountingcurrency().getValue() == 1) {
                throw new AccountException(AccountException.ALL_CURRENCY_TO_ONE_CURRENCY_ILLEGAL);
            }
            if (!oldModel.isIsQty() && newModel.isIsQty()) {
                throw new AccountException(AccountException.NO_QTY_TO_QTY_ILLEGAL);
            }
            if (!oldModel.isAC() && newModel.isAC()) {
                throw new AccountException(AccountException.NO_AC_TO_AC_ILLEGAL);
            }
            if (!oldModel.isBw() && newModel.isBw()) {
                throw new AccountException(AccountException.NO_BW_TO_BW_ILLEGAL);
            }
            if (!oldModel.isIsCountAccrual() && newModel.isIsCountAccrual()) {
                throw new AccountException(AccountException.NO_INTEREST_TO_INTEREST_ILLEGAL);
            }
        }
    }

    protected boolean isAccountFirstPriorityPropertiesModidfied(AccountViewInfo newModel, AccountViewInfo oldModel) {
        if (newModel.isIsCashEquivalent() != oldModel.isIsCashEquivalent()) {
            return true;
        }
        if (newModel.isIsBank() != oldModel.isIsBank()) {
            return true;
        }
        if (newModel.isIsCash() != oldModel.isIsCash()) {
            return true;
        }
        if (!newModel.getAccountTypeID().getId().toString().equals(oldModel.getAccountTypeID().getId().toString())) {
            return true;
        }
        return newModel.getPLType().getValue() != oldModel.getPLType().getValue();
    }

    @Override
    protected void _updateDisperseModeAccount(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AccountViewInfo vo = (AccountViewInfo)model;
        AccountViewInfo oldModel = (AccountViewInfo)this._getValue(ctx, pk);
        String newNumber = vo.getNumber();
        String newName = vo.getName();
        if (oldModel.getParent() != null) {
            AccountViewInfo parent = (AccountViewInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(oldModel.getParent().getId()));
            this.setPropertiesByParent(vo, parent);
        }
        boolean isFirstLevelCPModified = this.isAccountFirstPriorityPropertiesModidfied(vo, oldModel);
        super._checkNumberBlank(ctx, (IObjectValue)vo);
        if (!vo.getNumber().equals(oldModel.getNumber())) {
            this._checkNumberDup(ctx, (IObjectValue)vo);
        }
        this._update(ctx, pk, (IObjectValue)vo);
        AccountViewInfo updatedModel = (AccountViewInfo)super._getValue(ctx, pk);
        AccountViewCollection accounts = this.getAccountsByNumber(ctx, (IObjectPK)new ObjectUuidPK(updatedModel.getAccountTableID().getId()), updatedModel.getNumber());
        for (int i = 0; i < accounts.size(); ++i) {
            AccountViewInfo account = accounts.get(i);
            if (account.getId().toString().equals(pk.toString())) continue;
            updatedModel.setId(account.getId());
            updatedModel.setCompanyID(account.getCompanyID());
            updatedModel.setCU(account.getCompanyID().getCU());
            updatedModel.setParent(account.getParent());
            this._update(ctx, (IObjectPK)new ObjectUuidPK(account.getId()), (IObjectValue)updatedModel);
        }
        if (isFirstLevelCPModified) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)oldModel.getAccountTableID().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)(oldModel.getNumber() + "%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)oldModel.getNumber(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2");
            evi.setFilter(filter);
            evi.getSorter().add(new SorterItemInfo("number"));
            accounts = this.getAccountsByDAO(ctx, evi);
            for (int i = 0; i < accounts.size(); ++i) {
                AccountViewInfo tmp = accounts.get(i);
                this.setFirstLevelControlPropertiesDM(updatedModel, tmp);
                this._update(ctx, (IObjectPK)new ObjectUuidPK(tmp.getId()), (IObjectValue)tmp);
            }
        }
        if (!newName.equals(oldModel.getName())) {
            updatedModel = (AccountViewInfo)this._getValue(ctx, pk);
            this.commonSynchronizeLongName(ctx, oldModel, updatedModel, updatedModel.getCompanyID().getId().toString());
        }
        if (!newNumber.equals(oldModel.getNumber())) {
            this.commonSynchronizeNumber(ctx, newNumber, oldModel, null);
        }
    }

    protected void setFirstLevelControlPropertiesDM(AccountViewInfo src, AccountViewInfo dest) {
        dest.setIsCashEquivalent(src.isIsCashEquivalent());
        dest.setIsBank(src.isIsBank());
        dest.setIsCash(src.isIsCash());
        dest.setAccountTypeID(src.getAccountTypeID());
        dest.setPLType(src.getPLType());
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        boolean isAllowEditAC;
        AccountViewInfo acctInfo = (AccountViewInfo)model;
        boolean isAc = acctInfo.isAC();
        AccountViewInfo oldAcctInfo = (AccountViewInfo)super._getValue(ctx, (IObjectPK)new ObjectUuidPK(acctInfo.getId().toString()));
        if (!this.isCUBDAllowEdit(ctx, acctInfo)) {
            throw new AccountException(AccountException.CUBD_CANNOT_EDIT);
        }
        this.checkIsInEnabledAcctref(ctx, (IObjectPK)new ObjectUuidPK(acctInfo.getId().toString()));
        AccountViewInfo parentInfo = null;
        if (oldAcctInfo.getParent() != null && oldAcctInfo.getParent().getId() != null && oldAcctInfo.getParent().getId().toString().length() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("accountTypeID.property");
            sic.add("accountCurrency.*");
            parentInfo = this.getAccountViewInfo(ctx, (IObjectPK)new ObjectUuidPK(oldAcctInfo.getParent().getId()), sic);
        }
        AccountViewInfo upperInfo = null;
        if (oldAcctInfo.getUpper() != null && oldAcctInfo.getUpper().getId() != null && oldAcctInfo.getUpper().getId().toString().length() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("accountTypeID.property");
            sic.add("accountCurrency.*");
            upperInfo = this.getAccountViewInfo(ctx, (IObjectPK)new ObjectUuidPK(oldAcctInfo.getUpper().getId()), sic);
            acctInfo.setUpper(upperInfo);
        }
        this.attributeCheck(ctx, acctInfo, oldAcctInfo, false);
        this.setPropertiesWhenHasDeal(ctx, acctInfo, oldAcctInfo, parentInfo);
        this.setPropertiesWhenHasInferior(ctx, acctInfo, oldAcctInfo);
        this.setParentProperties(ctx, acctInfo, oldAcctInfo, parentInfo);
        this.setUpperProperties(ctx, acctInfo, oldAcctInfo, upperInfo, false);
        this.setPropertiesAccordToOtherRule(ctx, acctInfo, oldAcctInfo, false);
        if (acctInfo.getControl() != AccountControlAttribute.NONE && acctInfo.getControl() != oldAcctInfo.getControl() && (acctInfo.getControl() == AccountControlAttribute.AP || acctInfo.getControl() == AccountControlAttribute.AR)) {
            CommonServerUtils.isARAPAccount(ctx, acctInfo.getCompanyID().getId().toString(), acctInfo.getAccountTableID().getId().toString(), acctInfo.getId().toString(), acctInfo.getControl().getValue());
        }
        if (isAc && !oldAcctInfo.isAC() && (isAllowEditAC = this._isAllowEditAC(ctx, (IObjectValue)ContextUtil.getCurrentFIUnit((Context)ctx), (IObjectValue)acctInfo))) {
            acctInfo.setAC(isAc);
            GLFlagProcessFactory.getGLFlagProcessInstance().setCussentInitClosed(ctx, new String[]{acctInfo.getId().toString()}, new boolean[]{false}, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        }
        super._update(ctx, pk, (IObjectValue)acctInfo);
        if (!(acctInfo.getCAA() == null || oldAcctInfo.getCAA() != null && oldAcctInfo.getCAA().getId().equals((Object)acctInfo.getCAA().getId()))) {
            this.handleAstInitClosed(ctx, acctInfo);
        }
        CommonServerUtils.updateArApContrastAccount(ctx, acctInfo.getCompanyID().getId().toString(), acctInfo.getAccountTableID().getId().toString(), acctInfo.getId().toString());
        boolean isProfitCenterChanged = this.isProfitCenterChanged(acctInfo, oldAcctInfo);
        this.synchronizeChildProperties(ctx, acctInfo, oldAcctInfo, isProfitCenterChanged);
        this.synchronizeInferiorProperties(ctx, acctInfo, acctInfo.getCompanyID(), oldAcctInfo, false, isProfitCenterChanged);
        acctInfo.setRefId(null);
        PinYinHelper.generatePinYin((Context)ctx, (String)"com.kingdee.eas.basedata.master.account.app.AccountView", (String[])pk.toString().split(""));
    }

    protected void synchronizeAA(Context ctx, AccountViewInfo acctInfo) {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void synchronizeInferiorProperties(Context ctx, AccountViewInfo acctInfo, CompanyOrgUnitInfo currentCompany, AccountViewInfo oldAcctInfo, boolean needSyn, boolean isProfitCenterChanged) throws BOSException, EASBizException {
        if (acctInfo == null) return;
        boolean hasChanged = false;
        if (needSyn) {
            hasChanged = true;
        } else {
            if (oldAcctInfo == null) {
                oldAcctInfo = (AccountViewInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(acctInfo.getId().toString()));
            }
            if (!acctInfo.getNumber().equals(oldAcctInfo.getNumber()) || !acctInfo.getName(LocaleUtils.locale_L1).equals(oldAcctInfo.getName(LocaleUtils.locale_L1)) || !acctInfo.getName(LocaleUtils.locale_L2).equals(oldAcctInfo.getName(LocaleUtils.locale_L2)) || !acctInfo.getName(LocaleUtils.locale_L3).equals(oldAcctInfo.getName(LocaleUtils.locale_L3)) || !acctInfo.getAccountTypeID().getId().toString().equals(oldAcctInfo.getAccountTypeID().getId().toString()) || acctInfo.isIsCash() != oldAcctInfo.isIsCash() || acctInfo.isIsBank() != oldAcctInfo.isIsBank() || acctInfo.isIsCashEquivalent() != oldAcctInfo.isIsCashEquivalent() || acctInfo.getPLType().getValue() != oldAcctInfo.getPLType().getValue() || acctInfo.getControl().getValue() != oldAcctInfo.getControl().getValue() || acctInfo.getDC().getValue() != oldAcctInfo.getDC().getValue() || acctInfo.getAccountingcurrency().getValue() != oldAcctInfo.getAccountingcurrency().getValue() || acctInfo.isIsQty() && !oldAcctInfo.isIsQty() || acctInfo.isAC() && !oldAcctInfo.isAC() || acctInfo.isACNotice() && !oldAcctInfo.isACNotice() || acctInfo.isBw() != oldAcctInfo.isBw() || acctInfo.isIsChangeCurrency() && !oldAcctInfo.isIsChangeCurrency() || isProfitCenterChanged || acctInfo.getCAA() == null && oldAcctInfo.getCAA() != null || acctInfo.getCAA() != null && oldAcctInfo.getCAA() == null || acctInfo.getCAA() != null && oldAcctInfo.getCAA() != null && !acctInfo.getCAA().getId().toString().equals(oldAcctInfo.getCAA().getId().toString()) || this.compareAccountCurrency(acctInfo, oldAcctInfo) != 0 || acctInfo.getBorrowerMainCashFlowItem() != null && oldAcctInfo.getBorrowerMainCashFlowItem() == null || acctInfo.getBorrowerMainCashFlowItem() == null && oldAcctInfo.getBorrowerMainCashFlowItem() != null || acctInfo.getBorrowerMainCashFlowItem() != null && oldAcctInfo.getBorrowerMainCashFlowItem() != null && !acctInfo.getBorrowerMainCashFlowItem().getId().toString().equals(oldAcctInfo.getBorrowerMainCashFlowItem().getId().toString()) || acctInfo.getBorrowerAttCashFlowItem() != null && oldAcctInfo.getBorrowerAttCashFlowItem() == null || acctInfo.getBorrowerAttCashFlowItem() == null && oldAcctInfo.getBorrowerAttCashFlowItem() != null || acctInfo.getBorrowerAttCashFlowItem() != null && oldAcctInfo.getBorrowerAttCashFlowItem() != null && !acctInfo.getBorrowerAttCashFlowItem().getId().toString().equals(oldAcctInfo.getBorrowerAttCashFlowItem().getId().toString()) || acctInfo.getLenderAttCashFlowItem() != null && oldAcctInfo.getLenderAttCashFlowItem() == null || acctInfo.getLenderAttCashFlowItem() == null && oldAcctInfo.getLenderAttCashFlowItem() != null || acctInfo.getLenderAttCashFlowItem() != null && oldAcctInfo.getLenderAttCashFlowItem() != null && !acctInfo.getLenderAttCashFlowItem().getId().toString().equals(oldAcctInfo.getLenderAttCashFlowItem().getId().toString()) || acctInfo.getLenderMainCashFlowItem() != null && oldAcctInfo.getLenderMainCashFlowItem() == null || acctInfo.getLenderMainCashFlowItem() == null && oldAcctInfo.getLenderMainCashFlowItem() != null || acctInfo.getLenderMainCashFlowItem() != null && oldAcctInfo.getLenderMainCashFlowItem() != null && !acctInfo.getLenderMainCashFlowItem().getId().toString().equals(oldAcctInfo.getLenderMainCashFlowItem().getId().toString()) || !acctInfo.getDiffType().equals((Object)oldAcctInfo.getDiffType())) {
                hasChanged = true;
            }
        }
        if (!hasChanged) {
            return;
        }
        if (acctInfo.isIsCash() != oldAcctInfo.isIsCash() || acctInfo.isIsBank() != oldAcctInfo.isIsBank() || acctInfo.isIsCashEquivalent() != oldAcctInfo.isIsCashEquivalent()) {
            this.checkInferiorMainAttItem(ctx, acctInfo);
            if (acctInfo.isIsCash() != oldAcctInfo.isIsCash()) {
                this.updateInferiorCash(ctx, acctInfo);
            }
        }
        if (acctInfo.getBorrowerMainCashFlowItem() != null && oldAcctInfo.getBorrowerMainCashFlowItem() == null || acctInfo.getBorrowerMainCashFlowItem() == null && oldAcctInfo.getBorrowerMainCashFlowItem() != null || acctInfo.getBorrowerMainCashFlowItem() != null && oldAcctInfo.getBorrowerMainCashFlowItem() != null && !acctInfo.getBorrowerMainCashFlowItem().getId().toString().equals(oldAcctInfo.getBorrowerMainCashFlowItem().getId().toString()) || acctInfo.getBorrowerAttCashFlowItem() != null && oldAcctInfo.getBorrowerAttCashFlowItem() == null || acctInfo.getBorrowerAttCashFlowItem() == null && oldAcctInfo.getBorrowerAttCashFlowItem() != null || acctInfo.getBorrowerAttCashFlowItem() != null && oldAcctInfo.getBorrowerAttCashFlowItem() != null && !acctInfo.getBorrowerAttCashFlowItem().getId().toString().equals(oldAcctInfo.getBorrowerAttCashFlowItem().getId().toString()) || acctInfo.getLenderAttCashFlowItem() != null && oldAcctInfo.getLenderAttCashFlowItem() == null || acctInfo.getLenderAttCashFlowItem() == null && oldAcctInfo.getLenderAttCashFlowItem() != null || acctInfo.getLenderAttCashFlowItem() != null && oldAcctInfo.getLenderAttCashFlowItem() != null && !acctInfo.getLenderAttCashFlowItem().getId().toString().equals(oldAcctInfo.getLenderAttCashFlowItem().getId().toString()) || acctInfo.getLenderMainCashFlowItem() != null && oldAcctInfo.getLenderMainCashFlowItem() == null || acctInfo.getLenderMainCashFlowItem() == null && oldAcctInfo.getLenderMainCashFlowItem() != null || acctInfo.getLenderMainCashFlowItem() != null && oldAcctInfo.getLenderMainCashFlowItem() != null && !acctInfo.getLenderMainCashFlowItem().getId().toString().equals(oldAcctInfo.getLenderMainCashFlowItem().getId().toString())) {
            this.checkInferiorCashProperties(ctx, acctInfo);
        }
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentCompany.getId()));
        if (!acctInfo.getNumber().equals(oldAcctInfo.getNumber()) || !acctInfo.getName().equals(oldAcctInfo.getName())) {
            this.chkInfeCompanyDupAccount(ctx, acctInfo, oldAcctInfo);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctInfo.getAccountTableID().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("companyID.longNumber", (Object)(companyOrgUnitInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)oldAcctInfo.getNumber()));
        filter.getFilterItems().add(new FilterItemInfo("upper.id", null, CompareType.NOTEQUALS));
        try {
            String notLikeSql = this.getNotLikeSql(ctx, acctInfo);
            String companySql = "select fid from T_ORG_Company where (flongnumber ='" + companyOrgUnitInfo.getLongNumber() + "' or flongnumber like '" + companyOrgUnitInfo.getLongNumber() + "!%') " + notLikeSql.toString() + ")";
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companySql, CompareType.INNER));
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        selector.add("id");
        selector.add("number");
        selector.add("longNumber");
        selector.add("longName");
        selector.add("CAA.id");
        selector.add("isLeaf");
        selector.add("AC");
        selector.add("companyID.isBizUnit");
        view.setSelector(selector);
        SorterItemCollection coll = new SorterItemCollection();
        coll.add(new SorterItemInfo("companyID"));
        coll.add(new SorterItemInfo("number"));
        view.setSorter(coll);
        AccountViewCollection accountViewCollection = this.getAccountViewCollection(ctx, view);
        EntityViewInfo evi = new EntityViewInfo();
        filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("srcCompany.longNumber", (Object)companyOrgUnitInfo.getLongNumber()));
        filter.getFilterItems().add(new FilterItemInfo("srcCompany.longNumber", (Object)(companyOrgUnitInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctInfo.getAccountTableID().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)false));
        filter.setMaskString("(#0 or #1) and #2 and #3");
        IAccount_Control acctCtrl = Account_ControlFactory.getLocalInstance(ctx);
        Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
        HashMap<String, Account_ControlInfo> acctCtrlColsMap = new HashMap<String, Account_ControlInfo>();
        Account_ControlInfo acctCtrlInfo = null;
        int count = acctCtrlCols.size();
        for (int i = 0; i < count; ++i) {
            acctCtrlInfo = acctCtrlCols.get(i);
            acctCtrlColsMap.put(acctCtrlInfo.getDestCompany().getId().toString(), acctCtrlInfo);
        }
        AccountViewInfo accountViewInfo = null;
        String inferiorNumber = "";
        String inferiorLongNumber = "";
        String inferiorLongName = "";
        String inferiorLongName_L1 = "";
        Connection cn = null;
        Statement stmt = null;
        AccountViewCollection forAcRepair = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.createStatement();
            forAcRepair = new AccountViewCollection();
            int count2 = accountViewCollection.size();
            for (int i = 0; i < count2; ++i) {
                int j;
                AccountViewCollection acCol;
                StringBuilder sb;
                StringBuilder bmsf;
                StringBuilder bmsf22;
                accountViewInfo = accountViewCollection.get(i);
                acctCtrlInfo = (Account_ControlInfo)acctCtrlColsMap.get(accountViewInfo.getCompanyID().getId().toString());
                String inferiorId = accountViewInfo.getId().toString();
                inferiorNumber = accountViewInfo.getNumber();
                inferiorLongNumber = accountViewInfo.getLongNumber();
                inferiorLongName = accountViewInfo.getLongName();
                inferiorLongName_L1 = accountViewInfo.getLongName(new Locale("L1"));
                if (acctCtrlInfo == null || inferiorId == null || inferiorId.length() < 1) continue;
                StringBuffer sql = new StringBuffer();
                sql.append("UPDATE T_BD_ACCOUNTVIEW SET FNumber = '").append(acctInfo.getNumber()).append("'");
                sql.append(",FLongNumber = '").append(acctInfo.getLongNumber()).append("'");
                sql.append(",FName_L1");
                sql.append("='").append(acctInfo.getName(new Locale("L1"))).append("'");
                sql.append(",FName_L2");
                sql.append("='").append(acctInfo.getName(new Locale("L2"))).append("'");
                sql.append(",FName_L3");
                sql.append("='").append(acctInfo.getName(new Locale("L3"))).append("'");
                sql.append(",FLongName_L1");
                sql.append("='").append(acctInfo.getLongName(new Locale("L1"))).append("'");
                sql.append(",FLongName_L2");
                sql.append("='").append(acctInfo.getLongName(new Locale("L2"))).append("'");
                sql.append(",FLongName_L3");
                sql.append("='").append(acctInfo.getLongName(new Locale("L3"))).append("'");
                sql.append(",FDisplayName_L1");
                sql.append("='").append(acctInfo.getLongName(new Locale("L1"))).append("'");
                sql.append(",FDisplayName_L2");
                sql.append("='").append(acctInfo.getLongName(new Locale("L2"))).append("'");
                sql.append(",FDisplayName_L3");
                sql.append("='").append(acctInfo.getLongName(new Locale("L3"))).append("'");
                sql.append(",FLastUpdateUserId = '").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("' ");
                sql.append(",FLastUpdateTime = getdate() ");
                sql.append(",FAccountTypeID='").append(acctInfo.getAccountTypeID().getId().toString()).append("'");
                sql.append(",FIsCash=").append(this.getIntData(new Boolean(acctInfo.isIsCash())));
                sql.append(",FIsBank=").append(this.getIntData(new Boolean(acctInfo.isIsBank())));
                sql.append(",FIsCashEquivalent=").append(this.getIntData(new Boolean(acctInfo.isIsCashEquivalent())));
                sql.append(",FPLType=").append(new Integer(acctInfo.getPLType().getValue()));
                if (acctInfo.getCAA() != null) {
                    sql.append(",FGAA='" + acctInfo.getCAA().getId().toString() + "'");
                    sql.append(",FCAA=CASE WHEN FCAA IS NULL THEN '" + acctInfo.getCAA().getId().toString() + "' ELSE FCAA END");
                } else {
                    String sqlToSynchronizeGAA = "UPDATE T_BD_ACCOUNTVIEW SET FGAA = NULL WHERE FID='" + inferiorId + "'";
                    stmt.addBatch(sqlToSynchronizeGAA);
                }
                sql.append(" ,FDiffType =").append(acctInfo.getDiffType().getValue());
                if (acctCtrlInfo != null) {
                    if (acctCtrlInfo.getControl() == 1) {
                        sql.append(",FControl=").append(new Integer(acctInfo.getControl().getValue()));
                    }
                    if (acctCtrlInfo.getDc() == 1) {
                        sql.append(",FDC=").append(new Integer(acctInfo.getDC().getValue()));
                    }
                    if (acctCtrlInfo.getCurrencyID() == 1) {
                        String sqlToDeleteCurrency = "DELETE FROM T_BD_ACCOUNTCURRENCY WHERE FACCOUNTVIEWID='" + inferiorId + "'";
                        stmt.addBatch(sqlToDeleteCurrency);
                        String sqlToInsertCurrency = "INSERT INTO T_BD_ACCOUNTCURRENCY (FID,FACCOUNTVIEWID,FCURRENCYID) SELECT newbosid('DC61A512'),'" + inferiorId + "',FCURRENCYID FROM T_BD_ACCOUNTCURRENCY WHERE FACCOUNTVIEWID='" + acctInfo.getId().toString() + "'";
                        stmt.addBatch(sqlToInsertCurrency);
                        sql.append(",FAcctCurrency=").append(new Integer(acctInfo.getAccountingcurrency().getValue()));
                    }
                    if (acctCtrlInfo.getAc() == 1) {
                        sql.append(",FAC=").append(this.getIntData(new Boolean(acctInfo.isAC())));
                    }
                    if (acctCtrlInfo.getAcNotice() == 1 && acctInfo.isACNotice()) {
                        sql.append(",FACNotice=").append(this.getIntData(new Boolean(acctInfo.isACNotice())));
                    }
                    if (acctCtrlInfo.getBw() == 1 && acctInfo.isBw()) {
                        sql.append(",FBw=").append(this.getIntData(new Boolean(acctInfo.isBw())));
                    }
                    if (acctCtrlInfo.getIsQty() == 1 && acctInfo.isIsQty()) {
                        sql.append(",FIsQty=").append(this.getIntData(new Boolean(acctInfo.isIsQty())));
                        sql.append(",FMeasureUnitGroupID=CASE WHEN FMeasureUnitGroupID IS NULL THEN '").append(acctInfo.getMeasureUnitGroupID().getId().toString()).append("' ELSE FMeasureUnitGroupID END");
                        sql.append(",FMeasureUnitID=CASE WHEN FMeasureUnitID IS NULL THEN '").append(acctInfo.getMeasureUnitID().getId().toString()).append("' ELSE FMeasureUnitID END");
                    }
                    if (acctCtrlInfo.getIsChangeCurrency() == 1 && acctInfo.isIsChangeCurrency()) {
                        sql.append(",FIsChangeCurrency=").append(this.getIntData(new Boolean(acctInfo.isIsChangeCurrency())));
                    }
                    if (isProfitCenterChanged) {
                        sql.append(",FIsProfitCenter=").append(this.getIntData(acctInfo.isIsProfitCenter()));
                    }
                }
                sql.append(" WHERE FID='").append(inferiorId).append("'");
                stmt.addBatch(sql.toString());
                if (acctInfo.getBorrowerMainCashFlowItem() != null) {
                    bmsf22 = new StringBuilder();
                    bmsf22.append("UPDATE T_BD_ACCOUNTVIEW  SET FBorrowerMainCashFlowItemID = '" + acctInfo.getBorrowerMainCashFlowItem().getId().toString() + "' ");
                    bmsf22.append(" WHERE FID='").append(inferiorId).append("'");
                    bmsf22.append(" AND FBorrowerMainCashFlowItemID is null");
                    stmt.addBatch(bmsf22.toString());
                }
                if (acctInfo.getBorrowerAttCashFlowItem() != null) {
                    bmsf22 = new StringBuilder();
                    bmsf22.append("UPDATE T_BD_ACCOUNTVIEW  SET FBorrowerAttCashFlowItemID = '" + acctInfo.getBorrowerAttCashFlowItem().getId().toString() + "' ");
                    bmsf22.append(" WHERE FID='").append(inferiorId).append("'");
                    bmsf22.append(" AND FBorrowerAttCashFlowItemID is null");
                    stmt.addBatch(bmsf22.toString());
                }
                if (acctInfo.getLenderMainCashFlowItem() != null) {
                    bmsf22 = new StringBuilder();
                    bmsf22.append("UPDATE T_BD_ACCOUNTVIEW  SET FLenderMainCashFlowItemID = '" + acctInfo.getLenderMainCashFlowItem().getId().toString() + "' ");
                    bmsf22.append(" WHERE FID='").append(inferiorId).append("'");
                    bmsf22.append(" AND FLenderMainCashFlowItemID is null");
                    stmt.addBatch(bmsf22.toString());
                }
                if (acctInfo.getLenderAttCashFlowItem() != null) {
                    bmsf22 = new StringBuilder();
                    bmsf22.append("UPDATE T_BD_ACCOUNTVIEW  SET FLenderAttCashFlowItemID = '" + acctInfo.getLenderAttCashFlowItem().getId().toString() + "' ");
                    bmsf22.append(" WHERE FID='").append(inferiorId).append("'");
                    bmsf22.append(" AND FLenderAttCashFlowItemID is null");
                    stmt.addBatch(bmsf22.toString());
                }
                String longNameL2 = "FLongName_L2";
                String longNameL3 = "FLongName_L3";
                String displayNameL1 = "FDisplayName_L1";
                String displayNameL2 = "FDisplayName_L2";
                String displayNameL3 = "FDisplayName_L3";
                StringBuffer sqlToSynchronizeChild = new StringBuffer();
                sqlToSynchronizeChild.append("UPDATE T_BD_ACCOUNTVIEW  SET FNumber='" + acctInfo.getNumber().toString() + "'||RIGHT(FNumber,LEN(FNumber)-" + new Integer(inferiorNumber.length()) + "),FLongNumber='" + acctInfo.getLongNumber().toString() + "'||REPLACE(RIGHT(FLongNumber,LEN(FLongNumber)-" + new Integer(inferiorLongNumber.length()) + "),'!" + inferiorNumber.toString() + "','!" + acctInfo.getNumber().toString() + "'),FAccountTypeID='" + acctInfo.getAccountTypeID().getId().toString() + "',FIsCash=" + this.getIntData(new Boolean(acctInfo.isIsCash())) + ",FIsBank=" + this.getIntData(new Boolean(acctInfo.isIsBank())) + ",FIsCashEquivalent=" + this.getIntData(new Boolean(acctInfo.isIsCashEquivalent())));
                sqlToSynchronizeChild.append(",");
                sqlToSynchronizeChild.append(longNameL2);
                sqlToSynchronizeChild.append("='" + acctInfo.getLongName(new Locale("L2")) + "'||SUBSTRING(");
                sqlToSynchronizeChild.append(longNameL2);
                sqlToSynchronizeChild.append(",");
                sqlToSynchronizeChild.append(new Integer(inferiorLongName.length() + 1));
                sqlToSynchronizeChild.append(",LEN(");
                sqlToSynchronizeChild.append(longNameL2);
                sqlToSynchronizeChild.append("))");
                sqlToSynchronizeChild.append(",");
                sqlToSynchronizeChild.append(longNameL3);
                sqlToSynchronizeChild.append("='" + acctInfo.getLongName(new Locale("L3")) + "'||SUBSTRING(");
                sqlToSynchronizeChild.append(longNameL3);
                sqlToSynchronizeChild.append(",");
                sqlToSynchronizeChild.append(new Integer(inferiorLongName.length() + 1));
                sqlToSynchronizeChild.append(",LEN(");
                sqlToSynchronizeChild.append(longNameL3);
                sqlToSynchronizeChild.append("))");
                if (!StringUtils.isEmpty((String)inferiorLongName_L1)) {
                    sqlToSynchronizeChild.append(",");
                    sqlToSynchronizeChild.append(displayNameL1);
                    sqlToSynchronizeChild.append("='" + acctInfo.getLongName(new Locale("L1")) + "'||SUBSTRING(");
                    sqlToSynchronizeChild.append(displayNameL1);
                    sqlToSynchronizeChild.append(",");
                    sqlToSynchronizeChild.append(new Integer(inferiorLongName_L1.length() + 1));
                    sqlToSynchronizeChild.append(",LEN(");
                    sqlToSynchronizeChild.append(displayNameL1);
                    sqlToSynchronizeChild.append("))");
                }
                sqlToSynchronizeChild.append(",");
                sqlToSynchronizeChild.append(displayNameL2);
                sqlToSynchronizeChild.append("='" + acctInfo.getLongName(new Locale("L2")) + "'||SUBSTRING(");
                sqlToSynchronizeChild.append(displayNameL2);
                sqlToSynchronizeChild.append(",");
                sqlToSynchronizeChild.append(new Integer(inferiorLongName.length() + 1));
                sqlToSynchronizeChild.append(",LEN(");
                sqlToSynchronizeChild.append(displayNameL2);
                sqlToSynchronizeChild.append("))");
                sqlToSynchronizeChild.append(",");
                sqlToSynchronizeChild.append(displayNameL3);
                sqlToSynchronizeChild.append("='" + acctInfo.getLongName(new Locale("L3")) + "'||SUBSTRING(");
                sqlToSynchronizeChild.append(displayNameL3);
                sqlToSynchronizeChild.append(",");
                sqlToSynchronizeChild.append(new Integer(inferiorLongName.length() + 1));
                sqlToSynchronizeChild.append(",LEN(");
                sqlToSynchronizeChild.append(displayNameL3);
                sqlToSynchronizeChild.append("))");
                if (acctCtrlInfo != null) {
                    if (acctCtrlInfo.getControl() == 1) {
                        sqlToSynchronizeChild.append(",FControl=" + new Integer(acctInfo.getControl().getValue()));
                    }
                    if (acctCtrlInfo.getPlType() == 1) {
                        sqlToSynchronizeChild.append(",FPLType=" + new Integer(acctInfo.getPLType().getValue()));
                    }
                    if (acctCtrlInfo.getAc() == 1) {
                        sqlToSynchronizeChild.append(",FAC=" + this.getIntData(new Boolean(acctInfo.isAC())));
                    }
                    if (acctCtrlInfo.getAcNotice() == 1 && acctInfo.isACNotice()) {
                        sqlToSynchronizeChild.append(",FACNotice=" + this.getIntData(new Boolean(acctInfo.isACNotice())));
                    }
                    if (acctCtrlInfo.getBw() == 1 && acctInfo.isBw()) {
                        sqlToSynchronizeChild.append(",FBw=" + this.getIntData(new Boolean(acctInfo.isBw())));
                    }
                    if (acctInfo.getCAA() != null) {
                        String caaId = "'" + acctInfo.getCAA().getId().toString() + "'";
                        sqlToSynchronizeChild.append(",FParentAAID=CASE WHEN FPARENTAAID IS NULL THEN " + caaId + " ELSE FPARENTAAID END");
                        sqlToSynchronizeChild.append(",FCAA = CASE WHEN FCAA IS NULL THEN " + caaId + " ELSE FCAA END");
                        sqlToSynchronizeChild.append(",FGAA=CASE WHEN FGAA IS NULL AND FUPPERID IS NOT NULL THEN " + caaId + " ELSE FGAA END");
                    }
                    if (acctCtrlInfo.getIsQty() == 1 && acctInfo.isIsQty()) {
                        sqlToSynchronizeChild.append(",FIsQty=" + this.getIntData(new Boolean(acctInfo.isIsQty())));
                        sqlToSynchronizeChild.append(",FMeasureUnitGroupID=CASE WHEN FMeasureUnitGroupID IS NULL THEN '" + acctInfo.getMeasureUnitGroupID().getId().toString() + "'  ELSE FMeasureUnitGroupID END");
                        sqlToSynchronizeChild.append(",FMeasureUnitID=CASE WHEN FMeasureUnitID IS NULL THEN '" + acctInfo.getMeasureUnitID().getId().toString() + "' ELSE FMeasureUnitID END");
                    }
                    if (acctCtrlInfo.getIsChangeCurrency() == 1 && acctInfo.isIsChangeCurrency()) {
                        sqlToSynchronizeChild.append(",FIsChangeCurrency=" + this.getIntData(new Boolean(acctInfo.isIsChangeCurrency())));
                    }
                    if (isProfitCenterChanged) {
                        sqlToSynchronizeChild.append(",FIsProfitCenter=" + this.getIntData(new Boolean(acctInfo.isIsProfitCenter())));
                    }
                }
                sqlToSynchronizeChild.append(" ,FDiffType =").append(acctInfo.getDiffType().getValue());
                sqlToSynchronizeChild.append(",FLastUpdateUserId ='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "' ");
                sqlToSynchronizeChild.append(",FLastUpdateTime = getdate() ");
                sqlToSynchronizeChild.append(" WHERE FLongNumber LIKE '" + inferiorLongNumber + "!%' AND FAccountTableID='" + acctInfo.getAccountTableID().getId().toString() + "' AND FCompanyID='" + acctCtrlInfo.getDestCompany().getId().toString() + "'");
                stmt.addBatch(sqlToSynchronizeChild.toString());
                if (acctInfo.getBorrowerMainCashFlowItem() != null) {
                    bmsf = new StringBuilder();
                    bmsf.append("UPDATE T_BD_ACCOUNTVIEW  SET FBorrowerMainCashFlowItemID = '" + acctInfo.getBorrowerMainCashFlowItem().getId().toString() + "' ");
                    bmsf.append(" WHERE FLongNumber LIKE '" + inferiorLongNumber + "!%' AND FAccountTableID='" + acctInfo.getAccountTableID().getId().toString() + "' AND FCompanyID='" + acctCtrlInfo.getDestCompany().getId().toString() + "'");
                    bmsf.append(" AND FBorrowerMainCashFlowItemID is null");
                    stmt.addBatch(bmsf.toString());
                }
                if (acctInfo.getBorrowerAttCashFlowItem() != null) {
                    bmsf = new StringBuilder();
                    bmsf.append("UPDATE T_BD_ACCOUNTVIEW  SET FBorrowerAttCashFlowItemID = '" + acctInfo.getBorrowerAttCashFlowItem().getId().toString() + "' ");
                    bmsf.append(" WHERE FLongNumber LIKE '" + inferiorLongNumber + "!%' AND FAccountTableID='" + acctInfo.getAccountTableID().getId().toString() + "' AND FCompanyID='" + acctCtrlInfo.getDestCompany().getId().toString() + "'");
                    bmsf.append(" AND FBorrowerAttCashFlowItemID is null");
                    stmt.addBatch(bmsf.toString());
                }
                if (acctInfo.getLenderMainCashFlowItem() != null) {
                    bmsf = new StringBuilder();
                    bmsf.append("UPDATE T_BD_ACCOUNTVIEW  SET FLenderMainCashFlowItemID = '" + acctInfo.getLenderMainCashFlowItem().getId().toString() + "' ");
                    bmsf.append(" WHERE FLongNumber LIKE '" + inferiorLongNumber + "!%' AND FAccountTableID='" + acctInfo.getAccountTableID().getId().toString() + "' AND FCompanyID='" + acctCtrlInfo.getDestCompany().getId().toString() + "'");
                    bmsf.append(" AND FLenderMainCashFlowItemID is null");
                    stmt.addBatch(bmsf.toString());
                }
                if (acctInfo.getLenderAttCashFlowItem() != null) {
                    bmsf = new StringBuilder();
                    bmsf.append("UPDATE T_BD_ACCOUNTVIEW  SET FLenderAttCashFlowItemID = '" + acctInfo.getLenderAttCashFlowItem().getId().toString() + "' ");
                    bmsf.append(" WHERE FLongNumber LIKE '" + inferiorLongNumber + "!%' AND FAccountTableID='" + acctInfo.getAccountTableID().getId().toString() + "' AND FCompanyID='" + acctCtrlInfo.getDestCompany().getId().toString() + "'");
                    bmsf.append(" AND FLenderAttCashFlowItemID is null");
                    stmt.addBatch(bmsf.toString());
                }
                if (acctCtrlInfo.getAc() == 1 & acctInfo.isAC() && !accountViewInfo.isAC() && accountViewInfo.getCompanyID().isIsBizUnit()) {
                    if (accountViewInfo.isIsLeaf()) {
                        accountViewInfo.setAC(true);
                        forAcRepair.add(accountViewInfo);
                        continue;
                    }
                    sb = new StringBuilder();
                    sb.append(" WHERE longNumber LIKE '" + inferiorLongNumber + "!%' AND accountTableID.id='" + acctInfo.getAccountTableID().getId().toString() + "' AND companyID.id='" + acctCtrlInfo.getDestCompany().getId().toString() + "' AND isLeaf=1 AND AC=0 ");
                    acCol = AccountViewFactory.getLocalInstance(ctx).getAccountViewCollection(sb.toString());
                    for (j = 0; j < acCol.size(); ++j) {
                        acCol.get(j).setAC(true);
                    }
                    forAcRepair.addCollection(acCol);
                    continue;
                }
                if (!(acctCtrlInfo.getAc() == 1 & !acctInfo.isAC()) || !accountViewInfo.isAC() || !accountViewInfo.getCompanyID().isIsBizUnit()) continue;
                if (accountViewInfo.isIsLeaf()) {
                    accountViewInfo.setAC(false);
                    forAcRepair.add(accountViewInfo);
                    continue;
                }
                sb = new StringBuilder();
                sb.append(" WHERE longNumber LIKE '" + inferiorLongNumber + "!%' AND accountTableID.id='" + acctInfo.getAccountTableID().getId().toString() + "' AND companyID.id='" + acctCtrlInfo.getDestCompany().getId().toString() + "' AND isLeaf=1 AND AC=1 ");
                acCol = AccountViewFactory.getLocalInstance(ctx).getAccountViewCollection(sb.toString());
                for (j = 0; j < acCol.size(); ++j) {
                    acCol.get(j).setAC(false);
                }
                forAcRepair.addCollection(acCol);
            }
            if (forAcRepair.size() > 0) {
                this.fixAcctCussentData(ctx, forAcRepair);
            }
            stmt.executeBatch();
        }
        catch (AccountException e) {
            try {
                throw e;
                catch (Exception e2) {
                    logger.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new AccountException(AccountException.SYNCHRONIZE_INFERIOR_ERROR, e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    public boolean isProfitCenterChanged(AccountViewInfo acctInfo, AccountViewInfo oldAcctInfo) {
        int newProfitCenter = this.getIntData(acctInfo.isIsProfitCenter());
        int oldProfitCenter = this.getIntData(oldAcctInfo.isIsProfitCenter());
        boolean result = false;
        if (acctInfo.getAccountTypeID().getProperty() != AccountProperty.PROFIT_CENTER) {
            acctInfo.setIsProfitCenter(false);
            result = true;
        } else {
            result = newProfitCenter != oldProfitCenter;
        }
        return result;
    }

    private boolean isNameChanged(AccountViewInfo acctInfo, AccountViewInfo oldAcctInfo) {
        for (int i = 1; i <= 3; ++i) {
            if (acctInfo.getName(new Locale("L" + i)) != null && oldAcctInfo.getName(new Locale("L" + i)) != null && !acctInfo.getName(new Locale("L" + i)).equals(oldAcctInfo.getName(new Locale("L" + i)))) {
                return true;
            }
            if ((acctInfo.getName(new Locale("L" + i)) != null || oldAcctInfo.getName(new Locale("L" + i)) == null) && (acctInfo.getName(new Locale("L" + i)) == null || oldAcctInfo.getName(new Locale("L" + i)) != null)) continue;
            return true;
        }
        return false;
    }

    private void chkInfeCompanyDupAccount(Context ctx, AccountViewInfo acctInfo, AccountViewInfo oldAcctInfo) throws BOSException, EASBizException {
        String companyNumbers;
        String strSql = "";
        SelectorItemCollection seleColl = new SelectorItemCollection();
        seleColl.add(new SelectorItemInfo("longNumber"));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(acctInfo.getCompanyID().getId()), seleColl);
        String notLikeSql = "";
        try {
            notLikeSql = this.getNotLikeSql(ctx, acctInfo);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (!acctInfo.getNumber().equals(oldAcctInfo.getNumber()) && !acctInfo.getName().equals(oldAcctInfo.getName())) {
            strSql = "select distinct com.fnumber companyNumber from t_bd_accountview av1, t_bd_accountview av2,t_org_company  com  where av1.faccounttableid=av2.faccounttableid and av1.faccounttableid='" + acctInfo.getAccountTableID().getId().toString() + "' and av1.fcompanyid = av2.fcompanyid and com.fid=av1.fcompanyid  and ((av1.fnumber='" + oldAcctInfo.getNumber() + "' and av2.fnumber='" + acctInfo.getNumber() + "')  or (av1.fname_l2 ='" + oldAcctInfo.getName() + "' and av2.fname_l2 ='" + acctInfo.getName() + "' ))  and av1.fupperid is not null and av1.fparentid = av2.fparentid  and com.fid in( select fid from t_org_company where flongnumber like '" + company.getLongNumber() + "!%' " + notLikeSql + ")";
        } else if (!acctInfo.getNumber().equals(oldAcctInfo.getNumber())) {
            strSql = oldAcctInfo.getName() == null ? "select distinct com.fnumber companyNumber from t_bd_accountview av1, t_bd_accountview av2,t_org_company  com  where av1.faccounttableid=av2.faccounttableid and av1.faccounttableid='" + acctInfo.getAccountTableID().getId().toString() + "' and av1.fcompanyid = av2.fcompanyid and com.fid=av1.fcompanyid and av1.fname_l2 =" + oldAcctInfo.getName() + " and av2.fname_l2 ='" + acctInfo.getName().replaceAll("'", "''") + "' and av1.fupperid is not null and av1.fparentid = av2.fparentid  and com.fid in( select fid from t_org_company where flongnumber like '" + company.getLongNumber() + "!%' " + notLikeSql + ")" : "select distinct com.fnumber companyNumber from t_bd_accountview av1, t_bd_accountview av2,t_org_company  com  where av1.faccounttableid=av2.faccounttableid and av1.faccounttableid='" + acctInfo.getAccountTableID().getId().toString() + "' and av1.fcompanyid = av2.fcompanyid and com.fid=av1.fcompanyid and av1.fnumber='" + oldAcctInfo.getNumber() + "' and av2.fnumber='" + acctInfo.getNumber() + "' and av1.fupperid is not null and av1.fparentid = av2.fparentid  and com.fid in( select fid from t_org_company where flongnumber like '" + company.getLongNumber() + "!%' " + notLikeSql + ")";
        } else if (!acctInfo.getName().equals(oldAcctInfo.getName())) {
            strSql = "select distinct com.fnumber companyNumber from t_bd_accountview av1, t_bd_accountview av2,t_org_company  com  where av1.faccounttableid=av2.faccounttableid and av1.faccounttableid='" + acctInfo.getAccountTableID().getId().toString() + "' and av1.fcompanyid = av2.fcompanyid and com.fid=av1.fcompanyid and av1.fname_l2 ='" + oldAcctInfo.getName().replaceAll("'", "''") + "' and av2.fname_l2 ='" + acctInfo.getName().replaceAll("'", "''") + "' and av1.fupperid is not null and av1.fparentid = av2.fparentid  and av1.fnumber like '" + acctInfo.getNumber() + "%'  and com.fid in( select fid from t_org_company where flongnumber like '" + company.getLongNumber() + "!%' " + notLikeSql + ")";
        }
        IRowSet row = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)strSql);
        StringBuffer companyNumber = new StringBuffer();
        if (row != null && row.size() > 0) {
            try {
                while (row.next()) {
                    companyNumber.append(row.getString("companyNumber") + ",");
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((String)(companyNumbers = companyNumber.toString()))) {
            companyNumbers = companyNumbers.substring(0, companyNumbers.length() - 1);
            throw new AccountException(AccountException.INFEHASSAMEACCOUNT, new Object[]{acctInfo.getNumber(), companyNumbers});
        }
    }

    private void checkInferiorMainAttItem(Context ctx, AccountViewInfo acctInfo) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("longnumber");
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(acctInfo.getCompanyID().getId()), selector);
        StringBuffer checkSQL = new StringBuffer();
        checkSQL.append("select top 1 c.fnumber companyNumber, av.fnumber avNumber from t_bd_accountview av left outer join t_org_company c on av.fcompanyid = c.fid where av.FAccountTableID = ? and c.flongnumber like ? and av.flongnumber like ? and (av.FBorrowerMainCashFlowItemID is not null or av.FBorrowerAttCashFlowItemID is not null or av.FLenderMainCashFlowItemID is not null or av.FLenderAttCashFlowItemID is not null);");
        IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)checkSQL.toString(), (Object[])new Object[]{acctInfo.getAccountTableID().getId().toString(), company.getLongNumber() + "!%", acctInfo.getLongNumber() + "%"});
        try {
            if (rs != null && rs.next()) {
                String companyNumber = rs.getString("companyNumber");
                String accountNumber = rs.getString("avNumber");
                throw new AccountException(AccountException.INFERIOR_ACCOUNT_HAS_MAIN_ATT_ITEM, new Object[]{companyNumber, accountNumber});
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkInferiorCashProperties(Context ctx, AccountViewInfo acctInfo) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("longnumber");
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(acctInfo.getCompanyID().getId()), selector);
        StringBuffer checkSQL = new StringBuffer();
        checkSQL.append("select top 1 c.fnumber companyNumber, av.fnumber avNumber from t_bd_accountview av left outer join t_org_company c on av.fcompanyid = c.fid where av.FAccountTableID = ? and c.flongnumber like ? and av.flongnumber like ? and (av.FIsCash = 1 or av.FIsBank = 1 or av.FIsCashEquivalent = 1);");
        IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)checkSQL.toString(), (Object[])new Object[]{acctInfo.getAccountTableID().getId().toString(), company.getLongNumber() + "!%", acctInfo.getLongNumber() + "%"});
        try {
            if (rs != null && rs.next()) {
                String companyNumber = rs.getString("companyNumber");
                String accountNumber = rs.getString("avNumber");
                throw new AccountException(AccountException.INFERIOR_ACCOUNT_HAS_CASH_PROPERTIES, new Object[]{companyNumber, accountNumber});
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkInferiorParentMainItem(Context ctx, AccountViewInfo acctInfo) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("longnumber");
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(acctInfo.getCompanyID().getId()), selector);
        String accountNumber = acctInfo.getLongNumber();
        String parentAccountNumber = accountNumber.substring(0, accountNumber.lastIndexOf(33));
        StringBuffer checkSQL = new StringBuffer();
        checkSQL.append("select top 1 c.fnumber companyNumber, av.fnumber avNumber from t_bd_accountview av left outer join t_org_company c on av.fcompanyid = c.fid where av.FAccountTableID = ? and c.flongnumber like ? and av.flongnumber = ? and av.FBorrowerMainCashFlowItemID is not null and av.FBorrowerMainCashFlowItemID <> ?;");
        IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)checkSQL.toString(), (Object[])new Object[]{acctInfo.getAccountTableID().getId().toString(), company.getLongNumber() + "!%", parentAccountNumber, acctInfo.getBorrowerMainCashFlowItem().getId().toString()});
        try {
            if (rs != null && rs.next()) {
                String companyNumber = rs.getString("companyNumber");
                String inferiorAccountNumber = rs.getString("avNumber");
                throw new AccountException(AccountException.INFERIOR_PARENT_ACCOUNT_MAIN_ITEM_NOT_SAME, new Object[]{companyNumber, inferiorAccountNumber});
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkInferiorParentAttItem(Context ctx, AccountViewInfo acctInfo) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("longnumber");
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(acctInfo.getCompanyID().getId()), selector);
        String accountNumber = acctInfo.getLongNumber();
        String parentAccountNumber = accountNumber.substring(0, accountNumber.lastIndexOf(33));
        StringBuffer checkSQL = new StringBuffer();
        checkSQL.append("select top 1 c.fnumber companyNumber, av.fnumber avNumber from t_bd_accountview av left outer join t_org_company c on av.fcompanyid = c.fid where av.FAccountTableID = ? and c.flongnumber like ? and av.flongnumber = ? and av.FBorrowerAttCashFlowItemID is not null and av.FBorrowerAttCashFlowItemID <> ?;");
        IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)checkSQL.toString(), (Object[])new Object[]{acctInfo.getAccountTableID().getId().toString(), company.getLongNumber() + "!%", parentAccountNumber, acctInfo.getBorrowerAttCashFlowItem().getId().toString()});
        try {
            if (rs != null && rs.next()) {
                String companyNumber = rs.getString("companyNumber");
                String inferiorAccountNumber = rs.getString("avNumber");
                throw new AccountException(AccountException.INFERIOR_PARENT_ACCOUNT_ATT_ITEM_NOT_SAME, new Object[]{companyNumber, inferiorAccountNumber});
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected int getIntData(Boolean selectdata) {
        int io = 0;
        if (!selectdata.booleanValue()) {
            io = 0;
        } else if (selectdata.booleanValue()) {
            io = 1;
        }
        return io;
    }

    /*
     * Exception decompiling
     */
    protected void synchronizeChildProperties(Context ctx, AccountViewInfo acctInfo, AccountViewInfo oldAcctInfo, boolean isProfitCenterChanged) throws BOSException, AccountException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void fixAcctCussentData(Context ctx, AccountViewCollection accountViewCollection) throws AccountException, BOSException {
        try {
            Class<?> acctCussentInitFacadeFactory = Class.forName("com.kingdee.eas.fi.gl.AcctCussentInitFacadeFactory");
            Method method = acctCussentInitFacadeFactory.getMethod("getLocalInstance", Context.class);
            Object instace = method.invoke(null, ctx);
            Class<?> iAcctCussentInitFacade = Class.forName("com.kingdee.eas.fi.gl.IAcctCussentInitFacade");
            Method dealInitFlagWithAccountToAC = iAcctCussentInitFacade.getMethod("dealInitFlagWithAccountToAC", IObjectCollection.class);
            dealInitFlagWithAccountToAC.invoke(instace, new Object[]{accountViewCollection});
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new AccountException(AccountException.ACEDIT_GL_EXCEPTION_TIP);
        }
    }

    private void checkChildMainAttItem(Context ctx, AccountViewInfo acctInfo) throws BOSException, AccountException {
        StringBuffer checkSQL = new StringBuffer();
        checkSQL.append("select top 1 fid, fnumber from t_bd_accountview where FAccountTableID = ? and fcompanyid = ? and flongnumber like ? and (FBorrowerMainCashFlowItemID is not null or FBorrowerAttCashFlowItemID is not null or FLenderAttCashFlowItemID is not null or FLenderMainCashFlowItemID is not null);");
        IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)checkSQL.toString(), (Object[])new Object[]{acctInfo.getAccountTableID().getId().toString(), acctInfo.getCompanyID().getId().toString(), acctInfo.getLongNumber() + "!%"});
        try {
            if (rs != null && rs.next()) {
                String accountNumber = rs.getString("fnumber");
                throw new AccountException(AccountException.CHILD_ACCOUNT_HAS_MAIN_ATT_ITEM, new Object[]{accountNumber});
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkChildCashProperties(Context ctx, AccountViewInfo acctInfo) throws BOSException, AccountException {
        StringBuffer checkSQL = new StringBuffer();
        checkSQL.append("select top 1 fid, fnumber from t_bd_accountview where FAccountTableID = ? and fcompanyid = ? and flongnumber like ? and (FIsCash = 1 or FIsBank = 1 or FIsCashEquivalent = 1);");
        IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)checkSQL.toString(), (Object[])new Object[]{acctInfo.getAccountTableID().getId().toString(), acctInfo.getCompanyID().getId().toString(), acctInfo.getLongNumber() + "!%"});
        try {
            if (rs != null && rs.next()) {
                String accountNumber = rs.getString("fnumber");
                throw new AccountException(AccountException.CHILD_ACCOUNT_HAS_CASH_PROPERTIES, new Object[]{accountNumber});
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected void synchronizeCommonProperties(Context ctx, AccountViewInfo acctInfo) throws BOSException {
        if (acctInfo != null) {
            String sql = "UPDATE T_BD_ACCOUNTVIEW SET FAccountTypeID=?,FIsCash=?,FIsBank=?,FIsCashEquivalent=? WHERE FNumber LIKE ? AND FAccountTableID=?";
            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{acctInfo.getAccountTableID().getId().toString(), new Boolean(acctInfo.isIsCash()), new Boolean(acctInfo.isIsBank()), new Boolean(acctInfo.isIsCashEquivalent()), acctInfo.getNumber() + "%", acctInfo.getAccountTableID().getId().toString()});
        }
    }

    protected void setGroupCtronlProperties(AccountTableInfo table, AccountViewInfo src, AccountViewInfo dest) {
        if (src != null) {
            dest.setGLevel(src.getGLevel());
            dest.setIsAllowCA(src.isIsAllowCA());
            dest.setIsCashEquivalent(src.isIsCashEquivalent());
            dest.setIsBank(src.isIsBank());
            dest.setIsCash(src.isIsCash());
            dest.setAccountTypeID(src.getAccountTypeID());
            dest.setPLType(src.getPLType());
            Account_ControlInfo acct_ControlInfo = table.getControl().get(0);
            if (acct_ControlInfo.getDc() == 1) {
                dest.setDC(src.getDC());
            }
            if (acct_ControlInfo.getCurrencyID() == 1) {
                dest.setAccountingcurrency(src.getAccountingcurrency());
                if (src.getAccountingcurrency() == AccountingCurrencyEnum.ONECURRENCY) {
                    dest.setCurrencyID(src.getCurrencyID());
                } else {
                    dest.setCurrencyID(null);
                }
            }
            if (acct_ControlInfo.getIsChangeCurrency() == 1) {
                dest.setIsChangeCurrency(src.isIsChangeCurrency());
            }
            if (acct_ControlInfo.getIsCountAccrual() == 1) {
                dest.setIsCountAccrual(src.isIsCountAccrual());
                dest.setAccrualPer(src.getAccrualPer());
            }
            if (acct_ControlInfo.getIsQty() == 1) {
                dest.setIsQty(src.isIsQty());
            }
            if (acct_ControlInfo.getAc() == 1) {
                dest.setAC(src.isAC());
            }
            if (acct_ControlInfo.getAcNotice() == 1) {
                dest.setAC(src.isACNotice());
            }
            if (acct_ControlInfo.getBw() == 1) {
                dest.setBw(src.isBw());
            }
            if (acct_ControlInfo.getControl() == 1) {
                dest.setControl(src.getControl());
            }
        }
    }

    protected boolean isGAImportedByCompany(Context ctx, IObjectPK tablePK, String number) throws BOSException, EASBizException {
        String sql = "SELECT 1 FROM T_BD_AccountView WHERE FAccountTableID=? AND FNumber =? AND FCompanyID IS NOT NULL";
        IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{tablePK.toString(), number});
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return false;
    }

    protected int getMaxGALevel(Context ctx, IObjectPK tablePK, String number) throws BOSException, EASBizException {
        int count = 0;
        String sql = null;
        IRowSet rs = null;
        sql = "SELECT MAX(FLevel) AS maxLevel FROM T_BD_AccountView WHERE FAccountTableID=? AND FNumber LIKE? AND FCompanyID IS NULL";
        rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{tablePK.toString(), number + "%"});
        try {
            if (rs.next()) {
                count = rs.getInt("maxLevel");
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return count;
    }

    protected boolean isLeveOneGAHasCABeyondGCLevel(Context ctx, IObjectPK tablePK, String number) throws BOSException, EASBizException {
        String sql = null;
        IRowSet rs = null;
        sql = "SELECT 1 FROM T_BD_AccountView WHERE FAccountTableID=? AND FCompanyID IS NOT NULL AND FNumber LIKE?AND FLevel>FGLevel";
        rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{tablePK.toString(), number + "%"});
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return false;
    }

    protected void commonSynchronizeLongName(Context ctx, AccountViewInfo oldModel, AccountViewInfo updatedModel, String companyID) throws BOSException, EASBizException {
        String tableID = oldModel.getAccountTableID().getId().toString();
        String newLongName = updatedModel.getLongName();
        String oldLongName = oldModel.getLongName();
        String sql = null;
        String flongname = "FLongName_" + ctx.getLocale().toString();
        if (companyID == null) {
            sql = "UPDATE T_BD_AccountView SET " + flongname + "= REPLACE(" + flongname + ", ?, ?) WHERE FAccountTableID=? AND FNumber LIKE?";
            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{oldLongName + "_", newLongName + "_", tableID, updatedModel.getNumber() + "%"});
        } else {
            sql = "UPDATE T_BD_AccountView SET " + flongname + "= REPLACE(" + flongname + ", ?, ?) WHERE FAccountTableID=? AND FNumber LIKE? AND FCompanyID=?";
            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{oldLongName + "_", newLongName + "_", tableID, updatedModel.getNumber() + "%", companyID});
        }
    }

    protected void commonSynchronizeNumber(Context ctx, String newNumber, AccountViewInfo oldModel, String companyID) throws BOSException, EASBizException {
        String oldNumber = oldModel.getNumber();
        if (!newNumber.equals(oldNumber)) {
            String tableID = oldModel.getAccountTableID().getId().toString();
            String sql = null;
            IRowSet rs = null;
            if (companyID == null) {
                sql = "SELECT FID, FNumber, FParentID FROM T_BD_AccountView WHERE FAccountTableID=? AND FNumber LIKE? ORDER BY FNumber";
                rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{tableID, oldNumber + "!%"});
            } else {
                sql = "SELECT FID, FNumber, FParentID FROM T_BD_AccountView WHERE FAccountTableID=? AND FNumber LIKE? AND FCompanyID=? ORDER BY FNumber";
                rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{tableID, oldNumber + "!%", companyID});
            }
            try {
                while (rs.next()) {
                    String id = rs.getString("FID");
                    String number = rs.getString("FNumber");
                    String parentID = rs.getString("FParentID");
                    number = newNumber + number.substring(oldNumber.length());
                    String longNumber = this.getlongNumberBySQL(ctx, parentID);
                    longNumber = longNumber == null ? number : longNumber + "!" + number;
                    sql = "UPDATE T_BD_AccountView SET FNumber=?, FLongNumber=? WHERE FID=?";
                    com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{number, longNumber, id});
                }
            }
            catch (SQLException ex) {
                throw new BOSException((Throwable)ex);
            }
        }
    }

    protected String getParentLongNameInRS(Context ctx, RowSet rs, String id) throws BOSException, EASBizException {
        String parentLongName = null;
        try {
            int pos = rs.getRow();
            rs.first();
            rs.previous();
            while (rs.next()) {
                String parent = rs.getString("FParentID");
                if (!parent.equals(id)) continue;
                parentLongName = rs.getString("FLongName_L2");
                break;
            }
            rs.first();
            while (rs.getRow() != pos) {
                rs.next();
            }
        }
        catch (SQLException err) {
            throw new BOSException((Throwable)err);
        }
        return parentLongName;
    }

    protected String getlongNumberBySQL(Context ctx, String id) throws BOSException, EASBizException {
        String longNumber = null;
        if (id != null && !id.trim().equals("")) {
            String sql = "SELECT FLongNumber FROM T_BD_AccountView WHERE FID=?";
            IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id});
            try {
                if (rs.next()) {
                    longNumber = rs.getString("FLongNumber");
                }
            }
            catch (SQLException ex) {
                throw new BOSException((Throwable)ex);
            }
        }
        return longNumber;
    }

    @Override
    protected void _updateGroupAccount(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AccountViewInfo vo;
        int i;
        AccountViewInfo account = (AccountViewInfo)model;
        AccountViewInfo oldModel = (AccountViewInfo)this._getValue(ctx, pk);
        String newNumber = account.getNumber();
        String newName = account.getName();
        super._checkNumberBlank(ctx, (IObjectValue)account);
        if (!account.getNumber().equals(oldModel.getNumber())) {
            this._checkNumberDup(ctx, (IObjectValue)account);
        }
        if (oldModel.getParent() != null) {
            AccountViewInfo parent = (AccountViewInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(oldModel.getParent().getId()));
            this.setPropertiesByParent(account, parent);
        }
        if (oldModel.getCompanyID() != null) {
            throw new AccountException(AccountException.ONLY_ALLOW_MODIFY_CA_NOT_GA);
        }
        IAccountTable iacctTable = AccountTableFactory.getLocalInstance(ctx);
        AccountTableInfo table = iacctTable.getAccountTableInfo((IObjectPK)new ObjectUuidPK(account.getAccountTableID().getId()));
        boolean isGCPModified = this.isGCPModidfied(table, account, oldModel);
        boolean isGAAChangeNeedSynchronized = this.isGAAChangeNeedSynchronizedToCA(account, oldModel);
        if (isGCPModified) {
            if (oldModel.getLevel() != 1) {
                throw new AccountException(AccountException.GCP_ONLY_ALLOW_MODIFIED_AT_LEVEL_ONE);
            }
            if (account.getGLevel() < oldModel.getGLevel()) {
                int maxLevel = this.getMaxGALevel(ctx, (IObjectPK)new ObjectUuidPK(oldModel.getAccountTableID().getId()), oldModel.getNumber());
                if (account.getGLevel() < maxLevel) {
                    throw new AccountException(AccountException.GCLEVEL_NOT_ALLOW_REDUCE);
                }
            }
            if (account.getGLevel() > oldModel.getGLevel() && this.isGAImportedByCompany(ctx, (IObjectPK)new ObjectUuidPK(oldModel.getAccountTableID().getId()), oldModel.getNumber())) {
                throw new AccountException(AccountException.GA_ALREADY_USED_BY_CA);
            }
            if (oldModel.isIsAllowCA() && !account.isIsAllowCA() && this.isLeveOneGAHasCABeyondGCLevel(ctx, (IObjectPK)new ObjectUuidPK(oldModel.getAccountTableID().getId()), oldModel.getNumber())) {
                throw new AccountException(AccountException.CA_ALREADY_CREATED);
            }
        }
        this.checkParentNodeChanged(table, account, oldModel);
        account.setCAA(account.getGAA());
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)table.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)oldModel.getNumber(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        evi.getSelector().add("*");
        evi.getSelector().add("companyid.cu.id");
        AccountViewCollection accounts = this.getAccountsByDAO(ctx, evi);
        AccountViewInfo tmp = (AccountViewInfo)account.clone();
        for (i = 0; i < accounts.size(); ++i) {
            vo = accounts.get(i);
            tmp.setId(vo.getId());
            tmp.setCompanyID(vo.getCompanyID());
            tmp.setCU(vo.getCompanyID().getCU());
            tmp.setIsLeaf(vo.isIsLeaf());
            tmp.setParent(vo.getParent());
            this._update(ctx, (IObjectPK)new ObjectUuidPK(vo.getId()), (IObjectValue)tmp);
        }
        if (isGCPModified || isGAAChangeNeedSynchronized) {
            evi = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)table.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)(oldModel.getNumber() + "%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)oldModel.getNumber(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2");
            evi.setFilter(filter);
            evi.getSorter().add(new SorterItemInfo("number"));
            accounts = this.getAccountsByDAO(ctx, evi);
            for (i = 0; i < accounts.size(); ++i) {
                vo = accounts.get(i);
                this.setGroupCtronlProperties(table, account, vo);
                if (isGAAChangeNeedSynchronized && vo.getLevel() > vo.getGLevel()) {
                    vo.setGAA(account.getGAA());
                }
                this._update(ctx, (IObjectPK)new ObjectUuidPK(vo.getId()), (IObjectValue)vo);
            }
        }
        if (!newName.equals(oldModel.getName())) {
            AccountViewInfo updatedModel = (AccountViewInfo)this._getValue(ctx, pk);
            this.commonSynchronizeLongName(ctx, oldModel, updatedModel, null);
        }
        if (!newNumber.equals(oldModel.getNumber())) {
            this.commonSynchronizeNumber(ctx, newNumber, oldModel, null);
        }
    }

    protected boolean isGAAChangeNeedSynchronizedToCA(AccountViewInfo newModel, AccountViewInfo oldModel) {
        return oldModel.getLevel() == oldModel.getGLevel() && !this.isObjectBaseInfoEqual((ObjectBaseInfo)newModel.getGAA(), (ObjectBaseInfo)oldModel.getGAA());
    }

    protected boolean isGCPModidfied(AccountTableInfo table, AccountViewInfo newModel, AccountViewInfo oldModel) {
        Account_ControlInfo acct_ControlInfo = table.getControl().get(0);
        if (newModel.getGLevel() != oldModel.getGLevel()) {
            return true;
        }
        if (newModel.isIsAllowCA() != oldModel.isIsAllowCA()) {
            return true;
        }
        if (newModel.isIsCashEquivalent() != oldModel.isIsCashEquivalent()) {
            return true;
        }
        if (newModel.isIsBank() != oldModel.isIsBank()) {
            return true;
        }
        if (newModel.isIsCash() != oldModel.isIsCash()) {
            return true;
        }
        if (!newModel.getAccountTypeID().getId().toString().equals(oldModel.getAccountTypeID().getId().toString())) {
            return true;
        }
        if (newModel.getPLType().getValue() != oldModel.getPLType().getValue()) {
            return true;
        }
        if (acct_ControlInfo.getDc() == 1 && newModel.getDC().getValue() != oldModel.getDC().getValue()) {
            return true;
        }
        if (acct_ControlInfo.getCurrencyID() == 1) {
            if (newModel.getAccountingcurrency().getValue() != oldModel.getAccountingcurrency().getValue()) {
                return true;
            }
            if (oldModel.getAccountingcurrency() == AccountingCurrencyEnum.ONECURRENCY) {
                if (!this.isObjectBaseInfoEqual((ObjectBaseInfo)newModel.getCurrencyID(), (ObjectBaseInfo)oldModel.getCurrencyID())) {
                    // empty if block
                }
                return true;
            }
        }
        if (acct_ControlInfo.getIsChangeCurrency() == 1 && newModel.isIsChangeCurrency() != oldModel.isIsChangeCurrency()) {
            return true;
        }
        if (acct_ControlInfo.getIsCountAccrual() == 1 && newModel.isIsCountAccrual() != oldModel.isIsCountAccrual()) {
            return true;
        }
        if (acct_ControlInfo.getIsQty() == 1 && newModel.isIsQty() != oldModel.isIsQty()) {
            return true;
        }
        if (acct_ControlInfo.getAc() == 1 && newModel.isAC() != oldModel.isAC()) {
            return true;
        }
        if (acct_ControlInfo.getAcNotice() == 1 && newModel.isACNotice() != oldModel.isACNotice()) {
            return true;
        }
        if (acct_ControlInfo.getBw() == 1 && newModel.isBw() != oldModel.isBw()) {
            return true;
        }
        return acct_ControlInfo.getControl() == 1 && newModel.getControl().getValue() != oldModel.getControl().getValue();
    }

    protected void checkImportAllGAccountsAsCAccounts(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        String sql = "SELECT COUNT(*) AS accountCount FROM T_BD_AccountView WHERE FCompanyID=?";
        IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyPK.toString()});
        int count = 0;
        try {
            while (rs.next()) {
                count = rs.getInt("accountCount");
            }
        }
        catch (SQLException err) {
            throw new BOSException((Throwable)err);
        }
        if (count > 0) {
            throw new AccountException(AccountException.IMPORT_ALL_GA_NOT_ALLOWED);
        }
    }

    protected AccountTableInfo getAccountTableInfo(Context ctx, IObjectPK tablePK) throws EASBizException, BOSException {
        return AccountTableFactory.getLocalInstance(ctx).getAccountTableInfo(tablePK);
    }

    @Override
    protected void _importAllGAccountsAsCAccounts(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        IObjectPK[] importPKs;
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        if (iCompanyOrgUnit.exists(companyPK)) {
            CompanyOrgUnitInfo org = iCompanyOrgUnit.getCompanyOrgUnitInfo(companyPK);
            AccountTools.checkCompanyAccountTable(ctx, org);
            String sql = "SELECT FID FROM T_BD_AccountView WHERE FCompanyID IS NULL AND FIsLeaf=1 AND FLevel=FGLevel ORDER BY FNumber";
            IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql);
            importPKs = new IObjectPK[]{};
            try {
                rs.last();
                int size = rs.getRow();
                rs.first();
                rs.previous();
                importPKs = new IObjectPK[size];
                for (int i = 0; i < size; ++i) {
                    if (!rs.next()) continue;
                    String fid = rs.getString("FID");
                    importPKs[i] = new ObjectUuidPK(BOSUuid.read((String)fid));
                }
            }
            catch (SQLException err) {
                throw new BOSException((Throwable)err);
            }
        } else {
            throw new AccountException(AccountException.COMPANY_NOT_EXIST);
        }
        this._importGAccountsAsCAccounts(ctx, companyPK, importPKs);
    }

    protected AccountViewInfo getAccountByNumber(Context ctx, IObjectPK tablePK, IObjectPK companyPK, String number) throws BOSException, EASBizException {
        AccountViewInfo account = null;
        boolean isGrpAccount = companyPK == null;
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        if (companyPK != null) {
            companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(companyPK);
        }
        String sql = null;
        IRowSet rs = null;
        if (isGrpAccount) {
            sql = "SELECT FID, FParentID, FIsLeaf FROM T_BD_AccountView WHERE FAccountTableID=? AND FCompanyID IS NULL AND FNumber=?";
            rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{tablePK.toString(), number});
        } else {
            sql = "SELECT FID, FParentID, FIsLeaf FROM T_BD_AccountView WHERE FAccountTableID=?  AND FCompanyID=? AND FNumber=?";
            rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{tablePK.toString(), companyPK.toString(), number});
        }
        try {
            if (rs.next()) {
                String id = rs.getString("FID");
                String pid = rs.getString("FParentID");
                int leafValue = rs.getInt("FIsLeaf");
                account = new AccountViewInfo();
                account.setId(BOSUuid.read((String)id));
                if (pid != null) {
                    AccountViewInfo tmp = new AccountViewInfo();
                    tmp.setId(BOSUuid.read((String)pid));
                    account.setParent(tmp);
                }
                account.setIsLeaf(leafValue == 1);
                account.setNumber(number);
                AccountTableInfo table = new AccountTableInfo();
                table.setId(BOSUuid.read((String)tablePK.toString()));
                account.setAccountTableID(table);
                if (companyPK != null) {
                    account.setCompanyID(companyInfo);
                    account.setCU(companyInfo.getCU());
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return account;
    }

    protected AccountViewCollection getAccountsByNumber(Context ctx, IObjectPK tablePK, String number) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)tablePK.toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("parent.control"));
        evi.getSelector().add(new SelectorItemInfo("companyid.cu.id"));
        AccountViewCollection accounts = this.getAccountsByDAO(ctx, evi);
        return accounts;
    }

    protected AccountViewCollection getAccountsByNumberUseSQL(Context ctx, IObjectPK tablePK, String number) throws BOSException, EASBizException {
        AccountViewCollection accounts = new AccountViewCollection();
        String sql = "SELECT FID FROM T_BD_AccountView WHERE FAccountTableID=? AND FNumber=?";
        IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{tablePK.toString(), number});
        try {
            if (rs.next()) {
                String id = rs.getString("FID");
                AccountViewInfo account = new AccountViewInfo();
                account.setId(BOSUuid.read((String)id));
                accounts.add(account);
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return accounts;
    }

    @Override
    protected void _importGAccountsAsCAccounts(Context ctx, IObjectPK companyPK, IObjectPK[] pks) throws BOSException, EASBizException {
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = iCompanyOrgUnit.getCompanyOrgUnitInfo(companyPK);
        ObjectUuidPK tablePK = null;
        int count = 0;
        if (pks != null) {
            for (int i = 0; i < pks.length; ++i) {
                Vector<AccountViewInfo> v = null;
                AccountViewInfo parentCA = null;
                AccountViewInfo ga = null;
                boolean isFirst = true;
                IObjectPK gaPK = pks[i];
                ga = (AccountViewInfo)super._getValue(ctx, gaPK);
                if (!ga.isIsLeaf() || ga.getLevel() != ga.getGLevel()) continue;
                do {
                    if (isFirst) {
                        tablePK = new ObjectUuidPK(ga.getAccountTableID().getId());
                        v = new Vector<AccountViewInfo>();
                        isFirst = false;
                    } else {
                        ga = (AccountViewInfo)super._getValue(ctx, gaPK);
                    }
                    AccountViewInfo ca = this.getAccountByNumber(ctx, (IObjectPK)tablePK, companyPK, ga.getNumber());
                    if (ca != null) {
                        parentCA = ca;
                        break;
                    }
                    v.add(0, ga);
                    ga = ga.getParent();
                    if (ga == null) continue;
                    gaPK = new ObjectUuidPK(ga.getId());
                } while (ga != null);
                if (v == null) continue;
                if (parentCA != null && parentCA.isIsLeaf() && v.size() > 0) {
                    this.setAccoutNonLeaf(ctx, new ObjectUuidPK(parentCA.getId()));
                }
                for (AccountViewInfo account : v) {
                    account.setParent(parentCA);
                    account.setId(null);
                    account.setCompanyID(company);
                    account.setCU(company.getCU());
                    account.setCAA(account.getGAA());
                    BOSUuid addnewID = BOSUuid.create((BOSObjectType)account.getBOSType());
                    this.innerAddnew(ctx, (IObjectPK)new ObjectUuidPK(addnewID), (IObjectValue)account);
                    parentCA = new AccountViewInfo();
                    parentCA.setId(addnewID);
                    ++count;
                }
            }
        }
    }

    protected void setAccoutNonLeaf(Context ctx, ObjectUuidPK pk) throws BOSException {
        String sql = "UPDATE T_BD_AccountView SET FIsLeaf=0 WHERE FID=?";
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
    }

    protected void setEnabled(Context ctx, IObjectPK pk, boolean enabled) throws BOSException, EASBizException {
        AccountViewInfo account = (AccountViewInfo)this._getValue(ctx, pk);
        boolean isCAccount = account.getCompanyID() != null;
        this.checkAccount(ctx, account, isCAccount, enabled);
        String sql = null;
        sql = isCAccount ? "SELECT FID FROM T_BD_AccountView WHERE FCompanyID=? AND FNumber LIKE ?" : "SELECT FID FROM T_BD_AccountView WHERE FAccountTableID=? AND FNumber LIKE ?";
        IRowSet rs = null;
        if (isCAccount) {
            rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{account.getCompanyID().getId().toString(), account.getNumber() + "%"});
            sql = enabled ? "UPDATE T_BD_AccountView SET FIsCFreeze=0 WHERE FID=?" : "UPDATE T_BD_AccountView SET FIsCFreeze=1 WHERE FID=?";
        } else {
            rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{account.getAccountTableID().getId().toString(), account.getNumber() + "%"});
            sql = enabled ? "UPDATE T_BD_AccountView SET FIsGFreeze=0 WHERE FID=?" : "UPDATE T_BD_AccountView SET FIsGFreeze=1 WHERE FID=?";
        }
        try {
            while (rs.next()) {
                com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{rs.getString("FID")});
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    protected void checkAccount(Context ctx, AccountViewInfo account, boolean isCAccount, boolean enabled) throws BOSException, EASBizException {
        if (isCAccount) {
            if (enabled) {
                if (account.isIsGFreeze()) {
                    throw new AccountException(AccountException.GDISABLED_NOT_C_ENABLE);
                }
                if (!account.isIsCFreeze()) {
                    throw new AccountException(AccountException.ENABLED_ALREADY);
                }
                for (AccountViewInfo parent = account.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent = (AccountViewInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(parent.getId()))).isIsCFreeze()) continue;
                    throw new AccountException(AccountException.ENABLE_MUST_AT_FIRST_DISABLED_NODE);
                }
            } else if (account.isIsCFreeze()) {
                throw new AccountException(AccountException.DISABLED_ALREADY);
            }
        } else if (enabled) {
            if (account.isIsGFreeze()) {
                for (AccountViewInfo parent = account.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent = (AccountViewInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(parent.getId()))).isIsGFreeze()) continue;
                    throw new AccountException(AccountException.ENABLE_MUST_AT_FIRST_DISABLED_NODE);
                }
            }
            if (!account.isIsGFreeze()) {
                throw new AccountException(AccountException.ENABLED_ALREADY);
            }
        } else if (account.isIsGFreeze()) {
            throw new AccountException(AccountException.DISABLED_ALREADY);
        }
    }

    @Override
    protected void _disableAccount(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AccountViewInfo acctInfo = this.getAccountViewInfo(ctx, pk, this.getSelectorItemCollection());
        AccountTools.isHasBalance(ctx, BOSUuid.read((String)pk.toString()), acctInfo);
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        try {
            this.checkSubIsinEnabledAcctRefContrast(ctx, acctInfo);
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String sql = "update t_bd_accountview set FIsSelfFreeze =1,FIsCFreeze=1,flastupdateuserid = '" + userId + "',flastupdatetime= getdate() where fid ='" + acctInfo.getId().toString() + "'";
            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql);
            ORMValueCacheService.getInstance().remove(ctx, acctInfo.getBOSType(), pk);
            String notLikeSql = this.getNotLikeSql(ctx, acctInfo);
            sql = "update t_bd_accountview set FIsGFreeze =1,FIsCFreeze=1,flastupdateuserid = '" + userId + "',flastupdatetime= getdate() where   fnumber ='" + acctInfo.getNumber() + "'  and faccounttableid ='" + acctInfo.getAccountTableID().getId().toString() + "'  and fcompanyid in(select fid from T_ORG_Company where  flongnumber like '" + acctInfo.getCompanyID().getLongNumber() + "!%' " + notLikeSql.toString() + ")";
            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql);
            sql = "update t_bd_accountview set FIsParentFreeze =1,FIsCFreeze=1,flastupdateuserid = '" + userId + "',flastupdatetime= getdate() where   flongnumber like '" + acctInfo.getLongNumber() + "!%'  and faccounttableid ='" + acctInfo.getAccountTableID().getId().toString() + "'  and fcompanyid in(select fid from T_ORG_Company where (flongnumber ='" + acctInfo.getCompanyID().getLongNumber() + "' or flongnumber like '" + acctInfo.getCompanyID().getLongNumber() + "!%') " + notLikeSql.toString() + ")";
            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql);
            String sqlStr = "select fid from t_bd_accountview where  (fnumber ='" + acctInfo.getNumber() + "'  or flongnumber like '" + acctInfo.getLongNumber() + "!%')  and faccounttableid ='" + acctInfo.getAccountTableID().getId().toString() + "'  and fcompanyid in(select fid from T_ORG_Company where (flongnumber ='" + acctInfo.getCompanyID().getLongNumber() + "' or flongnumber like '" + acctInfo.getCompanyID().getLongNumber() + "!%') " + notLikeSql.toString() + ")";
            this.removeCache(ctx, sqlStr, acctInfo.getBOSType());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getNotLikeSql(Context ctx, AccountViewInfo acctInfo) throws BOSException, SQLException {
        String sql = "select flongnumber from T_ORG_Company where fid in(select fcompanyid from T_BD_ACCOUNTVIEW where fnumber ='" + acctInfo.getNumber() + "' and faccounttableid ='" + acctInfo.getAccountTableID().getId().toString() + "' and fupperid is null ) and flongnumber like '" + acctInfo.getCompanyID().getLongNumber() + "!%'";
        IRowSet rowSet = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql);
        StringBuffer notLikeSql = new StringBuffer();
        if (rowSet != null && rowSet.size() >= 0) {
            while (rowSet.next()) {
                notLikeSql.append(" and (flongnumber !='" + rowSet.getString("flongnumber") + "'  and flongnumber not like '" + rowSet.getString("flongnumber") + "!%') ");
            }
        }
        return notLikeSql.toString();
    }

    private void checkIsInEnabledAcctref(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection seleColl = new SelectorItemCollection();
        seleColl.add(new SelectorItemInfo("id"));
        seleColl.add(new SelectorItemInfo("companyID.id"));
        seleColl.add(new SelectorItemInfo("accountTableID.id"));
        seleColl.add(new SelectorItemInfo("accountTableID.name"));
        AccountViewInfo acctInfo = AccountViewFactory.getLocalInstance(ctx).getAccountViewInfo(pk, seleColl);
        if (acctInfo == null || acctInfo.getId() == null) {
            return;
        }
        AccountRefContrastInfo acctrefInfo = AccountRefContrastFactory.getLocalInstance(ctx).getAcctInfoByDisabledAcctTable(acctInfo.getCompanyID().getId().toString(), acctInfo.getAccountTableID().getId().toString());
        if (acctrefInfo != null) {
            throw new AccountException(AccountException.ACCOUNTINENABLEDACTREF, new Object[]{acctInfo.getAccountTableID().getName()});
        }
    }

    private SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection selectorColl = new SelectorItemCollection();
        selectorColl.add("id");
        selectorColl.add("number");
        selectorColl.add("longnumber");
        selectorColl.add("accountTableID");
        selectorColl.add("companyID.longNumber");
        selectorColl.add("companyID.id");
        return selectorColl;
    }

    @Override
    protected void _enableAccount(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        block7: {
            try {
                String sqlToGetFreezeFlag = "SELECT TOP 1 FIsParentFreeze,FIsSelfFreeze,FIsGFreeze FROM T_BD_ACCOUNTVIEW WHERE FID=? and ( FIsParentFreeze<>0 or FIsSelfFreeze<>0 or FIsGFreeze<>0 )";
                IRowSet rsToGetFreezeFlag = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetFreezeFlag, (Object[])new Object[]{pk.toString()});
                if (rsToGetFreezeFlag != null && rsToGetFreezeFlag.next()) {
                    boolean isParentFreeze = rsToGetFreezeFlag.getBoolean("FIsParentFreeze");
                    boolean isSelfFreeze = rsToGetFreezeFlag.getBoolean("FIsSelfFreeze");
                    boolean isGFreeze = rsToGetFreezeFlag.getBoolean("FIsGFreeze");
                    if (isParentFreeze) {
                        throw new AccountException(AccountException.CANNOTENABLEPARDIS);
                    }
                    if (isGFreeze) {
                        throw new AccountException(AccountException.CANNOTENABLEUPDIS);
                    }
                    if (isSelfFreeze) {
                        AccountViewInfo acctInfo = this.getAccountViewInfo(ctx, pk, this.getSelectorItemCollection());
                        this.checkSubIsinEnabledAcctRefContrast(ctx, acctInfo);
                        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                        String sqlToUpdateCFreezeFlag = "UPDATE T_BD_ACCOUNTVIEW SET FIsSelfFreeze=0,FIsCFreeze=0,flastupdateuserid = '" + userId + "',flastupdatetime = getdate() WHERE FID=?";
                        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sqlToUpdateCFreezeFlag, (Object[])new Object[]{pk.toString()});
                        ORMValueCacheService.getInstance().remove(ctx, acctInfo.getBOSType(), pk);
                        String notLikeSql = this.getNotLikeSql(ctx, acctInfo);
                        String sql = "update t_bd_accountview set FIsGFreeze =0,FIsCFreeze=0,flastupdateuserid = '" + userId + "',flastupdatetime = getdate() where   fnumber ='" + acctInfo.getNumber() + "'  and faccounttableid ='" + acctInfo.getAccountTableID().getId().toString() + "'  and FIsParentFreeze = 0  and FIsSelfFreeze = 0  and fcompanyid in(select fid from T_ORG_Company where  flongnumber like '" + acctInfo.getCompanyID().getLongNumber() + "!%' " + notLikeSql.toString() + ")";
                        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql);
                        sql = "update t_bd_accountview set FIsGFreeze =0 ,flastupdateuserid = '" + userId + "',flastupdatetime = getdate() where   fnumber ='" + acctInfo.getNumber() + "'  and faccounttableid ='" + acctInfo.getAccountTableID().getId().toString() + "'  and (FIsParentFreeze != 0 or FIsSelfFreeze != 0)  and fcompanyid in(select fid from T_ORG_Company where  flongnumber like '" + acctInfo.getCompanyID().getLongNumber() + "!%' " + notLikeSql.toString() + ")";
                        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql);
                        sql = "update t_bd_accountview acc1 set FIsParentFreeze =0,FIsCFreeze=0 ,flastupdateuserid = '" + userId + "',flastupdatetime = getdate() where   flongnumber like '" + acctInfo.getLongNumber() + "!%'  and faccounttableid ='" + acctInfo.getAccountTableID().getId().toString() + "'  and FIsGFreeze = 0  and FIsSelfFreeze = 0  and exists(select 1 from t_bd_accountview acc2 where acc2.fnumber='" + acctInfo.getNumber() + "' and acc1.fcompanyid = acc2.fcompanyid and fiscfreeze =0)  and fcompanyid in(select fid from T_ORG_Company where (flongnumber='" + acctInfo.getCompanyID().getLongNumber() + "' or flongnumber like '" + acctInfo.getCompanyID().getLongNumber() + "!%') " + notLikeSql.toString() + ")";
                        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql);
                        sql = "update t_bd_accountview set FIsParentFreeze =0 ,flastupdateuserid = '" + userId + "',flastupdatetime = getdate() where   flongnumber like '" + acctInfo.getLongNumber() + "!%'  and faccounttableid ='" + acctInfo.getAccountTableID().getId().toString() + "'  and (FIsGFreeze != 0 or FIsSelfFreeze != 0)  and fcompanyid in(select fid from T_ORG_Company where (flongnumber ='" + acctInfo.getCompanyID().getLongNumber() + "' or flongnumber like '" + acctInfo.getCompanyID().getLongNumber() + "!%') " + notLikeSql.toString() + ")";
                        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql);
                        sql = "select fid from t_bd_accountview where  (fnumber ='" + acctInfo.getNumber() + "'  or flongnumber like '" + acctInfo.getLongNumber() + "!%')  and faccounttableid ='" + acctInfo.getAccountTableID().getId().toString() + "'  and fcompanyid in(select fid from T_ORG_Company where (flongnumber ='" + acctInfo.getCompanyID().getLongNumber() + "' or flongnumber like '" + acctInfo.getCompanyID().getLongNumber() + "!%') " + notLikeSql.toString() + ")";
                        this.removeCache(ctx, sql, acctInfo.getBOSType());
                        sql = "select fid from t_bd_accountview where flongnumber like '" + acctInfo.getLongNumber() + "!%'  and faccounttableid ='" + acctInfo.getAccountTableID().getId().toString() + "'  and FIsSelfFreeze = 1  and fcompanyid in(select fid from T_ORG_Company where (flongnumber='" + acctInfo.getCompanyID().getLongNumber() + "' or flongnumber like '" + acctInfo.getCompanyID().getLongNumber() + "!%') " + notLikeSql.toString() + ")";
                        IRowSet rowSet = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql);
                        if (rowSet != null && rowSet.next()) {
                            String fid = rowSet.getString("fid");
                            this._disableAccount(ctx, (IObjectPK)new ObjectUuidPK(fid));
                        }
                    }
                    break block7;
                }
                throw new AccountException(AccountException.ENABLED_ALREADY);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void checkSubIsinEnabledAcctRefContrast(Context ctx, AccountViewInfo acctInfo) throws BOSException, EASBizException {
        StringBuffer fidStringBuffer = new StringBuffer();
        StringBuffer detailMessage = new StringBuffer();
        IRowSet rowSet = this.getAllInferiorAcct(ctx, acctInfo);
        ArrayList<String> fids = new ArrayList<String>();
        if (rowSet != null && rowSet.size() > 0) {
            try {
                while (rowSet.next()) {
                    if (StringUtils.isEmpty((String)rowSet.getString("fid"))) continue;
                    fids.add(rowSet.getString("fid"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        fids.add(acctInfo.getId().toString());
        int batchSize = 1000;
        StringBuilder fidStr = new StringBuilder();
        for (int i = 0; i < fids.size(); i += batchSize) {
            fidStr.setLength(0);
            int endIndex = Math.min(i + batchSize, fids.size());
            List batchFids = fids.subList(i, endIndex);
            for (int j = 0; j < batchFids.size(); ++j) {
                fidStr.append("'").append((String)batchFids.get(j)).append("'");
                if (j >= batchFids.size() - 1) continue;
                fidStr.append(",");
            }
            String sql = " select t_org_company.fnumber companyNumber from t_bd_acctrefcontrast,t_org_company  where t_bd_acctrefcontrast.fid in(  select distinct FAcctRefContrastID from T_BD_AcctRefContrastEntry where FOldAcctID in (" + fidStr.toString() + ")) and FIsEnabled=1  and t_bd_acctrefcontrast.fcompanyid=t_org_company.fid";
            IRowSet row = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql);
            if (row == null || row.size() <= 0) continue;
            try {
                while (row.next()) {
                    detailMessage.append(ResourceBase.getString((String)RESOURCE, (String)"companyNumber", (Locale)ctx.getLocale()) + ":" + row.getString("companyNumber") + "\n");
                }
                if (StringUtils.isEmpty((String)detailMessage.toString())) continue;
                throw new HeadDetailException(ResourceBase.getString((String)RESOURCE, (String)"subAcctInEnabledAcctRefContrast", (Locale)ctx.getLocale()), detailMessage.toString(), 1);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private IRowSet getAllInferiorAcct(Context ctx, AccountViewInfo acctInfo) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("id");
        coll.add("companyID.*");
        view.setSelector(coll);
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("upper", (Object)acctInfo.getId().toString()));
        AccountViewCollection accountViewCollection = this.getAccountViewCollection(ctx, view);
        if (accountViewCollection == null || accountViewCollection.size() == 0) {
            return null;
        }
        StringBuffer companyIds = new StringBuffer();
        int count = accountViewCollection.size();
        for (int i = 0; i < count; ++i) {
            AccountViewInfo inferiorAcctInfo = accountViewCollection.get(i);
            String companyLongnumber = inferiorAcctInfo.getCompanyID().getLongNumber();
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)companyLongnumber));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(companyLongnumber + "!%"), CompareType.LIKE));
            filter.setMaskString("#0 or #1");
            CompanyOrgUnitCollection companyOrgUnitColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
            for (int j = 0; j < companyOrgUnitColl.size(); ++j) {
                if (j > 0 || !StringUtils.isEmpty((String)companyIds.toString())) {
                    companyIds.append(",");
                }
                companyIds.append("'").append(companyOrgUnitColl.get(j).getId().toString()).append("'");
            }
        }
        String sqlToUpdateCFreezeFlag = "SELECT FID,FIsGFreeze,FIsCFreeze,FIsParentFreeze,FIsSelfFreeze from t_bd_accountview WHERE FLONGNUMBER like '" + acctInfo.getLongNumber() + "%' and FAccountTableID ='" + acctInfo.getAccountTableID().getId().toString() + "' and  FCOMPANYID IN (" + companyIds.toString() + ")";
        IRowSet rsAllInferior = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToUpdateCFreezeFlag);
        return rsAllInferior;
    }

    protected boolean isRealHasDeal(Context ctx, IObjectPK pk) {
        boolean isHasDeal = false;
        try {
            isHasDeal = this._isHasDeal(ctx, pk);
        }
        catch (Exception e) {
            isHasDeal = true;
        }
        return isHasDeal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkHasDeal(Context ctx, AccountViewInfo newModel, AccountViewInfo oldModel) throws BOSException, EASBizException {
        if (!this.isRealHasDeal(ctx, (IObjectPK)new ObjectUuidPK(oldModel.getId()))) return;
        if (oldModel.getGAA() != null) {
            if (newModel.getGAA() == null) throw new BizHasDealException(BizHasDealException.BIZ_HASDEAL);
            if (!oldModel.getGAA().getId().toString().equals(newModel.getGAA().getId().toString())) {
                throw new BizHasDealException(BizHasDealException.BIZ_HASDEAL);
            }
        } else if (newModel.getGAA() != null) {
            throw new BizHasDealException(BizHasDealException.BIZ_HASDEAL);
        }
        if (oldModel.getCAA() != null) {
            if (newModel.getCAA() == null) throw new BizHasDealException(BizHasDealException.BIZ_HASDEAL);
            if (!oldModel.getCAA().getId().toString().equals(newModel.getCAA().getId().toString())) {
                throw new BizHasDealException(BizHasDealException.BIZ_HASDEAL);
            }
        } else if (newModel.getCAA() != null) {
            throw new BizHasDealException(BizHasDealException.BIZ_HASDEAL);
        }
        if (oldModel.getAccountingcurrency().getValue() == AccountingCurrencyEnum.ALLCURRENCY.getValue() && newModel.getAccountingcurrency().getValue() == 1) {
            throw new BizHasDealException(BizHasDealException.BIZ_HASDEAL);
        }
        if (oldModel.getAccountingcurrency().getValue() == 1 && newModel.getAccountingcurrency().getValue() == 1 && newModel.getCurrencyID().getId().toString().equals(oldModel.getCurrencyID().getId().toString())) {
            throw new BizHasDealException(BizHasDealException.BIZ_HASDEAL);
        }
        if (oldModel.isIsCash() != newModel.isIsCash()) {
            throw new BizHasDealException(BizHasDealException.BIZ_HASDEAL);
        }
        if (oldModel.isIsBank() != newModel.isIsBank()) {
            throw new BizHasDealException(BizHasDealException.BIZ_HASDEAL);
        }
        if (oldModel.isIsCashEquivalent() != newModel.isIsCashEquivalent()) {
            throw new BizHasDealException(BizHasDealException.BIZ_HASDEAL);
        }
        if (!oldModel.isIsQty() && newModel.isIsQty()) {
            throw new BizHasDealException(BizHasDealException.BIZ_HASDEAL);
        }
        if (oldModel.isAC() != newModel.isAC()) {
            throw new BizHasDealException(BizHasDealException.BIZ_HASDEAL);
        }
        if (oldModel.isACNotice() != newModel.isACNotice()) {
            throw new BizHasDealException(BizHasDealException.BIZ_HASDEAL);
        }
        if (oldModel.isBw() != newModel.isBw()) {
            throw new BizHasDealException(BizHasDealException.BIZ_HASDEAL);
        }
        if (!oldModel.getAccountTypeID().getId().toString().equals(newModel.getAccountTypeID().getId().toString())) {
            throw new BizHasDealException(BizHasDealException.BIZ_HASDEAL);
        }
        if (oldModel.getPLType() != newModel.getPLType()) {
            throw new BizHasDealException(BizHasDealException.BIZ_HASDEAL);
        }
        if (oldModel.getControl() == AccountControlAttribute.NONE || oldModel.getControl() == newModel.getControl()) return;
        throw new BizHasDealException(BizHasDealException.BIZ_HASDEAL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkHasBizReferrence(Context ctx, AccountViewInfo newModel, AccountViewInfo oldModel) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(oldModel.getId());
        if (!BizCheckerUtil.isReferenced((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString())).isFound()) return;
        if (oldModel.getGAA() != null) {
            if (newModel.getGAA() == null) throw new BizReferenceException(BizReferenceException.BIZ_REFENCED);
            if (!oldModel.getGAA().getId().toString().equals(newModel.getGAA().getId().toString())) {
                throw new BizReferenceException(BizReferenceException.BIZ_REFENCED);
            }
        } else if (newModel.getGAA() != null) {
            throw new BizReferenceException(BizReferenceException.BIZ_REFENCED);
        }
        if (oldModel.getCAA() != null) {
            if (newModel.getCAA() == null) throw new BizReferenceException(BizReferenceException.BIZ_REFENCED);
            if (!oldModel.getCAA().getId().toString().equals(newModel.getCAA().getId().toString())) {
                throw new BizReferenceException(BizReferenceException.BIZ_REFENCED);
            }
        } else if (newModel.getCAA() != null) {
            throw new BizReferenceException(BizReferenceException.BIZ_REFENCED);
        }
        if (oldModel.getAccountingcurrency().getValue() == AccountingCurrencyEnum.ALLCURRENCY.getValue() && newModel.getAccountingcurrency().getValue() == 1) {
            throw new BizReferenceException(BizReferenceException.BIZ_REFENCED);
        }
        if (oldModel.getAccountingcurrency().getValue() == 1 && newModel.getAccountingcurrency().getValue() == 1 && newModel.getCurrencyID().getId().toString().equals(oldModel.getCurrencyID().getId().toString())) {
            throw new BizReferenceException(BizReferenceException.BIZ_REFENCED);
        }
        if (oldModel.isIsCash() != newModel.isIsCash()) {
            throw new BizReferenceException(BizReferenceException.BIZ_REFENCED);
        }
        if (oldModel.isIsBank() != newModel.isIsBank()) {
            throw new BizReferenceException(BizReferenceException.BIZ_REFENCED);
        }
        if (oldModel.isIsCashEquivalent() != newModel.isIsCashEquivalent()) {
            throw new BizReferenceException(BizReferenceException.BIZ_REFENCED);
        }
        if (!oldModel.isIsQty() && newModel.isIsQty()) {
            throw new BizReferenceException(BizReferenceException.BIZ_REFENCED);
        }
        if (oldModel.isAC() != newModel.isAC()) {
            throw new BizReferenceException(BizReferenceException.BIZ_REFENCED);
        }
        if (oldModel.isACNotice() != newModel.isACNotice()) {
            throw new BizReferenceException(BizReferenceException.BIZ_REFENCED);
        }
        if (oldModel.isBw() != newModel.isBw()) {
            throw new BizReferenceException(BizReferenceException.BIZ_REFENCED);
        }
        if (!oldModel.getAccountTypeID().getId().toString().equals(newModel.getAccountTypeID().getId().toString())) {
            throw new BizHasDealException(BizHasDealException.BIZ_HASDEAL);
        }
        if (oldModel.getPLType() != newModel.getPLType()) {
            throw new BizReferenceException(BizReferenceException.BIZ_REFENCED);
        }
        if (oldModel.getControl() == AccountControlAttribute.NONE || oldModel.getControl() == newModel.getControl()) return;
        throw new BizReferenceException(BizReferenceException.BIZ_REFENCED);
    }

    @Override
    protected void _updateByCompany(Context ctx, IObjectPK companyID, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _deleteByCompany(Context ctx, IObjectPK CompanyPK) throws BOSException, EASBizException {
        switch (this.getEASModeValue(ctx)) {
            case 0: {
                break;
            }
            case 1: {
                try {
                    String sql0 = "Delete From T_BD_AccountView WHERE FCompanyID=?";
                    com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql0, (Object[])new Object[]{CompanyPK.toString()});
                    break;
                }
                catch (BOSException e) {
                    throw new AccountException(AccountException.DELETE_ALL_CA_FAILED, e);
                }
            }
        }
    }

    @Override
    protected void _updateByCompany(Context ctx, IObjectPK companyPK, IObjectPK oldAccountTablePK, IObjectPK newAccountTablePK) throws BOSException, EASBizException {
        switch (this.getEASModeValue(ctx)) {
            case 0: {
                break;
            }
            case 1: {
                if (oldAccountTablePK != null) {
                    this._deleteByCompany(ctx, companyPK);
                }
                if (newAccountTablePK == null) {
                    return;
                }
                if (oldAccountTablePK == null || newAccountTablePK == null || oldAccountTablePK.equals((Object)newAccountTablePK)) break;
                this.copyAccountsByCompanyDM(ctx, companyPK);
            }
        }
    }

    @Override
    protected IObjectCollection _getChildrenList(Context ctx, IObjectPK pk, IObjectPK companyID) throws BOSException, EASBizException {
        AccountViewCollection vet = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (companyID != null) {
            filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)companyID.toString().trim()));
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)pk.toString().trim()));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString().trim(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("companyID", null));
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)pk.toString().trim()));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString().trim(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2");
        }
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("accountTableID.name"));
        evi.getSelector().add(new SelectorItemInfo("accountTypeID.name"));
        evi.getSelector().add(new SelectorItemInfo("account.name"));
        evi.getSelector().add(new SelectorItemInfo("companyID.name"));
        evi.getSelector().add(new SelectorItemInfo("currencyID.name"));
        evi.getSelector().add(new SelectorItemInfo("measureUnitGroupID.name"));
        evi.getSelector().add(new SelectorItemInfo("measureUnitID.name"));
        evi.getSelector().add(new SelectorItemInfo("GAA.name"));
        evi.getSelector().add(new SelectorItemInfo("CAA.name"));
        evi.getSorter().add(new SorterItemInfo("number"));
        vet = this.getAccountsByDAO(ctx, evi);
        return vet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AccountViewCollection getAccountsByDAO(Context ctx, EntityViewInfo evi) throws BOSException, EASBizException {
        AccountViewCollection accounts = new AccountViewCollection();
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            accounts = (AccountViewCollection)super.getDAO(ctx, cn).getCollection(evi);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return accounts;
    }

    @Override
    protected IObjectCollection _getListByType(Context ctx, IObjectPK accountTypeID, IObjectPK companyID) throws BOSException, EASBizException {
        AccountViewCollection accountViewC = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (companyID != null) {
            filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)companyID.toString().trim()));
            filter.getFilterItems().add(new FilterItemInfo("accountTypeID", (Object)accountTypeID.toString().trim()));
            filter.setMaskString("#0 and #1");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("accountTypeID", (Object)accountTypeID.toString().trim()));
            filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()));
            filter.setMaskString("#0 and #1");
        }
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("accountTableID.name"));
        evi.getSelector().add(new SelectorItemInfo("accountTypeID.name"));
        evi.getSelector().add(new SelectorItemInfo("parent.name"));
        evi.getSelector().add(new SelectorItemInfo("GAA.name"));
        evi.getSelector().add(new SelectorItemInfo("CAA.name"));
        evi.getSelector().add(new SelectorItemInfo("CU.name"));
        evi.getSelector().add(new SelectorItemInfo("companyID.name"));
        evi.getSelector().add(new SelectorItemInfo("measureUnitGroupID.name"));
        evi.getSelector().add(new SelectorItemInfo("measureUnitID.name"));
        evi.getSorter().add(new SorterItemInfo("number"));
        accountViewC = this.getAccountsByDAO(ctx, evi);
        return accountViewC;
    }

    protected void deleteCM(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean isGrpAccount;
        AccountViewInfo account = (AccountViewInfo)super._getValue(ctx, pk);
        this.deleteCMCheck(account);
        boolean bl = isGrpAccount = account.getCompanyID() == null;
        if (isGrpAccount) {
            String sql = "SELECT 1 FROM T_BD_AccountView WHERE FAccountTableID=? and FNumber=? and FCompanyID IS NOT NULL";
            IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{account.getAccountTableID().getId().toString(), account.getNumber()});
            try {
                if (rs.next()) {
                    throw new AccountException(AccountException.CANNOT_DELETE_IMPORTED_GA);
                }
            }
            catch (SQLException ex) {
                throw new BOSException((Throwable)ex);
            }
            this.runDelete(ctx, pk);
        } else if (account.getLevel() <= account.getGLevel()) {
            AccountViewInfo parent = null;
            AccountViewInfo delAccount = account;
            while (delAccount != null && delAccount.isIsLeaf()) {
                parent = delAccount.getParent();
                this.runDelete(ctx, (IObjectPK)new ObjectUuidPK(delAccount.getId()));
                if (parent != null) {
                    delAccount = (AccountViewInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(parent.getId()));
                    continue;
                }
                delAccount = null;
            }
        } else {
            this.runDelete(ctx, pk);
        }
    }

    protected void deleteCMCheck(AccountViewInfo account) throws AccountException {
        if (!account.isIsLeaf()) {
            throw new AccountException(AccountException.CANNOT_DELETE_NONLEAF_ACCOUNT);
        }
    }

    protected void runDelete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        BizCheckResult rs = AccountTools.hasDeal(ctx, BOSUuid.read((String)pk.toString()));
        if (rs.isFound()) {
            EASBizException e = rs.getException();
            if (e != null) {
                throw rs.getException();
            }
            throw new BizHasDealException(BizHasDealException.BIZ_HASDEAL);
        }
        super._delete(ctx, pk);
    }

    protected void deleteDM(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AccountViewInfo account = (AccountViewInfo)super._getValue(ctx, pk);
        IObjectPK[] delPKs = null;
        String sql = "SELECT FID FROM T_BD_AccountView WHERE FAccountTableID=? and FNumber=?";
        IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{account.getAccountTableID().getId().toString(), account.getNumber()});
        try {
            rs.last();
            int size = rs.getRow();
            rs.first();
            rs.previous();
            delPKs = new IObjectPK[size];
            for (int i = 0; i < size; ++i) {
                if (!rs.next()) continue;
                String fid = rs.getString("FID");
                delPKs[i] = new ObjectUuidPK(BOSUuid.read((String)fid));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        for (int i = 0; i < delPKs.length; ++i) {
            this.runDelete(ctx, delPKs[i]);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        AccountViewInfo accountView = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("parent.*");
        accountView = this.getAccountViewInfo(ctx, pk, selector);
        if (accountView == null) {
            return;
        }
        this.deleteCheck(ctx, accountView);
    }

    protected void deleteCheck(Context ctx, AccountViewInfo accountView) throws EASBizException, BOSException {
        String parentId;
        String upperId;
        block35: {
            ObjectUuidPK pk;
            block33: {
                boolean refered;
                if (!this.isCUBDAllowDelete(ctx, accountView)) {
                    throw new AccountException(AccountException.CUBD_CANNOT_ADDREMOVE);
                }
                if (accountView.getUpper() != null) {
                    throw new AccountException(AccountException.CANTDELETEASSIGNEDACCOUNT);
                }
                pk = new ObjectUuidPK(accountView.getId());
                upperId = null;
                parentId = null;
                String accountNumber = null;
                String fparentnumber = null;
                if (accountView.getUpper() != null) {
                    upperId = accountView.getUpper().getId().toString();
                }
                if (accountView.getParent() != null) {
                    parentId = accountView.getParent().getId().toString();
                    fparentnumber = accountView.getParent().getNumber();
                }
                accountNumber = accountView.getNumber();
                int FControlLevel = accountView.getControlLevel();
                int Level2 = accountView.getLevel();
                if (upperId != null && upperId.length() > 0) {
                    if (FControlLevel > Level2) {
                        throw new AccountException(AccountException.CANNOTDELACCOUNT);
                    }
                    boolean canDelete = AccountTools.checkAccountCanDelete(ctx, ContextUtil.getCurrentCtrlUnit((Context)ctx));
                    if (!canDelete) {
                        throw new AccountException(AccountException.CURRENTCUCANNOTDELETEUPPERACCOUNT);
                    }
                }
                String sqlToCheckHasRefByAccount = "SELECT TOP 1 Fnumber FROM T_BD_ACCOUNTVIEW WHERE FPARENTID=? OR FUPPERID=?";
                IRowSet rsToCheckHasRefByAccount = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToCheckHasRefByAccount, (Object[])new Object[]{accountView.getId().toString(), accountView.getId().toString()});
                try {
                    if (rsToCheckHasRefByAccount != null && rsToCheckHasRefByAccount.next()) {
                        rsToCheckHasRefByAccount.getString("Fnumber");
                        throw new AccountException(AccountException.DELETEACCOUNTHASREFER, new Object[]{accountNumber});
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
                boolean hasParent = false;
                if (parentId != null) {
                    try {
                        hasParent = this.hasParent(ctx, accountView);
                    }
                    catch (SQLException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new BOSException(e.getMessage(), (Throwable)e);
                    }
                }
                if ((refered = this.checkIsAccountHasDeal(ctx, accountView, true)) && !hasParent) {
                    if (this.checkerName != null) {
                        if (this.accountCheck != null && this.accountCheck.getException() != null) {
                            throw this.accountCheck.getException();
                        }
                        throw new AccountException(AccountException.ACCOUNTBIZ, new Object[]{AcctRefContrastHelper.getSubSystemName(ctx, this.checkerName)});
                    }
                    throw new AccountException(AccountException.DELETEACCOUNTHASDEAL);
                }
                boolean bl = hasParent = hasParent && refered;
                if (AccountTools.isInEnabledAcctRefContrast(ctx, accountView)) {
                    throw new AccountException(AccountException.ACCTINENALBEDACCTREF, new Object[]{accountView.getNumber()});
                }
                AcctRefContrastHelper.delAcctRef(ctx, pk.toString());
                if (!hasParent) break block33;
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("*"));
                selector.add(new SelectorItemInfo("parent.companyID.*"));
                selector.add(new SelectorItemInfo("accountCurrency.*"));
                selector.add(new SelectorItemInfo("accountTypeID.*"));
                selector.add(new SelectorItemInfo("upper.*"));
                selector.add(new SelectorItemInfo("upper.accountTypeID.*"));
                selector.add(new SelectorItemInfo("upper.accountCurrency.*"));
                AccountViewInfo parent = AccountViewFactory.getLocalInstance(ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountView.getParent().getId()), selector);
                parent.setNumber(fparentnumber);
                parent.setIsLeaf(true);
                parent.setId(accountView.getId());
                ObjectUuidPK pPk = new ObjectUuidPK(parentId);
                String companyId = parent.getCompanyID().getId().toString();
                Statement stmt = null;
                Connection cn = null;
                try {
                    cn = EJBFactory.getConnection((Context)ctx);
                    stmt = cn.createStatement();
                    String updateParent = " update T_BD_ACCOUNTVIEW set fnumber='*#'||fnumber,flongnumber='*#'||flongnumber where fid= '" + parentId + "' ";
                    stmt.addBatch(updateParent);
                    String updateSel = null;
                    if (parent.getParent() != null) {
                        updateSel = " update T_BD_ACCOUNTVIEW set fparentid='" + parent.getParent().getId().toString() + "',fControlLevel= " + parent.getControlLevel() + " where fid='" + pk.toString() + "' ";
                        stmt.addBatch(updateSel);
                    } else {
                        updateSel = " update T_BD_ACCOUNTVIEW set fparentid=null ,fControlLevel= " + parent.getControlLevel() + " where fid='" + pk.toString() + "' ";
                        stmt.addBatch(updateSel);
                    }
                    updateSel = "update T_BD_ACCOUNTVIEW set FUpperID='" + pk.toString() + "' where FUpperID='" + pPk.toString() + "' ";
                    stmt.addBatch(updateSel);
                    updateSel = "update T_BD_AcctRefContrastEntry set FNewAcctID='" + pk.toString() + "' where FNewAcctID='" + pPk.toString() + "' ";
                    stmt.addBatch(updateSel);
                    String deleteSql = "delete from t_bd_accountcurrency where faccountviewid='" + pPk.toString() + "' ";
                    stmt.addBatch(deleteSql);
                    String deleteVoucherEntrySql = "delete from t_gl_VoucherEntry where FAccountID ='" + pPk.toString() + "' ";
                    stmt.addBatch(deleteVoucherEntrySql);
                    String deleteInitAccountBalanceSql = "delete from t_gl_InitAccountBalance where FAccountID ='" + pPk.toString() + "' ";
                    stmt.addBatch(deleteInitAccountBalanceSql);
                    String deleteInitAssistBalanceSql = "delete from t_gl_InitAssistBalance  where FAccountID ='" + pPk.toString() + "' ";
                    stmt.addBatch(deleteInitAssistBalanceSql);
                    String accountId = pPk.toString();
                    this.removeGLBalance(stmt, "t_gl_AccountBalance_1f", accountId);
                    this.removeGLBalance(stmt, "t_gl_AccountBalance_1l", accountId);
                    this.removeGLBalance(stmt, "t_gl_AccountBalance_1r", accountId);
                    this.removeGLBalance(stmt, "t_gl_AccountBalance_5f", accountId);
                    this.removeGLBalance(stmt, "t_gl_AccountBalance_5l", accountId);
                    this.removeGLBalance(stmt, "t_gl_AccountBalance_5r", accountId);
                    this.removeGLBalance(stmt, "t_gl_AssistBalance_1f", accountId);
                    this.removeGLBalance(stmt, "t_gl_AssistBalance_1l", accountId);
                    this.removeGLBalance(stmt, "t_gl_AssistBalance_1r", accountId);
                    this.removeGLBalance(stmt, "t_gl_AssistBalance_5f", accountId);
                    this.removeGLBalance(stmt, "t_gl_AssistBalance_5l", accountId);
                    this.removeGLBalance(stmt, "t_gl_AssistBalance_5r", accountId);
                    this.removeGLBalance(stmt, "t_gl_Assistmeasurebalance_1f", accountId);
                    this.removeGLBalance(stmt, "t_gl_Assistmeasurebalance_1l", accountId);
                    this.removeGLBalance(stmt, "t_gl_Assistmeasurebalance_1r", accountId);
                    this.removeGLBalance(stmt, "t_gl_Assistmeasurebalance_5f", accountId);
                    this.removeGLBalance(stmt, "t_gl_Assistmeasurebalance_5l", accountId);
                    this.removeGLBalance(stmt, "t_gl_Assistmeasurebalance_5r", accountId);
                    String deleteFlagSql = "delete from t_gl_flag where fkey  ='" + pPk.toString() + "' ";
                    stmt.addBatch(deleteFlagSql);
                    stmt.executeBatch();
                    ORMValueCacheService.getInstance().remove(ctx, accountView.getBOSType(), (IObjectPK)pk);
                    ORMValueCacheService.getInstance().remove(ctx, accountView.getBOSType(), parentId);
                    String sql = "select fid from  T_BD_ACCOUNTVIEW  where FUpperID='" + pPk.toString() + "' ";
                    this.removeCache(ctx, sql, accountView.getBOSType());
                    sql = "select fid  from  T_BD_AcctRefContrastEntry where FNewAcctID='" + pPk.toString() + "' ";
                    AccountRefContrastEntryInfo contrast = new AccountRefContrastEntryInfo();
                    this.removeCache(ctx, sql, contrast.getBOSType());
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new BOSException(e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(stmt, (Connection)cn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)stmt, (Connection)cn);
                this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)parent);
                refered = this._isHasDeal(ctx, (IObjectPK)pPk);
                if (refered) {
                    throw new AccountException(AccountException.DELETEACCOUNTHASDEAL);
                }
                String deleteSQL = "delete from t_bd_accountview where fid = ?";
                com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)deleteSQL, (Object[])new Object[]{pPk.toString()});
                ORMValueCacheService.getInstance().remove(ctx, accountView.getBOSType(), (IObjectPK)pPk);
                parentId = pk.toString();
                break block35;
            }
            super._delete(ctx, (IObjectPK)pk);
            this.removeGlFlag(ctx, pk.toString());
        }
        if (upperId != null && upperId.length() > 0) {
            try {
                while (parentId != null && parentId.length() > 0) {
                    String sqlToGetParent = "SELECT FGLevel,FLevel,fcontrollevel,FParentID FROM T_BD_ACCOUNTVIEW WHERE FID=?";
                    IRowSet rsToGetParent = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetParent, (Object[])new Object[]{parentId});
                    if (rsToGetParent == null || !rsToGetParent.next()) continue;
                    int gLevel = rsToGetParent.getInt("FGLevel");
                    int level = rsToGetParent.getInt("FLevel");
                    int controllevel = rsToGetParent.getInt("fcontrollevel");
                    if (gLevel > level) {
                        String sqlToGetMinGLevel = "SELECT MIN(FGLevel) MINGLEVEL FROM T_BD_ACCOUNTVIEW WHERE FPARENTID=?";
                        IRowSet rsToGetMinGLevel = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetMinGLevel, (Object[])new Object[]{parentId});
                        int minGLevel = level;
                        if (rsToGetMinGLevel != null && rsToGetMinGLevel.next()) {
                            minGLevel = rsToGetMinGLevel.getInt("MINGLEVEL");
                        }
                        if (minGLevel < 1) {
                            minGLevel = level;
                        }
                        if (controllevel > minGLevel) {
                            controllevel = minGLevel;
                        }
                        String sqlToUpdateGLevel = "UPDATE T_BD_ACCOUNTVIEW SET FGLevel=?,fcontrollevel=? WHERE FID=?";
                        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sqlToUpdateGLevel, (Object[])new Object[]{new Integer(minGLevel), new Integer(controllevel), parentId});
                        parentId = rsToGetParent.getString("FParentID");
                        continue;
                    }
                    break;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void removeGLBalance(Statement stmt, String balTableName, String accountId) throws SQLException {
        String deleteAccountBalanceSql = "delete from " + balTableName + " where FAccountID ='" + accountId + "' ";
        stmt.addBatch(deleteAccountBalanceSql);
    }

    private void removeGlFlag(Context ctx, String accountId) throws BOSException {
        String sql = "delete from t_gl_flag where fkey = ?";
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{accountId});
    }

    protected void deleteCheck(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        block24: {
            try {
                boolean refered;
                String sqlToCheckHasRefByAccount;
                IRowSet rsToCheckHasRefByAccount;
                String sqlToGetAcctInfo = "SELECT TOP 1 FUPPERID,FPARENTID,FNumber,FLevel,FControlLevel,FCONTROLUNITID,FCompanyID FROM T_BD_ACCOUNTVIEW WHERE FID=?";
                IRowSet rsToGetAcctInfo = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetAcctInfo, (Object[])new Object[]{pk.toString()});
                String upperId = null;
                String parentId = null;
                String accountNumber = null;
                String fparentnumber = null;
                if (rsToGetAcctInfo != null && rsToGetAcctInfo.next()) {
                    upperId = rsToGetAcctInfo.getString("FUPPERID");
                    parentId = rsToGetAcctInfo.getString("FPARENTID");
                    accountNumber = rsToGetAcctInfo.getString("FNumber");
                    int FControlLevel = rsToGetAcctInfo.getInt("FControlLevel");
                    int Level2 = rsToGetAcctInfo.getInt("FLevel");
                    if (upperId != null && upperId.length() > 0) {
                        if (FControlLevel > Level2) {
                            throw new AccountException(AccountException.CANNOTDELACCOUNT);
                        }
                        boolean canDelete = AccountTools.checkAccountCanDelete(ctx, ContextUtil.getCurrentCtrlUnit((Context)ctx));
                        if (!canDelete) {
                            throw new AccountException(AccountException.CURRENTCUCANNOTDELETEUPPERACCOUNT);
                        }
                    }
                    if (parentId != null && parentId.length() > 0 && (rsToGetAcctInfo = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)(sqlToGetAcctInfo = "SELECT TOP 1 FNumber FROM T_BD_ACCOUNTVIEW WHERE FID=?"), (Object[])new Object[]{parentId})) != null && rsToGetAcctInfo.next()) {
                        fparentnumber = rsToGetAcctInfo.getString("FNumber");
                    }
                }
                if ((rsToCheckHasRefByAccount = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)(sqlToCheckHasRefByAccount = "SELECT TOP 1 * FROM T_BD_ACCOUNTVIEW WHERE FPARENTID=? OR FUPPERID=?"), (Object[])new Object[]{pk.toString(), pk.toString()})) != null && rsToCheckHasRefByAccount.next()) {
                    throw new AccountException(AccountException.DELETEACCOUNTHASREFER, new Object[]{accountNumber});
                }
                boolean hasParent = false;
                if (parentId != null) {
                    hasParent = this.hasParent(ctx, pk);
                }
                if ((refered = this._isHasDeal(ctx, pk)) && !hasParent) {
                    if (this.checkerName != null) {
                        if (this.accountCheck != null && this.accountCheck.getException() != null) {
                            throw this.accountCheck.getException();
                        }
                        throw new AccountException(AccountException.ACCOUNTBIZ, new Object[]{AcctRefContrastHelper.getSubSystemName(ctx, this.checkerName)});
                    }
                    throw new AccountException(AccountException.DELETEACCOUNTHASDEAL);
                }
                hasParent = hasParent && refered;
                AcctRefContrastHelper.delAcctRef(ctx, pk.toString());
                if (hasParent) {
                    String updateParent = " update T_BD_ACCOUNTVIEW set fnumber='*#'||fnumber where fid=? ";
                    com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)updateParent, (Object[])new Object[]{parentId});
                    ObjectUuidPK pPk = new ObjectUuidPK(parentId);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("*"));
                    sic.add(new SelectorItemInfo("accountTypeID.*"));
                    sic.add(new SelectorItemInfo("accountCurrency.*"));
                    AccountViewInfo parent = (AccountViewInfo)this.getValue(ctx, (IObjectPK)pPk, sic);
                    parent.setNumber(fparentnumber);
                    parent.setIsLeaf(true);
                    parent.setId(BOSUuid.read((String)pk.toString()));
                    String updateSel = null;
                    if (parent.getParent() != null) {
                        updateSel = " update T_BD_ACCOUNTVIEW set fparentid=?,fControlLevel=? where fid=? ";
                        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)updateSel, (Object[])new Object[]{parent.getParent().getId().toString(), new Integer(parent.getControlLevel()), pk.toString()});
                    } else {
                        updateSel = " update T_BD_ACCOUNTVIEW set fparentid=null ,fControlLevel=? where fid=? ";
                        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)updateSel, (Object[])new Object[]{new Integer(parent.getControlLevel()), pk.toString()});
                    }
                    updateSel = "update T_BD_ACCOUNTVIEW set FUpperID=? where FUpperID=? ";
                    com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)updateSel, (Object[])new Object[]{pk.toString(), pPk.toString()});
                    updateSel = "update T_BD_AcctRefContrastEntry set FNewAcctID=? where FNewAcctID=? ";
                    com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)updateSel, (Object[])new Object[]{pk.toString(), pPk.toString()});
                    String deleteSql = "delete from t_bd_accountcurrency where faccountviewid=? ";
                    com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new Object[]{pPk.toString()});
                    this.update(ctx, pk, (CoreBaseInfo)parent);
                    refered = this._isHasDeal(ctx, (IObjectPK)pPk);
                    if (refered) {
                        throw new AccountException(AccountException.DELETEACCOUNTHASDEAL);
                    }
                    String deleteSQL = "delete from t_bd_accountview where fid = ?";
                    com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)deleteSQL, (Object[])new Object[]{pPk.toString()});
                    parentId = pk.toString();
                } else {
                    super._delete(ctx, pk);
                }
                if (upperId == null || upperId.length() <= 0) break block24;
                try {
                    while (parentId != null && parentId.length() > 0) {
                        String sqlToGetParent = "SELECT FGLevel,FLevel,fcontrollevel,FParentID FROM T_BD_ACCOUNTVIEW WHERE FID=?";
                        IRowSet rsToGetParent = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetParent, (Object[])new Object[]{parentId});
                        if (rsToGetParent == null || !rsToGetParent.next()) continue;
                        int gLevel = rsToGetParent.getInt("FGLevel");
                        int level = rsToGetParent.getInt("FLevel");
                        int controllevel = rsToGetParent.getInt("fcontrollevel");
                        if (gLevel > level) {
                            String sqlToGetMinGLevel = "SELECT MIN(FGLevel) MINGLEVEL FROM T_BD_ACCOUNTVIEW WHERE FPARENTID=?";
                            IRowSet rsToGetMinGLevel = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetMinGLevel, (Object[])new Object[]{parentId});
                            int minGLevel = level;
                            if (rsToGetMinGLevel != null && rsToGetMinGLevel.next()) {
                                minGLevel = rsToGetMinGLevel.getInt("MINGLEVEL");
                            }
                            if (minGLevel < 1) {
                                minGLevel = level;
                            }
                            if (controllevel > minGLevel) {
                                controllevel = minGLevel;
                            }
                            String sqlToUpdateGLevel = "UPDATE T_BD_ACCOUNTVIEW SET FGLevel=?,fcontrollevel=? WHERE FID=?";
                            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sqlToUpdateGLevel, (Object[])new Object[]{new Integer(minGLevel), new Integer(controllevel), parentId});
                            parentId = rsToGetParent.getString("FParentID");
                            continue;
                        }
                        break;
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected boolean hasParent(Context ctx, AccountViewInfo accountView) throws BOSException, SQLException {
        if (accountView == null || accountView.getParent() == null) {
            return false;
        }
        int count = 0;
        String sqlToCheckHasRefByAccount = "SELECT count(*) count FROM T_BD_ACCOUNTVIEW WHERE FPARENTID=? ";
        IRowSet rsToCheckHasRefByAccount = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToCheckHasRefByAccount, (Object[])new Object[]{accountView.getParent().getId().toString()});
        if (rsToCheckHasRefByAccount != null && rsToCheckHasRefByAccount.next()) {
            count = rsToCheckHasRefByAccount.getInt("count");
        }
        if (count == 1) {
            String caa = null;
            if (accountView.getCAA() != null) {
                caa = accountView.getCAA().getId().toString();
            }
            String pcaa = null;
            if (accountView.getParent().getCAA() != null) {
                pcaa = accountView.getParent().getCAA().getId().toString();
            }
            if (caa == null & pcaa == null || caa != null && pcaa != null && caa.equals(pcaa)) {
                return true;
            }
        }
        return false;
    }

    protected boolean hasParent(Context ctx, IObjectPK pk) throws BOSException, SQLException {
        String sqlToGetAcctInfo = "SELECT TOP 1 FPARENTID,FCAA FROM T_BD_ACCOUNTVIEW WHERE FID=?";
        IRowSet rsToGetAcctInfo = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetAcctInfo, (Object[])new Object[]{pk.toString()});
        String parentId = null;
        String caa = null;
        if (rsToGetAcctInfo != null && rsToGetAcctInfo.next()) {
            parentId = rsToGetAcctInfo.getString("FPARENTID");
            caa = rsToGetAcctInfo.getString("FCAA");
            if (parentId != null && parentId.length() > 0) {
                String pcaa;
                int count = 0;
                String sqlToCheckHasRefByAccount = "SELECT count(*) count FROM T_BD_ACCOUNTVIEW WHERE FPARENTID=? ";
                IRowSet rsToCheckHasRefByAccount = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToCheckHasRefByAccount, (Object[])new Object[]{parentId});
                if (rsToCheckHasRefByAccount != null && rsToCheckHasRefByAccount.next()) {
                    count = rsToCheckHasRefByAccount.getInt("count");
                }
                if (count == 1 && (rsToCheckHasRefByAccount = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)(sqlToCheckHasRefByAccount = "SELECT FCAA FROM T_BD_ACCOUNTVIEW WHERE FID=? "), (Object[])new Object[]{parentId})) != null && rsToCheckHasRefByAccount.next() && (caa == null & (pcaa = rsToGetAcctInfo.getString("FCAA")) == null || caa != null && pcaa != null && caa.equals(pcaa))) {
                    return true;
                }
            }
        }
        return false;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AccountViewInfo account = (AccountViewInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)account.getNumber().trim()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)account.getAccountTableID().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)account.getCompanyID().getId().toString()));
        filter.setMaskString("#0 and #1 and #2");
        if (account.getId() != null && account.getId().toString().length() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)account.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3");
        }
        if (this._exists(ctx, filter)) {
            String companyNumber = account.getCompanyID().getNumber();
            if (companyNumber == null || companyNumber.length() < 1) {
                String sqlToGetCompanyNumber = "SELECT TOP 1 FNUMBER FROM T_ORG_Company WHERE FID = ?";
                IRowSet rsToGetCompanyNumber = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetCompanyNumber, (Object[])new Object[]{account.getCompanyID().getId().toString()});
                try {
                    companyNumber = rsToGetCompanyNumber.next() ? rsToGetCompanyNumber.getString("FNUMBER") : "";
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            String accountTableName = "";
            if (account.getAccountTableID() != null) {
                accountTableName = account.getAccountTableID().getName();
            }
            if (accountTableName == null || accountTableName.trim().length() == 0) {
                IAccountTable accountTable = AccountTableFactory.getLocalInstance(ctx);
                AccountTableInfo accountTableInfo = accountTable.getAccountTableInfo((IObjectPK)new ObjectUuidPK(account.getAccountTableID().getId()));
                accountTableName = accountTableInfo.getName() != null && accountTableInfo.getName().trim().length() > 0 ? accountTableInfo.getName() : "";
            }
            throw new AccountException(AccountException.DUPLONGNUMBER, new Object[]{companyNumber, accountTableName, account.getNumber()});
        }
    }

    protected void checkParentNodeChanged(AccountTableInfo table, AccountViewInfo addnewModel, AccountViewInfo oldModel) throws BOSException, EASBizException {
        String oldParentNumber;
        String newParentNumber = this.getParentNum(addnewModel, table);
        if (!AccountTools.isStringEqual(newParentNumber, oldParentNumber = this.getParentNum(oldModel, table))) {
            throw new AccountException(AccountException.PARENT_POSITION_NOT_ALLOW_CHANGED);
        }
    }

    protected void setLongName(AccountViewInfo parentInfo, AccountViewInfo model) {
        if (parentInfo == null) {
            model.setLongName(model.getName());
            model.setLongName(model.getName(locale_L1), locale_L1);
            model.setLongName(model.getName(locale_L2), locale_L2);
            model.setLongName(model.getName(locale_L3), locale_L3);
        } else {
            model.setLongName(parentInfo.getLongName() + "_" + model.getName());
            model.setLongName(parentInfo.getLongName(locale_L1) + "_" + model.getName(locale_L1), locale_L1);
            model.setLongName(parentInfo.getLongName(locale_L2) + "_" + model.getName(locale_L2), locale_L2);
            model.setLongName(parentInfo.getLongName(locale_L3) + "_" + model.getName(locale_L3), locale_L3);
        }
    }

    protected void setLongName(Context ctx, IObjectPK parentPK, AccountViewInfo model) throws EASBizException, BOSException {
        if (parentPK == null) {
            model.setLongName(model.getName());
            model.setLongName(model.getName(locale_L1), locale_L1);
            model.setLongName(model.getName(locale_L2), locale_L2);
            model.setLongName(model.getName(locale_L3), locale_L3);
        } else {
            AccountViewInfo parentInfo = (AccountViewInfo)this._getValue(ctx, parentPK);
            model.setLongName(parentInfo.getLongName() + "_" + model.getName());
            model.setLongName(parentInfo.getLongName(locale_L1) + "_" + model.getName(locale_L1), locale_L1);
            model.setLongName(parentInfo.getLongName(locale_L2) + "_" + model.getName(locale_L2), locale_L2);
            model.setLongName(parentInfo.getLongName(locale_L3) + "_" + model.getName(locale_L3), locale_L3);
        }
    }

    @Override
    protected int _getMaxLevel(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        int MaxLevel = 0;
        String sql = "SELECT MAX(FLEVEL) AS MAXLevel FROM T_BD_AccountView WHERE FCompanyID=?";
        IRowSet rowSet = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyPK.toString()});
        try {
            if (rowSet.next()) {
                MaxLevel = rowSet.getInt("MAXLevel");
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return MaxLevel;
    }

    protected boolean checkHasBalance(AccountViewInfo model, AccountViewInfo parentModel) {
        boolean ret = false;
        if (model.getCompanyID() != parentModel.getCompanyID()) {
            ret = false;
            return ret;
        }
        return ret;
    }

    protected boolean checkCurrencyChanged(Context ctx, IObjectPK pk, AccountViewInfo model) throws EASBizException, BOSException {
        boolean ret = false;
        AccountViewInfo oldModel = this.getAccountViewInfo(ctx, pk);
        if (oldModel.getAccountingcurrency() == AccountingCurrencyEnum.ONECURRENCY && model.getAccountingcurrency() == AccountingCurrencyEnum.ONECURRENCY && oldModel.getCurrencyID() != model.getCurrencyID()) {
            ret = true;
        }
        return ret;
    }

    protected boolean checkHelpCodeDup(Context ctx, AccountViewInfo model) throws EASBizException, BOSException {
        if (model != null) {
            return true;
        }
        boolean ret = false;
        if (model.getHelpCode() == null || model.getHelpCode().equals("")) {
            return true;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("helpCode", (Object)model.getHelpCode().trim()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)model.getAccountTableID().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)model.getCompanyID().getId().toString()));
        if (model.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3");
        } else {
            filter.setMaskString("#0 and #1 and #2");
        }
        if (this._exists(ctx, filter)) {
            throw new AccountException(AccountException.DUPHELPCODE, new Object[]{model.getHelpCode()});
        }
        return ret;
    }

    protected boolean checkCashBankCashEquivalentCashFlow(Context ctx, AccountViewInfo model) throws EASBizException, BOSException {
        boolean ret = false;
        if (model == null) {
            return true;
        }
        if (model.isIsCash() && model.isIsBank() || model.isIsCash() && model.isIsCashEquivalent() || model.isIsBank() && model.isIsCashEquivalent()) {
            throw new AccountException(AccountException.ACCOUNTATTRIBUTEERROR, new Object[]{model.getNumber()});
        }
        if ((model.isIsCash() || model.isIsBank() || model.isIsCashEquivalent()) && (model.getBorrowerMainCashFlowItem() != null || model.getBorrowerAttCashFlowItem() != null || model.getLenderMainCashFlowItem() != null || model.getLenderAttCashFlowItem() != null)) {
            throw new AccountException(AccountException.CASHFLOWMUTEX);
        }
        return ret;
    }

    protected String getSeparator(Context ctx, AccountViewInfo model) throws BOSException, EASBizException {
        String Separator = "";
        if (model == null) {
            return Separator;
        }
        IAccountTable iAccountTable = AccountTableFactory.getLocalInstance(ctx);
        AccountTableInfo table = iAccountTable.getAccountTableInfo((IObjectPK)new ObjectUuidPK(model.getAccountTableID().getId()));
        if (table.isIsUseSeparator()) {
            Separator = table.getSeparator();
        }
        return Separator;
    }

    protected UserInfo getUserInfo(Context ctx) {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    @Override
    protected boolean _isHasDeal(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return this._isHasDeal(ctx, pk, true);
    }

    @Override
    protected boolean _isHasDeal(Context ctx, IObjectPK pk, boolean isCheckChilden) throws BOSException, EASBizException {
        boolean ret = false;
        if (pk.toString().length() > 0) {
            try {
                String sqlToAcctInfo = "SELECT TOP 1 FNUMBER,FCONTROLUNITID,FCompanyID,FACCOUNTTABLEID FROM T_BD_ACCOUNTVIEW WHERE FID=?";
                IRowSet rsToAcctInfo = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToAcctInfo, (Object[])new Object[]{pk.toString()});
                if (rsToAcctInfo.next()) {
                    AccountViewInfo acctInfo = new AccountViewInfo();
                    acctInfo.setId(BOSUuid.read((String)pk.toString()));
                    acctInfo.setNumber(rsToAcctInfo.getString("FNUMBER"));
                    CtrlUnitInfo cu = new CtrlUnitInfo();
                    cu.setId(BOSUuid.read((String)rsToAcctInfo.getString("FCONTROLUNITID")));
                    acctInfo.setCU(cu);
                    CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)rsToAcctInfo.getString("FCompanyID")));
                    acctInfo.setCompanyID(company);
                    AccountTableInfo acctTable = new AccountTableInfo();
                    acctTable.setId(BOSUuid.read((String)rsToAcctInfo.getString("FACCOUNTTABLEID")));
                    acctInfo.setAccountTableID(acctTable);
                    ret = this.checkIsAccountHasDeal(ctx, acctInfo, isCheckChilden);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return ret;
    }

    protected boolean checkIsAccountHasDeal(Context ctx, AccountViewInfo acctInfo, boolean isCheckInferior) throws BOSException, EASBizException {
        boolean ret = false;
        if (acctInfo != null) {
            CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(acctInfo.getCompanyID().getId()));
            AccountViewCollection accountViewCollection = new AccountViewCollection();
            if (companyOrgUnitInfo != null && companyOrgUnitInfo.isIsBizUnit()) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection coll = new SelectorItemCollection();
                coll.add("id");
                view.setSelector(coll);
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctInfo.getAccountTableID().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)acctInfo.getNumber()));
                filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)("%" + acctInfo.getNumber() + "!%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("companyID.isBizUnit", (Object)new Boolean(true)));
                filter.getFilterItems().add(new FilterItemInfo("companyID.longNumber", (Object)companyOrgUnitInfo.getLongNumber()));
                filter.setMaskString("#0 and (#1 or #2) and #3 and #4");
                accountViewCollection = this.getAccountViewCollection(ctx, view);
            } else {
                String selSql = "SELECT  acct.FID  FROM ( select *    from T_BD_ACCOUNTVIEW acct   where acct.FACCOUNTTABLEID = ?  AND acct.FNUMBER =? AND acct.FUPPERID IS NOT NULL UNION select /*+ INDEX(acct IX_ACCTVIEW_LNUM) */ * from T_BD_ACCOUNTVIEW acct where acct.FACCOUNTTABLEID = ?   AND acct.FLONGNUMBER LIKE ? AND acct.FUPPERID IS NOT NULL) acct LEFT OUTER JOIN T_ORG_COMPANY com ON acct.FCOMPANYID= com.FID WHERE com.FISBIZUNIT= 1 AND com.FLONGNUMBER LIKE ? and exists(select * from t_bd_accountview where fupperid = ?) ";
                IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)selSql, (Object[])new Object[]{acctInfo.getAccountTableID().getId().toString(), acctInfo.getNumber(), acctInfo.getAccountTableID().getId().toString(), acctInfo.getLongNumber() + "!%", companyOrgUnitInfo.getLongNumber() + "!%", acctInfo.getId().toString()});
                try {
                    while (rs.next()) {
                        AccountViewInfo account = new AccountViewInfo();
                        String id = rs.getString("FID");
                        account.setId(BOSUuid.read((String)id));
                        accountViewCollection.add(account);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
            }
            BizCheckResult accountCheckResult = AccountTools.hasDeal(ctx, accountViewCollection);
            if (accountCheckResult instanceof AccountCheckResult) {
                this.checkerName = ((AccountCheckResult)accountCheckResult).getCheckerName();
                this.accountCheck = accountCheckResult;
            }
            if (accountCheckResult.isFound()) {
                ret = true;
                return ret;
            }
            BizCheckResult bizCheckResult = AccountTools.isReferenced(ctx, accountViewCollection);
            if (bizCheckResult.isFound()) {
                ret = true;
                return ret;
            }
        }
        return ret;
    }

    @Override
    protected int _getMaxGroupControlLevel(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        int MaxLevel = 0;
        String sql = "SELECT MAX(FGLevel) AS MAXLevel FROM T_BD_AccountView WHERE FCompanyID=? AND FUpperID IS NOT NULL";
        IRowSet rowSet = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyPK.toString()});
        try {
            if (rowSet.next()) {
                MaxLevel = rowSet.getInt("MAXLevel");
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return MaxLevel;
    }

    @Override
    protected IObjectPK[] _checkCompanyAccouts(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        Hashtable errors = new Hashtable();
        if (companyPK != null) {
            this.simplyCheckCompanyAccounts(ctx, companyPK, errors);
        } else {
            this.simplyCheckGroupAccounts(ctx, errors);
        }
        return this.hashtableToArray(errors);
    }

    protected void simplyCheckGroupAccounts(Context ctx, Hashtable errors) throws BOSException {
        String sql = null;
        sql = "SELECT FID, FNumber, FLongNumber FROM T_BD_AccountView WHERE FNumber IS NULL OR FLongNumber IS NULL OR FLevel <= 0 AND  FCompanyID IS NULL";
        this.queryErrorPKsToHashtable(ctx, sql, null, errors);
        sql = "SELECT FID, FNumber, FLongNumber FROM T_BD_AccountView WHERE FNumber<>RIGHT(FLongNumber, LEN(FNumber)) AND  FCompanyID IS NULL";
        this.queryErrorPKsToHashtable(ctx, sql, null, errors);
        sql = "SELECT FID, FLongNumber, FLevel FROM T_BD_AccountView WHERE FCompanyID IS NULL";
        this.queryLongNumberAndLevelErrorPKsToHashtable(ctx, sql, null, errors);
        sql = "SELECT FID FROM T_BD_AccountView WHERE FParentID=FID AND  FCompanyID IS NULL";
        this.queryErrorPKsToHashtable(ctx, sql, null, errors);
        sql = "SELECT FID FROM T_BD_AccountView WHERE FLongNumber = FNumber AND (FParentID IS NOT NULL OR FLevel <> 1) AND  FCompanyID IS NULL";
        this.queryErrorPKsToHashtable(ctx, sql, null, errors);
        sql = "SELECT T1.FID, T1.FNumber, T1.FName_L2, T1.FCompanyID,  T1.FParentID, T2.FID FROM T_BD_AccountView T1, T_BD_AccountView T2 WHERE LEFT(T1.FLongNumber, LEN(T1.FLongNumber) - LEN(T1.FNumber) - 1) = T2.FLongNumber AND T1.FParentID <> T2.FID AND T1.FLevel >1 AND T1.FCompanyID IS NULL AND T2.FCompanyID IS NULL";
        this.queryErrorPKsToHashtable(ctx, sql, null, errors);
        sql = "SELECT FID FROM T_BD_AccountView WHERE FParentID IS NULL AND (FLongNumber <> FNumber OR FLevel <> 1) AND  FCompanyID IS NULL";
        this.queryErrorPKsToHashtable(ctx, sql, null, errors);
        sql = "SELECT t1.FID FROM T_BD_AccountView t1, T_BD_AccountView t2 WHERE t1.FParentID = t2.FID AND t1.FLongNumber <> t2.FLongNumber || '!' || t1.FNumber AND  T1.FCompanyID = T2.FCompanyID AND T1.FCompanyID IS NULL";
        this.queryErrorPKsToHashtable(ctx, sql, null, errors);
        sql = "SELECT FID FROM T_BD_AccountView WHERE FID IN (SELECT DISTINCT FParentID FROM T_BD_AccountView WHERE FParentID IS NOT NULL AND FCompanyID IS NULL) AND FIsLeaf = 1 AND FCompanyID IS NULL";
        this.queryErrorPKsToHashtable(ctx, sql, null, errors);
        sql = "SELECT FID FROM T_BD_AccountView WHERE FID NOT IN(SELECT DISTINCT FParentID FROM T_BD_AccountView WHERE FParentID IS NOT NULL AND FCompanyID IS NULL) AND FIsLeaf = 0 AND FCompanyID IS NULL";
        this.queryErrorPKsToHashtable(ctx, sql, null, errors);
        sql = "SELECT T1.FID FROM T_BD_AccountView T1, T_BD_AccountView T2 WHERE T1.FNumber = T2.FNumber AND T1.FCompanyID IS NULL AND T2.FCompanyID IS NULL AND T1.FID <> T2.FID";
        this.queryErrorPKsToHashtable(ctx, sql, null, errors);
    }

    protected void simplyCheckCompanyAccounts(Context ctx, IObjectPK companyPK, Hashtable errors) throws EASBizException, BOSException {
        Object[] params = new Object[]{companyPK.toString()};
        String sql = null;
        sql = "SELECT FID, FNumber, FLongNumber FROM T_BD_AccountView WHERE FNumber IS NULL OR FLongNumber IS NULL OR FLevel <= 0 AND  FCompanyID=?";
        this.queryErrorPKsToHashtable(ctx, sql, params, errors);
        sql = "SELECT FID, FNumber, FLongNumber FROM T_BD_AccountView WHERE FNumber<>RIGHT(FLongNumber, LEN(FNumber)) AND  FCompanyID=?";
        this.queryErrorPKsToHashtable(ctx, sql, params, errors);
        sql = "SELECT FID, FLongNumber, FLevel FROM T_BD_AccountView WHERE FCompanyID=?";
        this.queryLongNumberAndLevelErrorPKsToHashtable(ctx, sql, params, errors);
        sql = "SELECT FID FROM T_BD_AccountView WHERE FParentID=FID AND  FCompanyID=?";
        this.queryErrorPKsToHashtable(ctx, sql, params, errors);
        sql = "SELECT FID FROM T_BD_AccountView WHERE FLongNumber = FNumber AND (FParentID IS NOT NULL OR FLevel <> 1) AND  FCompanyID=?";
        this.queryErrorPKsToHashtable(ctx, sql, params, errors);
        sql = "SELECT T1.FID, T1.FNumber, T1.FName_L2, T1.FCompanyID,  T1.FParentID, T2.FID FROM T_BD_AccountView T1, T_BD_AccountView T2 WHERE LEFT(T1.FLongNumber, LEN(T1.FLongNumber) - LEN(T1.FNumber) - 1) = T2.FLongNumber AND T1.FParentID <> T2.FID AND T1.FLevel >1 AND T1.FCompanyID = T2.FCompanyID AND  T1.FCompanyID=?";
        this.queryErrorPKsToHashtable(ctx, sql, params, errors);
        sql = "SELECT FID FROM T_BD_AccountView WHERE FParentID IS NULL AND (FLongNumber <> FNumber OR FLevel <> 1) AND  FCompanyID=?";
        this.queryErrorPKsToHashtable(ctx, sql, params, errors);
        sql = "SELECT t1.FID FROM T_BD_AccountView t1, T_BD_AccountView t2 WHERE t1.FParentID = t2.FID AND t1.FLongNumber <> t2.FLongNumber || '!' || t1.FNumber AND  T1.FCompanyID = T2.FCompanyID AND T1.FCompanyID=?";
        this.queryErrorPKsToHashtable(ctx, sql, params, errors);
        params = new Object[]{companyPK.toString(), companyPK.toString()};
        sql = "SELECT FID FROM T_BD_AccountView WHERE FID IN (SELECT DISTINCT FParentID FROM T_BD_AccountView WHERE FParentID IS NOT NULL AND FCompanyID=?) AND FIsLeaf = 1 AND FCompanyID=?";
        this.queryErrorPKsToHashtable(ctx, sql, params, errors);
        sql = "SELECT FID FROM T_BD_AccountView WHERE FID NOT IN(SELECT DISTINCT FParentID FROM T_BD_AccountView WHERE FParentID IS NOT NULL AND FCompanyID=?) AND FIsLeaf = 0 AND FCompanyID=?";
        this.queryErrorPKsToHashtable(ctx, sql, params, errors);
        sql = "SELECT T1.FID FROM T_BD_AccountView T1, T_BD_AccountView T2 WHERE T1.FNumber = T2.FNumber AND T1.FCompanyID = T2.FCompanyID AND T1.FID <> T2.FID";
        this.queryErrorPKsToHashtable(ctx, sql, null, errors);
    }

    protected void queryLongNumberAndLevelErrorPKsToHashtable(Context ctx, String sql, Object[] params, Hashtable errors) throws BOSException {
        IRowSet rs = null;
        rs = params == null || params.length == 0 ? com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql) : com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        try {
            while (rs.next()) {
                String id = rs.getString("FID");
                String longNumber = rs.getString("FLongNumber");
                int level = rs.getInt("FLevel");
                int seps = 0;
                int startPos = 0;
                while ((startPos = longNumber.indexOf("!", startPos)) >= 0) {
                    ++startPos;
                    ++seps;
                }
                if (seps + 1 == level) continue;
                errors.put(id, new ObjectUuidPK(BOSUuid.read((String)id)));
            }
        }
        catch (SQLException err) {
            throw new BOSException((Throwable)err);
        }
    }

    protected void queryErrorPKsToHashtable(Context ctx, String sql, Object[] params, Hashtable errors) throws BOSException {
        IRowSet rs = null;
        rs = params == null || params.length == 0 ? com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql) : com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        try {
            while (rs.next()) {
                String id = rs.getString("FID");
                errors.put(id, new ObjectUuidPK(BOSUuid.read((String)id)));
            }
        }
        catch (SQLException err) {
            throw new BOSException((Throwable)err);
        }
    }

    @Override
    protected IObjectCollection _getGroupControlAccountsByCompany(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        String companyId = companyPK == null ? ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() : companyPK.toString();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("upper", null, CompareType.NOTEQUALS));
        return this.getAccountsByDAO(ctx, evi);
    }

    @Override
    protected IObjectPK[] _repairCompanyAccounts(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        IObjectPK[] repairedPKs = new IObjectPK[]{};
        return repairedPKs;
    }

    @Override
    protected IObjectCollection _getNonImportedGAsByCompany(Context ctx, IObjectPK tablePK, IObjectPK companyPK) throws BOSException, EASBizException {
        AccountViewCollection accounts = new AccountViewCollection();
        StringBuffer bf = new StringBuffer();
        bf.append("SELECT FID, FName_");
        bf.append(ctx.getLocale().toString());
        bf.append(" AS FName, FNumber, FIsleaf, FLevel, FGLevel, FCompanyID FROM T_BD_AccountView WHERE FNumber NOT IN (SELECT FNumber FROM T_BD_AccountView WHERE FAccountTableID=? AND FCompanyID=?) AND FCompanyID IS NULL AND FIsLeaf=1 and FLevel=FGLevel ORDER BY FNumber");
        IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)bf.toString(), (Object[])new Object[]{tablePK.toString(), companyPK.toString()});
        try {
            while (rs.next()) {
                AccountViewInfo account = new AccountViewInfo();
                String id = rs.getString("FID");
                String number = rs.getString("FNumber");
                String name = rs.getString("FName");
                account.setId(BOSUuid.read((String)id));
                account.setNumber(number);
                account.setName(name);
                accounts.add(account);
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return accounts;
    }

    @Override
    protected IObjectPK[] _checkAllAccounts(Context ctx) throws BOSException, EASBizException {
        Hashtable errors = new Hashtable();
        String sql = null;
        sql = "SELECT FID, FNumber, FLongNumber FROM T_BD_AccountView WHERE FNumber IS NULL OR FLongNumber IS NULL OR FLevel <= 0";
        this.queryErrorPKsToHashtable(ctx, sql, null, errors);
        sql = "SELECT FID, FNumber, FLongNumber FROM T_BD_AccountView WHERE FNumber<>RIGHT(FLongNumber, LEN(FNumber))";
        this.queryErrorPKsToHashtable(ctx, sql, null, errors);
        sql = "SELECT FID, FLongNumber, FLevel FROM T_BD_AccountView";
        this.queryLongNumberAndLevelErrorPKsToHashtable(ctx, sql, null, errors);
        sql = "SELECT FID FROM T_BD_AccountView WHERE FParentID=FID";
        this.queryErrorPKsToHashtable(ctx, sql, null, errors);
        sql = "SELECT FID FROM T_BD_AccountView WHERE FLongNumber = FNumber AND (FParentID IS NOT NULL OR FLevel <> 1)";
        this.queryErrorPKsToHashtable(ctx, sql, null, errors);
        sql = "SELECT T1.FID, T1.FNumber, T1.FName_L2, T1.FCompanyID,  T1.FParentID, T2.FID FROM T_BD_AccountView T1, T_BD_AccountView T2 WHERE LEFT(T1.FLongNumber, LEN(T1.FLongNumber) - LEN(T1.FNumber) - 1) = T2.FLongNumber AND T1.FParentID <> T2.FID AND T1.FLevel >1 AND (T1.FCompanyID = T2.FCompanyID OR T1.FCompanyID IS NULL AND T2.FCompanyID IS NULL)";
        this.queryErrorPKsToHashtable(ctx, sql, null, errors);
        sql = "SELECT FID FROM T_BD_AccountView WHERE FParentID IS NULL AND (FLongNumber <> FNumber OR FLevel <> 1)";
        this.queryErrorPKsToHashtable(ctx, sql, null, errors);
        sql = "SELECT t1.FID FROM T_BD_AccountView t1, T_BD_AccountView t2 WHERE t1.FParentID = t2.FID AND t1.FLongNumber <> t2.FLongNumber || '!' || t1.FNumber";
        this.queryErrorPKsToHashtable(ctx, sql, null, errors);
        sql = "SELECT FID FROM T_BD_AccountView WHERE FID IN (SELECT DISTINCT FParentID FROM T_BD_AccountView WHERE FParentID IS NOT NULL) AND FIsLeaf = 1";
        this.queryErrorPKsToHashtable(ctx, sql, null, errors);
        sql = "SELECT FID FROM T_BD_AccountView WHERE FID NOT IN(SELECT DISTINCT FParentID FROM T_BD_AccountView WHERE FParentID IS NOT NULL) AND FIsLeaf = 0";
        this.queryErrorPKsToHashtable(ctx, sql, null, errors);
        sql = "SELECT T1.FID FROM T_BD_AccountView T1, T_BD_AccountView T2 WHERE T1.FNumber = T2.FNumber AND (T1.FCompanyID = T2.FCompanyID OR T1.FCompanyID IS NULL AND T2.FCompanyID IS NULL) AND T1.FID <> T2.FID";
        this.queryErrorPKsToHashtable(ctx, sql, null, errors);
        return this.hashtableToArray(errors);
    }

    protected IObjectPK[] hashtableToArray(Hashtable errors) {
        IObjectPK[] errPKs = new IObjectPK[errors.size()];
        int count = 0;
        Enumeration e = errors.elements();
        while (e.hasMoreElements()) {
            errPKs[count] = (IObjectPK)e.nextElement();
            ++count;
        }
        return errPKs;
    }

    protected void checkLNForTree(Context ctx, TreeBaseInfo treeBaseInfo) throws BOSException, EASBizException, TreeBaseException {
    }

    @Override
    protected boolean _checkAccountHasInferior(Context ctx, IObjectValue accountViewInfo) throws BOSException {
        String sql = "SELECT TOP 1 1 FROM T_BD_ACCOUNTVIEW WHERE FUpperID=?";
        IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{((AccountViewInfo)accountViewInfo).getId().toString()});
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected List _assignAccountToChild(Context ctx, IObjectCollection subAcctCtrlCols, IObjectCollection accountCollection, boolean isDisplayAll) {
        Account_ControlCollection acctCtrlCols = (Account_ControlCollection)subAcctCtrlCols;
        boolean isAssign = acctCtrlCols.get(0).isAssign();
        AccountViewCollection accountCols = (AccountViewCollection)accountCollection;
        boolean isUseThread = this.getIsAccountAssignUseThread(ctx);
        int threadCount = 1;
        Object dbType = ctx.get((Object)"dbType");
        if (isUseThread && dbType != null) {
            threadCount = 10;
        }
        HashMap acctCtrlMap = new HashMap();
        ArrayList<CompanyOrgUnitInfo> destComList = new ArrayList<CompanyOrgUnitInfo>();
        int[] destCompanyLevelArray = this.getLevelArray(acctCtrlCols, acctCtrlMap, destComList);
        String detailLog = this.buildAssignLog(ctx, isAssign, destComList, accountCols);
        String method = null;
        method = isAssign ? ResourceBase.getString((String)RESOURCE, (String)"accountAssign", (Locale)ctx.getLocale()) : ResourceBase.getString((String)RESOURCE, (String)"accountUnassign", (Locale)ctx.getLocale());
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)method, (BOSObjectType)new BOSObjectType("9DA99826"), null, (String)detailLog, (String)"bd_account_accountView_assign", (String)acctCtrlCols.get(0).getSrcCompany().getId().toString(), (String)method);
        ExecutorService service = Executors.newFixedThreadPool(threadCount);
        Vector<AccountAssignErrorInfo> errorList = new Vector<AccountAssignErrorInfo>();
        AccountRefContrastInfo upperRef = this.getAcctRefContrastInfo(ctx, acctCtrlCols);
        AccountRefContrastUtil util = new AccountRefContrastUtil();
        HashMap dAssistTypemMap = null;
        if (upperRef != null && isAssign && upperRef.isIsEnabled()) {
            try {
                util.checkGenAsstActType(ctx, accountCols, upperRef);
                dAssistTypemMap = util.prepareDAssistType(ctx, accountCols, upperRef);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        ArrayList<AccountViewInfo> accountForInsert = new ArrayList<AccountViewInfo>();
        for (int j = 0; j < accountCols.size(); ++j) {
            accountForInsert.add(accountCols.get(j));
        }
        HashMap<String, String> companyIdCatch = new HashMap<String, String>();
        for (int i = 0; i < destCompanyLevelArray.length; ++i) {
            int j;
            Account_ControlCollection tempColl = (Account_ControlCollection)((Object)acctCtrlMap.get(destCompanyLevelArray[i]));
            Vector returnMsgList = new Vector();
            for (j = 0; j < tempColl.size(); ++j) {
                AssignAndUnassignedThread t = new AssignAndUnassignedThread(ctx, tempColl.get(j), accountCols, returnMsgList, upperRef, isDisplayAll, String.valueOf(Thread.currentThread().getId()), companyIdCatch, dAssistTypemMap, accountForInsert);
                service.execute(t);
            }
            while (returnMsgList.size() != tempColl.size()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.error((Object)e);
                }
            }
            for (j = 0; j < returnMsgList.size(); ++j) {
                if (returnMsgList.get(j) == null || !(returnMsgList.get(j) instanceof AccountAssignErrorInfo)) continue;
                AccountAssignErrorInfo errorInfo = (AccountAssignErrorInfo)returnMsgList.get(j);
                errorList.add(errorInfo);
                this.removeCompany(destCompanyLevelArray[i], errorInfo, acctCtrlMap, isAssign);
            }
        }
        service.shutdown();
        BOSObjectType accountviewBOSType = new AccountViewInfo().getBOSType();
        ORMValueCacheService.getInstance().discardType(ctx, accountviewBOSType);
        if (errorList.size() < 1) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        return errorList;
    }

    private String buildAssignLog(Context ctx, boolean isAssign, List<CompanyOrgUnitInfo> destComList, AccountViewCollection accountCols) {
        if (destComList.size() < 1 || accountCols.size() < 1) {
            return null;
        }
        StringBuilder detailLog = new StringBuilder();
        detailLog.append(ResourceBase.getString((String)RESOURCE, (String)"chooseCompany", (Locale)ctx.getLocale()) + "\u3010");
        for (CompanyOrgUnitInfo comInfo : destComList) {
            detailLog.append(comInfo.getNumber() + "(" + comInfo.getName() + ");");
        }
        detailLog.append("\u3011\n");
        detailLog.append(ResourceBase.getString((String)RESOURCE, (String)"chooseAccount", (Locale)ctx.getLocale()) + "\u3010");
        for (int i = 0; i < accountCols.size(); ++i) {
            AccountViewInfo info = accountCols.get(i);
            detailLog.append(info.getNumber() + "(" + info.getName() + ");");
        }
        detailLog.append("\u3011");
        return detailLog.toString();
    }

    private AccountRefContrastInfo getAcctRefContrastInfo(Context ctx, Account_ControlCollection acctCtrlCols) {
        try {
            return AccountRefContrastFactory.getLocalInstance(ctx).getAcctInfo(acctCtrlCols.get(0).getSrcCompany().getId().toString(), acctCtrlCols.get(0).getAccountTableID().getId().toString());
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return null;
    }

    private boolean getIsAccountAssignUseThread(Context ctx) {
        try {
            ContextUtil.getCurrentCtrlUnit((Context)ctx).getId();
            String value = ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)"AccountAssignUseThread", (IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId()), (boolean)true);
            return value != null && value.trim().equalsIgnoreCase("true");
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private void removeCompany(int level, AccountAssignErrorInfo errorInfo, Map acctCtrlMap, boolean isAssign) {
        level = isAssign ? ++level : --level;
        Account_ControlCollection acctCtrlCol = (Account_ControlCollection)((Object)acctCtrlMap.get(level));
        String longnumber = errorInfo.getCompany().getLongNumber();
        if (acctCtrlCol == null) {
            return;
        }
        for (int i = 0; i < acctCtrlCol.size(); ++i) {
            Account_ControlInfo acctCtrlnfo = acctCtrlCol.get(i);
            String destCompanyLongnumber = acctCtrlnfo.getDestCompany().getLongNumber();
            if (longnumber == null || destCompanyLongnumber.indexOf(longnumber + "!") != 0 && longnumber.indexOf(destCompanyLongnumber + "!") != 0) continue;
            acctCtrlCol.removeObject(i);
            if (errorInfo != null) {
                errorInfo.setRelatedCompanyError(true);
            }
            this.removeCompany(level, errorInfo, acctCtrlMap, isAssign);
        }
    }

    private int[] getLevelArray(Account_ControlCollection acctCtrlCols, Map map, List<CompanyOrgUnitInfo> destComList) {
        boolean isAssign = acctCtrlCols.get(0).isAssign();
        for (int i = 0; i < acctCtrlCols.size(); ++i) {
            Account_ControlCollection acctCtrlColltion;
            CompanyOrgUnitInfo info = acctCtrlCols.get(i).getDestCompany();
            destComList.add(info);
            int level = info.getLevel();
            if (map.get(level) == null) {
                acctCtrlColltion = new Account_ControlCollection();
                acctCtrlColltion.add(acctCtrlCols.get(i));
                map.put(level, acctCtrlColltion);
                continue;
            }
            acctCtrlColltion = (Account_ControlCollection)((Object)map.get(level));
            acctCtrlColltion.add(acctCtrlCols.get(i));
        }
        Set keySet = map.keySet();
        int[] levelArray = new int[keySet.size()];
        Iterator it = keySet.iterator();
        int i = 0;
        while (it.hasNext()) {
            levelArray[i++] = Integer.parseInt(it.next() + "");
        }
        Arrays.sort(levelArray);
        if (isAssign) {
            return levelArray;
        }
        int[] reversedLevelSort = new int[levelArray.length];
        for (i = 0; i < levelArray.length; ++i) {
            reversedLevelSort[i] = levelArray[levelArray.length - (i + 1)];
        }
        return reversedLevelSort;
    }

    @Override
    protected String _accountAssign(Context ctx, IObjectValue accountCtrlInfo, IObjectCollection acctViewCols, IObjectValue upperRefContrast, boolean isDisplayAll) throws BOSException, EASBizException {
        String currThreadId = (String)AccountAssignThreadLocalUtil.getThreadLocalMapValue("currThreadId");
        HashMap companyIdCatch = (HashMap)AccountAssignThreadLocalUtil.getThreadLocalMapValue("result");
        ArrayList accountForInsert = (ArrayList)AccountAssignThreadLocalUtil.getThreadLocalMapValue("accountForInsert");
        AccountViewCollection accountCols = (AccountViewCollection)acctViewCols;
        AccountRefContrastInfo upperRef = (AccountRefContrastInfo)upperRefContrast;
        Account_ControlInfo acctCtrlInfo = (Account_ControlInfo)accountCtrlInfo;
        this.assignAcctCtrl(ctx, acctCtrlInfo);
        if (isDisplayAll && !acctCtrlInfo.getSrcCompany().getId().equals((Object)acctCtrlInfo.getDestCompany().getParent().getId())) {
            String parentCompanyId = acctCtrlInfo.getDestCompany().getParent().getId().toString();
            String key = currThreadId + parentCompanyId;
            String verifyResult = (String)companyIdCatch.get(key);
            if (verifyResult == null) {
                this.checkParentCompany(ctx, acctCtrlInfo, accountCols);
                companyIdCatch.put(key, parentCompanyId);
            }
        }
        this.setCompanyAccountTable(ctx, acctCtrlInfo.getDestCompany(), acctCtrlInfo.getAccountTableID());
        Set assignedAccountNumberSet = this.getAssignedAccountNumberSet(ctx, acctCtrlInfo, accountCols);
        AccountRefContrastInfo curRef = null;
        curRef = this.checkAccountRefWhenAssignOrUnassign(ctx, curRef, upperRef, acctCtrlInfo, accountCols, true);
        AccountViewCollection acctColl = new AccountViewCollection();
        AccountCurrencyCollection acctCurrencyCols = new AccountCurrencyCollection();
        AccountViewCollection acctColsForInsert = this.getAllInformationForAcct(ctx, accountForInsert);
        StringBuffer returnStr = this.dealInsert(ctx, acctCtrlInfo, assignedAccountNumberSet, acctColl, acctCurrencyCols, acctColsForInsert);
        this.handleAstInitClosed(ctx, acctCtrlInfo.getDestCompany(), acctCtrlInfo.getAccountTableID(), acctColl);
        if (acctColl.size() > 0) {
            try {
                String[] ids = ORMEngine.addnewVO((Context)ctx, (IObjectCollection)acctColl);
                if (acctCtrlInfo.getDestCompany().isIsBizUnit()) {
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(Arrays.asList(ids)), CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("ac", (Object)1, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)1, CompareType.EQUALS));
                    ev.setFilter(filter);
                    AccountViewCollection avc = this.getAccountViewCollection(ctx, ev);
                    if (avc.size() > 0) {
                        this.fixAcctCussentData(ctx, avc);
                    }
                }
            }
            catch (BOSException e11) {
                logger.error((Object)"\u65b0\u589e\u5206\u914d\u79d1\u76ee\u5931\u8d25", (Throwable)e11);
                int[] errInfo = ((BatchUpdateException)e11.getCause()).getUpdateCounts();
                AccountViewInfo errAcctInfo = new AccountViewInfo();
                for (int i = 0; i < errInfo.length; ++i) {
                    if (errInfo[i] != -3) continue;
                    errAcctInfo = acctColl.get(i);
                    break;
                }
                throw new AccountException(AccountException.DUPLONGNUMBER, new Object[]{acctCtrlInfo.getDestCompany().getNumber(), acctCtrlInfo.getAccountTableID().getName(), errAcctInfo.getNumber()});
            }
            ORMEngine.addnewVO((Context)ctx, (IObjectCollection)acctCurrencyCols);
            this.checkDumpNamePerCompany(ctx, acctCtrlInfo, acctColl);
            if (isDisplayAll) {
                this.repairUpperidAndFreezeProperties(ctx, acctCtrlInfo, acctColl);
            }
        }
        this.copyAcctRef(ctx, curRef, upperRef, acctColsForInsert);
        return returnStr.toString();
    }

    private void checkDumpNamePerCompany(Context ctx, Account_ControlInfo acctCtrlInfo, AccountViewCollection acctColl) throws BOSException, AccountException {
        String language = ctx.getLocale().getLanguage();
        String sql = "select fname_" + language + " name,fnumber number from t_bd_accountview where exists(select 1 from t_bd_accountview av where  av.fcompanyid=t_bd_accountview.fcompanyid  and av.faccounttableid=t_bd_accountview.faccounttableid  and av.fparentid=t_bd_accountview.fparentid  and av.flevel=t_bd_accountview.flevel  and av.fname_" + language + "= t_bd_accountview.fname_" + language + " and av.fid !=t_bd_accountview.fid  and av.fcompanyid=? and av.faccounttableid=?) ";
        IRowSet rowSet = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{acctCtrlInfo.getDestCompany().getId().toString(), acctCtrlInfo.getAccountTableID().getId().toString()});
        if (rowSet == null || rowSet.size() <= 0) {
            return;
        }
        HashMap<String, String> assignedAccountNameSet = new HashMap<String, String>();
        for (int i = 0; i < acctColl.size(); ++i) {
            assignedAccountNameSet.put(acctColl.get(i).getName(), acctColl.get(i).getNumber());
        }
        StringBuffer dumpNames = new StringBuffer();
        try {
            while (rowSet.next()) {
                String name = rowSet.getString("name");
                String number = rowSet.getString("number");
                Object assAccNum = assignedAccountNameSet.get(name);
                if (assAccNum == null || number.equals(assAccNum.toString())) continue;
                dumpNames.append("\u3010" + number + "," + name + "\u3011").append("\u3001");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (dumpNames.length() > 0) {
            dumpNames.deleteCharAt(dumpNames.length() - 1);
            throw new AccountException(AccountException.NAMEALEADYEXISTBYASSIGN, new Object[]{dumpNames.toString()});
        }
    }

    private StringBuffer dealInsert(Context ctx, Account_ControlInfo acctCtrlInfo, Set assignedAccountNumberSet, AccountViewCollection acctColl, AccountCurrencyCollection acctCurrencyCols, AccountViewCollection acctColsForInsert) throws BOSException, EASBizException, AccountException {
        HashMap<String, AccountViewInfo> upperIdMap = new HashMap<String, AccountViewInfo>();
        int notSuc = 0;
        StringBuffer returnStr = new StringBuffer();
        CompanyOrgUnitInfo destCompany = acctCtrlInfo.getDestCompany();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)destCompany.getId().toString(), CompareType.EQUALS));
        ev.setFilter(filter);
        ev.getSelector().add(new SelectorItemInfo("*"));
        CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(ev);
        boolean destCompanyIsSealUp = false;
        if (companyOrgUnitCollection.size() > 0) {
            destCompanyIsSealUp = companyOrgUnitCollection.get(0).isIsSealUp();
        }
        for (int j = 0; j < acctColsForInsert.size(); ++j) {
            AccountViewInfo acctInfo = this.copyGeneratedNewAccountInfo(ctx, acctCtrlInfo, upperIdMap, acctColsForInsert, j);
            this.checkIsCanassign(ctx, assignedAccountNumberSet, acctInfo);
            AccountCurrencyCollection acctCuCols = this.getAccountCurrencyCollection(acctInfo);
            try {
                AccountViewInfo destParentAccount;
                AccountViewInfo parent = null;
                String parentId = null;
                if (acctInfo.getParent() != null && destCompanyIsSealUp && destCompany.isIsBizUnit() && (destParentAccount = this.getAccountByNumber(ctx, (IObjectPK)new ObjectUuidPK(acctInfo.getAccountTableID().getId()), (IObjectPK)new ObjectUuidPK(destCompany.getId()), acctInfo.getParent().getNumber())) != null && destParentAccount.isIsLeaf() && this._isHasDeal(ctx, (IObjectPK)new ObjectUuidPK(destParentAccount.getId()))) {
                    throw new AccountException(AccountException.ACCOUNT_ASSIGN_HAS_DAEL, new Object[]{acctInfo.getNumber(), destCompany.getNumber()});
                }
                if (acctInfo.getParent() != null) {
                    parentId = acctInfo.getParent().getId().toString();
                    parent = this.setParentProperty(ctx, acctCtrlInfo, acctInfo, assignedAccountNumberSet, upperIdMap);
                }
                if (assignedAccountNumberSet.contains(acctInfo.getNumber())) {
                    this._addnew(ctx, (IObjectValue)acctInfo);
                    continue;
                }
                if (acctInfo.getParent() != null && acctInfo.getParent().getNumber() != null && assignedAccountNumberSet.contains(acctInfo.getParent().getNumber())) {
                    this._addnew(ctx, (IObjectValue)acctInfo, true);
                    parent = acctInfo.getParent();
                    upperIdMap.put(parentId, parent);
                    continue;
                }
                if (acctInfo.getParent() != null && acctInfo.getParent().isIsLeaf()) {
                    this._addnew(ctx, (IObjectValue)acctInfo, true);
                    parent.setId(acctInfo.getParent().getId());
                    parent.setIsLeaf(false);
                    continue;
                }
                acctColl.add(acctInfo);
                acctCurrencyCols.addCollection(acctCuCols);
                continue;
            }
            catch (AccountException e) {
                if ("542".equals(e.getSubCode())) {
                    returnStr.append("(" + ++notSuc + ")").append(ResourceBase.getString((String)RESOURCE, (String)"Company", (Locale)ctx.getLocale())).append(acctInfo.getCompanyID().getNumber()).append(acctInfo.getCompanyID().getName()).append(e.getMessage()).append("\r\n");
                    continue;
                }
                if ("100".equals(e.getSubCode())) {
                    this.handleDupLongNumber(ctx, acctInfo, e, true);
                    continue;
                }
                throw e;
            }
        }
        return returnStr;
    }

    private void copyAcctRef(Context ctx, AccountRefContrastInfo curRef, AccountRefContrastInfo upperRef, AccountViewCollection acctColsForInsert) throws BOSException {
        if (curRef != null && curRef.getId() != null) {
            try {
                if (upperRef != null && upperRef.isIsEnabled()) {
                    this.util.copyRefEntry(ctx, upperRef, curRef, acctColsForInsert);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private AccountCurrencyCollection getAccountCurrencyCollection(AccountViewInfo acctInfo) {
        AccountCurrencyCollection acctCuCols = acctInfo.getAccountCurrency();
        if (acctCuCols != null && acctCuCols.size() > 0) {
            for (int k = 0; k < acctCuCols.size(); ++k) {
                AccountCurrencyInfo acctCuInfo = acctCuCols.get(k);
                acctCuInfo.setAccountView(acctInfo);
                acctCuInfo.setId(null);
            }
        }
        return acctCuCols;
    }

    private void checkIsCanassign(Context ctx, Set assignedAccountNumberSet, AccountViewInfo acctInfo) throws BOSException, EASBizException {
        this.checkAssignAACM(ctx, acctInfo);
    }

    private AccountViewInfo setParentProperty(Context ctx, Account_ControlInfo acctCtrlInfo, AccountViewInfo acctInfo, Set assignedAccountNumberSet, HashMap upperIdMap) throws BOSException, EASBizException {
        AccountViewInfo parent = (AccountViewInfo)upperIdMap.get(acctInfo.getParent().getId().toString());
        try {
            ObjectUuidPK pkCompany;
            ObjectUuidPK pkParent;
            IAsstAccount iAsstAccount;
            if (parent == null || assignedAccountNumberSet.contains(acctInfo.getParent().getNumber())) {
                String sqlToGetInferiorParent = "SELECT TOP 1 FID,FAcctCurrency,FCAA,FIsleaf,FISCFREEZE,FCONTROL FROM T_BD_ACCOUNTVIEW WHERE FNumber=? AND FAccountTableID=?  AND FCompanyID=?";
                IRowSet rsToGetInferiorParent = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetInferiorParent, (Object[])new Object[]{acctInfo.getParent().getNumber(), acctInfo.getAccountTableID().getId().toString(), acctCtrlInfo.getDestCompany().getId().toString()});
                if (rsToGetInferiorParent != null && rsToGetInferiorParent.next()) {
                    int acctCurrency = rsToGetInferiorParent.getInt("FAcctCurrency");
                    if (acctCurrency == 1 && AccountingCurrencyEnum.ALLCURRENCY.equals((Object)acctInfo.getAccountingcurrency())) {
                        throw new AccountException(AccountException.DCOMPANY_NOTALLCUR, new Object[]{acctCtrlInfo.getDestCompany().getName(), acctInfo.getNumber()});
                    }
                    int control = rsToGetInferiorParent.getInt("FCONTROL");
                    AccountControlAttribute parentControl = AccountControlAttribute.getEnum(control);
                    if (!AccountControlAttribute.NONE.equals((Object)parentControl)) {
                        acctInfo.setControl(parentControl);
                    }
                    String parentId = rsToGetInferiorParent.getString("FID");
                    boolean isLeaf = rsToGetInferiorParent.getBoolean("FIsleaf");
                    parent = new AccountViewInfo();
                    if (!StringUtils.isEmpty((String)rsToGetInferiorParent.getString("Fcaa"))) {
                        AsstAccountInfo asst = new AsstAccountInfo();
                        asst.setId(BOSUuid.read((String)rsToGetInferiorParent.getString("Fcaa")));
                        parent.setCAA(asst);
                    }
                    parent.setId(BOSUuid.read((String)parentId));
                    AccountTableInfo atInfo = new AccountTableInfo();
                    atInfo.setId(BOSUuid.read((String)acctInfo.getAccountTableID().getId().toString()));
                    parent.setAccountTableID(atInfo);
                    parent.setIsLeaf(isLeaf);
                    parent.setIsCFreeze(rsToGetInferiorParent.getBoolean("FISCFREEZE"));
                    parent.setIsCFreeze(rsToGetInferiorParent.getBoolean("FISCFREEZE"));
                    upperIdMap.put(acctInfo.getParent().getId().toString(), parent);
                } else {
                    throw new AccountException(AccountException.CHILDCUMUSTEQUALPARENTCU, new Object[]{acctInfo.getNumber()});
                }
            }
            if (parent.isIsCFreeze()) {
                acctInfo.setIsCFreeze(true);
                acctInfo.setIsParentFreeze(true);
            }
            acctInfo.setParent(parent);
            if (acctInfo.getCAA() == null && parent.getCAA() != null) {
                acctInfo.setCAA(parent.getCAA());
            } else if (acctInfo.getCAA() != null && parent.getCAA() != null && !(iAsstAccount = AsstAccountFactory.getLocalInstance((Context)ctx)).compare((IObjectPK)(pkParent = new ObjectUuidPK(parent.getCAA().getId())), (IObjectPK)(pkCompany = new ObjectUuidPK(acctInfo.getCAA().getId())))) {
                throw new AccountException(AccountException.CAANOTINCLUDEPARENTAA, new Object[]{acctInfo.getNumber()});
            }
            if (parent.getCAA() != null) {
                acctInfo.setParentAA(parent.getCAA());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return parent;
    }

    private AccountViewInfo copyGeneratedNewAccountInfo(Context ctx, Account_ControlInfo acctCtrlInfo, HashMap upperIdMap, AccountViewCollection acctColsForInsert, int j) {
        AccountViewInfo acctInfo = acctColsForInsert.get(j);
        String upperActountId = acctInfo.getId().toString();
        acctInfo.setId(BOSUuid.create((BOSObjectType)acctInfo.getBOSType()));
        upperIdMap.put(upperActountId, acctInfo);
        acctInfo.setCompanyID(acctCtrlInfo.getDestCompany());
        acctInfo.setCU(acctCtrlInfo.getDestCompany().getCU());
        AccountViewInfo upperInfo = new AccountViewInfo();
        upperInfo.setId(BOSUuid.read((String)upperActountId));
        acctInfo.setUpper(upperInfo);
        acctInfo.setGAA(acctInfo.getCAA());
        acctInfo.setControlLevel(acctInfo.getGLevel());
        acctInfo.setIsAllowCA(acctInfo.isIsUpperAllowCA());
        acctInfo.setLastUpdateUser(this.getUserInfo(ctx));
        acctInfo.setLastUpdateTime(this.getTime());
        return acctInfo;
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    protected AccountViewCollection getAllInformationForAcct(Context ctx, IObjectCollection accountCollection) throws EASBizException, BOSException {
        AccountViewCollection acctCols = new AccountViewCollection();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("accountTypeID.property");
        selector.add("accountCurrency.currency");
        AccountViewCollection initCols = (AccountViewCollection)accountCollection;
        HashSet<String> acctPKSet = new HashSet<String>();
        int count = initCols.size();
        for (int i = 0; i < count; ++i) {
            AccountViewInfo initialAcctInfo = initCols.get(i);
            acctPKSet.add(initialAcctInfo.getId().toString());
        }
        if (acctPKSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", acctPKSet, CompareType.INCLUDE));
            view.setSelector(selector);
            SorterItemCollection coll = new SorterItemCollection();
            SorterItemInfo sorterInfo = new SorterItemInfo("number");
            coll.add(sorterInfo);
            view.setSorter(coll);
            acctCols = this.getAccountViewCollection(ctx, view);
        }
        AccountViewInfo accountViewInfo = null;
        int count2 = acctCols.size();
        block1: for (int i = 0; i < count2; ++i) {
            accountViewInfo = acctCols.get(i);
            int initCount = initCols.size();
            for (int j = 0; j < initCount; ++j) {
                AccountViewInfo initialAcctInfo = initCols.get(j);
                if (!accountViewInfo.getId().equals((Object)initialAcctInfo.getId())) continue;
                accountViewInfo.setGLevel(initialAcctInfo.getGLevel());
                accountViewInfo.setIsUpperAllowCA(initialAcctInfo.isIsUpperAllowCA());
                continue block1;
            }
        }
        return acctCols;
    }

    protected AccountViewCollection getAllInformationForAcct(Context ctx, List acctList) throws EASBizException, BOSException {
        AccountViewCollection acctCols = new AccountViewCollection();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("accountTypeID.property");
        selector.add("accountCurrency.currency");
        selector.add("parent.number");
        Iterator acctIter = acctList.iterator();
        HashSet<String> acctPKSet = new HashSet<String>();
        while (acctIter.hasNext()) {
            AccountViewInfo initialAcctInfo = (AccountViewInfo)acctIter.next();
            acctPKSet.add(initialAcctInfo.getId().toString());
        }
        if (acctPKSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", acctPKSet, CompareType.INCLUDE));
            view.setSelector(selector);
            SorterItemCollection coll = new SorterItemCollection();
            SorterItemInfo sorterInfo = new SorterItemInfo("number");
            coll.add(sorterInfo);
            view.setSorter(coll);
            acctCols = this.getAccountViewCollection(ctx, view);
        }
        AccountViewInfo accountViewInfo = null;
        int count = acctCols.size();
        block1: for (int i = 0; i < count; ++i) {
            accountViewInfo = acctCols.get(i);
            for (AccountViewInfo initialAcctInfo : acctList) {
                if (!accountViewInfo.getId().equals((Object)initialAcctInfo.getId())) continue;
                accountViewInfo.setGLevel(initialAcctInfo.getGLevel());
                accountViewInfo.setIsUpperAllowCA(initialAcctInfo.isIsUpperAllowCA());
                accountViewInfo.setHasUserProperty(false);
                continue block1;
            }
        }
        return acctCols;
    }

    private AccountRefContrastInfo checkAccountRefWhenAssignOrUnassign(Context ctx, AccountRefContrastInfo curRef, AccountRefContrastInfo upperRef, Account_ControlInfo acctCtrlInfo, AccountViewCollection accountCols, boolean assign) throws BOSException, EASBizException {
        String companyID = acctCtrlInfo.getDestCompany().getId().toString();
        String curAcctTableID = acctCtrlInfo.getAccountTableID().getId().toString();
        String oql = "select id,isEnabled,enabledAcctTable.id,refType where  company.id='" + companyID + "' and (enabledAcctTable.id='" + curAcctTableID + "' or disabledAcctTable.id='" + curAcctTableID + "') ";
        AccountRefContrastCollection acctRefCol = AccountRefContrastFactory.getLocalInstance(ctx).getAccountRefContrastCollection(oql);
        if (upperRef != null) {
            boolean isSameAcctTable;
            if ((acctRefCol == null || acctRefCol.size() == 0) && assign && upperRef.getCompany().getId().toString().equals(acctCtrlInfo.getDestCompany().getParent().getId().toString()) && (isSameAcctTable = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).exists("where id='" + acctCtrlInfo.getDestCompany().getId().toString() + "' and accountTable.id = '" + upperRef.getDisabledAcctTable().getId().toString() + "'"))) {
                curRef = (AccountRefContrastInfo)upperRef.clone();
                curRef.setId(null);
                curRef.setCompany(acctCtrlInfo.getDestCompany());
                curRef.setEnabledPeriod(null);
                curRef.setEnabledTime(null);
                curRef.setIsEnabled(false);
                curRef.setUpper(upperRef);
                curRef.setContrastTime(new Date());
                curRef.getAcctRefContrastEntry().clear();
                AccountRefContrastFactory.getLocalInstance(ctx).submit((CoreBaseInfo)curRef);
            }
            if (assign && upperRef.isIsEnabled()) {
                AccountRefContrastUtil util = new AccountRefContrastUtil();
                try {
                    HashMap entitySet = (HashMap)AccountAssignThreadLocalUtil.getThreadLocalMapValue("dAssistTypemMap");
                    util.chkDataBaseDIsAssign(ctx, acctCtrlInfo.getDestCompany(), true, entitySet);
                }
                catch (EASBizException e) {
                    throw e;
                }
                catch (BOSException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BOSException(e.getMessage());
                }
            }
        }
        AccountRefContrastInfo curRefTmp = null;
        for (int i = 0; i < acctRefCol.size(); ++i) {
            curRefTmp = acctRefCol.get(i);
            if (curRefTmp != null && curRefTmp.isIsEnabled() && assign) {
                if (acctCtrlInfo.getAccountTableID() == null || acctCtrlInfo.getAccountTableID().getId().toString().equals(curRefTmp.getEnabledAcctTable().getId().toString()) || curRefTmp.getRefType().getValue() != 1) continue;
                throw new AccountException(AccountException.ACCOUNTTABLEINENABLEDACCTREF, new Object[]{acctCtrlInfo.getDestCompany().getName(), acctCtrlInfo.getAccountTableID().getName()});
            }
            if (curRefTmp == null || !curRefTmp.isIsEnabled() || assign) continue;
            this.checkCanUnassignWhenRefisenabled(ctx, acctCtrlInfo, accountCols, curRefTmp);
        }
        if (!acctCtrlInfo.getDestCompany().isIsAssistantOrg()) {
            this.checkCanUnassignForAssistantOrg(ctx, acctCtrlInfo, accountCols);
        }
        return curRef;
    }

    private void checkCanUnassignForAssistantOrg(Context ctx, Account_ControlInfo acctCtrlInfo, AccountViewCollection accountCols) throws BOSException {
        String mainOrgID = acctCtrlInfo.getDestCompany().getId().toString();
        String acctTabelID = acctCtrlInfo.getAccountTableID().getId().toString();
        String sql = "select ref1.fid id from t_bd_AcctRefContrast ref1  inner join t_org_company org on org.fid=ref1.fcompanyid where ref1.fisenabled=1 and ref1.freftype=? and ref1.FDisabledAcctTableID=? and org.fmainorgid=?";
        IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{2, acctTabelID, mainOrgID});
        AccountRefContrastInfo refInfo = new AccountRefContrastInfo();
        try {
            while (rowSet.next()) {
                refInfo.setId(BOSUuid.read((String)rowSet.getString("id")));
                this.checkCanUnassignWhenRefisenabled(ctx, acctCtrlInfo, accountCols, refInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected String accountUnassign(Context ctx, Account_ControlInfo acctCtrlInfo, AccountViewCollection accountCols, boolean isDisplayAll) throws BOSException, EASBizException {
        AccountViewCollection acctForDeleteCon = this.getAcctForDeleteCon(ctx, acctCtrlInfo, accountCols);
        this.assignAcctCtrl(ctx, acctCtrlInfo);
        AccountRefContrastInfo curRef = null;
        AccountRefContrastInfo upperRef = null;
        this.checkAccountRefWhenAssignOrUnassign(ctx, curRef, upperRef, acctCtrlInfo, acctForDeleteCon, false);
        String errorMsg = this.verifyNew(ctx, acctForDeleteCon, acctCtrlInfo.getDestCompany(), acctCtrlInfo.getAccountTableID(), true);
        if (errorMsg != null) {
            return errorMsg;
        }
        this.handleParentLevel(ctx, acctForDeleteCon);
        this.batchCancleAssignAccount(ctx, acctCtrlInfo.getDestCompany(), acctCtrlInfo.getAccountTableID(), acctForDeleteCon);
        this.delRefEntry(ctx, acctForDeleteCon, curRef, upperRef);
        this.deleteAcctCtrl(ctx, acctCtrlInfo);
        return null;
    }

    private void deleteAcctCtrl(Context ctx, Account_ControlInfo acctCtrlInfo) throws BOSException, EASBizException {
        FilterInfo acctFilter = new FilterInfo();
        acctFilter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)acctCtrlInfo.getDestCompany().getId().toString()));
        acctFilter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)acctCtrlInfo.getAccountTableID().getId().toString()));
        if (!this.exists(ctx, acctFilter)) {
            IAccount_Control acctCtrl = Account_ControlFactory.getLocalInstance(ctx);
            FilterInfo acctCtrlFilter = new FilterInfo();
            acctCtrlFilter.getFilterItems().add(new FilterItemInfo("destCompany.id", (Object)acctCtrlInfo.getDestCompany().getId().toString()));
            acctCtrlFilter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)acctCtrlInfo.getAccountTableID().getId().toString()));
            acctCtrl.delete(acctCtrlFilter);
            ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo companyOrgUnitInfo = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(acctCtrlInfo.getDestCompany().getId()));
            if (companyOrgUnitInfo.getAccountTable() != null && acctCtrlInfo.getAccountTableID().getId().equals((Object)companyOrgUnitInfo.getAccountTable().getId())) {
                NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx).updateAccountTableInCompany(companyOrgUnitInfo.getId().toString(), null);
            }
        }
    }

    private void delRefEntry(Context ctx, AccountViewCollection acctForDeleteCon, AccountRefContrastInfo curRef, AccountRefContrastInfo upperRef) throws BOSException {
        if (curRef != null && curRef.getId() != null && upperRef != null) {
            try {
                this.util.delRefEntry(ctx, curRef, acctForDeleteCon);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void handleParentLevel(Context ctx, AccountViewCollection acctForDeleteCon) throws BOSException {
        for (int j = acctForDeleteCon.size() - 1; j >= 0; --j) {
            String inferiorId = acctForDeleteCon.get(j).getId().toString();
            String parentId = null;
            if (acctForDeleteCon.get(j).getParent() != null) {
                parentId = acctForDeleteCon.get(j).getParent().getId().toString();
            }
            if (StringUtils.isEmpty((String)inferiorId) || StringUtils.isEmpty(parentId)) continue;
            try {
                int minGLevel;
                String sqlToGetParent = "SELECT FGLevel,FLevel,fcontrollevel,FParentID FROM T_BD_ACCOUNTVIEW WHERE FID=?";
                IRowSet rsToGetParent = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetParent, (Object[])new Object[]{parentId});
                if (rsToGetParent == null || !rsToGetParent.next()) continue;
                int gLevel = rsToGetParent.getInt("FGLevel");
                int level = rsToGetParent.getInt("FLevel");
                int controllevel = rsToGetParent.getInt("fcontrollevel");
                if (gLevel <= level) continue;
                String sqlToGetMinGLevel = "SELECT COUNT(fid) COUNT,MIN(FGLevel) MINGLEVEL FROM T_BD_ACCOUNTVIEW WHERE FPARENTID=?";
                IRowSet rsToGetMinGLevel = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetMinGLevel, (Object[])new Object[]{parentId});
                if (rsToGetMinGLevel != null && rsToGetMinGLevel.next()) {
                    minGLevel = rsToGetMinGLevel.getInt("MINGLEVEL");
                    if (rsToGetMinGLevel.getInt("COUNT") <= 1) {
                        --minGLevel;
                        String sqlToSetParentLeaf = "UPDATE T_BD_ACCOUNTVIEW SET FISLEAF=? WHERE FID=?";
                        if (parentId != null && parentId.length() > 0) {
                            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sqlToSetParentLeaf, (Object[])new Object[]{Boolean.TRUE, parentId});
                        }
                    }
                    if (minGLevel < 1) {
                        minGLevel = level;
                    }
                } else {
                    minGLevel = level;
                }
                if (controllevel > minGLevel) {
                    controllevel = minGLevel;
                }
                String sqlToUpdateGLevel = "UPDATE T_BD_ACCOUNTVIEW SET FGLevel=?,fcontrollevel=? WHERE FID=?";
                com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sqlToUpdateGLevel, (Object[])new Object[]{new Integer(minGLevel), new Integer(controllevel), parentId});
                parentId = rsToGetParent.getString("FParentID");
                continue;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private AccountViewCollection getAcctForDeleteCon(Context ctx, Account_ControlInfo acctCtrlInfo, AccountViewCollection accountCols) throws BOSException, EASBizException {
        HashSet<String> destNumber = new HashSet<String>();
        int acctCount = accountCols.size();
        for (int j = 0; j < acctCount; ++j) {
            AccountViewInfo acctInfo = accountCols.get(j);
            destNumber.add(acctInfo.getNumber());
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctCtrlInfo.getAccountTableID().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)acctCtrlInfo.getDestCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("number", destNumber, CompareType.INCLUDE));
        evi.setFilter(filter);
        SorterItemCollection coll = new SorterItemCollection();
        SorterItemInfo sorterInfo = new SorterItemInfo("number");
        coll.add(sorterInfo);
        evi.setSorter(coll);
        return this.getAccountsByDAO(ctx, evi);
    }

    protected String verifyAndAssign(Context ctx, Account_ControlCollection acctCtrlCols, AccountViewCollection accountCols, boolean isDisplayAll) throws BOSException, EASBizException {
        int i;
        StringBuffer value = new StringBuffer("");
        int notSuc = 0;
        int total = 0;
        ArrayList<AccountViewInfo> accountForInsert = new ArrayList<AccountViewInfo>();
        ArrayList<AccountViewInfo> accountForDelete = new ArrayList<AccountViewInfo>();
        boolean isCacelAssign = false;
        boolean assign = acctCtrlCols.get(0).isAssign();
        if (!assign) {
            Account_ControlCollection tmpAcctCtrlColl = new Account_ControlCollection();
            for (i = acctCtrlCols.size() - 1; i >= 0; --i) {
                tmpAcctCtrlColl.add(acctCtrlCols.get(i));
            }
            acctCtrlCols = tmpAcctCtrlColl;
        }
        int acctCtrlCount = acctCtrlCols.size();
        for (i = 0; i < acctCtrlCount; ++i) {
            BOSUuid parentCompanyId;
            BOSUuid currentCompanyId;
            boolean isGradeAssign;
            accountForInsert.clear();
            accountForDelete.clear();
            Account_ControlInfo acctCtrlInfo = acctCtrlCols.get(i);
            isCacelAssign = !assign;
            HashSet<String> destNumber = new HashSet<String>();
            int acctCount = accountCols.size();
            for (int j = 0; j < acctCount; ++j) {
                AccountViewInfo acctInfo = accountCols.get(j);
                if (assign) {
                    accountForInsert.add(acctInfo);
                    continue;
                }
                destNumber.add(acctInfo.getNumber());
            }
            AccountViewCollection acctForDeleteCon = null;
            if (destNumber.size() > 0) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctCtrlInfo.getAccountTableID().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)acctCtrlInfo.getDestCompany().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("number", destNumber, CompareType.INCLUDE));
                evi.setFilter(filter);
                SorterItemCollection coll = new SorterItemCollection();
                SorterItemInfo sorterInfo = new SorterItemInfo("number");
                coll.add(sorterInfo);
                evi.setSorter(coll);
                acctForDeleteCon = this.getAccountsByDAO(ctx, evi);
                int count = acctForDeleteCon.size();
                for (int k = 0; k < count; ++k) {
                    AccountViewInfo info = acctForDeleteCon.get(k);
                    accountForDelete.add(info);
                }
            }
            this.assignAcctCtrl(ctx, acctCtrlInfo);
            boolean bl = isGradeAssign = !isDisplayAll;
            if (assign && !isGradeAssign && !(currentCompanyId = acctCtrlInfo.getSrcCompany().getId()).equals((Object)(parentCompanyId = acctCtrlInfo.getDestCompany().getParent().getId()))) {
                this.checkParentCompany(ctx, acctCtrlInfo, accountCols);
            }
            if (assign) {
                this.setCompanyAccountTable(ctx, acctCtrlInfo.getDestCompany(), acctCtrlInfo.getAccountTableID());
            }
            AccountViewCollection acctColsForInsert = this.getAllInformationForAcct(ctx, accountForInsert);
            Set assignedAccountNumberSet = new HashSet();
            if (assign) {
                assignedAccountNumberSet = this.getAssignedAccountNumberSet(ctx, acctCtrlInfo, accountCols);
            }
            AccountRefContrastInfo curRef = null;
            AccountRefContrastInfo upperRef = AccountRefContrastFactory.getLocalInstance(ctx).getAcctInfo(acctCtrlInfo.getSrcCompany().getId().toString(), acctCtrlInfo.getAccountTableID().getId().toString());
            if (upperRef != null) {
                boolean isSameAcctTable = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).exists("where id='" + acctCtrlInfo.getDestCompany().getId().toString() + "' and accountTable.id = '" + upperRef.getDisabledAcctTable().getId().toString() + "'");
                curRef = AccountRefContrastFactory.getLocalInstance(ctx).getAcctInfo(acctCtrlInfo.getDestCompany().getId().toString(), acctCtrlInfo.getAccountTableID().getId().toString());
                if (curRef != null && curRef.isIsEnabled() && !assign) {
                    this.checkCanUnassignWhenRefisenabled(ctx, acctCtrlInfo, accountCols, curRef);
                }
                if (curRef != null && curRef.isIsEnabled() && assign && acctCtrlCols.get(0).getAccountTableID() != null && !acctCtrlCols.get(0).getAccountTableID().getId().toString().equals(curRef.getEnabledAcctTable().getId().toString()) && curRef.getRefType().getValue() == 1) {
                    throw new AccountException(AccountException.ACCOUNTTABLEINENABLEDACCTREF, new Object[]{acctCtrlInfo.getDestCompany().getName(), acctCtrlInfo.getAccountTableID().getName()});
                }
                if (curRef == null && isSameAcctTable && assign) {
                    curRef = (AccountRefContrastInfo)upperRef.clone();
                    curRef.setId(null);
                    curRef.setCompany(acctCtrlInfo.getDestCompany());
                    curRef.setEnabledPeriod(null);
                    curRef.setEnabledTime(null);
                    curRef.setIsEnabled(false);
                    curRef.setUpper(upperRef);
                    curRef.setContrastTime(new Date());
                    curRef.getAcctRefContrastEntry().clear();
                    AccountRefContrastFactory.getLocalInstance(ctx).submit((CoreBaseInfo)curRef);
                }
                if (assign && upperRef.isIsEnabled()) {
                    AccountRefContrastUtil util = new AccountRefContrastUtil();
                    try {
                        util.checkGenAsstActType(ctx, accountCols, upperRef);
                        util.checkAsstActTypeD(ctx, accountCols, upperRef, acctCtrlInfo.getDestCompany());
                    }
                    catch (EASBizException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw e;
                    }
                    catch (BOSException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw e;
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new BOSException(e.getMessage());
                    }
                }
            }
            if (curRef == null) {
                curRef = AccountRefContrastFactory.getLocalInstance(ctx).getLastAcctInfo(acctCtrlInfo.getDestCompany().getId().toString(), acctCtrlInfo.getAccountTableID().getId().toString());
                if (curRef != null && curRef.isIsEnabled() && assign) {
                    if (acctCtrlCols.get(0).getAccountTableID() != null && !acctCtrlCols.get(0).getAccountTableID().getId().toString().equals(curRef.getEnabledAcctTable().getId().toString()) && curRef.getRefType().getValue() == 1) {
                        throw new AccountException(AccountException.ACCOUNTTABLEINENABLEDACCTREF, new Object[]{acctCtrlInfo.getDestCompany().getName(), acctCtrlInfo.getAccountTableID().getName()});
                    }
                } else if (curRef != null && curRef.isIsEnabled() && !assign) {
                    this.checkCanUnassignWhenRefisenabled(ctx, acctCtrlInfo, accountCols, curRef);
                }
            }
            AccountViewCollection acctColl = new AccountViewCollection();
            AccountCurrencyCollection acctCurrencyCols = new AccountCurrencyCollection();
            HashMap<String, AccountViewInfo> acctParentIdMap = new HashMap<String, AccountViewInfo>();
            int accountForInsertCount = acctColsForInsert.size();
            for (int j = 0; j < accountForInsertCount; ++j) {
                AccountViewInfo acctInfo = this.copyGeneratedNewAccountInfo(ctx, acctCtrlInfo, acctParentIdMap, acctColsForInsert, j);
                this.checkAssignAACM(ctx, acctInfo);
                AccountCurrencyCollection acctCuCols = acctInfo.getAccountCurrency();
                if (acctCuCols != null) {
                    int acctCuCount = acctCuCols.size();
                    for (int k = 0; k < acctCuCount; ++k) {
                        AccountCurrencyInfo acctCuInfo = acctCuCols.get(k);
                        acctCuInfo.setAccountView(acctInfo);
                        acctCuInfo.setId(null);
                    }
                }
                String parentId = null;
                String upperId = "";
                boolean isLeaf = false;
                try {
                    AccountViewInfo parent = null;
                    if (acctInfo.getParent() != null) {
                        upperId = acctInfo.getParent().getId().toString();
                        try {
                            parent = (AccountViewInfo)acctParentIdMap.get(acctInfo.getParent().getId().toString());
                            if (parent == null || assignedAccountNumberSet.contains(acctInfo.getNumber())) {
                                String sqlToGetInferiorParent = "SELECT TOP 1 FID,FAcctCurrency,FCAA, FIsleaf,FISCFREEZE FROM T_BD_ACCOUNTVIEW WHERE FNumber=? AND FAccountTableID=?  AND FCompanyID=?";
                                IRowSet rsToGetInferiorParent = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetInferiorParent, (Object[])new Object[]{acctInfo.getParent().getNumber(), acctInfo.getAccountTableID().getId().toString(), acctCtrlInfo.getDestCompany().getId().toString()});
                                if (rsToGetInferiorParent != null && rsToGetInferiorParent.next()) {
                                    int acctCurrency = rsToGetInferiorParent.getInt("FAcctCurrency");
                                    if (acctCurrency == 1 && AccountingCurrencyEnum.ALLCURRENCY.equals((Object)acctInfo.getAccountingcurrency())) {
                                        throw new AccountException(AccountException.DCOMPANY_NOTALLCUR, new Object[]{acctCtrlInfo.getDestCompany().getName(), acctInfo.getNumber()});
                                    }
                                    parentId = rsToGetInferiorParent.getString("FID");
                                    isLeaf = rsToGetInferiorParent.getBoolean("FIsleaf");
                                    parent = new AccountViewInfo();
                                    if (!StringUtils.isEmpty((String)rsToGetInferiorParent.getString("Fcaa"))) {
                                        AsstAccountInfo asst = new AsstAccountInfo();
                                        asst.setId(BOSUuid.read((String)rsToGetInferiorParent.getString("Fcaa")));
                                        parent.setCAA(asst);
                                    }
                                    parent.setId(BOSUuid.read((String)parentId));
                                    parent.setIsLeaf(isLeaf);
                                    parent.setIsCFreeze(rsToGetInferiorParent.getBoolean("FISCFREEZE"));
                                    parent.setIsCFreeze(rsToGetInferiorParent.getBoolean("FISCFREEZE"));
                                    acctParentIdMap.put(acctInfo.getParent().getId().toString(), parent);
                                } else {
                                    throw new AccountException(AccountException.CHILDCUMUSTEQUALPARENTCU, new Object[]{acctInfo.getNumber()});
                                }
                            }
                            if (parent.isIsCFreeze()) {
                                acctInfo.setIsCFreeze(true);
                                acctInfo.setIsParentFreeze(true);
                            }
                            acctInfo.setParent(parent);
                            acctInfo.setCAA(parent.getCAA());
                            acctInfo.setParentAA(parent.getCAA());
                        }
                        catch (SQLException e) {
                            throw new BOSException((Throwable)e);
                        }
                    }
                    if (parentId != null) {
                        // empty if block
                    }
                    ++total;
                    if (assignedAccountNumberSet.contains(acctInfo.getNumber())) {
                        this._addnew(ctx, (IObjectValue)acctInfo);
                        continue;
                    }
                    if (acctInfo.getParent() != null && acctInfo.getParent().getNumber() != null && assignedAccountNumberSet.contains(acctInfo.getParent().getNumber())) {
                        this._addnew(ctx, (IObjectValue)acctInfo);
                        parent = acctInfo.getParent();
                        acctParentIdMap.put(upperId, parent);
                        continue;
                    }
                    if (acctInfo.getParent() != null && acctInfo.getParent().isIsLeaf()) {
                        this._addnew(ctx, (IObjectValue)acctInfo);
                        parent.setId(acctInfo.getParent().getId());
                        parent.setIsLeaf(false);
                        continue;
                    }
                    try {
                        this.checkDupName(ctx, acctInfo);
                    }
                    catch (EASBizException e) {
                        throw new AccountException(AccountException.NAMEADUPLICATE_CAN_NOT_ASSIGN, new Object[]{acctInfo.getCompanyID().getName(), acctInfo.getName(), acctInfo.getNumber()});
                    }
                    acctColl.add(acctInfo);
                    acctCurrencyCols.addCollection(acctCuCols);
                    continue;
                }
                catch (AccountException e) {
                    if ("542".equals(e.getSubCode())) {
                        value.append("(" + ++notSuc + ")").append(ResourceBase.getString((String)RESOURCE, (String)"Company", (Locale)ctx.getOriginLocale())).append(acctInfo.getCompanyID().getNumber()).append(acctInfo.getCompanyID().getName()).append(e.getMessage()).append("\r\n");
                        continue;
                    }
                    if ("100".equals(e.getSubCode())) {
                        this.handleDupLongNumber(ctx, acctInfo, e, true);
                        continue;
                    }
                    throw e;
                }
            }
            this.handleAstInitClosed(ctx, acctCtrlInfo.getDestCompany(), acctCtrlInfo.getAccountTableID(), acctColl);
            ORMEngine.addnewVO((Context)ctx, (IObjectCollection)acctColl);
            ORMEngine.addnewVO((Context)ctx, (IObjectCollection)acctCurrencyCols);
            this.repairUpperidAndFreezeProperties(ctx, acctCtrlInfo, acctColl);
            if (curRef != null && curRef.getId() != null) {
                try {
                    if (upperRef != null && upperRef.isIsEnabled() && assign) {
                        this.util.copyRefEntry(ctx, upperRef, curRef, acctColsForInsert);
                    }
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            this.verify(ctx, acctForDeleteCon, acctCtrlInfo.getDestCompany(), acctCtrlInfo.getAccountTableID(), true);
            int accountForDeleteCount = accountForDelete.size();
            for (int j = accountForDeleteCount - 1; j >= 0; --j) {
                isCacelAssign = true;
                String inferiorId = ((AccountViewInfo)accountForDelete.get(j)).getId().toString();
                String parentId = null;
                if (((AccountViewInfo)accountForDelete.get(j)).getParent() != null) {
                    parentId = ((AccountViewInfo)accountForDelete.get(j)).getParent().getId().toString();
                }
                if (inferiorId == null || inferiorId.length() <= 0) continue;
                try {
                    int minGLevel;
                    String sqlToGetParent;
                    IRowSet rsToGetParent;
                    if (parentId == null || parentId.length() <= 0 || (rsToGetParent = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)(sqlToGetParent = "SELECT FGLevel,FLevel,fcontrollevel,FParentID FROM T_BD_ACCOUNTVIEW WHERE FID=?"), (Object[])new Object[]{parentId})) == null || !rsToGetParent.next()) continue;
                    int gLevel = rsToGetParent.getInt("FGLevel");
                    int level = rsToGetParent.getInt("FLevel");
                    int controllevel = rsToGetParent.getInt("fcontrollevel");
                    if (gLevel <= level) continue;
                    String sqlToGetMinGLevel = "SELECT COUNT(fid) COUNT,MIN(FGLevel) MINGLEVEL FROM T_BD_ACCOUNTVIEW WHERE FPARENTID=?";
                    IRowSet rsToGetMinGLevel = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetMinGLevel, (Object[])new Object[]{parentId});
                    if (rsToGetMinGLevel != null && rsToGetMinGLevel.next()) {
                        minGLevel = rsToGetMinGLevel.getInt("MINGLEVEL");
                        if (rsToGetMinGLevel.getInt("COUNT") <= 1) {
                            --minGLevel;
                            String sqlToSetParentLeaf = "UPDATE T_BD_ACCOUNTVIEW SET FISLEAF=? WHERE FID=?";
                            if (parentId != null && parentId.length() > 0) {
                                com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sqlToSetParentLeaf, (Object[])new Object[]{Boolean.TRUE, parentId});
                            }
                        }
                        if (minGLevel < 1) {
                            minGLevel = level;
                        }
                    } else {
                        minGLevel = level;
                    }
                    if (controllevel > minGLevel) {
                        controllevel = minGLevel;
                    }
                    String sqlToUpdateGLevel = "UPDATE T_BD_ACCOUNTVIEW SET FGLevel=?,fcontrollevel=? WHERE FID=?";
                    com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sqlToUpdateGLevel, (Object[])new Object[]{new Integer(minGLevel), new Integer(controllevel), parentId});
                    parentId = rsToGetParent.getString("FParentID");
                    continue;
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            if (!assign) {
                this.batchCancleAssignAccount(ctx, acctCtrlInfo.getDestCompany(), acctCtrlInfo.getAccountTableID(), acctForDeleteCon);
                if (curRef != null && curRef.getId() != null) {
                    try {
                        if (upperRef != null) {
                            this.util.delRefEntry(ctx, curRef, acctForDeleteCon);
                        }
                    }
                    catch (Exception e) {
                        throw new BOSException((Throwable)e);
                    }
                }
            }
            FilterInfo acctFilter = new FilterInfo();
            acctFilter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)acctCtrlInfo.getDestCompany().getId().toString()));
            acctFilter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)acctCtrlInfo.getAccountTableID().getId().toString()));
            if (assign || this.exists(ctx, acctFilter)) continue;
            IAccount_Control acctCtrl = Account_ControlFactory.getLocalInstance(ctx);
            FilterInfo acctCtrlFilter = new FilterInfo();
            acctCtrlFilter.getFilterItems().add(new FilterItemInfo("destCompany.id", (Object)acctCtrlInfo.getDestCompany().getId().toString()));
            acctCtrlFilter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)acctCtrlInfo.getAccountTableID().getId().toString()));
            acctCtrl.delete(acctCtrlFilter);
            ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo companyOrgUnitInfo = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(acctCtrlInfo.getDestCompany().getId()));
            if (companyOrgUnitInfo.getAccountTable() == null || !acctCtrlInfo.getAccountTableID().getId().equals((Object)companyOrgUnitInfo.getAccountTable().getId())) continue;
            NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx).updateAccountTableInCompany(companyOrgUnitInfo.getId().toString(), null);
        }
        if (isCacelAssign) {
            value.append(ResourceBase.getString((String)RESOURCE, (String)"CancelAssisgnSuccess", (Locale)ctx.getLocale()));
        } else if (acctCtrlCount == 1) {
            if (notSuc > 0) {
                value.append(ResourceBase.getString((String)RESOURCE, (String)"OTherAccount", (Locale)ctx.getLocale()));
            }
            value.append(ResourceBase.getString((String)RESOURCE, (String)"AssisgnSuccess", (Locale)ctx.getLocale()));
        } else {
            value = new StringBuffer(ResourceBase.getString((String)RESOURCE, (String)"AssisgnSuccess", (Locale)ctx.getLocale()));
        }
        return value.toString();
    }

    private void repairUpperidAndFreezeProperties(Context ctx, Account_ControlInfo acctCtrlInfo, AccountViewCollection acctColl) throws BOSException {
        this.repairUperID(ctx, acctCtrlInfo.getDestCompany().getId().toString(), acctCtrlInfo.getAccountTableID().getId().toString());
        HashSet<String> idSet = new HashSet<String>();
        for (int j = 0; j < acctColl.size(); ++j) {
            AccountViewInfo acctInfo = acctColl.get(j);
            idSet.add(acctInfo.getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SelectorItemCollection seleColl = new SelectorItemCollection();
        seleColl.add(new SelectorItemInfo("id"));
        seleColl.add(new SelectorItemInfo("upper.id"));
        seleColl.add(new SelectorItemInfo("upper.isCFreeze"));
        seleColl.add(new SelectorItemInfo("upper.isGFreeze"));
        seleColl.add(new SelectorItemInfo("upper.isParentFreeze"));
        seleColl.add(new SelectorItemInfo("upper.isSelfFreeze"));
        view.setFilter(filter);
        view.setSelector(seleColl);
        AccountViewCollection accountViewColl = AccountViewFactory.getLocalInstance(ctx).getAccountViewCollection(view);
        for (int j = 0; j < accountViewColl.size(); ++j) {
            AccountViewInfo accountViewInfo = accountViewColl.get(j);
            if (!accountViewInfo.getUpper().isIsGFreeze() && !accountViewInfo.getUpper().isIsSelfFreeze() && !accountViewInfo.getUpper().isIsParentFreeze()) continue;
            String tmpSql = "update t_bd_accountview set FIsGFreeze =1,FIsCFreeze =1 where fid='" + accountViewInfo.getId().toString() + "'";
            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)tmpSql);
        }
    }

    private void handleDupLongNumber(Context ctx, AccountViewInfo acctInfo, AccountException e, boolean isAssign) throws BOSException, EASBizException {
        block8: {
            if (acctInfo.getUpper() != null) {
                String isUpdateUpper = ParamManager.getParamValue((Context)ctx, null, (String)"ISUpdateUpper");
                String sqlQueryName = "select top 1 fid,FCAA from  T_BD_ACCOUNTVIEW WHERE fnumber=? and fname_" + ctx.getLocale().getLanguage() + "=? and FCompanyID=? and FaccounttableId=? ";
                IRowSet rsToGetSame = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlQueryName, (Object[])new Object[]{acctInfo.getNumber().trim(), acctInfo.getName().toString(), acctInfo.getCompanyID().getId().toString(), acctInfo.getAccountTableID().getId().toString()});
                try {
                    if (rsToGetSame != null && rsToGetSame.next() && "true".equalsIgnoreCase(isUpdateUpper)) {
                        if (rsToGetSame.getString("fcaa") == null && acctInfo.getCAA() != null) {
                            throw new AccountException(AccountException.INFERIORNOTINCLUDEUPPERCAA, new Object[]{acctInfo.getCompanyID().getName(), acctInfo.getNumber()});
                        }
                        if (rsToGetSame.getString("fcaa") != null && acctInfo.getCAA() != null) {
                            ObjectUuidPK caa = new ObjectUuidPK(rsToGetSame.getString("fcaa"));
                            ObjectUuidPK upperCaa = new ObjectUuidPK(acctInfo.getCAA().getId());
                            IAsstAccount iAsstAccount = AsstAccountFactory.getLocalInstance((Context)ctx);
                            if (!iAsstAccount.compare((IObjectPK)upperCaa, (IObjectPK)caa)) {
                                throw new AccountException(AccountException.INFERIORNOTINCLUDEUPPERCAA, new Object[]{acctInfo.getCompanyID().getName(), acctInfo.getNumber()});
                            }
                        }
                        String sqlUpdateNumber = "Update T_BD_ACCOUNTVIEW set FupperId=?,FGAA=? WHERE fnumber=? and fname_" + ctx.getLocale().getLanguage() + "=? and FCompanyID=? and FaccounttableId=? ";
                        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sqlUpdateNumber, (Object[])new Object[]{acctInfo.getUpper().getId().toString(), acctInfo.getCAA() == null ? null : acctInfo.getCAA().getId().toString(), acctInfo.getNumber().trim(), acctInfo.getName().toString(), acctInfo.getCompanyID().getId().toString(), acctInfo.getAccountTableID().getId().toString()});
                        String accountId = rsToGetSame.getString("fid");
                        if (accountId != null && accountId.trim().length() > 0) {
                            acctInfo.setId(BOSUuid.read((String)accountId));
                        }
                        break block8;
                    }
                    throw e;
                }
                catch (SQLException e1) {
                    logger.error((Object)e1.getMessage());
                    throw new BOSException((Throwable)((Object)e));
                }
            }
        }
    }

    private void checkCanUnassignWhenRefisenabled(Context ctx, Account_ControlInfo acctCtrlInfo, AccountViewCollection accountCols, AccountRefContrastInfo curRef) throws BOSException, HeadDetailException {
        HashSet<String> deleteSet = new HashSet<String>();
        for (int j = 0; j < accountCols.size(); ++j) {
            AccountViewInfo acctInfo = accountCols.get(j);
            deleteSet.add(acctInfo.getId().toString());
        }
        String accountNumber = this.accountInAcctRef(ctx, deleteSet, curRef);
        if (!StringUtils.isEmpty((String)accountNumber)) {
            AccountException headException = new AccountException(AccountException.INFERIOR_ACCT_REF_ENABLE, new Object[]{acctCtrlInfo.getDestCompany().getName()});
            throw new HeadDetailException(headException.getMessage(), accountNumber, 1);
        }
    }

    private String accountInAcctRef(Context ctx, Set accountForDelete, AccountRefContrastInfo curRef) throws BOSException {
        if (accountForDelete == null || accountForDelete.size() == 0) {
            return "";
        }
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection selectColl = new SelectorItemCollection();
        selectColl.add(new SelectorItemInfo("oldAcct.number"));
        selectColl.add(new SelectorItemInfo("oldAcct.name"));
        selectColl.add(new SelectorItemInfo("newAcct.number"));
        selectColl.add(new SelectorItemInfo("newAcct.name"));
        filter.getFilterItems().add(new FilterItemInfo("newAcct", (Object)accountForDelete, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("oldAcct", (Object)accountForDelete, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("acctRefContrast", (Object)curRef.getId().toString()));
        filter.setMaskString("(#0 or #1) and #2");
        entity.setSelector(selectColl);
        entity.setFilter(filter);
        AccountRefContrastEntryCollection acctRefContrastEntry = AccountRefContrastEntryFactory.getLocalInstance(ctx).getAccountRefContrastEntryCollection(entity);
        String accountNumber = "";
        for (int i = 0; i < acctRefContrastEntry.size(); ++i) {
            accountNumber = accountNumber + acctRefContrastEntry.get(i).getOldAcct().getNumber() + " [" + acctRefContrastEntry.get(i).getOldAcct().getName() + "]---" + acctRefContrastEntry.get(i).getNewAcct().getNumber() + " [" + acctRefContrastEntry.get(i).getNewAcct().getName() + "]\n";
        }
        return accountNumber;
    }

    private void checkParentCompany(Context ctx, Account_ControlInfo acctCtrlInfo, AccountViewCollection accountCols) throws BOSException, EASBizException {
        BOSUuid accountTableId = acctCtrlInfo.getAccountTableID().getId();
        BOSUuid currentCompanyId = acctCtrlInfo.getSrcCompany().getId();
        BOSUuid parentCompanyId = acctCtrlInfo.getDestCompany().getParent().getId();
        if (accountTableId == null || currentCompanyId == null || parentCompanyId == null || accountCols == null || accountCols.size() == 0) {
            return;
        }
        StringBuilder accountNumberSet = new StringBuilder();
        boolean isFirst = true;
        HashMap<String, AccountViewInfo> accInfoMap = new HashMap<String, AccountViewInfo>();
        for (int i = 0; i < accountCols.size(); ++i) {
            AccountViewInfo account = accountCols.get(i);
            accInfoMap.put(account.getNumber(), account);
            if (isFirst) {
                isFirst = false;
            } else {
                accountNumberSet.append(",");
            }
            accountNumberSet.append("'").append(account.getNumber()).append("'");
        }
        String sql = "select fnumber from t_bd_accountview where faccounttableid = ? and fcompanyid = ? and fnumber in (" + accountNumberSet.toString() + ") and fnumber not in(select fnumber from t_bd_accountview where  faccounttableid = ? and fcompanyid = ?)";
        try {
            IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{accountTableId.toString(), currentCompanyId.toString(), accountTableId.toString(), parentCompanyId.toString()});
            StringBuilder errNumber = new StringBuilder();
            isFirst = true;
            while (rs != null && rs.next()) {
                String number = rs.getString("fnumber");
                if (isFirst) {
                    isFirst = false;
                } else {
                    errNumber.append(", ");
                }
                errNumber.append(number);
            }
            if (!isFirst) {
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(parentCompanyId));
                throw new AccountException(AccountException.PARENT_COMPANY_HAS_NOT_ACCOUNT, new Object[]{company.getNumber() + "(" + company.getName() + ")", errNumber.toString()});
            }
            String sql1 = "SELECT FCAA,FNUMBER FROM T_BD_ACCOUNTVIEW WHERE FCOMPANYID = ? AND FACCOUNTTABLEID = ? AND FCAA IS NOT NULL and FNUMBER in (" + accountNumberSet.toString() + ")";
            rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new String[]{parentCompanyId.toString(), accountTableId.toString()});
            StringBuilder detailErrInfo = new StringBuilder();
            detailErrInfo.append("\u3010");
            boolean flag = false;
            IAsstAccount iAsstAccount = AsstAccountFactory.getLocalInstance((Context)ctx);
            while (rs.next()) {
                AccountViewInfo info = (AccountViewInfo)accInfoMap.get(rs.getString("FNumber"));
                if (info.getCAA() != null && iAsstAccount.compare((IObjectPK)new ObjectUuidPK(rs.getString("FCAA")), (IObjectPK)new ObjectUuidPK(info.getCAA().getId()))) continue;
                flag = true;
                detailErrInfo.append(info.getNumber() + "(" + info.getName() + ");");
            }
            detailErrInfo.append("\u3011");
            if (flag) {
                throw new AccountException(AccountException.CAANOTINCLUDEGAA, new Object[]{detailErrInfo.toString()});
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private Set getAssignedAccountNumberSet(Context ctx, Account_ControlInfo acctCtrlInfo, AccountViewCollection accountCols) throws BOSException {
        HashSet<String> assignedAccountNumberSet = new HashSet<String>();
        if (acctCtrlInfo.getAccountTableID() == null || acctCtrlInfo.getDestCompany() == null || accountCols == null || accountCols.size() == 0) {
            return assignedAccountNumberSet;
        }
        StringBuffer numberSet = new StringBuffer();
        int count = accountCols.size();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                numberSet.append(",");
            }
            numberSet.append("'").append(accountCols.get(i).getNumber()).append("'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select fnumber from t_bd_accountview where fcompanyid = '").append(acctCtrlInfo.getDestCompany().getId().toString()).append("' and faccounttableid = '").append(acctCtrlInfo.getAccountTableID().getId().toString()).append("' and  fnumber in (").append(numberSet.toString()).append(")");
        IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs != null && rs.next()) {
                assignedAccountNumberSet.add(rs.getString("fnumber"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return assignedAccountNumberSet;
    }

    private void batchCancleAssignAccount(Context ctx, CompanyOrgUnitInfo company, AccountTableInfo accountTable, AccountViewCollection acctForDeleteCon) throws EASBizException, BOSException {
        StringBuffer idSet = new StringBuffer();
        int count = acctForDeleteCon.size();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                idSet.append(",");
            }
            idSet.append("'").append(acctForDeleteCon.get(i).getId().toString()).append("'");
            this.removeGlFlag(ctx, acctForDeleteCon.get(i).getId().toString());
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        try {
            String sql = "select fparentid from t_bd_accountview where fid in (" + idSet.toString() + ")";
            IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                params.add(new Object[]{rs.getString("fparentid")});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String sqlToDeleteAccountCurrency = "DELETE FROM T_BD_ACCOUNTCURRENCY WHERE FACCOUNTVIEWID in (" + idSet.toString() + ")";
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sqlToDeleteAccountCurrency);
        String sqlToDeleteAccount = "DELETE FROM T_BD_ACCOUNTVIEW WHERE FID in (" + idSet.toString() + ")";
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sqlToDeleteAccount);
        StringBuilder sb = new StringBuilder();
        sb.append("update t_bd_accountview A set FIsLeaf = 1 where not exists").append("(select 1 from t_bd_accountview B where B.fparentid = A.fid) and A.fid =?");
        com.kingdee.eas.util.app.DbUtil.executeBatch((Context)ctx, (String)sb.toString(), params);
    }

    private void handleAstInitClosed(Context ctx, AccountViewInfo acctInfo) throws BOSException {
        if (acctInfo == null || acctInfo.getCAA() == null) {
            return;
        }
        if (!acctInfo.getCompanyID().isIsBizUnit()) {
            try {
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(acctInfo.getCompanyID().getId()));
                if (!company.isIsBizUnit()) {
                    return;
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return;
            }
        }
        if (!acctInfo.isIsLeaf()) {
            return;
        }
        String accountID = acctInfo.getId().toString();
        String accountTableID = acctInfo.getAccountTableID().getId().toString();
        String currentCompanyID = acctInfo.getCompanyID().getId().toString();
        String caaID = acctInfo.getCAA().getId().toString();
        String sqlCheckAstInit = "select acc.fid c from t_gl_flag flag left outer join t_bd_accountview acc on flag.fkey = acc.fid where flag.forgunitid = ? and acc.fisleaf=1 and acc.faccounttableid = ? and acc.fcompanyid = ? ";
        IRowSet checkResult = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlCheckAstInit, (Object[])new Object[]{currentCompanyID, accountTableID, currentCompanyID});
        try {
            if (checkResult == null || !checkResult.next()) {
                return;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String sqlAllAccountAstInitClosed = "select acc.fid from t_bd_accountview acc left outer join t_gl_flag flag on acc.fid=flag.fkey where acc.fisleaf=1 and acc.faccounttableid = ? and acc.fcompanyid = ? and acc.fcaa = ? and acc.fid <> ? and (fkey is null or (flag.fname='astinit' and flag.fvalue='false' and flag.forgunitid = ?))";
        checkResult = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlAllAccountAstInitClosed, (Object[])new Object[]{accountTableID, currentCompanyID, caaID, accountID, currentCompanyID});
        try {
            if (checkResult == null || !checkResult.next()) {
                String[] accountIds = new String[]{accountID};
                boolean[] flags = new boolean[]{true};
                GLFlagProcessFactory.getGLFlagProcessInstance().setAstInitClosed(ctx, accountIds, flags, currentCompanyID);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void handleAstInitClosed(Context ctx, CompanyOrgUnitInfo company, AccountTableInfo accountTable, AccountViewCollection acctColl) throws BOSException {
        if (company == null || !company.isIsBizUnit()) {
            return;
        }
        if (acctColl == null || acctColl.size() == 0) {
            return;
        }
        String currentCompanyID = company.getId().toString();
        String accountTableID = accountTable.getId().toString();
        String sqlCheckAstInit = "select acc.fid c from t_gl_flag flag left outer join t_bd_accountview acc on flag.fkey = acc.fid where flag.forgunitid = ? and acc.fisleaf=1 and acc.faccounttableid = ? and acc.fcompanyid = ? ";
        IRowSet checkResult = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlCheckAstInit, (Object[])new Object[]{currentCompanyID, accountTableID, currentCompanyID});
        try {
            if (checkResult == null || !checkResult.next()) {
                return;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        ArrayList<String> caaIDList = new ArrayList<String>();
        for (int i = 0; i < acctColl.size(); ++i) {
            AccountViewInfo accountViewInfo = acctColl.get(i);
            if (!accountViewInfo.isIsLeaf() || accountViewInfo.getCAA() == null || caaIDList.contains(accountViewInfo.getCAA().getId().toString())) continue;
            caaIDList.add(accountViewInfo.getCAA().getId().toString());
        }
        if (caaIDList.size() == 0) {
            return;
        }
        StringBuffer caaIDs = new StringBuffer();
        boolean isFirst = true;
        for (int i = 0; i < caaIDList.size(); ++i) {
            if (isFirst) {
                isFirst = false;
            } else {
                caaIDs.append(",");
            }
            caaIDs.append("'").append(caaIDList.get(i)).append("'");
        }
        StringBuffer sqlAllAccountAstInitClosed = new StringBuffer();
        sqlAllAccountAstInitClosed.append(" select fcaa from t_bd_accountview acc left outer join t_gl_flag flag on acc.fid=flag.fkey ");
        sqlAllAccountAstInitClosed.append(" where acc.fisleaf=1 and acc.faccounttableid = ? ");
        sqlAllAccountAstInitClosed.append(" and acc.fcompanyid = ? ");
        sqlAllAccountAstInitClosed.append(" and acc.fcaa in (").append(caaIDs.toString()).append(") ");
        sqlAllAccountAstInitClosed.append(" and (fkey is null ");
        sqlAllAccountAstInitClosed.append(" or (flag.fname='astinit' and flag.fvalue='false' and flag.forgunitid = ?)) ");
        checkResult = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlAllAccountAstInitClosed.toString(), (Object[])new Object[]{accountTableID, currentCompanyID, currentCompanyID});
        try {
            ArrayList<String> notFinishedCaaIDList = new ArrayList<String>();
            while (checkResult != null && checkResult.next()) {
                String caa = checkResult.getString("fcaa");
                if (notFinishedCaaIDList.contains(caa)) continue;
                notFinishedCaaIDList.add(caa);
            }
            ArrayList<String> accountIdList = new ArrayList<String>();
            for (int i = 0; i < acctColl.size(); ++i) {
                AccountViewInfo accountViewInfo = acctColl.get(i);
                if (!accountViewInfo.isIsLeaf() || accountViewInfo.getCAA() == null || notFinishedCaaIDList.contains(accountViewInfo.getCAA().getId().toString())) continue;
                accountIdList.add(accountViewInfo.getId().toString());
            }
            if (accountIdList.size() == 0) {
                return;
            }
            String[] accountIds = new String[accountIdList.size()];
            boolean[] flags = new boolean[accountIdList.size()];
            for (int i = 0; i < accountIdList.size(); ++i) {
                accountIds[i] = accountIdList.get(i).toString();
                flags[i] = true;
            }
            GLFlagProcessFactory.getGLFlagProcessInstance().setAstInitClosed(ctx, accountIds, flags, currentCompanyID);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void setCompanyAccountTable(Context ctx, CompanyOrgUnitInfo company, AccountTableInfo accountTable) throws EASBizException, BOSException {
        if (company == null || accountTable == null) {
            return;
        }
        if (company.getAccountTable() == null) {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()));
        }
        if (company.getAccountTable() == null) {
            NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx).updateAccountTableInCompany(company.getId().toString(), accountTable.getId().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String verifyAndReference(Context ctx, Account_ControlCollection acctCtrlCols, AccountViewCollection accountCols) throws BOSException, EASBizException {
        LowTimer low = new LowTimer();
        low.reset();
        String sqlToGetAllUpper = "SELECT DISTINCT FUPPERID,FID,FNUMBER,FGLevel,FIsUpperAllowCA,FControlLevel FROM T_BD_ACCOUNTVIEW WHERE FCompanyID=? and FACCOUNTTABLEID=? AND FISCFREEZE =0 and FUPPERID IS NOT NULL ORDER BY FNUMBER";
        ArrayList<AccountViewInfo> accountForInsert = new ArrayList<AccountViewInfo>();
        HashSet accountForDelete = new HashSet();
        ArrayList<AccountViewInfo> accountForUpdate = new ArrayList<AccountViewInfo>();
        ArrayList<String> acctIdList = new ArrayList<String>();
        ArrayList<String> upperIdList = new ArrayList<String>();
        ArrayList<String> inferiorIdList = new ArrayList<String>();
        AccountViewCollection acctForDeleteCon = null;
        Hashtable<String, Integer> upperGLevel = new Hashtable<String, Integer>();
        Hashtable<String, Boolean> upperIsUpperAllowCA = new Hashtable<String, Boolean>();
        Hashtable<String, Integer> upperControlLevel = new Hashtable<String, Integer>();
        StringBuilder sb = new StringBuilder();
        int acctCtrlCount = acctCtrlCols.size();
        for (int i = 0; i < acctCtrlCount; ++i) {
            String accountNumber;
            Account_ControlInfo acctCtrlInfo;
            accountForInsert.clear();
            accountForDelete.clear();
            accountForUpdate.clear();
            acctIdList.clear();
            upperIdList.clear();
            inferiorIdList.clear();
            try {
                int j;
                acctCtrlInfo = acctCtrlCols.get(i);
                CompanyOrgUnitInfo destCompany = acctCtrlInfo.getDestCompany();
                AccountTableInfo acctTable = acctCtrlInfo.getAccountTableID();
                IRowSet rsToGetAllUpper = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetAllUpper, (Object[])new Object[]{destCompany.getId().toString(), acctTable.getId().toString()});
                while (rsToGetAllUpper.next()) {
                    upperIdList.add(rsToGetAllUpper.getString("FUPPERID"));
                    inferiorIdList.add(rsToGetAllUpper.getString("FID"));
                    upperGLevel.put(rsToGetAllUpper.getString("FUPPERID"), new Integer(rsToGetAllUpper.getInt("FGLevel")));
                    upperIsUpperAllowCA.put(rsToGetAllUpper.getString("FUPPERID"), new Boolean(rsToGetAllUpper.getBoolean("FIsUpperAllowCA")));
                    upperControlLevel.put(rsToGetAllUpper.getString("FUPPERID"), new Integer(rsToGetAllUpper.getInt("FControlLevel")));
                }
                int acctCount = accountCols.size();
                for (j = 0; j < acctCount; ++j) {
                    AccountViewInfo acctInfo = accountCols.get(j);
                    acctInfo.getId().toString();
                    if (upperIdList.contains(acctInfo.getId().toString())) {
                        int intGlevel = (Integer)upperGLevel.get(acctInfo.getId().toString());
                        boolean bIsUpperAllowCA = (Boolean)upperIsUpperAllowCA.get(acctInfo.getId().toString());
                        int intControlLevel = (Integer)upperControlLevel.get(acctInfo.getId().toString());
                        if (intGlevel != acctInfo.getGLevel() || bIsUpperAllowCA != acctInfo.isIsUpperAllowCA() || intControlLevel < acctInfo.getGLevel()) {
                            accountForUpdate.add(acctInfo);
                        }
                    } else {
                        String sql = "select 1 from t_bd_accountview where fupperid='" + acctInfo.getId().toString() + "' and FCompanyID='" + destCompany.getId().toString() + "'";
                        IRowSet row = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql);
                        if (!row.next()) {
                            accountForInsert.add(acctInfo);
                        }
                    }
                    acctIdList.add(acctInfo.getId().toString());
                }
                int upperCount = upperIdList.size();
                for (j = 0; j < upperCount; ++j) {
                    if (acctIdList.contains((String)upperIdList.get(j))) continue;
                    accountForDelete.add(inferiorIdList.get(j));
                }
                logger.debug((Object)("sqlToGetAllUpper  is:  " + low.msValue()));
                low.reset();
                if (accountForDelete.size() > 0) {
                    EntityViewInfo evi = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctCtrlInfo.getAccountTableID().getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)acctCtrlInfo.getDestCompany().getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("id", accountForDelete, CompareType.INCLUDE));
                    evi.setFilter(filter);
                    SorterItemCollection coll = new SorterItemCollection();
                    SorterItemInfo sorterInfo = new SorterItemInfo("number");
                    coll.add(sorterInfo);
                    evi.setSorter(coll);
                    acctForDeleteCon = this.getAccountsByDAO(ctx, evi);
                    int count = acctForDeleteCon.size();
                    for (int k = 0; k < count; ++k) {
                        AccountViewInfo info = acctForDeleteCon.get(k);
                        if (info.getUpper().isIsCFreeze()) continue;
                        accountForDelete.add(info);
                    }
                }
                if (acctForDeleteCon != null) {
                    AccountViewInfo info;
                    int j2;
                    ArrayList<String> canNotDelete = new ArrayList<String>();
                    AccountViewCollection acctForDeleteConFilter = new AccountViewCollection();
                    for (j2 = 0; j2 < acctForDeleteCon.size(); ++j2) {
                        info = acctForDeleteCon.get(j2);
                        try {
                            this.verify(ctx, info, acctForDeleteCon, acctCtrlInfo.getDestCompany(), acctCtrlInfo.getAccountTableID(), false);
                            acctForDeleteConFilter.add(info);
                            continue;
                        }
                        catch (EASBizException e) {
                            sb.append(info.getNumber() + ":" + e.getMessage()).append("\n");
                            canNotDelete.add(info.getNumber());
                        }
                    }
                    acctForDeleteCon = new AccountViewCollection();
                    for (j2 = 0; j2 < acctForDeleteConFilter.size(); ++j2) {
                        info = acctForDeleteConFilter.get(j2);
                        if (info.isIsLeaf()) {
                            acctForDeleteCon.add(info);
                            continue;
                        }
                        boolean canDelete = true;
                        for (String number : canNotDelete) {
                            if (number.indexOf(info.getNumber()) <= -1) continue;
                            canDelete = false;
                            break;
                        }
                        if (canDelete) {
                            for (int idx = 0; idx < accountCols.size(); ++idx) {
                                AccountViewInfo tmp = accountCols.get(idx);
                                if (tmp.getNumber().indexOf(info.getNumber()) <= -1) continue;
                                canDelete = false;
                                break;
                            }
                        }
                        if (canDelete) {
                            acctForDeleteCon.add(info);
                            continue;
                        }
                        sb.append(info.getNumber() + ":" + ResourceBase.getString((String)RESOURCE, (String)"CHILD_EXISTS", (Locale)ctx.getLocale())).append("\n");
                    }
                }
                logger.debug((Object)("verify  is:  " + low.msValue()));
                low.reset();
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            this.assignAcctCtrl(ctx, acctCtrlInfo);
            logger.debug((Object)("assignAcctCtrl  is:  " + low.msValue()));
            low.reset();
            Set assignedAccountNumberSet = new HashSet();
            assignedAccountNumberSet = this.getAssignedAccountNumberSet(ctx, acctCtrlInfo, accountCols);
            if (accountForInsert != null && accountForInsert.size() > 0) {
                this.setCompanyAccountTable(ctx, acctCtrlInfo.getDestCompany(), acctCtrlInfo.getAccountTableID());
            }
            AccountViewCollection acctColsForInsert = this.getAllInformationForAcct(ctx, accountForInsert);
            AccountRefContrastInfo curRef = AccountRefContrastFactory.getLocalInstance(ctx).getLastAcctInfo(acctCtrlInfo.getDestCompany().getId().toString(), acctCtrlInfo.getAccountTableID().getId().toString());
            if (curRef != null && curRef.isIsEnabled() && acctColsForInsert.size() > 0 && acctCtrlInfo.getAccountTableID() != null && !acctCtrlInfo.getAccountTableID().getId().toString().equals(curRef.getEnabledAcctTable().getId().toString())) {
                throw new AccountException(AccountException.ACCOUNTTABLEINENABLEDACCTREF, new Object[]{acctCtrlInfo.getDestCompany().getName(), acctCtrlInfo.getAccountTableID().getName()});
            }
            if (curRef != null && curRef.isIsEnabled() && accountForDelete.size() > 0 && !StringUtils.isEmpty((String)(accountNumber = this.accountInAcctRef(ctx, accountForDelete, curRef)))) {
                AccountException headException = new AccountException(AccountException.INFERIOR_ACCT_CANCEL_REF_FAIL, new Object[]{acctCtrlInfo.getDestCompany().getName()});
                throw new HeadDetailException(headException.getMessage(), accountNumber, 1);
            }
            AccountRefContrastInfo upperRef = AccountRefContrastFactory.getLocalInstance(ctx).getLastAcctInfo(acctCtrlInfo.getSrcCompany().getId().toString(), acctCtrlInfo.getAccountTableID().getId().toString());
            if (upperRef != null) {
                boolean isSameAcctTable = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).exists("where id='" + acctCtrlInfo.getDestCompany().getId().toString() + "' and accountTable.id = '" + upperRef.getDisabledAcctTable().getId().toString() + "'");
                curRef = AccountRefContrastFactory.getLocalInstance(ctx).getLastAcctInfo(acctCtrlInfo.getDestCompany().getId().toString(), acctCtrlInfo.getAccountTableID().getId().toString());
                if (curRef == null && isSameAcctTable && acctColsForInsert.size() > 0) {
                    curRef = (AccountRefContrastInfo)upperRef.clone();
                    curRef.setId(null);
                    curRef.setCompany(acctCtrlInfo.getDestCompany());
                    curRef.setEnabledPeriod(null);
                    curRef.setEnabledTime(null);
                    curRef.setIsEnabled(false);
                    curRef.setContrastTime(new Date());
                    curRef.getAcctRefContrastEntry().clear();
                    AccountRefContrastFactory.getLocalInstance(ctx).submit((CoreBaseInfo)curRef);
                }
            }
            AccountViewCollection acctColl = new AccountViewCollection();
            AccountCurrencyCollection acctCurrencyCols = new AccountCurrencyCollection();
            HashMap<String, AccountViewInfo> acctParentIdMap = new HashMap<String, AccountViewInfo>();
            int accountForInsertCount = acctColsForInsert.size();
            for (int j = 0; j < accountForInsertCount; ++j) {
                AccountViewInfo acctInfo = acctColsForInsert.get(j);
                String parentCompanyacctId = acctInfo.getId().toString();
                acctInfo.setId(BOSUuid.create((BOSObjectType)acctInfo.getBOSType()));
                acctParentIdMap.put(parentCompanyacctId, acctInfo);
                acctInfo.setCompanyID(acctCtrlInfo.getDestCompany());
                acctInfo.setCU(acctCtrlInfo.getDestCompany().getCU());
                AccountViewInfo upperInfo = new AccountViewInfo();
                upperInfo.setId(BOSUuid.read((String)parentCompanyacctId));
                acctInfo.setUpper(upperInfo);
                acctInfo.setGAA(acctInfo.getCAA());
                acctInfo.setControlLevel(acctInfo.getGLevel());
                acctInfo.setIsAllowCA(acctInfo.isIsUpperAllowCA());
                this.checkAssignAACM(ctx, acctInfo);
                AccountCurrencyCollection acctCuCols = acctInfo.getAccountCurrency();
                if (acctCuCols != null) {
                    int acctCuCount = acctCuCols.size();
                    for (int k = 0; k < acctCuCount; ++k) {
                        AccountCurrencyInfo acctCuInfo = acctCuCols.get(k);
                        acctCuInfo.setAccountView(acctInfo);
                        acctCuInfo.setId(null);
                    }
                }
                String parentId = null;
                boolean isLeaf = false;
                try {
                    if (acctInfo.getParent() != null) {
                        try {
                            AccountViewInfo parent = (AccountViewInfo)acctParentIdMap.get(acctInfo.getParent().getId().toString());
                            if (parent == null || assignedAccountNumberSet.contains(acctInfo.getNumber())) {
                                String sqlToGetInferiorParent = "SELECT TOP 1 FID,FIsCFreeze,FAcctCurrency, FCAA,FIsleaf,FNumber,FAccountTableID FROM T_BD_ACCOUNTVIEW WHERE FUPPERID=? AND FCompanyID=?";
                                IRowSet rsToGetInferiorParent = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetInferiorParent, (Object[])new Object[]{acctInfo.getParent().getId().toString(), acctCtrlInfo.getDestCompany().getId().toString()});
                                if (rsToGetInferiorParent != null && rsToGetInferiorParent.next()) {
                                    int acctCurrency = rsToGetInferiorParent.getInt("FAcctCurrency");
                                    if (acctCurrency == 1 && AccountingCurrencyEnum.ALLCURRENCY.equals((Object)acctInfo.getAccountingcurrency())) {
                                        throw new AccountException(AccountException.DCOMPANY_NOTALLCUR, new Object[]{acctCtrlInfo.getDestCompany().getName(), acctInfo.getNumber()});
                                    }
                                    parentId = rsToGetInferiorParent.getString("FID");
                                    isLeaf = rsToGetInferiorParent.getBoolean("FIsleaf");
                                    parent = new AccountViewInfo();
                                    if (!StringUtils.isEmpty((String)rsToGetInferiorParent.getString("Fcaa"))) {
                                        AsstAccountInfo asst = new AsstAccountInfo();
                                        asst.setId(BOSUuid.read((String)rsToGetInferiorParent.getString("Fcaa")));
                                        parent.setCAA(asst);
                                    }
                                    parent.setId(BOSUuid.read((String)parentId));
                                    parent.setIsCFreeze(rsToGetInferiorParent.getBoolean("FIsCFreeze"));
                                    parent.setIsLeaf(isLeaf);
                                    parent.put("isOld", "true");
                                    parent.setNumber(rsToGetInferiorParent.getString("FNumber"));
                                    SelectorItemCollection sic = new SelectorItemCollection();
                                    sic.add("id");
                                    String accountTableInfoid = rsToGetInferiorParent.getString("FAccountTableID");
                                    String companyId = acctCtrlInfo.getDestCompany().getId().toString();
                                    AccountTableInfo accountTableInfo = (AccountTableInfo)AccountTableFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(accountTableInfoid), sic);
                                    CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(companyId), sic);
                                    parent.setAccountTableID(accountTableInfo);
                                    parent.setCompanyID(companyOrgUnitInfo);
                                    acctParentIdMap.put(acctInfo.getParent().getId().toString(), parent);
                                } else {
                                    throw new AccountException(AccountException.CHILDCUMUSTEQUALPARENTCU, new Object[]{acctInfo.getNumber()});
                                }
                            }
                            if (this.exists(ctx, "where number = '" + parent.getNumber() + "' and accountTableID='" + parent.getAccountTableID().getId() + "' and companyID='" + parent.getCompanyID().getId() + "'")) {
                                SelectorItemCollection selector = new SelectorItemCollection();
                                selector.add(new SelectorItemInfo("id"));
                                selector.add(new SelectorItemInfo("isCFreeze"));
                                selector.add(new SelectorItemInfo("isLeaf"));
                                selector.add(new SelectorItemInfo("caa"));
                                String id = this.getValue(ctx, "where number = '" + parent.getNumber() + "' and accountTableID='" + parent.getAccountTableID().getId() + "' and companyID='" + parent.getCompanyID().getId() + "'").getId().toString();
                                parent = (AccountViewInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(id), selector);
                                parent.put("isOld", "true");
                            }
                            acctInfo.setParent(parent);
                            if (acctInfo.getCAA() == null && parent.getCAA() != null) {
                                acctInfo.setCAA(parent.getCAA());
                            }
                            if (parent.getCAA() != null) {
                                acctInfo.setParentAA(parent.getCAA());
                            }
                        }
                        catch (SQLException e) {
                            throw new BOSException((Throwable)e);
                        }
                        if (acctInfo.getParent().isIsCFreeze()) {
                            acctInfo.setIsParentFreeze(true);
                            acctInfo.setIsCFreeze(true);
                        }
                    }
                    if (assignedAccountNumberSet.contains(acctInfo.getNumber())) {
                        this._addnew(ctx, (IObjectValue)acctInfo);
                        continue;
                    }
                    if (acctInfo.getParent() != null && acctInfo.getParent().isIsLeaf() && acctInfo.getParent().get("isOld") != null) {
                        BOSUuid tempparentid = acctInfo.getParent().getId();
                        BOSUuid tempid = acctInfo.getId();
                        this._addnew(ctx, (IObjectValue)acctInfo);
                        acctInfo.getParent().setId(tempid);
                        acctInfo.getParent().setIsLeaf(false);
                        acctInfo.setId(tempparentid);
                        acctInfo.put("isOld", "true");
                        acctInfo.setIsLeaf(true);
                        continue;
                    }
                    try {
                        this.checkDupName(ctx, acctInfo);
                    }
                    catch (EASBizException e) {
                        throw new AccountException(AccountException.NAMEADUPLICATE_CAN_NOT_REFERENCE, new Object[]{acctInfo.getCompanyID().getName(), acctInfo.getName(), acctInfo.getNumber()});
                    }
                    acctColl.add(acctInfo);
                    acctCurrencyCols.addCollection(acctCuCols);
                    continue;
                }
                catch (AccountException e) {
                    if ("100".equals(e.getSubCode())) {
                        this.handleDupLongNumber(ctx, acctInfo, e, false);
                        continue;
                    }
                    throw e;
                }
            }
            ORMEngine.addnewVO((Context)ctx, (IObjectCollection)acctColl);
            ORMEngine.addnewVO((Context)ctx, (IObjectCollection)acctCurrencyCols);
            if (upperRef != null && curRef != null && curRef.getId() != null) {
                try {
                    this.util.copyRefEntry(ctx, upperRef, curRef, acctColsForInsert);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            logger.debug((Object)("addnew  is:  " + low.msValue()));
            low.reset();
            PreparedStatement stmt = null;
            Connection conn = null;
            String sqlToUpdate = "UPDATE T_BD_ACCOUNTVIEW SET FGLevel=?,FIsUpperAllowCA=?,FControlLevel=CASE WHEN FControlLevel<? THEN ? ELSE FControlLevel END WHERE FNUMBER LIKE ? AND FCompanyID=?";
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                stmt = conn.prepareStatement(sqlToUpdate);
                int accountForUpdateCount = accountForUpdate.size();
                for (int j = 0; j < accountForUpdateCount; ++j) {
                    AccountViewInfo acctInfo = (AccountViewInfo)accountForUpdate.get(j);
                    stmt.setInt(1, acctInfo.getGLevel());
                    stmt.setBoolean(2, acctInfo.isIsUpperAllowCA());
                    stmt.setInt(3, acctInfo.getGLevel());
                    stmt.setInt(4, acctInfo.getGLevel());
                    stmt.setString(5, acctInfo.getNumber() + "%");
                    stmt.setString(6, acctCtrlInfo.getDestCompany().getId().toString());
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            catch (SQLException e1) {
                try {
                    e1.printStackTrace();
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt, (Connection)conn);
                    throw throwable;
                }
                SQLUtils.cleanup((Statement)stmt, (Connection)conn);
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
            if (acctForDeleteCon != null && acctForDeleteCon.size() > 0) {
                this.batchCancleAssignAccount(ctx, acctCtrlInfo.getDestCompany(), acctCtrlInfo.getAccountTableID(), acctForDeleteCon);
                if (curRef != null && curRef.getId() != null) {
                    try {
                        this.util.delRefEntry(ctx, curRef, acctForDeleteCon);
                    }
                    catch (Exception e) {
                        throw new BOSException((Throwable)e);
                    }
                }
            }
            FilterInfo acctFilter = new FilterInfo();
            acctFilter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)acctCtrlInfo.getDestCompany().getId().toString()));
            acctFilter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)acctCtrlInfo.getAccountTableID().getId().toString()));
            if (accountForDelete != null && accountForDelete.size() > 0 && !this.exists(ctx, acctFilter)) {
                IAccount_Control acctCtrl = Account_ControlFactory.getLocalInstance(ctx);
                FilterInfo acctCtrlFilter = new FilterInfo();
                acctCtrlFilter.getFilterItems().add(new FilterItemInfo("destCompany.id", (Object)acctCtrlInfo.getDestCompany().getId().toString()));
                acctCtrlFilter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)acctCtrlInfo.getAccountTableID().getId().toString()));
                acctCtrl.delete(acctCtrlFilter);
                ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                CompanyOrgUnitInfo companyOrgUnitInfo = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(acctCtrlInfo.getDestCompany().getId()));
                if (companyOrgUnitInfo.getAccountTable() != null && acctCtrlInfo.getAccountTableID().getId().equals((Object)companyOrgUnitInfo.getAccountTable().getId())) {
                    NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx).updateAccountTableInCompany(companyOrgUnitInfo.getId().toString(), null);
                }
            }
            if (curRef == null || curRef.getId() == null) continue;
            AcctRefContrastHelper.delAllAcctRef(ctx, acctCtrlInfo.getDestCompany().getId().toString(), acctCtrlInfo.getAccountTableID().getId().toString(), curRef.getId().toString());
        }
        return sb.toString();
    }

    protected boolean checkIsCanAssign(Context ctx, Account_ControlInfo acctCtrlInfo, AccountViewInfo acctInfo) throws BOSException, SQLException {
        if (acctInfo.getCAA() == null) {
            return true;
        }
        CompanyOrgUnitInfo companyInfo = acctCtrlInfo.getDestCompany();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        String cuLongNumber = companyInfo.getCU().getLongNumber();
        String[] cuNumber = cuLongNumber.split("!");
        StringBuffer compareLongNumber = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cuNumber.length; ++i) {
            if (i > 0) {
                sb.append("!");
                compareLongNumber.append(",");
            }
            sb.append(cuNumber[i]);
            compareLongNumber.append(sb.toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.longNumber", (Object)compareLongNumber.toString(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("assignCU.longNumber", (Object)compareLongNumber.toString(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)acctInfo.getCAA().getId().toString()));
        filter.setMaskString("(#0 or #1) and #2");
        evi.setFilter(filter);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.basedata.master.auxacct.app.F7AsstAccountForRefQuery"));
        exec.setObjectView(evi);
        IRowSet rs = exec.executeQuery();
        return rs.next();
    }

    protected void assignAcctCtrl(Context ctx, Account_ControlInfo tmpAcctCtrlInfo) throws EASBizException, BOSException {
        IAccount_Control acctCtrl = Account_ControlFactory.getLocalInstance(ctx);
        if (tmpAcctCtrlInfo.getId() != null && acctCtrl.exists((IObjectPK)new ObjectUuidPK(tmpAcctCtrlInfo.getId()))) {
            Account_ControlCollection acctCtrlColl = AccountTools.getAcctCtrlCollection(ctx, tmpAcctCtrlInfo.getAccountTableID(), tmpAcctCtrlInfo.getDestCompany());
            boolean isChanged = false;
            for (int i = 0; i < acctCtrlColl.size(); ++i) {
                Account_ControlInfo acctCtrlInfo = acctCtrlColl.get(i);
                if (tmpAcctCtrlInfo.getAc() != acctCtrlInfo.getAc()) {
                    acctCtrlInfo.setAc(tmpAcctCtrlInfo.getAc());
                    isChanged = true;
                }
                if (tmpAcctCtrlInfo.getDc() != acctCtrlInfo.getDc()) {
                    acctCtrlInfo.setDc(tmpAcctCtrlInfo.getDc());
                    isChanged = true;
                }
                if (tmpAcctCtrlInfo.getIsChangeCurrency() != acctCtrlInfo.getIsChangeCurrency()) {
                    acctCtrlInfo.setIsChangeCurrency(tmpAcctCtrlInfo.getIsChangeCurrency());
                    isChanged = true;
                }
                if (tmpAcctCtrlInfo.getCurrencyID() != acctCtrlInfo.getCurrencyID()) {
                    acctCtrlInfo.setCurrencyID(tmpAcctCtrlInfo.getCurrencyID());
                    isChanged = true;
                }
                if (tmpAcctCtrlInfo.getIsQty() != acctCtrlInfo.getIsQty()) {
                    acctCtrlInfo.setIsQty(tmpAcctCtrlInfo.getIsQty());
                    isChanged = true;
                }
                if (tmpAcctCtrlInfo.getAcNotice() != acctCtrlInfo.getAcNotice()) {
                    acctCtrlInfo.setAcNotice(tmpAcctCtrlInfo.getAcNotice());
                    isChanged = true;
                }
                if (tmpAcctCtrlInfo.getControl() != acctCtrlInfo.getControl()) {
                    acctCtrlInfo.setControl(tmpAcctCtrlInfo.getControl());
                    isChanged = true;
                }
                if (tmpAcctCtrlInfo.getPlType() != acctCtrlInfo.getPlType()) {
                    acctCtrlInfo.setPlType(1);
                    isChanged = true;
                }
                if (!isChanged) continue;
                acctCtrl.update((IObjectPK)new ObjectUuidPK(acctCtrlInfo.getId()), (CoreBaseInfo)acctCtrlInfo);
                isChanged = false;
            }
        } else {
            tmpAcctCtrlInfo.setIsDefaultForRefer(false);
            acctCtrl.addnew((CoreBaseInfo)tmpAcctCtrlInfo);
            tmpAcctCtrlInfo.setId(null);
            tmpAcctCtrlInfo.setIsDefaultForRefer(true);
            acctCtrl.addnew((CoreBaseInfo)tmpAcctCtrlInfo);
        }
    }

    protected void verify(Context ctx, ArrayList accountForInsert, ArrayList accountForDelete, ArrayList accountForUpdate, CtrlUnitInfo currentCU) throws BOSException, EASBizException {
        AccountViewInfo acctForDelete = new AccountViewInfo();
        LowTimer low = new LowTimer();
        low.reset();
        String sqlToGetAcctInfo = "SELECT ACCT.FNUMBER AS ACCTNO, CU.FNUMBER AS CUNO FROM T_BD_ACCOUNTVIEW ACCT JOIN T_ORG_CTRLUNIT CU ON ACCT.FCONTROLUNITID = CU.FID where ACCT.FID = ?";
        int count = accountForDelete.size();
        for (int i = 0; i < count; ++i) {
            String inferiorId = (String)accountForDelete.get(i);
            acctForDelete.setId(BOSUuid.read((String)inferiorId));
            boolean refered = AccountTools.checkAccountHasReference(ctx, acctForDelete);
            if (!refered) continue;
            IRowSet rsToGetAcctInfo = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetAcctInfo, (Object[])new Object[]{inferiorId});
            String acctNumber = "";
            String cuNumber = "";
            try {
                if (rsToGetAcctInfo != null && rsToGetAcctInfo.next()) {
                    acctNumber = rsToGetAcctInfo.getString(1);
                    cuNumber = rsToGetAcctInfo.getString(2);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            throw new AccountException(AccountException.ACCOUNTHASREFERENCEWHENASSIGN, new Object[]{acctNumber, cuNumber});
        }
        System.out.println(ResourceBase.getString((String)"com.kingdee.eas.basedata.master.account.ACCOUNTAutoGenerateResource", (String)"75_AccountViewControllerBean", (Locale)ctx.getLocale()) + low.msValue());
    }

    protected void verify(Context ctx, ArrayList accountForInsert, ArrayList accountForDelete, ArrayList accountForUpdate, CompanyOrgUnitInfo currentCompany) throws BOSException, EASBizException {
        AccountViewInfo acctForDelete = new AccountViewInfo();
        LowTimer low = new LowTimer();
        low.reset();
        String sqlToGetAcctInfo = "SELECT ACCT.FNUMBER AS ACCTNO, COMPANY.FNUMBER AS COMPANYNO FROM T_BD_ACCOUNTVIEW ACCT JOIN T_ORG_Company COMPANY ON ACCT.FCompanyID = COMPANY.FID where ACCT.FID = ?";
        int count = accountForDelete.size();
        for (int i = 0; i < count; ++i) {
            String inferiorId = (String)accountForDelete.get(i);
            acctForDelete.setId(BOSUuid.read((String)inferiorId));
            boolean refered = AccountTools.checkAccountHasReference(ctx, acctForDelete);
            if (!refered) continue;
            IRowSet rsToGetAcctInfo = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetAcctInfo, (Object[])new Object[]{inferiorId});
            String acctNumber = "";
            String companyNumber = "";
            try {
                if (rsToGetAcctInfo != null && rsToGetAcctInfo.next()) {
                    acctNumber = rsToGetAcctInfo.getString(1);
                    companyNumber = rsToGetAcctInfo.getString(2);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            throw new AccountException(AccountException.ACCOUNTHASREFERENCEWHENASSIGN, new Object[]{acctNumber, companyNumber});
        }
        System.out.println(ResourceBase.getString((String)"com.kingdee.eas.basedata.master.account.ACCOUNTAutoGenerateResource", (String)"75_AccountViewControllerBean", (Locale)ctx.getLocale()) + low.msValue());
    }

    protected void verify(Context ctx, ArrayList accountForDelete, CtrlUnitInfo currentCU) throws BOSException, EASBizException {
        AccountViewInfo acctForDelete = new AccountViewInfo();
        LowTimer low = new LowTimer();
        low.reset();
        int count = accountForDelete.size();
        for (int i = 0; i < count; ++i) {
            acctForDelete = (AccountViewInfo)accountForDelete.get(i);
            boolean refered = this._isHasDeal(ctx, (IObjectPK)new ObjectUuidPK(acctForDelete.getId()), false);
            if (!refered) continue;
            throw new AccountException(AccountException.ACCOUNTHASREFERENCEWHENASSIGN, new Object[]{acctForDelete.getNumber(), currentCU.getNumber()});
        }
        System.out.println(ResourceBase.getString((String)"com.kingdee.eas.basedata.master.account.ACCOUNTAutoGenerateResource", (String)"75_AccountViewControllerBean", (Locale)ctx.getLocale()) + low.msValue());
    }

    protected void verify(Context ctx, AccountViewCollection acctForDeleteCon, CompanyOrgUnitInfo currentCompany, AccountTableInfo accountTable, boolean isAssigned) throws BOSException, EASBizException {
        if (acctForDeleteCon == null || acctForDeleteCon.size() == 0 || currentCompany == null || accountTable == null) {
            return;
        }
        try {
            StringBuffer idSet = new StringBuffer();
            int count = acctForDeleteCon.size();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    idSet.append(",");
                }
                idSet.append("'").append(acctForDeleteCon.get(i).getId().toString()).append("'");
            }
            String sqlToGetRefByAccount = "SELECT TOP 1 fid FROM T_BD_ACCOUNTVIEW WHERE FUPPERID in (" + idSet.toString() + ") and faccounttableid=? order by fnumber";
            IRowSet rsToGetRefByAccount = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetRefByAccount, (Object[])new Object[]{accountTable.getId().toString()});
            if (rsToGetRefByAccount != null && rsToGetRefByAccount.next()) {
                String acctid = rsToGetRefByAccount.getString("fid");
                String sqlToGetAcctInfo = "SELECT ACCT.FNUMBER AS acctno, COMPANY.FNUMBER as companyno FROM T_BD_ACCOUNTVIEW ACCT JOIN T_ORG_Company COMPANY ON ACCT.FCompanyID = COMPANY.FID AND ACCT.FID = ?";
                IRowSet rsToGetAcctInfo = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetAcctInfo, (Object[])new Object[]{acctid});
                String acctNumber = "";
                String companyNumber = "";
                try {
                    if (rsToGetAcctInfo != null && rsToGetAcctInfo.next()) {
                        acctNumber = rsToGetAcctInfo.getString("acctno");
                        companyNumber = rsToGetAcctInfo.getString("companyno");
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (isAssigned) {
                    throw new AccountException(AccountException.ACCOUNT_ASSIGNED, new Object[]{acctNumber, companyNumber});
                }
                throw new AccountException(AccountException.ACCOUNT_REFERED, new Object[]{acctNumber, companyNumber});
            }
            sqlToGetRefByAccount = "SELECT TOP 1 fid FROM T_BD_ACCOUNTVIEW WHERE FParentID in (" + idSet.toString() + ") and fid not in (" + idSet.toString() + ") and faccounttableid=? order by fnumber";
            rsToGetRefByAccount = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetRefByAccount, (Object[])new Object[]{accountTable.getId().toString()});
            if (rsToGetRefByAccount != null && rsToGetRefByAccount.next()) {
                String acctid = rsToGetRefByAccount.getString("fid");
                String sqlToGetAcctInfo = "SELECT parentAccount.fnumber as parentnumber, ACCT.FNUMBER AS acctno, COMPANY.FNUMBER as companyno FROM T_BD_ACCOUNTVIEW ACCT left outer JOIN T_ORG_Company COMPANY ON ACCT.FCompanyID = COMPANY.FID left outer join T_BD_ACCOUNTVIEW parentAccount on ACCT.fparentid = parentAccount.fid where ACCT.FID = ?";
                IRowSet rsToGetAcctInfo = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetAcctInfo, (Object[])new Object[]{acctid});
                String parentAcctNumber = "";
                String acctNumber = "";
                String companyNumber = "";
                try {
                    if (rsToGetAcctInfo != null && rsToGetAcctInfo.next()) {
                        parentAcctNumber = rsToGetAcctInfo.getString("parentnumber");
                        acctNumber = rsToGetAcctInfo.getString("acctno");
                        companyNumber = rsToGetAcctInfo.getString("companyno");
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (isAssigned) {
                    throw new AccountException(AccountException.ACCOUNT_HAS_CHILD, new Object[]{companyNumber, parentAcctNumber, acctNumber});
                }
                throw new AccountException(AccountException.ACCOUNT_REFERED_HAS_CHILD, new Object[]{companyNumber, parentAcctNumber, acctNumber});
            }
            if (!currentCompany.isIsBizUnit()) {
                return;
            }
            BizCheckResult checkResult = this.checkIsAccountHasDeal(ctx, acctForDeleteCon, currentCompany.getId(), accountTable.getId());
            if (checkResult.isFound()) {
                String accountID;
                if (checkResult.getException() != null) {
                    checkResult.getException().printStackTrace();
                }
                if ((accountID = (String)checkResult.getDetailObject((Object)"FAccountID")) != null && accountID.trim().length() > 0) {
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add("id");
                    selector.add("number");
                    selector.add("companyid.number");
                    AccountViewInfo accountViewInfo = this.getAccountViewInfo(ctx, (IObjectPK)new ObjectUuidPK(accountID), selector);
                    if (checkResult.getException() == null) {
                        if (isAssigned) {
                            throw new AccountException(AccountException.DISASSIGN_ACCOUNT_HAS_DAEL_DETAIL, new Object[]{accountViewInfo.getNumber(), accountViewInfo.getCompanyID().getNumber(), ""});
                        }
                        throw new AccountException(AccountException.DISREFERED_ACCOUNT_HAS_DAEL_DETAIL, new Object[]{accountViewInfo.getNumber(), accountViewInfo.getCompanyID().getNumber(), ""});
                    }
                    if (isAssigned) {
                        throw new AccountException(AccountException.DISASSIGN_ACCOUNT_HAS_DAEL_DETAIL, new Object[]{accountViewInfo.getNumber(), accountViewInfo.getCompanyID().getNumber(), checkResult.getException().getMessage()});
                    }
                    throw new AccountException(AccountException.DISREFERED_ACCOUNT_HAS_DAEL_DETAIL, new Object[]{accountViewInfo.getNumber(), accountViewInfo.getCompanyID().getNumber(), checkResult.getException().getMessage()});
                }
                throw new AccountException(AccountException.DISASSIGN_ACCOUNT_HAS_DAEL);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected String verifyNew(Context ctx, AccountViewCollection acctForDeleteCon, CompanyOrgUnitInfo currentCompany, AccountTableInfo accountTable, boolean isAssigned) throws BOSException, EASBizException {
        if (acctForDeleteCon == null || acctForDeleteCon.size() == 0 || currentCompany == null || accountTable == null) {
            return null;
        }
        StringBuilder errorMsg = new StringBuilder();
        try {
            StringBuffer idSet = new StringBuffer();
            int count = acctForDeleteCon.size();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    idSet.append(",");
                }
                idSet.append("'").append(acctForDeleteCon.get(i).getId().toString()).append("'");
            }
            String sqlToGetRefByAccount = "SELECT ACCT.FNUMBER as accNumber,COMPANY.FNUMBER as comNumber FROM T_BD_ACCOUNTVIEW ACCT JOIN T_ORG_Company COMPANY  ON ACCT.FCompanyID = COMPANY.FID WHERE ACCT.FUPPERID in (" + idSet.toString() + ") and ACCT.faccounttableid=? order by ACCT.fnumber";
            IRowSet rsToGetRefByAccount = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetRefByAccount, (Object[])new Object[]{accountTable.getId().toString()});
            while (rsToGetRefByAccount.next()) {
                String acctNumber = rsToGetRefByAccount.getString("accNumber");
                String companyNumber = rsToGetRefByAccount.getString("comNumber");
                AccountException ex = new AccountException(AccountException.ACCOUNT_ASSIGNED, new Object[]{acctNumber, companyNumber});
                String message = ex.getMessage();
                errorMsg.append(message + "\n");
            }
            String sqlToGetAcctInfo = "SELECT parentAccount.fnumber as parentnumber, ACCT.FNUMBER AS acctno, COMPANY.FNUMBER as companyno FROM T_BD_ACCOUNTVIEW ACCT left outer JOIN T_ORG_Company COMPANY ON ACCT.FCompanyID = COMPANY.FID left outer join T_BD_ACCOUNTVIEW parentAccount on ACCT.fparentid = parentAccount.fid where ACCT.FParentID in (" + idSet.toString() + ") and ACCT.fid not in (" + idSet.toString() + ") and ACCT.faccounttableid=? order by ACCT.fnumber";
            IRowSet rsToGetAcctInfo = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetAcctInfo, (Object[])new Object[]{accountTable.getId().toString()});
            String parentAcctNumber = "";
            String acctNumber = "";
            String companyNumber = "";
            try {
                while (rsToGetAcctInfo.next()) {
                    parentAcctNumber = rsToGetAcctInfo.getString("parentnumber");
                    acctNumber = rsToGetAcctInfo.getString("acctno");
                    companyNumber = rsToGetAcctInfo.getString("companyno");
                    AccountException ex = new AccountException(AccountException.ACCOUNT_HAS_CHILD, new Object[]{companyNumber, parentAcctNumber, acctNumber});
                    String message = ex.getMessage();
                    errorMsg.append(message + "\n");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (!currentCompany.isIsBizUnit()) {
                return errorMsg.length() < 1 ? null : errorMsg.toString();
            }
            BizCheckResult checkResult = this.checkIsAccountHasDeal(ctx, acctForDeleteCon, currentCompany.getId(), accountTable.getId());
            if (checkResult.isFound()) {
                if (checkResult.getException() != null) {
                    checkResult.getException().printStackTrace();
                }
                String accountID = (String)checkResult.getDetailObject((Object)"FAccountID");
                AccountException ex = null;
                if (accountID != null && accountID.trim().length() > 0) {
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add("id");
                    selector.add("number");
                    selector.add("companyid.number");
                    AccountViewInfo accountViewInfo = this.getAccountViewInfo(ctx, (IObjectPK)new ObjectUuidPK(accountID), selector);
                    ex = checkResult.getException() == null ? new AccountException(AccountException.DISASSIGN_ACCOUNT_HAS_DAEL_DETAIL, new Object[]{accountViewInfo.getNumber(), accountViewInfo.getCompanyID().getNumber(), ""}) : new AccountException(AccountException.DISASSIGN_ACCOUNT_HAS_DAEL_DETAIL, new Object[]{accountViewInfo.getNumber(), accountViewInfo.getCompanyID().getNumber(), checkResult.getException().getMessage()});
                } else {
                    ex = new AccountException(AccountException.DISASSIGN_ACCOUNT_HAS_DAEL);
                }
                errorMsg.append(ex.getMessage() + "\n");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return errorMsg.length() < 1 ? null : errorMsg.toString();
    }

    protected void verify(Context ctx, ArrayList accountForDelete, CompanyOrgUnitInfo currentCompany) throws BOSException, EASBizException {
        AccountViewInfo acctForDelete = new AccountViewInfo();
        LowTimer low = new LowTimer();
        low.reset();
        int count = accountForDelete.size();
        for (int i = 0; i < count; ++i) {
            acctForDelete = (AccountViewInfo)accountForDelete.get(i);
            boolean refered = this._isHasDeal(ctx, (IObjectPK)new ObjectUuidPK(acctForDelete.getId()), false);
            if (!refered) continue;
            throw new AccountException(AccountException.ACCOUNTHASREFERENCEWHENASSIGN, new Object[]{acctForDelete.getNumber(), currentCompany.getNumber()});
        }
    }

    protected void _referUpperAccount(Context ctx, CtrlUnitInfo currentCu, CtrlUnitInfo parentCu, IObjectValue acctTbl, IObjectCollection acctCols) throws BOSException, EASBizException {
        Account_ControlCollection acctCtrlCols = new Account_ControlCollection();
        Account_ControlInfo parentAcctCtrlInfo = AccountTools.getAcctCtrlInfo(ctx, (AccountTableInfo)acctTbl, parentCu, true);
        parentAcctCtrlInfo.setSrcCu(parentCu);
        parentAcctCtrlInfo.setDestCu(currentCu);
        parentAcctCtrlInfo.setIsDefaultForRefer(false);
        Account_ControlInfo childAcctCtrlInfo = AccountTools.getAcctCtrlInfo(ctx, (AccountTableInfo)acctTbl, currentCu, false);
        if (childAcctCtrlInfo != null && childAcctCtrlInfo.getId() != null && childAcctCtrlInfo.getId().toString().length() > 0) {
            parentAcctCtrlInfo.setId(childAcctCtrlInfo.getId());
        } else {
            parentAcctCtrlInfo.setId(null);
        }
        acctCtrlCols.add(parentAcctCtrlInfo);
        AccountViewCollection acctViewCols = this.getAllInformationForAcct(ctx, acctCols);
        this.verifyAndReference(ctx, acctCtrlCols, acctViewCols);
    }

    @Override
    protected String _referUpperAccount(Context ctx, IObjectValue currentCompany, IObjectValue parentCompany, IObjectValue acctTbl, IObjectCollection acctCols) throws BOSException, EASBizException {
        Account_ControlCollection acctCtrlCols = new Account_ControlCollection();
        Account_ControlInfo parentAcctCtrlInfo = AccountTools.getAcctCtrlInfo(ctx, (AccountTableInfo)acctTbl, (CompanyOrgUnitInfo)parentCompany, true);
        parentAcctCtrlInfo.setSrcCompany((CompanyOrgUnitInfo)parentCompany);
        parentAcctCtrlInfo.setDestCompany((CompanyOrgUnitInfo)currentCompany);
        parentAcctCtrlInfo.setIsDefaultForRefer(false);
        Account_ControlInfo childAcctCtrlInfo = AccountTools.getAcctCtrlInfo(ctx, (AccountTableInfo)acctTbl, (CompanyOrgUnitInfo)currentCompany, false);
        if (childAcctCtrlInfo != null && childAcctCtrlInfo.getId() != null && childAcctCtrlInfo.getId().toString().length() > 0) {
            parentAcctCtrlInfo.setId(childAcctCtrlInfo.getId());
        } else {
            parentAcctCtrlInfo.setId(null);
        }
        acctCtrlCols.add(parentAcctCtrlInfo);
        AccountViewCollection acctViewCols = this.getAllInformationForAcct(ctx, acctCols);
        return this.verifyAndReference(ctx, acctCtrlCols, acctViewCols);
    }

    @Override
    protected void _updateAcctounProperties(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AccountViewInfo oldacctInfo = (AccountViewInfo)this._getValue(ctx, pk);
        AccountViewInfo acctInfo = (AccountViewInfo)model;
        this.checkAACM(ctx, acctInfo, oldacctInfo, false);
        this.checkCompanyAuxAccount(ctx, acctInfo);
        String sql = new String();
        ArrayList<Object> obj = new ArrayList<Object>();
        if (acctInfo.getCAA() != null) {
            obj.add(((AccountViewInfo)model).getCAA().getId().toString());
            sql = "update T_BD_ACCOUNTVIEW SET FCAA=?, FAC = ?,FACNotice = ? where FID=?";
            obj.add(acctInfo.isAC());
            obj.add(acctInfo.isACNotice());
            obj.add(acctInfo.getId().toString());
            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])obj.toArray());
        } else {
            sql = "update T_BD_ACCOUNTVIEW SET FCAA=null, FAC = 0 ,FACNotice =0 where FID=?";
            obj.add(acctInfo.getId().toString());
            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])obj.toArray());
        }
        if (acctInfo.getCAA() != null) {
            String caaId = acctInfo.getCAA().getId().toString();
            String sqlToSynchronizeChildAA = "UPDATE T_BD_ACCOUNTVIEW SET FParentAAID=CASE WHEN FParentAAID IS NULL THEN '" + caaId + "' ELSE FParentAAID END,FCAA=CASE WHEN FCAA IS NULL THEN '" + caaId + "' ELSE FCAA END";
            if (acctInfo.isAC()) {
                sqlToSynchronizeChildAA = sqlToSynchronizeChildAA + " ,FAC = 1";
            }
            sqlToSynchronizeChildAA = sqlToSynchronizeChildAA + " WHERE FACCOUNTTABLEID = ? AND FCompanyID = ? AND FLONGNUMBER LIKE ?";
            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sqlToSynchronizeChildAA, (Object[])new Object[]{oldacctInfo.getAccountTableID().getId().toString(), oldacctInfo.getCompanyID().getId().toString(), acctInfo.getLongNumber() + "!%"});
            String sqlToSynchronizeParentAA = "UPDATE T_BD_ACCOUNTVIEW SET FPARENTAAID = ? WHERE FPARENTID = ?";
            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sqlToSynchronizeParentAA, (Object[])new Object[]{acctInfo.getCAA().getId().toString(), acctInfo.getId().toString()});
        } else {
            String sqlToSynchronizeParentAA = "UPDATE T_BD_ACCOUNTVIEW SET FPARENTAAID = NULL";
            if (acctInfo.isAC()) {
                sqlToSynchronizeParentAA = sqlToSynchronizeParentAA + " ,FAC = 1";
            }
            if (acctInfo.isACNotice()) {
                sqlToSynchronizeParentAA = sqlToSynchronizeParentAA + " ,FACNotice = 1";
            }
            sqlToSynchronizeParentAA = sqlToSynchronizeParentAA + " WHERE FPARENTID = ?";
            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sqlToSynchronizeParentAA, (Object[])new Object[]{acctInfo.getId().toString()});
        }
        this.synchronizeInferiorAA(ctx, acctInfo);
    }

    protected void synchronizeInferiorAA(Context ctx, AccountViewInfo acctInfo) throws BOSException {
        String sqlToGetInferior = "SELECT FID, FLONGNUMBER, FCONTROLUNITID,FCompanyID, FCAA FROM T_BD_ACCOUNTVIEW WHERE FUPPERID = ?";
        IRowSet rsToGetInferior = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetInferior, (Object[])new Object[]{acctInfo.getId().toString()});
        if (rsToGetInferior != null) {
            try {
                while (rsToGetInferior.next()) {
                    String inferiorId = rsToGetInferior.getString("FID");
                    String inferiorLongNumber = rsToGetInferior.getString("FLONGNUMBER");
                    String inferiorCompanyId = rsToGetInferior.getString("FCompanyID");
                    String inferiorCaaId = rsToGetInferior.getString("FCAA");
                    String sqlToCheckIsAcControl = "SELECT TOP 1 FAC FROM T_BD_Acct_Contorl WHERE FACCOUNTTABLEID = ? AND FDestCompanyID = ? AND FIsDefaultForRefer = ?";
                    IRowSet rsToCheckIsAcControl = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToCheckIsAcControl, (Object[])new Object[]{acctInfo.getAccountTableID().getId().toString(), inferiorCompanyId, false});
                    boolean isAcControl = false;
                    if (rsToCheckIsAcControl != null && rsToCheckIsAcControl.next()) {
                        isAcControl = rsToCheckIsAcControl.getBoolean("FAC");
                    }
                    if (acctInfo.getCAA() != null) {
                        String caaId = acctInfo.getCAA().getId().toString();
                        String sqlToSynchronize = "UPDATE T_BD_ACCOUNTVIEW SET FGAA= ?, FCAA=CASE WHEN FCAA IS NULL THEN '" + caaId + "' ELSE FCAA END ";
                        if (isAcControl && acctInfo.isAC()) {
                            sqlToSynchronize = sqlToSynchronize + ",FAC = 1";
                        }
                        sqlToSynchronize = sqlToSynchronize + "WHERE FID = ?";
                        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sqlToSynchronize, (Object[])new Object[]{acctInfo.getCAA().getId().toString(), inferiorId});
                        String sqlToSynchronizeChild = "UPDATE T_BD_ACCOUNTVIEW SET FParentAAID=CASE WHEN FPARENTAAID IS NULL THEN '" + caaId + "' ELSE FPARENTAAID END, FCAA = CASE WHEN FCAA IS NULL THEN '" + caaId + "' ELSE FCAA END, FGAA=CASE WHEN FGAA IS NULL AND FUPPERID IS NOT NULL THEN '" + caaId + "' ELSE FGAA END";
                        if (isAcControl && acctInfo.isAC()) {
                            sqlToSynchronizeChild = sqlToSynchronizeChild + ",FAC = 1";
                        }
                        sqlToSynchronizeChild = sqlToSynchronizeChild + " WHERE FACCOUNTTABLEID = ? AND FCompanyID = ? AND FLONGNUMBER LIKE ?";
                        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sqlToSynchronizeChild, (Object[])new Object[]{acctInfo.getAccountTableID().getId().toString(), inferiorCompanyId, inferiorLongNumber + "!%"});
                        AccountViewInfo inferiorInfo = (AccountViewInfo)acctInfo.clone();
                        inferiorInfo.setId(BOSUuid.read((String)inferiorId));
                        if (inferiorCaaId != null && inferiorCaaId.length() > 0) {
                            AsstAccountInfo inferiorCaaInfo = new AsstAccountInfo();
                            inferiorCaaInfo.setId(BOSUuid.read((String)inferiorCaaId));
                            inferiorInfo.setCAA(inferiorCaaInfo);
                        }
                        this.synchronizeInferiorAA(ctx, inferiorInfo);
                        continue;
                    }
                    String sqlToSynchronize = "UPDATE T_BD_ACCOUNTVIEW SET FGAA = NULL ";
                    if (isAcControl && acctInfo.isAC()) {
                        sqlToSynchronize = sqlToSynchronize + ",FAC = 1";
                    }
                    sqlToSynchronize = sqlToSynchronize + "WHERE FID = ?";
                    com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sqlToSynchronize, (Object[])new Object[]{inferiorId});
                    if (!isAcControl || !acctInfo.isAC()) continue;
                    String sqlToSynchronizeChild = "UPDATE T_BD_ACCOUNTVIEW SET FAC = 1  WHERE FACCOUNTTABLEID = ? AND FCompanyID = ? AND FLONGNUMBER LIKE ?";
                    com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sqlToSynchronizeChild, (Object[])new Object[]{acctInfo.getAccountTableID().getId().toString(), inferiorCompanyId, inferiorLongNumber + "!%"});
                    AccountViewInfo inferiorInfo = (AccountViewInfo)acctInfo.clone();
                    inferiorInfo.setId(BOSUuid.read((String)inferiorId));
                    if (inferiorCaaId != null && inferiorCaaId.length() > 0) {
                        AsstAccountInfo inferiorCaaInfo = new AsstAccountInfo();
                        inferiorCaaInfo.setId(BOSUuid.read((String)inferiorCaaId));
                        inferiorInfo.setCAA(inferiorCaaInfo);
                    }
                    this.synchronizeInferiorAA(ctx, inferiorInfo);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected IObjectCollection _getAllUpperAcctIdByCuAndTbl(Context ctx, IObjectValue ctrlunitinfo, IObjectValue accounttable) throws BOSException {
        AccountViewCollection acctCols = new AccountViewCollection();
        ArrayList<String> obj = new ArrayList<String>();
        CtrlUnitInfo unitinfo = (CtrlUnitInfo)ctrlunitinfo;
        AccountTableInfo tableinf = (AccountTableInfo)accounttable;
        if (ctrlunitinfo != null && accounttable != null) {
            try {
                String sql = "select fupperid,fisUpperAllowCA,fgLevel  from t_bd_accountview where Fcontrolunitid=?  and  FaccountTableID=? and FUpperID is not null";
                obj.add(unitinfo.getId().toString());
                obj.add(tableinf.getId().toString());
                IRowSet irow = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])obj.toArray());
                while (irow.next()) {
                    AccountViewInfo acctInfo = new AccountViewInfo();
                    AccountViewInfo upperInfo = new AccountViewInfo();
                    upperInfo.setId(BOSUuid.read((String)irow.getString("fupperid")));
                    acctInfo.setUpper(upperInfo);
                    acctInfo.setIsUpperAllowCA(irow.getBoolean("fisupperAllowCA"));
                    acctInfo.setGLevel(irow.getInt("fGLevel"));
                    acctCols.add(acctInfo);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return acctCols;
    }

    @Override
    protected IObjectCollection _getAllUpperAcctIdByCompanyAndTbl(Context ctx, IObjectValue companyInfo, IObjectValue accountTable) throws BOSException {
        AccountViewCollection acctCols = new AccountViewCollection();
        ArrayList<String> obj = new ArrayList<String>();
        CompanyOrgUnitInfo unitInfo = (CompanyOrgUnitInfo)companyInfo;
        AccountTableInfo tableInfo = (AccountTableInfo)accountTable;
        if (unitInfo == null || tableInfo == null) {
            return acctCols;
        }
        try {
            String sql = "select fupperid,fisleaf,fisUpperAllowCA,fgLevel,fiscfreeze  from t_bd_accountview where FCompanyID=?  and  FaccountTableID=? and FUpperID is not null";
            obj.add(unitInfo.getId().toString());
            obj.add(tableInfo.getId().toString());
            IRowSet irow = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])obj.toArray());
            while (irow.next()) {
                AccountViewInfo acctInfo = new AccountViewInfo();
                AccountViewInfo upperInfo = new AccountViewInfo();
                upperInfo.setId(BOSUuid.read((String)irow.getString("fupperid")));
                acctInfo.setUpper(upperInfo);
                acctInfo.setIsUpperAllowCA(irow.getBoolean("fisupperAllowCA"));
                acctInfo.setGLevel(irow.getInt("fGLevel"));
                acctInfo.setIsCFreeze(irow.getBoolean("fiscfreeze"));
                acctInfo.setIsLeaf(irow.getBoolean("fisleaf"));
                acctCols.add(acctInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return acctCols;
    }

    protected IObjectCollection _getAllUpperAcctIdByCompanyAndTbl(Context ctx, String companyId, String accountTableId) throws BOSException {
        AccountViewCollection acctCols = new AccountViewCollection();
        ArrayList<String> obj = new ArrayList<String>();
        if (companyId == null || accountTableId == null) {
            return acctCols;
        }
        try {
            String sql = "select fnumber, fupperid,fisUpperAllowCA,fgLevel  from t_bd_accountview where FCompanyID=?  and  FaccountTableID=? and FUpperID is not null order by fnumber";
            obj.add(companyId);
            obj.add(accountTableId);
            IRowSet irow = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])obj.toArray());
            while (irow.next()) {
                AccountViewInfo acctInfo = new AccountViewInfo();
                AccountViewInfo upperInfo = new AccountViewInfo();
                upperInfo.setId(BOSUuid.read((String)irow.getString("fupperid")));
                acctInfo.setUpper(upperInfo);
                acctInfo.setNumber(irow.getString("fnumber"));
                acctInfo.setIsUpperAllowCA(irow.getBoolean("fisupperAllowCA"));
                acctInfo.setGLevel(irow.getInt("fGLevel"));
                acctCols.add(acctInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return acctCols;
    }

    @Override
    protected Map _batchGetAllUpperAcctIdByCompanysAndTbl(Context ctx, List companyIdList, String accountTableId) throws BOSException {
        HashMap upperInfoListMap = new HashMap();
        Iterator iterator = companyIdList.iterator();
        String companyId = null;
        AccountViewCollection collection = null;
        ArrayList<AccountViewInfo> upperIdList = null;
        while (iterator.hasNext()) {
            companyId = (String)iterator.next();
            collection = (AccountViewCollection)this._getAllUpperAcctIdByCompanyAndTbl(ctx, companyId, accountTableId);
            upperIdList = new ArrayList<AccountViewInfo>();
            if (collection != null && collection.size() > 0) {
                int count = collection.size();
                for (int i = 0; i < count; ++i) {
                    if (collection.get(i) == null) continue;
                    upperIdList.add(collection.get(i));
                }
            }
            upperInfoListMap.put(companyId, upperIdList);
        }
        return upperInfoListMap;
    }

    protected IObjectCollection _getAllAccountForAssign(Context ctx, CtrlUnitInfo currentCu, IObjectValue acctTblInfo) throws BOSException {
        String cuId = currentCu.getId().toString();
        String acctTblId = ((AccountTableInfo)acctTblInfo).getId().toString();
        AccountViewCollection acctCols = this.getAccountViewCollection(ctx, "select id,number,name,longnumber,longname,level,glevel,controlLevel,isUpperAllowCA,PARENT.id,upper.id,CAA.fid,isleaf,CU.id,accountTableID.id where cu='" + cuId + "' AND accountTableID='" + acctTblId + "'  AND (isSelfFreeze=0 AND isParentFreeze=0) ORDER BY NUMBER");
        return acctCols != null && acctCols.size() > 0 ? acctCols : new AccountViewCollection();
    }

    @Override
    protected IObjectCollection _getAllAccountForAssign(Context ctx, IObjectValue currentCompany, IObjectValue acctTblInfo) throws BOSException {
        String companyId = ((CompanyOrgUnitInfo)currentCompany).getId().toString();
        String acctTblId = ((AccountTableInfo)acctTblInfo).getId().toString();
        AccountViewCollection acctCols = this.getAccountViewCollection(ctx, "select id,number,name,longnumber,longname,level,glevel,controlLevel,isUpperAllowCA,PARENT.id,upper.id,CAA.fid,isleaf,companyID.id,accountTableID.id where companyID='" + companyId + "' AND accountTableID='" + acctTblId + "'  AND (isSelfFreeze=0 AND isParentFreeze=0) ORDER BY NUMBER");
        return acctCols != null && acctCols.size() > 0 ? acctCols : new AccountViewCollection();
    }

    protected FilterInfo getFilterForCheckNumber(IObjectValue model) {
        FilterInfo cuFilter = super.getFilterForCheckNumber(model);
        AccountViewInfo acctInfo = (AccountViewInfo)model;
        if (acctInfo.getAccountTableID() != null) {
            cuFilter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctInfo.getAccountTableID().getId().toString()));
        }
        return cuFilter;
    }

    @Override
    protected IObjectCollection _getAccountColsFromExternalExcel(Context ctx, String fileName, IObjectValue acctTblInfo) throws BOSException, AccountException {
        File file = new File(fileName);
        return this.getAccountColsFromExternalExcel(ctx, file, acctTblInfo);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _importAccountTemplate(Context ctx, String fileName, IObjectValue acctTblInfo) throws BOSException, AccountException {
        byte[] content = null;
        FileInputStream input = null;
        try {
            input = new FileInputStream(fileName);
            content = new byte[input.available()];
            input.read(content);
            if (input == null) return this._importAccountTemplate(ctx, content, acctTblInfo);
        }
        catch (FileNotFoundException e1) {
            try {
                throw new AccountException(AccountException.READFILEERROR, new Object[]{fileName});
                catch (IOException e) {
                    throw new AccountException(AccountException.READFILEERROR, new Object[]{fileName});
                }
            }
            catch (Throwable throwable) {
                if (input == null) throw throwable;
                try {
                    input.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AccountException(AccountException.READFILEERROR, new Object[]{fileName});
                }
            }
        }
        try {
            input.close();
            return this._importAccountTemplate(ctx, content, acctTblInfo);
        }
        catch (IOException e) {
            throw new AccountException(AccountException.READFILEERROR, new Object[]{fileName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _importAccountTemplate(Context ctx, byte[] content, IObjectValue acctTblInfo) throws BOSException {
        ArrayList<TaskLog> logList = new ArrayList<TaskLog>();
        IDatataskRunServer iDataTask = DatataskRunServerFactory.getLocalInstance((Context)ctx);
        DatataskParameter param = new DatataskParameter();
        param.datataskMode = 8;
        param.setFileType("xls");
        if (content != null) {
            param.ext = content;
        }
        Hashtable<String, String> dataTaskCtx = new Hashtable<String, String>();
        dataTaskCtx.put("varAccountTableID", acctTblInfo.get("id").toString());
        dataTaskCtx.put("varCUID", ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
        dataTaskCtx.put("varCompanyID", ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        param.setContextParam(dataTaskCtx);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        TaskLog acctTypeLog = null;
        TaskLog acctLog = null;
        try {
            param.solutionName = "eas.basedata.common.accounttype";
            String strAlias = RESOURCE;
            param.alias = ResourceBase.getString((String)strAlias, (String)"accountType", (Locale)ctx.getLocale());
            String logUuid = Uuid.create().toString();
            param.setLogUuID(logUuid);
            iDataTask.run(paramList);
            acctTypeLog = iDataTask.getTaskLog(logUuid);
            iDataTask.clearTaskLog(logUuid);
            logUuid = Uuid.create().toString();
            param.setLogUuID(logUuid);
            param.solutionName = "eas.basedata.common.accountview";
            param.alias = ResourceBase.getString((String)strAlias, (String)"accountantSubject", (Locale)ctx.getLocale());
            iDataTask.run(paramList);
            acctLog = iDataTask.getTaskLog(logUuid);
            iDataTask.clearTaskLog(logUuid);
        }
        catch (DatataskException e) {
            e.printStackTrace();
        }
        finally {
            logList.add(acctTypeLog);
            logList.add(acctLog);
        }
        return logList;
    }

    @Override
    protected IObjectCollection _getAccountColsFromExternalExcel(Context ctx, byte[] content, IObjectValue acctTblInfo) throws BOSException, AccountException {
        FileOutputStream fs = null;
        File file = null;
        String fileName = Uuid.create().toString();
        try {
            file = File.createTempFile(fileName, "xls");
            fs = new FileOutputStream(file);
            fs.write(content);
        }
        catch (Exception e) {
            throw new AccountException(AccountException.READFILEERROR, new Object[]{""});
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.getAccountColsFromExternalExcel(ctx, file, acctTblInfo);
    }

    protected AccountViewCollection getAccountColsFromExternalExcel(Context ctx, File file, IObjectValue acctTblInfo) throws AccountException {
        AccountViewCollection acctCols = new AccountViewCollection();
        AccountViewDataImport acctImport = new AccountViewDataImport();
        Hashtable<String, Object> dataTaskCtx = new Hashtable<String, Object>();
        dataTaskCtx.put("varAccountTableID", acctTblInfo.get("id").toString());
        dataTaskCtx.put("varCUID", ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
        dataTaskCtx.put("varCompanyID", ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        dataTaskCtx.put("ONLYSHOW", true);
        acctImport.setContextParameter(dataTaskCtx);
        String strAlias = RESOURCE;
        String sheetName = ResourceBase.getString((String)strAlias, (String)"accountantSubject", (Locale)ctx.getLocale());
        ExternalExcelDataReader reader = new ExternalExcelDataReader();
        reader.setLocacle(ctx.getLocale());
        try {
            reader.openFile(file, sheetName);
            reader.calculatorRowCount();
            while (reader.hasNext()) {
                String name_l3;
                String name_l2;
                Hashtable hsTbl = reader.getNext();
                AccountViewInfo acctInfo = new AccountViewInfo();
                String number = null;
                String helpCode = null;
                if ((DataToken)hsTbl.get("FNumber") == null) continue;
                number = ((DataToken)hsTbl.get((Object)"FNumber")).data.toString();
                acctInfo.setNumber(number);
                if ((DataToken)hsTbl.get("Fname_L2") != null && (name_l2 = (String)((DataToken)hsTbl.get((Object)"Fname_L2")).data) != null && name_l2.trim().length() != 0) {
                    acctInfo.setName(name_l2, new Locale("L2"));
                }
                if ((DataToken)hsTbl.get("Fname_L3") != null && (name_l3 = (String)((DataToken)hsTbl.get((Object)"Fname_L3")).data) != null && name_l3.trim().length() != 0) {
                    acctInfo.setName(name_l3, new Locale("L3"));
                }
                if ((DataToken)hsTbl.get("FHelpCode") != null) {
                    helpCode = (String)((DataToken)hsTbl.get((Object)"FHelpCode")).data;
                    acctInfo.setHelpCode(helpCode);
                }
                if (acctInfo == null) continue;
                acctCols.add(acctInfo);
            }
            reader.close();
        }
        catch (FileFormatNotStandardException e) {
            throw new AccountException(AccountException.READFILEERROR, new Object[]{"", e.getMessage()});
        }
        catch (TaskRunnerException e) {
            throw new AccountException(AccountException.READFILEERROR, new Object[]{"", e.getMessage()});
        }
        return acctCols;
    }

    @Override
    protected IObjectPK _submitSelf(Context ctx, IObjectValue object) throws BOSException, EASBizException {
        return super._addnew(ctx, object);
    }

    @Override
    protected void _updateSelf(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    @Override
    protected IObjectCollection _getAccountForAssign(Context ctx, String oql) throws BOSException, EASBizException {
        DataPermissionService server = new DataPermissionService(ctx);
        String where = server.getPermissionWhereSQL((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()), (IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()), "bd_account_accountview_assign", "id");
        String order = " ORDER BY NUMBER";
        String sql = null;
        sql = where.equals("1 = 1") ? oql + order : oql + " and " + where + order;
        return this.getAccountViewCollection(ctx, sql);
    }

    @Override
    protected IObjectCollection _getListCAAIsNotNull(Context ctx, IObjectPK companyPK, String accountTableID) throws BOSException, EASBizException {
        AccountViewCollection accountViewC = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (companyPK != null) {
            filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)companyPK.toString().trim()));
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)accountTableID));
            filter.getFilterItems().add(new FilterItemInfo("CAA", null, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
            filter.setMaskString("#0 and #1 and #2 and #3");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)accountTableID));
            filter.getFilterItems().add(new FilterItemInfo("CAA", null, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
            filter.setMaskString("#0 and #1 and #2 and #3");
        }
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSorter().add(new SorterItemInfo("number"));
        accountViewC = this.getAccountsByDAO(ctx, evi);
        return accountViewC;
    }

    @Override
    protected boolean _isAllowEditAC(Context ctx, IObjectValue _company, IObjectValue _accountview) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)_company;
        AccountViewInfo accountview = this.getAccountViewInfo(ctx, "select *,companyID.longNumber where id='" + _accountview.getBOSUuid("id") + "'");
        if (accountview.getCAA() == null || accountview.isAC()) {
            return false;
        }
        if (company == null || company.isIsBizUnit()) {
            boolean isHasDeal = this.isHasAcBiz(ctx, accountview);
            return !isHasDeal;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)accountview.getAccountTableID().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("companyID.longNumber", (Object)(company.getLongNumber() + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("companyID.isBizUnit", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountview.getNumber()));
        filter.getFilterItems().add(new FilterItemInfo("upper.id", null, CompareType.NOTEQUALS));
        try {
            String notLikeSql = this.getNotLikeSql(ctx, accountview);
            String companySql = "select fid from T_ORG_Company where (flongnumber ='" + company.getLongNumber() + "' or flongnumber like '" + company.getLongNumber() + "!%') " + notLikeSql.toString() + ")";
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companySql, CompareType.INNER));
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        selector.add("id");
        selector.add("accountTableID.id");
        selector.add("number");
        selector.add("longNumber");
        selector.add("longName");
        selector.add("CAA.id");
        view.setSelector(selector);
        SorterItemCollection coll = new SorterItemCollection();
        coll.add(new SorterItemInfo("companyID"));
        coll.add(new SorterItemInfo("companyID.number"));
        coll.add(new SorterItemInfo("companyID.longNumber"));
        coll.add(new SorterItemInfo("number"));
        view.setSorter(coll);
        AccountViewCollection accountViewCollection = this.getAccountViewCollection(ctx, view);
        EntityViewInfo evi = new EntityViewInfo();
        filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("srcCompany.longNumber", (Object)company.getLongNumber()));
        filter.getFilterItems().add(new FilterItemInfo("srcCompany.longNumber", (Object)(company.getLongNumber() + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)accountview.getAccountTableID().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)false));
        filter.setMaskString("(#0 or #1) and #2 and #3");
        IAccount_Control acctCtrl = Account_ControlFactory.getLocalInstance(ctx);
        Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
        HashMap<String, Account_ControlInfo> acctCtrlColsMap = new HashMap<String, Account_ControlInfo>();
        Account_ControlInfo acctCtrlInfo = null;
        int count = acctCtrlCols.size();
        for (int i = 0; i < count; ++i) {
            acctCtrlInfo = acctCtrlCols.get(i);
            acctCtrlColsMap.put(acctCtrlInfo.getDestCompany().getId().toString(), acctCtrlInfo);
        }
        AccountViewInfo accountViewInfo = null;
        int count2 = accountViewCollection.size();
        for (int i = 0; i < count2; ++i) {
            accountViewInfo = accountViewCollection.get(i);
            if (accountViewInfo.isAC() || (acctCtrlInfo = (Account_ControlInfo)acctCtrlColsMap.get(accountViewInfo.getCompanyID().getId().toString())) == null || acctCtrlInfo.getAc() != 1) continue;
            boolean isInTimeVerify = "0".equals(ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(accountview.getCompanyID().getId()), (String)"GL_052"));
            if (isInTimeVerify) {
                return false;
            }
            boolean isHasDeal = this.isHasAcBiz(ctx, accountViewInfo);
            if (!isHasDeal) continue;
            return false;
        }
        return true;
    }

    private boolean isHasAcBiz(Context ctx, AccountViewInfo accountview) throws BOSException, EASBizException {
        try {
            CompanyOrgUnitInfo company = accountview.getCompanyID();
            PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
            int CurrentPeriodYear = curPeriod.getPeriodYear();
            int CurrentPeriodNumber = curPeriod.getPeriodNumber();
            StringBuilder sb = new StringBuilder();
            sb.append("select fid from t_bd_accountview WHERE FLongNumber LIKE '" + accountview.getLongNumber().toString() + "%' AND FAccountTableID='" + accountview.getAccountTableID().getId().toString() + "' AND FCompanyID='" + accountview.getCompanyID().getId().toString() + "' AND FAc=0");
            IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            StringBuilder inSql = new StringBuilder("('").append(accountview.getId().toString()).append("'");
            while (rs.next()) {
                String acctID = rs.getString(1);
                inSql.append(",'").append(acctID).append("'");
            }
            inSql.append(")");
            String sql = "select top 1 head.fid from t_gl_voucher head inner join t_gl_voucherentry entry on entry.FBILLID =head.FID where head.fcompanyid=? and ( head.FPeriodID in (select fid from t_bd_period where (fperiodyear*100+fperiodnumber)>=?)) and entry.FAccountID in " + inSql.toString();
            rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{company.getId().toString(), new Integer(CurrentPeriodYear * 100 + CurrentPeriodNumber)});
            return rs.next();
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _disableAccountTable(Context ctx, IObjectPK companyID, IObjectPK accountTableID) throws BOSException, EASBizException {
        boolean hasAssign = this.checkAccountTableHasAssign(ctx, companyID, accountTableID);
        if (hasAssign) {
            AccountTableInfo accountTableInfo = AccountTableFactory.getLocalInstance(ctx).getAccountTableInfo(accountTableID);
            throw new AccountException(AccountException.ACCOUNT_HAS_ASSIGN, new Object[]{accountTableInfo.getName()});
        }
        boolean hasAccountRefContrast = false;
        hasAccountRefContrast = this.checkAccountTableHasRefContrast(ctx, companyID, accountTableID);
        if (hasAccountRefContrast) {
            AccountTableInfo accountTableInfo = AccountTableFactory.getLocalInstance(ctx).getAccountTableInfo(accountTableID);
            throw new AccountException(AccountException.ACCOUNT_HAS_REFCONTRAST, new Object[]{accountTableInfo.getName()});
        }
        boolean isAccountTableHasDeal = false;
        isAccountTableHasDeal = this.checkAccountTableHasDeal(ctx, companyID, accountTableID);
        if (isAccountTableHasDeal) {
            throw new AccountException(AccountException.ACCOUNTTABLEHASDEAL);
        }
        NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx).updateAccountTableInCompany(companyID.toString(), null);
    }

    private boolean checkAccountTableHasRefContrast(Context ctx, IObjectPK companyID, IObjectPK accountTableID) throws BOSException {
        boolean hasAccountRefContrast = false;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT top 1 fid \n");
        sql.append(" FROM T_BD_AcctRefContrast \n");
        sql.append(" WHERE FCompanyID = ? and FEnabledAcctTableID = ? and FIsEnabled = 1");
        try {
            IRowSet rowSet = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID.toString(), accountTableID.toString()});
            if (rowSet.next()) {
                hasAccountRefContrast = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return hasAccountRefContrast;
    }

    private boolean checkAccountTableHasAssign(Context ctx, IObjectPK companyID, IObjectPK accountTableID) throws BOSException {
        boolean hasAssign = false;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT top 1 fid ");
        sql.append(" FROM T_BD_Acct_Contorl ");
        sql.append(" WHERE FSrcCompanyID = ? and FDestCompanyID!=? and FAccountTableID = ? ");
        try {
            IRowSet rowSet = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID.toString(), companyID.toString(), accountTableID.toString()});
            if (rowSet.next()) {
                hasAssign = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return hasAssign;
    }

    @Override
    protected void _enableAccountTable(Context ctx, IObjectPK companyID, IObjectPK oldAccountTableID, IObjectPK newAccountTableID) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        String oql = "select id where  destCompany='" + companyInfo.getId().toString() + "' and accountTableID='" + newAccountTableID.toString() + "'";
        if (!Account_ControlFactory.getLocalInstance(ctx).exists(oql)) {
            throw new AccountException(AccountException.ACCOUNTTABLENOTAVAILABLE);
        }
        if (oldAccountTableID != null) {
            this._disableAccountTable(ctx, companyID, oldAccountTableID);
        }
        NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx).updateAccountTableInCompany(companyID.toString(), newAccountTableID.toString());
    }

    private boolean checkAccountTableHasDeal(Context ctx, IObjectPK companyID, IObjectPK accountTableID) throws BOSException, EASBizException {
        boolean isAccountTableHasDeal = false;
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(companyID);
        if (company == null) {
            logger.debug((Object)("Company " + companyID.toString() + " does not exist."));
            return isAccountTableHasDeal;
        }
        if (!company.isIsBizUnit()) {
            return isAccountTableHasDeal;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)companyID.toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)accountTableID.toString()));
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        SorterItemCollection coll = new SorterItemCollection();
        SorterItemInfo info = new SorterItemInfo("number");
        coll.add(info);
        evi.setSorter(coll);
        AccountViewCollection accountViewCollection = this.getAccountViewCollection(ctx, evi);
        if (accountViewCollection == null || accountViewCollection.size() <= 0) {
            return isAccountTableHasDeal;
        }
        BizCheckResult checkResult = this.checkIsAccountHasDeal(ctx, accountViewCollection, BOSUuid.read((String)companyID.toString()), BOSUuid.read((String)accountTableID.toString()));
        if (checkResult != null && checkResult.isFound()) {
            isAccountTableHasDeal = true;
        }
        return isAccountTableHasDeal;
    }

    protected void _updateAccountTableInCompany(Context ctx, String companyId, String accountTableId) throws BOSException, EASBizException {
        if (!CompanyOrgUnitFactory.getLocalInstance((Context)ctx).exists("where id = '" + companyId + "'")) {
            throw new BOSException("id, " + companyId + ", is not a company unit's id");
        }
        if (accountTableId != null && !AccountTableFactory.getLocalInstance(ctx).exists("where id = '" + accountTableId + "'")) {
            throw new BOSException("id, " + accountTableId + ", is not an account table's id");
        }
        StringBuffer updateOUPartFI = new StringBuffer();
        if (accountTableId == null) {
            updateOUPartFI.append("update t_org_oupartfi set faccounttableid = null");
        } else {
            updateOUPartFI.append("update t_org_oupartfi set faccounttableid = '").append(accountTableId).append("'");
        }
        updateOUPartFI.append(" where funitid = '").append(companyId).append("'");
        StringBuffer updateCompany = new StringBuffer();
        if (accountTableId == null) {
            updateCompany.append("update t_org_company set faccounttableid = null");
        } else {
            updateCompany.append("update t_org_company set faccounttableid = '").append(accountTableId).append("'");
        }
        updateCompany.append(" where fid = '").append(companyId).append("'");
        Connection cn = null;
        Statement stmt = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.createStatement();
            stmt.addBatch(updateOUPartFI.toString());
            stmt.addBatch(updateCompany.toString());
            stmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        OrgCacheFactory.getOrgCache((Context)ctx).clearOrgCache();
    }

    @Override
    protected void _dataUpdate(Context ctx) throws BOSException, EASBizException {
        BaseFaAlterModeFactory.createInstance().updateBaseDataFromCUToFi(ctx);
        this.updataAccountData(ctx);
        this.updataBizData(ctx);
        this.repairUperID(ctx);
    }

    @Override
    protected void _updataAccountData(Context ctx) throws BOSException, EASBizException {
        CtrlUnitCollection ctrlUnitCollection = this.getCtrlUnitCollection(ctx);
        if (ctrlUnitCollection == null || ctrlUnitCollection.size() <= 0) {
            return;
        }
        CompanyOrgUnitInfo parentCompany = new CompanyOrgUnitInfo();
        int count = ctrlUnitCollection.size();
        for (int i = 0; i < count; ++i) {
            AccountTableCollection accountTableCollection;
            CtrlUnitInfo ctrlUnitInfo = null;
            CompanyOrgUnitCollection companyOrgUnitCollection = null;
            ctrlUnitInfo = ctrlUnitCollection.get(i);
            parentCompany.setId(ctrlUnitInfo.getId());
            companyOrgUnitCollection = this.getCompanyOrgUnitCollection(ctx, ctrlUnitInfo);
            if (companyOrgUnitCollection == null || companyOrgUnitCollection.size() <= 0 || (accountTableCollection = AccountTools.getAllAccountTableByCompany(ctx, parentCompany)) == null || accountTableCollection.size() <= 0) continue;
            AccountTableInfo accountTable = null;
            int tableCount = accountTableCollection.size();
            for (int j = 0; j < tableCount; ++j) {
                accountTable = accountTableCollection.get(j);
                AccountViewCollection allAccount = AccountTools.getallAccountViewByCompanyAndTable(ctx, parentCompany, accountTable, null, null);
                Account_ControlCollection account_ControlCollection = this.getAccount_ControlCollection(ctx, accountTable, parentCompany, companyOrgUnitCollection);
                this._assignAccountToChild(ctx, (IObjectCollection)account_ControlCollection, (IObjectCollection)allAccount, false);
            }
        }
    }

    private CtrlUnitCollection getCtrlUnitCollection(Context ctx) throws BOSException, EASBizException {
        CtrlUnitCollection ctrlUnitCollection = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select id where id in (");
        sql.append("select fcontrolunitid from t_org_company where fiscu = 0 and fid not in (");
        sql.append("select fcompanyid from t_bd_accountview");
        sql.append(")");
        sql.append(")");
        ctrlUnitCollection = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitCollection(sql.toString());
        return ctrlUnitCollection;
    }

    private CompanyOrgUnitCollection getCompanyOrgUnitCollection(Context ctx, CtrlUnitInfo ctrlUnitInfo) throws BOSException, EASBizException {
        CompanyOrgUnitCollection companyOrgUnitCollection = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select * where cu = '");
        sql.append(ctrlUnitInfo.getId().toString());
        sql.append("' and ");
        sql.append("iscu = 0 and ");
        sql.append("id not in (");
        sql.append("select fcompanyid from t_bd_accountview");
        sql.append(")");
        companyOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(sql.toString());
        return companyOrgUnitCollection;
    }

    @Override
    protected void _updataBizData(Context ctx) throws BOSException, EASBizException {
        ArrayList referenceEntityList = AccountTools.getReferenceEntity(ctx);
        Connection cn = null;
        Statement stmt = null;
        try {
            cn = this.getConnection(ctx);
            cn.setAutoCommit(false);
            stmt = cn.createStatement();
            CompanyOrgUnitCollection notCuCompanyIDSet = this.getNotCuCompanyIDSet(ctx);
            String notCuCompanyID = null;
            int count = notCuCompanyIDSet.size();
            for (int i = 0; i < count; ++i) {
                notCuCompanyID = "'" + notCuCompanyIDSet.get(i).getId().toString() + "'";
                this.updateBizDataByCompany(ctx, stmt, referenceEntityList, notCuCompanyID);
                cn.commit();
                stmt.clearBatch();
            }
            cn.setAutoCommit(true);
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new AccountException(AccountException.UPDATE_BIZ_DATA_ERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    private void updateBizDataByCompany(Context ctx, Statement stmt, ArrayList referenceEntityList, String notCuCompanyID) throws AccountException {
        String referenceTableName = null;
        String currentAccountFieldName = null;
        String currentCompanyFieldName = null;
        String sql = null;
        try {
            int count = referenceEntityList.size() / 3;
            for (int i = 0; i < count; ++i) {
                referenceTableName = (String)referenceEntityList.get(3 * i);
                currentAccountFieldName = (String)referenceEntityList.get(3 * i + 1);
                currentCompanyFieldName = (String)referenceEntityList.get(3 * i + 2);
                try {
                    sql = this.generateUpdateBizData(ctx, referenceTableName, currentAccountFieldName, currentCompanyFieldName, notCuCompanyID);
                    logger.info((Object)("sql: " + sql));
                    com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql);
                    continue;
                }
                catch (Exception e) {
                    logger.error(sql, (Throwable)e);
                }
            }
            this.addBizBatch(ctx, stmt, notCuCompanyID);
            stmt.executeBatch();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new AccountException(AccountException.UPDATE_BIZ_DATA_ERROR, e);
        }
    }

    private CompanyOrgUnitCollection getNotCuCompanyIDSet(Context ctx) throws BOSException {
        StringBuffer notCuCompanyIDSet = new StringBuffer();
        notCuCompanyIDSet.append("''");
        String oql = "select fid where isCU = 0";
        CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(oql);
        return companyOrgUnitCollection;
    }

    private void addBizBatch(Context ctx, Statement stmt, String notCuCompanyID) throws SQLException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_GL_VoucherEntry set ");
        sql.append(" (FAccountID) = (select t_bd_accountview.fid from t_bd_accountview,T_GL_Voucher where ");
        sql.append(" T_GL_VoucherEntry.FAccountID = t_bd_accountview.FUPPERID and ");
        sql.append(" T_GL_VoucherEntry.FBillID = T_GL_Voucher.FID and ");
        sql.append(" T_GL_Voucher.Fcompanyid = ").append(notCuCompanyID).append(" and ");
        sql.append(" T_GL_Voucher.Fcompanyid = t_bd_accountview.FCOMPANYID);");
        stmt.addBatch(sql.toString());
        sql = new StringBuffer();
        sql.append(" update T_GL_AutoTransEntry set                                                        ");
        sql.append(" (FAccountID) = (select t_bd_accountview.fid from t_bd_accountview,T_GL_AutoTrans where  ");
        sql.append(" T_GL_AutoTransEntry.FAccountID = t_bd_accountview.FUPPERID and                        ");
        sql.append(" T_GL_AutoTransEntry.FAutoTransID = T_GL_AutoTrans.FID and                             ");
        sql.append(" T_GL_AutoTrans.Fcompanyid = ").append(notCuCompanyID).append(" and ");
        sql.append(" T_GL_AutoTrans.Fcompanyid = t_bd_accountview.FCOMPANYID);                              ");
        stmt.addBatch(sql.toString());
        sql = new StringBuffer();
        sql.append(" insert into T_GL_AssistCustomizedProperty (FID , FCREATORID , FCREATETIME , FLASTUPDATEUSERID , FLASTUPDATETIME , FACCOUNTID , FSEQ , FISNECESSARY , FCUSTOMIZEDTYPEID , FCONTROLUNITID , FISDEBITNECESSARY , FISCREDITNECESSARY , FISENABLE , FDELETEDSTATUS) ");
        sql.append(" select newbosid('F3F9C04F') FID , asst.FCREATORID , asst.FCREATETIME , asst.FLASTUPDATEUSERID , asst.FLASTUPDATETIME , acct.fid FACCOUNTID , FSEQ , FISNECESSARY , FCUSTOMIZEDTYPEID , asst.FCONTROLUNITID , FISDEBITNECESSARY , FISCREDITNECESSARY , FISENABLE , FDELETEDSTATUS ");
        sql.append(" from T_GL_AssistCustomizedProperty asst,t_org_company c, T_BD_AccountView acct ");
        sql.append(" where asst.fcontrolunitid = c.fcontrolunitid and ");
        sql.append(" c.fid = acct.fcompanyid and ");
        sql.append(" c.fiscu = 0 and ");
        sql.append(" acct.fupperid = asst.FACCOUNTID and ");
        sql.append(" acct.fid not in(select FAccountID from T_GL_AssistCustomizedProperty); ");
        stmt.addBatch(sql.toString());
        sql = new StringBuffer();
        sql.append(" insert into T_BD_AsstActTypeDefault(Fid,FAsstActTypeID,FDefaultID,FIsAccountCussent,FIsDefaultAccountReceivable,FIsDefaultAccountPayable,FCompanyID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID) ");
        sql.append(" select newbosid('E6CDF88A') Fid,FAsstActTypeID,FDefaultID,FIsAccountCussent,FIsDefaultAccountReceivable,FIsDefaultAccountPayable,c.fid FCompanyID, ");
        sql.append(" asst.FCreatorID FCreatorID,asst.FCreateTime FCreateTime,asst.FLastUpdateUserID FLastUpdateUserID,asst.FLastUpdateTime FLastUpdateTime, ");
        sql.append(" asst.FControlUnitID FControlUnitID ");
        sql.append(" from T_BD_AsstActTypeDefault asst,t_org_company c ");
        sql.append(" where asst.fcontrolunitid = asst.FCompanyID and asst.fcontrolunitid = c.fcontrolunitid and ");
        sql.append(" c.fiscu = 0 and ");
        sql.append(" c.fid not in(select FCompanyID from T_BD_AsstActTypeDefault); ");
        stmt.addBatch(sql.toString());
        sql = new StringBuffer();
        sql.append(" update t_gl_flag set (FKey) = ");
        sql.append(" (select t_bd_accountview.fid from t_bd_accountview where ");
        sql.append(" t_gl_flag.FKey = t_bd_accountview.FUPPERID and ");
        sql.append(" t_gl_flag.FOrgUnitId = ").append(notCuCompanyID).append(" and ");
        sql.append(" t_gl_flag.FOrgUnitId = t_bd_accountview.FCOMPANYID); ");
        stmt.addBatch(sql.toString());
        sql = new StringBuffer();
        sql.append(" insert into T_BD_AcctRefContrast (FID , FCreatorID , FCreateTime , FLastUpdateUserID , FLastUpdateTime , FControlUnitID , FEnabledAcctTableID , FDisabledAcctTableID , FIsEnabled , FEnabledTime , FContrastTime , FEnabledPeriodID , FIsIncludeFreezeAcct , FRefType , FCompanyID) ");
        sql.append(" select newbosid('88378C14') FID , arc.FCreatorID , arc.FCreateTime , arc.FLastUpdateUserID , arc.FLastUpdateTime , arc.FControlUnitID , FEnabledAcctTableID , FDisabledAcctTableID , FIsEnabled , FEnabledTime , FContrastTime , FEnabledPeriodID , FIsIncludeFreezeAcct , FRefType , c.FID FCompanyID ");
        sql.append(" from T_BD_AcctRefContrast arc, t_org_company c, T_BD_SystemStatusCtrol s ");
        sql.append(" where arc.fcontrolunitid = arc.FCompanyID and arc.fcontrolunitid = c.fcontrolunitid and ");
        sql.append(" c.fiscu = 0 and ");
        sql.append(" c.fid not in(select FCompanyID from T_BD_AcctRefContrast) and ");
        sql.append(" s.fcompanyid = c.fid and ");
        sql.append(" s.fsystemstatusid = 'e45c1988-00fd-1000-e000-33d8c0a8100d02A5514C' and ");
        sql.append(" s.fisstart = 1; ");
        stmt.addBatch(sql.toString());
        sql = new StringBuffer();
        sql.append(" Create Table T_BD_AcctRefContrastEntryT ( FID VARCHAR(44) NOT NULL ,FAcctRefContrastID VARCHAR(44),FOldAcctID VARCHAR(44),FNewAcctID VARCHAR(44),FOldAcctNumber NVARCHAR(80),FOldAcctName_L1 NVARCHAR(255),FOldAcctName_L2 NVARCHAR(255),FOldAcctName_L3 NVARCHAR(255),FSeq INT,CONSTRAINT PK_AcctRCEntry4 PRIMARY KEY (FID));");
        stmt.addBatch(sql.toString());
        sql = new StringBuffer();
        sql.append(" insert into T_BD_AcctRefContrastEntryT (FID , FAcctRefContrastID , FOldAcctID , FNewAcctID , FOldAcctNumber , FOldAcctName_L1 , FOldAcctName_L2 , FOldAcctName_L3 , FSeq) ");
        sql.append(" select newbosid('0EC0F8BE') FID , childh.FID FAcctRefContrastID , parente.FOldAcctID , parente.FNewAcctID , parente.FOldAcctNumber , parente.FOldAcctName_L1 , parente.FOldAcctName_L2 , parente.FOldAcctName_L3 , parente.FSeq ");
        sql.append(" from T_BD_AcctRefContrastentry parente, T_BD_AcctRefContrast parenth , T_BD_AcctRefContrast childh, t_org_company c ");
        sql.append(" where childh.fcompanyid = c.fid ");
        sql.append(" and c.fcontrolunitid = parenth.fcompanyid ");
        sql.append(" and parenth.FEnabledAcctTableID= childh.FEnabledAcctTableID ");
        sql.append(" and parenth.FDisabledAcctTableID= childh.FDisabledAcctTableID ");
        sql.append(" and parenth.FCreateTime= childh.FCreateTime ");
        sql.append(" and parente.FAcctRefContrastID= parenth.fid ");
        sql.append(" and childh.fcompanyid = ").append(notCuCompanyID).append("  ");
        sql.append(" and not exists (select FAcctRefContrastID from T_BD_AcctRefContrastentry where FAcctRefContrastID = childh.fid); ");
        stmt.addBatch(sql.toString());
        sql = new StringBuffer();
        sql.append(" update T_BD_AcctRefContrastEntryT set ");
        sql.append(" (FOldAcctID) = (select top 1 t_bd_accountview.fid from t_bd_accountview,T_BD_AcctRefContrast,t_org_company where ");
        sql.append(" T_BD_AcctRefContrastEntryT.FOldAcctID = t_bd_accountview.FUPPERID and ");
        sql.append(" T_BD_AcctRefContrastEntryT.FAcctRefContrastID = T_BD_AcctRefContrast.FID and ");
        sql.append(" T_BD_AcctRefContrast.FCompanyID = t_org_company.fid and ");
        sql.append(" (T_BD_AcctRefContrast.FRefType = 1 or ");
        sql.append(" (T_BD_AcctRefContrast.FRefType = 2 and t_org_company.FMainOrgID is null)) and ");
        sql.append(" T_BD_AcctRefContrast.Fcompanyid = ").append(notCuCompanyID).append(" and ");
        sql.append(" T_BD_AcctRefContrast.Fcompanyid = t_bd_accountview.FCOMPANYID); ");
        stmt.addBatch(sql.toString());
        sql = new StringBuffer();
        sql.append(" update T_BD_AcctRefContrastEntryT set ");
        sql.append(" (FOldAcctID) = (select top 1 t_bd_accountview.fid from t_bd_accountview,T_BD_AcctRefContrast,t_org_company where ");
        sql.append(" T_BD_AcctRefContrastEntryT.FOldAcctID = t_bd_accountview.FUPPERID and ");
        sql.append(" T_BD_AcctRefContrastEntryT.FAcctRefContrastID = T_BD_AcctRefContrast.FID and ");
        sql.append(" T_BD_AcctRefContrast.FCompanyID = t_org_company.fid and ");
        sql.append(" T_BD_AcctRefContrast.FRefType = 2 and ");
        sql.append(" t_org_company.FMainOrgID is not null and ");
        sql.append(" T_BD_AcctRefContrast.Fcompanyid = ").append(notCuCompanyID).append(" and ");
        sql.append(" t_org_company.FMainOrgID = t_bd_accountview.FCOMPANYID); ");
        stmt.addBatch(sql.toString());
        sql = new StringBuffer();
        sql.append(" update T_BD_AcctRefContrastEntryT set ");
        sql.append(" (FNewAcctID) = (select top 1 t_bd_accountview.fid from t_bd_accountview,T_BD_AcctRefContrast where ");
        sql.append(" T_BD_AcctRefContrastEntryT.FNewAcctID = t_bd_accountview.FUPPERID and ");
        sql.append(" T_BD_AcctRefContrastEntryT.FAcctRefContrastID = T_BD_AcctRefContrast.FID and ");
        sql.append(" T_BD_AcctRefContrast.Fcompanyid = ").append(notCuCompanyID).append(" and ");
        sql.append(" T_BD_AcctRefContrast.Fcompanyid = t_bd_accountview.FCOMPANYID); ");
        stmt.addBatch(sql.toString());
        sql = new StringBuffer();
        sql.append(" insert into T_BD_AcctRefContrastEntry (FID , FAcctRefContrastID , FOldAcctID , FNewAcctID , FOldAcctNumber , FOldAcctName_L1 , FOldAcctName_L2 , FOldAcctName_L3 , FSeq) ");
        sql.append(" select FID , FAcctRefContrastID , FOldAcctID , FNewAcctID , FOldAcctNumber , FOldAcctName_L1 , FOldAcctName_L2 , FOldAcctName_L3 , FSeq from T_BD_AcctRefContrastEntryT ; ");
        stmt.addBatch(sql.toString());
        sql = new StringBuffer();
        sql.append(" drop table T_BD_AcctRefContrastEntryT; ");
        stmt.addBatch(sql.toString());
        sql = new StringBuffer();
        sql.append(" update T_BD_KAClassificationDetail set ");
        sql.append(" (FAccountlinkID) = (select t_bd_accountview.fid from t_bd_accountview,T_BD_KAClassfication where ");
        sql.append(" T_BD_KAClassificationDetail.FAccountlinkID = t_bd_accountview.FUPPERID and ");
        sql.append(" T_BD_KAClassificationDetail.FKaclassficlink = T_BD_KAClassfication.FID and ");
        sql.append(" T_BD_KAClassfication.FCurrencyCompany = ").append(notCuCompanyID).append(" and ");
        sql.append(" T_BD_KAClassfication.FCurrencyCompany = t_bd_accountview.FCOMPANYID); ");
        stmt.addBatch(sql.toString());
        sql = new StringBuffer();
        sql.append(" update t_bas_paramitem set (FValue_L1) =  ");
        sql.append(" (select top 1 t_bd_accountview.fid from t_bd_accountview,t_bas_paramitem where ");
        sql.append(" t_bas_paramitem.FValue_L1 = t_bd_accountview.FUPPERID and ");
        sql.append(" t_bas_paramitem.FOrgUnitID = ").append(notCuCompanyID).append(" and ");
        sql.append(" t_bas_paramitem.FOrgUnitID = t_bd_accountview.FCOMPANYID) ");
        sql.append(" where fkeyid = (select fid from t_bas_param where fnumber = 'GL_010'); ");
        stmt.addBatch(sql.toString());
        sql = new StringBuffer();
        sql.append(" update t_bas_paramitem set FValue_L2 = FValue_L1, FValue_L3 = FValue_L1 ");
        sql.append(" where fkeyid = (select fid from t_bas_param where fnumber = 'GL_010') and ");
        sql.append(" FValue_L2 <> FValue_L1; ");
        stmt.addBatch(sql.toString());
    }

    private String generateUpdateBizData(Context ctx, String referenceTableName, String currentAccountFieldName, String currentCompanyFieldName, String notCuCompanyID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ");
        sql.append(referenceTableName);
        sql.append(" set (");
        sql.append(currentAccountFieldName);
        sql.append(") = (select t_bd_accountview.fid from t_bd_accountview where ");
        sql.append(referenceTableName);
        sql.append(".");
        sql.append(currentAccountFieldName);
        sql.append(" = t_bd_accountview.FUPPERID and ");
        sql.append(referenceTableName);
        sql.append(".");
        sql.append(currentCompanyFieldName);
        sql.append(" = t_bd_accountview.FCOMPANYID and ");
        sql.append(" t_bd_accountview.FCOMPANYID ");
        sql.append(" = ").append(notCuCompanyID);
        sql.append(")");
        return sql.toString();
    }

    private Account_ControlCollection getAccount_ControlCollection(Context ctx, AccountTableInfo accountTable, CompanyOrgUnitInfo srcCompany, CompanyOrgUnitCollection children) throws BOSException, EASBizException {
        Account_ControlCollection account_ControlCollection = new Account_ControlCollection();
        Map childAcctCtrlInfoMap = AccountTools.getAcctCtrlInfoMap(ctx, accountTable, srcCompany, children);
        CompanyOrgUnitInfo child = null;
        int count = children.size();
        for (int i = 0; i < count; ++i) {
            child = children.get(i);
            Account_ControlInfo childAcctCtrlInfo = (Account_ControlInfo)childAcctCtrlInfoMap.get(child.getId().toString());
            if (childAcctCtrlInfo == null) {
                childAcctCtrlInfo = new Account_ControlInfo();
            }
            childAcctCtrlInfo.setId(null);
            childAcctCtrlInfo.setAssign(true);
            childAcctCtrlInfo.setAccountTableID(accountTable);
            childAcctCtrlInfo.setSrcCompany(srcCompany);
            childAcctCtrlInfo.setDestCompany(child);
            account_ControlCollection.add(childAcctCtrlInfo);
        }
        return account_ControlCollection;
    }

    @Override
    protected void _repairUperID(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        Object dbType = ctx.get((Object)"dbType");
        if (dbType != null && "MS SQL Server".equalsIgnoreCase(dbType.toString())) {
            sql.append("/*dialect*/ ");
            sql.append("UPDATE t_bd_accountview SET fupperid=pv.fid ");
            sql.append("FROM t_bd_accountview, t_bd_accountview pv, t_org_company ");
            sql.append("WHERE pv.fnumber = t_bd_accountview.fnumber AND ");
            sql.append("t_bd_accountview.faccounttableid = pv.faccounttableid AND ");
            sql.append("pv.FcompanyID = t_org_company.FPARENTID AND ");
            sql.append("t_org_company.FID = t_bd_accountview.Fcompanyid AND");
            sql.append(" t_org_company.FPARENTID IS NOT NULL and  ");
            sql.append("t_bd_accountview.fupperid<>pv.fid");
        } else {
            sql.append("update t_bd_accountview set (fupperid) = ");
            sql.append("(");
            sql.append("select top 1 pv.fid from t_bd_accountview pv, t_org_company where ");
            sql.append("pv.fnumber= t_bd_accountview.fnumber and ");
            sql.append("pv.faccounttableid= t_bd_accountview.faccounttableid and ");
            sql.append("pv.FcompanyID= t_org_company.FPARENTID and ");
            sql.append("t_org_company.FID = t_bd_accountview.Fcompanyid and ");
            sql.append("t_org_company.FPARENTID is not null ");
            sql.append("and t_bd_accountview.fupperid<>pv.fid)");
        }
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void repairUperID(Context ctx, String companyId, String accountTableId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update t_bd_accountview set fupperid =                            ");
        sql.append(" (                                                                   ");
        sql.append(" select top 1 pv.fid from t_bd_accountview pv, t_org_company where  ");
        sql.append(" t_org_company.fid = ? and                                      ");
        sql.append(" t_bd_accountview.faccounttableid = ? and                                      ");
        sql.append(" t_org_company.FPARENTID is not null and                            ");
        sql.append(" t_org_company.FID = t_bd_accountview.Fcompanyid and            ");
        sql.append(" t_org_company.FPARENTID = pv.Fcompanyid and                    ");
        sql.append(" t_bd_accountview.fnumber = pv.fnumber and                           ");
        sql.append(" t_bd_accountview.faccounttableid = pv.faccounttableid and           ");
        sql.append(" t_bd_accountview.fupperid <> pv.fid                                 ");
        sql.append(" )                                                                   ");
        sql.append(" where Fcompanyid = ?                                                ");
        sql.append(" and faccounttableid = ?                                           ");
        sql.append(" and exists(                                                       ");
        sql.append(" select top 1 pv.fid from t_bd_accountview pv, t_org_company where  ");
        sql.append(" t_org_company.fid = ? and                                      ");
        sql.append(" t_bd_accountview.faccounttableid = ? and                           ");
        sql.append(" t_org_company.FPARENTID is not null and                            ");
        sql.append(" t_org_company.FID = t_bd_accountview.Fcompanyid and        ");
        sql.append(" t_org_company.FPARENTID = pv.Fcompanyid and                    ");
        sql.append(" t_bd_accountview.fnumber = pv.fnumber and                           ");
        sql.append(" t_bd_accountview.faccounttableid = pv.faccounttableid and           ");
        sql.append(" t_bd_accountview.fupperid <> pv.fid                                 ");
        sql.append(" )                                                                   ");
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, accountTableId, companyId, accountTableId, companyId, accountTableId});
    }

    @Override
    protected boolean _isOnlyChild(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AccountViewInfo accountView = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("caa");
        selector.add("parent.id");
        selector.add("parent.caa");
        accountView = this.getAccountViewInfo(ctx, pk, selector);
        if (accountView == null) {
            return false;
        }
        try {
            return this.hasParent(ctx, accountView);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Set _getNoDealAccountIDSet(Context ctx, BOSUuid companyID, BOSUuid accountTableID) throws BOSException, EASBizException {
        HashSet<String> noDealAccountIDSet = new HashSet<String>();
        if (companyID == null) return noDealAccountIDSet;
        if (accountTableID == null) {
            return noDealAccountIDSet;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyID.toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableID.toString()));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)new Boolean(false)));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)new Boolean(false)));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        view.setSelector(selector);
        AccountViewCollection accountViewColl = this.getAccountViewCollection(ctx, view);
        if (accountViewColl == null) return noDealAccountIDSet;
        if (accountViewColl.size() == 0) {
            return noDealAccountIDSet;
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        view.setFilter(filter);
        StringBuffer maskString = new StringBuffer();
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)accountTableID.toString()));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Boolean(true)));
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
        filter.getFilterItems().add(new FilterItemInfo("companyID.longNumber", (Object)companyOrgUnitInfo.getLongNumber()));
        filter.getFilterItems().add(new FilterItemInfo("companyID.longNumber", (Object)(companyOrgUnitInfo.getLongNumber() + "!%"), CompareType.LIKE));
        maskString.append("(#0 and #1 and (#2 or #3) and (");
        int index = 4;
        String lastNumber = "9999999999";
        int count = accountViewColl.size();
        for (int i = 0; i < count; ++i) {
            AccountViewInfo acctInfo = accountViewColl.get(i);
            String number = acctInfo.getNumber();
            if (number.indexOf(lastNumber, 0) == 0) continue;
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)(number + "%"), CompareType.LIKE));
            if (i > 0) {
                maskString.append(" or ");
            }
            lastNumber = number;
            maskString.append(" #" + index++);
        }
        maskString.append("))");
        filter.setMaskString(maskString.toString());
        selector = new SelectorItemCollection();
        selector.add("id");
        view.setSelector(selector);
        AccountViewCollection accountViewCollection = this.getAccountViewCollection(ctx, view);
        AccountViewInfo accountViewInfo = null;
        StringBuffer idSet = new StringBuffer();
        int count2 = accountViewCollection.size();
        for (int i = 0; i < count2; ++i) {
            accountViewInfo = accountViewCollection.get(i);
            noDealAccountIDSet.add(accountViewInfo.getId().toString());
            if (i > 0) {
                idSet.append(",");
            }
            idSet.append("'").append(accountViewInfo.getId().toString()).append("'");
        }
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        try {
            con = DbUtil.getConn((Context)ctx);
            sql = new StringBuffer();
            sql.append("select distinct FAccountID                                                                                                                  \t\t\t\t\t\r\n");
            sql.append("from t_gl_VoucherEntry                                                                                                                         \t\r\n");
            sql.append(" where \tFAccountID in (").append(idSet.toString()).append("); \t\r\n");
            String selectVoucherAccountSql = sql.toString();
            stmt = con.prepareStatement(selectVoucherAccountSql);
            rs = stmt.executeQuery();
            while (rs != null && rs.next()) {
                String accountID = rs.getString("FAccountID");
                noDealAccountIDSet.remove(accountID);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql = new StringBuffer();
            sql.append(" select distinct bal.FAccountID                                                          \t\r\n");
            sql.append("from t_gl_InitAccountBalance bal                                        \r\n");
            sql.append("where bal.FAccountID in (").append(idSet.toString()).append(")                                                \r\n");
            sql.append(" \tand (fbeginbalancefor<>0 or fyeardebitfor<>0 or fyearcreditfor<>0  or fdebitfor<>0  or fcreditfor<>0\t").append(" or fendbalancefor<>0  or fbeginbalancelocal<>0  or fyeardebitlocal<>0  or fyearcreditlocal<>0 \t\t\t\t\t").append(" or fdebitlocal<>0  or fcreditlocal<>0  or fendbalancelocal<>0  or fbeginbalancerpt<>0 \t\t\t\t\t\t").append(" or fyeardebitrpt<>0  or fyearcreditrpt<>0  or fdebitrpt<>0  or fcreditrpt<>0  or fendbalancerpt<>0\t\t\t\t").append(" or fyearpnlfor<>0  or fmonthpnlfor<>0  or fyearpnllocal<>0  or fmonthpnllocal<>0  or fyearpnlrpt<>0  or fmonthpnlrpt<>0\t").append(" or fbeginqty<>0  or fyeardebitqty<>0  or fyearcreditqty<>0  or fdebitqty<>0  or fcreditqty<>0  or fendqty<>0\t\t\t\t").append(");");
            String selectInitAccountBalanceAccountSql = sql.toString();
            stmt = con.prepareStatement(selectInitAccountBalanceAccountSql);
            rs = stmt.executeQuery();
            while (rs != null && rs.next()) {
                String accountID = rs.getString("FAccountID");
                noDealAccountIDSet.remove(accountID);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql = new StringBuffer();
            sql.append(" select distinct bal.FAccountID                                                                                                             \t\t\t\t\t\r\n");
            sql.append("from t_gl_InitAssistBalance bal                                                                                                                        \r\n");
            sql.append("where bal.FAccountID in (").append(idSet.toString()).append(")                                                                                                                                \r\n");
            sql.append(" \tand (fbeginbalancefor<>0 or fyeardebitfor<>0 or fyearcreditfor<>0  or fdebitfor<>0  or fcreditfor<>0\t").append(" or fendbalancefor<>0  or fbeginbalancelocal<>0  or fyeardebitlocal<>0  or fyearcreditlocal<>0 \t\t\t\t\t").append(" or fdebitlocal<>0  or fcreditlocal<>0  or fendbalancelocal<>0  or fbeginbalancerpt<>0 \t\t\t\t\t\t").append(" or fyeardebitrpt<>0  or fyearcreditrpt<>0  or fdebitrpt<>0  or fcreditrpt<>0  or fendbalancerpt<>0\t\t\t\t").append(" or fyearpnlfor<>0  or fmonthpnlfor<>0  or fyearpnllocal<>0  or fmonthpnllocal<>0  or fyearpnlrpt<>0  or fmonthpnlrpt<>0\t").append(" or fbeginqty<>0  or fyeardebitqty<>0  or fyearcreditqty<>0  or fdebitqty<>0  or fcreditqty<>0  or fendqty<>0 \t\t\t").append(");");
            String selectAssistBalanceAccount = sql.toString();
            stmt = con.prepareStatement(selectAssistBalanceAccount);
            rs = stmt.executeQuery();
            while (rs != null && rs.next()) {
                String accountID = rs.getString("FAccountID");
                noDealAccountIDSet.remove(accountID);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql = new StringBuffer();
            sql.append(" select distinct a.fkey from t_gl_flag a  \t\t\t\t\t\t\t\t \t\t\t\r\n");
            sql.append("\twhere a.fvalue='true' and a.fname='astinit' and a.fkey in(").append(idSet.toString()).append(") ");
            String selectGlFlagAccountSql = sql.toString();
            stmt = con.prepareStatement(selectGlFlagAccountSql);
            rs = stmt.executeQuery();
            while (rs != null && rs.next()) {
                String accountID = rs.getString("fkey");
                noDealAccountIDSet.remove(accountID);
            }
        }
        catch (SQLDataException sqle) {
            try {
                sqle.printStackTrace();
                throw new BizHasDealException(BizHasDealException.SQL_ERR, (Throwable)sqle);
                catch (SQLException sqle2) {
                    sqle2.printStackTrace();
                    throw new BizHasDealException(BizHasDealException.SQL_ERR, (Throwable)sqle2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return noDealAccountIDSet;
    }

    protected Set _getNoDealAccountIDSetBAK(Context ctx, BOSUuid companyID, BOSUuid accountTableID) throws BOSException, EASBizException {
        HashSet<String> noDealAccountIDSet = new HashSet<String>();
        if (companyID == null || accountTableID == null) {
            return noDealAccountIDSet;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyID.toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableID.toString()));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)new Boolean(false)));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)new Boolean(false)));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        view.setSelector(selector);
        AccountViewCollection accountViewCollection = this.getAccountViewCollection(ctx, view);
        if (accountViewCollection == null || accountViewCollection.size() == 0) {
            return noDealAccountIDSet;
        }
        AccountViewInfo accountViewInfo = null;
        boolean checkResult = false;
        int count = accountViewCollection.size();
        for (int i = 0; i < count; ++i) {
            checkResult = false;
            accountViewInfo = accountViewCollection.get(i);
            checkResult = this.isHasDeal(ctx, (IObjectPK)new ObjectUuidPK(accountViewInfo.getId()));
            if (checkResult) continue;
            noDealAccountIDSet.add(accountViewInfo.getId().toString());
        }
        return noDealAccountIDSet;
    }

    private BizCheckResult checkIsAccountHasDeal(Context ctx, AccountViewCollection accountViewColl, BOSUuid currentCompany, BOSUuid accountTable) throws BOSException, EASBizException {
        BizCheckResult checkResult = BizCheckResult.NOTFOUND;
        if (accountViewColl == null || accountViewColl.size() == 0 || currentCompany == null || accountTable == null) {
            return checkResult;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("id");
        view.setSelector(coll);
        FilterInfo filter = new FilterInfo();
        StringBuffer maskString = new StringBuffer();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)accountTable.toString()));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Boolean(true)));
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentCompany));
        filter.getFilterItems().add(new FilterItemInfo("companyID.longNumber", (Object)companyOrgUnitInfo.getLongNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyID.longNumber", (Object)(companyOrgUnitInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("companyID.isLeaf", (Object)new Boolean(true)));
        maskString.append("(#0 and #1 and ((#2 or #3) and #4) and (");
        int index = 5;
        String lastNumber = "9999999999";
        int count = accountViewColl.size();
        for (int i = 0; i < count; ++i) {
            AccountViewInfo acctInfo = accountViewColl.get(i);
            String number = acctInfo.getNumber();
            if (number.indexOf(lastNumber, 0) == 0) continue;
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)(number + "%"), CompareType.LIKE));
            if (i > 0) {
                maskString.append(" or ");
            }
            lastNumber = number;
            maskString.append(" #" + index++);
        }
        maskString.append("))");
        filter.setMaskString(maskString.toString());
        AccountViewCollection accountViewCollection = this.getAccountViewCollection(ctx, view);
        checkResult = AccountTools.hasDeal(ctx, accountViewCollection);
        if (checkResult instanceof AccountCheckResult) {
            this.checkerName = ((AccountCheckResult)checkResult).getCheckerName();
            this.accountCheck = checkResult;
        }
        if (checkResult.isFound()) {
            return checkResult;
        }
        checkResult = AccountTools.isReferenced(ctx, accountViewCollection);
        if (checkResult.isFound()) {
            return checkResult;
        }
        return checkResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Set _getNoDealAccountNumberSet(Context ctx, BOSUuid companyID, BOSUuid accountTableID) throws BOSException, EASBizException {
        HashSet<String> noDealAccountNumberSet = new HashSet<String>();
        if (companyID == null) return noDealAccountNumberSet;
        if (accountTableID == null) {
            return noDealAccountNumberSet;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyID.toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableID.toString()));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)new Boolean(false)));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)new Boolean(false)));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        view.setSelector(selector);
        SorterItemCollection coll = new SorterItemCollection();
        SorterItemInfo info = new SorterItemInfo("number");
        coll.add(info);
        view.setSorter(coll);
        AccountViewCollection accountViewColl = this.getAccountViewCollection(ctx, view);
        if (accountViewColl == null) return noDealAccountNumberSet;
        if (accountViewColl.size() == 0) {
            return noDealAccountNumberSet;
        }
        int count = accountViewColl.size();
        for (int i = 0; i < count; ++i) {
            AccountViewInfo accountViewInfo = accountViewColl.get(i);
            noDealAccountNumberSet.add(accountViewInfo.getNumber());
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        view.setFilter(filter);
        StringBuffer maskString = new StringBuffer();
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)accountTableID.toString()));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Boolean(true)));
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
        filter.getFilterItems().add(new FilterItemInfo("companyID.longNumber", (Object)companyOrgUnitInfo.getLongNumber()));
        filter.getFilterItems().add(new FilterItemInfo("companyID.longNumber", (Object)(companyOrgUnitInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("companyID.isLeaf", (Object)new Boolean(true)));
        maskString.append("(#0 and #1 and ((#2 or #3) and #4) and (");
        int index = 5;
        String lastNumber = "9999999999";
        int count2 = accountViewColl.size();
        for (int i = 0; i < count2; ++i) {
            AccountViewInfo acctInfo = accountViewColl.get(i);
            String number = acctInfo.getNumber();
            if (number.indexOf(lastNumber, 0) == 0) continue;
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)(number + "%"), CompareType.LIKE));
            if (i > 0) {
                maskString.append(" or ");
            }
            lastNumber = number;
            maskString.append(" #" + index++);
        }
        maskString.append("))");
        filter.setMaskString(maskString.toString());
        selector = new SelectorItemCollection();
        selector.add("id");
        view.setSelector(selector);
        AccountViewCollection accountViewCollection = this.getAccountViewCollection(ctx, view);
        AccountViewInfo accountViewInfo = null;
        StringBuffer idSet = new StringBuffer();
        int count3 = accountViewCollection.size();
        for (int i = 0; i < count3; ++i) {
            accountViewInfo = accountViewCollection.get(i);
            if (i > 0) {
                idSet.append(",");
            }
            idSet.append("'").append(accountViewInfo.getId().toString()).append("'");
        }
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        try {
            con = DbUtil.getConn((Context)ctx);
            sql = new StringBuffer();
            sql.append(" select distinct av.fnumber ");
            sql.append(" from t_gl_VoucherEntry ve left outer join t_bd_accountview av on ve.FAccountID = av.fid ");
            sql.append(" where ve.FAccountID in (").append(idSet.toString()).append("); \t\r\n");
            String selectVoucherAccountSql = sql.toString();
            stmt = con.prepareStatement(selectVoucherAccountSql);
            rs = stmt.executeQuery();
            while (rs != null && rs.next()) {
                String accountNumber = rs.getString("fnumber");
                noDealAccountNumberSet.remove(accountNumber);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql = new StringBuffer();
            sql.append(" select distinct av.fnumber ");
            sql.append(" from t_gl_InitAccountBalance bal left outer join t_bd_accountview av on bal.FAccountID = av.fid ");
            sql.append(" where bal.FAccountID in (").append(idSet.toString()).append(") ");
            sql.append(" and (fbeginbalancefor<>0 or fyeardebitfor<>0 or fyearcreditfor<>0  or fdebitfor<>0  or fcreditfor<>0 ").append(" or fendbalancefor<>0  or fbeginbalancelocal<>0  or fyeardebitlocal<>0  or fyearcreditlocal<>0 ").append(" or fdebitlocal<>0  or fcreditlocal<>0  or fendbalancelocal<>0  or fbeginbalancerpt<>0 ").append(" or fyeardebitrpt<>0  or fyearcreditrpt<>0  or fdebitrpt<>0  or fcreditrpt<>0  or fendbalancerpt<>0 ").append(" or fyearpnlfor<>0  or fmonthpnlfor<>0  or fyearpnllocal<>0  or fmonthpnllocal<>0  or fyearpnlrpt<>0  or fmonthpnlrpt<>0 ").append(" or fbeginqty<>0  or fyeardebitqty<>0  or fyearcreditqty<>0  or fdebitqty<>0  or fcreditqty<>0  or fendqty<>0 ); ");
            String selectInitAccountBalanceAccountSql = sql.toString();
            stmt = con.prepareStatement(selectInitAccountBalanceAccountSql);
            rs = stmt.executeQuery();
            while (rs != null && rs.next()) {
                String accountNumber = rs.getString("fnumber");
                noDealAccountNumberSet.remove(accountNumber);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql = new StringBuffer();
            sql.append(" select distinct av.fnumber ");
            sql.append(" from t_gl_InitAssistBalance bal left outer join t_bd_accountview av on bal.FAccountID = av.fid ");
            sql.append(" where bal.FAccountID in (").append(idSet.toString()).append(") ");
            sql.append(" and (fbeginbalancefor<>0 or fyeardebitfor<>0 or fyearcreditfor<>0 or fdebitfor<>0  or fcreditfor<>0 ").append(" or fendbalancefor<>0  or fbeginbalancelocal<>0  or fyeardebitlocal<>0  or fyearcreditlocal<>0 ").append(" or fdebitlocal<>0  or fcreditlocal<>0  or fendbalancelocal<>0  or fbeginbalancerpt<>0 ").append(" or fyeardebitrpt<>0  or fyearcreditrpt<>0  or fdebitrpt<>0  or fcreditrpt<>0  or fendbalancerpt<>0 ").append(" or fyearpnlfor<>0  or fmonthpnlfor<>0  or fyearpnllocal<>0  or fmonthpnllocal<>0  or fyearpnlrpt<>0  or fmonthpnlrpt<>0 ").append(" or fbeginqty<>0  or fyeardebitqty<>0  or fyearcreditqty<>0  or fdebitqty<>0  or fcreditqty<>0  or fendqty<>0 ); ");
            String selectInitAssistBalanceAccountSql = sql.toString();
            stmt = con.prepareStatement(selectInitAssistBalanceAccountSql);
            rs = stmt.executeQuery();
            while (rs != null && rs.next()) {
                String accountNumber = rs.getString("fnumber");
                noDealAccountNumberSet.remove(accountNumber);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        }
        catch (SQLDataException sqle) {
            try {
                sqle.printStackTrace();
                throw new BizHasDealException(BizHasDealException.SQL_ERR, (Throwable)sqle);
                catch (SQLException sqle2) {
                    sqle2.printStackTrace();
                    throw new BizHasDealException(BizHasDealException.SQL_ERR, (Throwable)sqle2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return noDealAccountNumberSet;
    }

    @Override
    protected Map _batchEnable(Context ctx, List ids) throws BOSException, EASBizException {
        AccountViewInfo account = null;
        StringBuffer sucNumber = new StringBuffer();
        StringBuffer failMsg = new StringBuffer();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add("isGFreeze");
        sic.add("isParentFreeze");
        for (int i = 0; i < ids.size(); ++i) {
            String id = (String)ids.get(i);
            account = (AccountViewInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), sic);
            try {
                this.enableAccount(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                if (account.isIsGFreeze()) {
                    if (failMsg.length() > 0) {
                        failMsg.append(",");
                    }
                    failMsg.append(account.getNumber());
                } else if (account.isIsParentFreeze()) {
                    if (failMsg.length() > 0) {
                        failMsg.append(",");
                    }
                    failMsg.append(account.getNumber());
                }
                if (sucNumber.length() > 0) {
                    sucNumber.append("\u3001");
                }
                sucNumber.append(account.getNumber());
                continue;
            }
            catch (EASBizException ex) {
                String msg2 = ex.getMessage();
                if (failMsg.length() > 0) {
                    failMsg.append("\n\r");
                }
                failMsg.append(account.getNumber()).append(msg2);
            }
        }
        HashMap<String, StringBuffer> result = new HashMap<String, StringBuffer>();
        result.put("sucNumber", sucNumber);
        result.put("failMsg", failMsg);
        return result;
    }

    @Override
    protected Map _batchDisable(Context ctx, List ids) throws BOSException, EASBizException {
        AccountViewInfo account = null;
        StringBuffer sucNumber = new StringBuffer();
        StringBuffer failMsg = new StringBuffer();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        for (int i = 0; i < ids.size(); ++i) {
            String id = (String)ids.get(i);
            account = (AccountViewInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), sic);
            try {
                this.disableAccount(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                if (sucNumber.length() > 0) {
                    sucNumber.append("\u3001");
                }
                sucNumber.append(account.getNumber());
                continue;
            }
            catch (EASBizException ex) {
                String msg2 = ex.getMessage();
                if (failMsg.length() > 0) {
                    failMsg.append("\n\r");
                }
                failMsg.append(account.getNumber()).append(msg2);
            }
        }
        HashMap<String, StringBuffer> result = new HashMap<String, StringBuffer>();
        result.put("sucNumber", sucNumber);
        result.put("failMsg", failMsg);
        return result;
    }

    @Override
    protected void _updateIsUpperAllowCA(Context ctx, String companyId, AccountViewCollection accountViewCollection) throws BOSException, EASBizException {
        String sql1 = "update t_bd_accountview set fisUpperAllowCA = 1 where FCompanyID = ? and faccounttableid = ? and fnumber = ?;";
        String sql2 = "update t_bd_accountview set FIsAllowCA = 0, fisUpperAllowCA = 0 where FCompanyID = ? and faccounttableid = ? and fnumber = ?;";
        int count = accountViewCollection.size();
        for (int i = 0; i < count; ++i) {
            AccountViewInfo accountViewInfo = accountViewCollection.get(i);
            if (accountViewInfo.isIsUpperAllowCA()) {
                com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql1, (Object[])new Object[]{companyId, accountViewInfo.getAccountTableID().getId().toString(), accountViewInfo.getNumber()});
                continue;
            }
            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{companyId, accountViewInfo.getAccountTableID().getId().toString(), accountViewInfo.getNumber()});
        }
        String subCUsql = "select fid from T_ORG_CtrlUnit where FParentID = ?";
        IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)subCUsql, (Object[])new Object[]{companyId});
        try {
            while (rs != null && rs.next()) {
                String subCU = rs.getString("fid");
                this._updateIsUpperAllowCA(ctx, subCU, accountViewCollection);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _isHasDealAndHasInferior(Context ctx, IObjectValue accountViewInfo) throws BOSException, EASBizException {
        AccountViewInfo info = (AccountViewInfo)accountViewInfo;
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        boolean isHasDeal = this._isHasDeal(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
        resultMap.put("isHasDeal", new Boolean(isHasDeal));
        boolean isHasInferior = this._checkAccountHasInferior(ctx, (IObjectValue)info);
        resultMap.put("isHasInferior", new Boolean(isHasInferior));
        return resultMap;
    }

    protected boolean _accountContrastSwap(Context ctx, IObjectPK companyID, IObjectPK oldAccountTableID, IObjectPK newAccountTableID) throws BOSException, EASBizException {
        if (oldAccountTableID == null) {
            return false;
        }
        AccountRefContrastProcess helper = new AccountRefContrastProcess();
        return helper.enableTable(ctx, companyID.toString(), oldAccountTableID.toString(), newAccountTableID.toString());
    }

    @Override
    protected List _getCurrentCompanyAccountTable(Context ctx, String companyId) throws BOSException, EASBizException {
        ArrayList<String> tableIdList = new ArrayList<String>();
        IAccount_Control acctCtrl = Account_ControlFactory.getLocalInstance(ctx);
        EntityViewInfo eviForCtrl = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)companyId));
        eviForCtrl.setFilter(filter);
        eviForCtrl.getSelector().add("accountTableID.*");
        eviForCtrl.getSelector().add("accountTableID.userLevel.*");
        Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(eviForCtrl);
        if (acctCtrlCols != null) {
            int count = acctCtrlCols.size();
            for (int i = 0; i < count; ++i) {
                Account_ControlInfo acctCtrlInfo = acctCtrlCols.get(i);
                tableIdList.add(acctCtrlInfo.getAccountTableID().getId().toString());
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("userLevel.*"));
        IAccountTable iAccountTable = AccountTableFactory.getLocalInstance(ctx);
        AccountTableCollection tableInfos = iAccountTable.getAccountTableCollection(evi);
        Iterator ter = tableInfos.iterator();
        ArrayList<AccountTableInfo> currCompanyAccountTableList = new ArrayList<AccountTableInfo>();
        while (ter.hasNext()) {
            AccountTableInfo tableInfo = (AccountTableInfo)ter.next();
            if (!tableIdList.contains(tableInfo.getId().toString())) continue;
            currCompanyAccountTableList.add(tableInfo);
        }
        return currCompanyAccountTableList;
    }

    @Override
    protected IObjectCollection _getOrgUnitInfosByType(Context ctx, IObjectPK userPK, OrgType orgType, String permissionItem) throws BOSException, EASBizException {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection orgs = new OrgUnitCollection();
        IPermission permission = null;
        FullOrgUnitCollection result = null;
        permission = PermissionFactory.getLocalInstance((Context)ctx);
        result = permission.getAuthorizedOrg(userPK, orgType, null, permissionItem);
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            orgs.add((OrgUnitInfo)fullInfo);
        }
        OrgUnitCollection results = new OrgUnitCollection();
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("isLeaf"));
        selector.add(new SelectorItemInfo("CU.*"));
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("accountTable"));
        selector.add(new SelectorItemInfo("longNumber"));
        view.setSelector(selector);
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                results.add((OrgUnitInfo)collection.get(i));
            }
        }
        return results;
    }

    @Override
    protected String _chkInfeParentCashFlow(Context ctx, IObjectValue acctInfo) throws BOSException, EASBizException {
        AccountViewInfo accountviewInfo = (AccountViewInfo)acctInfo;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("upper", (Object)accountviewInfo.getParent().getId().toString()));
        SelectorItemCollection seletorColl = new SelectorItemCollection();
        seletorColl.add(new SelectorItemInfo("id"));
        seletorColl.add(new SelectorItemInfo("name"));
        seletorColl.add(new SelectorItemInfo("number"));
        seletorColl.add(new SelectorItemInfo("borrowerMainCashFlowItem"));
        seletorColl.add(new SelectorItemInfo("borrowerAttCashFlowItem"));
        seletorColl.add(new SelectorItemInfo("lenderMainCashFlowItem"));
        seletorColl.add(new SelectorItemInfo("lenderAttCashFlowItem"));
        seletorColl.add(new SelectorItemInfo("companyID.number"));
        seletorColl.add(new SelectorItemInfo("companyID.name"));
        view.setSelector(seletorColl);
        view.setFilter(filterInfo);
        AccountViewCollection acctColl = this.getAccountsByDAO(ctx, view);
        if (acctColl != null && acctColl.size() > 0) {
            StringBuffer msg = new StringBuffer();
            for (int i = 0; i < acctColl.size(); ++i) {
                AccountViewInfo infeParentInfo = acctColl.get(i);
                AccountViewInfo parentInfo = accountviewInfo.getParent();
                if (parentInfo.getBorrowerMainCashFlowItem() == null && infeParentInfo != null && infeParentInfo.getBorrowerMainCashFlowItem() != null && accountviewInfo.getBorrowerMainCashFlowItem() != null && !infeParentInfo.getBorrowerMainCashFlowItem().getId().toString().equals(accountviewInfo.getBorrowerMainCashFlowItem().getId().toString())) {
                    msg.append(infeParentInfo.getCompanyID().getNumber() + "--" + infeParentInfo.getCompanyID().getName() + ",");
                }
                if (parentInfo.getBorrowerAttCashFlowItem() == null && infeParentInfo != null && infeParentInfo.getBorrowerAttCashFlowItem() != null && accountviewInfo.getBorrowerAttCashFlowItem() != null && !infeParentInfo.getBorrowerAttCashFlowItem().getId().toString().equals(accountviewInfo.getBorrowerAttCashFlowItem().getId().toString())) {
                    msg.append(infeParentInfo.getCompanyID().getNumber() + "--" + infeParentInfo.getCompanyID().getName() + ",");
                }
                if (parentInfo.getLenderMainCashFlowItem() == null && infeParentInfo != null && infeParentInfo.getLenderMainCashFlowItem() != null && accountviewInfo.getLenderMainCashFlowItem() != null && !infeParentInfo.getLenderMainCashFlowItem().getId().toString().equals(accountviewInfo.getLenderMainCashFlowItem().getId().toString())) {
                    msg.append(infeParentInfo.getCompanyID().getNumber() + "--" + infeParentInfo.getCompanyID().getName() + ",");
                }
                if (parentInfo.getLenderAttCashFlowItem() != null || infeParentInfo == null || infeParentInfo.getLenderAttCashFlowItem() == null || accountviewInfo.getLenderAttCashFlowItem() == null || infeParentInfo.getLenderAttCashFlowItem().getId().toString().equals(accountviewInfo.getLenderAttCashFlowItem().getId().toString())) continue;
                msg.append(infeParentInfo.getCompanyID().getNumber() + "--" + infeParentInfo.getCompanyID().getName() + ",");
            }
            if (!StringUtils.isEmpty((String)msg.toString())) {
                return msg.toString().substring(0, msg.toString().length() - 1);
            }
        }
        return null;
    }

    @Override
    protected boolean _isAllHasSameAsst(Context ctx, ArrayList idList) throws BOSException, EASBizException {
        if (idList.size() < 2) {
            return false;
        }
        String id = idList.get(0).toString();
        AccountViewInfo firstAcctInfo = (AccountViewInfo)AccountViewFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(id));
        for (int i = 1; i < idList.size(); ++i) {
            id = idList.get(i).toString();
            AccountViewInfo acctInfo = (AccountViewInfo)AccountViewFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(id));
            if (firstAcctInfo.getCAA() == null && acctInfo.getCAA() == null || firstAcctInfo.getCAA() != null && acctInfo.getCAA() != null && firstAcctInfo.getCAA().getId().toString().equals(acctInfo.getCAA().getId().toString())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void _updateCashFlowItem(Context ctx, IObjectValue acctInfo) throws BOSException, EASBizException {
        AccountViewInfo accountviewInfo = (AccountViewInfo)acctInfo;
        if (accountviewInfo == null) {
            return;
        }
        String fid = accountviewInfo.getId().toString();
        String sql = "update t_bd_accountview set FBorrowerMainCashFlowItemID = null,FBorrowerAttCashFlowItemID =null,FLenderMainCashFlowItemID =null,FLenderAttCashFlowItemID =null where fid=?";
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{fid});
    }

    private boolean isCUBDAllowEdit(Context ctx, AccountViewInfo acctInfo) throws BOSException, EASBizException {
        boolean isAllowEdit = true;
        ICUBDControl cubdControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        try {
            CUBDControlInfo cubdControlInfo = cubdControl.getBDCtrlInfo(acctInfo.getBOSType().toString(), acctInfo.getCU().getId().toString());
            isAllowEdit = cubdControlInfo.isIsSubordinateEditable();
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return isAllowEdit;
    }

    private boolean isCUBDAllowAddnew(Context ctx, AccountViewInfo acctInfo) throws BOSException, EASBizException {
        boolean isAllowAddnew = true;
        ICUBDControl cubdControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        try {
            String cuID = null;
            if (acctInfo != null && acctInfo.getCU() != null && acctInfo.getCU().getId() != null) {
                cuID = acctInfo.getCU().getId().toString();
            } else if (acctInfo != null && acctInfo.getCompanyID() != null && acctInfo.getCompanyID().getCU() != null && acctInfo.getCompanyID().getCU().getId() != null) {
                cuID = acctInfo.getCompanyID().getCU().getId().toString();
            } else if (acctInfo != null && acctInfo.getCompanyID() != null && acctInfo.getCompanyID().getCU() == null) {
                CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(acctInfo.getCompanyID().getId()));
                acctInfo.setCompanyID(companyOrgUnitInfo);
                cuID = companyOrgUnitInfo.getCU().getId().toString();
            }
            CUBDControlInfo cubdControlInfo = cubdControl.getBDCtrlInfo(acctInfo.getBOSType().toString(), cuID);
            isAllowAddnew = cubdControlInfo.isIsSubordinateAddnewable();
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return isAllowAddnew;
    }

    private boolean isCUBDAllowDelete(Context ctx, AccountViewInfo acctInfo) throws BOSException, EASBizException {
        boolean isAllowDelete = true;
        ICUBDControl cubdControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        try {
            CUBDControlInfo cubdControlInfo = cubdControl.getBDCtrlInfo(acctInfo.getBOSType().toString(), acctInfo.getCU().getId().toString());
            isAllowDelete = cubdControlInfo.isIsSubordinateDeletable();
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return isAllowDelete;
    }

    protected void checkAssignAACM(Context ctx, AccountViewInfo accountViewInfo) throws BOSException, EASBizException {
        if (accountViewInfo.getCAA() != null) {
            try {
                String fcontrolunitid;
                String sqlToGetInferiorParent = "SELECT c.fcontrolunitid from t_bd_asstactgroupdetail a,t_bd_asstacttype b ,t_bd_generalasstacttypegroup c where a.fasstacttypeid=b.fid and b.fglasstacttypegrpid=c.fid and a.fasstaccountid=? and c.fsharetactic=3 ";
                IRowSet rsToGetInferiorParent = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetInferiorParent, (Object[])new Object[]{accountViewInfo.getCAA().getId().toString()});
                if (rsToGetInferiorParent != null && rsToGetInferiorParent.next() && !(fcontrolunitid = rsToGetInferiorParent.getString("fcontrolunitid")).equalsIgnoreCase(accountViewInfo.getCU().getId().toString())) {
                    throw new AccountException(AccountException.CAAINCLUDENOTCUASST, new Object[]{accountViewInfo.getNumber()});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void updateInferiorCash(Context ctx, AccountViewInfo acctInfo) throws BOSException, EASBizException {
        IRowSet rowSet = this.getAllInferiorAcct(ctx, acctInfo);
        String sql = "";
        PreparedStatement stmt = null;
        Connection conn = null;
        if (rowSet == null || rowSet.size() <= 0) {
            return;
        }
        try {
            int isCash = acctInfo.isIsCash() ? 1 : 0;
            sql = "update t_bd_accountview set FIsCash=" + isCash + " where fid= ?";
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql);
            while (rowSet.next()) {
                stmt.setString(1, rowSet.getString("FID"));
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private void removeCache(Context ctx, String sql, BOSObjectType bostype) throws BOSException {
        IRowSet rowSet = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet != null && rowSet.size() > 0) {
            String[] pks = new String[rowSet.size()];
            int i = 0;
            try {
                while (rowSet.next()) {
                    pks[i] = rowSet.getString("fid");
                    ++i;
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            ORMValueCacheService.getInstance().removeBatch(ctx, bostype, pks);
        }
    }

    private void updateMLName(Context ctx, AccountViewInfo acctInfo, AccountViewInfo oldAcctInfo) {
        Locale locale = ctx.getLocale();
        String currentName = acctInfo.getName(locale);
        String name_l1 = acctInfo.getName(LocaleUtils.locale_l1);
        String name_l2 = acctInfo.getName(LocaleUtils.locale_l2);
        String name_l3 = acctInfo.getName(LocaleUtils.locale_l3);
        if (oldAcctInfo != null) {
            String oldName_l1 = oldAcctInfo.getName(LocaleUtils.locale_l1);
            String oldName_l2 = oldAcctInfo.getName(LocaleUtils.locale_l2);
            String oldName_l3 = oldAcctInfo.getName(LocaleUtils.locale_l3);
            if (!"l1".equals(locale.toString()) && StringUtil.isEmpty((String)name_l1) && StringUtil.isEmpty((String)oldName_l1)) {
                acctInfo.put("name_l1", currentName);
            }
            if (!"l2".equals(locale.toString()) && StringUtil.isEmpty((String)name_l2) && StringUtil.isEmpty((String)oldName_l2)) {
                acctInfo.put("name_l2", currentName);
            }
            if (!"l3".equals(locale.toString()) && StringUtil.isEmpty((String)name_l3) && StringUtil.isEmpty((String)oldName_l3)) {
                acctInfo.put("name_l3", currentName);
            }
        } else {
            if (!"l1".equals(locale.toString()) && StringUtil.isEmpty((String)name_l1)) {
                acctInfo.put("name_l1", currentName);
            }
            if (!"l2".equals(locale.toString()) && StringUtil.isEmpty((String)name_l2)) {
                acctInfo.put("name_l2", currentName);
            }
            if (!"l3".equals(locale.toString()) && StringUtil.isEmpty((String)name_l3)) {
                acctInfo.put("name_l3", currentName);
            }
        }
    }

    private void checkAccountIsEnableRef(Context ctx, List ids) throws BOSException, EASBizException {
        IAccountRefContrastEntry accountRefContrastEntryService = AccountRefContrastEntryFactory.getLocalInstance(ctx);
        StringBuilder message = new StringBuilder();
        String sql = "select FAcctRefContrastID,FOldAcctID,FNewAcctID from T_BD_AcctRefContrastEntry ";
        ArrayList<String[]> results = new ArrayList<String[]>();
        if (ids != null && ids.size() > 0) {
            int i;
            int page = ids.size() / 999;
            int left = ids.size() % 999;
            StringBuilder where = new StringBuilder();
            where.append(" where FNewAcctID in ");
            if (page == 0) {
                where.append("(");
                for (i = 0; i < ids.size(); ++i) {
                    where.append("?");
                    if (i == ids.size() - 1) continue;
                    where.append(",");
                }
                where.append(")");
            } else {
                for (i = 0; i < page; ++i) {
                    where.append("(");
                    for (int j = 0; j < 999; ++j) {
                        where.append("?");
                        if (j == ids.size() - 1) continue;
                        where.append(",");
                    }
                    where.append(") ");
                    if (i == page - 1) continue;
                    where.append(" or FNewAcctID in ");
                }
                if (left != 0) {
                    where.append(" or FNewAcctID in (");
                    for (i = 0; i < ids.size(); ++i) {
                        where.append("?");
                        if (i == ids.size() - 1) continue;
                        where.append(",");
                    }
                    where.append(")");
                }
            }
            sql = sql + where.toString();
            IRowSet rowSet = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])ids.toArray());
            try {
                while (rowSet.next()) {
                    String[] _item = new String[]{rowSet.getString("FAcctRefContrastID"), rowSet.getString("FOldAcctID"), rowSet.getString("FNewAcctID")};
                    results.add(_item);
                }
            }
            catch (SQLException e) {
                logger.error((Object)"\u67e5\u8be2\u79d1\u76ee\u5bf9\u7167\u5206\u5f55\u51fa\u9519", (Throwable)e);
            }
        }
        IAccountView accountViewService = AccountViewFactory.getLocalInstance(ctx);
        IAccountRefContrast accountRefContrastService = AccountRefContrastFactory.getLocalInstance(ctx);
        IAccountTable accountTableService = AccountTableFactory.getLocalInstance(ctx);
        if (results != null) {
            for (int i = 0; i < results.size(); ++i) {
                String[] item = (String[])results.get(i);
                String destinationAccountID = item[2];
                if (destinationAccountID == null) continue;
                AccountViewInfo destinationAccount = accountViewService.getAccountViewInfo((IObjectPK)new ObjectUuidPK(destinationAccountID));
                AccountRefContrastInfo accountRefContrastInfo = accountRefContrastService.getAccountRefContrastInfo((IObjectPK)new ObjectUuidPK(item[0]));
                AccountTableInfo enabledAccountTableInfo = accountRefContrastInfo.getEnabledAcctTable();
                String enabledAccountTableInfoID = enabledAccountTableInfo.getId().toString();
                enabledAccountTableInfo = accountTableService.getAccountTableInfo((IObjectPK)new ObjectUuidPK(enabledAccountTableInfoID));
                message.append(destinationAccount.getNumber()).append("-").append(enabledAccountTableInfo.getName());
                if (i == results.size() - 1) continue;
                message.append(",");
            }
            if (message.length() > 0) {
                throw new AccountException(AccountException.DISABLE_ACCOUNTREF_NOT_ALLOWED, new Object[]{message.toString()});
            }
        }
    }

    private void setHasUserProperty(Context ctx, AccountViewInfo acctInfo) throws BOSException {
        boolean isFinalnode = false;
        boolean isHasUserProperty = false;
        AccountViewInfo parentInfo = acctInfo.getParent();
        if (parentInfo == null || "".equals(parentInfo)) {
            return;
        }
        isHasUserProperty = parentInfo.isHasUserProperty();
        String parentID = parentInfo.getId().toString();
        String acctTableID = acctInfo.getAccountTableID().getId().toString();
        String selectIDSql = " select fid from t_bd_accountview where fparentid = '" + parentID + "'  and faccounttableid = '" + acctTableID + "'";
        IRowSet idRs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)selectIDSql);
        this.removeCache(ctx, selectIDSql, acctInfo.getBOSType());
        if (idRs.size() == 0) {
            isFinalnode = true;
        }
        if (isHasUserProperty && isFinalnode) {
            acctInfo.setHasUserProperty(true);
        }
    }

    @Override
    public String _getAccountViewCreateOrg(Context ctx, String accountNumber, String accountType) throws BOSException, EASBizException {
        String orgId = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FCOMPANYID FROM T_BD_ACCOUNTVIEW WHERE FUPPERID IS NULL AND FNUMBER =?  AND FACCOUNTTYPEID =?");
        try {
            IRowSet rowSet = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{accountNumber, accountType});
            while (rowSet.next()) {
                orgId = rowSet.getString("FCOMPANYID");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return orgId;
    }

    protected void verify(Context ctx, AccountViewInfo info, AccountViewCollection acctForDeleteCon, CompanyOrgUnitInfo currentCompany, AccountTableInfo accountTable, boolean isAssigned) throws BOSException, EASBizException {
        if (acctForDeleteCon == null || acctForDeleteCon.size() == 0 || currentCompany == null || accountTable == null) {
            return;
        }
        try {
            StringBuffer idSet = new StringBuffer();
            int count = acctForDeleteCon.size();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    idSet.append(",");
                }
                idSet.append("'").append(acctForDeleteCon.get(i).getId().toString()).append("'");
            }
            String sqlToGetRefByAccount = "SELECT TOP 1 fid FROM T_BD_ACCOUNTVIEW WHERE FUPPERID ='" + info.getId().toString() + "' and faccounttableid=? order by fnumber";
            IRowSet rsToGetRefByAccount = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetRefByAccount, (Object[])new Object[]{accountTable.getId().toString()});
            if (rsToGetRefByAccount != null && rsToGetRefByAccount.next()) {
                String acctid = rsToGetRefByAccount.getString("fid");
                String sqlToGetAcctInfo = "SELECT ACCT.FNUMBER AS acctno, COMPANY.FNUMBER as companyno FROM T_BD_ACCOUNTVIEW ACCT JOIN T_ORG_Company COMPANY ON ACCT.FCompanyID = COMPANY.FID AND ACCT.FID = ?";
                IRowSet rsToGetAcctInfo = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetAcctInfo, (Object[])new Object[]{acctid});
                String acctNumber = "";
                String companyNumber = "";
                try {
                    if (rsToGetAcctInfo != null && rsToGetAcctInfo.next()) {
                        acctNumber = rsToGetAcctInfo.getString("acctno");
                        companyNumber = rsToGetAcctInfo.getString("companyno");
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (isAssigned) {
                    throw new AccountException(AccountException.ACCOUNT_ASSIGNED, new Object[]{acctNumber, companyNumber});
                }
                throw new AccountException(AccountException.ACCOUNT_REFERED, new Object[]{acctNumber, companyNumber});
            }
            sqlToGetRefByAccount = "SELECT TOP 1 fid FROM T_BD_ACCOUNTVIEW WHERE FParentID ='" + info.getId().toString() + "' and fid not in (" + idSet.toString() + ") and faccounttableid=? order by fnumber";
            rsToGetRefByAccount = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetRefByAccount, (Object[])new Object[]{accountTable.getId().toString()});
            if (rsToGetRefByAccount != null && rsToGetRefByAccount.next()) {
                String acctid = rsToGetRefByAccount.getString("fid");
                String sqlToGetAcctInfo = "SELECT parentAccount.fnumber as parentnumber, ACCT.FNUMBER AS acctno, COMPANY.FNUMBER as companyno FROM T_BD_ACCOUNTVIEW ACCT left outer JOIN T_ORG_Company COMPANY ON ACCT.FCompanyID = COMPANY.FID left outer join T_BD_ACCOUNTVIEW parentAccount on ACCT.fparentid = parentAccount.fid where ACCT.FID = ?";
                IRowSet rsToGetAcctInfo = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetAcctInfo, (Object[])new Object[]{acctid});
                String parentAcctNumber = "";
                String acctNumber = "";
                String companyNumber = "";
                try {
                    if (rsToGetAcctInfo != null && rsToGetAcctInfo.next()) {
                        parentAcctNumber = rsToGetAcctInfo.getString("parentnumber");
                        acctNumber = rsToGetAcctInfo.getString("acctno");
                        companyNumber = rsToGetAcctInfo.getString("companyno");
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (isAssigned) {
                    throw new AccountException(AccountException.ACCOUNT_HAS_CHILD, new Object[]{companyNumber, parentAcctNumber, acctNumber});
                }
                throw new AccountException(AccountException.ACCOUNT_REFERED_HAS_CHILD, new Object[]{companyNumber, parentAcctNumber, acctNumber});
            }
            if (!currentCompany.isIsBizUnit()) {
                return;
            }
            if (!info.isIsLeaf()) {
                return;
            }
            acctForDeleteCon = new AccountViewCollection();
            acctForDeleteCon.add(info);
            BizCheckResult checkResult = this.checkIsAccountHasDeal(ctx, acctForDeleteCon, currentCompany.getId(), accountTable.getId());
            if (checkResult.isFound()) {
                String accountID;
                if (checkResult.getException() != null) {
                    checkResult.getException().printStackTrace();
                }
                if ((accountID = (String)checkResult.getDetailObject((Object)"FAccountID")) != null && accountID.trim().length() > 0) {
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add("id");
                    selector.add("number");
                    selector.add("companyid.number");
                    AccountViewInfo accountViewInfo = this.getAccountViewInfo(ctx, (IObjectPK)new ObjectUuidPK(accountID), selector);
                    if (checkResult.getException() == null) {
                        if (isAssigned) {
                            throw new AccountException(AccountException.DISASSIGN_ACCOUNT_HAS_DAEL_DETAIL, new Object[]{accountViewInfo.getNumber(), accountViewInfo.getCompanyID().getNumber(), ""});
                        }
                        throw new AccountException(AccountException.DISREFERED_ACCOUNT_HAS_DAEL_DETAIL, new Object[]{accountViewInfo.getNumber(), accountViewInfo.getCompanyID().getNumber(), ""});
                    }
                    if (isAssigned) {
                        throw new AccountException(AccountException.DISASSIGN_ACCOUNT_HAS_DAEL_DETAIL, new Object[]{accountViewInfo.getNumber(), accountViewInfo.getCompanyID().getNumber(), checkResult.getException().getMessage()});
                    }
                    throw new AccountException(AccountException.DISREFERED_ACCOUNT_HAS_DAEL_DETAIL, new Object[]{accountViewInfo.getNumber(), accountViewInfo.getCompanyID().getNumber(), checkResult.getException().getMessage()});
                }
                throw new AccountException(AccountException.DISASSIGN_ACCOUNT_HAS_DAEL);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _isHasDealAllChildren(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean ret = false;
        if (pk.toString().length() > 0) {
            try {
                String sqlToAcctInfo = "SELECT TOP 1 FNUMBER,FCONTROLUNITID,FCompanyID,FACCOUNTTABLEID FROM T_BD_ACCOUNTVIEW WHERE FID=?";
                IRowSet rsToAcctInfo = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToAcctInfo, (Object[])new Object[]{pk.toString()});
                if (rsToAcctInfo.next()) {
                    AccountViewInfo acctInfo = new AccountViewInfo();
                    acctInfo.setId(BOSUuid.read((String)pk.toString()));
                    acctInfo.setNumber(rsToAcctInfo.getString("FNUMBER"));
                    CtrlUnitInfo cu = new CtrlUnitInfo();
                    cu.setId(BOSUuid.read((String)rsToAcctInfo.getString("FCONTROLUNITID")));
                    acctInfo.setCU(cu);
                    CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)rsToAcctInfo.getString("FCompanyID")));
                    acctInfo.setCompanyID(company);
                    AccountTableInfo acctTable = new AccountTableInfo();
                    acctTable.setId(BOSUuid.read((String)rsToAcctInfo.getString("FACCOUNTTABLEID")));
                    acctInfo.setAccountTableID(acctTable);
                    ret = this.checkHasDealAllChildren(ctx, acctInfo);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return ret;
    }

    private boolean checkHasDealAllChildren(Context ctx, AccountViewInfo acctInfo) throws BOSException, EASBizException {
        boolean ret = false;
        if (acctInfo != null) {
            BizCheckResult accountCheckResult;
            CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(acctInfo.getCompanyID().getId()));
            AccountViewCollection accountViewCollection = new AccountViewCollection();
            if (companyOrgUnitInfo != null && companyOrgUnitInfo.isIsBizUnit()) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection coll = new SelectorItemCollection();
                coll.add("id");
                view.setSelector(coll);
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctInfo.getAccountTableID().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)acctInfo.getNumber()));
                filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)("%" + acctInfo.getNumber() + "!%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("companyID.isBizUnit", (Object)new Boolean(true)));
                filter.getFilterItems().add(new FilterItemInfo("companyID.longNumber", (Object)companyOrgUnitInfo.getLongNumber()));
                filter.setMaskString("#0 and (#1 or #2) and #3 and #4");
                accountViewCollection = this.getAccountViewCollection(ctx, view);
            } else {
                String selSql = "SELECT  acct.FID  FROM ( select *    from T_BD_ACCOUNTVIEW acct   where acct.FACCOUNTTABLEID = ?  AND acct.FNUMBER =? AND acct.FUPPERID IS NOT NULL UNION select /*+ INDEX(acct IX_ACCTVIEW_LNUM) */ * from T_BD_ACCOUNTVIEW acct where acct.FACCOUNTTABLEID = ?   AND acct.FLONGNUMBER LIKE ? AND acct.FUPPERID IS NOT NULL) acct LEFT OUTER JOIN T_ORG_COMPANY com ON acct.FCOMPANYID= com.FID WHERE com.FISBIZUNIT= 1 AND com.FLONGNUMBER LIKE ? ";
                IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)selSql, (Object[])new Object[]{acctInfo.getAccountTableID().getId().toString(), acctInfo.getNumber(), acctInfo.getAccountTableID().getId().toString(), acctInfo.getLongNumber() + "!%", companyOrgUnitInfo.getLongNumber() + "!%"});
                try {
                    while (rs.next()) {
                        AccountViewInfo account = new AccountViewInfo();
                        String id = rs.getString("FID");
                        account.setId(BOSUuid.read((String)id));
                        accountViewCollection.add(account);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
            }
            if (accountViewCollection.size() == 0) {
                return ret;
            }
            AccountViewCollection tempCollection = new AccountViewCollection();
            for (int i = 0; i < accountViewCollection.size(); ++i) {
                tempCollection.add(accountViewCollection.get(i));
                if (tempCollection.size() != 5) continue;
                accountCheckResult = AccountTools.hasDeal(ctx, tempCollection);
                if (accountCheckResult.isFound()) {
                    return true;
                }
                accountCheckResult = AccountTools.isReferenced(ctx, accountViewCollection);
                if (accountCheckResult.isFound()) {
                    return true;
                }
                tempCollection = new AccountViewCollection();
            }
            if (tempCollection.size() != 0) {
                accountCheckResult = AccountTools.hasDeal(ctx, tempCollection);
                if (accountCheckResult.isFound()) {
                    return true;
                }
                accountCheckResult = AccountTools.isReferenced(ctx, accountViewCollection);
                if (accountCheckResult.isFound()) {
                    return true;
                }
            }
        }
        return ret;
    }

    @Override
    protected List _checkUnAssign(Context ctx, String upperId, List companyIdList) throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isEmpty((String)upperId) || companyIdList == null || companyIdList.size() == 0) {
            return list;
        }
        this.checkSqlInner(upperId);
        this.checkSqlInner(companyIdList);
        IAccountView iAccountView = AccountViewFactory.getLocalInstance(ctx);
        AccountViewCollection avCollection = iAccountView.getAccountViewCollection("select id,name,number,isLeaf,CAA.id,parent.id,parent.CAA.id,companyID.id,companyID.number,companyID.name,companyID.isBizUnit,companyID.isLeaf where upper.id = '" + upperId + "' and companyID.id in (" + this.listToSqlArrays(companyIdList) + ")");
        for (int i = 0; i < avCollection.size(); ++i) {
            AccountViewInfo info = avCollection.get(i);
            if (!info.isIsLeaf() || !info.getCompanyID().isIsBizUnit()) continue;
            boolean hasParent = false;
            try {
                hasParent = this.hasParent(ctx, info);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            boolean refered = this.checkHasDeal(ctx, info);
            if (!hasParent || !refered) continue;
            list.add(info.getCompanyID().getNumber() + " - " + info.getCompanyID().getName());
        }
        return list;
    }

    private boolean checkHasDeal(Context ctx, AccountViewInfo info) throws EASBizException {
        AccountViewCollection accountViewCollection = new AccountViewCollection();
        accountViewCollection.add(info);
        BizCheckResult accountCheckResult = AccountTools.hasDeal(ctx, accountViewCollection);
        if (accountCheckResult.isFound()) {
            return true;
        }
        BizCheckResult bizCheckResult = AccountTools.isReferenced(ctx, accountViewCollection);
        return bizCheckResult.isFound();
    }

    @Override
    protected List _unAssign(Context ctx, String upperId, List companyIdList) throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isEmpty((String)upperId) || companyIdList == null || companyIdList.size() == 0) {
            return list;
        }
        this.checkSqlInner(upperId);
        this.checkSqlInner(companyIdList);
        AccountViewInfo accountViewInfo = this.getAccountViewInfo(ctx, (IObjectPK)new ObjectUuidPK(upperId));
        IAccountView iAccountView = AccountViewFactory.getLocalInstance(ctx);
        IAccount_Control iAccount_control = Account_ControlFactory.getLocalInstance(ctx);
        AccountViewCollection avCollection = iAccountView.getAccountViewCollection("select id,name,number,isLeaf,CAA.id,parent.id,parent.CAA.id,accountTableID.id,companyID.id,companyID.number,companyID.name,companyID.isBizUnit,companyID.isLeaf where upper.id = '" + upperId + "' and companyID.id in (" + this.listToSqlArrays(companyIdList) + ")");
        String detailLog = this.buildUnAssign(ctx, upperId, companyIdList);
        String method = ResourceBase.getString((String)RESOURCE, (String)"accountUnassign", (Locale)ctx.getLocale());
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)method, (BOSObjectType)new BOSObjectType("9DA99826"), null, (String)detailLog, (String)"bd_account_accountView_assign", (String)accountViewInfo.getCompanyID().getId().toString(), (String)method);
        block10: for (int i = 0; i < avCollection.size(); ++i) {
            String parentId;
            ObjectUuidPK pk;
            Account_ControlInfo account_controlInfo;
            AccountViewCollection acctForDeleteCon;
            block25: {
                AccountViewInfo info = avCollection.get(i);
                Account_ControlCollection aCCollection = iAccount_control.getAccount_ControlCollection("where destCompany.id = '" + info.getCompanyID().getId().toString() + "' and accountTableID.id = '" + info.getAccountTableID().getId().toString() + "'");
                if (aCCollection.size() <= 0) continue;
                acctForDeleteCon = new AccountViewCollection();
                account_controlInfo = aCCollection.get(0);
                acctForDeleteCon.add(info);
                Object curRef = null;
                Object upperRef = null;
                if (AccountTools.isInEnabledAcctRefContrast(ctx, info)) {
                    AccountException accountException = new AccountException(AccountException.ACCTINENALBEDACCTREF, new Object[]{info.getNumber()});
                    list.add(accountException.getMessage());
                    continue;
                }
                String sqlToCheckHasRefByAccount = "SELECT TOP 1 Fnumber FROM T_BD_ACCOUNTVIEW WHERE FPARENTID=? OR FUPPERID=?";
                IRowSet rsToCheckHasRefByAccount = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToCheckHasRefByAccount, (Object[])new Object[]{info.getId().toString(), info.getId().toString()});
                try {
                    if (rsToCheckHasRefByAccount != null && rsToCheckHasRefByAccount.next()) {
                        AccountException accountException = new AccountException(AccountException.DELETEACCOUNTHASREFER, new Object[]{info.getNumber()});
                        list.add(accountException.getMessage());
                        continue;
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
                pk = new ObjectUuidPK(info.getId());
                parentId = null;
                if (info.getParent() != null) {
                    parentId = info.getParent().getId().toString();
                }
                if (!info.isIsLeaf() || !info.getCompanyID().isIsBizUnit()) break block25;
                boolean hasParent = false;
                try {
                    if (parentId != null) {
                        hasParent = this.hasParent(ctx, info);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
                boolean refered = this.checkHasDeal(ctx, info);
                if (!refered) break block25;
                if (!hasParent) {
                    AccountException accountException = new AccountException(AccountException.DISASSIGN_ACCOUNT_HAS_DAEL_DETAIL, new Object[]{info.getNumber(), info.getCompanyID().getNumber(), ""});
                    list.add(accountException.getMessage());
                    continue;
                }
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("*"));
                selector.add(new SelectorItemInfo("parent.*"));
                selector.add(new SelectorItemInfo("parent.companyID.*"));
                selector.add(new SelectorItemInfo("accountCurrency.*"));
                selector.add(new SelectorItemInfo("accountTypeID.*"));
                selector.add(new SelectorItemInfo("upper.*"));
                selector.add(new SelectorItemInfo("upper.accountTypeID.*"));
                selector.add(new SelectorItemInfo("upper.accountCurrency.*"));
                AccountViewInfo parent = AccountViewFactory.getLocalInstance(ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(info.getParent().getId()), selector);
                parent.setIsLeaf(true);
                parent.setId(info.getId());
                ObjectUuidPK pPk = new ObjectUuidPK(parentId);
                Statement stmt = null;
                Connection cn = null;
                try {
                    cn = EJBFactory.getConnection((Context)ctx);
                    stmt = cn.createStatement();
                    String updateParent = " update T_BD_ACCOUNTVIEW set fnumber='*#'||fnumber,flongnumber='*#'||flongnumber where fid= '" + parentId + "' ";
                    stmt.addBatch(updateParent);
                    String updateSel = null;
                    if (parent.getParent() != null) {
                        updateSel = " update T_BD_ACCOUNTVIEW set fparentid='" + parent.getParent().getId().toString() + "',fControlLevel= " + parent.getControlLevel() + " where fid='" + pk.toString() + "' ";
                        stmt.addBatch(updateSel);
                    } else {
                        updateSel = " update T_BD_ACCOUNTVIEW set fparentid=null ,fControlLevel= " + parent.getControlLevel() + " where fid='" + pk.toString() + "' ";
                        stmt.addBatch(updateSel);
                    }
                    updateSel = "update T_BD_ACCOUNTVIEW set FUpperID='" + pk.toString() + "' where FUpperID='" + pPk.toString() + "' ";
                    stmt.addBatch(updateSel);
                    updateSel = "update T_BD_AcctRefContrastEntry set FNewAcctID='" + pk.toString() + "' where FNewAcctID='" + pPk.toString() + "' ";
                    stmt.addBatch(updateSel);
                    String deleteSql = "delete from t_bd_accountcurrency where faccountviewid='" + pPk.toString() + "' ";
                    stmt.addBatch(deleteSql);
                    String deleteVoucherEntrySql = "delete from t_gl_VoucherEntry where FAccountID ='" + pPk.toString() + "' ";
                    stmt.addBatch(deleteVoucherEntrySql);
                    String deleteInitAccountBalanceSql = "delete from t_gl_InitAccountBalance where FAccountID ='" + pPk.toString() + "' ";
                    stmt.addBatch(deleteInitAccountBalanceSql);
                    String deleteInitAssistBalanceSql = "delete from t_gl_InitAssistBalance  where FAccountID ='" + pPk.toString() + "' ";
                    stmt.addBatch(deleteInitAssistBalanceSql);
                    String accountId = pPk.toString();
                    this.removeGLBalance(stmt, "t_gl_AccountBalance_1f", accountId);
                    this.removeGLBalance(stmt, "t_gl_AccountBalance_1l", accountId);
                    this.removeGLBalance(stmt, "t_gl_AccountBalance_1r", accountId);
                    this.removeGLBalance(stmt, "t_gl_AccountBalance_5f", accountId);
                    this.removeGLBalance(stmt, "t_gl_AccountBalance_5l", accountId);
                    this.removeGLBalance(stmt, "t_gl_AccountBalance_5r", accountId);
                    this.removeGLBalance(stmt, "t_gl_AssistBalance_1f", accountId);
                    this.removeGLBalance(stmt, "t_gl_AssistBalance_1l", accountId);
                    this.removeGLBalance(stmt, "t_gl_AssistBalance_1r", accountId);
                    this.removeGLBalance(stmt, "t_gl_AssistBalance_5f", accountId);
                    this.removeGLBalance(stmt, "t_gl_AssistBalance_5l", accountId);
                    this.removeGLBalance(stmt, "t_gl_AssistBalance_5r", accountId);
                    this.removeGLBalance(stmt, "t_gl_Assistmeasurebalance_1f", accountId);
                    this.removeGLBalance(stmt, "t_gl_Assistmeasurebalance_1l", accountId);
                    this.removeGLBalance(stmt, "t_gl_Assistmeasurebalance_1r", accountId);
                    this.removeGLBalance(stmt, "t_gl_Assistmeasurebalance_5f", accountId);
                    this.removeGLBalance(stmt, "t_gl_Assistmeasurebalance_5l", accountId);
                    this.removeGLBalance(stmt, "t_gl_Assistmeasurebalance_5r", accountId);
                    String deleteFlagSql = "delete from t_gl_flag where fkey  ='" + pPk.toString() + "' ";
                    stmt.addBatch(deleteFlagSql);
                    stmt.executeBatch();
                    ORMValueCacheService.getInstance().remove(ctx, info.getBOSType(), (IObjectPK)pk);
                    ORMValueCacheService.getInstance().remove(ctx, info.getBOSType(), parentId);
                    String sql = "select fid from  T_BD_ACCOUNTVIEW  where FUpperID='" + pPk.toString() + "' ";
                    this.removeCache(ctx, sql, info.getBOSType());
                    sql = "select fid  from  T_BD_AcctRefContrastEntry where FNewAcctID='" + pPk.toString() + "' ";
                    AccountRefContrastEntryInfo contrast = new AccountRefContrastEntryInfo();
                    this.removeCache(ctx, sql, contrast.getBOSType());
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new BOSException(e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(stmt, (Connection)cn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)stmt, (Connection)cn);
                this.innerUpdate(ctx, (IObjectPK)pk, (IObjectValue)parent);
                String deleteSQL = "delete from t_bd_accountview where fid = ?";
                com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)deleteSQL, (Object[])new Object[]{pPk.toString()});
                ORMValueCacheService.getInstance().remove(ctx, info.getBOSType(), (IObjectPK)pPk);
                parentId = pk.toString();
                acctForDeleteCon.clear();
            }
            AcctRefContrastHelper.delAcctRef(ctx, pk.toString());
            this.deleteAcctCtrl(ctx, account_controlInfo);
            if (acctForDeleteCon.size() > 0) {
                this.batchCancleAssignAccount(ctx, null, null, acctForDeleteCon);
            }
            if (upperId == null || upperId.length() <= 0) continue;
            try {
                while (parentId != null && parentId.length() > 0) {
                    String sqlToGetParent = "SELECT FGLevel,FLevel,fcontrollevel,FParentID FROM T_BD_ACCOUNTVIEW WHERE FID=?";
                    IRowSet rsToGetParent = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetParent, (Object[])new Object[]{parentId});
                    if (rsToGetParent == null || !rsToGetParent.next()) continue;
                    int gLevel = rsToGetParent.getInt("FGLevel");
                    int level = rsToGetParent.getInt("FLevel");
                    int controllevel = rsToGetParent.getInt("fcontrollevel");
                    if (gLevel <= level) continue block10;
                    String sqlToGetMinGLevel = "SELECT MIN(FGLevel) MINGLEVEL FROM T_BD_ACCOUNTVIEW WHERE FPARENTID=?";
                    IRowSet rsToGetMinGLevel = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlToGetMinGLevel, (Object[])new Object[]{parentId});
                    int minGLevel = level;
                    if (rsToGetMinGLevel != null && rsToGetMinGLevel.next()) {
                        minGLevel = rsToGetMinGLevel.getInt("MINGLEVEL");
                    }
                    if (minGLevel < 1) {
                        minGLevel = level;
                    }
                    if (controllevel > minGLevel) {
                        controllevel = minGLevel;
                    }
                    String sqlToUpdateGLevel = "UPDATE T_BD_ACCOUNTVIEW SET FGLevel=?,fcontrollevel=? WHERE FID=?";
                    com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sqlToUpdateGLevel, (Object[])new Object[]{new Integer(minGLevel), new Integer(controllevel), parentId});
                    parentId = rsToGetParent.getString("FParentID");
                }
                continue;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (list.size() < 1) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        return list;
    }

    private String buildUnAssign(Context ctx, String upperId, List companyIdList) throws BOSException, EASBizException {
        AccountViewInfo accountViewInfo = this.getAccountViewInfo(ctx, (IObjectPK)new ObjectUuidPK(upperId));
        CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection("where id in (" + this.listToSqlArrays(companyIdList) + ")");
        StringBuilder detailLog = new StringBuilder();
        detailLog.append(ResourceBase.getString((String)RESOURCE, (String)"chooseCompany", (Locale)ctx.getLocale()) + "\u3010");
        for (int i = 0; i < companyOrgUnitCollection.size(); ++i) {
            detailLog.append(companyOrgUnitCollection.get(i).getNumber() + "(" + companyOrgUnitCollection.get(i).getName() + ");");
        }
        detailLog.append("\u3011\n");
        detailLog.append(ResourceBase.getString((String)RESOURCE, (String)"chooseAccount", (Locale)ctx.getLocale()) + "\u3010");
        detailLog.append(accountViewInfo.getNumber() + "(" + accountViewInfo.getName() + ");");
        detailLog.append("\u3011");
        return detailLog.toString();
    }

    private void checkSqlInner(String upperId) {
        BOSUuid.read((String)upperId);
    }

    private void checkSqlInner(List companyIdList) {
        for (int i = 0; i < companyIdList.size(); ++i) {
            if (companyIdList.get(i) == null) continue;
            BOSUuid.read((String)companyIdList.get(i).toString());
        }
    }

    private String listToSqlArrays(List companyIdList) {
        StringBuilder ids = new StringBuilder();
        for (int i = 0; i < companyIdList.size(); ++i) {
            ids.append("'");
            ids.append(companyIdList.get(i).toString());
            ids.append("'");
            if (i >= companyIdList.size() - 1) continue;
            ids.append(",");
        }
        return ids.toString();
    }

    private class AssignAndUnassignedThread
    implements Runnable {
        private Context ctx;
        private Account_ControlInfo acctCtrlInfo;
        private AccountViewCollection accountCols;
        private AccountRefContrastInfo upperRef;
        private boolean isDisplayAll;
        private List list;
        private String currThreadId;
        private Map<String, String> companyIdCatch;
        private Map dAssistTypemMap;
        private ArrayList accountForInsert;

        public AssignAndUnassignedThread(Context ctx, Account_ControlInfo acctCtrlInfo, AccountViewCollection accountCols, List list, AccountRefContrastInfo upperRef, boolean isDisplayAll, String currThreadId, Map<String, String> companyIdCatch, Map dAssistTypemMap, ArrayList accountForInsert) {
            this.ctx = ctx;
            this.acctCtrlInfo = acctCtrlInfo;
            this.accountCols = accountCols;
            this.list = list;
            this.upperRef = upperRef;
            this.isDisplayAll = isDisplayAll;
            this.currThreadId = currThreadId;
            this.companyIdCatch = companyIdCatch;
            this.dAssistTypemMap = dAssistTypemMap;
            this.accountForInsert = accountForInsert;
        }

        @Override
        public void run() {
            boolean isAssign = this.acctCtrlInfo.isAssign();
            ContextUtils.setLocaleToThread((Locale)this.ctx.getOriginLocale());
            HashMap<String, Object> temMap = new HashMap<String, Object>();
            temMap.put("currThreadId", this.currThreadId);
            temMap.put("result", this.companyIdCatch);
            temMap.put("dAssistTypemMap", this.dAssistTypemMap);
            temMap.put("accountForInsert", this.accountForInsert);
            AccountAssignThreadLocalUtil.setThreadLocalMap(temMap);
            try {
                String msg = "";
                msg = isAssign ? AccountViewFactory.getLocalInstance(this.ctx).accountAssign(this.acctCtrlInfo, this.accountCols, this.upperRef, this.isDisplayAll) : AccountViewControllerBean.this.accountUnassign(this.ctx, this.acctCtrlInfo, this.accountCols, this.isDisplayAll);
                if (!StringUtils.isEmpty((String)msg)) {
                    AccountAssignErrorInfo errorInfo = new AccountAssignErrorInfo(this.acctCtrlInfo.getDestCompany(), new Exception(msg), false);
                    this.list.add(errorInfo);
                } else {
                    this.list.add(null);
                }
            }
            catch (AccountException e) {
                logger.error((Object)e.getMessage(), (Throwable)((Object)e));
                if (e != null && !StringUtils.isEmpty((String)e.getMessage())) {
                    AccountAssignErrorInfo errorInfo = new AccountAssignErrorInfo(this.acctCtrlInfo.getDestCompany(), (Exception)((Object)e), false);
                    this.list.add(errorInfo);
                } else {
                    this.list.add(null);
                }
            }
            catch (AcctRefContrastException e) {
                logger.error((Object)e.getMessage(), (Throwable)((Object)e));
                if (e != null && !StringUtils.isEmpty((String)e.getMessage())) {
                    AccountAssignErrorInfo errorInfo = new AccountAssignErrorInfo(this.acctCtrlInfo.getDestCompany(), (Exception)((Object)e), false);
                    this.list.add(errorInfo);
                } else {
                    this.list.add(null);
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                if (e != null) {
                    if (e instanceof HeadDetailException) {
                        HeadDetailException headException = (HeadDetailException)e;
                        Exception ex = new Exception(headException.getHeadMsg() + "\n" + headException.getDetailMsg(), e);
                        AccountAssignErrorInfo errorInfo = new AccountAssignErrorInfo(this.acctCtrlInfo.getDestCompany(), ex, false);
                        this.list.add(errorInfo);
                    } else {
                        this.list.add(null);
                    }
                } else {
                    this.list.add(null);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                this.list.add(null);
            }
        }
    }
}

