/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeCollection;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeEntryInfo;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeFactory;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeInfo;
import com.kingdee.eas.basedata.master.account.app.AbstractAsstAccountChangeControllerBean;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AsstAccountChangeControllerBean
extends AbstractAsstAccountChangeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.account.app.AsstAccountChangeControllerBean");
    public static final String HARDRESOURCE = "com.kingdee.eas.basedata.master.account.AccountHardCodeResource";

    @Override
    protected Object _check(Context ctx, String companyId, Map params) throws BOSException {
        String error;
        HashMap result = new HashMap();
        LinkedList<String> errors = new LinkedList<String>();
        result.put("errors", errors);
        Set accountNumbers = (Set)params.get("accountNumbers");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("account.companyID.id", (Object)companyId));
        if (accountNumbers != null && accountNumbers.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("account.number", (Object)accountNumbers, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("account.id");
        selector.add("account.number");
        selector.add("account.name");
        selector.add("account.CAA.id");
        selector.add("account.CAA.number");
        selector.add("account.CAA.name");
        selector.add("period.*");
        selector.add("before.id");
        selector.add("before.number");
        selector.add("before.name");
        selector.add("after.id");
        selector.add("after.number");
        selector.add("after.name");
        selector.add("entries.id");
        selector.add("entries.asstActType.id");
        selector.add("entries.asstAct");
        view.setSelector(selector);
        SorterItemCollection sorter = new SorterItemCollection();
        view.setSorter(sorter);
        SorterItemInfo item = new SorterItemInfo("account.number");
        item.setSortType(SortType.ASCEND);
        sorter.add(item);
        item = new SorterItemInfo("account.id");
        item.setSortType(SortType.ASCEND);
        sorter.add(item);
        item = new SorterItemInfo("period.number");
        item.setSortType(SortType.ASCEND);
        sorter.add(item);
        AsstAccountChangeCollection changess = AsstAccountChangeFactory.getLocalInstance(ctx).getAsstAccountChangeCollection(view);
        if (changess.size() == 0) {
            return result;
        }
        HashMap<String, AsstActTypeCollection> asstActTypess = new HashMap<String, AsstActTypeCollection>();
        ArrayList<AsstAccountChangeInfo> changes = new ArrayList<AsstAccountChangeInfo>();
        AsstAccountChangeInfo change = changess.get(0);
        changes.add(change);
        String prefixId = change.getAccount().getId().toString();
        for (int i = 1; i < changess.size(); ++i) {
            change = changess.get(i);
            String accountId = change.getAccount().getId().toString();
            if (!accountId.equals(prefixId)) {
                String error2 = this.check(ctx, changes, asstActTypess);
                if (error2 != null && error2.length() > 0) {
                    errors.add(error2);
                }
                changes = new ArrayList();
                prefixId = accountId;
            }
            changes.add(change);
        }
        if (changes.size() > 0 && (error = this.check(ctx, changes, asstActTypess)) != null && error.length() > 0) {
            errors.add(error);
        }
        return result;
    }

    private String check(Context ctx, List<AsstAccountChangeInfo> changes, Map<String, AsstActTypeCollection> asstActTypess) throws BOSException {
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < changes.size(); ++i) {
            AsstAccountInfo after;
            AsstAccountChangeInfo change = changes.get(i);
            AsstAccountInfo before = change.getBefore();
            HashMap<String, AsstActTypeInfo> beforeTypes = new HashMap<String, AsstActTypeInfo>();
            if (before != null) {
                AsstActTypeCollection coll = this.getAsstActTypes(ctx, before.getId().toString(), asstActTypess);
                for (AsstActTypeInfo type : coll) {
                    beforeTypes.put(type.getId().toString(), type);
                }
            }
            if ((after = change.getAfter()) != null) {
                AsstActTypeCollection coll = this.getAsstActTypes(ctx, after.getId().toString(), asstActTypess);
                HashMap<String, String> defValues = new HashMap<String, String>();
                Iterator it = change.getEntries().iterator();
                while (it.hasNext()) {
                    AsstAccountChangeEntryInfo changeEntry = (AsstAccountChangeEntryInfo)it.next();
                    if (changeEntry.getAsstActType() == null || changeEntry.getAsstAct() == null || changeEntry.getAsstAct().length() <= 0) continue;
                    defValues.put(changeEntry.getAsstActType().getId().toString(), changeEntry.getAsstAct());
                }
                for (AsstActTypeInfo type : coll) {
                    if (beforeTypes.containsKey(type.getId().toString()) || defValues.containsKey(type.getId().toString())) continue;
                    msg.append(this.parseHardCode(ctx, "ChangeRecords") + change.getPeriod().getNumber() + this.parseHardCode(ctx, "DAuxacct") + "[" + type.getName() + "(" + type.getNumber() + ")]" + this.parseHardCode(ctx, "MissDefaultValue") + "; ");
                }
            }
            if (i + 1 < changes.size()) {
                AsstAccountChangeInfo next = changes.get(i + 1);
                if (next.getPeriod().getNumber() == change.getPeriod().getNumber()) {
                    msg.append(this.parseHardCode(ctx, "ChangeRecords") + change.getPeriod().getNumber() + this.parseHardCode(ctx, "Repeat") + "; ");
                }
                AsstAccountInfo afterCaa = change.getAfter();
                AsstAccountInfo beforeCaa = next.getBefore();
                if (afterCaa != null && beforeCaa == null || afterCaa == null && beforeCaa != null || afterCaa != null && beforeCaa != null && !afterCaa.getId().equals((Object)beforeCaa.getId())) {
                    String afterName = afterCaa == null ? "" : afterCaa.getName() + "(" + afterCaa.getNumber() + ")";
                    String beforeName = beforeCaa == null ? "" : beforeCaa.getName() + "(" + beforeCaa.getNumber() + ")";
                    msg.append(this.parseHardCode(ctx, "ChangeRecords") + change.getPeriod().getNumber() + this.parseHardCode(ctx, "DChangeAfterAuxacct") + "[" + afterName + "]" + this.parseHardCode(ctx, "AndChangeRecords") + next.getPeriod().getNumber() + this.parseHardCode(ctx, "ChangeBeforeAuxacct") + "[" + beforeName + "]" + this.parseHardCode(ctx, "Disagree") + "; ");
                }
            }
            if ((before != null || after != null) && (before == null || after == null || !before.getId().equals((Object)after.getId()))) continue;
            msg.append(this.parseHardCode(ctx, "ChangeRecords") + change.getPeriod().getNumber() + this.parseHardCode(ctx, "TheSameWithChange") + "; ");
        }
        AsstAccountChangeInfo last = changes.get(changes.size() - 1);
        AsstAccountInfo curCaa = last.getAccount().getCAA();
        AsstAccountInfo newCaa = last.getAfter();
        if (curCaa != null && newCaa == null || curCaa == null && newCaa != null || curCaa != null && newCaa != null && !curCaa.getId().equals((Object)newCaa.getId())) {
            String curName = curCaa == null ? "" : curCaa.getName() + "(" + curCaa.getNumber() + ")";
            String newName = newCaa == null ? "" : newCaa.getName() + "(" + newCaa.getNumber() + ")";
            msg.append(this.parseHardCode(ctx, "LastChangeRecord") + last.getPeriod().getNumber() + this.parseHardCode(ctx, "DAsstAccount") + "[" + newName + "]" + this.parseHardCode(ctx, "WithCurrentAsstAccount") + "[" + curName + "]" + this.parseHardCode(ctx, "Disagree") + "; ");
        }
        if (msg.length() > 0) {
            return this.parseHardCode(ctx, "Account") + last.getAccount().getNumber() + ": " + msg.toString();
        }
        return null;
    }

    private AsstActTypeCollection getAsstActTypes(Context ctx, String caaId, Map<String, AsstActTypeCollection> asstActTypess) throws BOSException {
        if (asstActTypess.containsKey(caaId)) {
            return asstActTypess.get(caaId);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)caaId));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        AsstActGroupDetailCollection asstcol = AsstActGroupDetailFactory.getLocalInstance((Context)ctx).getAsstActGroupDetailCollection(view);
        AsstActTypeCollection asstActTypes = new AsstActTypeCollection();
        for (int i = 0; i < asstcol.size(); ++i) {
            asstActTypes.add(asstcol.get(i).getAsstActType());
        }
        asstActTypess.put(caaId, asstActTypes);
        return asstActTypes;
    }

    private String parseHardCode(Context ctx, String resName) {
        return ResourceBase.getString((String)HARDRESOURCE, (String)resName, (Locale)ctx.getLocale());
    }
}

