/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AbstractMulDataTransmission;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AcctRefContrastException;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.RefTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Hashtable;

public class CompanyAcctRefProfitCenterDataImport
extends AbstractMulDataTransmission {
    protected CoreBaseInfo createHead(Hashtable hsData, Context ctx) throws Exception {
        AccountRefContrastInfo info = new AccountRefContrastInfo();
        info.setRefType(RefTypeEnum.FINANCEPROFIT);
        CompanyOrgUnitInfo curCompany = this.getCompany(hsData, ctx);
        info.setCompany(curCompany);
        boolean hasPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "bd_account_accountRefContrast_addNew");
        if (!hasPermission) {
            throw new AcctRefContrastException(AcctRefContrastException.NOT_HAS_ADD_PERMISSION, new Object[]{info.getCompany().getName()});
        }
        String srcAccountTableNumber = ((DataToken)hsData.get((Object)"FSrcAccountTableNumber")).data.toString();
        String destAccountTableNumber = ((DataToken)hsData.get((Object)"FDestAccountTableNumber")).data.toString();
        String destCompanyNumber = ((DataToken)hsData.get((Object)"FDestCompanyNumber")).data.toString();
        CompanyOrgUnitCollection company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection("where number='" + destCompanyNumber + "'");
        if (company.size() < 1) {
            throw new AcctRefContrastException(AcctRefContrastException.CAN_NOT_FOUND_DEST_COMPANY, new Object[]{destCompanyNumber});
        }
        info.setStCompany(company.get(0));
        AccountTableCollection desAccountTable = AccountTableFactory.getLocalInstance(ctx).getAccountTableCollection(this.buildAccountTableFilter(company.get(0), destAccountTableNumber));
        if (desAccountTable.size() < 1) {
            throw new AcctRefContrastException(AcctRefContrastException.DEST_ACCOUNTTABLE_NOT_IN_COMPANY, new Object[]{company.get(0).getName(), destCompanyNumber});
        }
        info.setEnabledAcctTable(desAccountTable.get(0));
        AccountTableCollection srcAccountTable = AccountTableFactory.getLocalInstance(ctx).getAccountTableCollection(this.buildAccountTableFilter(curCompany, srcAccountTableNumber));
        if (srcAccountTable.size() < 1) {
            throw new AcctRefContrastException(AcctRefContrastException.SRC_ACCOUNTTABLE_NOT_IN_COMPANY, new Object[]{curCompany.getName(), srcAccountTableNumber});
        }
        info.setDisabledAcctTable(srcAccountTable.get(0));
        return info;
    }

    public CompanyOrgUnitInfo getCompany(Hashtable hsData, Context ctx) throws Exception {
        CompanyOrgUnitInfo curCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        return curCompany;
    }

    private EntityViewInfo buildAccountTableFilter(CompanyOrgUnitInfo company, String accountTableNumber) {
        FilterInfo filter = new FilterInfo();
        String sql = "select faccounttableid  from t_bd_acct_contorl where fdestcompanyid ='" + company.getId().toString() + "'";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountTableNumber, CompareType.EQUALS));
        EntityViewInfo entryViewInfo = new EntityViewInfo();
        entryViewInfo.setFilter(filter);
        return entryViewInfo;
    }

    private EntityViewInfo buildAccountFilter(CompanyOrgUnitInfo company, AccountTableInfo accountTable, String acctNumber) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)acctNumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString(), CompareType.EQUALS));
        EntityViewInfo entryViewInfo = new EntityViewInfo();
        entryViewInfo.setFilter(filter);
        return entryViewInfo;
    }

    protected void createEntry(CoreBaseInfo head, Hashtable hsData, Context ctx) throws Exception {
        AccountRefContrastInfo parent = (AccountRefContrastInfo)head;
        AccountRefContrastEntryInfo entry = new AccountRefContrastEntryInfo();
        String srcAccountNumber = ((DataToken)hsData.get((Object)"FSrcAccountNumber")).data.toString();
        String destAccountNumber = ((DataToken)hsData.get((Object)"FDestAccountNumber")).data.toString();
        IAccountView instance = AccountViewFactory.getLocalInstance(ctx);
        AccountViewCollection srcAccount = instance.getAccountViewCollection(this.buildAccountFilter(parent.getCompany(), parent.getDisabledAcctTable(), srcAccountNumber));
        if (srcAccount.size() < 1) {
            throw new AcctRefContrastException(AcctRefContrastException.ACCOUNTTABLE_NOT_HAS_ACCOUNT, new Object[]{parent.getCompany().getName(), parent.getDisabledAcctTable().getName(), srcAccountNumber});
        }
        if (srcAccount.get(0).isIsCFreeze()) {
            throw new AcctRefContrastException(AcctRefContrastException.SRC_ACCOUNT_IS_NOT_ENABLE, new Object[]{srcAccountNumber});
        }
        if (!srcAccount.get(0).isIsLeaf()) {
            throw new AcctRefContrastException(AcctRefContrastException.SRC_ACCOUNT_IS_NOT_LEAF, new Object[]{srcAccountNumber});
        }
        entry.setOldAcct(srcAccount.get(0));
        AccountViewCollection destAccount = instance.getAccountViewCollection(this.buildAccountFilter(parent.getStCompany(), parent.getEnabledAcctTable(), destAccountNumber));
        if (destAccount.size() < 1) {
            throw new AcctRefContrastException(AcctRefContrastException.ACCOUNTTABLE_NOT_HAS_ACCOUNT, new Object[]{parent.getCompany().getName(), parent.getEnabledAcctTable().getName(), destAccountNumber});
        }
        if (destAccount.get(0).isIsCFreeze()) {
            throw new AcctRefContrastException(AcctRefContrastException.DEST_ACCOUNT_IS_NOT_ENABLE, new Object[]{destAccountNumber});
        }
        if (!destAccount.get(0).isIsLeaf()) {
            throw new AcctRefContrastException(AcctRefContrastException.DEST_ACCOUNT_IS_NOT_LEAF, new Object[]{destAccountNumber});
        }
        if (destAccount.get(0).isIsProfitCenter()) {
            throw new AcctRefContrastException(AcctRefContrastException.ACCOUNT_IS_NOT_COMPANY, new Object[]{destAccountNumber});
        }
        entry.setNewAcct(destAccount.get(0));
        parent.getAcctRefContrastEntry().add(entry);
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return AccountRefContrastFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        String oldSrcAccountTableNumber = ((DataToken)firstData.get((Object)"FSrcAccountTableNumber")).data.toString();
        String oldDestAccountTableNumber = ((DataToken)firstData.get((Object)"FDestAccountTableNumber")).data.toString();
        String oldDestCompanyNumber = ((DataToken)firstData.get((Object)"FDestCompanyNumber")).data.toString();
        String newSrcAccountTableNumber = ((DataToken)currentData.get((Object)"FSrcAccountTableNumber")).data.toString();
        String newDestAccountTableNumber = ((DataToken)currentData.get((Object)"FDestAccountTableNumber")).data.toString();
        String newDestCompanyNumber = ((DataToken)currentData.get((Object)"FDestCompanyNumber")).data.toString();
        if (!oldSrcAccountTableNumber.equals(newSrcAccountTableNumber)) {
            return false;
        }
        if (!oldDestAccountTableNumber.equals(newDestAccountTableNumber)) {
            return false;
        }
        return oldDestCompanyNumber.equals(newDestCompanyNumber);
    }
}

