/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.app.builder.ContrastAccountViewSubmitBuilder;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.DynamicBusinessProcessHelper;
import com.kingdee.eas.dynbusiness.app.IBusinessProcessorBuilder;
import com.kingdee.eas.dynbusiness.app.processor.BillsExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;

public class CommonServerUtils {
    public static final String RT = "\r\n";

    public static void isARAPAccount(Context ctx, String companyID, String accountTableID, String accountID, int system) throws BOSException, EASBizException {
        int periodNumber;
        if (system != 1 && system != 2) {
            return;
        }
        AccountViewInfo acctViewInfo = AccountViewFactory.getLocalInstance(ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)accountID)));
        AccountTableInfo acctTableInfo = new AccountTableInfo();
        acctTableInfo.setId(BOSUuid.read((String)accountTableID));
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyID));
        PeriodInfo currPeriod = null;
        currPeriod = system == 1 ? SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)company) : SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)company);
        if (currPeriod == null) {
            return;
        }
        int periodYear = currPeriod.getPeriodYear();
        if (!CommonServerUtils.existContrastAccount(ctx, companyID, accountTableID, accountID, system, periodYear, periodNumber = currPeriod.getPeriodNumber())) {
            AsstActTypeInfo assActTypeInfo = CommonServerUtils.getAsstActTypeByAccountView(ctx, acctViewInfo.getId().toString(), companyID);
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("Account", acctViewInfo);
            info.put("AccountTableID", acctTableInfo);
            info.put("System", "" + system);
            info.put("Company", company);
            info.put("PeriodYear", "" + periodYear);
            info.put("PeriodNumber", "" + periodNumber);
            info.put("DefaultAsstActType", assActTypeInfo);
            ctx.put((Object)"CommonServerUtils_isARAPAccount_Param_Info", info);
            BillsExecuteContext executeContext = new BillsExecuteContext(ctx, null, BatchActionEnum.SUBMIT, null, new Object[]{"emptyID"});
            ContrastAccountViewSubmitBuilder builder = new ContrastAccountViewSubmitBuilder((ExecuteContext)executeContext);
            DynamicBusinessProcessHelper.batchExecute((ExecuteContext)executeContext, (IBusinessProcessorBuilder)builder);
        }
    }

    private static boolean existContrastAccount(Context ctx, String companyID, String accountTableID, String accountID, int system, int periodYear, int periodNumber) throws BOSException, EASBizException {
        boolean exist = false;
        StringBuffer sb = new StringBuffer("");
        sb.append("select fid from T_AR_ContrastAccountView where \r\t");
        sb.append(" FAccountTableID='").append(accountTableID).append("' \r\t");
        sb.append(" and FCompanyID='").append(companyID).append("' \r\t");
        sb.append(" and FAccountID='").append(accountID).append("' \r\t");
        sb.append(" and FSystem = ").append(system).append(" \r\t");
        sb.append(" and FPeriodYear ='").append(periodYear).append("' \r\t");
        sb.append(" and FPeriodNumber ='").append(periodNumber).append("'");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs.next()) {
                exist = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return exist;
    }

    private static AsstActTypeInfo getAsstActTypeByAccountView(Context ctx, String accountId, String companyID) throws BOSException, EASBizException {
        AsstActTypeCollection asstCol = CommonServerUtils.getAsstActType(ctx, accountId, companyID);
        if (asstCol.size() == 0) {
            return null;
        }
        AsstActTypeInfo info = asstCol.get(0);
        for (int i = 1; i < asstCol.size(); ++i) {
            AsstActTypeInfo nextInfo = asstCol.get(i);
            String nextHgType = nextInfo.getAsstHGAttribute();
            String infoHgType = info.getAsstHGAttribute();
            if (infoHgType.equals("customer")) break;
            if (infoHgType.equals("provider") && nextHgType.equals("customer")) {
                info = nextInfo;
                continue;
            }
            if (infoHgType.equals("adminOrg") && (nextHgType.equals("provider") || nextHgType.equals("customer"))) {
                info = nextInfo;
                continue;
            }
            if (infoHgType.equals("person") && (nextHgType.equals("provider") || nextHgType.equals("customer") || nextHgType.equals("adminOrg"))) {
                info = nextInfo;
                continue;
            }
            if (!nextHgType.equals("provider") && !nextHgType.equals("customer") && !nextHgType.equals("adminOrg") && !nextHgType.equals("person")) continue;
            info = nextInfo;
        }
        return info;
    }

    public static void updateArApContrastAccount(Context ctx, String companyID, String accountTableID, String accountID) throws BOSException, EASBizException {
        if (accountTableID == null || accountID == null) {
            return;
        }
        AsstActTypeInfo asstActType = CommonServerUtils.getAsstActTypeByAccountView(ctx, accountID, companyID);
        StringBuffer buffer = new StringBuffer("");
        if (asstActType == null) {
            buffer.append(" update t_ar_contrastaccountview set FAsstActTypeID = null ").append(RT);
            buffer.append(" where faccounttableid='").append(accountTableID).append("'").append(RT);
            buffer.append(" and FCompanyID='").append(companyID).append("'").append(RT);
            buffer.append(" and faccountid='").append(accountID).append("'").append(RT);
        } else {
            buffer.append(" update t_ar_contrastaccountview set FAsstActTypeID = '").append(asstActType.getId().toString()).append("'").append(RT);
            buffer.append(" where faccounttableid='").append(accountTableID).append("'").append(RT);
            buffer.append(" and FCompanyID='").append(companyID).append("'").append(RT);
            buffer.append(" and faccountid='").append(accountID).append("'").append(RT);
        }
        DbUtil.execute((Context)ctx, (String)buffer.toString());
    }

    private static AsstActTypeCollection getAsstActType(Context ctx, String accountViewID, String CompanyId) throws BOSException {
        if (StringUtils.isEmpty((String)accountViewID) || StringUtils.isEmpty((String)CompanyId)) {
            return new AsstActTypeCollection();
        }
        String lang = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer("select distinct ty.fid as fid, ty.fname_").append(lang).append(" as fname, ty.fnumber as fnumber, ty.FAsstHGAttribute as FAsstHGAttribute").append("\r\t");
        sql.append("from t_bd_accountview av").append("\r\t");
        sql.append("inner join t_bd_asstaccount ass on av.fcaa = ass.fid").append("\r\t");
        sql.append("inner join t_bd_asstactgroupdetail det on det.fasstaccountid=ass.fid").append("\r\t");
        sql.append("inner join t_bd_asstacttype ty on ty.fid=det.fasstacttypeid").append("\r\t");
        sql.append("inner join t_bd_asstacttypedefault de on de.fasstacttypeid = ty.fid").append("\r\t");
        sql.append("where de.fisaccountcussent = 1 and av.fid=? and de.FCompanyID = ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{accountViewID, CompanyId});
        AsstActTypeCollection objCol = new AsstActTypeCollection();
        try {
            while (rs.next()) {
                AsstActTypeInfo info = new AsstActTypeInfo();
                info.setId(BOSUuid.read((String)rs.getString("fid")));
                info.setName(rs.getString("fname"));
                info.setNumber(rs.getString("fnumber"));
                info.setAsstHGAttribute(rs.getString("FAsstHGAttribute"));
                objCol.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return objCol;
    }
}

