/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.eas.basedata.assistant.AbstractExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTypeEnum;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ExchangeRateInfo
extends AbstractExchangeRateInfo
implements Serializable {
    public static final Date INFINITE_INVALID_DATE = ExchangeRateInfo.getInfiniteInvalidDate();
    public static final String ZERO_STRING = "0.000";

    private static Date getInfiniteInvalidDate() {
        Date date = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = format.parse("2199-12-31");
            DateFormat f = BOSLocaleUtil.getDateFormat();
            date = f.parse(f.format(date));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return date;
    }

    public ExchangeRateInfo() {
    }

    protected ExchangeRateInfo(String pkField) {
        super(pkField);
    }

    public CurrencyInfo getSourceCurrency() {
        CurrencyInfo currencyVO = null;
        if (this.getExchangeAux() != null) {
            currencyVO = this.getExchangeAux().getSourceCurrency();
        }
        return currencyVO;
    }

    public CurrencyInfo getTargetCurrency() {
        CurrencyInfo currencyVO = null;
        if (this.getExchangeAux() != null) {
            currencyVO = this.getExchangeAux().getTargetCurrency();
        }
        return currencyVO;
    }

    public ConvertModeEnum getConvertMode() {
        ConvertModeEnum convertMode = null;
        if (this.getExchangeAux() != null) {
            convertMode = this.getExchangeAux().getConvertMode();
        }
        return convertMode;
    }

    public int getPrecision() {
        int precision = -1;
        if (this.getExchangeAux() != null) {
            precision = this.getExchangeAux().getPrecision();
        }
        return precision;
    }

    public ExchangeTypeEnum getExchangeRateType() {
        ExchangeTypeEnum exchangeRateType = null;
        if (this.getExchangeAux() != null) {
            exchangeRateType = this.getExchangeAux().getExchangeRateType();
        }
        return exchangeRateType;
    }

    public ExchangeTableInfo getExchangeTable() {
        ExchangeTableInfo exchangeTable = null;
        if (this.getExchangeAux() != null) {
            exchangeTable = this.getExchangeAux().getExchangeTable();
        }
        return exchangeTable;
    }
}

