/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.basedata.assistant.OrgUnitInfo;
import com.kingdee.eas.basedata.assistant.WorkCalendarException;
import com.kingdee.eas.basedata.assistant.WorkCalendarFactory;
import com.kingdee.eas.basedata.assistant.WorkCalendarInfo;
import com.kingdee.eas.util.client.EASResource;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.tree.MutableTreeNode;

public class WorkCalendarUtil {
    public static DefaultKingdeeTreeNode getOrgUnitTree(OrgUnitInfo[] infoArray) {
        if (infoArray == null || infoArray.length <= 0) {
            return null;
        }
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode();
        ArrayList preLevelNodes = new ArrayList();
        ArrayList<DefaultKingdeeTreeNode> curLevelNodes = new ArrayList<DefaultKingdeeTreeNode>();
        int preLevel = -1;
        int curLevel = 0;
        DefaultKingdeeTreeNode curNode = rootNode;
        DefaultKingdeeTreeNode tmpNode = null;
        OrgUnitInfo tmpInfo = null;
        DefaultKingdeeTreeNode tmpNode1 = null;
        for (int i = 0; i < infoArray.length; ++i) {
            tmpNode = new DefaultKingdeeTreeNode((Object)infoArray[i]);
            tmpNode.setCustomIcon(EASResource.getIcon((String)"imgTree_company"));
            if (i == 0) {
                curNode = rootNode = tmpNode;
                preLevel = curLevel = Integer.parseInt(infoArray[i].getOrgUnitLevel());
                curLevelNodes.add(curNode);
                continue;
            }
            curLevel = Integer.parseInt(infoArray[i].getOrgUnitLevel());
            if (curLevel > preLevel) {
                preLevelNodes.clear();
                preLevelNodes = curLevelNodes;
                curLevelNodes = new ArrayList();
                preLevel = curLevel;
            } else if (curLevel == preLevel) {
                // empty if block
            }
            curLevelNodes.add(tmpNode);
            for (int j = 0; j < preLevelNodes.size(); ++j) {
                tmpNode1 = (DefaultKingdeeTreeNode)preLevelNodes.get(j);
                tmpInfo = (OrgUnitInfo)tmpNode1.getUserObject();
                if (infoArray[i].getParentID() == null || !infoArray[i].getParentID().equals(tmpInfo.getOrgUnitID())) continue;
                tmpNode1.add((MutableTreeNode)tmpNode);
            }
        }
        return rootNode;
    }

    public static WorkCalendarInfo getWorkCalendarValue(String orgUnitID) {
        Calendar cl = Calendar.getInstance();
        int year = cl.get(1);
        int month = cl.get(2);
        return WorkCalendarUtil.getWorkCalendarValue(orgUnitID, year, month);
    }

    public static WorkCalendarInfo getWorkCalendarValue(String orgUnitID, int year, int month) {
        String oql = " where orgUnit = '" + orgUnitID + "'";
        WorkCalendarInfo info = null;
        try {
            info = WorkCalendarFactory.getRemoteInstance().getWorkCalendarInfo(oql);
        }
        catch (Exception e) {
            return null;
        }
        return info;
    }

    public static boolean isWorkDay(String orgUnitID, Date d, boolean isCastBack) throws BOSException, WorkCalendarException {
        return WorkCalendarFactory.getRemoteInstance().isWorkDay(orgUnitID, isCastBack, d);
    }

    public static boolean isWorkDayCastBack(String orgUnitLongNumber, Date d) throws BOSException, WorkCalendarException {
        return WorkCalendarFactory.getRemoteInstance().isWorkDayCastBack(orgUnitLongNumber, d);
    }

    public static boolean isWorkDayNoCastBack(String orgUnitID, Date d) throws BOSException, WorkCalendarException {
        return WorkCalendarFactory.getRemoteInstance().isWorkDayNoCastBack(orgUnitID, d);
    }
}

