/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fi.gl.GLUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankException;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AcctBankWebException;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.SharedAcctEntriesCollection;
import com.kingdee.eas.basedata.assistant.SharedAcctEntriesInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctFactory;
import com.kingdee.eas.basedata.assistant.SharedAcctInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctType;
import com.kingdee.eas.basedata.assistant.app.AbstractAccountBankWebFacadeControllerBean;
import com.kingdee.eas.basedata.assistant.model.BatchExecuteResult;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.condition.InterfaceItem;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.fm.be.OpenAreaFactory;
import com.kingdee.eas.fm.be.OpenAreaInfo;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class AccountBankWebFacadeControllerBean
extends AbstractAccountBankWebFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.AccountBankWebFacadeControllerBean");

    @Override
    protected Map _save(Context ctx, AccountBankInfo info) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            this.beforeSave(ctx, info);
            this.fillAccountBankInfo(ctx, info);
            IObjectPK pk = AccountBankFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
            result.put("error", 1);
            result.put("id", pk.toString());
        }
        catch (EASBizException e) {
            e.printStackTrace();
            result.put("error", 0);
            result.put("msg", e.getMessage());
        }
        catch (BOSException e) {
            e.printStackTrace();
            result.put("error", 0);
            result.put("msg", e.getMessage());
        }
        return result;
    }

    private void fillAccountBankInfo(Context ctx, AccountBankInfo info) throws BOSException, EASBizException {
        if (AccountBankFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId().toString()))) {
            AccountBankInfo oldInfo = AccountBankFactory.getLocalInstance(ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()));
            if (!info.getBankAccountNumber().equals(oldInfo.getBankAccountNumber())) {
                info.setOldBankAccountNumber(oldInfo.getBankAccountNumber());
            }
        }
        AccountViewInfo acctViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(info.getAccount().getId().toString()));
        info.setAccount(acctViewInfo);
        if (info.isIsSetBankInterface()) {
            OpenAreaInfo openAreaInfo = OpenAreaFactory.getLocalInstance((Context)ctx).getOpenAreaInfo((IObjectPK)new ObjectUuidPK(info.getOpenArea().getId().toString()));
            info.setOpenArea(openAreaInfo);
        }
        info.setIsBank(info.getAccount().isIsBank());
        info.setIsCash(info.getAccount().isIsCash());
    }

    private void beforeSave(Context ctx, AccountBankInfo info) throws EASBizException, BOSException {
        Pattern pattern;
        Matcher isNum;
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
        info.setCompany(company);
        if (GLUtil.isCompanyUnion((CompanyOrgUnitInfo)company)) {
            throw new AccountBankException(AccountBankException.INFO_COMPANY_ISONLYUNION);
        }
        if (!EmptyUtil.isEmpty((String)info.getBankAccountNumber()) && !(isNum = (pattern = Pattern.compile("^[^\\s]*$")).matcher(info.getBankAccountNumber())).matches()) {
            throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u94f6\u884c\u8d26\u53f7\u4e0d\u5141\u8bb8\u5b58\u5728\u7a7a\u683c\uff01"});
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getCompany())) {
            throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u5f00\u6237\u516c\u53f8\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01"});
        }
        if (info.isIsByCurrency() && EmptyUtil.isEmpty((CoreBaseInfo)info.getCurrency())) {
            throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u52fe\u9009\u5355\u4e00\u5e01\u522b\u540e\uff0c\u5e01\u522b\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01"});
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getBank())) {
            throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u91d1\u878d\u673a\u6784\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01"});
        }
        if (info.getBank().isInGroup() && EmptyUtil.isEmpty((CoreBaseInfo)info.getInnerAcct())) {
            throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u91d1\u878d\u673a\u6784\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u65f6\uff0c\u5bf9\u5e94\u5185\u90e8\u8d26\u6237\u5fc5\u5f55"});
        }
        if (EmptyUtil.isEmpty((Object)info.getOpenDate())) {
            throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u5f00\u6237\u65e5\u671f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01"});
        }
        if (EmptyUtil.isEmpty((Object)((Object)info.getAccountBankType()))) {
            throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u8d26\u6237\u6027\u8d28\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01"});
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getProperty())) {
            throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u8d26\u6237\u7528\u9014\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01"});
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getAccount())) {
            throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u79d1\u76ee\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01"});
        }
        if (info.isIsSetBankInterface() && info.isIsRpa()) {
            throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u8bbe\u7f6e\u94f6\u884c\u63a5\u53e3\u4fe1\u606f\u548c\u7f51\u94f6\u673a\u5668\u4eba\u8d26\u6237\u4e0d\u80fd\u540c\u65f6\u52fe\u9009\uff01"});
        }
        if (info.isIsSetBankInterface()) {
            if (EmptyUtil.isEmpty((String)info.getBankInterFaceID()) || EmptyUtil.isEmpty((String)info.getBankInterFace())) {
                throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u52fe\u9009\u94f6\u4f01\u63a5\u53e3\u540e\uff0c\u94f6\u884c\u63a5\u53e3\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01"});
            }
            if (EmptyUtil.isEmpty((CoreBaseInfo)info.getOpenArea()) || EmptyUtil.isEmpty((String)info.getBankInterFace())) {
                throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u52fe\u9009\u94f6\u4f01\u63a5\u53e3\u540e\uff0c\u5f00\u6237\u5730\u533a\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01"});
            }
            if (EmptyUtil.isEmpty((String)info.getAcctName()) || EmptyUtil.isEmpty((String)info.getBankInterFace())) {
                throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u52fe\u9009\u94f6\u4f01\u63a5\u53e3\u540e\uff0c\u94f6\u884c\u8d26\u6237\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01"});
            }
            if (EmptyUtil.isEmpty((CoreBaseInfo)info.getCountry()) || EmptyUtil.isEmpty((String)info.getBankInterFace())) {
                throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u52fe\u9009\u94f6\u4f01\u63a5\u53e3\u540e\uff0c\u56fd\u5bb6\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01"});
            }
        }
        if (info.isIsForEDrafOnly()) {
            BankInfo bank = BankFactory.getLocalInstance(ctx).getBankInfo((IObjectPK)new ObjectUuidPK(info.getBank().getId()));
            info.setBank(bank);
            if (bank.getAccountBank() == null) {
                throw new AccountBankException(AccountBankException.BANKISNULL);
            }
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getInnerAcct()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getSubAccount())) {
            InnerAccountInfo innerAcctInfo = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountInfo((IObjectPK)new ObjectUuidPK(info.getInnerAcct().getId().toString()));
            AccountBankInfo subAccountInfo = AccountBankFactory.getLocalInstance(ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getSubAccount().getId().toString()));
            if (!innerAcctInfo.getCompany().getId().toString().equals(subAccountInfo.getCompany().getId().toString())) {
                throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u9009\u62e9\u7684\u5185\u90e8\u8d26\u6237\u4e0d\u662f\u5728\u4e0a\u7ea7\u8d26\u53f7\u5f00\u6237\u5355\u4f4d\u5f00\u6237\u7684\u5185\u90e8\u8d26\u6237\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff0c\u5426\u5219\u6bcd\u516c\u53f8\u65e0\u6cd5\u767b\u8bb0\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26\uff01"});
            }
        }
    }

    @Override
    protected Map _batchDelete(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult results = new BatchExecuteResult();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        sic.add(new SelectorItemInfo("isClosed"));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.Array2Set(ids), CompareType.INCLUDE));
        AccountBankCollection coll = AccountBankFactory.getLocalInstance(ctx).getAccountBankCollection(view);
        int success = 0;
        String summary = "\u5171" + ids.length + "\u5f20\u5355\u636e\uff0c";
        for (int i = 0; i < coll.size(); ++i) {
            AccountBankInfo info = coll.get(i);
            try {
                this.beforeDetele(ctx, info);
                AccountBankFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(info.getId().toString()));
                ++success;
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                results.getDetailMsgList().add("\u5355\u636e\u7f16\u53f7\u4e3a" + info.getNumber() + "\u7684\u8d26\u6237\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
                continue;
            }
            catch (ObjectReferedException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                results.getDetailMsgList().add("\u5355\u636e\u7f16\u53f7\u4e3a" + info.getNumber() + "\u7684\u8d26\u6237\u5220\u9664\u5931\u8d25\uff1a" + ExceptionMessageUtility.getMessage((Throwable)e));
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                results.getDetailMsgList().add("\u5355\u636e\u7f16\u53f7\u4e3a" + info.getNumber() + "\u7684\u8d26\u6237\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        if (success == ids.length) {
            results.setError(1);
            summary = summary + "\u5168\u90e8\u5220\u9664\u6210\u529f\u3002";
        } else {
            results.setError(0);
            summary = summary + "\u5220\u9664\u6210\u529f" + success + "\u6761\uff0c\u5931\u8d25" + (ids.length - success) + "\u6761\u3002";
        }
        results.setSummaryMsg(summary);
        return results;
    }

    private Set Array2Set(String[] array) {
        if (array == null || array.length < 1) {
            return null;
        }
        HashSet<String> idSet = new HashSet<String>();
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            idSet.add(array[i]);
        }
        return idSet;
    }

    private void beforeDetele(Context ctx, AccountBankInfo info) throws BOSException, EASBizException {
        if (info.isIsClosed()) {
            throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u5df2\u9500\u6237\u7684\u94f6\u884c\u8d26\u6237\u4e0d\u80fd\u4fee\u6539\u548c\u5220\u9664\uff01"});
        }
        String sql = "select * from T_BD_AcctModifyApply where FAccountBankID = ? and FBillState in (1,2,3)";
        IRowSet rowSet = FMIsqlFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql, new Object[]{info.getId().toString()});
        if (rowSet != null && rowSet.size() != 0) {
            throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u6b64\u8d26\u6237\u5b58\u5728\u672a\u786e\u8ba4\u6216\u672a\u5e9f\u9664\u7684\u53d8\u66f4\u7533\u8bf7\uff0c\u4e0d\u80fd\u5220\u9664\uff01"});
        }
        sql = "select 1 from T_INT_IntObject where FsourceType = 2 and FsourceId = ?";
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{info.getId().toString()});
        if (rowSet != null && rowSet.size() > 0) {
            throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u5df2\u7ecf\u5173\u8054\u8ba1\u606f\u5bf9\u8c61\u7684\u94f6\u884c\u5e10\u6237\u4e0d\u5141\u8bb8\u5220\u9664\uff01"});
        }
    }

    @Override
    protected Map _setBankInterface(Context ctx, String bankId, String companyId) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        if (!EmptyUtil.isEmpty((String)bankId)) {
            BankInfo bankInfo = BankFactory.getLocalInstance(ctx).getBankInfo((IObjectPK)new ObjectUuidPK(bankId));
            String summary = "";
            Object[] bankCert = null;
            try {
                InterfaceItem item = new InterfaceItem("BankFacade", "A2F61E6C", "getBankCert", "facade", new Class[]{String.class, String.class}, null);
                bankCert = (Object[])item.doInvoke(ctx, new Object[]{bankInfo.getName(), companyId});
                result.setError(1);
                result.put("bankCert", bankCert);
            }
            catch (Exception e) {
                logger.error((Object)e);
                result.setError(0);
                result.put("msg", e.getMessage());
            }
        } else {
            result.setError(1);
        }
        return result;
    }

    @Override
    protected Map _writeOff(Context ctx, String[] ids, Date closeDate, Date openDate) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        IAccountBank iAccountBank = AccountBankFactory.getLocalInstance(ctx);
        AccountBankInfo info = iAccountBank.getAccountBankInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ids[0])));
        try {
            this.beforeWriteOff(ctx, info, closeDate, openDate);
            iAccountBank.writeOff((IObjectPK)new ObjectUuidPK(info.getId()), closeDate);
            if (info.getShareType().getValue() == 1) {
                this.unCloseAccBank_UsedShareType(iAccountBank, info.getBankAccountNumber());
            }
            result.put("error", 1);
            result.put("msg", "\u9500\u6237\u6210\u529f");
        }
        catch (EASBizException e) {
            e.printStackTrace();
            result.put("error", 0);
            result.put("msg", e.getMessage());
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private void beforeWriteOff(Context ctx, AccountBankInfo info, Date closeDate, Date openDate) throws BOSException, EASBizException, Exception {
        if (this.existAcctModifyApply(ctx, info.getId().toString())) {
            throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"209_AcctModifyApplyListUI", (Locale)ctx.getLocale())});
        }
        String param = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "BD002");
        boolean BD002 = false;
        BD002 = param == null ? false : Boolean.valueOf(param);
        if (BD002 && !this.existDestroyAccountApply(ctx, info.getId().toString())) {
            throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"49_AccountBankMainUI", (Locale)ctx.getLocale())});
        }
        if (!EmptyUtil.isEmpty((Object)info.getCloseDate())) {
            throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u8be5\u8d26\u6237\u5df2\u7ecf\u6ce8\u9500!"});
        }
        if (!EmptyUtil.isEmpty((Object)closeDate) && closeDate.before(openDate)) {
            throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u9500\u6237\u65e5\u671f\u8981\u5927\u4e8e\u7b49\u4e8e\u5f00\u6237\u65e5\u671f"});
        }
    }

    private void unCloseAccBank_UsedShareType(IAccountBank iAccountBank, String bankAccNumber) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add("id");
        ev.getSelector().add("isClosed");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)bankAccNumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("shareType", (Object)2, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        ev.setFilter(filter);
        AccountBankCollection accBankCols = iAccountBank.getAccountBankCollection(ev);
        for (int i = 0; i < accBankCols.size(); ++i) {
            AccountBankInfo info = accBankCols.get(i);
            if (!info.isIsClosed()) continue;
            iAccountBank.unWriteOff((IObjectPK)new ObjectUuidPK(info.getId()));
        }
    }

    @Override
    protected Map _unWriteOff(Context ctx, String[] ids) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        IAccountBank iAccountBank = AccountBankFactory.getLocalInstance(ctx);
        AccountBankInfo info = iAccountBank.getAccountBankInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ids[0])));
        try {
            iAccountBank.unWriteOff((IObjectPK)new ObjectUuidPK(info.getId()));
            if (info.getShareType().getValue() == 1) {
                this.unCloseAccBank_UsedShareType(iAccountBank, info.getBankAccountNumber());
            }
            result.put("error", 1);
            result.put("msg", ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.AccountBankResource", (String)"Msg_SuccessUnCancelAccountBank", (Locale)ctx.getLocale()));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            result.put("error", 0);
            result.put("msg", e.getMessage());
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected Map _synAccountToBank(Context ctx) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            String ret = AccountBankFactory.getLocalInstance(ctx).synAccountToBank();
            result.setError(1);
            result.setSummaryMsg(ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.AccountBankResource", (String)"syncBankAcctErr", (Locale)ctx.getLocale()));
            String[] detailMsg = ret.split("\n");
            for (int i = 0; i < detailMsg.length; ++i) {
                result.getDetailMsgList().add(detailMsg[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setError(0);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    @Override
    protected Map _beforeShareAcct(Context ctx, String[] ids) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (ids.length > 1) {
                throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u4e0d\u5141\u8bb8\u6279\u91cf\u64cd\u4f5c\u4f7f\u7528\u6743\u8d26\u6237\u5206\u914d\uff01"});
            }
            if (this.existAcctModifyApply(ctx, ids[0])) {
                throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"209_AcctModifyApplyListUI", (Locale)ctx.getLocale())});
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("bank.*");
            AccountBankInfo info = AccountBankFactory.getLocalInstance(ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(ids[0]), sic);
            if (!this.canSharedAcct(info)) {
                throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u94f6\u884c\u8d26\u6237\u7684\u91d1\u878d\u673a\u6784\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u65f6\uff0c\u6216\u4ec5\u6709\u4f7f\u7528\u6743\u7684\u94f6\u884c\u8d26\u6237\uff0c\u6216\u662f\u5b50\u8d26\u6237\u8d26\u6237\uff0c\u4e0d\u5141\u8bb8\u8d26\u6237\u4f7f\u7528\u6743\u5206\u914d!"});
            }
            result.put("error", 1);
            result.put("shareType", info.getShareType().getValue());
        }
        catch (EASBizException e) {
            result.put("error", 0);
            result.put("msg", e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private boolean canSharedAcct(AccountBankInfo info) {
        return !info.getBank().isInGroup() && !info.isIsClosed() && info.getShareType().getValue() != 2 && EmptyUtil.isEmpty((CoreBaseInfo)info.getSubAccount());
    }

    private boolean existAcctModifyApply(Context ctx, String id) throws BOSException, Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)id));
        HashSet<Integer> billStateSet = new HashSet<Integer>();
        billStateSet.add(1);
        billStateSet.add(2);
        billStateSet.add(3);
        filter.getFilterItems().add(new FilterItemInfo("billState", billStateSet, CompareType.INCLUDE));
        ICoreBase icoreBase = (ICoreBase)BusinessProcessUtil.getBizInteface((Context)ctx, (BOSObjectType)new BOSObjectType("A4ADEA96"));
        return icoreBase.exists(filter);
    }

    private boolean existDestroyAccountApply(Context ctx, String id) throws BOSException, Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)id));
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)3));
        ICoreBase icoreBase = (ICoreBase)BusinessProcessUtil.getBizInteface((Context)ctx, (BOSObjectType)new BOSObjectType("560D4DB0"));
        return icoreBase.exists(filter);
    }

    @Override
    protected Map _saveShareAcct(Context ctx, String operateState, SharedAcctInfo model) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String operate = "EDIT";
            this.verifyInput(ctx, model);
            SharedAcctInfo shareAcct = null;
            AccountBankInfo acctBankInfo = AccountBankFactory.getLocalInstance(ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(model.getBankAccount().getId().toString()));
            if (SharedAcctType.shared.equals((Object)acctBankInfo.getShareType())) {
                shareAcct = SharedAcctFactory.getLocalInstance(ctx).getSharedAcctInfo((IObjectPK)new ObjectUuidPK(acctBankInfo.getShareAcct().getId().toString()));
                model.setId(shareAcct.getId());
            } else if (SharedAcctType.normal.equals((Object)acctBankInfo.getShareType())) {
                operate = "ADDNEW";
                AccountBankInfo tmpAcctBankInfo = null;
                for (int index = 0; index < model.getEntries().size(); ++index) {
                    SharedAcctEntriesInfo entry = model.getEntries().get(index);
                    if (EmptyUtil.isEmpty((CoreBaseInfo)entry.getAccountBank())) continue;
                    tmpAcctBankInfo = AccountBankFactory.getLocalInstance(ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(entry.getAccountBank().getId().toString()));
                    entry.setAccountBank(tmpAcctBankInfo);
                }
                model.setId(null);
            }
            IObjectPK pk = SharedAcctFactory.getLocalInstance(ctx).save((CoreBaseInfo)model);
            SharedAcctEntriesCollection coll = model.getEntries();
            if (coll.size() == 0) {
                SharedAcctFactory.getLocalInstance(ctx).delete(pk);
                operate = "DELETE";
            }
            if (!EmptyUtil.isEmpty((CoreBaseInfo)shareAcct)) {
                for (int index = 0; index < shareAcct.getEntries().size(); ++index) {
                    SharedAcctEntriesInfo entry = shareAcct.getEntries().get(index);
                    AccountBankFactory.getLocalInstance(ctx).delShareNormalAcct((IObjectValue)entry);
                }
            }
            result.put("error", 1);
            result.put("id", pk.toString());
            result.put("operateState", operate);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            e.printStackTrace();
            result.put("error", 0);
            result.put("msg", e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private void verifyInput(Context ctx, SharedAcctInfo model) throws Exception {
        if (EmptyUtil.isEmpty((CoreBaseInfo)model.getShareBalanceOfAcctCompany())) {
            throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{"\u94f6\u884c\u8d26\u53f7\u6240\u5c5e\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a!"});
        }
        this.checkCompany(ctx, model);
        this.casCheckData(ctx, model);
    }

    private void checkCompany(Context ctx, SharedAcctInfo model) throws Exception {
        HashMap<String, String> companyMap = new HashMap<String, String>();
        AccountBankInfo acctBankInfo = AccountBankFactory.getLocalInstance(ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(model.getBankAccount().getId().toString()));
        String shareCompanyid = acctBankInfo.getCompany().getId().toString();
        companyMap.put(shareCompanyid, shareCompanyid);
        String companyId = null;
        for (int i = 0; i < model.getEntries().size(); ++i) {
            if (EmptyUtil.isEmpty((CoreBaseInfo)model.getEntries().get(i).getSharedCompany()) || EmptyUtil.isEmpty((Object)model.getEntries().get(i).getSharedCompany().getId())) {
                String msg = ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.AccountBankResource", (String)"emptyCompany", (Locale)ctx.getLocale());
                throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{msg});
            }
            companyId = model.getEntries().get(i).getSharedCompany().getId().toString();
            if (companyMap.containsKey(companyId)) {
                String msg = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.AccountBankResource", (String)"sameCompany", (Locale)ctx.getLocale()), model.getEntries().get(i).getSharedCompany().getName());
                throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{msg});
            }
            companyMap.put(companyId, companyId);
        }
    }

    private void casCheckData(Context ctx, SharedAcctInfo model) throws Exception {
        SharedAcctEntriesCollection coll = model.getEntries();
        for (int i = 0; i < coll.size(); ++i) {
            SharedAcctEntriesInfo info = coll.get(i);
            if (info.isIsLinkAcct()) {
                if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getAccountBank())) continue;
                String msg = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.AccountBankResource", (String)"emptyAccountBank", (Locale)ctx.getLocale()), "" + (i + 1) + " " + info.getSharedCompany().getName());
                throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{msg});
            }
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getAccountView())) continue;
            String msg = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.AccountBankResource", (String)"emptyAccountView", (Locale)ctx.getLocale()), "" + (i + 1) + " " + info.getSharedCompany().getName(), ctx.getLocale());
            throw new AcctBankWebException(AcctBankWebException.COMMON, new Object[]{msg});
        }
    }
}

