/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AccountCussentException;
import com.kingdee.eas.basedata.assistant.AccountCussentInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractAccountCussentControllerBean;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.BizCheckerUtil;

public class AccountCussentControllerBean
extends AbstractAccountCussentControllerBean {
    protected void addnewCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkNameDup(ctx, model);
        if (((AccountCussentInfo)model).getType() == null) {
            throw new AccountCussentException(AccountCussentException.TYPE_IS_NULL);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected void updateCheck(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        AccountCussentInfo oldModel = this.getAccountCussentInfo(ctx, pk);
        Throwable e = this.checkReference(ctx, oldModel.getId());
        if (e != null) {
            throw new AccountCussentException(AccountCussentException.DO_NOT_UPDATE_REFERENCED);
        }
        if (!((DataBaseInfo)model).getNumber().equals(oldModel.getNumber())) {
            this._checkNumberDup(ctx, model);
        }
        if (!((DataBaseInfo)model).getName().equals(oldModel.getName())) {
            this._checkNameDup(ctx, model);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCheck(ctx, pk, model);
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BOSUuid id = BOSUuid.read((String)pk.toString());
        Throwable e = this.checkReference(ctx, id);
        if (e != null) {
            throw new AccountCussentException(AccountCussentException.DO_NOT_DELETE_REFERENCED);
        }
        BizCheckResult bizCheckResult = BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)id);
        if (bizCheckResult.isFound()) {
            throw new AccountCussentException(AccountCussentException.DO_NOT_DELETE_HAPPENEDBUS);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _disable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AccountCussentInfo vo = this.getAccountCussentInfo(ctx, pk);
        if (vo.isIsDisabled()) {
            throw new AccountCussentException(AccountCussentException.REDISABLE);
        }
        vo.setIsDisabled(true);
        this.update(ctx, pk, (CoreBaseInfo)vo);
    }

    @Override
    protected void _enable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AccountCussentInfo vo = this.getAccountCussentInfo(ctx, pk);
        if (!vo.isIsDisabled()) {
            throw new AccountCussentException(AccountCussentException.REENABLE);
        }
        vo.setIsDisabled(false);
        this.update(ctx, pk, (CoreBaseInfo)vo);
    }

    private Throwable checkReference(Context ctx, BOSUuid id) {
        Exception e = null;
        try {
            this._isReferenced(ctx, (IObjectPK)new ObjectUuidPK(id));
            BizCheckerUtil.isReferenced((Context)ctx, (BOSUuid)id);
        }
        catch (Exception er) {
            e = er;
        }
        return e;
    }
}

