/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fi.cas.SubAccountForBaseFactory;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyCollection;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyFactory;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyInfo;
import com.kingdee.eas.basedata.assistant.IAccountMgrStrategy;
import com.kingdee.eas.basedata.assistant.TransUpPeriodEnum;
import com.kingdee.eas.basedata.assistant.app.AbstractAccountMgrStrategyFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountMgrStrategyFacadeControllerBean
extends AbstractAccountMgrStrategyFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.AccountMgrStrategyFacadeControllerBean");

    @Override
    protected String _getCtrlMsg(Context ctx, IObjectCollection param) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectCollection _getTransUpStragety(Context ctx, Date date) throws BOSException, EASBizException {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        dayOfWeek = dayOfWeek == 1 ? 7 : --dayOfWeek;
        int dayOfMonth = calendar.get(5);
        int lastDayOfMonth = this.getLastDayOfMonth(date);
        IAccountMgrStrategy iAcctMgr = AccountMgrStrategyFactory.getLocalInstance(ctx);
        AccountMgrStrategyCollection coll = iAcctMgr.getAccountMgrStrategyCollection();
        AccountMgrStrategyCollection upColl = new AccountMgrStrategyCollection();
        AccountMgrStrategyInfo info = null;
        TransUpPeriodEnum period = null;
        int upDate = 0;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            period = info.getTransUpPeriod();
            if (period.equals((Object)TransUpPeriodEnum.PERDAY)) {
                upColl.add(info);
                continue;
            }
            if (period.equals((Object)TransUpPeriodEnum.PERWEEK)) {
                upDate = info.getTransUpDate();
                if (dayOfWeek != upDate) continue;
                upColl.add(info);
                continue;
            }
            if (!period.equals((Object)TransUpPeriodEnum.PERMONTH)) continue;
            upDate = info.getTransUpDate();
            if (upDate > lastDayOfMonth) {
                upDate = lastDayOfMonth;
            }
            if (dayOfMonth != upDate) continue;
            upColl.add(info);
        }
        return upColl;
    }

    private int getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.get(5);
    }

    @Override
    protected IObjectCollection _getTransUpAcctBankColl(Context ctx, Date date) throws BOSException, EASBizException {
        AccountMgrStrategyCollection acctMgrColl = this.getTransUpStragety(ctx, date);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ctrlStrategy.id", (Object)this.getIdSet(acctMgrColl), CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        evi.getSelector().add("subAccount.*");
        evi.getSelector().add("company.*");
        evi.getSelector().add("ctrlStrategy.*");
        return AccountBankFactory.getLocalInstance(ctx).getAccountBankCollection(evi);
    }

    private Set getIdSet(AccountMgrStrategyCollection coll) {
        HashSet<String> idSet = new HashSet<String>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            idSet.add(coll.get(i).getId().toString());
        }
        return idSet;
    }

    @Override
    protected IObjectCollection _getTransUpInnerAcctColl(Context ctx, Date date) throws BOSException, EASBizException {
        AccountMgrStrategyCollection acctMgrColl = this.getTransUpStragety(ctx, date);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ctrlParam.id", (Object)this.getIdSet(acctMgrColl), CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        evi.getSelector().add("ctrlParam.*");
        return InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountCollection(evi);
    }

    @Override
    protected IObjectCollection _getTransUpSubAcctColl(Context ctx, Date date) throws BOSException, EASBizException {
        AccountMgrStrategyCollection acctMgrColl = this.getTransUpStragety(ctx, date);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ctrlStrategy.id", (Object)this.getIdSet(acctMgrColl), CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        evi.getSelector().add("ctrlStrategy.*");
        return SubAccountForBaseFactory.createInstance().getSubAccountCollection(ctx, evi);
    }
}

