/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.JournalBalanceUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractAcctBankEntOpenRateFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AcctBankEntOpenRateFacadeControllerBean
extends AbstractAcctBankEntOpenRateFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.AcctBankEntOpenRateFacadeControllerBean");
    public static final String resourcePath = "com.kingdee.eas.basedata.assistant.RptAcctBankEntOpenRate_Resource";

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        SchemaSource ss = new SchemaSource();
        this.createSchemaSource_ByType(ss, params, ctx);
        return ss;
    }

    private void createSchemaSource_ByType(SchemaSource ss, RptParams params, Context ctx) throws BOSException {
        Set companyIdSet = (Set)params.getObject("companyIdSet");
        Set<String> bankIdSet = (Set<String>)params.getObject("bankIdSet");
        boolean kDRadioCompany = (Boolean)params.getObjectElement("kDRadioCompany.value");
        boolean kDRadioBank = (Boolean)params.getObjectElement("kDRadioBank.value");
        String configFile = "";
        if (kDRadioCompany) {
            configFile = "RptAcctBankEntOpenRate_company.xml";
        }
        if (kDRadioBank) {
            configFile = "RptAcctBankEntOpenRate_bank.xml";
        }
        String loc = AcctBankEntOpenRateFacadeControllerBean.getLoc((Context)ctx);
        StringBuffer sql = new StringBuffer();
        StringBuffer mdx = new StringBuffer();
        SqlParams spCompany = new SqlParams();
        sql.append("select A.FID,A.FName_").append(loc).append(" FName, A.FParentID from t_org_company A where 1=1 ");
        JournalBalanceUtil.appendFilter((String)"A.FID", (Set)companyIdSet, (StringBuffer)sql, (SqlParams)spCompany, (String)"and");
        ss.setDataItem("Company", sql.toString(), spCompany);
        sql.setLength(0);
        SqlParams spBank = new SqlParams();
        sql.append("Select FID, FName_").append(loc).append(" FName , FNumber from T_BD_Bank where 1=1 ");
        if (bankIdSet == null || bankIdSet.size() <= 0) {
            bankIdSet = this.getTopBankIdSet(ctx);
        }
        JournalBalanceUtil.appendFilter((String)"FID", bankIdSet, (StringBuffer)sql, (SqlParams)spBank, (String)"and");
        ss.setDataItem("Bank", sql.toString(), spBank);
        Map<String, String> son_topBankIdMap = this.getSonTopBankMap(ctx, bankIdSet);
        String tableName = this.bulidRptEntOpenRates(ctx, companyIdSet, son_topBankIdMap);
        StringBuffer factSql = new StringBuffer();
        SqlParams factsp = new SqlParams();
        factSql.append("Select FCompanyId, FTopBankId, FTotalCount, FBeCount from ").append(tableName);
        ss.setDataItem("Fact", factSql.toString(), factsp);
        String title = ResourceBase.getString((String)resourcePath, (String)"FBeRate", (Locale)ctx.getLocale());
        if (kDRadioCompany) {
            mdx.append(" WITH MEMBER Measures.[BePercent] AS ' ((Bank.CurrentMember, Measures.[FBeCount]) / (Bank.CurrentMember, Measures.[FTotalCount]))', caption='" + title + "', FORMAT_STRING = '0.00%' ");
            mdx.append(" SELECT {Measures.[FTotalCount], Measures.[FBeCount], Measures.[BePercent]} ON COLUMNS , ");
            mdx.append(" FactMembersWithPCD(Company,Bank) on rows from fm");
        }
        if (kDRadioBank) {
            mdx.append(" WITH MEMBER Measures.[BePercent] AS '((Company.CurrentMember, Measures.[FBeCount]) / (Company.CurrentMember, Measures.[FTotalCount]))', caption='" + title + "', FORMAT_STRING = '0.00%' ");
            mdx.append(" SELECT {Measures.[FTotalCount], Measures.[FBeCount], Measures.[BePercent]} ON COLUMNS , ");
            mdx.append(" FactMembersWithPCD(Bank,Company) on rows from fm");
        }
        ss.setCaller(AcctBankEntOpenRateFacadeControllerBean.class);
        ss.setFilename(configFile);
        ss.setMdx(mdx.toString());
    }

    private Map<String, String> getSonTopBankMap(Context ctx, Set bankIdSet) throws BOSException {
        HashMap<String, String> son_topBankIdMap = new HashMap<String, String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)bankIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        BankCollection topBankColl = BankFactory.getLocalInstance(ctx).getBankCollection(view);
        for (int i = 0; i < topBankColl.size(); ++i) {
            BankInfo topBankInfo = topBankColl.get(i);
            this.fillSonTopBankIdMap(ctx, topBankInfo, son_topBankIdMap);
        }
        return son_topBankIdMap;
    }

    private Set<String> getTopBankIdSet(Context ctx) throws BOSException {
        HashSet<String> topBankIdSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("level", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1));
        view.setFilter(filter);
        BankCollection topBankColl = BankFactory.getLocalInstance(ctx).getBankCollection(view);
        for (int i = 0; i < topBankColl.size(); ++i) {
            String bankId = topBankColl.get(i).getId().toString();
            topBankIdSet.add(bankId);
        }
        return topBankIdSet;
    }

    private void fillSonTopBankIdMap(Context ctx, BankInfo topBankInfo, Map<String, String> son_topBankIdMap) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)topBankInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(topBankInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("inGroup", (Object)false));
        filter.getFilterItems().add(new FilterItemInfo("inGroup", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("isFinanceCompany", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1));
        filter.setMaskString("(#0 or #1) and (#2 or (#3 and #4)) and #5");
        view.setFilter(filter);
        BankCollection bankColl = BankFactory.getLocalInstance(ctx).getBankCollection(view);
        for (int i = 0; i < bankColl.size(); ++i) {
            String bankId = bankColl.get(i).getId().toString();
            son_topBankIdMap.put(bankId, topBankInfo.getId().toString());
        }
    }

    private String bulidRptEntOpenRates(Context ctx, Set<String> companyIdSet, Map<String, String> son_topBankIdMap) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", companyIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bank.id", new HashSet<String>(son_topBankIdMap.keySet()), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)false));
        filter.getFilterItems().add(new FilterItemInfo("shareType", (Object)2, CompareType.NOTEQUALS));
        view.setFilter(filter);
        AccountBankCollection coll = AccountBankFactory.getLocalInstance(ctx).getAccountBankCollection(view);
        HashMap<String, Integer> totalMap = new HashMap<String, Integer>();
        HashMap<String, Integer> beMap = new HashMap<String, Integer>();
        for (int i = 0; i < coll.size(); ++i) {
            AccountBankInfo acctBank = coll.get(i);
            String companyId = acctBank.getCompany().getId().toString();
            String bankId = acctBank.getBank().getId().toString();
            String topBankId = son_topBankIdMap.get(bankId);
            String key = companyId + "-" + topBankId;
            int totalCount = totalMap.get(key) == null ? 0 : (Integer)totalMap.get(key);
            totalMap.put(key, totalCount + 1);
            if (!acctBank.isIsSetBankInterface()) continue;
            int beCount = beMap.get(key) == null ? 0 : (Integer)beMap.get(key);
            beMap.put(key, beCount + 1);
        }
        String tableName = this.insertTempTableDatas(ctx, totalMap, beMap);
        return tableName;
    }

    private String insertTempTableDatas(Context ctx, Map<String, Integer> totalMap, Map<String, Integer> beMap) throws BOSException {
        String tableName = this.buildRptTempTable(ctx);
        StringBuffer insertTableSql = new StringBuffer();
        for (String key : totalMap.keySet()) {
            String companyId = key.split("-")[0];
            String bankId = key.split("-")[1];
            int totalCount = totalMap.get(key) == null ? 0 : totalMap.get(key);
            int beCount = beMap.get(key) == null ? 0 : beMap.get(key);
            insertTableSql = insertTableSql.append("insert into " + tableName + " values('" + companyId + "', '" + bankId + "', " + totalCount + ", " + beCount + " )").append(";");
        }
        if (insertTableSql.length() > 0) {
            this.executeBatchUpdate(ctx, insertTableSql.toString().split(";"));
        }
        return tableName;
    }

    private String buildRptTempTable(Context ctx) throws BOSException {
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append(" if not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_TABNAME='T_Temp_RptEntOpenRate') ");
        createTableSql.append(" Create Table T_Temp_RptEntOpenRate ( FCompanyId Varchar(44), FTopBankId Varchar(44), FTotalCount Int DEFAULT 0, FBeCount Int DEFAULT 0 ); ");
        DbUtil.execute((Context)ctx, (String)createTableSql.toString());
        String deleteSQL = "truncate table T_Temp_RptEntOpenRate";
        DbUtil.execute((Context)ctx, (String)deleteSQL);
        return "T_Temp_RptEntOpenRate";
    }

    protected int[] executeBatchUpdate(Context ctx, String[] sqls) throws BOSException {
        int[] i2;
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection(ctx);
            ps = con.createStatement();
            int n = sqls.length;
            for (int i2 = 0; i2 < n; ++i2) {
                ps.addBatch(sqls[i2]);
            }
            i2 = ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                e.setNextException(new SQLException("Execute batch update: " + ps));
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
        return i2;
    }
}

