/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.master.account.AbstractAccountRefContrastProcess;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BankAccountRefContrastProcess
extends AbstractAccountRefContrastProcess {
    private Logger logger = Logger.getLogger((String)BankAccountRefContrastProcess.class.getName());

    public boolean enable(Context ctx, String companyID, String acrefID) throws BOSException, EASBizException {
        this.logger.info((Object)("---BankAccountRefContrastProcess#enable start---,acrefID is :" + acrefID + "   companyID is: " + companyID));
        this.insertRefContrastBankAcctChangeData(ctx, acrefID);
        this.enableChangeAccountBankfication(ctx, companyID, acrefID);
        this.logger.info((Object)"---BankAccountRefContrastProcess#enable end---");
        return true;
    }

    private void insertRefContrastBankAcctChangeData(Context ctx, String acrefID) throws BOSException {
        StringBuilder querySql = new StringBuilder();
        querySql.append("SELECT Max(FVersion) version FROM T_BD_AcctRefConBankAcctChange WHERE facrefId = '" + acrefID + "'");
        Integer version = null;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        try {
            while (rowSet.next()) {
                String versionStr = rowSet.getString("version");
                version = versionStr == null ? null : Integer.valueOf(versionStr);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"insertAcctRefConBankAcctChange query error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        querySql.setLength(0);
        querySql.append("SELECT head.Fid AcrefId,en.foldacctid oldAcctId,en.fnewacctid newAcctId,head.fdisabledaccttableid oldAcctTabId, head.fenabledaccttableid newAcctTabId,banks.fid acctBanksId ").append(" FROM  t_bd_acctrefcontrastentry en ").append(" INNER JOIN t_bd_acctrefcontrast head ON en.facctrefcontrastid = head.fid ").append(" INNER JOIN T_BD_AccountBanks banks on banks.FAccountID = en.foldacctid ").append(" WHERE head.fid = '" + acrefID + "'");
        IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        Connection cn = null;
        Statement stmt = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.createStatement();
            version = version == null ? 1 : version + 1;
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String controlUnitId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            StringBuilder insertSql = null;
            while (rowSet2.next()) {
                insertSql = new StringBuilder();
                insertSql.append("INSERT INTO T_BD_AcctRefConBankAcctChange (Fid,FAcrefId,FOldAcctId,FNewAcctId,FOldAcctTabId").append(",FNewAcctTabId,FVersion,FBankAccountIdID,FCreatorId,FCreateTime,FLastUpdateUserId,FLastUpdateTime,FControlUnitId) ").append(" SELECT newbosid('6E2D609F') Fid,").append("'").append(rowSet2.getString("AcrefId")).append("',").append("'").append(rowSet2.getString("oldAcctId")).append("',").append("'").append(rowSet2.getString("newAcctId")).append("',").append("'").append(rowSet2.getString("oldAcctTabId")).append("',").append("'").append(rowSet2.getString("newAcctTabId")).append("',").append(version).append(",").append("'").append(rowSet2.getString("acctBanksId")).append("',").append("'").append(userId).append("',").append("getdate(),").append("'").append(userId).append("',").append("getdate(),").append("'").append(controlUnitId).append("'");
                stmt.addBatch(insertSql.toString());
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)"AcctRefConBankAcctChange insert error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    private void enableChangeAccountBankfication(Context ctx, String companyID, String acrefID) throws EASBizException, BOSException {
        String templeTable = this.createEnableTempleTable(ctx, acrefID);
        try {
            String disableTab = null;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select top 1 * from " + templeTable));
            while (rs.next()) {
                disableTab = rs.getString("FoldAcctTabID");
            }
            if (disableTab == null) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("UPDATE t_bd_accountbanks  SET (faccountid, fcontrolunitid) =  \r\n");
            sb.append("(select top 1 tem.fnewacctid, t_bd_accountbanks.fcontrolunitid  from " + templeTable + "\r\n");
            sb.append(" tem where tem.foldacctid = t_bd_accountbanks.faccountid  ");
            sb.append(" and t_bd_accountbanks.fcompanyid='" + companyID + "')");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        catch (Exception e) {
            this.logger.error((Object)"enableChangeAccountBankfication error:", (Throwable)e);
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                ITableManagerFacade mfa = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
                if (mfa.existTable(templeTable)) {
                    mfa.releaseTableName(templeTable);
                }
            }
            catch (BOSException e) {
                this.logger.error((Object)"enableChangeAccountBankfication tem table release error:", (Throwable)e);
            }
        }
    }

    public String createEnableTempleTable(Context ctx, String acrefID) throws BOSException {
        ITableManagerFacade mfa = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tempTable = mfa.getTemporaryTableName("BankAcctEnableTempleName");
        StringBuffer createSql = new StringBuffer();
        createSql.append("Create Table ");
        createSql.append(tempTable);
        createSql.append("(");
        createSql.append("FoldAcctID \tVARCHAR(44), ");
        createSql.append("FnewAcctID \tVARCHAR(44), ");
        createSql.append("FoldAcctTabID \tVARCHAR(44), ");
        createSql.append("FnewAcctTabID \tVARCHAR(44) ");
        createSql.append(")");
        mfa.createTempTable(createSql.toString());
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ");
        insertSql.append(tempTable);
        insertSql.append(" SELECT   En.Foldacctid,     \r\n");
        insertSql.append("         En.Fnewacctid,     \r\n");
        insertSql.append("         Head.Fdisabledaccttableid,     \r\n");
        insertSql.append("         Head.Fenabledaccttableid     \r\n");
        insertSql.append("FROM     T_bd_acctrefcontrastentry En     \r\n");
        insertSql.append("         INNER JOIN T_bd_acctrefcontrast Head     \r\n");
        insertSql.append("           ON En.Facctrefcontrastid = Head.Fid     \r\n");
        insertSql.append("WHERE    Head.Fid = '" + acrefID + "'     \r\n");
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
        return tempTable;
    }

    public boolean disEnable(Context ctx, String companyID, String acrefID) throws BOSException, EASBizException {
        this.logger.info((Object)("---BankAccountRefContrastProcess#disEnable start---,acrefID is :" + acrefID + "  companyID is: " + companyID));
        String querySql = "SELECT Max(FVersion) version FROM T_BD_AcctRefConBankAcctChange WHERE facrefId = '" + acrefID + "'";
        Integer version = null;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql);
        try {
            while (rowSet != null && rowSet.next()) {
                String versionStr = rowSet.getString("version");
                version = versionStr == null ? null : Integer.valueOf(versionStr);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"BankAccountRefContrastProcess#disEnable error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (version == null) {
            this.logger.error((Object)("\u94f6\u884c\u8d26\u6237\u5bf9\u7167\u8868\u542f\u7528\u65f6\uff0c\u65e0\u53d8\u66f4\u8bb0\u5f55\u8868\u6570\u636e\uff0c\u5bf9\u7167\u8868acrefID\u503c\u4e3a\uff1a" + acrefID));
            this.AccountBanksDataReductionOld(ctx, acrefID, companyID);
        } else {
            this.AccountBanksDataReductionNew(ctx, companyID, acrefID, version);
        }
        this.logger.info((Object)"---BankAccountRefContrastProcess#disEnable end---");
        return true;
    }

    private void AccountBanksDataReductionOld(Context ctx, String acrefID, String companyID) throws BOSException, EASBizException {
        String templeTable = this.createDisableTempleTable(ctx, acrefID);
        try {
            String disableTab = null;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select top 1 * from " + templeTable));
            while (rs.next()) {
                disableTab = rs.getString("FoldAcctTabID");
            }
            if (disableTab == null) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("UPDATE T_BD_AccountBanks SET (faccountid, fcontrolunitid) =  \r\n");
            sb.append("(select top 1 tem.fnewacctid, t_bd_accountbanks.fcontrolunitid from " + templeTable + "\r\n");
            sb.append(" tem where tem.foldacctid = T_BD_AccountBanks.faccountid)");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                ITableManagerFacade manager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
                if (manager.existTable(templeTable)) {
                    manager.releaseTableName(templeTable);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    private void AccountBanksDataReductionNew(Context ctx, String companyID, String acrefID, Integer version) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT FBankAccountIdID bankAccountId,FOldAcctId OldAcctId,FNewAcctId NewAcctId,FOldAcctTabId oldAcctTab,FNewAcctTabId newAcctTab FROM T_BD_AcctRefConBankAcctChange").append(" WHERE FAcrefId = '" + acrefID + "'").append(" AND FVersion = ").append(version);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String disableTable = null;
            String enableTable = null;
            HashMap<String, String> updateAccountBanksMap = new HashMap<String, String>();
            while (rs.next()) {
                updateAccountBanksMap.put(rs.getString("bankAccountId"), rs.getString("OldAcctId"));
                if (disableTable == null || disableTable.length() < 0) {
                    disableTable = rs.getString("newAcctTab");
                }
                if (enableTable != null && enableTable.length() >= 0) continue;
                enableTable = rs.getString("oldAcctTab");
            }
            cn = this.getConnection(ctx);
            stmt = cn.createStatement();
            StringBuilder updateAccountBanksSql = null;
            for (String key : updateAccountBanksMap.keySet()) {
                String value = (String)updateAccountBanksMap.get(key);
                updateAccountBanksSql = new StringBuilder();
                updateAccountBanksSql.append("UPDATE T_BD_AccountBanks ").append(" SET FAccountID = '").append(value).append("'").append(" WHERE Fid = '").append(key).append("'");
                stmt.addBatch(updateAccountBanksSql.toString());
            }
            stmt.executeBatch();
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)("AccountBanksDataReductionNew update sql error:" + e));
                if (e instanceof EASBizException) {
                    throw (EASBizException)((Object)e);
                }
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public String createDisableTempleTable(Context ctx, String acrefID) throws BOSException {
        ITableManagerFacade mfa = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tempTable = mfa.getTemporaryTableName("BankAcctDisableTempleName");
        StringBuffer createSql = new StringBuffer();
        createSql.append("Create Table ");
        createSql.append(tempTable);
        createSql.append("(");
        createSql.append("FoldAcctID \tVARCHAR(44), ");
        createSql.append("FnewAcctID \tVARCHAR(44), ");
        createSql.append("FoldAcctTabID \tVARCHAR(44), ");
        createSql.append("FnewAcctTabID \tVARCHAR(44) ");
        createSql.append(")");
        mfa.createTempTable(createSql.toString());
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ");
        insertSql.append(tempTable);
        insertSql.append(" SELECT   En.Fnewacctid,     \r\n");
        insertSql.append("         En.Foldacctid,     \r\n");
        insertSql.append("         Head.Fenabledaccttableid,     \r\n");
        insertSql.append("         Head.Fdisabledaccttableid     \r\n");
        insertSql.append("FROM     T_bd_acctrefcontrastentry En     \r\n");
        insertSql.append("         INNER JOIN T_bd_acctrefcontrast Head     \r\n");
        insertSql.append("           ON En.Facctrefcontrastid = Head.Fid     \r\n");
        insertSql.append("WHERE    Head.Fid = '" + acrefID + "'     \r\n");
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
        return tempTable;
    }
}

