/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankException;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractBankControllerBean;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.util.StringUtility;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BankControllerBean
extends AbstractBankControllerBean {
    private static Logger logger = Logger.getLogger(BankControllerBean.class);

    public void isReferenced(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super.isReferenced(ctx, pk);
        this.deleteCheck(ctx, pk);
    }

    private void deleteCheck(Context ctx, IObjectPK pk) throws BOSException, EASBizException, BankException {
        BankInfo info = BankFactory.getLocalInstance(ctx).getBankInfo(pk);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select count(fid) as c from T_BD_Bank where FParentId=?", (Object[])new Object[]{info.getId().toString()});
        try {
            rs.next();
            if (rs.getInt("c") > 0) {
                throw new BankException(BankException.REFBYCHILDBANK);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (info.isInGroup() && info.isUsed()) {
            throw new BankException(BankException.CLEARHOUSECANNOTDELETE);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.isReferenced(ctx, pk);
        BankInfo info = BankFactory.getLocalInstance(ctx).getBankInfo(pk);
        this.updateParent(ctx, info);
        super._delete(ctx, pk);
    }

    private void updateParent(Context ctx, BankInfo info) throws BOSException {
        if (info.getLevel() != 1) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select count(fid) as c from T_BD_Bank where FparentId=?", (Object[])new Object[]{info.getParent().getId().toString()});
            try {
                rs.next();
                if (rs.getInt("c") == 1) {
                    DbUtil.execute((Context)ctx, (String)"update T_BD_Bank set FIsLeaf=1 where FID=?", (Object[])new Object[]{info.getParent().getId().toString()});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected void addnewCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkNameDup(ctx, model);
        BankInfo info = (BankInfo)model;
        if (info.getParent() != null) {
            BankInfo p = this.getBankInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getParent().getId()));
            if (p.isIsBank() != info.isIsBank()) {
                throw new BankException(BankException.NOTSAMEISBANK);
            }
            if (p.isInGroup() != info.isInGroup()) {
                throw new BankException(BankException.NOTSAMEISCLEARH);
            }
        }
        if (info.getRelatedCompany() == null) {
            return;
        }
        BOSUuid refCompanyId = info.getRelatedCompany().getId();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select count(fid) as c from T_BD_Bank where FrelatedCompanyId=?", (Object[])new Object[]{refCompanyId.toString()});
        try {
            rs.next();
            if (rs.getInt("c") > 0) {
                throw new BankException(BankException.MANYBANKCANNOTPOINTTOONECOMPANY);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, model);
        this.setLongNumberInGroup(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BankInfo info = (BankInfo)model;
        this.submitCheck(ctx, model);
        info.setOpenDate(BankControllerBean.getDayBegin(info.getOpenDate()));
        info.setSettleDate(BankControllerBean.getDayBegin(info.getSettleDate()));
        return super._submit(ctx, model);
    }

    private void submitCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BankInfo info = (BankInfo)model;
        BankInfo parent = info.getParent();
        if (parent != null) {
            info.setLevel(parent.getLevel() + 1);
            if (info.getId() == null) {
                info.setIsLeaf(true);
            }
            DbUtil.execute((Context)ctx, (String)"update T_BD_Bank set FIsLeaf=0 where FID=?", (Object[])new Object[]{parent.getId().toString()});
        }
    }

    protected boolean updateCheck(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BankInfo info;
        boolean hasChanged = false;
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        BankInfo oldModel = this.getBankInfo(ctx, pk);
        if (!((DataBaseInfo)model).getNumber().equals(oldModel.getNumber())) {
            this._checkNumberDup(ctx, model);
        }
        if (!((DataBaseInfo)model).getName().equals(oldModel.getName())) {
            this._checkNameDup(ctx, model);
        }
        if ((info = (BankInfo)model).getParent() != null) {
            BankInfo p = this.getBankInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getParent().getId()));
            if (p.isIsBank() != info.isIsBank()) {
                throw new BankException(BankException.NOTSAMEISBANK);
            }
            if (p.isInGroup() != info.isInGroup()) {
                throw new BankException(BankException.NOTSAMEISCLEARH);
            }
        }
        return hasChanged;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BankInfo bankInfo = (BankInfo)model;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("parent.*"));
        BankInfo oldInfo = (BankInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(bankInfo.getId()), selector);
        if (!(EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getParent()) || bankInfo.getParent() != null && bankInfo.getParent().getId().equals((Object)oldInfo.getParent().getId()))) {
            this.updateParentForUpdate(ctx, bankInfo, oldInfo);
        }
        this.updateCheck(ctx, pk, model);
        super._update(ctx, pk, model);
        this.updateLongNumberInGroup(ctx, pk, model);
        if (ContextUtil.getCurrentFIUnit((Context)ctx) == null) {
            return;
        }
        ParamItemInfo item = ParamManager.getParamItemInfoByNumberAndOrg((Context)ctx, (String)"GL_050", (String)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        if (item != null && item.getValue().equals("true")) {
            BankInfo bank = (BankInfo)model;
            String sql = "update t_bd_accountbanks set fname_l2='" + bank.getName(LocaleUtils.getLocale((String)"l2")) + "'||FBankAccountNumber, fname_l3='" + bank.getName(LocaleUtils.getLocale((String)"l3")) + "'||FBankAccountNumber where fbank=? and fcompanyid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{bank.getId().toString(), ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    @Override
    protected boolean _existsClearingHouse(Context ctx) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select count(fid) as c from T_BD_Bank where fisingroup=1");
        try {
            rs.next();
            return rs.getInt("c") > 0;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected IObjectValue _getClearingHouse(Context ctx, String companyId) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((String)companyId)) {
            companyId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.getSelector().add("relatedCompany.*");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("inGroup", (Object)new Boolean(true)));
        if (companyId != null && companyId.trim().length() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("relatedCompany.id", (Object)companyId));
        }
        evi.setFilter(filterInfo);
        BankCollection collection = BankFactory.getLocalInstance(ctx).getBankCollection(evi);
        if (collection.size() <= 0) {
            return null;
        }
        if (collection.size() == 1) {
            return collection.get(0);
        }
        throw new BankException(BankException.MANYBANKCANNOTPOINTTOONECOMPANY);
    }

    @Override
    protected IObjectCollection _getAllChildBank(Context ctx, String bankId) throws BOSException, EASBizException {
        BankCollection bc = new BankCollection();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)bankId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        BankCollection bankCollection = BankFactory.getLocalInstance(ctx).getBankCollection(evi);
        bc.addCollection(bankCollection);
        int n = bankCollection.size();
        for (int i = 0; i < n; ++i) {
            BankInfo bank = bankCollection.get(i);
            if (bank.isIsLeaf()) continue;
            bc.addCollection((BankCollection)this._getAllChildBank(ctx, bank.getId().toString()));
        }
        return bc;
    }

    public static Date getDayBegin(Date d) {
        if (d == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date ds = new Date(cal.getTimeInMillis());
        return ds;
    }

    protected IObjectValue _getClearingHouseCompany(Context ctx) throws BOSException, EASBizException {
        BankInfo ch = (BankInfo)this._getClearingHouse(ctx, null);
        if (ch == null) {
            return null;
        }
        return ch.getRelatedCompany();
    }

    @Override
    protected boolean _isClearinghouseCompany(Context ctx, String companyId) throws BOSException, EASBizException {
        BankInfo chCompany;
        if (companyId == null || companyId.trim().length() == 0) {
            logger.error((Object)"ClearnHouse need companyId", (Throwable)new BOSException());
            companyId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        }
        if ((chCompany = (BankInfo)this._getClearingHouse(ctx, companyId)) == null) {
            return false;
        }
        return chCompany.isInGroup();
    }

    protected boolean _isClearinghouseCompany(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        return this._isClearinghouseCompany(ctx, companyInfo.getId().toString());
    }

    private void setLongNumberInGroup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BankInfo bankInfo = (BankInfo)model;
        BankInfo parent = this.getFullParent(ctx, (IObjectValue)bankInfo);
        if (parent == null || parent.getId().equals((Object)bankInfo.getId())) {
            bankInfo.setLevel(1);
            bankInfo.setLongNumberInGroup(bankInfo.getNumber());
            this.checkLongNumberLen(ctx, bankInfo);
        } else {
            bankInfo.setLevel(1);
            bankInfo.setLongNumberInGroup(parent.getLongNumberInGroup() + "!" + bankInfo.getNumber());
            this.checkLongNumberLen(ctx, bankInfo);
        }
    }

    private void updateLongNumberInGroup(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BankInfo bankInfo = (BankInfo)model;
        BankInfo oldInfo = (BankInfo)this._getValue(ctx, pk);
        String oldLongNumberInGroup = oldInfo.getLongNumberInGroup();
        if (bankInfo.containsKey("number") && oldLongNumberInGroup != null) {
            String parentLongNumber;
            String longNumberInGroup = "";
            longNumberInGroup = oldLongNumberInGroup;
            BankInfo parent = this.getFullParent(ctx, (IObjectValue)bankInfo);
            if (parent != null && (longNumberInGroup.equals(parentLongNumber = parent.getLongNumberInGroup()) || parentLongNumber.startsWith(longNumberInGroup))) {
                throw new BankException(BankException.PARENTCANNOTBESELFORCHILDREN);
            }
            if (parent == null || parent.getId().equals((Object)bankInfo.getId())) {
                bankInfo.setLongNumberInGroup(bankInfo.getNumber());
                this.checkLongNumberLen(ctx, bankInfo);
            } else {
                bankInfo.setLongNumberInGroup(parent.getLongNumberInGroup() + "!" + bankInfo.getNumber());
                this.checkLongNumberLen(ctx, bankInfo);
            }
            this.checkLNForTree(ctx, bankInfo);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(bankInfo.getId()), (IObjectValue)bankInfo);
            if (longNumberInGroup != null && !longNumberInGroup.equals(bankInfo.getLongNumberInGroup())) {
                this.updateChildrenByNumberUpdated(ctx, (IObjectValue)bankInfo, longNumberInGroup);
            }
        }
    }

    private void checkLongNumberLen(Context ctx, BankInfo info) throws EASBizException, BOSException {
        String propertyAlias = null;
        String longNumberParam = null;
        int maxLen = 0;
        propertyAlias = this.getPropertyAlias(ctx, (CoreBaseInfo)info, "parentInGroup", ctx.getLocale());
        int len = null == info.getLongNumberInGroup() ? -1 : info.getLongNumberInGroup().getBytes().length;
        longNumberParam = ParamManager.getParamValue((Context)ctx, null, (String)"TreeLongNumberlen");
        if (longNumberParam != null) {
            maxLen = Integer.parseInt(longNumberParam);
        }
        if (maxLen > 80) {
            if (len > maxLen) {
                throw new TreeBaseException(TreeBaseException.CHECKLONGNUMBERLEN, new Object[]{propertyAlias, String.valueOf(maxLen)});
            }
        } else if (len > 80) {
            throw new TreeBaseException(TreeBaseException.CHECKLONGNUMBERLEN, new Object[]{propertyAlias, String.valueOf(80)});
        }
    }

    private String getPropertyAlias(Context ctx, CoreBaseInfo info, String propertyName, Locale locale) {
        String alias = null;
        PropertyInfo property = this.getProperty(ctx, info, propertyName);
        if (property != null) {
            alias = property.getAlias(locale);
        }
        return alias;
    }

    private PropertyInfo getProperty(Context ctx, CoreBaseInfo info, String propertyName) {
        EntityObjectInfo entity = this.getBOSEntity(ctx, info);
        PropertyInfo property = null;
        property = entity.getPropertyByNameRuntime(propertyName);
        return property;
    }

    private BankInfo getFullParent(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BankInfo bankInfo = (BankInfo)model;
        BankInfo parent = (BankInfo)bankInfo.get("parentInGroup");
        if (parent == null || parent.getId().equals((Object)bankInfo.getId())) {
            return null;
        }
        parent = this.lazyLoad(ctx, (IObjectValue)parent);
        bankInfo.setParentInGroup(parent);
        return parent;
    }

    private BankInfo lazyLoad(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BankInfo BankInfo2 = (BankInfo)model;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("longNumber"));
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("parentInGroup"));
        selector.add(new SelectorItemInfo("longNumberInGroup"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("level"));
        selector.add(new SelectorItemInfo("isLeaf"));
        selector.add(new SelectorItemInfo("displayName"));
        selector.add(new SelectorItemInfo("deletedStatus"));
        BankInfo result = (BankInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(BankInfo2.getId()), selector);
        return result;
    }

    private void updateChildrenByNumberUpdated(Context ctx, IObjectValue model, String oldLongNumberInGroup) throws BOSException, EASBizException {
        BankInfo bankInfo = (BankInfo)model;
        String longNumberInGroup = bankInfo.getLongNumberInGroup();
        FilterItemInfo item = new FilterItemInfo("longNumberInGroup", (Object)(oldLongNumberInGroup + "!" + "%"), CompareType.LIKE);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(item);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        TreeBaseCollection collection = this.getTreeBaseCollection(ctx, view);
        BankInfo temp2 = null;
        for (BankInfo temp2 : collection) {
            String temps = StringUtility.castRegular((String)oldLongNumberInGroup);
            temp2.setLongNumberInGroup(temp2.getLongNumberInGroup().replaceFirst(temps, longNumberInGroup));
            this.checkLongNumberLen(ctx, bankInfo);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(temp2.getId()), (IObjectValue)temp2);
        }
    }

    private void updateParentForUpdate(Context ctx, BankInfo info, BankInfo oldInfo) throws BOSException {
        if (oldInfo.getLevel() != 1 && !EmptyUtil.isEmpty((Object)oldInfo.getParent().getId())) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select count(fid) as c from T_BD_Bank where FparentId = ?", (Object[])new Object[]{oldInfo.getParent().getId().toString()});
            try {
                rs.next();
                if (rs.getInt("c") == 1) {
                    DbUtil.execute((Context)ctx, (String)"update T_BD_Bank set FIsLeaf=1 , flevel = 1 where FID=?", (Object[])new Object[]{oldInfo.getParent().getId().toString()});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected Map _isClearinghouseCompany(Context ctx, CompanyOrgUnitInfo[] companys) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        HashSet<String> clearinghouseSet = new HashSet<String>();
        HashSet<String> noClearinghouseSet = new HashSet<String>();
        for (int i = 0; i < companys.length; ++i) {
            if (this._isClearinghouseCompany(ctx, companys[i].getId().toString())) {
                clearinghouseSet.add(companys[i].getId().toString());
                continue;
            }
            noClearinghouseSet.add(companys[i].getId().toString());
        }
        result.put("clearinghouseSet", clearinghouseSet);
        result.put("noClearinghouseSet", noClearinghouseSet);
        return result;
    }
}

