/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyException;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractCurrencyControllerBean;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.BizHasDealException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CurrencyControllerBean
extends AbstractCurrencyControllerBean {
    private void checkNumberCharacter(CurrencyInfo model) throws EASBizException {
        char[] chs = model.getNumber().trim().toCharArray();
        Pattern p = Pattern.compile("[a-zA-Z_0-9]");
        for (int i = 0; i < chs.length; ++i) {
            Matcher m = p.matcher(Character.toString(chs[i]));
            if (m.matches()) continue;
            throw new CurrencyException(CurrencyException.NUMBER_MUST_LETTER_OR_DIGIT);
        }
    }

    private void checkSortNumber(IObjectValue model) throws CurrencyException {
        if (model.get("sortnumber") != null) {
            if (model.get("sortnumber").toString().equals("0")) {
                throw new CurrencyException(CurrencyException.SORTNUMBER_ILLEGAL);
            }
            if (model.get("sortnumber").toString().trim().equals("")) {
                model.setInt("sortnumber", 999);
            }
        } else {
            model.setInt("sortnumber", 999);
        }
    }

    protected void addnewCheck(Context ctx, CurrencyInfo model) throws BOSException, EASBizException {
        model.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        this._checkNumberBlank(ctx, (IObjectValue)model);
        this._checkNumberDup(ctx, (IObjectValue)model);
        if (model.getNumber().trim().length() > 12) {
            throw new CurrencyException(CurrencyException.NUMBER_TOO_LONG);
        }
        this.checkNumberCharacter(model);
        this.checkSortNumber((IObjectValue)model);
        this._checkNameBlank(ctx, (IObjectValue)model);
        this._checkNameDup(ctx, (IObjectValue)model);
        Locale locale = ContextUtils.getLocaleFromEnv();
        String basUnit = model.getBaseUnit(locale);
        if (basUnit == null) {
            throw new CurrencyException(CurrencyException.BASE_UNIT_NOT_NULL);
        }
        if (model.getBaseUnit() != null && model.getBaseUnit().length() > 8) {
            throw new CurrencyException(CurrencyException.BASE_UNIT_TOO_LONG);
        }
        if (model.getSign() != null && model.getSign().trim().length() > 4) {
            throw new CurrencyException(CurrencyException.SIGN_TOO_LONG);
        }
        if (model.getPrecision() < 0) {
            throw new CurrencyException(CurrencyException.PRECISION_NOT_NEGATIVE);
        }
        if (model.getPrecision() > 4) {
            model.setPrecision(4);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, (CurrencyInfo)model);
        return super._addnew(ctx, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, (CurrencyInfo)model);
        super._addnew(ctx, pk, model);
    }

    private boolean isHasDeal(Context ctx, BOSUuid id) {
        boolean hasDeal = false;
        try {
            BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)id);
        }
        catch (BizHasDealException e) {
            hasDeal = true;
        }
        return hasDeal;
    }

    private void checkHasDeal(Context ctx, CurrencyInfo oldVO, CurrencyInfo updateVO) throws EASBizException {
        boolean hasDeal;
        Boolean has = null;
        if (!EqualsUtil.equals((String)oldVO.getBaseUnit(), (String)updateVO.getBaseUnit())) {
            if (has == null) {
                hasDeal = this.isHasDeal(ctx, updateVO.getId());
                has = hasDeal;
            }
            if (has.booleanValue()) {
                throw new CurrencyException(CurrencyException.HAS_DEAL_NOT_UPDATE_BASEUNIT);
            }
        }
        if (oldVO.getPrecision() > updateVO.getPrecision()) {
            if (has == null) {
                hasDeal = this.isHasDeal(ctx, updateVO.getId());
                has = hasDeal;
            }
            if (has.booleanValue()) {
                throw new CurrencyException(CurrencyException.HAS_DEAL_NOT_REDUCE_PRECISION);
            }
        }
    }

    private Throwable checkReference(Context ctx, BOSUuid id) {
        Exception e = null;
        try {
            this._isReferenced(ctx, (IObjectPK)new ObjectUuidPK(id));
            BizCheckerUtil.isReferenced((Context)ctx, (BOSUuid)id);
        }
        catch (Exception er) {
            e = er;
        }
        return e;
    }

    private void checkHasReference(Context ctx, CurrencyInfo oldVO, CurrencyInfo updateVO) throws EASBizException {
        Throwable e = null;
        if (oldVO.getBaseUnit() != null && !oldVO.getBaseUnit().equals(updateVO.getBaseUnit()) || oldVO.getBaseUnit() == null && updateVO.getBaseUnit() != null) {
            if (e == null) {
                e = this.checkReference(ctx, updateVO.getId());
            }
            if (e != null) {
                throw new CurrencyException(CurrencyException.REF_NOT_UPDATE_BASEUNIT, e);
            }
        }
        if (oldVO.getPrecision() > updateVO.getPrecision()) {
            if (e == null) {
                e = this.checkReference(ctx, updateVO.getId());
            }
            if (e != null) {
                throw new CurrencyException(CurrencyException.REF_NOT_REDUCE_PRECISION, e);
            }
        }
    }

    protected void updateCheck(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (pk.toString().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
            throw new CurrencyException(CurrencyException.GENERAL_LOCAL_CURRENCY_NOT_ALLOW_MAINTAINED);
        }
        if (pk.toString().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
            throw new CurrencyException(CurrencyException.GENERAL_REPORT_CURRENCY_NOT_ALLOW_MAINTAINED);
        }
        CurrencyInfo oldModel = this.getCurrencyInfo(ctx, pk);
        CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (!ctrlUnitInfo.getId().equals((Object)oldModel.getCU().getId())) {
            throw new CurrencyException(CurrencyException.NOT_CREATE_CU, new Object[]{oldModel.getName(), ctrlUnitInfo.getName()});
        }
        this.checkHasDeal(ctx, oldModel, (CurrencyInfo)model);
        this.checkHasReference(ctx, oldModel, (CurrencyInfo)model);
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        if (!((DataBaseInfo)model).getNumber().equals(oldModel.getNumber())) {
            this._checkNumberDup(ctx, model);
        }
        if (!((DataBaseInfo)model).getName().equals(oldModel.getName())) {
            this._checkNameDup(ctx, model);
        }
        if (((DataBaseInfo)model).getNumber().trim().length() > 12) {
            throw new CurrencyException(CurrencyException.NUMBER_TOO_LONG);
        }
        this.checkNumberCharacter((CurrencyInfo)model);
        Locale locale = ContextUtils.getLocaleFromEnv();
        String basUnit = ((CurrencyInfo)model).getBaseUnit(locale);
        this.checkSortNumber(model);
        if (basUnit == null) {
            throw new CurrencyException(CurrencyException.BASE_UNIT_NOT_NULL);
        }
        if (((CurrencyInfo)model).getBaseUnit() != null && ((CurrencyInfo)model).getBaseUnit().length() > 8) {
            throw new CurrencyException(CurrencyException.BASE_UNIT_TOO_LONG);
        }
        if (((CurrencyInfo)model).getSign() != null && ((CurrencyInfo)model).getSign().trim().length() > 4) {
            throw new CurrencyException(CurrencyException.SIGN_TOO_LONG);
        }
        if (((CurrencyInfo)model).getPrecision() < 0) {
            throw new CurrencyException(CurrencyException.PRECISION_NOT_NEGATIVE);
        }
        if (((CurrencyInfo)model).getPrecision() > 4) {
            ((CurrencyInfo)model).setPrecision(4);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCheck(ctx, pk, model);
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk.toString().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
            throw new CurrencyException(CurrencyException.GENERAL_LOCAL_CURRENCY_NOT_ALLOW_MAINTAINED);
        }
        if (pk.toString().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
            throw new CurrencyException(CurrencyException.GENERAL_REPORT_CURRENCY_NOT_ALLOW_MAINTAINED);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected IObjectCollection _getCurrencyCollection(Context ctx, boolean isExcludeGeneralCurrency) throws BOSException, EASBizException {
        if (isExcludeGeneralCurrency) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString(), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1");
            evi.setFilter(filter);
            evi.getSelector().add(new SelectorItemInfo("*"));
            return this.getCurrencyCollection(ctx, evi);
        }
        return this.getCurrencyCollection(ctx);
    }

    @Override
    protected IObjectCollection _getCurrencyCollection(Context ctx, EntityViewInfo view, boolean isExcludeGeneralCurrency) throws BOSException, EASBizException {
        CurrencyCollection vos = this.getCurrencyCollection(ctx, view);
        if (vos != null && isExcludeGeneralCurrency) {
            for (int i = 0; i < vos.size(); ++i) {
                CurrencyInfo vo = (CurrencyInfo)vos.getObject(i);
                if (!vo.isGeneralLocalCurrency() && !vo.isGeneralReportCurrency()) continue;
                vos.removeObject(i);
                --i;
            }
        }
        return vos;
    }

    @Override
    protected boolean _checkReferenced(Context ctx, BOSUuid id) throws BOSException {
        boolean reference = false;
        try {
            this._isReferenced(ctx, (IObjectPK)new ObjectUuidPK(id));
            BizCheckerUtil.isReferenced((Context)ctx, (BOSUuid)id);
        }
        catch (Exception er) {
            reference = true;
        }
        return reference;
    }
}

