/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;

public class CurrencyDataTransmission
extends AbstractDataTransmission {
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CurrencyFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String description_l3;
        String description_l2;
        String description_l1;
        int temp;
        String basUnit_l3;
        String basUnit_l2;
        String basUnit_l1;
        String iSOCode;
        String name_l3;
        String name_l2;
        CurrencyInfo info = new CurrencyInfo();
        String number = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        if (number == null) throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"187_NumberNoExist", (Locale)ctx.getLocale()));
        info.setNumber(number);
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (mode == 16) {
            try {
                ICurrency iCurrency = (ICurrency)this.getController(ctx);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.appendFilterItem("number", (Object)number);
                view.setFilter(filter);
                CurrencyCollection currencyCollectoin = iCurrency.getCurrencyCollection(view);
                if (currencyCollectoin != null && currencyCollectoin.size() != 0) {
                    info = currencyCollectoin.get(0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TaskExternalException("BOSException: getCurrencyCollection", (Throwable)e);
            }
        }
        String name_l1 = (String)((DataToken)hsData.get((Object)"Fname_L1")).data;
        if (name_l1 != null && name_l1.trim().length() != 0) {
            info.setName(name_l1, new Locale("L1"));
        }
        if ((name_l2 = (String)((DataToken)hsData.get((Object)"Fname_L2")).data) != null && name_l2.trim().length() != 0) {
            info.setName(name_l2, new Locale("L2"));
        }
        if ((name_l3 = (String)((DataToken)hsData.get((Object)"Fname_L3")).data) != null && name_l3.trim().length() != 0) {
            info.setName(name_l3, new Locale("L3"));
        }
        if ((iSOCode = (String)((DataToken)hsData.get((Object)"FISOCode")).data) != null && iSOCode.trim().length() != 0) {
            info.setIsoCode(iSOCode);
        }
        if ((basUnit_l1 = (String)((DataToken)hsData.get((Object)"FBaseUnit_L1")).data) != null && basUnit_l1.trim().length() != 0) {
            info.setBaseUnit(basUnit_l1, new Locale("L1"));
        }
        if ((basUnit_l2 = (String)((DataToken)hsData.get((Object)"FBaseUnit_L2")).data) != null && basUnit_l2.trim().length() != 0) {
            info.setBaseUnit(basUnit_l2, new Locale("L2"));
        }
        if ((basUnit_l3 = (String)((DataToken)hsData.get((Object)"FBaseUnit_L3")).data) != null && basUnit_l3.trim().length() != 0) {
            info.setBaseUnit(basUnit_l3, new Locale("L3"));
        }
        if (((DataToken)hsData.get((Object)"FPrecision")).data != null && ((DataToken)hsData.get((Object)"FPrecision")).data != "") {
            temp = Integer.parseInt(((DataToken)hsData.get((Object)"FPrecision")).data.toString());
            if (temp > 4) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"188_PrecisionNotGreaterThanFour", (Locale)ctx.getLocale()));
            }
            info.setPrecision(temp);
        }
        if (((DataToken)hsData.get((Object)"FSortNumber")).data != null && ((DataToken)hsData.get((Object)"FSortNumber")).data != "") {
            temp = 999;
            try {
                temp = Integer.parseInt(((DataToken)hsData.get((Object)"FSortNumber")).data.toString());
            }
            catch (Exception e) {
                throw new TaskExternalException("\u6392\u5e8f\u7801\u53ea\u80fd\u8f93\u5165\u6570\u5b57\uff01");
            }
            info.setSortNumber(temp);
        }
        if ((description_l1 = (String)((DataToken)hsData.get((Object)"Fdescription_L1")).data) != null && description_l1.trim().length() != 0) {
            info.setDescription(description_l1, new Locale("L1"));
        }
        if ((description_l2 = (String)((DataToken)hsData.get((Object)"Fdescription_L2")).data) != null && description_l2.trim().length() != 0) {
            info.setDescription(description_l2, new Locale("L2"));
        }
        if ((description_l3 = (String)((DataToken)hsData.get((Object)"Fdescription_L3")).data) == null || description_l3.trim().length() == 0) return info;
        info.setDescription(description_l3, new Locale("L3"));
        return info;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase iCurrency = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !iCurrency.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iCurrency.addnew(coreBaseInfo);
            } else {
                iCurrency.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("FNumber", rs.getString("number"));
            if (LocaleUtils.getLocale((String)"l2").equals(ctx.getLocale()) && rs.getString("name") != null) {
                result.put("Fname_L2", rs.getString("name"));
            }
            if (LocaleUtils.getLocale((String)"l3").equals(ctx.getLocale()) && rs.getString("name") != null) {
                result.put("Fname_L3", rs.getString("name"));
            }
            if (rs.getString("isoCode") != null) {
                result.put("FISOCode", rs.getString("isoCode"));
            }
            if (LocaleUtils.getLocale((String)"l2").equals(ctx.getLocale()) && rs.getString("baseUnit") != null) {
                result.put("FBaseUnit_L2", rs.getString("baseUnit"));
            }
            if (LocaleUtils.getLocale((String)"l3").equals(ctx.getLocale()) && rs.getString("baseUnit") != null) {
                result.put("FBaseUnit_L3", rs.getString("baseUnit"));
            }
            if (rs.getString("currencyPrecision") != null) {
                result.put("FPrecision", rs.getString("currencyPrecision"));
            }
            if (rs.getString("description") != null) {
                result.put("Fdescription_L2", rs.getString("description"));
            }
            if (rs.getString("sortNumber") != null) {
                result.put("FSortNumber", rs.getString("sortNumber"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new TaskExternalException("Database access error occurs, can't read field values!", (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.assistant.app.CurrencyQuery";
    }
}

