/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AssistantCtrlUnitUtils;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateException;
import com.kingdee.eas.basedata.assistant.app.AbstractExchangeAuxControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.BizCheckerUtil;

public class ExchangeAuxControllerBean
extends AbstractExchangeAuxControllerBean {
    protected void checkEmpty(ExchangeAuxInfo model) throws BOSException, EASBizException {
        if (model.getExchangeTable() == null) {
            throw new ExchangeRateException(ExchangeRateException.EXCHANGE_TABLE_IS_NULL);
        }
        if (model.getSourceCurrency() == null) {
            throw new ExchangeRateException(ExchangeRateException.SOURCE_CURRENCY_IS_NULL);
        }
        if (model.getTargetCurrency() == null) {
            throw new ExchangeRateException(ExchangeRateException.TARGET_CURRENCY_IS_NULL);
        }
        if (model.getSourceCurrency().getId().toString().equals(model.getTargetCurrency().getId().toString())) {
            throw new ExchangeRateException(ExchangeRateException.SOURCE_AND_TARGET_CURRENCY_IS_SAME);
        }
        if (model.getConvertMode() == null) {
            throw new ExchangeRateException(ExchangeRateException.CONVERT_TYPE_IS_NULL);
        }
        if (model.getExchangeRateType() == null) {
            throw new ExchangeRateException(ExchangeRateException.CONVERT_TYPE_IS_NULL);
        }
        if (model.getPrecision() < 0) {
            throw new ExchangeRateException(ExchangeRateException.EXCHANGE_RATE_PRECISION_MUST_GREATER_THAN_ZERO);
        }
    }

    protected void checkDuplicate(Context ctx, ExchangeAuxInfo model) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("exchangeTable.id", (Object)model.getExchangeTable().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("sourceCurrency.id", (Object)model.getSourceCurrency().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("targetCurrency.id", (Object)model.getTargetCurrency().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        IObjectPK[] pks = this._getPKList(ctx, filter, null);
        if (pks != null && pks.length > 0) {
            this.setRollbackOnly();
            throw new ExchangeRateException(ExchangeRateException.EXCHANGE_AUX_DUPLICATED);
        }
    }

    protected void addnewCheck(Context ctx, ExchangeAuxInfo model) throws BOSException, EASBizException {
        model.setCU(AssistantCtrlUnitUtils.getRootCU(ctx));
        this.checkEmpty(model);
        this.checkDuplicate(ctx, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, (ExchangeAuxInfo)model);
        return super._addnew(ctx, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, (ExchangeAuxInfo)model);
        super._addnew(ctx, pk, model);
    }

    protected void updateCheck(Context ctx, IObjectPK pk, ExchangeAuxInfo model) throws BOSException, EASBizException {
        this.checkEmpty(model);
        ExchangeAuxInfo oldModel = this.getExchangeAuxInfo(ctx, pk);
        if (!(model.getExchangeTable().getId().toString().equals(oldModel.getExchangeTable().getId().toString()) && model.getSourceCurrency().getId().toString().equals(oldModel.getSourceCurrency().getId().toString()) && model.getTargetCurrency().getId().toString().equals(oldModel.getTargetCurrency().getId().toString()))) {
            this.checkDuplicate(ctx, model);
        }
        this.checkHasReference(ctx, oldModel, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCheck(ctx, pk, (ExchangeAuxInfo)model);
        super._update(ctx, pk, model);
    }

    private Throwable checkReference(Context ctx, BOSUuid id) {
        Exception e = null;
        try {
            this._isReferenced(ctx, (IObjectPK)new ObjectUuidPK(id));
            BizCheckerUtil.isReferenced((Context)ctx, (BOSUuid)id);
        }
        catch (Exception er) {
            e = er;
        }
        return e;
    }

    private void checkHasReference(Context ctx, ExchangeAuxInfo oldVO, ExchangeAuxInfo updateVO) throws EASBizException, ExchangeRateException {
        Throwable e = this.checkReference(ctx, oldVO.getId());
        if (e != null) {
            if (!oldVO.getSourceCurrency().getId().toString().equals(updateVO.getSourceCurrency().getId().toString())) {
                throw new ExchangeRateException(ExchangeRateException.NOT_UPDATE_EXCHANGE_AUX_SOURCECURRENCY, e);
            }
            if (!oldVO.getTargetCurrency().getId().toString().equals(updateVO.getTargetCurrency().getId().toString())) {
                throw new ExchangeRateException(ExchangeRateException.NOT_UPDATE_EXCHANGE_AUX_TARGETCURRENCY, e);
            }
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ExchangeAuxInfo info = (ExchangeAuxInfo)super._getValue(ctx, pk);
        return info.getLogInfo();
    }
}

