/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ExchangeAuxFactory;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.assistant.ExchangeRateException;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateUtils;
import com.kingdee.eas.basedata.assistant.ExchangeTableFactory;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeAux;
import com.kingdee.eas.basedata.assistant.IExchangeTable;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractExchangeRateControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class ExchangeRateControllerBean
extends AbstractExchangeRateControllerBean {
    private Logger logger = Logger.getLogger((String)"com.kingdee.bos.framework.ejb.AbstractEntityControllerBean");

    protected void checkEmpty(ExchangeRateInfo model) throws BOSException, EASBizException {
        if (model.getExchangeAux() == null) {
            throw new ExchangeRateException(ExchangeRateException.EXCHANGE_AUX_IS_NULL);
        }
        if (model.getConvertRate() == null) {
            throw new ExchangeRateException(ExchangeRateException.EXCHANGERATE_CONVERTRATE_IS_NULL);
        }
        if (model.getConvertRate().compareTo(new BigDecimal("0.000")) <= 0) {
            throw new ExchangeRateException(ExchangeRateException.EXCHANGERATE_CONVERTRATE_MUST_GREATER_THAN_ZERO);
        }
        if (model.getAvailTime() == null) {
            throw new ExchangeRateException(ExchangeRateException.EXCHANGE_RATE_AVAIL_DATE_IS_NULL);
        }
    }

    protected void checkAddNewInvalidDate(ExchangeRateInfo model) throws BOSException, EASBizException {
        if (model.getInvalidTime().compareTo(ExchangeRateInfo.INFINITE_INVALID_DATE) != 0) {
            throw new ExchangeRateException(ExchangeRateException.EXCHANGE_RATE_INVAILD_DATE_NOT_ALLOW_MAINTAINED);
        }
    }

    protected void checkDuplicate(Context ctx, ExchangeRateInfo model) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("exchangeAux.id", (Object)model.getExchangeAux().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("availTime", (Object)model.getAvailTime(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("quoteprice", (Object)model.getQuoteprice(), CompareType.EQUALS));
        if (model.isIsUsedBG()) {
            filter.getFilterItems().add(new FilterItemInfo("isUsedBG", (Object)new Integer(1), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("isUsedBG", (Object)new Integer(0), CompareType.EQUALS));
        }
        filter.setMaskString("#0 and #1 and #2 and #3");
        IObjectPK[] pks = this._getPKList(ctx, filter, null);
        if (pks != null && pks.length > 0) {
            IExchangeTable exchangeTable = ExchangeTableFactory.getLocalInstance(ctx);
            ObjectUuidPK pk = new ObjectUuidPK(model.getExchangeTable().getId());
            ExchangeTableInfo exchangeTableInfo = exchangeTable.getExchangeTableInfo((IObjectPK)pk);
            this.setRollbackOnly();
            if (exchangeTableInfo.isIsMulExchange()) {
                throw new ExchangeRateException(ExchangeRateException.EXCHANGE_MUL_RATE_DUPLICATE);
            }
            throw new ExchangeRateException(ExchangeRateException.EXCHANGE_RATE_DUPLICATE);
        }
    }

    protected void addnewCheck(Context ctx, ExchangeRateInfo model) throws BOSException, EASBizException {
        model.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        this.checkEmpty(model);
        this.setConvertRateByPrecision(ctx, model);
        this.covertToSimpleDate(model, true);
        this.setAddnewInvalidDateToInfinity(model);
        this.checkDuplicate(ctx, model);
    }

    protected void updatePreviousExchangeRateInvalidDate(Context ctx, ExchangeRateInfo model) throws BOSException, EASBizException {
        ExchangeRateInfo previousVO = this.getPreviousExchangeRate(ctx, model);
        if (previousVO != null) {
            previousVO.setInvalidTime(this.getPreviousInvalidDate(ctx, model.getAvailTime()));
            this.update(ctx, (IObjectPK)new ObjectUuidPK(previousVO.getId()), (CoreBaseInfo)previousVO);
        }
    }

    private Date getPreviousInvalidDate(Context ctx, Date date) {
        Calendar cal = Calendar.getInstance(ctx.getLocale());
        cal.setTime(date);
        cal.add(5, -1);
        return cal.getTime();
    }

    protected void setConvertRateByPrecision(Context ctx, ExchangeRateInfo model) throws BOSException, EASBizException {
        if (model.getExchangeAux() != null) {
            IExchangeAux iExchangeAux = ExchangeAuxFactory.getLocalInstance(ctx);
            ExchangeAuxInfo exchangeAuxVO = iExchangeAux.getExchangeAuxInfo((IObjectPK)new ObjectUuidPK(model.getExchangeAux().getId()));
            BigDecimal newConvertRate = model.getConvertRate().setScale(exchangeAuxVO.getPrecision(), 4);
            model.setConvertRate(newConvertRate);
        }
    }

    private void covertToSimpleDate(ExchangeRateInfo model, boolean isAddnew) {
        model.setAvailTime(ExchangeRateUtils.covertToSimpleDate(model.getAvailTime()));
        if (!isAddnew) {
            model.setInvalidTime(ExchangeRateUtils.covertToSimpleDate(model.getInvalidTime()));
        }
    }

    private void setAddnewInvalidDateToInfinity(ExchangeRateInfo model) {
        model.setInvalidTime(ExchangeRateInfo.INFINITE_INVALID_DATE);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.addnew(ctx, null, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addnew(ctx, pk, model);
    }

    protected IObjectPK addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, (ExchangeRateInfo)model);
        ExchangeRateInfo first = this.getFirstExchangeRate(ctx, (ExchangeRateInfo)model);
        if (first == null) {
            if (pk != null) {
                super._addnew(ctx, pk, model);
            } else {
                pk = super._addnew(ctx, model);
            }
        } else {
            if (((ExchangeRateInfo)model).getAvailTime().compareTo(first.getAvailTime()) < 0) {
                ((ExchangeRateInfo)model).setInvalidTime(this.getPreviousInvalidDate(ctx, first.getAvailTime()));
            } else {
                ExchangeRateInfo previous = this.getPreviousExchangeRate(ctx, (ExchangeRateInfo)model);
                ((ExchangeRateInfo)model).setInvalidTime(previous.getInvalidTime());
                previous.setInvalidTime(this.getPreviousInvalidDate(ctx, ((ExchangeRateInfo)model).getAvailTime()));
                this.update(ctx, (IObjectPK)new ObjectUuidPK(previous.getId()), (CoreBaseInfo)previous);
            }
            if (pk != null) {
                super._addnew(ctx, pk, model);
            } else {
                pk = super._addnew(ctx, model);
            }
        }
        return pk;
    }

    protected void updateCheck(Context ctx, IObjectPK pk, ExchangeRateInfo model) throws BOSException, EASBizException {
        this.checkEmpty(model);
        this.setConvertRateByPrecision(ctx, model);
        this.covertToSimpleDate(model, false);
        ExchangeRateInfo oldModel = this.getExchangeRateInfo(ctx, pk);
        if (!(model.getExchangeAux().getId().toString().equals(oldModel.getExchangeAux().getId().toString()) && model.isIsUsedBG() == oldModel.isIsUsedBG() && model.getAvailTime().equals(oldModel.getAvailTime()) && model.getQuoteprice().equals((Object)oldModel.getQuoteprice()))) {
            this.checkDuplicate(ctx, model);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ExchangeRateInfo info = (ExchangeRateInfo)model;
        this.updateCheck(ctx, pk, (ExchangeRateInfo)model);
        ExchangeRateInfo exist = this.getExchangeRateInfo(ctx, pk);
        if (((ExchangeRateInfo)model).getExchangeAux().getId().toString().equals(exist.getExchangeAux().getId().toString()) && ((ExchangeRateInfo)model).getAvailTime().compareTo(exist.getAvailTime()) == 0 && info.getQuoteprice() == exist.getQuoteprice()) {
            super._update(ctx, pk, model);
        } else {
            this.delete(ctx, pk);
            ((ExchangeRateInfo)model).setId(null);
            this.addnew(ctx, pk, (CoreBaseInfo)((ExchangeRateInfo)model));
            model = this.getExchangeRateInfo(ctx, pk);
            super._update(ctx, pk, model);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ExchangeRateInfo exist = this.getExchangeRateInfo(ctx, pk);
        ExchangeRateInfo previous = this.getPreviousExchangeRate(ctx, exist);
        if (previous != null) {
            previous.setInvalidTime(exist.getInvalidTime());
            this.update(ctx, (IObjectPK)new ObjectUuidPK(previous.getId()), (CoreBaseInfo)previous);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ExchangeRateInfo vo = (ExchangeRateInfo)super._getValue(ctx, pk);
        this.setConvertRateByPrecision(ctx, vo);
        return vo;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        ExchangeRateInfo vo = (ExchangeRateInfo)super._getValue(ctx, pk, selector);
        this.setConvertRateByPrecision(ctx, vo);
        return vo;
    }

    protected IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        ExchangeRateInfo vo = (ExchangeRateInfo)super._getValue(ctx, oql);
        this.setConvertRateByPrecision(ctx, vo);
        return vo;
    }

    private EntityViewInfo getExchangeRateDetailEntityViewInfo(IObjectPK exchangeTablePk, IObjectPK sourceCurrencyPk, IObjectPK targetCurrencyPk) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("exchangeAux.exchangeTable.id", (Object)exchangeTablePk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("exchangeAux.sourceCurrency.id", (Object)sourceCurrencyPk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("exchangeAux.targetCurrency.id", (Object)targetCurrencyPk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("isUsedBG", (Object)"0"));
        filter.setMaskString("#0 and #1 and #2 and #3");
        evi.setFilter(filter);
        SorterItemInfo sortItem = new SorterItemInfo("availTime");
        sortItem.setSortType(SortType.DESCEND);
        evi.getSorter().add(sortItem);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("exchangeAux.*"));
        return evi;
    }

    private EntityViewInfo getExchangeRateDetailEntityViewInfo(IObjectPK exchangeTablePk, Date beginDate, Date endDate, IObjectPK sourceCurrencyPk, IObjectPK targetCurrencyPk) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("exchangeAux.exchangeTable.id", (Object)exchangeTablePk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("availTime", (Object)beginDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("inValidTime", (Object)beginDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("availTime", (Object)beginDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("availTime", (Object)endDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("exchangeAux.sourceCurrency.id", (Object)sourceCurrencyPk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("exchangeAux.targetCurrency.id", (Object)targetCurrencyPk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("isUsedBG", (Object)"1"));
        filter.setMaskString("#0 and ((#1 and #2) or (#3 and #4)) and #5 and #6 and #7");
        evi.setFilter(filter);
        SorterItemInfo sortItem = new SorterItemInfo("availTime");
        sortItem.setSortType(SortType.DESCEND);
        evi.getSorter().add(sortItem);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("exchangeAux.*"));
        return evi;
    }

    private EntityViewInfo getExchangeRateDetailEntityViewInfo(IObjectPK exchangeTablePk, Date beginDate, Date endDate, IObjectPK sourceCurrencyPk, IObjectPK targetCurrencyPk, String direction) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("exchangeAux.exchangeTable.id", (Object)exchangeTablePk.toString()));
        if (direction.equalsIgnoreCase("LEFT")) {
            filter.getFilterItems().add(new FilterItemInfo("inValidTime", (Object)beginDate, CompareType.LESS));
        } else if (direction.equalsIgnoreCase("RIGHT")) {
            filter.getFilterItems().add(new FilterItemInfo("availTime", (Object)endDate, CompareType.GREATER));
        }
        filter.getFilterItems().add(new FilterItemInfo("exchangeAux.sourceCurrency.id", (Object)sourceCurrencyPk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("exchangeAux.targetCurrency.id", (Object)targetCurrencyPk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("isUsedBG", (Object)"1"));
        filter.setMaskString("#0 and #1  and #2 and #3 and #4");
        evi.setFilter(filter);
        SorterItemInfo sortItem = new SorterItemInfo("availTime");
        sortItem.setSortType(SortType.DESCEND);
        evi.getSorter().add(sortItem);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("exchangeAux.*"));
        return evi;
    }

    private EntityViewInfo getExchangeRateSimpleEntityViewInfo(IObjectPK exchangeAuxPk, ExchangeRateInfo model) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("exchangeAux.id", (Object)exchangeAuxPk.toString()));
        if (model.isIsUsedBG()) {
            filter.getFilterItems().add(new FilterItemInfo("isUsedBG", (Object)new Integer(1), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("isUsedBG", (Object)new Integer(0), CompareType.EQUALS));
        }
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        SorterItemInfo sortItem = new SorterItemInfo("availTime");
        sortItem.setSortType(SortType.DESCEND);
        evi.getSorter().add(sortItem);
        evi.getSelector().add(new SelectorItemInfo("*"));
        return evi;
    }

    protected ExchangeRateInfo getPreviousExchangeRate(Context ctx, ExchangeRateInfo model) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("exchangeAux.id", (Object)model.getExchangeAux().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("quoteprice", (Object)model.getQuoteprice()));
        filter.getFilterItems().add(new FilterItemInfo("availTime", (Object)model.getAvailTime(), CompareType.LESS));
        evi.setFilter(filter);
        SorterItemInfo sortItem = new SorterItemInfo("availTime");
        sortItem.setSortType(SortType.DESCEND);
        evi.getSorter().add(sortItem);
        ExchangeRateCollection vos = this.getExchangeRateCollection(ctx, evi);
        ExchangeRateInfo vo = null;
        if (vos != null && vos.size() > 0) {
            vo = vos.get(0);
        }
        return vo;
    }

    protected ExchangeRateInfo getFirstExchangeRate(Context ctx, ExchangeRateInfo model) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("exchangeAux.id", (Object)model.getExchangeAux().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("quoteprice", (Object)model.getQuoteprice()));
        evi.setFilter(filter);
        SorterItemInfo sortItem = new SorterItemInfo("availTime");
        evi.getSorter().add(sortItem);
        ExchangeRateCollection vos = this.getExchangeRateCollection(ctx, evi);
        ExchangeRateInfo vo = null;
        if (vos != null && vos.size() > 0) {
            vo = vos.get(0);
        }
        return vo;
    }

    @Override
    protected IObjectValue _getExchangeRate(Context ctx, IObjectPK exchangeTablePk, IObjectPK sourceCurrencyPk, IObjectPK targetCurrencyPk, Date date) throws BOSException, EASBizException {
        this.logger.debug((Object)("Date to query\uff1a" + date));
        EntityViewInfo evi = this.getExchangeRateDetailEntityViewInfo(exchangeTablePk, sourceCurrencyPk, targetCurrencyPk);
        ExchangeRateCollection vos = this.getExchangeRateCollection(ctx, evi);
        if (date == null && vos != null && vos.size() > 0) {
            return vos.get(0);
        }
        if (vos != null && vos.size() > 0) {
            int l = 0;
            int h = vos.size() - 1;
            int mid = (l + h) / 2;
            while (l <= h) {
                int compare = 0;
                if (date instanceof Timestamp) {
                    Date newDate = new Date(date.getTime());
                    compare = newDate.compareTo(vos.get(mid).getAvailTime());
                } else {
                    compare = date.compareTo(vos.get(mid).getAvailTime());
                }
                if (compare == 0) {
                    return vos.get(mid);
                }
                if (compare > 0) {
                    h = mid - 1;
                } else {
                    l = mid + 1;
                }
                mid = (l + h) / 2;
            }
            if (l > h && l < vos.size()) {
                return vos.get(l);
            }
        }
        return null;
    }

    @Override
    protected BigDecimal _getExchangeRateConvertValue(Context ctx, IObjectPK exchangeTablePk, IObjectPK sourceCurrencyPk, IObjectPK targetCurrencyPk, Date date) throws BOSException, EASBizException {
        ExchangeRateInfo indirect;
        ExchangeRateInfo direct = this.getExchangeRate(ctx, exchangeTablePk, sourceCurrencyPk, targetCurrencyPk, date);
        if (direct != null) {
            BigDecimal returanRate = direct.getConvertRate().setScale(direct.getExchangeAux().getPrecision(), 4);
            return returanRate;
        }
        IExchangeTable iExchangeTable = ExchangeTableFactory.getLocalInstance(ctx);
        ExchangeTableInfo table = iExchangeTable.getExchangeTableInfo(exchangeTablePk);
        if (table.isIsReversible() && (indirect = this.getExchangeRate(ctx, exchangeTablePk, targetCurrencyPk, sourceCurrencyPk, date)) != null) {
            BigDecimal tempConvertRate = indirect.getConvertRate();
            tempConvertRate = new BigDecimal(1).divide(tempConvertRate, 4);
            return tempConvertRate;
        }
        return null;
    }

    @Override
    protected IObjectValue _getExchangeRateConvertInfo(Context ctx, IObjectPK exchangeTablePk, IObjectPK sourceCurrencyPk, IObjectPK targetCurrencyPk, Date date) throws BOSException, EASBizException {
        ExchangeRateInfo rateInfo;
        ExchangeRateInfo direct = this.getExchangeRate(ctx, exchangeTablePk, sourceCurrencyPk, targetCurrencyPk, date);
        if (direct != null) {
            direct.setConvertRate(direct.getConvertRate().setScale(direct.getExchangeAux().getPrecision(), 4));
            return direct;
        }
        IExchangeTable iExchangeTable = ExchangeTableFactory.getLocalInstance(ctx);
        ExchangeTableInfo table = iExchangeTable.getExchangeTableInfo(exchangeTablePk);
        if (table.isIsReversible() && (rateInfo = this.getExchangeRate(ctx, exchangeTablePk, targetCurrencyPk, sourceCurrencyPk, date)) != null) {
            ExchangeRateInfo indirect = (ExchangeRateInfo)rateInfo.clone();
            BigDecimal tempConvertRate = indirect.getConvertRate();
            tempConvertRate = new BigDecimal(1).divide(tempConvertRate, indirect.getExchangeAux().getPrecision(), 4);
            indirect.setConvertRate(tempConvertRate);
            return indirect;
        }
        return null;
    }

    @Override
    protected IObjectValue _getExchangeRateByBG(Context ctx, IObjectPK exchangeTablePk, IObjectPK periodPK, IObjectPK sourceCurrencyPK, IObjectPK targetCurrencyPk) throws BOSException, EASBizException {
        EntityViewInfo evi;
        ExchangeRateCollection vos;
        Date beginDate = null;
        Timestamp endDate = null;
        PeriodInfo periodInfo = this.getPeriodInfo(ctx, periodPK);
        if (periodInfo != null) {
            beginDate = periodInfo.getBeginDate();
            endDate = periodInfo.getEndDate();
        }
        if ((vos = this.getExchangeRateCollection(ctx, evi = this.getExchangeRateDetailEntityViewInfo(exchangeTablePk, beginDate, endDate, sourceCurrencyPK, targetCurrencyPk))) != null && vos.size() > 0) {
            return vos.get(0);
        }
        evi = this.getExchangeRateDetailEntityViewInfo(exchangeTablePk, beginDate, endDate, sourceCurrencyPK, targetCurrencyPk, "LEFT");
        vos = this.getExchangeRateCollection(ctx, evi);
        if (vos != null && vos.size() > 0) {
            return vos.get(0);
        }
        evi = this.getExchangeRateDetailEntityViewInfo(exchangeTablePk, beginDate, endDate, sourceCurrencyPK, targetCurrencyPk, "RIGHT");
        vos = this.getExchangeRateCollection(ctx, evi);
        if (vos != null && vos.size() > 0) {
            return vos.get(0);
        }
        return null;
    }

    private PeriodInfo getPeriodInfo(Context ctx, IObjectPK periodPK) throws EASBizException, BOSException {
        PeriodInfo periodInfo = null;
        IPeriod iPeriod = PeriodFactory.getLocalInstance(ctx);
        periodInfo = iPeriod.getPeriodInfo(periodPK);
        return periodInfo;
    }

    @Override
    protected IObjectValue _getDirectExchangeRate(Context ctx, IObjectPK exchangeTablePk, IObjectPK sourceCurrencyPk, IObjectPK targetCurrencyPK, Date date) throws BOSException, EASBizException {
        ExchangeRateInfo direct = (ExchangeRateInfo)this._getExchangeRateConvertInfo(ctx, exchangeTablePk, sourceCurrencyPk, targetCurrencyPK, date);
        if (direct != null && direct.getExchangeAux() != null && direct.getExchangeAux().getConvertMode().getValue() == 1) {
            direct.getExchangeAux().setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
            BigDecimal tempConvertRate = direct.getConvertRate();
            tempConvertRate = new BigDecimal(1).divide(tempConvertRate, direct.getExchangeAux().getPrecision(), 4);
            direct.setConvertRate(tempConvertRate);
        }
        return direct;
    }
}

