/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.GlobalRoamingCollection;
import com.kingdee.eas.basedata.assistant.GlobalRoamingFactory;
import com.kingdee.eas.basedata.assistant.GlobalRoamingInfo;
import com.kingdee.eas.basedata.assistant.IGlobalRoaming;
import com.kingdee.eas.basedata.assistant.StateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class GlobalRoamTransmission
extends AbstractDataTransmission {
    private static final int NUMBER_MAX_LENGTH = 80;
    private String RESOURCE = "com.kingdee.eas.basedata.assistant.AssitantResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return GlobalRoamingFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Locale locale = ctx.getLocale();
        GlobalRoamingInfo info = new GlobalRoamingInfo();
        String str = null;
        str = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        String strArea = (String)((DataToken)hsData.get((Object)"FAreaCode")).data;
        try {
            if (!StringUtils.isEmpty((String)str)) {
                if ((str = str.trim()).length() >= 80) {
                    throw new TaskExternalException(ResourceBase.getString((String)this.RESOURCE, (String)"NUM_TOOLONG", (Locale)locale) + 80);
                }
                IGlobalRoaming iGlobalRoaming = GlobalRoamingFactory.getLocalInstance(ctx);
                GlobalRoamingCollection globalRoamingCol = iGlobalRoaming.getGlobalRoamingCollection(new EntityViewInfo("where number = '" + str + "' or areaCode='" + strArea + "'"));
                if (globalRoamingCol != null && globalRoamingCol.size() > 0) {
                    if ((Integer)this.getContextMap().get("DATATASKMODE") == 8) {
                        throw new TaskExternalException(ResourceBase.getString((String)this.RESOURCE, (String)"GLOBALROAM_IS_EXIST", (Locale)locale));
                    }
                    info = globalRoamingCol.get(0);
                } else {
                    info.setNumber(str);
                }
            }
            if ((str = (String)((DataToken)hsData.get((Object)"FName_l1")).data).isEmpty()) {
                // empty if block
            }
            info.setName(str, new Locale("L1"));
            str = (String)((DataToken)hsData.get((Object)"FName_l2")).data;
            if (str.isEmpty()) {
                throw new TaskExternalException(ResourceBase.getString((String)this.RESOURCE, (String)"NAME_CANOT_NULL", (Locale)locale));
            }
            info.setName(str, new Locale("L2"));
            str = (String)((DataToken)hsData.get((Object)"FName_l3")).data;
            if (str.isEmpty()) {
                // empty if block
            }
            info.setName(str, new Locale("L3"));
            str = (String)((DataToken)hsData.get((Object)"FAreaCode")).data;
            if (str.isEmpty()) {
                throw new TaskExternalException(ResourceBase.getString((String)this.RESOURCE, (String)"AREACODE_CANOT_NULL", (Locale)locale));
            }
            info.setAreaCode(strArea);
            str = (String)((DataToken)hsData.get((Object)"FSortCode")).data;
            info.setSortCode(str);
            str = (String)((DataToken)hsData.get((Object)"FState")).data;
            if (StringUtils.isEmpty((String)str)) {
                str = "1";
            }
            if (!str.trim().equals("0") && !str.trim().equals("1")) {
                throw new TaskExternalException("\u201c\u72b6\u6001\u201d\u5217\u7684\u503c\u65e0\u6548\uff0c\u8bf7\u586b\u5199 \u201c0\u201d \u6216  \u201c1\u201d  \uff08\u6ce8\uff1a0\u4f5c\u5e9f\uff0c1\u666e\u901a\uff09!");
            }
            int state = Integer.parseInt(str);
            info.setState(state == 1 ? StateEnum.ENABLE : StateEnum.DISABLE);
            return info;
        }
        catch (BOSException e1) {
            throw new TaskExternalException(e1.getMessage(), e1.getCause());
        }
        catch (ParserException e) {
            throw new TaskExternalException(ResourceBase.getString((String)this.RESOURCE, (String)"DATA_PARSE_ERROR", (Locale)locale), (Throwable)e);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Locale locale = ctx.getLocale();
        HashMap<String, String[]> exportMap = new HashMap<String, String[]>();
        exportMap.put("queryFiled", new String[]{"number", "name", "areacode", "sortcode", "state", "creatorNumber", "CreateTime"});
        exportMap.put("excelFiled", new String[]{"FNumber", "FName" + GlobalRoamTransmission.getLocal(ctx), "FAreaCode", "FSortCode", "FState", "FCreator_number", "FCreateTime"});
        exportMap.put("FiledType", new String[0]);
        return this.transeExport(rs, exportMap);
    }

    private Hashtable<String, String> transeExport(IRowSet rs, Map map) throws TaskExternalException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] queryFiled = (String[])map.get("queryFiled");
        String[] excelFiled = (String[])map.get("excelFiled");
        try {
            int size = queryFiled.length;
            for (int i = 0; i < size; ++i) {
                if (rs.getString(queryFiled[i]) == null) continue;
                hashtable.put(excelFiled[i], rs.getString(queryFiled[i]));
            }
        }
        catch (SQLException ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        return hashtable;
    }

    private boolean checkPermission(Context ctx, String permissionItem) {
        try {
            IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK userPk = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
            ObjectUuidPK orgPk = new ObjectUuidPK(ContextUtil.getCurrentOrgUnit((Context)ctx).getId());
            boolean haspermission = permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, permissionItem);
            if (!haspermission) {
                return false;
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return true;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return super.getExportFilterForQuery(ctx);
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.assistant.app.GlobalRoamingExportQuery";
    }

    public static String getLocal(Context ctx) {
        String localString = null;
        localString = ctx != null ? "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale()).toLowerCase() : "_" + LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale()).toLowerCase();
        return localString;
    }
}

