/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.master.account.AbstractAccountRefContrastProcess;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class KAClassAccountRefContrastProcess
extends AbstractAccountRefContrastProcess {
    private Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.KAClassAccountRefContrastProcess");

    public boolean enable(Context ctx, String companyID, String acrefID) throws BOSException, EASBizException {
        this.logger.info((Object)("---KAClassAccountRefContrastProcess#enable start---,acrefID is :" + acrefID + "   companyID is: " + companyID));
        this.insertRefContrastKAClassChangeData(ctx, acrefID);
        this.enableChangeKAClassfication(ctx, companyID, acrefID);
        this.logger.info((Object)"---KAClassAccountRefContrastProcess#enable end---");
        return true;
    }

    private void insertRefContrastKAClassChangeData(Context ctx, String acrefID) throws BOSException {
        StringBuilder querySql = new StringBuilder();
        querySql.append("SELECT Max(FVersion) version FROM T_BD_AcctRefConKAClassChange WHERE facrefId = '" + acrefID + "'");
        Integer version = null;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        try {
            while (rowSet.next()) {
                String versionStr = rowSet.getString("version");
                version = versionStr == null ? null : Integer.valueOf(versionStr);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"insertRefContrastKAClassChange query error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        querySql.setLength(0);
        querySql.append("SELECT head.Fid AcrefId,en.foldacctid oldAcctId,en.fnewacctid newAcctId,head.fdisabledaccttableid oldAcctTabId, head.fenabledaccttableid newAcctTabId,kaDetail.fid kAClassDetailId ").append(" FROM  t_bd_acctrefcontrastentry en ").append(" INNER JOIN t_bd_acctrefcontrast head ON en.facctrefcontrastid = head.fid ").append(" INNER JOIN T_bd_kaclassificationdetail kaDetail on kaDetail.faccountlinkid = en.foldacctid ").append(" WHERE head.fid = '" + acrefID + "'");
        IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        Connection cn = null;
        Statement stmt = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.createStatement();
            version = version == null ? 1 : version + 1;
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String controlUnitId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            StringBuilder insertSql = null;
            while (rowSet2.next()) {
                insertSql = new StringBuilder();
                insertSql.append("INSERT INTO T_BD_AcctRefConKAClassChange(Fid,FAcrefId,FOldAcctId,FNewAcctId,FOldAcctTabId").append(",FNewAcctTabId,FVersion,FKAClassDetailId,FCreatorId,FCreateTime,FLastUpdateUserId,FLastUpdateTime,FControlUnitId) ").append(" SELECT newbosid('6E2D609F') Fid,").append("'").append(rowSet2.getString("AcrefId")).append("',").append("'").append(rowSet2.getString("oldAcctId")).append("',").append("'").append(rowSet2.getString("newAcctId")).append("',").append("'").append(rowSet2.getString("oldAcctTabId")).append("',").append("'").append(rowSet2.getString("newAcctTabId")).append("',").append(version).append(",").append("'").append(rowSet2.getString("kAClassDetailId")).append("',").append("'").append(userId).append("',").append("getdate(),").append("'").append(userId).append("',").append("getdate(),").append("'").append(controlUnitId).append("'");
                stmt.addBatch(insertSql.toString());
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)"insertRefContrastKAClassChange insert error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    private void enableChangeKAClassfication(Context ctx, String companyID, String acrefID) throws EASBizException, BOSException {
        String templeTable = this.createEnableTempleTable(ctx, acrefID);
        try {
            String disableTab = null;
            String enableTab = null;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select top 1 * from " + templeTable));
            while (rs.next()) {
                disableTab = rs.getString("FoldAcctTabID");
                enableTab = rs.getString("FnewAcctTabID");
            }
            if (disableTab == null) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("UPDATE T_bd_kaclassificationdetail    SET    (FAccountlinkID) =  \r\n");
            sb.append("(select top 1 tem.fnewacctid from " + templeTable + "\r\n");
            sb.append(" tem where tem.foldacctid = T_bd_kaclassificationdetail.FAccountlinkID)");
            DbUtil.execute((Context)ctx, (String)sb.toString());
            String updateSql = "update T_BD_KAClassfication set FAccountTableID ='" + enableTab + "' where FAccountTableID ='" + disableTab + "' and fcurrencycompany ='" + companyID + "'";
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
        catch (Exception e) {
            this.logger.error((Object)"enableChangeKAClassfication error:", (Throwable)e);
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                ITableManagerFacade mfa = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
                if (mfa.existTable(templeTable)) {
                    mfa.releaseTableName(templeTable);
                }
            }
            catch (BOSException e) {
                this.logger.error((Object)"enableChangeKAClassfication tem table release error:", (Throwable)e);
            }
        }
    }

    public String createEnableTempleTable(Context ctx, String acrefID) throws BOSException {
        ITableManagerFacade mfa = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tempTable = mfa.getTemporaryTableName("KAClassEnableTempleName");
        StringBuffer createSql = new StringBuffer();
        createSql.append("Create Table ");
        createSql.append(tempTable);
        createSql.append("(");
        createSql.append("FoldAcctID \tVARCHAR(44), ");
        createSql.append("FnewAcctID \tVARCHAR(44), ");
        createSql.append("FoldAcctTabID \tVARCHAR(44), ");
        createSql.append("FnewAcctTabID \tVARCHAR(44) ");
        createSql.append(")");
        mfa.createTempTable(createSql.toString());
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ");
        insertSql.append(tempTable);
        insertSql.append(" SELECT   En.Foldacctid,     \r\n");
        insertSql.append("         En.Fnewacctid,     \r\n");
        insertSql.append("         Head.Fdisabledaccttableid,     \r\n");
        insertSql.append("         Head.Fenabledaccttableid     \r\n");
        insertSql.append("FROM     T_bd_acctrefcontrastentry En     \r\n");
        insertSql.append("         INNER JOIN T_bd_acctrefcontrast Head     \r\n");
        insertSql.append("           ON En.Facctrefcontrastid = Head.Fid     \r\n");
        insertSql.append("WHERE    Head.Fid = '" + acrefID + "'     \r\n");
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
        return tempTable;
    }

    public boolean disEnable(Context ctx, String companyID, String acrefID) throws BOSException, EASBizException {
        this.logger.info((Object)("---KAClassAccountRefContrastProcess#disEnable start---,acrefID is :" + acrefID + "  companyID is: " + companyID));
        String querySql = "SELECT Max(FVersion) version FROM T_BD_AcctRefConKAClassChange WHERE facrefId = '" + acrefID + "'";
        Integer version = null;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql);
        try {
            while (rowSet != null && rowSet.next()) {
                String versionStr = rowSet.getString("version");
                version = versionStr == null ? null : Integer.valueOf(versionStr);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"KAClassAccountRefContrastProcess#disEnable error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (version == null) {
            this.logger.error((Object)("\uff08\u8bb0\u8d26\u5206\u7c7b\uff09\u79d1\u76ee\u5bf9\u7167\u8868\u542f\u7528\u65f6\uff0c\u65e0\u53d8\u66f4\u8bb0\u5f55\u8868\u6570\u636e\uff0c\u5bf9\u7167\u8868acrefID\u503c\u4e3a\uff1a" + acrefID));
            this.kaClassDataReductionOld(ctx, acrefID, companyID);
        } else {
            this.kaClassDataReductionNew(ctx, companyID, acrefID, version);
        }
        this.logger.info((Object)"---KAClassAccountRefContrastProcess#disEnable end---");
        return true;
    }

    private void kaClassDataReductionOld(Context ctx, String acrefID, String companyID) throws BOSException, EASBizException {
        String templeTable = this.createDisableTempleTable(ctx, acrefID);
        try {
            String disableTab = null;
            String enableTab = null;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select top 1 * from " + templeTable));
            while (rs.next()) {
                disableTab = rs.getString("FoldAcctTabID");
                enableTab = rs.getString("FnewAcctTabID");
            }
            if (disableTab == null) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("UPDATE T_bd_kaclassificationdetail    SET    (FAccountlinkID) =  \r\n");
            sb.append("(select top 1 tem.fnewacctid from " + templeTable + "\r\n");
            sb.append(" tem where tem.foldacctid = T_bd_kaclassificationdetail.FAccountlinkID)");
            DbUtil.execute((Context)ctx, (String)sb.toString());
            String updateSql = "update T_BD_KAClassfication set FAccountTableID ='" + enableTab + "' where FAccountTableID ='" + disableTab + "' and fcurrencycompany ='" + companyID + "'";
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                ITableManagerFacade manager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
                if (manager.existTable(templeTable)) {
                    manager.releaseTableName(templeTable);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    private void kaClassDataReductionNew(Context ctx, String companyID, String acrefID, Integer version) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT FKAClassDetailId kalDetailId,FOldAcctId OldAcctId,FNewAcctId NewAcctId,FOldAcctTabId oldAcctTab,FNewAcctTabId newAcctTab FROM T_BD_AcctRefConKAClassChange").append(" WHERE FAcrefId = '" + acrefID + "'").append(" AND FVersion = ").append(version);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String disableTable = null;
            String enableTable = null;
            HashMap<String, String> updateKAClassDetailMap = new HashMap<String, String>();
            while (rs.next()) {
                updateKAClassDetailMap.put(rs.getString("kalDetailId"), rs.getString("OldAcctId"));
                if (disableTable == null || disableTable.length() < 1) {
                    disableTable = rs.getString("newAcctTab");
                }
                if (enableTable != null && enableTable.length() >= 1) continue;
                enableTable = rs.getString("oldAcctTab");
            }
            cn = this.getConnection(ctx);
            stmt = cn.createStatement();
            StringBuilder updateKAClassDetailSql = null;
            for (String key : updateKAClassDetailMap.keySet()) {
                String value = (String)updateKAClassDetailMap.get(key);
                updateKAClassDetailSql = new StringBuilder();
                updateKAClassDetailSql.append("UPDATE T_bd_kaclassificationdetail ").append(" SET FAccountlinkID = '").append(value).append("'").append(" WHERE Fid = '").append(key).append("'");
                stmt.addBatch(updateKAClassDetailSql.toString());
            }
            stmt.executeBatch();
            sql.setLength(0);
            sql.append("UPDATE T_BD_KAClassfication SET FAccountTableID ='" + enableTable + "' WHERE FAccountTableID ='" + disableTable + "' AND fcurrencycompany ='" + companyID + "'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)("kaClassDataReductionNew update sql error:" + e));
                if (e instanceof EASBizException) {
                    throw (EASBizException)((Object)e);
                }
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public String createDisableTempleTable(Context ctx, String acrefID) throws BOSException {
        ITableManagerFacade mfa = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tempTable = mfa.getTemporaryTableName("KAClassDisableTempleName");
        StringBuffer createSql = new StringBuffer();
        createSql.append("Create Table ");
        createSql.append(tempTable);
        createSql.append("(");
        createSql.append("FoldAcctID \tVARCHAR(44), ");
        createSql.append("FnewAcctID \tVARCHAR(44), ");
        createSql.append("FoldAcctTabID \tVARCHAR(44), ");
        createSql.append("FnewAcctTabID \tVARCHAR(44) ");
        createSql.append(")");
        mfa.createTempTable(createSql.toString());
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ");
        insertSql.append(tempTable);
        insertSql.append(" SELECT   En.Fnewacctid,     \r\n");
        insertSql.append("         En.Foldacctid,     \r\n");
        insertSql.append("         Head.Fenabledaccttableid,     \r\n");
        insertSql.append("         Head.Fdisabledaccttableid     \r\n");
        insertSql.append("FROM     T_bd_acctrefcontrastentry En     \r\n");
        insertSql.append("         INNER JOIN T_bd_acctrefcontrast Head     \r\n");
        insertSql.append("           ON En.Facctrefcontrastid = Head.Fid     \r\n");
        insertSql.append("WHERE    Head.Fid = '" + acrefID + "'     \r\n");
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
        return tempTable;
    }
}

