/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.assistant.ILanguage;
import com.kingdee.eas.basedata.assistant.LanguageCollection;
import com.kingdee.eas.basedata.assistant.LanguageFactory;
import com.kingdee.eas.basedata.assistant.LanguageInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;

public class LanguageDataTransmission
extends AbstractDataTransmission {
    private final String RESOURCE_FILE_NAME = "com.kingdee.eas.tools.datatask.DatataskResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return LanguageFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String description_l3;
        String description_l2;
        String description_l1;
        String name_l3;
        String name_l2;
        String name_l1;
        LanguageInfo info = new LanguageInfo();
        String number = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        if (number == null) throw new TaskExternalException("number not found!");
        info.setNumber(number);
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (mode == 16) {
            try {
                ILanguage iLanguage = (ILanguage)this.getController(ctx);
                LanguageCollection languageCollection = iLanguage.getLanguageCollection();
                if (languageCollection != null) {
                    for (int i = 0; i < languageCollection.size(); ++i) {
                        if (!languageCollection.get(i).getNumber().equalsIgnoreCase(number)) continue;
                        info.setId(languageCollection.get(i).getId());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TaskExternalException("BOSException: getLanguageCollection", (Throwable)e);
            }
        }
        if ((name_l1 = (String)((DataToken)hsData.get((Object)"Fname_L1")).data) != null && name_l1.trim().length() != 0) {
            info.setName(name_l1, new Locale("L1"));
        }
        if ((name_l2 = (String)((DataToken)hsData.get((Object)"Fname_L2")).data) != null && name_l2.trim().length() != 0) {
            info.setName(name_l2, new Locale("L2"));
        }
        if ((name_l3 = (String)((DataToken)hsData.get((Object)"Fname_L3")).data) != null && name_l3.trim().length() != 0) {
            info.setName(name_l3, new Locale("L3"));
        }
        if ((description_l1 = (String)((DataToken)hsData.get((Object)"Fdescription_L1")).data) != null && description_l1.trim().length() != 0) {
            info.setDescription(description_l1, new Locale("L1"));
        }
        if ((description_l2 = (String)((DataToken)hsData.get((Object)"Fdescription_L2")).data) != null && description_l2.trim().length() != 0) {
            info.setDescription(description_l2, new Locale("L2"));
        }
        if ((description_l3 = (String)((DataToken)hsData.get((Object)"Fdescription_L3")).data) == null || description_l3.trim().length() == 0) return info;
        info.setDescription(description_l3, new Locale("L3"));
        return info;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase iLanguage = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !iLanguage.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iLanguage.addnew(coreBaseInfo);
            } else {
                iLanguage.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("FNumber", rs.getString("number"));
            Locale currentLocale = ctx.getLocale();
            if (rs.getString("name") != null) {
                if (new Locale("L1").equals(currentLocale)) {
                    result.put("Fname_L1", rs.getString("name"));
                } else if (new Locale("L2").equals(currentLocale)) {
                    result.put("Fname_L2", rs.getString("name"));
                } else if (new Locale("L3").equals(currentLocale)) {
                    result.put("Fname_L3", rs.getString("name"));
                }
            }
            if (rs.getString("description") != null) {
                if (new Locale("L1").equals(currentLocale)) {
                    result.put("Fdescription_L1", rs.getString("description"));
                } else if (new Locale("L2").equals(currentLocale)) {
                    result.put("Fdescription_L2", rs.getString("description"));
                } else if (new Locale("L3").equals(currentLocale)) {
                    result.put("Fdescription_L3", rs.getString("description"));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Locale currentLocale = ctx.getLocale();
            String message = ResourceBase.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"accessError", (Locale)currentLocale);
            throw new TaskExternalException(message, (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.assistant.app.LanguageQuery";
    }
}

