/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fi.gl.VoucherUtilFactory;
import com.kingdee.eas.basedata.assistant.AssistantCtrlUnitUtils;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.IPeriodType;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.app.AbstractO_PeriodControllerBean;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Vector;

public class O_PeriodControllerBean
extends AbstractO_PeriodControllerBean {
    @Override
    protected IObjectCollection _getAllPeriod(Context ctx, String typeId, int periodYear) throws BOSException, EASBizException {
        FilterInfo i = new FilterInfo();
        i.getFilterItems().add(new FilterItemInfo("periodType", (Object)typeId, CompareType.EQUALS));
        i.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(i);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("periodType"));
        evi.getSelector().add(new SelectorItemInfo("periodYear"));
        evi.getSelector().add(new SelectorItemInfo("periodQuarter"));
        evi.getSelector().add(new SelectorItemInfo("periodNumber"));
        evi.getSelector().add(new SelectorItemInfo("beginDate"));
        evi.getSelector().add(new SelectorItemInfo("endDate"));
        evi.getSelector().add(new SelectorItemInfo("isAdjustPeriod"));
        IPeriod iPeriod = PeriodFactory.getLocalInstance(ctx);
        return iPeriod.getCollection(evi);
    }

    @Override
    protected IObjectCollection _getNewPeriodCollection(Context ctx, String typeId) throws BOSException, EASBizException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT FPeriodYear,FPeriodQuarter,FPeriodNumber,FBeginDate,FEndDate,FIsAdjustPeriod FROM T_BD_Period ");
        strBuf.append("WHERE (FPeriodYear IN (SELECT DISTINCT MAX(FPeriodYear) FROM T_BD_Period))  ");
        strBuf.append("AND (FTypeID = ?) ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)strBuf.toString(), (Object[])new Object[]{typeId});
        System.out.println(rows.size());
        IPeriodType iPeriodType = PeriodTypeFactory.getLocalInstance(ctx);
        PeriodTypeInfo typeInfo = iPeriodType.getPeriodTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)typeId)));
        PeriodCollection collection = new PeriodCollection();
        PeriodInfo info = null;
        if (rows.size() == 0) {
            Calendar calender = Calendar.getInstance();
            Date currentDate = calender.getTime();
            calender.set(DateTimeUtils.getYear((Date)currentDate), 0, 1);
            Date beginDate = calender.getTime();
            for (int i = 0; i < 12; ++i) {
                info = new PeriodInfo();
                info.setPeriodType(typeInfo);
                info.setPeriodYear(DateTimeUtils.getYear((Date)beginDate));
                info.setPeriodQuarter((i + 1) % 3);
                info.setPeriodNumber(i);
                info.setBeginDate(DateTimeUtils.addMonth((Date)beginDate, (int)i));
                info.setEndDate(new Timestamp(DateTimeUtils.addDay((Date)DateTimeUtils.addMonth((Date)beginDate, (int)(i + 1)), (long)-1L).getTime()));
                info.setIsAdjustPeriod(false);
                collection.add(info);
            }
        } else {
            try {
                while (rows.next()) {
                    info = new PeriodInfo();
                    info.setPeriodType(typeInfo);
                    info.setPeriodYear(rows.getInt("FPeriodYear"));
                    info.setPeriodQuarter(rows.getInt("FPeriodQuarter"));
                    info.setPeriodNumber(rows.getInt("FPeriodNumber"));
                    info.setBeginDate(rows.getDate("FBeginDate"));
                    info.setEndDate(new Timestamp(rows.getDate("FEndDate").getTime()));
                    info.setIsAdjustPeriod(rows.getBoolean("FIsAdjustPeriod"));
                    collection.add(info);
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                throw new BOSException((Throwable)ex);
            }
            Date newBeginDate = DateTimeUtils.addDay((Date)collection.get(collection.size() - 1).getEndDate(), (long)1L);
            long periodYearDays = DateTimeUtils.dateDiff((Date)collection.get(0).getBeginDate(), (Date)collection.get(collection.size() - 1).getEndDate());
            for (int i = 0; i < collection.size(); ++i) {
                info = collection.get(i);
                info.setPeriodYear(info.getPeriodYear() + 1);
                info.setBeginDate(DateTimeUtils.addDay((Date)info.getBeginDate(), (long)periodYearDays));
                info.setEndDate(new Timestamp(DateTimeUtils.addDay((Date)info.getEndDate(), (long)periodYearDays).getTime()));
            }
        }
        return collection;
    }

    @Override
    protected IRowSet _getNoRelationTargetPeriod(Context ctx, String typeId) throws BOSException, EASBizException {
        IRowSet rows = this._getTargetPeriod(ctx, typeId);
        System.out.println(rows.size());
        int count = rows.size();
        int periodYear = 0;
        int periodNumber = 0;
        if (count > 0) {
            try {
                rows.last();
                periodYear = rows.getInt("FPeriodYear");
                periodNumber = rows.getInt("FPeriodNumber");
            }
            catch (SQLException ex) {
                throw new BOSException((Throwable)ex);
            }
        }
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT FPeriodYear, FPeriodNumber, FID  ");
        strBuf.append("FROM T_BD_Period  ");
        strBuf.append("WHERE (FTypeID = ?) ");
        if (count == 0) {
            return DbUtil.executeQuery((Context)ctx, (String)strBuf.toString(), (Object[])new Object[]{typeId});
        }
        strBuf.append("AND (FPeriodYear > ?)  OR (FPeriodYear = ?) AND (FTypeID = ?) AND (FPeriodNumber > ?)  ");
        System.out.println(strBuf.toString());
        System.out.println("FPeriodYear : " + periodYear);
        System.out.println("FPeriodNumber : " + periodNumber);
        System.out.println("typeId : " + typeId);
        return DbUtil.executeQuery((Context)ctx, (String)strBuf.toString(), (Object[])new Object[]{typeId, new Integer(periodYear), new Integer(periodYear), typeId, new Integer(periodNumber)});
    }

    protected IRowSet _getTargetPeriod(Context ctx, String targetTypeId) throws BOSException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT B.FPeriodYear, B.FPeriodNumber  ");
        strBuf.append("FROM T_BD_PeriodRelation A RIGHT OUTER JOIN T_BD_Period B ON A.FTargetPeriod = B.FID ");
        strBuf.append("WHERE (A.FSourcePeriod IS NOT NULL) AND (B.FTypeID = ?) ");
        strBuf.append("ORDER BY B.FPeriodYear, B.FPeriodNumber");
        return DbUtil.executeQuery((Context)ctx, (String)strBuf.toString(), (Object[])new Object[]{targetTypeId});
    }

    @Override
    protected IRowSet _getPeriodRelation(Context ctx, String SourceTypeId, String targetTypeId) throws BOSException, EASBizException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("Select T1.SourceYear,T1.SourceNumber, T1.SourceId,  ");
        strBuf.append("C.FPeriodYear AS TargetYear,C.FPeriodNumber AS TargetNumber,C.FID AS TargetId, T1.RelationId From ( ");
        strBuf.append("SELECT A.FPeriodYear AS SourceYear, A.FPeriodNumber AS SourceNumber, A.FID AS SourceId, B.FID AS RelationId ,B.FTargetPeriod ");
        strBuf.append("From T_bd_period A left outer join T_BD_PeriodRelation B ON A.FID = B.FSourcePeriod ");
        strBuf.append("Where A.FTypeID='");
        strBuf.append(SourceTypeId);
        strBuf.append("' and (B.FTargetPeriodType='");
        strBuf.append(targetTypeId);
        strBuf.append("'  OR B.FTargetPeriodType IS NULL))");
        strBuf.append(" AS T1 Left OUTER JOIN T_BD_Period C On T1.FTargetPeriod = C.FID Order By T1.SourceYear,T1.SourceNumber ");
        return DbUtil.executeQuery((Context)ctx, (String)strBuf.toString());
    }

    @Override
    protected IObjectPK _addNew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PeriodInfo periodInfo = (PeriodInfo)model;
        IPeriod iPeriod = PeriodFactory.getLocalInstance(ctx);
        periodInfo.setCU(AssistantCtrlUnitUtils.getRootCU(ctx));
        Date oldBeginDate = periodInfo.getBeginDate();
        Date newBeginDate = this.setDateToSpecificTime(oldBeginDate, 0, 0, 0);
        Timestamp oldEndDate = periodInfo.getEndDate();
        Date newEndDate = this.setDateToSpecificTime(oldEndDate, 0, 0, 0);
        periodInfo.setEndDate(new Timestamp(newEndDate.getTime()));
        periodInfo.setNumber(periodInfo.getPeriodYear() * 100 + periodInfo.getPeriodNumber());
        return iPeriod.addnew((CoreBaseInfo)periodInfo);
    }

    @Override
    protected IObjectPK[] _addPeriodCollection(Context ctx, IObjectCollection periodCollection) throws BOSException, EASBizException {
        PeriodCollection periodc = (PeriodCollection)periodCollection.cast(PeriodCollection.class);
        System.out.println("Begin Add Collection");
        IPeriod iPeriod = PeriodFactory.getLocalInstance(ctx);
        IObjectPK[] pkList = new IObjectPK[periodc.size()];
        for (int i = 0; i < periodc.size(); ++i) {
            Date oldBeginDate = periodc.get(i).getBeginDate();
            Date newBeginDate = this.setDateToSpecificTime(oldBeginDate, 0, 0, 0);
            Timestamp oldEndDate = periodc.get(i).getEndDate();
            Date newEndDate = this.setDateToSpecificTime(oldEndDate, 0, 0, 0);
            periodc.get(i).setBeginDate(newBeginDate);
            periodc.get(i).setEndDate(new Timestamp(newEndDate.getTime()));
            periodc.get(i).setNumber(periodc.get(i).getPeriodYear() * 100 + periodc.get(i).getPeriodNumber());
            pkList[i] = iPeriod.addnew((CoreBaseInfo)periodc.get(i));
            System.out.println(pkList[i].toString());
        }
        return pkList;
    }

    @Override
    protected void _removePeriodCollection(Context ctx, IObjectPK[] pkList) throws BOSException, EASBizException {
        System.out.println("[method]: removePeriodCollection");
        IPeriod iPeriod = PeriodFactory.getLocalInstance(ctx);
        for (int i = 0; i < pkList.length; ++i) {
            System.out.println(pkList[i].toString());
            iPeriod.delete(pkList[i]);
        }
    }

    @Override
    protected IObjectPK[] _updatePeriodCollection(Context ctx, IObjectCollection updatePeriodCollection, IObjectPK[] removePKList, String PeriodTypeID, String PeriodYear) throws BOSException, EASBizException {
        Date newEndDate;
        Timestamp oldEndDate;
        PeriodCollection periodc = (PeriodCollection)updatePeriodCollection.cast(PeriodCollection.class);
        ArrayList<ObjectUuidPK> updatePeriodPKListTemp = new ArrayList<ObjectUuidPK>();
        for (int k = 0; k < updatePeriodCollection.size(); ++k) {
            if (periodc.get(k).getId() == null) continue;
            updatePeriodPKListTemp.add(new ObjectUuidPK(periodc.get(k).getId().toString()));
        }
        IObjectPK[] updatePeriodPKList = new IObjectPK[updatePeriodPKListTemp.size()];
        if (updatePeriodPKListTemp.size() > 0) {
            System.arraycopy(updatePeriodPKListTemp.toArray(), 0, updatePeriodPKList, 0, updatePeriodPKListTemp.size());
        }
        IPeriod iPeriod = PeriodFactory.getLocalInstance(ctx);
        PeriodInfo info = null;
        Vector<Integer> vRemoveIndex = new Vector<Integer>();
        System.out.println("Collection size : " + periodc.size());
        System.out.println("removePKList length : " + removePKList.length);
        if (this.isStartPeriod(ctx, removePKList) || this.isStartPeriod(ctx, updatePeriodPKList) && this.existStartPeriodBeforeRemove(ctx, updatePeriodPKList, periodc)) {
            throw new PeriodException(PeriodException.NOT_DEL_STARTPERIOD);
        }
        if (VoucherUtilFactory.getVoucherUtil().isVoucherExist(ctx, removePKList) || VoucherUtilFactory.getVoucherUtil().isVoucherExist(ctx, updatePeriodPKList) && VoucherUtilFactory.getVoucherUtil().existVoucherBeforeRemove(ctx, updatePeriodPKList, periodc)) {
            throw new PeriodException(PeriodException.NOT_DEL_PERIOD);
        }
        this._removePeriodCollection(ctx, removePKList);
        System.out.println("Collection new size : " + periodc.size());
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(" SELECT FPeriodNumber,FBeginDate,FEndDate FROM T_BD_Period A ");
        strBuf.append(" WHERE (A.FPeriodYear =" + PeriodYear);
        strBuf.append(" And A.FTypeID='" + PeriodTypeID + "')");
        strBuf.append(" ORDER BY A.FPeriodYear, A.FPeriodNumber");
        IRowSet existPeriodColl = DbUtil.executeQuery((Context)ctx, (String)strBuf.toString());
        if (existPeriodColl.size() > 0) {
            try {
                while (existPeriodColl.next()) {
                    for (int i = 0; i < periodc.size(); ++i) {
                        info = periodc.get(i);
                        if (info == null || info.getId() == null || info.getPeriodNumber() != existPeriodColl.getInt("FPeriodNumber") || info.getBeginDate().equals(new Date(existPeriodColl.getDate("FBeginDate").getTime())) && info.getEndDate().equals(new Date(existPeriodColl.getDate("FEndDate").getTime()))) continue;
                        if (this.isStartPeriod(ctx, info.getId().toString())) {
                            throw new PeriodException(PeriodException.NOT_UPDATE_STARTPERIOD);
                        }
                        if (this.isBeforeMaxPeriod(ctx, info.getId().toString())) {
                            String maxDate = null;
                            String sql = "select max(pd.FEndDate) maxDate from T_BD_SystemStatusCtrol ss inner join  T_BD_Period pd on ss.FCurrentPeriodID=pd.fid where pd.ftypeid='" + info.getPeriodType().getId().toString() + "'";
                            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
                            if (rowset != null && rowset.next() && (maxDate = rowset.getString("maxDate")) != null) {
                                maxDate = maxDate.substring(0, 7);
                            }
                            throw new PeriodException(PeriodException.CAN_NOT_UPDATE_CURRENTPERIOD, new Object[]{maxDate});
                        }
                        if (VoucherUtilFactory.getVoucherUtil().isVoucherExist(ctx, info.getId().toString())) {
                            throw new PeriodException(PeriodException.NOT_UPDATE_PERIOD);
                        }
                        oldEndDate = info.getEndDate();
                        newEndDate = this.setDateToSpecificTime(oldEndDate, 0, 0, 0);
                        info.setEndDate(new Timestamp(newEndDate.getTime()));
                        info.setNumber(info.getPeriodYear() * 100 + info.getPeriodNumber());
                        iPeriod.update((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getId().toString())), (CoreBaseInfo)info);
                        System.out.println("Collection new size : " + periodc.size());
                        vRemoveIndex.add(new Integer(i));
                    }
                }
            }
            catch (PeriodException e) {
                throw e;
            }
            catch (EASBizException e) {
                throw e;
            }
            catch (BOSException e) {
                throw e;
            }
            catch (UuidException e) {
                throw e;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            for (int i = 0; i < periodc.size(); ++i) {
                info = periodc.get(i);
                if (info.getId() == null) continue;
                oldEndDate = info.getEndDate();
                newEndDate = this.setDateToSpecificTime(oldEndDate, 23, 59, 59);
                info.setEndDate(new Timestamp(newEndDate.getTime()));
                info.setNumber(info.getPeriodYear() * 100 + info.getPeriodNumber());
                iPeriod.update((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getId().toString())), (CoreBaseInfo)info);
                System.out.println("Collection new size : " + periodc.size());
                vRemoveIndex.add(new Integer(i));
            }
        }
        for (int j = vRemoveIndex.size() - 1; j >= 0; --j) {
            periodc.remove(periodc.get(j));
        }
        return this._addPeriodCollection(ctx, (IObjectCollection)periodc);
    }

    private boolean isStartPeriod(Context ctx, IObjectPK[] removePKList) throws BOSException, EASBizException {
        boolean returnValue = false;
        ISystemStatusCtrol startPeriodCtrl = SystemStatusCtrolFactory.getLocalInstance(ctx);
        for (int i = 0; i < removePKList.length; ++i) {
            boolean isStartPeriod = startPeriodCtrl.isStartPeriod(BOSUuid.read((String)removePKList[i].toString()));
            if (!isStartPeriod) continue;
            returnValue = true;
        }
        return returnValue;
    }

    private boolean isStartPeriod(Context ctx, String removePKList) throws BOSException, EASBizException {
        boolean returnValue = false;
        ISystemStatusCtrol startPeriodCtrl = SystemStatusCtrolFactory.getLocalInstance(ctx);
        boolean isStartPeriod = startPeriodCtrl.isStartPeriod(BOSUuid.read((String)removePKList));
        if (isStartPeriod) {
            returnValue = true;
        }
        return returnValue;
    }

    private boolean isBeforeMaxPeriod(Context ctx, String fid) throws BOSException, EASBizException {
        boolean returnValue = false;
        String sql = "select fid from T_BD_Period where fenddate <= (select max(pd.FEndDate) maxDate from T_BD_SystemStatusCtrol ss inner join  T_BD_Period pd on ss.FCurrentPeriodID=pd.fid where pd.ftypeid=T_BD_Period.ftypeid) and T_BD_Period.fid='" + fid + "'";
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowset != null && rowset.next()) {
                returnValue = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return returnValue;
    }

    @Override
    protected int[] _getAllPeriodYear(Context ctx, String typeId) throws BOSException, EASBizException {
        int[] years = new int[]{};
        String sql = "SELECT Distinct FPeriodYear from T_BD_Period  where FTypeId = ? order by FPeriodYear desc";
        System.out.println(sql);
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{typeId});
        if (rows.size() > 0) {
            years = new int[rows.size()];
            int i = 0;
            try {
                while (rows.next()) {
                    years[i] = rows.getInt("FPeriodYear");
                    ++i;
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return years;
    }

    @Override
    protected HashMap _getNewPeriodRelInfo(Context ctx, String typeId) throws BOSException, EASBizException {
        HashMap<String, Comparable<Integer>> map = new HashMap<String, Comparable<Integer>>();
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT FPeriodYear,FPeriodQuarter,FPeriodNumber,FBeginDate,FEndDate,FIsAdjustPeriod FROM T_BD_Period ");
        strBuf.append("WHERE FPeriodYear IN (SELECT DISTINCT MAX(FPeriodYear) FROM T_BD_Period where ");
        strBuf.append("FTypeID = ?) and FTypeId = ? order by FPeriodYear,FPeriodNumber");
        Object[] params = new Object[]{typeId, typeId};
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)strBuf.toString(), (Object[])params);
        System.out.println(rows.size());
        map.put("PeriodCount", new Integer(rows.size()));
        if (rows.size() != 0) {
            PeriodCollection collection = new PeriodCollection();
            PeriodInfo info = null;
            IPeriodType iPeriodType = PeriodTypeFactory.getLocalInstance(ctx);
            PeriodTypeInfo typeInfo = iPeriodType.getPeriodTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)typeId)));
            try {
                while (rows.next()) {
                    info = new PeriodInfo();
                    info.setPeriodType(typeInfo);
                    info.setPeriodYear(rows.getInt("FPeriodYear"));
                    info.setPeriodQuarter(rows.getInt("FPeriodQuarter"));
                    info.setPeriodNumber(rows.getInt("FPeriodNumber"));
                    info.setBeginDate(rows.getDate("FBeginDate"));
                    info.setEndDate(new Timestamp(rows.getDate("FEndDate").getTime()));
                    info.setIsAdjustPeriod(rows.getBoolean("FIsAdjustPeriod"));
                    collection.add(info);
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                throw new BOSException((Throwable)ex);
            }
            Date newBeginDate = DateTimeUtils.addDay((Date)collection.get(collection.size() - 1).getEndDate(), (long)1L);
            map.put("BeginDate", newBeginDate);
            map.put("PeriodYear", new Integer(collection.get(0).getPeriodYear() + 1));
        }
        return map;
    }

    @Override
    protected IRowSet _getNoRelation(Context ctx, String sourceTypeId, String targetTypeId) throws BOSException, EASBizException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT B.FPeriodYear, B.FPeriodNumber  ");
        strBuf.append("FROM T_BD_PeriodRelation A RIGHT OUTER JOIN T_BD_Period B ON A.FTargetPeriod = B.FID ");
        strBuf.append("WHERE (A.FSourcePeriod IS NOT NULL) AND (B.FTypeID = ?) ");
        strBuf.append("ORDER BY B.FPeriodYear, B.FPeriodNumber");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)strBuf.toString(), (Object[])new Object[]{sourceTypeId, targetTypeId});
        return rows;
    }

    @Override
    protected IRowSet _getAllTargetPeriods(Context ctx, String PeriodTypeId) throws BOSException, EASBizException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT FID,FPeriodYear,FPeriodNumber ");
        strBuf.append("FROM T_BD_Period ");
        strBuf.append("WHERE FTypeID = ? ");
        strBuf.append("ORDER BY FPeriodYear, FPeriodNumber");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)strBuf.toString(), (Object[])new Object[]{PeriodTypeId});
        return rows;
    }

    private boolean existStartPeriodBeforeRemove(Context ctx, IObjectPK[] updatePeriodPKList, PeriodCollection periodc) throws EASBizException, BOSException {
        PeriodInfo oldInfo = null;
        ISystemStatusCtrol startPeriodCtrl = SystemStatusCtrolFactory.getLocalInstance(ctx);
        IPeriod iPeriod = PeriodFactory.getLocalInstance(ctx);
        for (int i = 0; i < updatePeriodPKList.length; ++i) {
            boolean isStartPeriod = startPeriodCtrl.isStartPeriod(BOSUuid.read((String)updatePeriodPKList[i].toString()));
            if (!isStartPeriod) continue;
            oldInfo = iPeriod.getPeriodInfo(updatePeriodPKList[i]);
            for (int j = 0; j < periodc.size(); ++j) {
                if (periodc.get(j).getId() == null || !oldInfo.getId().toString().equals(periodc.get(j).getId().toString()) || oldInfo.getPeriodNumber() == periodc.get(j).getPeriodNumber()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected Date _getMaxPeriodEndDate(Context ctx, IObjectPK CompanyID) throws BOSException, EASBizException {
        ICompanyOrgUnit iComOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo comOrgInfo = iComOrg.getCompanyOrgUnitInfo(CompanyID);
        PeriodTypeInfo periodTypeInfo = comOrgInfo.getAccountPeriodType();
        if (periodTypeInfo != null) {
            BOSUuid periodTypeID = periodTypeInfo.getId();
            IPeriod iPeriod = PeriodFactory.getLocalInstance(ctx);
            EntityViewInfo env = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodTypeID.toString()));
            env.setFilter(filter);
            PeriodCollection periodCol = iPeriod.getPeriodCollection(env);
            int periodNum = periodCol.size();
            if (periodNum > 0) {
                return periodCol.get(periodNum - 1).getEndDate();
            }
            throw new PeriodException(PeriodException.COMPANYNOPERIOD);
        }
        throw new PeriodException(PeriodException.COMPANYNOPERIOD);
    }

    private Date setDateToSpecificTime(Date date, int hour, int min, int sec) {
        if (date == null || hour > 24 || hour < 0 || min > 59 || min < 0 || sec > 59 || sec < 0) {
            return date;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(11, hour);
        cal.set(12, min);
        cal.set(13, sec);
        cal.set(14, 0);
        return cal.getTime();
    }
}

