/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.AbstractMulDataTransmission;
import com.kingdee.eas.basedata.assistant.IPayCondition;
import com.kingdee.eas.basedata.assistant.PayConditionCollection;
import com.kingdee.eas.basedata.assistant.PayConditionEntryInfo;
import com.kingdee.eas.basedata.assistant.PayConditionFactory;
import com.kingdee.eas.basedata.assistant.PayConditionInfo;
import com.kingdee.eas.basedata.assistant.PayConditionUsageEnum;
import com.kingdee.eas.basedata.assistant.SettlementTypeEnum;
import com.kingdee.eas.basedata.assistant.StartStandardEnum;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;

public class PayConditionDataTransmission
extends AbstractMulDataTransmission {
    private final String RESOURCE_FILE_NAME = "com.kingdee.eas.tools.datatask.DatataskResource";
    private static final int HALF_UP = 4;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PayConditionFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    @Override
    protected CoreBaseInfo createHead(Hashtable hsData, Context ctx) throws Exception {
        CompanyOrgUnitInfo company;
        BigDecimal tempBigDecimal;
        PayConditionInfo info = new PayConditionInfo();
        String tempString = null;
        tempString = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        if (tempString == null || tempString.trim().length() == 0) {
            throw new TaskExternalException("number not found!");
        }
        if (this.isSltImportUpdate()) {
            EntityViewInfo viewInfo = DataImportTools.getNumberEntityView((String)tempString);
            IPayCondition iPayCondition = PayConditionFactory.getLocalInstance(ctx);
            PayConditionCollection collection = iPayCondition.getPayConditionCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                info.setId(collection.get(0).getId());
            }
        }
        info.setNumber(tempString);
        info.setName(DataImportTools.getMlData((Hashtable)hsData, (String)"FName"));
        PayConditionUsageEnum tempEnum = DataImportTools.getPayConditionUsageEnum((String)((String)((DataToken)hsData.get((Object)"FUsage")).data), (Context)ctx);
        if (tempEnum == null) {
            throw new TaskExternalException("usage not found!");
        }
        info.setUsage(tempEnum);
        tempString = DataImportTools.getMlData((Hashtable)hsData, (String)"FDescription");
        if (tempString != null && tempString.trim().length() > 0) {
            info.setDescription(tempString);
        }
        if ((tempBigDecimal = DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)"FPrepayRate")) != null) {
            info.setPrepayRate(tempBigDecimal);
        }
        if ((company = DataImportTools.getCompanyOrgUnitInfoFromNumber((Context)ctx, (String)(tempString = (String)((DataToken)hsData.get((Object)"FCompanyID")).data))) == null) {
            company = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        if (company == null) {
            throw new TaskExternalException("Company not Found");
        }
        info.setCreateOrg(company);
        tempEnum = DataImportTools.getDeletedStatusEnum((String)((String)((DataToken)hsData.get((Object)"FDeletedStatus")).data), (Context)ctx);
        if (tempEnum != null) {
            info.setDeletedStatus((DeletedStatusEnum)tempEnum);
        }
        return info;
    }

    @Override
    protected void createEntry(CoreBaseInfo head, Hashtable hsData, Context ctx) throws Exception {
        StringEnum tempEnum;
        PayConditionEntryInfo info = new PayConditionEntryInfo();
        BigDecimal tempBigDecimal = DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)"FRate");
        if (tempBigDecimal != null) {
            info.setRate(tempBigDecimal);
        }
        if ((tempEnum = DataImportTools.getSettlementTypeEnum((String)((String)((DataToken)hsData.get((Object)"FSettlementType")).data), (Context)ctx)) != null) {
            info.setSettlementType((SettlementTypeEnum)tempEnum);
        }
        if ((tempEnum = DataImportTools.getStartStandardEnum((String)((String)((DataToken)hsData.get((Object)"FStartStandard")).data), (Context)ctx)) != null) {
            info.setStartStandard((StartStandardEnum)tempEnum);
        }
        info.setStartDeferDays(DataImportTools.getDataint((Hashtable)hsData, (String)"FStartDeferDays"));
        Date date = DataImportTools.getDataDate((Hashtable)hsData, (String)"FFicedDate");
        info.setFicedDate(date);
        info.setCreditDays(DataImportTools.getDataint((Hashtable)hsData, (String)"FCreditDays"));
        info.setMonths(DataImportTools.getDataint((Hashtable)hsData, (String)"FMonths"));
        info.setDay(DataImportTools.getDataint((Hashtable)hsData, (String)"FDay"));
        info.setIsPrepay(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsPrepay"));
        PayConditionInfo parent = (PayConditionInfo)head;
        info.setParent(parent);
        parent.getEntries().add(info);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("FNumber", rs.getString("number"));
            String languagePostfix = "_" + ctx.getLocale().getLanguage().toUpperCase();
            if (rs.getString("name") != null) {
                DataImportTools.putValue(result, (Object)("FName" + languagePostfix), (Object)rs.getString("name"));
            }
            DataImportTools.putValue(result, (Object)"FUsage", (Object)PayConditionUsageEnum.getEnum(rs.getString("usage")).getAlias(ctx.getLocale()));
            BigDecimal prepayRate = rs.getBigDecimal("prepayRate") == null ? new BigDecimal(0) : rs.getBigDecimal("prepayRate");
            DataImportTools.putValue(result, (Object)"FPrepayRate", (Object)prepayRate.setScale(2, 4).toString());
            DataImportTools.putValue(result, (Object)"FCompanyID", (Object)rs.getString("createOrg.number"));
            DataImportTools.putValue(result, (Object)"FDeletedStatus", (Object)DeletedStatusEnum.getEnum((String)rs.getString("deletedStatus")));
            if (rs.getString("description") != null) {
                DataImportTools.putValue(result, (Object)("FDescription" + languagePostfix), (Object)rs.getString("description"));
            }
            BigDecimal rate = rs.getBigDecimal("PayConditionEntry.rate") == null ? new BigDecimal(0) : rs.getBigDecimal("PayConditionEntry.rate");
            DataImportTools.putValue(result, (Object)"FRate", (Object)rate.setScale(2, 4).toString());
            DataImportTools.putValue(result, (Object)"FSettlementType", (Object)SettlementTypeEnum.getEnum(rs.getString("PayConditionEntry.settlementType")).getAlias(ctx.getLocale()));
            DataImportTools.putValue(result, (Object)"FStartStandard", (Object)StartStandardEnum.getEnum(rs.getString("PayConditionEntry.startStandard")).getAlias(ctx.getLocale()));
            DataImportTools.putValue(result, (Object)"FStartDeferDays", (Object)rs.getString("PayConditionEntry.startDeferDays"));
            DataImportTools.putValue(result, (Object)"FFicedDate", (Object)rs.getString("PayConditionEntry.ficedDate"));
            DataImportTools.putValue(result, (Object)"FCreditDays", (Object)rs.getString("PayConditionEntry.creditDays"));
            DataImportTools.putValue(result, (Object)"FMonths", (Object)rs.getString("PayConditionEntry.months"));
            DataImportTools.putValue(result, (Object)"FDay", (Object)rs.getString("PayConditionEntry.day"));
            boolean isPrepay = rs.getBoolean("PayConditionEntry.isPrepay");
            DataImportTools.putValue(result, (Object)"FIsPrepay", (Object)DataImportTools.boolToString((boolean)isPrepay));
        }
        catch (SQLException e) {
            e.printStackTrace();
            Locale currentLocale = ctx.getLocale();
            String message = ResourceBase.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"accessError", (Locale)currentLocale);
            throw new TaskExternalException(message, (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("createOrg.id", (Object)company.getId(), CompareType.EQUALS));
        StringBuffer sb = new StringBuffer();
        sb.append(" select FPayConditionID from T_BD_PayConditionReference ");
        sb.append("where (FAssignCompanyID = '");
        sb.append(company.getId().toString());
        sb.append("') ");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        filter.setMaskString("#0 OR #1");
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.assistant.app.PayConditionQuery";
    }
}

