/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PrintIntegrationCollection;
import com.kingdee.eas.basedata.assistant.PrintIntegrationInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractPrintIntegrationControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PrintIntegrationControllerBean
extends AbstractPrintIntegrationControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.PrintIntegrationControllerBean");

    @Override
    protected PrintIntegrationInfo _getBillPrintInfo(Context ctx, String bosType, String billID) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("printBosType", (Object)bosType, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("printBillID", (Object)billID, CompareType.EQUALS));
        fi.setMaskString("#0 and #1");
        ev.setFilter(fi);
        PrintIntegrationCollection pcon = this.getPrintIntegrationCollection(ctx, ev);
        if (pcon.size() > 0) {
            return pcon.get(0);
        }
        return null;
    }

    @Override
    protected boolean _updateBillsPrintInfoByList(Context ctx, List printList) throws BOSException {
        boolean isUpdate = false;
        try {
            PrintIntegrationInfo printInfo = null;
            for (int i = 0; i < printList.size(); ++i) {
                printInfo = (PrintIntegrationInfo)printList.get(i);
                if (printInfo.getId() != null) {
                    this.update(ctx, (IObjectPK)new ObjectStringPK(printInfo.getId().toString()), (CoreBaseInfo)printInfo);
                    continue;
                }
                this.addnew(ctx, (CoreBaseInfo)printInfo);
            }
            isUpdate = true;
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            isUpdate = false;
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            isUpdate = false;
            throw new BOSException((Throwable)e);
        }
        return isUpdate;
    }

    @Override
    protected List _getBillsPrintInfoByList(Context ctx, List printList, String bosType) throws BOSException {
        StringBuffer str_sql = new StringBuffer();
        str_sql.append("select t.fid,t.fprintbostype,t.fprintbillid,t.fprintednumber ");
        str_sql.append("from t_pi_printintegration t ");
        str_sql.append("where t.fprintbostype ='" + bosType + "' ");
        str_sql.append("and t.fprintbillid in (");
        for (int i = 0; i < printList.size(); ++i) {
            str_sql.append("'" + printList.get(i) + "'" + (i != printList.size() - 1 ? "," : "") + "");
        }
        str_sql.append(")");
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"37_PrintIntegrationControllerBean", (Locale)ctx.getLocale()) + str_sql.toString()));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)str_sql.toString());
        ArrayList<PrintIntegrationInfo> infoList = new ArrayList<PrintIntegrationInfo>();
        PrintIntegrationInfo info = null;
        try {
            while (rs.next()) {
                info = new PrintIntegrationInfo();
                info.setId(BOSUuid.read((String)rs.getString("fid")));
                info.setPrintBosType(rs.getString("fprintbostype"));
                info.setPrintBillID(rs.getString("fprintbillid"));
                info.setPrintedNumber(Integer.parseInt(rs.getString("fprintednumber")));
                infoList.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return infoList;
    }

    @Override
    protected String _getBillNumberByBosType(Context ctx, String bosType, String billID) throws BOSException {
        EntityObjectInfo df = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)BOSObjectType.create((String)bosType));
        String tabName = df.getTable().getName();
        StringBuffer str_sql = new StringBuffer();
        str_sql.append("select t.fnumber from ");
        str_sql.append(tabName + " t");
        str_sql.append(" where t.fid='" + billID + "'");
        logger.debug((Object)str_sql.toString());
        String billNumber = "";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)str_sql.toString());
            if (rs.next()) {
                billNumber = rs.getString("fnumber");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return billNumber;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PrintIntegrationInfo printInfo = (PrintIntegrationInfo)model;
        PrintIntegrationInfo printInfoFromDB = this._getBillPrintInfo(ctx, printInfo.getBOSType().toString(), printInfo.getPrintBillID());
        if (printInfoFromDB == null) {
            return super._addnew(ctx, model);
        }
        int curNum = printInfo.getPrintedNumber();
        printInfo.setPrintedNumber(printInfoFromDB.getPrintedNumber() + curNum);
        ObjectUuidPK pk = new ObjectUuidPK(printInfoFromDB.getId());
        super._update(ctx, (IObjectPK)pk, (IObjectValue)printInfoFromDB);
        return pk;
    }
}

