/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.AssistantCtrlUnitUtils;
import com.kingdee.eas.basedata.assistant.AssistantException;
import com.kingdee.eas.basedata.assistant.RegionInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractRegionControllerBean;
import com.kingdee.eas.basedata.assistant.util.AssistantUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import java.util.Locale;

public class RegionControllerBean
extends AbstractRegionControllerBean {
    public static final String L1_VALUE = "L1";
    public static final String L2_VALUE = "L2";
    public static final String L3_VALUE = "L3";
    public static final Locale l1 = new Locale("L1");
    public static final Locale l2 = new Locale("L2");
    public static final Locale l3 = new Locale("L3");

    protected void addnewCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ((RegionInfo)model).setCU(AssistantCtrlUnitUtils.getRootCU(ctx));
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkCityNameBlank(ctx, model);
    }

    protected void _checkCityNameBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RegionInfo info = (RegionInfo)model;
        if (info.getCity() == null) {
            throw new AssistantException(AssistantException.CITYNOTNULL);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected void updateCheck(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        RegionInfo oldModel = this.getRegionInfo(ctx, pk);
        if (!((DataBaseInfo)model).getNumber().equals(oldModel.getNumber())) {
            this._checkNumberDup(ctx, model);
        }
        if (!((DataBaseInfo)model).getName().equals(oldModel.getName())) {
            // empty if block
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCheck(ctx, pk, model);
        String[] oldNameStr = AssistantUtil.getOldAddressName(ctx, pk, "T_BD_Region");
        RegionInfo oldRegion = this.getRegionInfo(ctx, pk);
        String oldRegionName = oldRegion.getName();
        super._update(ctx, pk, model);
        if (!oldRegionName.equals(((RegionInfo)model).getName())) {
            String name_l1 = ((RegionInfo)model).getName(l1);
            String name_l2 = ((RegionInfo)model).getName(l2);
            String name_l3 = ((RegionInfo)model).getName(l3);
            String[] newNameStr = new String[]{name_l1, name_l2, name_l3};
            AssistantUtil.updateAddress(ctx, pk, oldNameStr, newNameStr, "T_BD_Region", "FDistrictIdID");
        }
    }
}

