/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeException;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;

public class SettlementTypeDataTransmission
extends AbstractDataTransmission {
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SettlementTypeFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String noteType;
        String isDefault;
        String description_l3;
        String description_l2;
        String description_l1;
        String name_l3;
        String name_l2;
        String name_l1;
        SettlementTypeInfo info = new SettlementTypeInfo();
        String number = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        if (number == null) throw new TaskExternalException("number not found!");
        info.setNumber(number);
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (mode == 16) {
            try {
                ISettlementType iSettlementType = (ISettlementType)this.getController(ctx);
                SettlementTypeCollection settlementTypeCollection = iSettlementType.getSettlementTypeCollection();
                if (settlementTypeCollection != null) {
                    for (int i = 0; i < settlementTypeCollection.size(); ++i) {
                        if (!settlementTypeCollection.get(i).getNumber().equalsIgnoreCase(number)) continue;
                        info.setId(settlementTypeCollection.get(i).getId());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TaskExternalException("BOSException: getSettlementTypeCollection", (Throwable)e);
            }
        }
        if ((name_l1 = (String)((DataToken)hsData.get((Object)"Fname_L1")).data) != null && name_l1.trim().length() != 0) {
            info.setName(name_l1, new Locale("L1"));
        }
        if ((name_l2 = (String)((DataToken)hsData.get((Object)"Fname_L2")).data) != null && name_l2.trim().length() != 0) {
            info.setName(name_l2, new Locale("L2"));
        }
        if ((name_l3 = (String)((DataToken)hsData.get((Object)"Fname_L3")).data) != null && name_l3.trim().length() != 0) {
            info.setName(name_l3, new Locale("L3"));
        }
        if ((description_l1 = (String)((DataToken)hsData.get((Object)"Fdescription_L1")).data) != null && description_l1.trim().length() != 0) {
            info.setDescription(description_l1, new Locale("L1"));
        }
        if ((description_l2 = (String)((DataToken)hsData.get((Object)"Fdescription_L2")).data) != null && description_l2.trim().length() != 0) {
            info.setDescription(description_l2, new Locale("L2"));
        }
        if ((description_l3 = (String)((DataToken)hsData.get((Object)"Fdescription_L3")).data) != null && description_l3.trim().length() != 0) {
            info.setDescription(description_l3, new Locale("L3"));
        }
        if ((isDefault = (String)((DataToken)hsData.get((Object)"FIsDefault")).data) != null && isDefault.trim().length() != 0) {
            info.setIsDefault(this.getBooleanFromAlias(isDefault));
        }
        if ((noteType = (String)((DataToken)hsData.get((Object)"NoteType")).data) == null || noteType.length() <= 0) return info;
        try {
            NTTypeInfo noteTypeInfo = (NTTypeInfo)NTTypeFactory.getLocalInstance((Context)ctx).getValue("where number = '" + noteType + "'");
            info.setNtType(noteTypeInfo);
            return info;
        }
        catch (ObjectNotFoundException e) {
            String msg = new SettlementTypeException(SettlementTypeException.NOTEXIST_TARGET_NTTYPE, new Object[]{noteType}).getMessage();
            throw new TaskExternalException(msg, (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase iSettlementType = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !iSettlementType.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iSettlementType.addnew(coreBaseInfo);
            } else {
                iSettlementType.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("FNumber", rs.getString("number"));
            if (LocaleUtils.getLocale((String)"l2").equals(ctx.getLocale()) && rs.getString("name") != null) {
                result.put("Fname_L2", rs.getString("name"));
            }
            if (LocaleUtils.getLocale((String)"l3").equals(ctx.getLocale()) && rs.getString("name") != null) {
                result.put("Fname_L3", rs.getString("name"));
            }
            if (LocaleUtils.getLocale((String)"l2").equals(ctx.getLocale()) && rs.getString("description") != null) {
                result.put("Fdescription_L2", rs.getString("description"));
            }
            if (LocaleUtils.getLocale((String)"l3").equals(ctx.getLocale()) && rs.getString("description") != null) {
                result.put("Fdescription_L3", rs.getString("description"));
            }
            result.put("FIsDefault", this.getAliasFromBooleanValue(rs.getBoolean("isDefault")));
            String noteType = rs.getString("ntType.number");
            if (noteType != null && noteType.length() > 0) {
                result.put("NoteType", rs.getString("ntType.number"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new TaskExternalException("Database access error occurs, can't read field values!", (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.assistant.app.SettlementTypeQuery";
    }

    private boolean getBooleanFromAlias(String isFreeze) {
        return !isFreeze.equals("N");
    }

    private String getAliasFromBooleanValue(boolean value) {
        if (value) {
            return "Y";
        }
        return "N";
    }
}

