/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import java.util.Hashtable;

public final class SystemStatusCtrolCacheImpl {
    private static Hashtable sysStatusCtrolMap = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSystemStatusCtrolCache(Context ctx) {
        if (sysStatusCtrolMap != null) {
            Hashtable hashtable = sysStatusCtrolMap;
            synchronized (hashtable) {
                sysStatusCtrolMap.remove(ctx.getAIS());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void constructPeriod(Context ctx) throws BOSException {
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("isStart"));
        sic.add(new SelectorItemInfo("isRelatedAccount"));
        sic.add(new SelectorItemInfo("isClosedAccount"));
        sic.add(new SelectorItemInfo("systemStatus.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("currentPeriod.id"));
        sic.add(new SelectorItemInfo("currentPeriod.periodYear"));
        sic.add(new SelectorItemInfo("currentPeriod.periodNumber"));
        sic.add(new SelectorItemInfo("currentPeriod.isAdjustPeriod"));
        sic.add(new SelectorItemInfo("currentPeriod.beginDate"));
        sic.add(new SelectorItemInfo("currentPeriod.endDate"));
        sic.add(new SelectorItemInfo("startPeriod.id"));
        sic.add(new SelectorItemInfo("startPeriod.periodYear"));
        sic.add(new SelectorItemInfo("startPeriod.periodNumber"));
        sic.add(new SelectorItemInfo("startPeriod.isAdjustPeriod"));
        sic.add(new SelectorItemInfo("startPeriod.beginDate"));
        sic.add(new SelectorItemInfo("startPeriod.endDate"));
        SystemStatusCtrolCollection sysStatusColl = ictrol.getSystemStatusCtrolCollection(view);
        Hashtable<String, SystemStatusCtrolInfo> currAISSysStatus = new Hashtable<String, SystemStatusCtrolInfo>();
        int size = sysStatusColl.size();
        for (int i = 0; i < size; ++i) {
            SystemStatusCtrolInfo systemStatusCtrolInfo = sysStatusColl.get(i);
            Hashtable<String, SystemStatusCtrolInfo> hashtable = currAISSysStatus;
            synchronized (hashtable) {
                if (systemStatusCtrolInfo.getSystemStatus().getName() != null) {
                    currAISSysStatus.put(systemStatusCtrolInfo.getCompany().getId().toString() + "_" + systemStatusCtrolInfo.getSystemStatus().getName().getValue(), systemStatusCtrolInfo);
                }
                continue;
            }
        }
        sysStatusCtrolMap.put(ctx.getAIS(), currAISSysStatus);
    }

    public static PeriodInfo getCurrentPeriod(Context ctx, int systemStatus, String companyID) throws BOSException {
        if (sysStatusCtrolMap.get(ctx.getAIS()) == null) {
            SystemStatusCtrolCacheImpl.constructPeriod(ctx);
        }
        if (((Hashtable)sysStatusCtrolMap.get(ctx.getAIS())).get(companyID + "_" + systemStatus) != null) {
            return ((SystemStatusCtrolInfo)((Hashtable)sysStatusCtrolMap.get(ctx.getAIS())).get(companyID + "_" + systemStatus)).getCurrentPeriod();
        }
        return null;
    }

    public static PeriodInfo getStartPeriod(Context ctx, int systemStatus, String companyID) throws BOSException {
        if (sysStatusCtrolMap.get(ctx.getAIS()) == null) {
            SystemStatusCtrolCacheImpl.constructPeriod(ctx);
        }
        if (((Hashtable)sysStatusCtrolMap.get(ctx.getAIS())).get(companyID + "_" + systemStatus) != null) {
            return ((SystemStatusCtrolInfo)((Hashtable)sysStatusCtrolMap.get(ctx.getAIS())).get(companyID + "_" + systemStatus)).getStartPeriod();
        }
        return null;
    }

    public static boolean isClose(Context ctx, int systemStatus, String companyID) throws BOSException {
        if (sysStatusCtrolMap.get(ctx.getAIS()) == null) {
            SystemStatusCtrolCacheImpl.constructPeriod(ctx);
        }
        if (((Hashtable)sysStatusCtrolMap.get(ctx.getAIS())).get(companyID + "_" + systemStatus) != null) {
            return ((SystemStatusCtrolInfo)((Hashtable)sysStatusCtrolMap.get(ctx.getAIS())).get(companyID + "_" + systemStatus)).isIsClosedAccount();
        }
        return false;
    }

    public static boolean isStart(Context ctx, int systemStatus, String companyID) throws BOSException {
        if (sysStatusCtrolMap.get(ctx.getAIS()) == null) {
            SystemStatusCtrolCacheImpl.constructPeriod(ctx);
        }
        if (((Hashtable)sysStatusCtrolMap.get(ctx.getAIS())).get(companyID + "_" + systemStatus) != null) {
            return ((SystemStatusCtrolInfo)((Hashtable)sysStatusCtrolMap.get(ctx.getAIS())).get(companyID + "_" + systemStatus)).isIsStart();
        }
        return false;
    }

    public static boolean isRelatedAccount(Context ctx, String companyID, int systemStatus) throws BOSException {
        if (sysStatusCtrolMap.get(ctx.getAIS()) == null) {
            SystemStatusCtrolCacheImpl.constructPeriod(ctx);
        }
        if (((Hashtable)sysStatusCtrolMap.get(ctx.getAIS())).get(companyID + "_" + systemStatus) != null) {
            return ((SystemStatusCtrolInfo)((Hashtable)sysStatusCtrolMap.get(ctx.getAIS())).get(companyID + "_" + systemStatus)).isIsRelatedAccount();
        }
        return false;
    }

    public static boolean isEqualsCurPeriodAndRelPeriod(Context ctx, int systemStatus, String companyID) throws BOSException {
        if (sysStatusCtrolMap.get(ctx.getAIS()) == null) {
            SystemStatusCtrolCacheImpl.constructPeriod(ctx);
        }
        if (((Hashtable)sysStatusCtrolMap.get(ctx.getAIS())).get(companyID + "_" + systemStatus) != null) {
            return ((SystemStatusCtrolInfo)((Hashtable)sysStatusCtrolMap.get(ctx.getAIS())).get(companyID + "_" + systemStatus)).getCurrentPeriod().getId().toString().equals(((SystemStatusCtrolInfo)((Hashtable)sysStatusCtrolMap.get(ctx.getAIS())).get(companyID + "_" + systemStatus)).getStartPeriod().getId().toString());
        }
        return false;
    }

    public static SystemStatusCtrolInfo getSystemStatusCtrolInfo(Context ctx, int systemStatus, String companyID) throws BOSException {
        if (sysStatusCtrolMap.get(ctx.getAIS()) == null) {
            SystemStatusCtrolCacheImpl.constructPeriod(ctx);
        }
        if (((Hashtable)sysStatusCtrolMap.get(ctx.getAIS())).get(companyID + "_" + systemStatus) != null) {
            return (SystemStatusCtrolInfo)((Hashtable)sysStatusCtrolMap.get(ctx.getAIS())).get(companyID + "_" + systemStatus);
        }
        return null;
    }
}

