/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.TimeZoneException;
import com.kingdee.eas.basedata.assistant.TimeZoneInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractTimeZoneControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class TimeZoneControllerBean
extends AbstractTimeZoneControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.TimeZoneControllerBean");

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TimeZoneInfo coreBaseInfo = (TimeZoneInfo)model;
        coreBaseInfo.setDeleteStatus(DeletedStatusEnum.DELETED);
        super._cancel(ctx, pk, (IObjectValue)coreBaseInfo);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNum(ctx, null, model);
        this.oneDefaultOnlyCheck(ctx, null, model);
        return super._addnew(ctx, model);
    }

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkNum(ctx, pk, model);
        this.oneDefaultOnlyCheck(ctx, pk, model);
        super._addnew(ctx, pk, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkNum(ctx, pk, model);
        this.oneDefaultOnlyCheck(ctx, pk, model);
        super._update(ctx, pk, model);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TimeZoneInfo coreBaseInfo = (TimeZoneInfo)model;
        coreBaseInfo.setDeleteStatus(DeletedStatusEnum.NORMAL);
        super._cancel(ctx, pk, (IObjectValue)coreBaseInfo);
    }

    protected void checkNum(Context ctx, IObjectPK pk, IObjectValue model) throws DataBaseException, TimeZoneException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        String number = dataBaseInfo.getNumber();
        if (number == null || number.trim().equals("")) {
            throw new DataBaseException(DataBaseException.NUMBERNOTNULL);
        }
        if (TimeZoneControllerBean.hasChineseByReg(number)) {
            throw new TimeZoneException(TimeZoneException.BLANKNOTALLOW4NUMBER);
        }
    }

    protected void oneDefaultOnlyCheck(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        TimeZoneInfo dataBaseInfo = (TimeZoneInfo)model;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isdefault", (Object)1, CompareType.EQUALS));
        if (pk != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)pk, CompareType.NOTEQUALS));
        }
        if (dataBaseInfo.isIsDefault() && this.exists(ctx, filterInfo)) {
            throw new TimeZoneException(TimeZoneException.ONLYONEDEFALUT);
        }
    }

    public static boolean hasChinese(String str) {
        char[] ch;
        if (str == null) {
            return false;
        }
        for (char c : ch = str.toCharArray()) {
            if (!TimeZoneControllerBean.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isChinese(String str) {
        char[] ch;
        if (str == null) {
            return false;
        }
        for (char c : ch = str.toCharArray()) {
            if (TimeZoneControllerBean.isChinese(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B) {
            return true;
        }
        if (ub == Character.UnicodeBlock.GENERAL_PUNCTUATION) {
            return true;
        }
        return ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static boolean hasChineseByReg(String str) {
        if (str == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("[\\u4E00-\\u9FBF]+");
        return pattern.matcher(str).find();
    }

    public static boolean isChineseByReg(String str) {
        if (str == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("[\\u4E00-\\u9FBF]+");
        return pattern.matcher(str).matches();
    }

    public static boolean hasChineseByRange(String str) {
        char[] ch;
        if (str == null) {
            return false;
        }
        for (char c : ch = str.toCharArray()) {
            if (c < '\u4e00' || c > '\u9fbf') continue;
            return true;
        }
        return false;
    }

    public static boolean isChineseByRange(String str) {
        char[] ch;
        if (str == null) {
            return false;
        }
        for (char c : ch = str.toCharArray()) {
            if (c >= '\u4e00' && c <= '\u9fbf') continue;
            return false;
        }
        return true;
    }
}

