/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.assistant.ITimeZone;
import com.kingdee.eas.basedata.assistant.TimeDifference;
import com.kingdee.eas.basedata.assistant.TimeZoneCollection;
import com.kingdee.eas.basedata.assistant.TimeZoneFactory;
import com.kingdee.eas.basedata.assistant.TimeZoneInfo;
import com.kingdee.eas.basedata.assistant.TimeZoneStandard;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;

public class TimeZoneDataTransmission
extends AbstractDataTransmission {
    private final String RESOURCE_FILE_NAME = "com.kingdee.eas.tools.datatask.DatataskResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return TimeZoneFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String description_l3;
        String description_l2;
        String description_l1;
        String name_l3;
        String name_l2;
        String timeZoneStandard;
        TimeZoneInfo info = new TimeZoneInfo();
        String number = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        if (number == null) throw new TaskExternalException("number not found!");
        info.setNumber(number);
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (mode == 16) {
            try {
                ITimeZone iTimeZone = (ITimeZone)this.getController(ctx);
                TimeZoneCollection timeZoneCollection = iTimeZone.getTimeZoneCollection();
                if (timeZoneCollection != null) {
                    for (int i = 0; i < timeZoneCollection.size(); ++i) {
                        if (!timeZoneCollection.get(i).getNumber().equalsIgnoreCase(number)) continue;
                        info.setId(timeZoneCollection.get(i).getId());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TaskExternalException("BOSException: timeZoneCollection", (Throwable)e);
            }
        }
        if ((timeZoneStandard = (String)((DataToken)hsData.get((Object)"FTimeZoneStandard")).data) == null) {
            throw new TaskExternalException("timeZoneStandard not found!");
        }
        info.setTimeZoneStandard(TimeZoneStandard.getEnum(timeZoneStandard));
        String timeDiff = (String)((DataToken)hsData.get((Object)"FTimeDiff")).data;
        if (timeDiff == null) {
            throw new TaskExternalException("timeDiff not found!");
        }
        info.setTimeDiff(TimeDifference.getEnum(timeDiff));
        String standardTimeCode = (String)((DataToken)hsData.get((Object)"FStandardTimeCode")).data;
        if (standardTimeCode == null) {
            throw new TaskExternalException("standardTimeCode not found!");
        }
        info.setStandardTime(standardTimeCode);
        String deleteStatus = (String)((DataToken)hsData.get((Object)"FDeleteStatus")).data;
        if (deleteStatus == null) {
            throw new TaskExternalException("deleteStatus not found!");
        }
        info.setDeleteStatus(DeletedStatusEnum.getEnum((String)deleteStatus));
        String sortN = (String)((DataToken)hsData.get((Object)"FSortNumber")).data;
        if ("".equals(sortN)) {
            info.setSortNumber(0);
        } else {
            int sortNumber = Integer.parseInt(((DataToken)hsData.get((Object)"FSortNumber")).data.toString());
            info.setSortNumber(sortNumber);
        }
        String name_l1 = (String)((DataToken)hsData.get((Object)"FName_l1")).data;
        if (name_l1 != null && name_l1.trim().length() != 0) {
            info.setName(name_l1, new Locale("L1"));
        }
        if ((name_l2 = (String)((DataToken)hsData.get((Object)"FName_l2")).data) != null && name_l2.trim().length() != 0) {
            info.setName(name_l2, new Locale("L2"));
        }
        if ((name_l3 = (String)((DataToken)hsData.get((Object)"FName_l3")).data) != null && name_l3.trim().length() != 0) {
            info.setName(name_l3, new Locale("L3"));
        }
        if ((description_l1 = (String)((DataToken)hsData.get((Object)"FDescription_l1")).data) != null && description_l1.trim().length() != 0) {
            info.setDescription(description_l1, new Locale("L1"));
        }
        if ((description_l2 = (String)((DataToken)hsData.get((Object)"FDescription_l2")).data) != null && description_l2.trim().length() != 0) {
            info.setDescription(description_l2, new Locale("L2"));
        }
        if ((description_l3 = (String)((DataToken)hsData.get((Object)"FDescription_l3")).data) != null && description_l3.trim().length() != 0) {
            info.setDescription(description_l3, new Locale("L3"));
        }
        String abbreviation_L1 = (String)((DataToken)hsData.get((Object)"Fabbreviation_l1")).data;
        if (name_l1 != null && name_l1.trim().length() != 0) {
            info.setName(name_l1, new Locale("L1"));
        }
        String abbreviation_L2 = (String)((DataToken)hsData.get((Object)"Fabbreviation_l2")).data;
        if (name_l2 != null && name_l2.trim().length() != 0) {
            info.setName(name_l2, new Locale("L2"));
        }
        String abbreviation_L3 = (String)((DataToken)hsData.get((Object)"Fabbreviation_l3")).data;
        if (name_l3 != null && name_l3.trim().length() != 0) {
            info.setName(name_l3, new Locale("L3"));
        }
        String standardTime_L1 = (String)((DataToken)hsData.get((Object)"FStandardTime_l1")).data;
        if (name_l1 != null && name_l1.trim().length() != 0) {
            info.setName(name_l1, new Locale("L1"));
        }
        String standardTime_L2 = (String)((DataToken)hsData.get((Object)"FStandardTime_l2")).data;
        if (name_l2 != null && name_l2.trim().length() != 0) {
            info.setName(name_l2, new Locale("L2"));
        }
        String standardTime_L3 = (String)((DataToken)hsData.get((Object)"FStandardTime_l3")).data;
        if (name_l3 == null || name_l3.trim().length() == 0) return info;
        info.setName(name_l3, new Locale("L3"));
        return info;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase iTimeZone = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !iTimeZone.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iTimeZone.addnew(coreBaseInfo);
            } else {
                iTimeZone.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("FNumber", rs.getString("number"));
            Locale currentLocale = ctx.getLocale();
            if (rs.getString("name") != null) {
                if (new Locale("L1").equals(currentLocale)) {
                    result.put("FName_l1", rs.getString("name"));
                } else if (new Locale("L2").equals(currentLocale)) {
                    result.put("FName_l2", rs.getString("name"));
                } else if (new Locale("L3").equals(currentLocale)) {
                    result.put("FName_l3", rs.getString("name"));
                }
            }
            if (rs.getString("description") != null) {
                if (new Locale("L1").equals(currentLocale)) {
                    result.put("FDescription_l1", rs.getString("description"));
                } else if (new Locale("L2").equals(currentLocale)) {
                    result.put("FDescription_l2", rs.getString("description"));
                } else if (new Locale("L3").equals(currentLocale)) {
                    result.put("FDescription_l3", rs.getString("description"));
                }
            }
            if (rs.getString("simpleName") != null) {
                if (new Locale("L1").equals(currentLocale)) {
                    result.put("FsimpleName_L1", rs.getString("simpleName"));
                } else if (new Locale("L2").equals(currentLocale)) {
                    result.put("FsimpleName_L2", rs.getString("simpleName"));
                } else if (new Locale("L3").equals(currentLocale)) {
                    result.put("FsimpleName_L3", rs.getString("simpleName"));
                }
            }
            if (rs.getString("standardTime") != null) {
                if (new Locale("L1").equals(currentLocale)) {
                    result.put("FStandardTime_l1", rs.getString("standardTime"));
                } else if (new Locale("L2").equals(currentLocale)) {
                    result.put("FStandardTime_l2", rs.getString("standardTime"));
                } else if (new Locale("L3").equals(currentLocale)) {
                    result.put("FStandardTime_l3", rs.getString("standardTime"));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Locale currentLocale = ctx.getLocale();
            String message = ResourceBase.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"accessError", (Locale)currentLocale);
            throw new TaskExternalException(message, (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.assistant.app.TimeZoneQuery";
    }
}

