/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AssistantException;
import com.kingdee.eas.basedata.assistant.IVoucherAbstract;
import com.kingdee.eas.basedata.assistant.VoucherAbstractCollection;
import com.kingdee.eas.basedata.assistant.VoucherAbstractFactory;
import com.kingdee.eas.basedata.assistant.VoucherAbstractGroupInfo;
import com.kingdee.eas.basedata.assistant.VoucherAbstractInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;

public class VoucherAbstractDataTransmission
extends AbstractDataTransmission {
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return VoucherAbstractFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String description_l3;
        String description_l2;
        String description_l1;
        String name_l3;
        String name_l2;
        String name_l1;
        String groupname_l3;
        VoucherAbstractInfo info = new VoucherAbstractInfo();
        String number = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        if (number == null) throw new TaskExternalException("number not found!");
        info.setNumber(number);
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (mode == 16) {
            try {
                IVoucherAbstract iVoucherAbstract = (IVoucherAbstract)this.getController(ctx);
                VoucherAbstractCollection voucherAbstractCollection = iVoucherAbstract.getVoucherAbstractCollection();
                if (voucherAbstractCollection != null) {
                    for (int i = 0; i < voucherAbstractCollection.size(); ++i) {
                        if (!voucherAbstractCollection.get(i).getNumber().equalsIgnoreCase(number)) continue;
                        info.setId(voucherAbstractCollection.get(i).getId());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TaskExternalException("BOSException: getVoucherAbstractCollection", (Throwable)e);
            }
        }
        String groupNumber = (String)((DataToken)hsData.get((Object)"FGroupNumber")).data;
        String groupname_l2 = (String)((DataToken)hsData.get((Object)"FGroupName_L2")).data;
        if (groupname_l2 != null && groupname_l2.trim().length() != 0) {
            info.setName(groupname_l2, new Locale("L2"));
        }
        if ((groupname_l3 = (String)((DataToken)hsData.get((Object)"FGroupName_L3")).data) != null && groupname_l3.trim().length() != 0) {
            info.setName(groupname_l3, new Locale("L3"));
        }
        String groupParentNumber = (String)((DataToken)hsData.get((Object)"FParentNumber")).data;
        if (groupNumber != null && groupNumber.trim().length() != 0) {
            String groupLongNumber = null;
            groupLongNumber = groupParentNumber != null && groupParentNumber.trim().length() != 0 ? groupParentNumber + "." + groupNumber : groupNumber;
            String sql0 = "SELECT TOP 1 FID FROM t_bd_voucherabstractgroup  WHERE FLongNUMBER=?";
            try {
                IRowSet rst0 = DbUtil.executeQuery((Context)ctx, (String)sql0, (Object[])new Object[]{groupLongNumber.replaceAll("\\.", "!")});
                if (rst0 != null && rst0.next()) {
                    VoucherAbstractGroupInfo temVoucherAbstractGroupInfo = new VoucherAbstractGroupInfo();
                    temVoucherAbstractGroupInfo.setId(BOSUuid.read((String)rst0.getString("FID")));
                    info.setVoucherAbstractGroup(temVoucherAbstractGroupInfo);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (UuidException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (info.getVoucherAbstractGroup() == null) {
                throw new TaskExternalException(new AssistantException(AssistantException.VOUCHER_ABSTRACT_GROUP_NOT_EXISTS, new Object[]{groupNumber}).getMessage());
            }
        }
        if ((name_l1 = (String)((DataToken)hsData.get((Object)"Fname_L1")).data) != null && name_l1.trim().length() != 0) {
            info.setName(name_l1, new Locale("L1"));
        }
        if ((name_l2 = (String)((DataToken)hsData.get((Object)"Fname_L2")).data) != null && name_l2.trim().length() != 0) {
            info.setName(name_l2, new Locale("L2"));
        }
        if ((name_l3 = (String)((DataToken)hsData.get((Object)"Fname_L3")).data) != null && name_l3.trim().length() != 0) {
            info.setName(name_l3, new Locale("L3"));
        }
        if ((description_l1 = (String)((DataToken)hsData.get((Object)"Fdescription_L1")).data) != null && description_l1.trim().length() != 0) {
            info.setDescription(description_l1, new Locale("L1"));
        }
        if ((description_l2 = (String)((DataToken)hsData.get((Object)"Fdescription_L2")).data) != null && description_l2.trim().length() != 0) {
            info.setDescription(description_l2, new Locale("L2"));
        }
        if ((description_l3 = (String)((DataToken)hsData.get((Object)"Fdescription_L3")).data) != null && description_l3.trim().length() != 0) {
            info.setDescription(description_l3, new Locale("L3"));
        }
        info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        info.setAdminCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        return info;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase iVoucherAbstract = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !iVoucherAbstract.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iVoucherAbstract.addnew(coreBaseInfo);
            } else {
                iVoucherAbstract.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("FNumber", rs.getString("number"));
            if (LocaleUtils.getLocale((String)"l2").equals(ctx.getLocale()) && rs.getString("name") != null) {
                result.put("Fname_L2", rs.getString("name"));
            }
            if (LocaleUtils.getLocale((String)"l3").equals(ctx.getLocale()) && rs.getString("name") != null) {
                result.put("Fname_L3", rs.getString("name"));
            }
            if (rs.getString("group.number") != null) {
                result.put("FGroupNumber", rs.getString("group.number"));
            }
            if (rs.getString("parent.longNumber") != null) {
                result.put("FParentNumber", rs.getString("parent.longNumber").replaceAll("!", "."));
            }
            if (LocaleUtils.getLocale((String)"l2").equals(ctx.getLocale()) && rs.getString("group.name") != null) {
                result.put("FGroupName_L2", rs.getString("group.name"));
            }
            if (LocaleUtils.getLocale((String)"l3").equals(ctx.getLocale()) && rs.getString("group.name") != null) {
                result.put("FGroupName_L3", rs.getString("group.name"));
            }
            if (LocaleUtils.getLocale((String)"l2").equals(ctx.getLocale()) && rs.getString("description") != null) {
                result.put("Fdescription_L2", rs.getString("description"));
            }
            if (LocaleUtils.getLocale((String)"l3").equals(ctx.getLocale()) && rs.getString("description") != null) {
                result.put("Fdescription_L3", rs.getString("description"));
            }
        }
        catch (SQLException e) {
            throw new TaskExternalException("Database access error occurs, can't read field values!", (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.assistant.app.VoucherAbstractQuery";
    }

    private boolean getBooleanFromAlias(String isFreeze) {
        return !isFreeze.equals("N");
    }

    private String getAliasFromBooleanValue(boolean value) {
        if (value) {
            return "Y";
        }
        return "N";
    }
}

