/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CORelatedType;
import com.kingdee.eas.basedata.assistant.CostObjectBizException;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectGroupFactory;
import com.kingdee.eas.basedata.assistant.CostObjectGroupInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractCostObjectAndMaterialSynchronousFacadeControllerBean;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class CostObjectAndMaterialSynchronousFacadeControllerBean
extends AbstractCostObjectAndMaterialSynchronousFacadeControllerBean {
    private static final long serialVersionUID = 523323703106066974L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.CostObjectAndMaterialSynchronousFacadeControllerBean");

    @Override
    protected void _matAndCostObjectSynchronousCheck(Context ctx, String companyID) throws BOSException, EASBizException {
        try {
            this.checkNode(ctx, companyID);
            this.checkCostObject(ctx, companyID);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _repairCostObjectByMaterial(Context ctx, String companyID, String parentNodeNumber) throws BOSException, EASBizException {
        try {
            this.repairNode(ctx, companyID);
            this.repairCostObject(ctx, companyID);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkNode(Context ctx, String companyID) throws EASBizException, BOSException {
        if (companyID == null || companyID.length() < 1) {
            return;
        }
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
        String cuID = null;
        if (companyInfo != null && companyInfo.getCU() != null) {
            cuID = companyInfo.getCU().getId().toString();
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" (select matGr.FLongNumber from T_BD_MaterialGroup matGr \n");
        sql.append("                                    inner join T_BD_MaterialGroupStandard groupStandard ");
        sql.append("                                      on matGr.FGroupStandard=groupStandard.FID \n");
        sql.append("                                         and groupStandard.FID ='dR8lnQEPEADgAAWKwKgSxZeb4R8=' \n");
        sql.append("                                         and groupStandard.FSTANDARDTYPE=1 \n");
        sql.append("                      Where not exists (select 1 from T_BD_CostObjectGroup coGr \n");
        sql.append("                                            where matGr.Fid = coGr.FSourceID) \n");
        sql.append("                   ) \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> numberSet = new HashSet<String>();
        StringBuffer where = new StringBuffer();
        try {
            while (rs.next()) {
                String longNumber = rs.getString("FLongNumber");
                String[] numbers = longNumber.split("!");
                for (int i = 0; i < numbers.length; ++i) {
                    if (numberSet.contains(numbers[i])) continue;
                    numberSet.add(numbers[i]);
                    where.append("'" + numbers[i] + "',");
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        if (where.length() < 1) {
            return;
        }
        sql.append(" update T_BD_MaterialGroup set FIsSynochronous = 0 \n");
        sql.append(" where FNumber in (" + where.substring(0, where.length() - 1) + ") \n");
        sql.append("    And (FControlUnitID = '" + cuID + "' or FControlUnitID = '00000000-0000-0000-0000-000000000000CCE7AED4') \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void checkCostObject(Context ctx, String companyID) throws EASBizException, BOSException {
        if (companyID == null || companyID.length() < 1) {
            return;
        }
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
        String cuID = null;
        if (companyInfo != null && companyInfo.getCU() != null) {
            cuID = companyInfo.getCU().getId().toString();
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select FLongNumber from T_BD_MaterialGroup matGr \n");
        sql.append("                      inner join T_BD_MaterialGroupStandard groupStandard ");
        sql.append("                        on matGr.FGroupStandard=groupStandard.FID \n");
        sql.append("                           and groupStandard.FID ='dR8lnQEPEADgAAWKwKgSxZeb4R8=' \n");
        sql.append("                           and groupStandard.FSTANDARDTYPE=1 \n");
        sql.append("                      Where matGr.fid in (select mat.FMaterialGroupID from T_BD_Material mat \n");
        sql.append("                                            where not exists (Select 1 From T_BD_CostObject co  \n");
        sql.append("                                                                      inner join T_BD_CostObjectEntry coe \n");
        sql.append("                                                                         on co.FID = coe.FParentID \n");
        sql.append("                                                                      where coe.FRelatedID = mat.FID \n");
        sql.append("                                                             )");
        sql.append("                                              and mat.FID in (Select FMaterialID From T_BD_MaterialCompanyInfo \n");
        sql.append("                                                                                where FCompanyID = '" + companyID + "' \n");
        sql.append("                                                                                      and FCreateCOByOrder = 0  and FCalculateType = 2 \n");
        sql.append("                                                              )");
        sql.append("                                    ) \n");
        sql.append(" and exists (select 1 from T_BD_Material mat where matGr.Fid = mat.FMaterialGroupID ) \n");
        sql.append(" order by FLongNumber \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> numberSet = new HashSet<String>();
        StringBuffer where = new StringBuffer();
        try {
            while (rs.next()) {
                String longNumber = rs.getString("FLongNumber");
                String[] numbers = longNumber.split("!");
                for (int i = 0; i < numbers.length; ++i) {
                    if (numberSet.contains(numbers[i])) continue;
                    numberSet.add(numbers[i]);
                    where.append("'" + numbers[i] + "',");
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        if (where.length() < 1) {
            return;
        }
        sql.append(" update T_BD_MaterialGroup set FIsSynochronous = 0 \n");
        sql.append(" where FNumber in (" + where.substring(0, where.length() - 1) + ") \n");
        sql.append("    And (FControlUnitID = '" + cuID + "' or FControlUnitID = '00000000-0000-0000-0000-000000000000CCE7AED4') \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update T_BD_Material set FIsSynochronous = 0 \n");
        sql.append("   Where fid in (select mat.FID from T_BD_Material mat \n");
        sql.append("                    where not exists (Select 1 From T_BD_CostObject co  \n");
        sql.append("                                                 inner join T_BD_CostObjectEntry coe \n");
        sql.append("                                                   on co.FID = coe.FParentID \n");
        sql.append("                                       where mat.Fid = coe.FRelatedID \n");
        sql.append("                                      )");
        sql.append("                      and mat.FID in (Select FMaterialID From T_BD_MaterialCompanyInfo ");
        sql.append("                                        where FCompanyID = '" + companyID + "' \n");
        sql.append("                                          and FCreateCOByOrder = 0  and FCalculateType = 2 \n");
        sql.append("                                     )");
        sql.append("                 ) \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void repairNode(Context ctx, String companyID) throws EASBizException, BOSException {
        if (companyID == null || companyID.length() < 1) {
            return;
        }
        UserInfo UserInfo2 = (UserInfo)ctx.get((Object)"UserInfo");
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_BD_CostObjectGroup");
        sql.append("(FID, FSourceId, FControlUnitID, FLastUpdateUserID, FCreatorID, \n");
        sql.append(" FSimpleName, FDESCRIPTION_L1, FDESCRIPTION_L2, FDESCRIPTION_L3, \n");
        sql.append(" FNumber, FNAME_L1, FNAME_L2, FNAME_L3, FRelatedType, \n");
        sql.append(" FDISPLAYNAME_L1, FDISPLAYNAME_L2, FDISPLAYNAME_L3, FLONGNUMBER, \n");
        sql.append(" FLEVEL, FISLEAF, FParentID, FIsUsed ) \n");
        sql.append("select newbosid('CC39AE48') AS FID,  materialGroup.FID AS FSourceId, \n");
        sql.append(" materialGroup.FControlUnitID, \n '");
        sql.append(UserInfo2.getId().toString());
        sql.append("', '");
        sql.append(UserInfo2.getId().toString());
        sql.append("', ");
        sql.append(" materialGroup.FSimpleName, materialGroup.FDESCRIPTION_L1, materialGroup.FDESCRIPTION_L2, materialGroup.FDESCRIPTION_L3, ");
        sql.append(" materialGroup.FNumber, materialGroup.FNAME_L1, materialGroup.FNAME_L2, materialGroup.FNAME_L3, 0,");
        sql.append(" materialGroup.FDISPLAYNAME_L1, materialGroup.FDISPLAYNAME_L2, materialGroup.FDISPLAYNAME_L3, 'PD!'||materialGroup.FLONGNUMBER, ");
        sql.append(" materialGroup.FLEVEL+1, materialGroup.FISLEAF, materialGroup.FParentID, 1 ");
        sql.append("from T_BD_MaterialGroup materialGroup ");
        sql.append("where materialGroup.FIsSynochronous = 0 \n");
        sql.append("                      and not exists (select 1 from T_BD_CostObjectGroup coGr \n");
        sql.append("                                            where materialGroup.Fid = coGr.FSourceID) \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update T_BD_MaterialGroup set FIsSynochronous = 1 \n");
        sql.append(" where FIsSynochronous = 0 \n");
        sql.append("   and exists (select 1 from T_BD_CostObjectGroup coGr \n");
        sql.append("                 where T_BD_MaterialGroup.Fid = coGr.FSourceID) \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void repairCostObject(Context ctx, String companyID) throws EASBizException, BOSException {
        if (companyID == null || companyID.length() < 1) {
            return;
        }
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
        CostObjectFactory.getLocalInstance(ctx).batchAddFromMaterial(companyInfo);
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_BD_Material set FIsSynochronous = 1 \n");
        sql.append("   where FIsSynochronous = 0 ");
        sql.append("   and fid in (select FID from T_BD_Material mat \n");
        sql.append("                    where exists (Select 1 From T_BD_CostObject co  \n");
        sql.append("                                                 inner join T_BD_CostObjectEntry coe \n");
        sql.append("                                                   on co.FID = coe.FParentID \n");
        sql.append("                                   where mat.Fid = coe.FRelatedID  \n)");
        sql.append("                      and mat.FID in (Select FMaterialID From T_BD_MaterialCompanyInfo ");
        sql.append("                                        where FCompanyID = '" + companyID + "' \n");
        sql.append("                                          and FCreateCOByOrder = 0  and FCalculateType = 2 \n");
        sql.append("                                     )");
        sql.append("                 ) \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    public void _addCostObjectGroupByMatTreeNode(Context ctx, MaterialGroupInfo matGrInfo) throws BOSException, EASBizException {
        if (matGrInfo == null) {
            throw new CostObjectBizException(CostObjectBizException.COSTOBJECTNODEEXIST);
        }
        if (!"BaseGroupStandard".equals(matGrInfo.getGroupStandard().getNumber())) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        if (matGrInfo.getParent() == null) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)"PD", CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("sourceid", (Object)matGrInfo.getParent().getId().toString(), CompareType.EQUALS));
        }
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        CostObjectGroupInfo parentCoGrInfo = CostObjectGroupFactory.getLocalInstance(ctx).getCostObjectGroupCollection(ev).get(0);
        CostObjectGroupInfo coGrInfo = new CostObjectGroupInfo();
        coGrInfo.setName(matGrInfo.getName());
        coGrInfo.setNumber(matGrInfo.getNumber());
        coGrInfo.setParent(parentCoGrInfo);
        coGrInfo.setRelatedType(CORelatedType.Product);
        coGrInfo.setSourceId(matGrInfo.getId().toString());
        CostObjectGroupFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)coGrInfo);
    }

    @Override
    public void _deleteCostObjectGroupByMatTreeNode(Context ctx, MaterialGroupInfo matGrInfo) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FID From T_BD_CostObject where FCoGroupID in ( \n");
        sql.append("   select FID From T_BD_CostObjectGroup \n");
        sql.append("   where FsourceID = '" + matGrInfo.getId().toString() + "'");
        sql.append("   )");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs != null && rs.size() > 0) {
            throw new CostObjectBizException(CostObjectBizException.DELETECOSTOBJECTNODEBYMATERIAL);
        }
        sql.setLength(0);
        sql.append("delete From T_BD_CostObjectGroup \n");
        sql.append(" where FsourceID = '" + matGrInfo.getId().toString() + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    public void _moveCostObjectGroupByMatTreeNode(Context ctx, MaterialGroupInfo matGrInfo) throws BOSException, EASBizException {
        FilterInfo parentFilter = new FilterInfo();
        if (matGrInfo.getParent() == null) {
            parentFilter.getFilterItems().add(new FilterItemInfo("number", (Object)"PD", CompareType.EQUALS));
        } else {
            parentFilter.getFilterItems().add(new FilterItemInfo("sourceid", (Object)matGrInfo.getParent().getId().toString(), CompareType.EQUALS));
        }
        EntityViewInfo parentEv = new EntityViewInfo();
        parentEv.setFilter(parentFilter);
        CostObjectGroupInfo parentCoGrInfo = CostObjectGroupFactory.getLocalInstance(ctx).getCostObjectGroupCollection(parentEv).get(0);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceid", (Object)matGrInfo.getId().toString(), CompareType.EQUALS));
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        CostObjectGroupInfo coGrInfo = CostObjectGroupFactory.getLocalInstance(ctx).getCostObjectGroupCollection(ev).get(0);
        if (coGrInfo == null) {
            return;
        }
        coGrInfo.setParent(parentCoGrInfo);
        coGrInfo.setLongNumber(matGrInfo.getLongNumber());
        coGrInfo.setName(matGrInfo.getName());
        coGrInfo.setNumber(matGrInfo.getNumber());
        CostObjectGroupFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(coGrInfo.getId().toString()), (CoreBaseInfo)coGrInfo);
    }

    public void _updateCostObjectGroupByMatTreeNode(Context ctx, MaterialGroupInfo matGrInfo) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BD_CostObjectGroup set Fnumber = " + matGrInfo.getNumber() + "',FLongNumber = '" + matGrInfo.getLongNumber() + "', \n");
        sql.append("                                FName_" + ctx.getLocale() + " = '" + matGrInfo.getName() + "', \n");
        sql.append("                                FGroupStandard = '" + matGrInfo.getGroupStandard().getId().toString() + "' \n");
        sql.append("                                FDescription_" + ctx.getLocale() + " = '" + matGrInfo.getDescription() + "' \n");
        sql.append(" where FsourceID = '" + matGrInfo.getId().toString() + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    public boolean _isModifyCostObjectGroup(Context ctx, CostObjectGroupInfo coGrInfo) throws BOSException, EASBizException {
        if (coGrInfo == null || coGrInfo.getId().toString() == null) {
            return true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FID From T_BD_CostObject where FCostObejctGroupID = '" + coGrInfo.getId().toString() + "' \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs == null || rs.size() <= 0;
    }

    @Override
    public void _updateCostObjectNameAndNumberByMat(Context ctx, MaterialInfo matInfo) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        if (matInfo == null || matInfo.getId() == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_BD_CostObject  set \n");
        sql.append(" FName_" + ctx.getLocale() + " = ? \n");
        sql.append(" where fid in (select fParentID from T_BD_CostObjectEntry entry where entry.FRelatedID = ? ) \n");
        sql.append("   and FCalculateMode = 1 \n");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, matInfo.getName());
            pstmt.setString(2, matInfo.getId().toString());
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException("Sql222 execute exception : " + sql, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        sql.setLength(0);
        sql.append(" update T_BD_CostObject set  FNumber = ? \n");
        sql.append(" where fid in (select fParentID from T_BD_CostObjectEntry entry where entry.FRelatedID = ? ) \n");
        sql.append("   and FCalculateMode = 1\n");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, matInfo.getNumber());
            pstmt.setString(2, matInfo.getId().toString());
            pstmt.execute();
        }
        catch (SQLException e) {
            throw new BOSException("Sql222 execute exception : " + sql, (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
        MaterialGroupInfo matGrInfo = matInfo.getMaterialGroup();
        FilterInfo parentFilter = new FilterInfo();
        if (matGrInfo == null) {
            parentFilter.getFilterItems().add(new FilterItemInfo("number", (Object)"PD", CompareType.EQUALS));
        } else {
            parentFilter.getFilterItems().add(new FilterItemInfo("sourceid", (Object)matGrInfo.getId().toString(), CompareType.EQUALS));
        }
        EntityViewInfo parentEv = new EntityViewInfo();
        parentEv.setFilter(parentFilter);
        CostObjectGroupInfo parentCoGrInfo = CostObjectGroupFactory.getLocalInstance(ctx).getCostObjectGroupCollection(parentEv).get(0);
        if (parentCoGrInfo == null) {
            return;
        }
        sql.setLength(0);
        sql.append(" update T_BD_CostObject  set \n");
        sql.append(" FCoGroupID = '" + parentCoGrInfo.getId().toString() + "' \n");
        sql.append(" where fid in (select fParentID from T_BD_CostObjectEntry entry where entry.FRelatedID = '" + matInfo.getId().toString() + "' ) \n");
        sql.append("   and FCalculateMode <> 3 \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        if (matGrInfo != null && matGrInfo.getId() != null) {
            sql.setLength(0);
            sql.append(" update T_BD_CostObject  set \n");
            sql.append(" FGroupID = '" + matGrInfo.getId().toString() + "' \n");
            sql.append(" where fid in (select fParentID from T_BD_CostObjectEntry entry where entry.FRelatedID = '" + matInfo.getId().toString() + "' ) \n");
            sql.append("   and FCalculateMode <> 3 \n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }
}

