/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectSingleKey;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.core.util.PKUtils;
import com.kingdee.eas.base.core.util.PeriodUtils;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CORelatedType;
import com.kingdee.eas.basedata.assistant.CalculateModeEnum;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectEntryCollection;
import com.kingdee.eas.basedata.assistant.CostObjectEntryInfo;
import com.kingdee.eas.basedata.assistant.CostObjectException;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectGroupFactory;
import com.kingdee.eas.basedata.assistant.CostObjectGroupInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObjectGroup;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.app.AbstractCostObjectControllerBean;
import com.kingdee.eas.basedata.assistant.app.IProjectRef;
import com.kingdee.eas.basedata.master.auxacct.app.AssistUtil;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CostObjectControllerBean
extends AbstractCostObjectControllerBean
implements IProjectRef {
    public static final String NCM_TBL_Balance = "T_NCM_Balance";
    public static final int RELEASED_VALUE = 5;

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CostObjectInfo info = (CostObjectInfo)model;
        this._checkNumberDup(ctx, (IObjectValue)((CostObjectInfo)model));
        super._checkNameBlank(ctx, model);
        this._checkNameDup(ctx, (IObjectValue)info);
        this.checkBatchDup(ctx, (IObjectValue)info);
        this.checkClassMaterial(ctx, info);
        info.setIsForbiden(false);
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CostObjectInfo info = this.getCostObjectInfo(ctx, pk);
        this.checkRefByClassMaterial(ctx, info);
        BOSUuid objID = BOSUuid.read((String)pk.toString());
        BizCheckResult bizCheckResult = BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)objID);
        if (bizCheckResult.isFound()) {
            throw bizCheckResult.getException();
        }
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK costObjectPK = pk;
        CostObjectInfo costObjectInfo = (CostObjectInfo)model;
        this.checkCompanyBlank(ctx, (IObjectValue)costObjectInfo);
        super._checkNumberBlank(ctx, (IObjectValue)costObjectInfo);
        this._checkNumberDup(ctx, (IObjectValue)costObjectInfo);
        super._checkNameBlank(ctx, model);
        this._checkNameDup(ctx, (IObjectValue)costObjectInfo);
        this.checkReferenced(ctx, (IObjectValue)costObjectInfo);
        this.checkBatchDup(ctx, (IObjectValue)costObjectInfo);
        this.checkClassMaterial(ctx, costObjectInfo);
        super._update(ctx, costObjectPK, (IObjectValue)costObjectInfo);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CostObjectInfo costObjectInfo = (CostObjectInfo)model;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)costObjectInfo.getNumber(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("relatedType", (Object)costObjectInfo.getRelatedType().getValue(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)costObjectInfo.getCompany().getId(), CompareType.EQUALS));
        if (costObjectInfo.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)costObjectInfo.getId(), CompareType.NOTEQUALS));
            filterInfo.setMaskString("#0 and #1 and #2 and #3");
        } else {
            filterInfo.setMaskString("#0 and #1 and #2");
        }
        if (this.exists(ctx, filterInfo)) {
            throw new CostObjectException(CostObjectException.CANNOTDUP);
        }
    }

    public static FilterInfo getCheckNumberDupFilter(IObjectValue model, boolean isNeedComp) {
        FilterInfo filter = new FilterInfo();
        if (isNeedComp) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)model.getObjectValue("company").getBOSUuid("id")));
        }
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)model.getString("number")));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getBOSUuid("id"), CompareType.NOTEQUALS));
        return filter;
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CostObjectInfo costObjectInfo = (CostObjectInfo)model;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)costObjectInfo.getName().trim(), CompareType.EQUALS));
        if (costObjectInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)costObjectInfo.getId().toString().trim(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1");
        }
        evi.setFilter(filter);
    }

    private void checkBatchDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CostObjectInfo costObjectInfo = (CostObjectInfo)model;
        if (!CalculateModeEnum.BYBATCH.equals((Object)costObjectInfo.getCalculateMode())) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)costObjectInfo.getCompany().getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("calculateMode", (Object)costObjectInfo.getCalculateMode(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("StdProductID", (Object)costObjectInfo.getEntries().get(0).getRelatedID().toString(), CompareType.EQUALS));
        if (costObjectInfo.getBatchNumber() == null || costObjectInfo.getBatchNumber().trim().length() == 0) {
            filter.getFilterItems().add(new FilterItemInfo("batchNumber", null, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("batchNumber", (Object)costObjectInfo.getBatchNumber(), CompareType.EQUALS));
        }
        if (costObjectInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)costObjectInfo.getId().toString().trim(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new CostObjectException(CostObjectException.BATCHDUP, new Object[]{costObjectInfo.getCompany().getName()});
        }
    }

    protected void checkReferenced(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CostObjectInfo costObjectInfo = (CostObjectInfo)model;
        BOSUuid id = BOSUuid.read((String)costObjectInfo.getId().toString());
        ObjectUuidPK pk = new ObjectUuidPK(id.toString());
        try {
            if (!(costObjectInfo.getCalculateMode() == null || CalculateModeEnum.VARIET.equals((Object)costObjectInfo.getCalculateMode()) || CalculateModeEnum.BYBATCH.equals((Object)costObjectInfo.getCalculateMode()) || CalculateModeEnum.BYCLASS.equals((Object)costObjectInfo.getCalculateMode()))) {
                this._isReferenced(ctx, (IObjectPK)pk);
            }
        }
        catch (ObjectReferedException ex) {
            throw new CostObjectException(CostObjectException.CANNOTUPDATE);
        }
    }

    public void checkCompanyBlank(Context ctx, IObjectValue model) throws BOSException, CostObjectException {
        CostObjectInfo costObjectInfo = (CostObjectInfo)model;
        if (costObjectInfo.getCompany() == null) {
            throw new CostObjectException(CostObjectException.CANNOTBLANK);
        }
    }

    @Override
    protected boolean _checkMaterialUsed(Context ctx, String companyID, String materialNumber, int relateType) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        boolean returnEnd;
        block7: {
            StringBuffer sql = new StringBuffer();
            returnEnd = false;
            con = null;
            ps = null;
            rs = null;
            try {
                con = this.getConnection(ctx);
                if (relateType == 0) {
                    sql.append("select FRelatedName from T_BD_CostObject where FCompanyID = ? and FNumber = ? and FRelatedType = ?");
                    ps = con.prepareStatement(sql.toString());
                    ps.setString(1, companyID);
                    ps.setString(2, materialNumber);
                    ps.setInt(3, relateType);
                }
                if (relateType == 1) {
                    sql.append("select FRelatedName from T_BD_CostObject where FNumber = ? and FRelatedType = ?");
                    ps = con.prepareStatement(sql.toString());
                    ps.setString(1, materialNumber);
                    ps.setInt(2, relateType);
                }
                if ((rs = ps.executeQuery()).next()) {
                    returnEnd = true;
                    rs.close();
                    break block7;
                }
                returnEnd = false;
            }
            catch (SQLException e) {
                try {
                    throw new SQLAccessException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps, (Connection)con);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return returnEnd;
    }

    @Override
    protected void _batchAddFromMaterial(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        UserInfo UserInfo2 = (UserInfo)ctx.get((Object)"UserInfo");
        CtrlUnitInfo DefaultCU = company.getCU();
        StringBuffer copyMaterialTreeSql = new StringBuffer();
        copyMaterialTreeSql.append("insert into T_BD_CostObjectGroup").append("(FID, FSourceId, FControlUnitID, FLastUpdateUserID, FCreatorID, ").append(" FSimpleName, FDESCRIPTION_L1, FDESCRIPTION_L2, FDESCRIPTION_L3, ").append(" FNumber, FNAME_L1, FNAME_L2, FNAME_L3, FRelatedType, ").append(" FDISPLAYNAME_L1, FDISPLAYNAME_L2, FDISPLAYNAME_L3, FLONGNUMBER, ").append(" FLEVEL, FISLEAF, FParentID, FIsUsed )").append("select newbosid('CC39AE48') AS FID,  materialGroup.FID AS FSourceId, ").append(" materialGroup.FControlUnitID, '").append(UserInfo2.getId().toString()).append("', '").append(UserInfo2.getId().toString()).append("', ").append(" materialGroup.FSimpleName, materialGroup.FDESCRIPTION_L1, materialGroup.FDESCRIPTION_L2, materialGroup.FDESCRIPTION_L3, ").append(" materialGroup.FNumber, materialGroup.FNAME_L1, materialGroup.FNAME_L2, materialGroup.FNAME_L3, 0,").append(" materialGroup.FDISPLAYNAME_L1, materialGroup.FDISPLAYNAME_L2, materialGroup.FDISPLAYNAME_L3, 'PD!'||materialGroup.FLONGNUMBER, ").append(" materialGroup.FLEVEL+1, materialGroup.FISLEAF, materialGroup.FParentID, 1 ").append("from T_BD_MaterialGroup materialGroup ,T_BD_MaterialGroupStandard groupStandard ").append("where materialGroup.FNumber not in ").append("(select Fnumber from T_BD_CostObjectGroup ").append(" where FRelatedType=0) ").append("and materialGroup.FGroupStandard=groupStandard.FID ").append("and groupStandard.FID ='dR8lnQEPEADgAAWKwKgSxZeb4R8=' ").append("and groupStandard.FSTANDARDTYPE=1;");
        String tblName = this.createTempTable(ctx, "UpdateTreeParentTemp");
        StringBuffer fillTheTempTblSql = new StringBuffer();
        fillTheTempTblSql.append("insert into ").append(tblName).append("(FID, FParentID) ").append("SELECT b.FID, a.FID FParentID ").append("FROM T_BD_CostObjectGroup a ").append("INNER JOIN T_BD_CostObjectGroup b ").append("ON a.FSourceId = b.FParentID ").append("AND a.FIsUsed = 1 ").append("AND b.FIsUsed = 1 ").append("AND a.FSourceId IS NOT NULL ").append("AND b.FSourceId IS NOT NULL;");
        StringBuffer updateTreeParentSql = new StringBuffer();
        updateTreeParentSql.append("update T_BD_CostObjectGroup ").append("set FParentID = ").append("(select m.FParentID from ").append(tblName).append(" m ").append("where T_BD_CostObjectGroup.FID = m.FID and T_BD_CostObjectGroup.FIsUsed = 1 ").append(") where FIsUsed = 1;");
        StringBuffer updateTreeParentSql1 = new StringBuffer();
        updateTreeParentSql1.append("update T_BD_CostObjectGroup ").append("set FParentID ='").append("qtsXyapZTneI8TxJu+B2Q8w5rkg=").append("' ").append("where T_BD_CostObjectGroup.FIsUsed = 1 and T_BD_CostObjectGroup.FParentID is null ").append(";");
        StringBuffer updataCostObjectGroupSql = new StringBuffer();
        updataCostObjectGroupSql.append("update t_bd_costobject set FCoGroupID=").append("(select  coGroup.FID ").append(" from T_BD_CostObjectGroup coGroup, T_BD_MaterialGroup materialGroup ").append(" where t_bd_costobject.FGroupId=coGroup.FSourceId ").append("  and t_bd_costobject.FGroupId=materialGroup.FID and coGroup.FNumber = materialGroup.FNumber ").append("  and t_bd_costobject.fissys=1 ").append(" ) where fissys=1;");
        StringBuffer setUsedSql = new StringBuffer();
        setUsedSql.append("update T_BD_CostObjectGroup set FIsUsed=0");
        StringBuffer sql1 = new StringBuffer();
        StringBuffer sql2 = new StringBuffer();
        StringBuffer sql3 = new StringBuffer();
        sql1.append("insert into t_bd_costobject").append("(FID,FName_l1,FName_l2,FName_l3,FNumber ,FCompanyID ,FGroupId ,").append("FRelatedID ,FRelatedType ,FCalculateMode ,FIsSys,FStdProductIDID,FControlUnitID,FCreatorID, FCreateTime, FLastUpdateUserID,FLastUpdateTime,FCOGROUPID,FIsForbiden)").append("select  newbosid('39734A77') as fid,material.fname_l1,material.fname_l2,material.fname_l3,material.fnumber,materialcompany.fcompanyid,material.fmaterialgroupid,").append("material.fid,0,case when materialcompany.faccountType = 5 then 4 else 1 end,1,material.fid,'").append(DefaultCU.getId().toString()).append("','").append(UserInfo2.getId().toString()).append("', GetDate() AS FCreateTime, '").append(UserInfo2.getId().toString()).append("', GetDate() AS FLastUpdateTime, '").append("bf0NjwEcEADgABWBwKgTycw5rkg=").append("',0  ").append(" from T_BD_Material as material ,T_BD_MaterialCompanyInfo as materialcompany").append(" where material.fid=materialcompany.FMaterialID and").append(" material.fid not in (select distinct tbce.FRelatedID from t_bd_costobjectentry tbce, t_bd_costobject tbc where tbc.fid=tbce.FParentID  and tbc.FCompanyID='").append(company.getId().toString()).append("' ) and ").append("material.fstatus=1 and materialcompany.fstatus=1 ").append("and materialcompany.FCalculateType=2  and materialcompany.FCompanyID='").append(company.getId().toString()).append("' ");
        sql1.append("and (materialcompany.FCreateCOByOrder is null or materialcompany.FCreateCOByOrder = 0) ");
        sql2.append("insert into t_bd_costobjectentry ").append("(FID,FQuotiety,FParentID,FIsByproduct,FIsMainProduct,FRemark,FSeq,FRelatedID,FRelatedNumber ,FRelatedName)").append("select  newbosid('CC1BC03B') as fid,1.0,costobject.fid,0,1,material.fmodel,1,material.fid,material.fnumber,material.fname_l2").append(" from t_bd_costobject as costobject,t_bd_material as material where ").append("costobject.FStdProductIDID=material.fid and ").append(" costobject.fcompanyid='").append(company.getId().toString()).append("'  and costobject.fissys=1").append("");
        sql3.append("update t_bd_costobject set fissys=0");
        DbUtil.execute((Context)ctx, (String)copyMaterialTreeSql.toString());
        DbUtil.execute((Context)ctx, (String)fillTheTempTblSql.toString());
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tblName);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        DbUtil.execute((Context)ctx, (String)updateTreeParentSql.toString());
        DbUtil.execute((Context)ctx, (String)updateTreeParentSql1.toString());
        DbUtil.execute((Context)ctx, (String)sql1.toString());
        DbUtil.execute((Context)ctx, (String)sql2.toString());
        DbUtil.execute((Context)ctx, (String)updataCostObjectGroupSql.toString());
        DbUtil.execute((Context)ctx, (String)sql3.toString());
        DbUtil.execute((Context)ctx, (String)setUsedSql.toString());
        TempTablePool.getInstance((Context)ctx).releaseTable(tblName);
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection coll = iOUR.getFromUnit(company.getId().toString(), 1, 4);
        if (coll.size() <= 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("    m.FID FMaterialID, mo.FID FOrderID, mo.FNumber FOrderNumber, mo.FLot FLot, \n");
        sql.append("    mo.FProjectID FProjectID, mo.FTrackID FTrackID, mo.FBomID FBomID \n");
        sql.append("from T_BD_Material m \n");
        sql.append("join T_BD_MaterialCompanyInfo mc \n");
        sql.append("    on mc.FMaterialID = m.FID and mc.FCompanyID = '" + company.getId().toString() + "' \n");
        sql.append("join T_MM_ManufactureOrder mo \n");
        sql.append("    on mo.FMaterialID = m.FID and mo.FBaseStatus = 5 \n");
        sql.append("where m.FStatus = 1 and mc.FStatus = 1 \n");
        sql.append("and mc.FCreateCOByOrder = 1 \n");
        sql.append("and mo.FStorageOrgUnitID in ( \n");
        for (int i = 0; i < coll.size(); ++i) {
            sql.append("'" + coll.get(i).getId().toString() + "',");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" \n");
        sql.append(") \n");
        sql.append("and not exists ( \n");
        sql.append("    select 1 from T_BD_CostObject co \n");
        sql.append("    where co.FRelatedID = m.FID \n");
        sql.append("    and co.FOrderID = mo.FID \n");
        sql.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String orgId = null;
        orgId = company.getId().toString();
        orgId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus((IObjectValue)new CostObjectInfo(), orgId);
        PreparedStatement pstmt = null;
        try {
            HashMap<String, String> orderCos = new HashMap<String, String>();
            StringBuffer oql = new StringBuffer();
            while (rs.next()) {
                CostObjectInfo info = new CostObjectInfo();
                String orderNumber = rs.getString("FOrderNumber");
                MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(rs.getString("FMaterialID")));
                info.setCompany(company);
                if (ruleStatus.isExist()) {
                    this._checkNumber(ctx, (IObjectValue)info);
                } else {
                    oql.setLength(0);
                    oql.append("select id, number \n");
                    oql.append("where company.id = '" + info.getCompany().getId().toString() + "'\n");
                    oql.append("and number = '" + orderNumber + "'\n");
                    CostObjectCollection coColl = this.getCostObjectCollection(ctx, oql.toString());
                    if (coColl.size() > 0) {
                        throw new CostObjectException(CostObjectException.NUMBER_USED_OF_ORDER, new Object[]{orderNumber});
                    }
                    info.setNumber(orderNumber);
                }
                Locale l1 = new Locale("l1");
                Locale l2 = new Locale("l2");
                Locale l3 = new Locale("l3");
                info.setName(material.getName(l1), l1);
                info.setName(material.getName(l2), l2);
                info.setName(material.getName(l3), l3);
                info.setSimpleName(material.getSimpleName());
                info.setRelatedType(CORelatedType.Product);
                info.setRelatedId(material.getId());
                info.setStdProductID(material);
                info.setRelatedNumber(material.getNumber());
                info.setRelatedName(material.getName());
                info.setCalculateMode(CalculateModeEnum.BYORDER);
                info.setBatchNumber(rs.getString("FLot"));
                info.setProjectID(rs.getString("FProjectID"));
                info.setTrackID(rs.getString("FTrackID"));
                String bomID = rs.getString("FBomID");
                info.setBomID(bomID);
                info.setCostObjectGroup(CostObjectGroupFactory.getLocalInstance(ctx).getCostObjectGroupInfo((IObjectPK)new ObjectUuidPK("qtsXyapZTneI8TxJu+B2Q8w5rkg=")));
                info.setOrderID(rs.getString("FOrderID"));
                info.setOrderNumber(orderNumber);
                CostObjectEntryInfo entryinfo = new CostObjectEntryInfo();
                entryinfo.setRelatedID(material.getId());
                entryinfo.setRelatedName(material.getName());
                entryinfo.setRelatedNumber(material.getNumber());
                entryinfo.setRemark(material.getModel());
                entryinfo.setIsByproduct(false);
                entryinfo.setIsMainProduct(true);
                entryinfo.setQuotiety(new BigDecimal("1.0"));
                info.getEntries().add(entryinfo);
                IObjectPK pk = this._addnew(ctx, (IObjectValue)info);
                orderCos.put(rs.getString("FOrderID"), pk.toString());
            }
            if (orderCos.size() > 0) {
                conn = EJBFactory.getConnection((Context)ctx);
                String ksql = "update T_MM_ManufactureOrder set FCostObjectID = ? where FID = ?";
                pstmt = conn.prepareStatement(ksql);
                Set set = orderCos.entrySet();
                for (Map.Entry entry : set) {
                    String orderId = (String)entry.getKey();
                    String coId = (String)entry.getValue();
                    pstmt.setString(1, coId);
                    pstmt.setString(2, orderId);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(pstmt, (Connection)conn);
        }
    }

    private String createTempTable(Context ctx, String businessTblName) throws BOSException {
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("CREATE TABLE ");
        createTableSql.append(businessTblName);
        createTableSql.append("\t(");
        createTableSql.append("FID   \t    VARCHAR(44),");
        createTableSql.append("FParentID   \tVARCHAR(44)");
        createTableSql.append(")");
        String tblName = null;
        try {
            tblName = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tblName;
    }

    private void batchAddnewFromMaterial(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        oql.append("SELECT materialId, mateial.number,mateial.model,mateial.materialGroup, mateial.name, mateial.status, status, accountType ").append(" WHERE  FCompanyID = '").append(company.getId().toString()).append("' AND mateial.status = '1' AND status = '1' AND accountType = '5'");
        IMaterialCompanyInfo imci = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx);
        MaterialCompanyInfoCollection mciColl = imci.getMaterialCompanyInfoCollection(oql.toString());
        if (mciColl.size() == 0) {
            throw new IllegalArgumentException("Invalid Bybatch CostObjectInfo:Realted Material is invalid !");
        }
        MaterialCompanyInfoInfo materialComp = null;
        for (int i = 0; i < mciColl.size(); ++i) {
            materialComp = mciColl.get(i);
        }
    }

    protected String _getFullDisplayName(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String fullDisplayName = "";
        CostObjectInfo costObjectInfo = this.getCostObjectInfo(ctx, pk);
        ObjectUuidPK browseGroupPK = new ObjectUuidPK(costObjectInfo.getGroup().getId());
        ICostObjectGroup iCostObjectGroup = CostObjectGroupFactory.getLocalInstance(ctx);
        fullDisplayName = iCostObjectGroup.getFullDisplayName((IObjectPK)browseGroupPK) + "_" + costObjectInfo.getName();
        return fullDisplayName;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        if (selector.contains(new SelectorItemInfo("group.displayName"))) {
            return super._getValue(ctx, pk, selector);
        }
        selector.add(new SelectorItemInfo("group.displayName"));
        return super._getValue(ctx, pk, selector);
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("group.displayName"));
        selector.add(new SelectorItemInfo("entries.RelatedID"));
        return super._getValue(ctx, pk, selector);
    }

    public boolean IsRefrenced(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("relatedId", (Object)pk.toString(), CompareType.EQUALS));
        view.setFilter(filter);
        try {
            CostObjectCollection collection = this.getCostObjectCollection(ctx, view);
            if (collection.size() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public void updateSrcObject(Context ctx, ProjectInfo info) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        CostObjectCollection collection = null;
        if (info.getParent() != null) {
            filter.getFilterItems().add(new FilterItemInfo("relatedId", (Object)info.getParent().getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            collection = this.getCostObjectCollection(ctx, view);
        }
        if (collection == null || collection.size() < 1) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("relatedId", (Object)info.getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            collection = this.getCostObjectCollection(ctx, view);
        }
        if (collection.size() > 0) {
            CostObjectInfo costinfo = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                costinfo = (CostObjectInfo)iterator.next();
                costinfo.setName(info.getName());
                costinfo.setNumber(info.getNumber());
                StringBuffer sql = new StringBuffer();
                sql.append(" update T_BD_CostObject set (FName_").append(ctx.getLocale()).append(",FNumber)=(select '").append(info.getName()).append("' ,'").append(info.getNumber()).append("' from T_BD_CostObject where fid ='").append(costinfo.getId().toString()).append("')").append(" where fid ='").append(costinfo.getId().toString()).append("'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                AssistUtil.updateAssist((Context)ctx, (String)costinfo.getId().toString(), (BOSObjectType)costinfo.getBOSType());
            }
        }
    }

    @Override
    protected int _addnewBybatch(Context ctx, IObjectCollection cos) throws BOSException, EASBizException {
        if (cos == null) {
            throw new IllegalArgumentException("The CostObjectCollection is null !");
        }
        CostObjectInfo coInfo = null;
        boolean exist = false;
        int count = 0;
        int conum = cos.size();
        for (int co = 0; co < conum; ++co) {
            coInfo = (CostObjectInfo)cos.getObject(co);
            exist = this.buildBybatchCostObject(ctx, coInfo);
            if (exist) continue;
            this._addnew(ctx, (IObjectValue)coInfo);
            ++count;
        }
        return count;
    }

    private boolean buildBybatchCostObject(Context ctx, CostObjectInfo co) throws BOSException, EASBizException {
        if (co.getCompany() == null || co.getStdProductID() == null) {
            throw new IllegalArgumentException("Invalid Bybatch CostObjectInfo !");
        }
        CostObjectInfo info = co;
        StringBuffer oql = new StringBuffer();
        oql.append("SELECT \n");
        oql.append("    mateial.Id, mateial.number, mateial.name, mateial.status, \n");
        oql.append("    status, accountType, createCOByOrder \n");
        oql.append("WHERE  mateial.Id = '" + co.getRelatedId().toString() + "' \n");
        oql.append("AND mateial.status = '1' AND status = '1' \n");
        oql.append("AND company.Id = '").append(co.getCompany().getId().toString()).append("' \n");
        IMaterialCompanyInfo imci = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx);
        MaterialCompanyInfoCollection mciColl = imci.getMaterialCompanyInfoCollection(oql.toString());
        if (mciColl.size() == 0) {
            return true;
        }
        if (mciColl.get(0).isCreateCOByOrder() && info.getOrderID() != null) {
            RuleStatus ruleStatus;
            String ksql = "select FNumber, FLot, FProjectID, FTrackID, FBomID from T_MM_ManufactureOrder where FID = '" + co.getOrderID() + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)ksql);
            String orderNumber = null;
            String lot = null;
            String projectID = null;
            String trackID = null;
            String bomID = null;
            try {
                if (rs.next()) {
                    orderNumber = rs.getString("FNumber");
                    lot = rs.getString("FLot");
                    projectID = rs.getString("FProjectID");
                    trackID = rs.getString("FTrackID");
                    bomID = rs.getString("FBomID");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("relatedID", (Object)info.getRelatedId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orderID", (Object)info.getOrderID(), CompareType.EQUALS));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            view.setSelector(selector);
            CostObjectCollection coll = this.getCostObjectCollection(ctx, view);
            if (coll.size() > 0) {
                if (null != orderNumber && !orderNumber.equals(coll.get(0).getNumber())) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("update T_BD_CostObject \n");
                    buffer.append("set FNumber = '" + orderNumber + "' \n");
                    buffer.append("where FID = '" + coll.get(0).getId().toString() + "' \n");
                    DbUtil.execute((Context)ctx, (String)buffer.toString());
                }
                return true;
            }
            MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(info.getStdProductID().getId().toString()));
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            String orgId = null;
            if (info.getCompany() != null) {
                orgId = info.getCompany().getId().toString();
            }
            if (orgId == null) {
                orgId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            }
            if ((ruleStatus = iCodingRuleManager.getRuleStatus((IObjectValue)co, orgId)).isExist()) {
                this._checkNumber(ctx, (IObjectValue)info);
            } else {
                oql.setLength(0);
                oql.append("select id, number \n");
                oql.append("where company.id = '" + info.getCompany().getId().toString() + "'\n");
                oql.append("and number = '" + orderNumber + "'\n");
                CostObjectCollection coColl = this.getCostObjectCollection(ctx, oql.toString());
                if (coColl.size() > 0) {
                    throw new CostObjectException(CostObjectException.NUMBER_USED_OF_ORDER, new Object[]{orderNumber});
                }
                info.setNumber(orderNumber);
            }
            Locale l1 = new Locale("l1");
            Locale l2 = new Locale("l2");
            Locale l3 = new Locale("l3");
            info.setName(material.getName(l1), l1);
            info.setName(material.getName(l2), l2);
            info.setName(material.getName(l3), l3);
            info.setSimpleName(material.getSimpleName());
            info.setRelatedType(CORelatedType.Product);
            info.setRelatedName(material.getName());
            info.setCalculateMode(CalculateModeEnum.BYORDER);
            info.setBatchNumber(lot);
            info.setOrderNumber(orderNumber);
            info.setProjectID(projectID);
            info.setTrackID(trackID);
            info.setBomID(bomID);
            info.setCostObjectGroup(CostObjectGroupFactory.getLocalInstance(ctx).getCostObjectGroupInfo((IObjectPK)new ObjectUuidPK("qtsXyapZTneI8TxJu+B2Q8w5rkg=")));
            CostObjectEntryInfo entryinfo = new CostObjectEntryInfo();
            entryinfo.setRelatedID(material.getId());
            entryinfo.setRelatedName(material.getName());
            entryinfo.setRelatedNumber(material.getNumber());
            entryinfo.setRemark(material.getModel());
            entryinfo.setIsByproduct(false);
            entryinfo.setIsMainProduct(true);
            entryinfo.setQuotiety(new BigDecimal("1.0"));
            info.getEntries().add(entryinfo);
            return false;
        }
        if (mciColl.get(0).getAccountType().equals((Object)AccountType.SPECIAL_ACCT)) {
            String number = mciColl.get(0).getMateial().getNumber();
            String mname = mciColl.get(0).getMateial().getName();
            String lot = info.getBatchNumber();
            String coname = mname;
            if (UIRuleUtil.isNotNull((String)lot)) {
                lot = "-" + lot;
                number = number.concat(lot);
                coname = mname.concat(lot);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("relatedID", (Object)info.getRelatedId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            if (this.exists(ctx, filter)) {
                return true;
            }
            MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(info.getStdProductID().getId().toString()));
            info.setNumber(number);
            info.setName(coname);
            info.setSimpleName(coname);
            info.setRelatedType(CORelatedType.Product);
            info.setRelatedName(mname);
            info.setCalculateMode(CalculateModeEnum.BYBATCH);
            info.setCostObjectGroup(CostObjectGroupFactory.getLocalInstance(ctx).getCostObjectGroupInfo((IObjectPK)new ObjectUuidPK("qtsXyapZTneI8TxJu+B2Q8w5rkg=")));
            info.setOrderID(null);
            CostObjectEntryInfo entryinfo = new CostObjectEntryInfo();
            entryinfo.setRelatedID(material.getId());
            entryinfo.setRelatedName(material.getName());
            entryinfo.setRelatedNumber(material.getNumber());
            entryinfo.setRemark(material.getModel());
            entryinfo.setIsByproduct(false);
            entryinfo.setIsMainProduct(true);
            entryinfo.setQuotiety(new BigDecimal("1.0"));
            info.getEntries().add(entryinfo);
            return false;
        }
        return true;
    }

    @Override
    protected CostObjectInfo _getCostObjectByMaterialLotAndOrder(Context ctx, String companyID, String materialID, String lot, String orderID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT \n");
        sql.append("    mateial.Id, mateial.number, mateial.name, mateial.status, status, accountType, createCOByOrder \n");
        sql.append("WHERE mateial.Id = '" + materialID + "' \n");
        sql.append("AND mateial.status = '1' AND status = '1' \n");
        sql.append("AND company.Id = '").append(companyID).append("' \n");
        MaterialCompanyInfoCollection mciColl = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(sql.toString());
        if (mciColl.size() == 0) {
            return null;
        }
        sql.delete(0, sql.length());
        IRowSet rs = null;
        try {
            if (mciColl.get(0).isCreateCOByOrder()) {
                if (orderID == null || orderID.length() == 0) {
                    return null;
                }
                sql.append("select co.FID,CO.FNUMBER,CO.FNAME_" + ctx.getLocale() + " \n");
                sql.append("from T_BD_CostObject co left join T_BD_CostObjectEntry coe on coe.FparentID = co.Fid \n");
                sql.append("where coe.FRelatedID = ? ");
                sql.append("and co.FOrderID = ? ");
                sql.append("and co.FCompanyID = ? ");
                sql.append("and co.FIsForbiden = 0 \n");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{materialID, orderID, companyID});
                if (rs.next()) {
                    CostObjectInfo co = new CostObjectInfo();
                    co.setId(BOSUuid.read((String)rs.getString(1)));
                    co.setNumber(rs.getString(2));
                    co.setName(rs.getString(3));
                    return co;
                }
                return null;
            }
            if (mciColl.get(0).getAccountType().equals((Object)AccountType.SPECIAL_ACCT)) {
                sql.append("select co.FID,CO.FNUMBER,CO.FNAME_" + ctx.getLocale() + " \n");
                sql.append("from T_BD_CostObject co left join T_BD_CostObjectEntry coe on coe.FparentID = co.Fid \n");
                sql.append("where coe.FRelatedID = ? \n");
                sql.append("and co.FCompanyID = ? \n");
                sql.append("and FCalculateMode = 4 \n");
                sql.append("and co.FIsForbiden = 0 \n");
                if (lot != null && lot.length() > 0) {
                    sql.append("and FBatchNumber = '" + lot + "' \n");
                } else {
                    sql.append("and FBatchNumber is null ");
                }
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{materialID, companyID});
                if (rs.next()) {
                    CostObjectInfo co = new CostObjectInfo();
                    co.setId(BOSUuid.read((String)rs.getString(1)));
                    co.setNumber(rs.getString(2));
                    co.setName(rs.getString(3));
                    return co;
                }
                return null;
            }
            sql.append("select co.FID,CO.FNUMBER,CO.FNAME_" + ctx.getLocale() + " \n");
            sql.append("from T_BD_CostObject co left join T_BD_CostObjectEntry coe on coe.FparentID = co.Fid \n");
            sql.append("where coe.FRelatedID = ? \n");
            sql.append("and co.FCompanyID = ? \n");
            sql.append("and co.FIsForbiden = 0 \n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{materialID, companyID});
            if (rs.next()) {
                CostObjectInfo co = new CostObjectInfo();
                co.setId(BOSUuid.read((String)rs.getString(1)));
                co.setNumber(rs.getString(2));
                co.setName(rs.getString(3));
                return co;
            }
        }
        catch (UuidException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    @Override
    protected Set _deleteAfterOrderUnReleased(Context ctx, Set coIds) throws BOSException, EASBizException {
        HashSet<String> deletedIds = new HashSet<String>();
        if (coIds == null || coIds.size() == 0) {
            return deletedIds;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)coIds, CompareType.INCLUDE));
        HashSet<Integer> calculateModes = new HashSet<Integer>();
        calculateModes.add(7);
        calculateModes.add(4);
        filter.getFilterItems().add(new FilterItemInfo("calculateMode", calculateModes, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("calculateMode");
        selector.add("batchNumber");
        view.setSelector(selector);
        CostObjectCollection coColl = this.getCostObjectCollection(ctx, view);
        for (int i = 0; i < coColl.size(); ++i) {
            String lot;
            CostObjectInfo costObject = coColl.get(i);
            if (costObject.getCalculateMode().equals((Object)CalculateModeEnum.BYORDER)) {
                if (this.checkCostObjectReference(ctx, costObject.getId()) || this.isReferenceByOrder(ctx, costObject.getId().toString())) continue;
                this.delete(ctx, (IObjectPK)new ObjectUuidPK(costObject.getId().toString()));
                deletedIds.add(costObject.getId().toString());
                continue;
            }
            if (!costObject.getCalculateMode().equals((Object)CalculateModeEnum.BYBATCH) || (lot = costObject.getBatchNumber()) == null || lot.trim().length() == 0 || this.checkCostObjectReference(ctx, costObject.getId()) || this.isReferenceByOrder(ctx, costObject.getId().toString())) continue;
            this.delete(ctx, (IObjectPK)new ObjectUuidPK(costObject.getId().toString()));
            deletedIds.add(costObject.getId().toString());
        }
        return deletedIds;
    }

    private boolean isReferenceByOrder(Context ctx, String id) throws BOSException, EASBizException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("select \n");
        ksql.append("    mo.FID FOrderID \n");
        ksql.append("from T_MM_ManufactureOrder mo \n");
        ksql.append("where mo.FCostObjectID = '" + id + "' \n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            return rs.next();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private String buildSqlFromIds(Set ids) {
        StringBuffer idsSql = new StringBuffer();
        if (ids != null && ids.size() > 0) {
            idsSql.append("(");
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                idsSql.append("'" + it.next() + "',");
            }
            idsSql.deleteCharAt(idsSql.length() - 1);
            idsSql.append(")");
        }
        return idsSql.toString();
    }

    @Override
    protected Map _getOrderInfo(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        if (ids == null || ids.size() == 0) {
            return result;
        }
        StringBuffer ksql = new StringBuffer();
        ksql.append("select \n");
        ksql.append("    mo.FID FOrderID, \n");
        ksql.append("    mo.FNumber FOrderNumber, \n");
        ksql.append("    p.FID FProjectID, \n");
        ksql.append("    p.FNumber FProjectNumber, \n");
        ksql.append("    t.FID FTrackID, \n");
        ksql.append("    t.FNumber FTrackNumber, \n");
        ksql.append("    b.FID FBomID, \n");
        ksql.append("    b.FNumber FBomNumber, \n");
        ksql.append("    mo.FRelatingOrderNum FSaleNumber \n");
        ksql.append("from T_MM_ManufactureOrder mo \n");
        ksql.append("left join T_MM_Project p on p.FID = mo.FProjectID \n");
        ksql.append("left join T_MM_TrackNumber t on t.FID = mo.FTrackID \n");
        ksql.append("left join T_MM_Bom b on b.FID = mo.FBomID \n");
        ksql.append("where mo.FID in " + this.buildSqlFromIds(ids) + " \n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            while (rs.next()) {
                HashMap<String, String> item = new HashMap<String, String>();
                String orderID = rs.getString("FOrderID");
                item.put("orderID", orderID);
                item.put("orderNumber", rs.getString("FOrderNumber"));
                item.put("projectID", rs.getString("FProjectID"));
                item.put("projectNumber", rs.getString("FProjectNumber"));
                item.put("trackID", rs.getString("FTrackID"));
                item.put("trackNumber", rs.getString("FTrackNumber"));
                item.put("bomID", rs.getString("FBomID"));
                item.put("bomNumber", rs.getString("FBomNumber"));
                item.put("saleNumber", rs.getString("FSaleNumber"));
                result.put(orderID, item);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    @Override
    protected void _addByMaterial(Context ctx, MaterialCompanyInfoInfo MaterialCompanyInfoInfo2) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        CtrlUnitInfo DefaultCU = null;
        if (MaterialCompanyInfoInfo2.getCompany() != null) {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(MaterialCompanyInfoInfo2.getCompany().getId()));
            DefaultCU = company.getCU();
        }
        MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(MaterialCompanyInfoInfo2.getMateial().getId().toString()));
        if (MaterialCompanyInfoInfo2.getCalculateType().equals((Object)CalculateTypeEnum.SELFMANUFACTURE)) {
            if (MaterialCompanyInfoInfo2.isCreateCOByOrder()) {
                return;
            }
            CostObjectInfo info = new CostObjectInfo();
            CostObjectEntryInfo entryinfo = new CostObjectEntryInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("StdProductID", (Object)material.getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)material.getNumber(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)MaterialCompanyInfoInfo2.getCompany().getId().toString(), CompareType.EQUALS));
            if (!this.exists(ctx, filter)) {
                try {
                    IRowSet rst;
                    if (material.getMaterialGroup() != null && material.getMaterialGroup().getId() != null && !(rst = DbUtil.executeQuery((Context)ctx, (String)" select fid from t_bd_costobjectgroup where fsourceid = ? ", (Object[])new String[]{material.getMaterialGroup().getId().toString()})).next()) {
                        this.addCostObjectGroup(ctx, MaterialCompanyInfoInfo2.getCompany());
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                info.setName(material.getName());
                info.setNumber(material.getNumber());
                info.setGroup(material.getMaterialGroup());
                info.setIsSys(false);
                info.setCU(DefaultCU);
                info.setStdProductID(material);
                info.setRelatedId(material.getId());
                info.setRelatedType(CORelatedType.Product);
                info.setCompany(MaterialCompanyInfoInfo2.getCompany());
                info.setCostObjectGroup(this.getTheCoGroup(ctx, material.getMaterialGroup()));
                if (MaterialCompanyInfoInfo2.getAccountType().equals((Object)AccountType.SPECIAL_ACCT)) {
                    info.setCalculateMode(CalculateModeEnum.BYBATCH);
                } else {
                    info.setCalculateMode(CalculateModeEnum.VARIET);
                }
                entryinfo.setRelatedID(material.getId());
                entryinfo.setRelatedName(material.getName());
                entryinfo.setRelatedNumber(material.getNumber());
                entryinfo.setRemark(material.getModel());
                entryinfo.setIsByproduct(false);
                entryinfo.setIsMainProduct(true);
                entryinfo.setQuotiety(new BigDecimal("1.0"));
                info.getEntries().add(entryinfo);
                if (!this._checkMaterialUsedOrNot(ctx, info)) {
                    this._addnew(ctx, (IObjectValue)info);
                }
            }
        }
    }

    @Override
    protected boolean _checkMaterialUsedOrNot(Context ctx, CostObjectInfo info) throws BOSException, EASBizException {
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("select obj.fid as FID, obj.Fnumber AS Fnumber, obj.Fname_l2 AS Fname, material.FNumber AS FRelatedNumber, material.FName_l2 AS FRelatedName ").append("  from T_BD_CostObject obj, T_BD_CostObjectEntry entry, t_bd_material material ").append(" where obj.FID = entry.FParentID ").append("   and entry.FRelatedID=material.FID ").append("   and obj.FCompanyID = ? ").append("   and obj.FRelatedType=0 ").append("   and obj.FIsForbiden<>1 ").append("   and entry.FRelatedID = ? ");
        if (info.getId() != null) {
            sbSql.append("   and obj.FID<> '").append(info.getId().toString().trim()).append("' ");
        }
        String strSql = sbSql.toString();
        CostObjectEntryCollection entryColl = info.getEntries();
        if (entryColl != null && entryColl.size() > 0) {
            String companyId = info.getCompany().getId().toString();
            CostObjectEntryInfo entryInfo = null;
            String materialId = null;
            IRowSet _Data = null;
            for (int i = 0; i < entryColl.size(); ++i) {
                entryInfo = entryColl.get(i);
                materialId = entryInfo.getRelatedID().toString();
                _Data = DbUtil.executeQuery((Context)ctx, (String)strSql, (Object[])new String[]{companyId, materialId});
                try {
                    if (!_Data.next()) continue;
                    return true;
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return false;
    }

    private CostObjectGroupInfo getTheCoGroup(Context ctx, MaterialGroupInfo info) throws EASBizException, BOSException {
        MaterialGroupInfo parentMGroup;
        CostObjectGroupInfo parentCoGroup = null;
        String oql = "SELECT id, number, name WHERE sourceId='" + info.getId().toString() + "'";
        ICostObjectGroup iCostObjectGroup = CostObjectGroupFactory.getLocalInstance(ctx);
        if (iCostObjectGroup.exists(oql) && (parentCoGroup = iCostObjectGroup.getCostObjectGroupInfo(oql)) != null) {
            CostObjectGroupInfo costObjectGroupInfo = (CostObjectGroupInfo)CostObjectGroupFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(parentCoGroup.getId()));
            return costObjectGroupInfo;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("parent.id"));
        selector.add(new SelectorItemInfo("CU.id"));
        LinkedList<MaterialGroupInfo> mgs = new LinkedList<MaterialGroupInfo>();
        IMaterialGroup iMaterailGroup = MaterialGroupFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(info.getId().toString());
        MaterialGroupInfo sonMGroup = iMaterailGroup.getMaterialGroupInfo((IObjectPK)pk, selector);
        mgs.addFirst(sonMGroup);
        while ((parentMGroup = sonMGroup.getParent()) != null && parentMGroup.getId() != null) {
            oql = "SELECT id, number, name WHERE sourceId='" + parentMGroup.getId().toString() + "'";
            if (iCostObjectGroup.exists(oql)) {
                parentCoGroup = iCostObjectGroup.getCostObjectGroupInfo(oql);
                break;
            }
            pk = new ObjectUuidPK(parentMGroup.getId().toString());
            sonMGroup = iMaterailGroup.getMaterialGroupInfo((IObjectPK)pk, selector);
            mgs.addFirst(sonMGroup);
        }
        if (parentCoGroup == null) {
            parentCoGroup = iCostObjectGroup.getCostObjectGroupInfo((IObjectPK)new ObjectUuidPK("qtsXyapZTneI8TxJu+B2Q8w5rkg="));
        }
        CostObjectGroupInfo sonCoGroup = null;
        for (int i = 0; i < mgs.size(); ++i) {
            sonCoGroup = new CostObjectGroupInfo();
            sonCoGroup.setParent(parentCoGroup);
            sonCoGroup.setRelatedType(parentCoGroup.getRelatedType());
            sonCoGroup.setCalculateMode(parentCoGroup.getCalculateMode());
            sonCoGroup.setNumber(((MaterialGroupInfo)mgs.get(i)).getNumber());
            sonCoGroup.setName(((MaterialGroupInfo)mgs.get(i)).getName());
            sonCoGroup.setSourceId(((MaterialGroupInfo)mgs.get(i)).getId().toString());
            sonCoGroup.setCU(((MaterialGroupInfo)mgs.get(i)).getCU());
            iCostObjectGroup.addnew(sonCoGroup, false);
            parentCoGroup = sonCoGroup;
        }
        if (parentCoGroup != null) {
            CostObjectGroupInfo costObjectGroupInfo = (CostObjectGroupInfo)CostObjectGroupFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(parentCoGroup.getId()));
            return costObjectGroupInfo;
        }
        return parentCoGroup;
    }

    @Override
    protected void _forbid(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.checkBeforeForbid(ctx, pks);
        this.setIsForbidOrNot(ctx, pks, true);
    }

    @Override
    protected void _unForbid(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.checkBeforeUnForbid(ctx, pks);
        this.setIsForbidOrNot(ctx, pks, false);
    }

    private void checkBeforeForbid(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        CostObjectCollection coll = this.getSpetialCOcollection(ctx, pks, Boolean.FALSE);
        if (coll != null && coll.size() > 0) {
            HashMap<String, CostObjectInfo> coMap = new HashMap<String, CostObjectInfo>();
            String companyID = null;
            StringBuffer ids = new StringBuffer();
            ids.append("(");
            for (int i = 0; i < coll.size(); ++i) {
                CostObjectInfo info = coll.get(i);
                if (companyID == null) {
                    companyID = info.getCompany().getId().toString();
                }
                String coId = info.getId().toString();
                ids.append("'").append(coId).append("'");
                if (i != coll.size() - 1) {
                    ids.append(", ");
                }
                coMap.put(coId, info);
            }
            ids.append(")");
            PeriodInfo period = PeriodUtils.GetCurrentPeriod((Context)ctx, companyID);
            this.checkMaterialBeforeForbid(ctx, ids.toString(), companyID, period, coMap);
        }
    }

    private CostObjectCollection getSpetialCOcollection(Context ctx, IObjectPK[] pks, Boolean forbidOrNot) throws BOSException {
        Set idSet = PKUtils.arrayPK2Set((IObjectPK[])pks);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("relatedType", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isForbiden", (Object)forbidOrNot, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.setSelector(this.getSelectors());
        return this.getCostObjectCollection(ctx, evi);
    }

    private void checkBeforeUnForbid(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        CostObjectCollection coll = this.getSpetialCOcollection(ctx, pks, Boolean.TRUE);
        if (coll != null && coll.size() > 0) {
            this.checkMaterialBeforeUnForbid(ctx, coll);
        }
    }

    private void setIsForbidOrNot(Context ctx, IObjectPK[] pks, boolean forbid) throws EASBizException, BOSException {
        if (pks.length <= 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BD_CostObject set FisForbiden=");
        sql.append((forbid ? 1 : 0) + " where FID IN(");
        for (int i = 0; i < pks.length; ++i) {
            sql.append("'" + pks[i] + (i == pks.length - 1 ? "'" : "',"));
        }
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        CostObjectInfo costObectInfo = CostObjectFactory.getLocalInstance(ctx).getCostObjectInfo(pks[0]);
        ORMValueCacheService.getInstance().removeBatch(ctx, costObectInfo.getBOSType(), pks);
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("StdProductID.*"));
        sic.add(new SelectorItemInfo("calculateMode"));
        sic.add(new SelectorItemInfo("relatedType"));
        sic.add(new SelectorItemInfo("isForbiden"));
        sic.add(new SelectorItemInfo("entries.RelatedID"));
        sic.add(new SelectorItemInfo("entries.RelatedNumber"));
        sic.add(new SelectorItemInfo("entries.RelatedName"));
        sic.add(new SelectorItemInfo("entries.*"));
        return sic;
    }

    private void checkMaterialBeforeForbid(Context ctx, String ids, String companyID, PeriodInfo period, Map coMap) throws EASBizException, BOSException {
        if (period == null) {
            return;
        }
        this.checkMaterialExsitInBalance(ctx, ids, companyID, period, coMap);
        this.checkMaterialExsitInManuRecBill(ctx, ids, companyID, period, coMap);
        this.checkCostObjectExsitInitBalanceAdjust(ctx, ids, companyID, period, coMap);
        this.checkCostObjectExsitInOtherFeeBill(ctx, ids, companyID, period, coMap);
        this.checkCostObjectExsitInMaterialReqBill(ctx, ids, companyID, period, coMap);
        this.checkCostObjectExsitInOtherInWarehsBill(ctx, ids, companyID, period, coMap);
        this.checkCostObjectExsitInBoPInvSFPCost(ctx, ids, companyID, period, coMap);
    }

    private void checkMaterialExsitInBalance(Context ctx, String ids, String companyID, PeriodInfo period, Map coMap) throws EASBizException, BOSException {
        IRowSet rs = null;
        int periodFrom = period.getNumber();
        int periodTo = period.getNumber();
        try {
            Class<?> nCMDynamicTableManager = Class.forName("com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager");
            Class[] paramType = new Class[]{Context.class, String.class, String.class, Integer.TYPE, Integer.TYPE};
            Method staticGetTableName = nCMDynamicTableManager.getMethod("getPhysicalTblNameForReport", paramType);
            Object[] paramValue = new Object[]{ctx, companyID, NCM_TBL_Balance, periodFrom, periodTo};
            String tableName = staticGetTableName.invoke(nCMDynamicTableManager, paramValue).toString();
            StringBuffer strSQL = new StringBuffer();
            ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
            if (sysctrol.isStart(1001, companyID)) {
                strSQL.append("select FCostObjectID from ").append(tableName).append(" where FCalculatePeriodID=? ").append("   AND FCompanyOrg=? ").append("   AND FCostObjectID in ").append(ids).append(" \n");
                rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])new Object[]{period.getId().toString(), companyID});
            } else {
                strSQL.append("select FCostObjectID \n");
                strSQL.append("\t\tfrom T_NCM_InitBalance \n");
                strSQL.append("where  \n");
                strSQL.append("\t\tFCompanyOrg = '" + companyID + "' \n");
                strSQL.append("\t\tand FCostObjectID in ").append(ids).append(" \n");
                rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString());
            }
        }
        catch (IllegalAccessException e2) {
            throw new BOSException((Throwable)e2);
        }
        catch (ClassNotFoundException e3) {
            throw new BOSException((Throwable)e3);
        }
        catch (SecurityException e4) {
            throw new BOSException((Throwable)e4);
        }
        catch (NoSuchMethodException e5) {
            throw new BOSException((Throwable)e5);
        }
        catch (IllegalArgumentException e6) {
            throw new BOSException((Throwable)e6);
        }
        catch (InvocationTargetException e7) {
            throw new BOSException((Throwable)e7);
        }
        String costObjectId = null;
        try {
            if (rs != null && rs.next()) {
                costObjectId = rs.getString("FCostObjectID");
            }
        }
        catch (SQLException exc) {
            throw new BOSException("Sql in checkMaterialExsitInBalance execute exception : " + exc);
        }
        if (costObjectId != null) {
            CostObjectInfo info = (CostObjectInfo)coMap.get(costObjectId);
            Object[] param = new Object[]{info.getNumber() + ", " + info.getName()};
            throw new CostObjectException(CostObjectException.CHECKBEFOREFORBID, param);
        }
    }

    private void checkMaterialExsitInManuRecBill(Context ctx, String ids, String companyId, PeriodInfo period, Map coMap) throws EASBizException, BOSException {
        this.checkMatExsitInManuRecBill(ctx, ids, companyId, period, coMap);
        this.checkMatExsitInInputQtyBill(ctx, ids, companyId, period, coMap);
    }

    private void checkMatExsitInManuRecBill(Context ctx, String ids, String companyId, PeriodInfo period, Map coMap) throws BOSException, EASBizException {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("select DISTINCT PARENT.FID AS FID,PARENT.Fnumber AS FNumber, ENTRY.FCostObjectID AS FCostObjectID ").append(" FROM T_IM_ManufactureRecBill AS PARENT ").append(" INNER JOIN T_SCM_TransactionType TRANSTYPE ").append(" ON PARENT.FTransactionTypeID = TRANSTYPE.FID and TRANSTYPE.FIsManuCostCalculate = 1 ").append(" LEFT OUTER JOIN T_IM_ManufactureRecBillEntry AS  ENTRY ").append(" ON  PARENT .FID = ENTRY .FParentID ").append(" INNER JOIN T_BD_Period AS  YEARPERIOD ").append(" ON (( PARENT.FYear = YEARPERIOD.FPeriodYear AND PARENT.FPeriod >= YEARPERIOD.FPeriodNumber) or PARENT.FYear>YEARPERIOD.FPeriodYear )").append(" Where ENTRY.FCompanyOrgUnitID = ? ").append("   AND ENTRY.FCostObjectID in ").append(ids).append("   And YEARPERIOD .FID = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])new Object[]{companyId, period.getId().toString()});
        String FRelatedID = null;
        try {
            if (rs != null && rs.next()) {
                FRelatedID = rs.getString("FCostObjectID");
            }
        }
        catch (SQLException exc) {
            throw new BOSException("Sql in checkMatExsitInManuRecBill execute exception : " + exc);
        }
        if (FRelatedID != null) {
            CostObjectInfo info = (CostObjectInfo)coMap.get(FRelatedID);
            Object[] param = new Object[]{info.getNumber() + ", " + info.getName()};
            throw new CostObjectException(CostObjectException.CHECKBEFOREFORBID, param);
        }
    }

    private void checkMatExsitInInputQtyBill(Context ctx, String ids, String companyId, PeriodInfo period, Map coMap) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select bill.FID AS FID,  bill.Fnumber AS FNumber, entry.FCostObjectID as FCostObjectID ").append("  from T_NCM_InputQtyBill bill ").append(" INNER JOIN T_NCM_InputQtyBillEntry entry ").append("    ON bill.FID = entry.FParentID ").append(" INNER JOIN T_BD_Period AS  RPERIOD ").append("    ON bill.FCalculatePeriod = RPERIOD.FID ").append(" INNER JOIN T_BD_Period AS  COMPARERPERIOD ").append("    ON ((RPERIOD.FPeriodYear=COMPARERPERIOD.FPeriodYear ").append("         AND RPERIOD.FPeriodNumber >= COMPARERPERIOD.FPeriodNumber )").append("        OR RPERIOD.FPeriodYear>COMPARERPERIOD.FPeriodYear) ").append("where bill.FCompanyOrg = ? ").append("  and entry.FCostObjectID in ").append(ids).append("  and COMPARERPERIOD.FID = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{companyId, period.getId().toString()});
        String costObjectId = null;
        try {
            if (rs != null && rs.next()) {
                costObjectId = rs.getString("FCostObjectID");
            }
        }
        catch (SQLException exc) {
            throw new BOSException("Sql in checkMaterialExsitInManuRecBill execute exception : " + exc);
        }
        if (costObjectId != null) {
            CostObjectInfo info = (CostObjectInfo)coMap.get(costObjectId);
            Object[] param = new Object[]{info.getNumber() + ", " + info.getName()};
            throw new CostObjectException(CostObjectException.CHECKBEFOREFORBID, param);
        }
    }

    private void checkCostObjectExsitInitBalanceAdjust(Context ctx, String ids, String companyID, PeriodInfo period, Map coMap) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select tbl.FID,tbl.FNUMBER, tbl.FCostObjectID as FCostObjectID ").append("  from T_NCM_InitBalanceAdjust tbl ").append(" INNER JOIN T_BD_Period AS  RPERIOD ").append("    ON tbl.FCalculatePeriod = RPERIOD.FID ").append(" INNER JOIN T_BD_Period AS  COMPARERPERIOD ").append("    ON ((RPERIOD.FPeriodYear=COMPARERPERIOD.FPeriodYear ").append("         AND RPERIOD.FPeriodNumber >= COMPARERPERIOD.FPeriodNumber )").append("        OR RPERIOD.FPeriodYear>COMPARERPERIOD.FPeriodYear) ").append(" where tbl.FCostObjectID in ").append(ids).append("   and tbl.FCompanyOrg = ? ").append("   and COMPARERPERIOD.Fid = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{companyID, period.getId().toString()});
        String costObjectId = null;
        try {
            if (rs != null && rs.next()) {
                costObjectId = rs.getString("FCostObjectID");
            }
        }
        catch (SQLException exc) {
            throw new BOSException("Sql in checkCostObjectExsitInitBalanceAdjust execute exception : " + exc);
        }
        if (costObjectId != null) {
            CostObjectInfo info = (CostObjectInfo)coMap.get(costObjectId);
            Object[] param = new Object[]{info.getNumber() + ", " + info.getName()};
            throw new CostObjectException(CostObjectException.CHECKBEFOREFORBID, param);
        }
    }

    private void checkCostObjectExsitInOtherFeeBill(Context ctx, String ids, String companyID, PeriodInfo period, Map coMap) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select bill.FID,bill.FNUMBER, entry.FCostObjectID as FCostObjectID ").append("  from T_NCM_OtherFeeBill bill ").append(" INNER JOIN T_NCM_OtherFeeBillEntry entry ").append("    on bill.FID = entry.FParentID ").append(" INNER JOIN T_BD_Period AS  RPERIOD ").append("    ON bill.FCalculatePeriod = RPERIOD.FID ").append(" INNER JOIN T_BD_Period AS  COMPARERPERIOD ").append("    ON ((RPERIOD.FPeriodYear=COMPARERPERIOD.FPeriodYear ").append("         AND RPERIOD.FPeriodNumber >= COMPARERPERIOD.FPeriodNumber )").append("        OR RPERIOD.FPeriodYear>COMPARERPERIOD.FPeriodYear) ").append(" where entry.FCostObjectID in ").append(ids).append("   and bill.FCompanyOrg = ? ").append("   and COMPARERPERIOD.Fid = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{companyID, period.getId().toString()});
        String costObjectId = null;
        try {
            if (rs != null && rs.next()) {
                costObjectId = rs.getString("FCostObjectID");
            }
        }
        catch (SQLException exc) {
            throw new BOSException("Sql in checkCostObjectExsitInOtherFeeBill execute exception : " + exc);
        }
        if (costObjectId != null) {
            CostObjectInfo info = (CostObjectInfo)coMap.get(costObjectId);
            Object[] param = new Object[]{info.getNumber() + ", " + info.getName()};
            throw new CostObjectException(CostObjectException.CHECKBEFOREFORBID, param);
        }
    }

    private void checkCostObjectExsitInMaterialReqBill(Context ctx, String ids, String companyID, PeriodInfo period, Map coMap) throws EASBizException, BOSException {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("select DISTINCT PARENT.FID AS FID,PARENT.Fnumber AS FNumber, ENTRY.FCostObjectID as FCostObjectID ").append(" FROM T_IM_MaterialReqBill AS PARENT ").append(" INNER JOIN T_SCM_TransactionType TRANSTYPE ").append(" ON PARENT.FTransactionTypeID = TRANSTYPE.FID and TRANSTYPE.FIsManuCostCalculate = 1 ").append(" LEFT OUTER JOIN T_IM_MaterialReqBillEntry AS  ENTRY ").append(" ON  PARENT.FID = ENTRY.FParentID ").append(" INNER JOIN T_BD_Period AS  YEARPERIOD ").append(" ON (( PARENT.FYear = YEARPERIOD.FPeriodYear AND PARENT.FPeriod >= YEARPERIOD.FPeriodNumber) or PARENT.FYear>YEARPERIOD.FPeriodYear )").append(" Where ENTRY.FCompanyOrgUnitID = ? ").append("   AND ENTRY.FCostObjectID in ").append(ids).append("   And YEARPERIOD.FID = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])new Object[]{companyID, period.getId().toString()});
        String costObjectId = null;
        try {
            if (rs != null && rs.next()) {
                costObjectId = rs.getString("FCostObjectID");
            }
        }
        catch (SQLException exc) {
            throw new BOSException("Sql in checkCostObjectExsitInMaterialReqBill execute exception : " + exc);
        }
        if (costObjectId != null) {
            CostObjectInfo info = (CostObjectInfo)coMap.get(costObjectId);
            Object[] param = new Object[]{info.getNumber() + ", " + info.getName()};
            throw new CostObjectException(CostObjectException.CHECKBEFOREFORBID, param);
        }
    }

    private void checkCostObjectExsitInOtherInWarehsBill(Context ctx, String ids, String companyID, PeriodInfo period, Map coMap) throws EASBizException, BOSException {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("select DISTINCT PARENT.FID AS FID,PARENT.Fnumber AS FNumber, ENTRY.FCostObjectID as FCostObjectID ").append(" FROM T_IM_OtherInWarehsBill AS PARENT ").append(" INNER JOIN T_SCM_TransactionType TRANSTYPE ").append(" ON PARENT.FTransactionTypeID = TRANSTYPE.FID and TRANSTYPE.FIsManuCostCalculate = 1 ").append(" LEFT OUTER JOIN T_IM_OtherInWarehsBillEntry AS  ENTRY ").append(" ON  PARENT.FID = ENTRY.FParentID ").append(" INNER JOIN T_BD_Period AS  YEARPERIOD ").append(" ON (( PARENT.FYear = YEARPERIOD.FPeriodYear AND PARENT.FPeriod >= YEARPERIOD.FPeriodNumber) or PARENT.FYear>YEARPERIOD.FPeriodYear )").append(" Where ENTRY.FCompanyOrgUnitID = ? ").append("   AND ENTRY.FCostObjectID in ").append(ids).append("   And YEARPERIOD.FID = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])new Object[]{companyID, period.getId().toString()});
        String costObjectId = null;
        try {
            if (rs != null && rs.next()) {
                costObjectId = rs.getString("FCostObjectID");
            }
        }
        catch (SQLException exc) {
            throw new BOSException("Sql in checkCostObjectExsitInOtherInWarehsBill execute exception : " + exc);
        }
        if (costObjectId != null) {
            CostObjectInfo info = (CostObjectInfo)coMap.get(costObjectId);
            Object[] param = new Object[]{info.getNumber() + ", " + info.getName()};
            throw new CostObjectException(CostObjectException.CHECKBEFOREFORBID, param);
        }
    }

    private void checkCostObjectExsitInBoPInvSFPCost(Context ctx, String ids, String companyID, PeriodInfo period, Map coMap) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select tbl.FID,tbl.FNUMBER , tbl.FCostObjectID as FCostObjectID ").append("  from T_NCM_BoPInvSFPCost tbl ").append(" INNER JOIN T_BD_Period AS  RPERIOD ").append("    ON tbl.FCalculatePeriod = RPERIOD.FID ").append(" INNER JOIN T_BD_Period AS  COMPARERPERIOD ").append("    ON ((RPERIOD.FPeriodYear=COMPARERPERIOD.FPeriodYear ").append("         AND RPERIOD.FPeriodNumber >= COMPARERPERIOD.FPeriodNumber )").append("        OR RPERIOD.FPeriodYear>COMPARERPERIOD.FPeriodYear) ").append(" where tbl.FCostObjectID in ").append(ids).append("   and tbl.FCompanyOrg = ? ").append("   and COMPARERPERIOD.Fid = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{companyID, period.getId().toString()});
        String costObjectId = null;
        try {
            if (rs != null && rs.next()) {
                costObjectId = rs.getString("FCostObjectID");
            }
        }
        catch (SQLException exc) {
            throw new BOSException("Sql in checkCostObjectExsitInBoPInvSFPCost execute exception : " + exc);
        }
        if (costObjectId != null) {
            CostObjectInfo info = (CostObjectInfo)coMap.get(costObjectId);
            Object[] param = new Object[]{info.getNumber() + ", " + info.getName()};
            throw new CostObjectException(CostObjectException.CHECKBEFOREFORBID, param);
        }
    }

    private void checkMaterialBeforeUnForbid(Context ctx, CostObjectCollection coll) throws EASBizException, BOSException {
        String[] checkResult = this.getTheMaterialCheckResult(ctx, coll);
        if (checkResult != null && checkResult.length > 0) {
            Object[] param = new Object[]{checkResult[4] + ", " + checkResult[5], checkResult[2] + ", " + checkResult[3], checkResult[0] + ", " + checkResult[1]};
            throw new CostObjectException(CostObjectException.CHECKBEFOREUNFORBID, param);
        }
    }

    private void checkClassMaterial(Context ctx, CostObjectInfo info) throws EASBizException, BOSException {
        if (info == null || info.getRelatedType() == null || !CORelatedType.Product.equals((Object)info.getRelatedType()) || info.getCalculateMode() != null && !CalculateModeEnum.BYCLASS.equals((Object)info.getCalculateMode())) {
            return;
        }
        CostObjectCollection coll = new CostObjectCollection();
        coll.add(info);
        String[] checkResult = this.getTheMaterialCheckResult(ctx, coll);
        if (checkResult != null && checkResult.length > 0) {
            Object[] param = new Object[]{checkResult[2] + ", " + checkResult[3], checkResult[0] + ", " + checkResult[1]};
            throw new CostObjectException(CostObjectException.USEEDINOTHERCALMODE, param);
        }
    }

    private void checkRefByClassMaterial(Context ctx, CostObjectInfo info) throws EASBizException, BOSException {
        if (info == null || info.getRelatedType() == null || !CORelatedType.Product.equals((Object)info.getRelatedType()) || info.getCalculateMode() != null && !CalculateModeEnum.VARIET.equals((Object)info.getCalculateMode())) {
            return;
        }
        CostObjectCollection coll = new CostObjectCollection();
        coll.add(info);
        String[] checkResult = this.getTheMaterialCheckResult(ctx, coll);
        if (checkResult != null && checkResult.length > 0) {
            Object[] param = new Object[]{checkResult[2] + ", " + checkResult[3], checkResult[0] + ", " + checkResult[1]};
            throw new CostObjectException(CostObjectException.CANNOT_DEL_REF_BY_CLASS, param);
        }
    }

    private String[] getTheMaterialCheckResult(Context ctx, CostObjectCollection coll) throws BOSException, EASBizException {
        ArrayList<CostObjectInfo> varietObjList = null;
        ArrayList<CostObjectInfo> classObjList = null;
        ArrayList<CostObjectInfo> byBatchObjList = null;
        String companyId = null;
        for (int i = 0; i < coll.size(); ++i) {
            CostObjectInfo info = coll.get(i);
            if (companyId == null) {
                companyId = info.getCompany().getId().toString();
            }
            if (CalculateModeEnum.VARIET.equals((Object)info.getCalculateMode())) {
                if (varietObjList == null) {
                    varietObjList = new ArrayList<CostObjectInfo>();
                }
                varietObjList.add(info);
                continue;
            }
            if (CalculateModeEnum.BYCLASS.equals((Object)info.getCalculateMode())) {
                if (classObjList == null) {
                    classObjList = new ArrayList<CostObjectInfo>();
                }
                classObjList.add(info);
                continue;
            }
            if (!CalculateModeEnum.BYBATCH.equals((Object)info.getCalculateMode())) continue;
            if (byBatchObjList == null) {
                byBatchObjList = new ArrayList<CostObjectInfo>();
            }
            byBatchObjList.add(info);
        }
        if (varietObjList != null && varietObjList.size() > 0) {
            return this.checkMaterialInVarietObj(ctx, varietObjList, companyId);
        }
        if (classObjList != null && classObjList.size() > 0) {
            return this.checkMaterialInByClassObj(ctx, classObjList, companyId);
        }
        if (byBatchObjList != null && byBatchObjList.size() > 0) {
            return this.checkMaterialInBybatchObj(ctx, byBatchObjList, companyId);
        }
        return null;
    }

    private String[] checkMaterialInVarietObj(Context ctx, List varietObjList, String companyId) throws BOSException, EASBizException {
        HashMap coRelatedMap = new HashMap();
        String sql = this.getMaterialCommonCheckSql(ctx, varietObjList, coRelatedMap).toString();
        if (coRelatedMap.size() <= 0) {
            return null;
        }
        IRowSet _Data = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{companyId});
        try {
            if (_Data.next()) {
                String originalNumber = "";
                String originalName = "";
                if (coRelatedMap != null && coRelatedMap.size() > 0) {
                    String relatedId = _Data.getString("FRelatedId");
                    List coMesg = (List)coRelatedMap.get(relatedId);
                    originalNumber = (String)coMesg.get(0);
                    originalName = (String)coMesg.get(1);
                }
                return new String[]{_Data.getString("Fnumber"), _Data.getString("Fname"), _Data.getString("FRelatedNumber"), _Data.getString("FRelatedName"), originalNumber, originalName};
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private StringBuffer getMaterialCommonCheckSql(Context ctx, List list, Map coRelatedMap) throws BOSException, EASBizException {
        ArrayList<String> idList = null;
        ArrayList<String> relatedIdList = null;
        for (int i = 0; i < list.size(); ++i) {
            CostObjectInfo info = (CostObjectInfo)list.get(i);
            if (info.getId() != null) {
                if (idList == null) {
                    idList = new ArrayList<String>();
                }
                idList.add(info.getId().toString());
            }
            if (info.getEntries() == null || info.getEntries().size() <= 0) continue;
            ArrayList<String> coMesg = new ArrayList<String>();
            coMesg.add(info.getNumber());
            coMesg.add(info.getName());
            CostObjectEntryCollection entryColl = info.getEntries();
            CostObjectEntryInfo entryInfo = null;
            for (int j = 0; j < entryColl.size(); ++j) {
                entryInfo = entryColl.get(j);
                if (entryInfo.getRelatedID() == null) continue;
                if (relatedIdList == null) {
                    relatedIdList = new ArrayList<String>();
                }
                String relatedId = entryInfo.getRelatedID().toString();
                relatedIdList.add(relatedId);
                coRelatedMap.put(relatedId, coMesg);
            }
        }
        if (relatedIdList == null || relatedIdList.size() <= 0) {
            return null;
        }
        return this.getMaterialCommonCheckSql(idList, relatedIdList);
    }

    private StringBuffer getMaterialCommonCheckSql(List idList, List relatedIdList) {
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("select obj.fid as FID, obj.Fnumber AS Fnumber, obj.Fname_l2 AS Fname, material.Fid AS FRelatedId,material.FNumber AS FRelatedNumber, material.FName_l2 AS FRelatedName ").append("  from T_BD_CostObject obj, T_BD_CostObjectEntry entry, t_bd_material material ").append(" where obj.FID = entry.FParentID ").append("   and entry.FRelatedID=material.FID ").append("   and obj.FCompanyID = ? ").append("   and obj.FRelatedType=0 ").append("   and obj.FIsForbiden<>1 ");
        if (idList != null && idList.size() > 0) {
            sbSql.append("   and obj.FID not in(").append(this.getParamForSqlIn(idList)).append(")");
        }
        if (relatedIdList != null && relatedIdList.size() > 0) {
            sbSql.append("   and entry.FRelatedID in(").append(this.getParamForSqlIn(relatedIdList)).append(")");
        }
        return sbSql;
    }

    private String getParamForSqlIn(List list) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            sb.append("'").append(list.get(i).toString()).append("'");
            if (i == list.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private String[] checkMaterialInByClassObj(Context ctx, List classObjList, String companyId) throws BOSException, EASBizException {
        HashMap coRelatedMap = new HashMap();
        StringBuffer sb = this.getMaterialCommonCheckSql(ctx, classObjList, coRelatedMap);
        if (coRelatedMap.size() <= 0) {
            return null;
        }
        sb.append("   and (obj.FCalculateMode=").append(4).append(" or obj.FCalculateMode=").append(3).append(")");
        IRowSet _Data = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new String[]{companyId});
        try {
            if (_Data.next()) {
                String originalNumber = "";
                String originalName = "";
                if (coRelatedMap != null && coRelatedMap.size() > 0) {
                    String relatedId = _Data.getString("FRelatedId");
                    List coMesg = (List)coRelatedMap.get(relatedId);
                    originalNumber = (String)coMesg.get(0);
                    originalName = (String)coMesg.get(1);
                }
                return new String[]{_Data.getString("Fnumber"), _Data.getString("Fname"), _Data.getString("FRelatedNumber"), _Data.getString("FRelatedName"), originalNumber, originalName};
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        this.forbidTheVarietObj(ctx, classObjList, companyId);
        return null;
    }

    private StringBuffer getMaterialInbyBatchCheckSql(StringBuffer sbParam) {
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("select obj.fid as FID, obj.Fnumber AS Fnumber, obj.Fname_l2 AS Fname, material.Fid AS FRelatedId,material.FNumber AS FRelatedNumber, material.FName_l2 AS FRelatedName ").append("  from T_BD_CostObject obj, T_BD_CostObjectEntry entry, t_bd_material material ").append(" where obj.FID = entry.FParentID ").append("   and entry.FRelatedID=material.FID ").append("   and obj.FCompanyID = ? ").append("   and obj.FRelatedType=0 ").append("   and obj.FIsForbiden<>1 ").append(sbParam);
        return sbSql;
    }

    private String[] checkMatInBatchObjFirst(Context ctx, List byBatchObjList, String companyId) throws BOSException {
        StringBuffer sbParam = new StringBuffer();
        HashMap coRelatedMap = null;
        for (int i = 0; i < byBatchObjList.size(); ++i) {
            CostObjectInfo info = (CostObjectInfo)byBatchObjList.get(i);
            if (info.getEntries() == null || info.getEntries().size() <= 0) continue;
            if (sbParam.length() == 0) {
                sbParam.append("and (");
            } else {
                sbParam.append(" or ");
            }
            sbParam.append(" (");
            if (info.getId() != null) {
                sbParam.append(" obj.FID<> '").append(info.getId().toString()).append("' and ");
            }
            sbParam.append("  obj.FBatchNumber='").append(info.getBatchNumber()).append("'  and entry.FRelatedID in(");
            ArrayList<String> coMesg = new ArrayList<String>();
            coMesg.add(info.getNumber());
            coMesg.add(info.getName());
            CostObjectEntryCollection entryColl = info.getEntries();
            CostObjectEntryInfo entryInfo = null;
            for (int j = 0; j < entryColl.size(); ++j) {
                entryInfo = entryColl.get(j);
                if (entryInfo == null || entryInfo.getRelatedID() == null) continue;
                String relatedId = entryInfo.getRelatedID().toString();
                sbParam.append("'").append(relatedId).append("'");
                if (j != entryColl.size() - 1) {
                    sbParam.append(",");
                }
                if (coRelatedMap == null) {
                    coRelatedMap = new HashMap();
                }
                coRelatedMap.put(relatedId, coMesg);
            }
            sbParam.append(")) ");
        }
        sbParam.append(")");
        if (sbParam.length() == 0) {
            return null;
        }
        StringBuffer sqlCheckBatch = this.getMaterialInbyBatchCheckSql(sbParam);
        sqlCheckBatch.append("   and obj.FCalculateMode=").append(4);
        IRowSet _Data = DbUtil.executeQuery((Context)ctx, (String)sqlCheckBatch.toString(), (Object[])new String[]{companyId});
        try {
            if (_Data.next()) {
                String originalNumber = "";
                String originalName = "";
                if (coRelatedMap != null && coRelatedMap.size() > 0) {
                    String relatedId = _Data.getString("FRelatedId");
                    List coMesg = (List)coRelatedMap.get(relatedId);
                    originalNumber = (String)coMesg.get(0);
                    originalName = (String)coMesg.get(1);
                }
                return new String[]{_Data.getString("Fnumber"), _Data.getString("Fname"), _Data.getString("FRelatedNumber"), _Data.getString("FRelatedName"), originalNumber, originalName};
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private String[] checkMatInBatchObjSecond(Context ctx, List byBatchObjList, String companyId) throws BOSException {
        StringBuffer sbParam = new StringBuffer();
        HashMap coRelatedMap = null;
        for (int i = 0; i < byBatchObjList.size(); ++i) {
            CostObjectInfo info = (CostObjectInfo)byBatchObjList.get(i);
            if (info.getEntries() == null || info.getEntries().size() <= 0) continue;
            if (sbParam.length() == 0) {
                sbParam.append("and (");
            } else {
                sbParam.append(" or ");
            }
            sbParam.append(" (");
            if (info.getId() != null) {
                sbParam.append(" obj.FID<> '").append(info.getId().toString()).append("' and ");
            }
            sbParam.append(" entry.FRelatedID in(");
            ArrayList<String> coMesg = new ArrayList<String>();
            coMesg.add(info.getNumber());
            coMesg.add(info.getName());
            CostObjectEntryCollection entryColl = info.getEntries();
            CostObjectEntryInfo entryInfo = null;
            for (int j = 0; j < entryColl.size(); ++j) {
                entryInfo = entryColl.get(j);
                if (entryInfo == null || entryInfo.getRelatedID() == null) continue;
                String relatedId = entryInfo.getRelatedID().toString();
                sbParam.append("'").append(relatedId).append("'");
                if (j != entryColl.size() - 1) {
                    sbParam.append(",");
                }
                if (coRelatedMap == null) {
                    coRelatedMap = new HashMap();
                }
                coRelatedMap.put(relatedId, coMesg);
            }
            sbParam.append(")) ");
        }
        sbParam.append(")");
        if (sbParam.length() == 0) {
            return null;
        }
        StringBuffer sqlCheckClass = this.getMaterialInbyBatchCheckSql(sbParam);
        sqlCheckClass.append("   and obj.FCalculateMode=").append(3);
        IRowSet _Data = DbUtil.executeQuery((Context)ctx, (String)sqlCheckClass.toString(), (Object[])new String[]{companyId});
        try {
            if (_Data.next()) {
                String originalNumber = "";
                String originalName = "";
                if (coRelatedMap != null && coRelatedMap.size() > 0) {
                    String relatedId = _Data.getString("FRelatedId");
                    List coMesg = (List)coRelatedMap.get(relatedId);
                    originalNumber = (String)coMesg.get(0);
                    originalName = (String)coMesg.get(1);
                }
                return new String[]{_Data.getString("Fnumber"), _Data.getString("Fname"), _Data.getString("FRelatedNumber"), _Data.getString("FRelatedName"), originalNumber, originalName};
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private String[] checkMaterialInBybatchObj(Context ctx, List byBatchObjList, String companyId) throws BOSException, EASBizException {
        String[] checkFist = this.checkMatInBatchObjFirst(ctx, byBatchObjList, companyId);
        if (checkFist != null && checkFist.length > 0) {
            return checkFist;
        }
        String[] checkSecond = this.checkMatInBatchObjSecond(ctx, byBatchObjList, companyId);
        if (checkSecond != null && checkSecond.length > 0) {
            return checkSecond;
        }
        this.forbidTheVarietObj(ctx, byBatchObjList, companyId);
        return null;
    }

    private StringBuffer getCommonCheckSql(CostObjectInfo info) {
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("select obj.fid as FID, obj.Fnumber AS Fnumber, obj.Fname_l2 AS Fname, material.FNumber AS FRelatedNumber, material.FName_l2 AS FRelatedName ").append("  from T_BD_CostObject obj, T_BD_CostObjectEntry entry, t_bd_material material ").append(" where obj.FID = entry.FParentID ").append("   and entry.FRelatedID=material.FID ").append("   and obj.FCompanyID = ? ").append("   and obj.FRelatedType=0 ").append("   and obj.FIsForbiden<>1 ").append("   and entry.FRelatedID = ? ");
        if (info.getId() != null) {
            sbSql.append("   and obj.FID<> '").append(info.getId().toString().trim()).append("' ");
        }
        return sbSql;
    }

    private void forbidTheVarietObj(Context ctx, List classObjList, String companyId) throws BOSException, EASBizException {
        HashMap coRelatedMap = new HashMap();
        StringBuffer sb = this.getMaterialCommonCheckSql(ctx, classObjList, coRelatedMap);
        if (coRelatedMap == null || coRelatedMap.size() <= 0) {
            return;
        }
        sb.append("   and obj.FCalculateMode=").append(1);
        IRowSet _Data = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new String[]{companyId});
        if (_Data != null && _Data.size() > 0) {
            try {
                ObjectSingleKey[] pks = new ObjectSingleKey[_Data.size()];
                int i = 0;
                _Data.first();
                while (_Data.getRow() > 0 && !_Data.isAfterLast()) {
                    if (_Data.getString("FID") != null && !"".equals(_Data.getString("FID"))) {
                        pks[i] = new ObjectUuidPK(_Data.getString("FID"));
                        ++i;
                    }
                    _Data.next();
                }
                if (i > 0) {
                    this._forbid(ctx, (IObjectPK[])pks);
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    protected CostObjectInfo _getCostObjectByMaterial(Context ctx, String materialID, String companyID) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("select co.FID,CO.FNUMBER,CO.FNAME_" + ctx.getLocale()).append(" from T_BD_CostObject co left join T_BD_CostObjectEntry coe on coe.FparentID = co.Fid ").append(" where coe.FRelatedID = ?").append("\tand co.FCompanyID = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new String[]{materialID, companyID});
        try {
            if (rs.next()) {
                CostObjectInfo co = new CostObjectInfo();
                co.setId(BOSUuid.read((String)rs.getString(1)));
                co.setNumber(rs.getString(2));
                co.setName(rs.getString(3));
                return co;
            }
        }
        catch (UuidException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    @Override
    protected boolean _checkMaterialUsed(Context ctx, MaterialCompanyInfoInfo materialCompanyInfo) throws BOSException, EASBizException {
        if (CalculateTypeEnum.SELFMANUFACTURE.equals((Object)materialCompanyInfo.getCalculateType())) {
            CostObjectCollection costColl = this._getCostObjectColByMaterial(ctx, materialCompanyInfo.getMateial().getId().toString(), materialCompanyInfo.getCompany().getId().toString(), 5);
            int count = costColl.size();
            for (int i = 0; i < count; ++i) {
                CostObjectInfo costObjectInfo = costColl.get(i);
                if (!this.isByProUnitCostReference(ctx, costObjectInfo.getId())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean _checkAndDelObjByMaterial(Context ctx, MaterialCompanyInfoInfo updateInfo, MaterialCompanyInfoInfo oldInfo) throws BOSException, EASBizException {
        if (CalculateTypeEnum.SELFMANUFACTURE.equals((Object)oldInfo.getCalculateType()) && oldInfo.getAccountType().getValue() != updateInfo.getAccountType().getValue() && AccountType.SPECIAL_ACCT.equals((Object)updateInfo.getAccountType())) {
            CostObjectInfo costObjectInfo;
            int i;
            CostObjectCollection costColl = this._getCostObjectColByMaterial(ctx, oldInfo.getMateial().getId().toString(), oldInfo.getCompany().getId().toString(), 3);
            int count = costColl.size();
            for (i = 0; i < count; ++i) {
                costObjectInfo = costColl.get(i);
                BizReference ref = null;
                try {
                    ref = ReferenceDAO.getReference((Context)ctx, (BOSUuid)costObjectInfo.getId());
                }
                catch (Exception e) {
                    throw new ObjectReferedException((Object)ref, (Throwable)e);
                }
                if (ref == null) continue;
                return true;
            }
            count = costColl.size();
            for (i = 0; i < count; ++i) {
                costObjectInfo = costColl.get(i);
                this.delete(ctx, (IObjectPK)new ObjectUuidPK(costObjectInfo.getId().toString()));
            }
        }
        return false;
    }

    @Override
    protected CostObjectCollection _getCostObjectColByMaterial(Context ctx, String materialID, String companyID, int calculateMode) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("select co.FID,CO.FNUMBER,CO.FNAME_" + ctx.getLocale()).append("  from T_BD_CostObject co left join T_BD_CostObjectEntry coe on coe.FparentID = co.Fid ").append(" where coe.FRelatedID = ?").append("\t  and co.FCompanyID = ? ");
        Object[] param = null;
        if (calculateMode < 5) {
            sb.append("   and co.FCalculateMode = ? ");
            param = new Object[]{materialID, companyID, calculateMode};
        } else {
            param = new Object[]{materialID, companyID};
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
        CostObjectCollection col = new CostObjectCollection();
        try {
            if (rs != null && rs.size() > 0) {
                while (rs.next()) {
                    CostObjectInfo co = new CostObjectInfo();
                    co.setId(BOSUuid.read((String)rs.getString(1)));
                    co.setNumber(rs.getString(2));
                    co.setName(rs.getString(3));
                    col.add(co);
                }
            }
        }
        catch (UuidException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return col;
    }

    @Override
    protected boolean _checkCostObjectReference(Context ctx, BOSUuid costObjectId) throws BOSException, EASBizException {
        if (this.isCostObjectReference(ctx, costObjectId)) {
            return true;
        }
        return this.isByProUnitCostReference(ctx, costObjectId);
    }

    private boolean isCostObjectReference(Context ctx, BOSUuid costObjectId) throws BOSException, EASBizException {
        BizReference ref = null;
        try {
            ref = ReferenceDAO.getReference((Context)ctx, (BOSUuid)costObjectId);
        }
        catch (Exception e) {
            throw new ObjectReferedException((Object)ref, (Throwable)e);
        }
        return ref != null;
    }

    private boolean isByProUnitCostReference(Context ctx, BOSUuid costObjectId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("select co.FID,CO.FNUMBER,CO.FNAME_" + ctx.getLocale()).append("  from T_BD_CostObject co ").append(" INNER JOIN T_BD_CostObjectEntry coe on coe.FparentID = co.Fid ").append(" INNER JOIN T_NCM_ByProductUnitCost bpc on coe.FRelatedID = bpc.FMaterialID ").append("   and co.FCompanyID = bpc.FCompanyID ").append(" where co.FID = ? ");
        Object[] param = new Object[]{costObjectId.toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
        return rs != null && rs.size() > 0;
    }

    public CoreBaseCollection getCollection(Context ctx, EntityViewInfo view) throws BOSException {
        return super.getCollection(ctx, view);
    }

    @Override
    protected synchronized boolean _addShareCostObject(Context ctx, String companyID, String ctrlUnitID) throws BOSException, EASBizException {
        if (companyID == null || ctrlUnitID == null) {
            return false;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select top 1 FID from T_BD_CostObject where FNumber = '");
        sb.append("SCOID").append("' and FCompanyID = '");
        sb.append(companyID).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String shareCoNumber = "SCOID";
        String RESOURCE_URL = "com.kingdee.eas.basedata.assistant.CostObjectResource";
        String shareCoName_l1 = ResourceBase.getString((String)RESOURCE_URL, (String)"SHARE_COST_OBJECT", (Locale)new Locale("l1"));
        String shareCoName_l2 = ResourceBase.getString((String)RESOURCE_URL, (String)"SHARE_COST_OBJECT", (Locale)new Locale("l2"));
        String shareCoName_l3 = ResourceBase.getString((String)RESOURCE_URL, (String)"SHARE_COST_OBJECT", (Locale)new Locale("l3"));
        String ctrlUnitId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String userId = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        sb.setLength(0);
        sb.append("insert into T_BD_CostObject ").append("\n").append("(FID, FNumber, FName_l1, FName_l2, FName_l3, ").append(" FCompanyID, FGroupId, FCOGROUPID, FRelatedID ,FRelatedType ,FCalculateMode ,FStdProductIDID, ").append(" FControlUnitID, FCreatorID, FCreateTime, FLastUpdateUserID,FLastUpdateTime,FIsForbiden)").append("\n").append("values(newbosid(''39734A77'') , ").append("       ''").append(shareCoNumber).append("'', ").append("       ''").append(shareCoName_l1).append("'', ").append("       ''").append(shareCoName_l2).append("'', ").append("       ''").append(shareCoName_l3).append("'', ").append("       ''{0}'' ,  ").append("       ''").append("qtsXyapZTneI8TxJu+B2Q8w5rkg=").append("'' , ").append("       ''").append("qtsXyapZTneI8TxJu+B2Q8w5rkg=").append("'' , ").append("       null, 0, 0, null, ").append("       ''").append(ctrlUnitId).append("'' , ").append("       ''").append(userId).append("'' , GetDate() , ").append("       ''").append(userId).append("'' , GetDate() , 0 ) ").append("\n");
        String sql = MessageFormat.format(sb.toString(), companyID);
        DbUtil.execute((Context)ctx, (String)sql);
        return true;
    }

    @Override
    protected boolean _isCostObjectOfBillRequired(Context ctx, String companyID) throws BOSException, EASBizException {
        IParamControl ipctr = ParamControlFactory.getLocalInstance((Context)ctx);
        String companyOrgID = null;
        companyOrgID = companyID == null || companyID.length() == 0 ? ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() : companyID;
        ObjectUuidPK comPk = new ObjectUuidPK(companyOrgID);
        String value = ipctr.getParamValue((IObjectPK)comPk, "CM008");
        if (value != null && Boolean.valueOf(value).booleanValue()) {
            String ctrlUnitID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            this._addShareCostObject(ctx, companyOrgID, ctrlUnitID);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CostObjectInfo info = (CostObjectInfo)model;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String orgId = null;
        if (info.getCompany() != null) {
            orgId = info.getCompany().getId().toString();
        }
        if (orgId == null) {
            orgId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        }
        RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus(model, orgId);
        if (StringUtils.isEmpty((String)info.getNumber())) {
            if (!ruleStatus.isExist()) throw new CostObjectException(CostObjectException.CODINGRULE_NOT_ENABLE);
            this.setNewNumber(ctx, info, iCodingRuleManager, null);
            return;
        } else if (ruleStatus.isExist()) {
            if (ruleStatus.isAddView()) {
                if (ruleStatus.isModifiable()) {
                    this._checkNumberDup(ctx, model);
                    return;
                } else {
                    if (!this.isNumberUsed(ctx, info)) return;
                    this.setNewNumber(ctx, info, iCodingRuleManager, null);
                }
                return;
            } else {
                if (!ruleStatus.isAddNoBreak()) return;
                this.setNewNumber(ctx, info, iCodingRuleManager, null);
            }
            return;
        } else {
            this._checkNumberDup(ctx, model);
        }
    }

    protected boolean isNumberUsed(Context ctx, CostObjectInfo info) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        if (info.getCompany() != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
        }
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        boolean exist = super._exists(ctx, filter);
        return exist;
    }

    protected void setNewNumber(Context ctx, CostObjectInfo info, ICodingRuleManager iCodingRuleManager, String customString) throws BOSException, EASBizException {
        String number = iCodingRuleManager.getNumber((IObjectValue)info, info.getCompany().getId().toString(), customString);
        info.setNumber(number);
        if (this.isNumberUsed(ctx, info)) {
            this.setNewNumber(ctx, info, iCodingRuleManager, customString);
        }
    }

    protected void setNumberFromCodingRule(Context ctx, DataBaseInfo caller, String orgId) throws BOSException, EASBizException {
    }

    private void addCostObjectGroup(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        UserInfo UserInfo2 = (UserInfo)ctx.get((Object)"UserInfo");
        StringBuffer copyMaterialTreeSql = new StringBuffer();
        copyMaterialTreeSql.append("insert into T_BD_CostObjectGroup").append("(FID, FSourceId, FControlUnitID, FLastUpdateUserID, FCreatorID, ").append(" FSimpleName, FDESCRIPTION_L1, FDESCRIPTION_L2, FDESCRIPTION_L3, ").append(" FNumber, FNAME_L1, FNAME_L2, FNAME_L3, FRelatedType, ").append(" FDISPLAYNAME_L1, FDISPLAYNAME_L2, FDISPLAYNAME_L3, FLONGNUMBER, ").append(" FLEVEL, FISLEAF, FParentID, FIsUsed )").append("select newbosid('CC39AE48') AS FID,  materialGroup.FID AS FSourceId, ").append(" materialGroup.FControlUnitID, '").append(UserInfo2.getId().toString()).append("', '").append(UserInfo2.getId().toString()).append("', ").append(" materialGroup.FSimpleName, materialGroup.FDESCRIPTION_L1, materialGroup.FDESCRIPTION_L2, materialGroup.FDESCRIPTION_L3, ").append(" materialGroup.FNumber, materialGroup.FNAME_L1, materialGroup.FNAME_L2, materialGroup.FNAME_L3, 0,").append(" materialGroup.FDISPLAYNAME_L1, materialGroup.FDISPLAYNAME_L2, materialGroup.FDISPLAYNAME_L3, 'PD!'||materialGroup.FLONGNUMBER, ").append(" materialGroup.FLEVEL+1, materialGroup.FISLEAF, materialGroup.FParentID, 1 ").append("from T_BD_MaterialGroup materialGroup ,T_BD_MaterialGroupStandard groupStandard ").append("where materialGroup.FNumber not in ").append("(select Fnumber from T_BD_CostObjectGroup ").append(" where FRelatedType=0) ").append("and materialGroup.FGroupStandard=groupStandard.FID ").append("and groupStandard.FID ='dR8lnQEPEADgAAWKwKgSxZeb4R8=' ").append("and groupStandard.FSTANDARDTYPE=1;");
        String tblName = this.createTempTable(ctx, "UpdateTreeParentTemp");
        StringBuffer fillTheTempTblSql = new StringBuffer();
        fillTheTempTblSql.append("insert into ").append(tblName).append("(FID, FParentID) ").append("SELECT b.FID, a.FID FParentID ").append("FROM T_BD_CostObjectGroup a ").append("INNER JOIN T_BD_CostObjectGroup b ").append("ON a.FSourceId = b.FParentID ").append("AND a.FIsUsed = 1 ").append("AND b.FIsUsed = 1 ").append("AND a.FSourceId IS NOT NULL ").append("AND b.FSourceId IS NOT NULL;");
        StringBuffer updateTreeParentSql = new StringBuffer();
        updateTreeParentSql.append("update T_BD_CostObjectGroup ").append("set FParentID = ").append("(select m.FParentID from ").append(tblName).append(" m ").append("where T_BD_CostObjectGroup.FID = m.FID and T_BD_CostObjectGroup.FIsUsed = 1 ").append(") where FIsUsed = 1;");
        StringBuffer updateTreeParentSql1 = new StringBuffer();
        updateTreeParentSql1.append("update T_BD_CostObjectGroup ").append("set FParentID ='").append("qtsXyapZTneI8TxJu+B2Q8w5rkg=").append("' ").append("where T_BD_CostObjectGroup.FIsUsed = 1 and T_BD_CostObjectGroup.FParentID is null ").append(";");
        StringBuffer updataCostObjectGroupSql = new StringBuffer();
        updataCostObjectGroupSql.append("update t_bd_costobject set FCoGroupID=").append("(select  coGroup.FID ").append(" from T_BD_CostObjectGroup coGroup, T_BD_MaterialGroup materialGroup ").append(" where t_bd_costobject.FGroupId=coGroup.FSourceId ").append("  and t_bd_costobject.FGroupId=materialGroup.FID and coGroup.FNumber = materialGroup.FNumber ").append("  and t_bd_costobject.fissys=1 ").append(" ) where fissys=1;");
        DbUtil.execute((Context)ctx, (String)copyMaterialTreeSql.toString());
        DbUtil.execute((Context)ctx, (String)fillTheTempTblSql.toString());
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tblName);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        DbUtil.execute((Context)ctx, (String)updateTreeParentSql.toString());
        DbUtil.execute((Context)ctx, (String)updateTreeParentSql1.toString());
        DbUtil.execute((Context)ctx, (String)updataCostObjectGroupSql.toString());
        TempTablePool.getInstance((Context)ctx).releaseTable(tblName);
    }

    protected void _deleteBatchData(Context ctx, IObjectPK[] pkArray) throws BOSException, EASBizException {
        for (int i = 0; i < pkArray.length; ++i) {
            if (this.checkCostObjectReference(ctx, BOSUuid.read((String)pkArray[i].toString()))) continue;
            this.delete(ctx, (IObjectPK)new ObjectUuidPK(pkArray[i].toString()));
        }
    }

    @Override
    protected boolean _setCostObjectBom(Context ctx, List storageIds, String companyID, String setModel, String setRange) throws BOSException, EASBizException {
        String coBomTbl = null;
        try {
            coBomTbl = this.getCOBOMRangeTblData(ctx, companyID, setRange);
            for (int i = 0; i < storageIds.size(); ++i) {
                this.setBomData(ctx, coBomTbl, storageIds.get(i).toString(), i);
            }
            this.updateCoBom(ctx, coBomTbl, setModel);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (coBomTbl != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(coBomTbl);
            }
        }
        return true;
    }

    private String getCOBOMRangeTblData(Context ctx, String companyID, String setRange) throws BOSException {
        String coBomTbl = null;
        StringBuffer sb = new StringBuffer();
        sb.append("create Table T_NCM_CostObjectBOM (");
        sb.append("  FCostObjectID      VARCHAR(44),");
        sb.append("  FMaterialID   \t    VARCHAR(44),");
        sb.append("  FBomID   \t        VARCHAR(44), ");
        sb.append("  FIsUpdate          INT default 0, ");
        sb.append("  FIsMoreBom          INT default 0) ");
        try {
            coBomTbl = TempTablePool.getInstance((Context)ctx).createTempTable(sb.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        sb.setLength(0);
        sb.append(" Insert Into ").append(coBomTbl).append("\n");
        sb.append(" (FCostObjectID,FMaterialID,FBomID,FIsUpdate) \n");
        sb.append(" select co.FID,co.FStdProductIDID,'' as FBomID, 0 as FIsUpdate From \n");
        sb.append(" T_BD_Costobject co \n");
        sb.append(" where co.FCompanyID = '").append(companyID).append("' \n");
        sb.append("      and co.FIsForbiden = 0 \n");
        sb.append("      and co.FRelatedType = 0 \n");
        sb.append("      and (co.FCalculateMode = 1 or co.FCalculateMode = 4 ) \n");
        if ("1".equals(setRange)) {
            sb.append("  and (co.FBOMID is null or FBomID = '')");
        }
        DbUtil.execute((Context)ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append(" Insert Into ").append(coBomTbl).append("\n");
        sb.append(" (FCostObjectID,FMaterialID,FBomID,FIsUpdate) \n");
        sb.append("  select co.FID,coEntry.FRelatedID,'' as FBomID, 0 as FIsUpdate From \n");
        sb.append("  T_BD_CostObject co ");
        sb.append("  inner join T_BD_CostObjectEntry coEntry on coEntry.FParentID = co.Fid \n");
        sb.append("  where co.FCompanyID = '").append(companyID).append("' \n");
        sb.append("      and co.FIsForbiden = 0 \n");
        sb.append("      and co.FRelatedType = 0 \n");
        sb.append("      and co.FCalculateMode = 3  \n");
        sb.append("      and coEntry.FIsMainProduct = 1 \n");
        if ("1".equals(setRange)) {
            sb.append("  and (co.FBOMID is null or FBomID = '')");
        }
        sb.append(" ; \n");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        return coBomTbl;
    }

    private void setBomData(Context ctx, String coBomTbl, String storageID, int seq) throws BOSException {
        StringBuffer sb = new StringBuffer();
        if (seq > 0) {
            sb.setLength(0);
            sb.append(" Update ").append(coBomTbl).append(" co set FIsMoreBom = 1 ");
            sb.append(" where exists(select 1 From T_MM_BOM bom \n");
            sb.append("               where co.FMaterialID = bom.FMaterialID \n");
            sb.append("                     and co.FisUpdate = 1 \n");
            sb.append("                     and bom.FStorageOrgUnitID = '").append(storageID).append("' \n");
            sb.append("                     and bom.FBaseStatus = 4 ) \n");
            sb.append("  and co.FisUpdate = 1 ;\n");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        sb.append(" Update ").append(coBomTbl).append(" co set (FBOMID,FIsUpdate) = ");
        sb.append(" (select bom.Fid, 1 as FIsUpdate From T_MM_BOM bom \n");
        sb.append("  where co.FMaterialID = bom.FMaterialID \n");
        sb.append("   and co.FisUpdate = 0 \n");
        sb.append("   and bom.FStorageOrgUnitID = '").append(storageID).append("' \n");
        sb.append("   and bom.FBomType = 40 \n");
        sb.append("   and bom.FBaseStatus = 4  \n");
        sb.append("   and bom.FUsageType = 10) \n");
        sb.append(" Where (co.FBomID is null or FBomID = ''); \n");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private void updateCoBom(Context ctx, String coBomTbl, String setModel) throws BOSException {
        StringBuffer sb = new StringBuffer();
        if ("1".equals(setModel)) {
            sb.append(" update T_BD_CostObject set FBomID = ( \n");
            sb.append("  select FBomID from ").append(coBomTbl).append(" t1 \n");
            sb.append("   where T_BD_CostObject.Fid = t1.FCostObjectID \n");
            sb.append("     and t1.fisUpdate = 1 and t1.FIsMoreBom = 0 ) \n");
            sb.append(" where fid in ( select FCostobjectID from " + coBomTbl + ")");
        } else {
            sb.append(" update T_BD_CostObject set (FBomID, FIsMoreBom) = ( \n");
            sb.append("  select FBomID,FIsMoreBom from ").append(coBomTbl).append(" t1 \n");
            sb.append("   where T_BD_CostObject.Fid = t1.FCostObjectID \n");
            sb.append("     and t1.fisUpdate = 1 ) \n");
            sb.append(" where fid in ( select FCostobjectID from " + coBomTbl + ")");
        }
        DbUtil.execute((Context)ctx, (String)sb.toString());
        CostObjectInfo coInfo = new CostObjectInfo();
        ORMValueCacheService.getInstance().discardType(ctx, coInfo.getBOSType());
    }

    private void deleteManufactureOrderReferenced(Context ctx, IObjectPK pk) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append(" update T_MM_ManufactureOrder set FCostObjectID = '' where FCostObjectID = '" + pk.toString() + "' \n");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }
}

