/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CostItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostItemTypeTreeCollection;
import com.kingdee.eas.basedata.assistant.CostItemTypeTreeFactory;
import com.kingdee.eas.basedata.assistant.CostItemTypeTreeInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractCostItemControllerBean;
import com.kingdee.eas.common.EASBizException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CostItemControllerBean
extends AbstractCostItemControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.CostItemControllerBean");

    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.isReferenced(ctx, pk);
        super.delete(ctx, pk);
    }

    @Override
    protected Map _transformToTree(Context ctx, Set databaseIDs, int groupLevel) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)databaseIDs, CompareType.INCLUDE));
        view.getSelector().add("*");
        view.getSelector().add("TypeTree.*");
        CostItemCollection costItemCollection = this.getCostItemCollection(ctx, view);
        HashMap<BOSUuid, String> costItemFIDToTypeLongNumberMap = new HashMap<BOSUuid, String>();
        HashSet<String> typeLongNumberSet = new HashSet<String>();
        HashSet<String> rootSet = new HashSet<String>();
        int count = costItemCollection.size();
        for (int i = 0; i < count; ++i) {
            CostItemInfo costItemInfo = costItemCollection.get(i);
            if (costItemInfo.getTypeTree() == null) {
                rootSet.add(costItemInfo.getId().toString());
                continue;
            }
            String desLongNumber = this.getDestindationTypeLongNumber(costItemInfo.getTypeTree().getLongNumber(), groupLevel);
            costItemFIDToTypeLongNumberMap.put(costItemInfo.getId(), desLongNumber);
            typeLongNumberSet.add(desLongNumber);
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("longNumber", typeLongNumberSet, CompareType.INCLUDE));
        CostItemTypeTreeCollection costItemTypeTreeCollection = CostItemTypeTreeFactory.getLocalInstance(ctx).getCostItemTypeTreeCollection(view);
        HashMap<String, BOSUuid> costItemTypeLongNumberToFIDMap = new HashMap<String, BOSUuid>();
        int count2 = costItemTypeTreeCollection.size();
        for (int i = 0; i < count2; ++i) {
            CostItemTypeTreeInfo costItemTypeTreeInfo = costItemTypeTreeCollection.get(i);
            costItemTypeLongNumberToFIDMap.put(costItemTypeTreeInfo.getLongNumber(), costItemTypeTreeInfo.getId());
        }
        HashMap<String, HashSet<String>> returnCostItemTypeFIDToCostItemIDSetMap = new HashMap<String, HashSet<String>>();
        if (rootSet.size() > 0) {
            returnCostItemTypeFIDToCostItemIDSetMap.put("RootID", rootSet);
        }
        int count3 = costItemCollection.size();
        for (int i = 0; i < count3; ++i) {
            CostItemInfo costItemInfo = costItemCollection.get(i);
            Object longNumber = costItemFIDToTypeLongNumberMap.get(costItemInfo.getId());
            if (longNumber == null) continue;
            Object typeId = costItemTypeLongNumberToFIDMap.get(longNumber);
            HashSet<String> costItemIDSet = (HashSet<String>)returnCostItemTypeFIDToCostItemIDSetMap.get(typeId.toString());
            if (costItemIDSet == null) {
                costItemIDSet = new HashSet<String>();
                returnCostItemTypeFIDToCostItemIDSetMap.put(typeId.toString(), costItemIDSet);
            }
            costItemIDSet.add(costItemInfo.getId().toString());
        }
        return returnCostItemTypeFIDToCostItemIDSetMap;
    }

    private String getDestindationTypeLongNumber(String srcLongNumber, int groupLevel) {
        String desLongNumber = srcLongNumber;
        for (int i = 1; i < groupLevel && desLongNumber.lastIndexOf("!") > 0; ++i) {
            desLongNumber = desLongNumber.substring(0, desLongNumber.lastIndexOf("!"));
        }
        return desLongNumber;
    }

    protected boolean useOptimizedBatchAssginAndUnassign() {
        return true;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        super._update(ctx, pk, model);
    }
}

