/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectException;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectGroupFactory;
import com.kingdee.eas.basedata.assistant.CostObjectGroupInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.ICostObjectGroup;
import com.kingdee.eas.basedata.assistant.app.AbstractCostObjectGroupControllerBean;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class CostObjectGroupControllerBean
extends AbstractCostObjectGroupControllerBean {
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this._addnew(ctx, model, true);
    }

    @Override
    public IObjectPK _addnew(Context ctx, IObjectValue model, boolean isValidHasCo) throws BOSException, EASBizException {
        CostObjectGroupInfo costObjectGroupInfo = (CostObjectGroupInfo)model;
        super._checkNumberBlank(ctx, (IObjectValue)costObjectGroupInfo);
        this._checkNumberDup(ctx, (IObjectValue)costObjectGroupInfo);
        super._checkNameBlank(ctx, (IObjectValue)costObjectGroupInfo);
        this._checkNameDup(ctx, (IObjectValue)costObjectGroupInfo);
        this.checkObjectBlank(ctx, (IObjectValue)costObjectGroupInfo);
        IObjectPK pk = super._addnew(ctx, (IObjectValue)costObjectGroupInfo);
        return pk;
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CostObjectGroupInfo costObjectGroupInfo = (CostObjectGroupInfo)model;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)costObjectGroupInfo.getName().trim(), CompareType.EQUALS));
        if (costObjectGroupInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)costObjectGroupInfo.getId().toString().trim(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1");
        }
        filter.mergeFilter(this.getUnitFilter(ctx), "AND");
        evi.setFilter(filter);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CostObjectGroupInfo costObjectGroupInfo = (CostObjectGroupInfo)model;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)costObjectGroupInfo.getNumber().trim(), CompareType.EQUALS));
        if (costObjectGroupInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)costObjectGroupInfo.getId().toString().trim(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1");
        }
        filter.mergeFilter(this.getUnitFilter(ctx), "AND");
        evi.setFilter(filter);
        if (this.exists(ctx, filter)) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{costObjectGroupInfo.getNumber()});
        }
    }

    private FilterInfo getUnitFilter(Context ctx) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.mergeFilter(this.getControlUnitFilterInfo(ctx), "or");
        return filter;
    }

    private FilterInfo getCompanyFilterInfo(Context ctx) throws BOSException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyId = null;
        if (company != null) {
            companyId = company.getId().toString();
        }
        FilterInfo companyFilter = new FilterInfo();
        companyFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
        if (ctx.get((Object)"CurCompanyId") != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", ctx.get((Object)"CurCompanyId"), CompareType.EQUALS));
            try {
                companyFilter.mergeFilter(filter, "Or");
            }
            catch (BOSException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return companyFilter;
    }

    private FilterInfo getControlUnitFilterInfo(Context ctx) throws BOSException {
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)cu.getId().toString(), (String)cu.getLongNumber());
        return filterInfoCU;
    }

    protected void checkLNForTree(Context ctx, TreeBaseInfo treeBaseInfo) throws BOSException, EASBizException, TreeBaseException {
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK projectPK = pk;
        CostObjectGroupInfo costObjectGroupInfo = (CostObjectGroupInfo)model;
        super._checkNumberBlank(ctx, (IObjectValue)costObjectGroupInfo);
        this._checkNumberDup(ctx, (IObjectValue)costObjectGroupInfo);
        super._checkNameBlank(ctx, (IObjectValue)costObjectGroupInfo);
        this._checkNameDup(ctx, (IObjectValue)costObjectGroupInfo);
        this.checkObjectBlank(ctx, (IObjectValue)costObjectGroupInfo);
        this.checkType(ctx, projectPK, (IObjectValue)costObjectGroupInfo);
        super._update(ctx, projectPK, (IObjectValue)costObjectGroupInfo);
    }

    private void checkObjectBlank(Context ctx, IObjectValue model) throws BOSException, CostObjectException {
        CostObjectGroupInfo costObjectGroupInfo = (CostObjectGroupInfo)model;
        if (costObjectGroupInfo.getRelatedType() == null) {
            throw new CostObjectException(CostObjectException.OBJECTNOTNULL);
        }
    }

    private void checkType(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CostObjectGroupInfo costObjectGroupInfo = (CostObjectGroupInfo)model;
        ICostObjectGroup iCostObjectGroup = CostObjectGroupFactory.getLocalInstance(ctx);
        CostObjectGroupInfo costObjectGroupInfoOld = iCostObjectGroup.getCostObjectGroupInfo(pk);
        if (this.checkCostObject(ctx, pk) && !costObjectGroupInfo.getRelatedType().equals((Object)costObjectGroupInfoOld.getRelatedType())) {
            throw new CostObjectException(CostObjectException.UPDATEFAIL);
        }
    }

    private boolean checkCostObject(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String id = pk.toString();
        ICostObject icostObject = CostObjectFactory.getLocalInstance(ctx);
        CostObjectCollection costObjectCollection = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("group.id", (Object)id, CompareType.EQUALS));
        evi.setFilter(filterInfo);
        costObjectCollection = icostObject.getCostObjectCollection(evi);
        return costObjectCollection != null && costObjectCollection.size() > 0;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (this.checkCostObject(ctx, pk)) {
            throw new CostObjectException(CostObjectException.CANNOTDELETE);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected boolean _updateCostObject(Context ctx, IObjectPK parentPK, IObjectPK childPK) throws BOSException, EASBizException {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("update T_BD_CostObject set FGroupID = ? Where FGroupID =?");
        PreparedStatement stmt = null;
        Connection cn = null;
        int index = 1;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(strSQL.toString());
            stmt.setString(index++, childPK.toString());
            stmt.setString(index++, parentPK.toString());
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        return true;
    }

    private boolean isRefByCostObject(Context ctx, TreeBaseInfo tree) throws EASBizException, BOSException {
        if (tree != null && tree.getId() != null) {
            FilterInfo fiCU = new FilterInfo();
            fiCU.getFilterItems().add(new FilterItemInfo("company.id", null, CompareType.EQUALS));
            FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), (String)ContextUtil.getCurrentFIUnit((Context)ctx).getLongNumber());
            fiCU.mergeFilter(filterInfoCU, "and");
            FilterInfo fiCompany = new FilterInfo();
            CompanyOrgUnitInfo companyInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
            if (companyInfo != null && companyInfo.getId() != null) {
                fiCompany.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString()));
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("CostObjectGroup.id", (Object)tree.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"SCOID", CompareType.NOTEQUALS));
            fiCU.mergeFilter(fiCompany, "or");
            filterInfo.mergeFilter(fiCU, "and");
            ICostObject icostObject = CostObjectFactory.getLocalInstance(ctx);
            boolean exists = icostObject.exists(filterInfo);
            return exists;
        }
        return false;
    }

    protected void _moveTreeNode(Context ctx, IObjectValue sourceNode, IObjectValue targetNode) throws EASBizException, BOSException {
        TreeBaseInfo targetTree = (TreeBaseInfo)targetNode;
        if (this.isRefByCostObject(ctx, targetTree)) {
            throw new CostObjectException(CostObjectException.CANNOT_MOVE_COGROUP_REFCO);
        }
        super._moveTreeNode(ctx, sourceNode, targetNode);
    }
}

