/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.BDNCMException;
import com.kingdee.eas.basedata.assistant.CostObjectException;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteEntryCollection;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteEntryInfo;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractCostObjectSuiteControllerBean;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CostObjectSuiteControllerBean
extends AbstractCostObjectSuiteControllerBean {
    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.isReferenced(ctx, pk);
        super._delete(ctx, pk);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        this._checkNameDup(ctx, model);
        this.checkCostObjectGroupUnique(ctx, model);
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CostObjectSuiteInfo old = this.getCostObjectSuiteInfo(ctx, pk);
        if (!old.getId().toString().equals(model.getString("id"))) {
            this._checkNumberDup(ctx, model);
        }
        this._checkNumberDup(ctx, model);
        this._checkNameDup(ctx, model);
        this.checkCostObjectGroupUnique(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (this._checkDup(ctx, model, "number")) {
            throw new BDNCMException(BDNCMException.COMPANYANDNUMBER_CANNOTDUPLICATION);
        }
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (this._checkDup(ctx, model, "name")) {
            throw new BDNCMException(BDNCMException.COMPANYANDNAME_CANNOTDUPLICATION);
        }
    }

    private boolean _checkDup(Context ctx, IObjectValue model, String fieldName) throws BOSException, EASBizException {
        CostObjectSuiteInfo ccGroupInfo = (CostObjectSuiteInfo)model;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)ccGroupInfo.getCompany().getId().toString(), CompareType.EQUALS));
        FilterItemInfo filterItem = new FilterItemInfo(fieldName, ccGroupInfo.get(fieldName), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItem);
        if (ccGroupInfo.getId() != null) {
            FilterItemInfo filterItem2 = new FilterItemInfo("id", (Object)ccGroupInfo.getId(), CompareType.NOTEQUALS);
            filterInfo.getFilterItems().add(filterItem2);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return this.exists(ctx, filterInfo);
    }

    private void checkCostObjectGroupUnique(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CostObjectSuiteInfo ccGroupInfo = (CostObjectSuiteInfo)model;
        CostObjectSuiteEntryCollection costObjectSuiteEntry = ccGroupInfo.getEntry();
        int costObjectCount = costObjectSuiteEntry.size();
        StringBuffer sostObjectIDSet = new StringBuffer();
        CostObjectSuiteEntryInfo entryTemp = null;
        for (int i = 0; i < costObjectCount; ++i) {
            entryTemp = costObjectSuiteEntry.get(i);
            if (i > 0) {
                sostObjectIDSet.append(",");
            }
            sostObjectIDSet.append("'").append(entryTemp.getCostObject().getId().toString()).append("'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select parent.FNumber from T_NCM_CostObjectSuite parent inner join T_NCM_CostObjectSuiteEntry entry on parent.FID = entry.FParentID where entry.FParentID in( ");
        sql.append(" select FParentID from T_NCM_CostObjectSuiteEntry  where FCostObjectID in( ");
        sql.append(sostObjectIDSet);
        sql.append(" ) ");
        sql.append(" group by FParentID ");
        sql.append(" having count(*) = ").append(costObjectCount);
        if (ccGroupInfo.getId() != null) {
            sql.append(" and FParentID != '").append(ccGroupInfo.getId().toString()).append("' ");
        }
        sql.append(" ) ");
        sql.append(" group by parent.FNumber ");
        sql.append("having  max(FSeq) = ").append(costObjectCount);
        sql.append(";");
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowset != null && rowset.next()) {
                String costObjectSuiteNumber = rowset.getString("FNumber");
                throw new CostObjectException(CostObjectException.COST_OBJECT_GROUP_DUPLICATE, new Object[]{costObjectSuiteNumber});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _getCostObjectMatModel(Context ctx, Map param) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        Set set = param.entrySet();
        for (Map.Entry entry : set) {
            String coFid = (String)entry.getKey();
            String matFid = (String)entry.getValue();
            ObjectUuidPK pk = new ObjectUuidPK(matFid);
            if (!iMaterial.exists((IObjectPK)pk)) continue;
            MaterialInfo materialInfo = iMaterial.getMaterialInfo((IObjectPK)pk);
            String model = materialInfo.getModel();
            result.put(coFid, model);
        }
        return result;
    }
}

