/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.cm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.cm.util.QtyMultiMeasureUtils;
import com.kingdee.eas.basedata.cm.util.STConstant;
import com.kingdee.eas.basedata.cm.util.STQMUtils;
import com.kingdee.eas.basedata.cm.util.STUtils;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.cm.common.utils.PrecisionUtil;
import com.kingdee.eas.common.EASBizException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JScrollBar;
import javax.swing.JTextField;

public abstract class KDTableUtils {
    private static final String TABLENULLEXCEPTION = "\u4f20\u5165\u7684\u660e\u7ec6\u8868\u4e0d\u5b58\u5728";
    private static final BigDecimal MAXVALUE = new BigDecimal(9.99999999E8);
    private static final BigDecimal MINVALUE = new BigDecimal(1.0E-8);

    public static String getFieldName(KDTable table, int columnIndex) {
        String fieldName = null;
        if (table != null && columnIndex > -1) {
            fieldName = table.getColumnKey(columnIndex);
        }
        return fieldName;
    }

    public static Object getFieldValue(KDTable table, int rowIndex, String fieldName) {
        Object result = null;
        ICell cell = KDTableUtils.getCell(table, rowIndex, fieldName);
        if (cell != null) {
            result = cell.getValue();
        }
        return result;
    }

    public static Object getFieldValue(KDTable table, int rowIndex, int columnIndex) {
        Object result = null;
        ICell cell = KDTableUtils.getCell(table, rowIndex, columnIndex);
        if (cell != null) {
            result = cell.getValue();
        }
        return result;
    }

    public static List getFieldValues(KDTable table, int rowIndex, String[] fieldNames) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (table != null && rowIndex > -1 && fieldNames != null) {
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                values.add(i, KDTableUtils.getFieldValue(table, rowIndex, fieldNames[i]));
            }
        }
        return values;
    }

    public static List getMapFieldValues(KDTable table, String[] fieldNames) {
        ArrayList<Map> allList = new ArrayList<Map>();
        if (table != null && fieldNames != null) {
            for (int i = 0; i < table.getRowCount(); ++i) {
                Map map = KDTableUtils.getMapFieldValues(table, i, fieldNames);
                allList.add(map);
            }
        }
        return allList;
    }

    public static Map getMapFieldValues(KDTable table, int rowIndex, String[] fieldNames) {
        HashMap map = new HashMap();
        List list = KDTableUtils.getFieldValues(table, rowIndex, fieldNames);
        for (int j = 0; j < fieldNames.length; ++j) {
            map.put(fieldNames[j], list.get(j));
        }
        return map;
    }

    public static List getFieldValues(KDTable table, int rowIndex, int[] columnIndexes) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (table != null && rowIndex > -1 && columnIndexes != null) {
            int size = columnIndexes.length;
            for (int i = 0; i < size; ++i) {
                values.add(i, KDTableUtils.getFieldValue(table, rowIndex, columnIndexes[i]));
            }
        }
        return values;
    }

    public static void setFieldValues(KDTable table, int rowIndex, String[] fieldNames, Object[] values) {
        if (fieldNames != null) {
            int vSize = values.length;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                if (i > -1 && i < vSize) {
                    KDTableUtils.setFieldValue(table, rowIndex, fieldNames[i], values[i]);
                    continue;
                }
                KDTableUtils.setFieldValue(table, rowIndex, fieldNames[i], null);
            }
        }
    }

    public static void setFieldValues(KDTable table, int rowIndex, int[] columnIndexes, Object[] values) {
        if (columnIndexes != null) {
            int vSize = values.length;
            int size = columnIndexes.length;
            for (int i = 0; i < size; ++i) {
                if (i > -1 && i < vSize) {
                    KDTableUtils.setFieldValue(table, rowIndex, columnIndexes[i], values[i]);
                    continue;
                }
                KDTableUtils.setFieldValue(table, rowIndex, columnIndexes[i], null);
            }
        }
    }

    public static void setFieldValue(KDTable table, int rowIndex, String fieldName, Object value) {
        ICell cell = KDTableUtils.getCell(table, rowIndex, fieldName);
        if (cell != null) {
            cell.setValue(value);
        }
    }

    public static void setFieldValue(KDTable table, int rowIndex, int columnIndex, Object value) {
        ICell cell = KDTableUtils.getCell(table, rowIndex, columnIndex);
        if (cell != null) {
            cell.setValue(value);
        }
    }

    public static ICell getCell(KDTable table, int rowIndex, String fieldName) {
        ICell cell = null;
        if (table != null && rowIndex > -1 && fieldName != null && fieldName.trim().length() != 0) {
            cell = table.getRow(rowIndex).getCell(fieldName);
        }
        return cell;
    }

    public static ICell getCell(KDTable table, int rowIndex, int columnIndex) {
        ICell cell = null;
        if (table != null && rowIndex > -1 && columnIndex > -1) {
            cell = table.getRow(rowIndex).getCell(columnIndex);
        }
        return cell;
    }

    public static int getColumnIndex(KDTable table, String fieldName) {
        IColumn column = KDTableUtils.getColumn(table, fieldName);
        int columnIndex = -1;
        if (column != null) {
            columnIndex = column.getColumnIndex();
        }
        return columnIndex;
    }

    public static IColumn getColumn(KDTable table, String fieldName) {
        IColumn column = null;
        if (table != null && fieldName != null && fieldName.trim().length() != 0) {
            column = table.getColumn(fieldName);
        }
        return column;
    }

    public static IColumn getColumn(KDTable table, int columnIndex) {
        IColumn column = null;
        if (table != null && columnIndex > -1) {
            column = table.getColumn(columnIndex);
        }
        return column;
    }

    public static void setHideFields(KDTable table, String[] fieldNames, boolean isHide) {
        if (fieldNames != null) {
            IColumn column = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                column = KDTableUtils.getColumn(table, fieldNames[i]);
                if (column == null) continue;
                column.getStyleAttributes().setHided(isHide);
            }
        }
    }

    public static void setLockFields(KDTable table, String[] fieldNames, boolean isLock) {
        if (fieldNames != null) {
            IColumn column = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                column = KDTableUtils.getColumn(table, fieldNames[i]);
                if (column == null) continue;
                column.getStyleAttributes().setLocked(isLock);
            }
        }
    }

    public static void setBigDecimalFieldsPrecision(int precision, KDTable table, String[] fieldNames) {
        if (fieldNames != null) {
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                KDTableUtils.setBigDecimalFieldsPrecisionByColumn(KDTableUtils.getColumn(table, fieldNames[i]), precision);
            }
        }
    }

    public static void setBigDecimalFieldsPrecision(int precision, KDTable table, String[] fieldNames, BigDecimal maxValue) {
        if (fieldNames != null) {
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                KDTableUtils.setBigDecimalFieldsPrecisionByColumn(KDTableUtils.getColumn(table, fieldNames[i]), precision, maxValue);
            }
        }
    }

    public static void setBigDecimalFieldsPrecision(int precision, KDTable table, int rowIndex, String[] fieldNames) {
        if (fieldNames != null) {
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                KDTableUtils.setBigDecimalFieldsPrecisionByCell(KDTableUtils.getCell(table, rowIndex, fieldNames[i]), precision);
            }
        }
    }

    public static void setBigDecimalFieldsPrecision(int precision, KDTable table, int rowIndex, String[] fieldNames, BigDecimal maxValue) {
        if (fieldNames != null) {
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                KDTableUtils.setBigDecimalFieldsPrecisionByCell(KDTableUtils.getCell(table, rowIndex, fieldNames[i]), precision, maxValue);
            }
        }
    }

    public static void setBigDecimalFieldsPrecisionByColumn(IColumn column, int precision) {
        if (column != null) {
            column.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)KDTableUtils.getBigDecimalTextField(precision, null)));
            column.getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)precision));
        }
    }

    public static void setBigDecimalFieldsPrecisionByColumn(IColumn column, int precision, BigDecimal maxValue) {
        if (column != null) {
            column.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)KDTableUtils.getBigDecimalTextField(precision, maxValue)));
            column.getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)precision));
        }
    }

    public static void setBigDecimalFieldsPrecisionByCell(ICell cell, int precision) {
        if (cell != null) {
            cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)KDTableUtils.getBigDecimalTextField(precision, null)));
            cell.getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)precision));
        }
    }

    public static void setBigDecimalFieldsPrecisionByCell(ICell cell, int precision, BigDecimal maxValue) {
        if (cell != null) {
            cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)KDTableUtils.getBigDecimalTextField(precision, maxValue)));
            cell.getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)precision));
            cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    public static KDFormattedTextField getBigDecimalTextField(int precision, BigDecimal maxValue) {
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(precision);
        colTxtField.setHorizontalAlignment(4);
        if (STQMUtils.isNotNull(maxValue)) {
            colTxtField.setMaximumValue((Comparable)maxValue);
        } else {
            colTxtField.setMaximumValue((Comparable)MAXVALUE);
        }
        return colTxtField;
    }

    public static void changeScrollBar(KDTable table) {
        table.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        table.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
    }

    public static void setFieldsHorizontalAlignment(Styles.HorizontalAlignment hAlign, KDTable table, String[] fieldNames) {
        if (fieldNames != null) {
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                KDTableUtils.getColumn(table, fieldNames[i]).getStyleAttributes().setHorizontalAlign(hAlign);
            }
        }
    }

    public static void setFreezeColumn(KDTable table, int[] columnIndexes) {
        if (table != null && columnIndexes != null) {
            int size = columnIndexes.length;
            for (int i = 0; i < size; ++i) {
                table.getViewManager().freeze(-1, columnIndexes[i]);
            }
        }
    }

    public static void setFreezeColumn(KDTable table, String[] fieldNames) {
        if (table != null && fieldNames != null) {
            IColumn column = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                column = KDTableUtils.getColumn(table, fieldNames[i]);
                if (column == null) continue;
                table.getViewManager().freeze(-1, column.getColumnIndex() + 1);
            }
        }
    }

    public static void setFreezeRow(KDTable table, int[] rowIndex) {
        if (table != null && rowIndex != null) {
            int size = rowIndex.length;
            for (int i = 0; i < size; ++i) {
                table.getViewManager().freeze(-1, rowIndex[i]);
            }
        }
    }

    public static void setColEditor(KDTable table, Map columnEditors) {
        if (table != null && columnEditors != null) {
            Iterator itor = columnEditors.keySet().iterator();
            Object key = null;
            Object editor = null;
            IColumn column = null;
            while (itor.hasNext()) {
                key = itor.next();
                if (key instanceof String) {
                    column = KDTableUtils.getColumn(table, key.toString());
                } else if (key instanceof Integer) {
                    column = KDTableUtils.getColumn(table, Integer.parseInt(key.toString()));
                }
                editor = columnEditors.get(key);
                if (column == null || !(editor instanceof IKDEditor)) continue;
                column.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)editor));
            }
        }
    }

    public static IObjectValue[] selectedInfosForTable(KDTable table, DataBinder dataBinder) {
        ArrayList arrayList;
        KDTSelectManager kdtSelectManager;
        IObjectValue[] infos = null;
        IObjectValue info = null;
        if (STQMUtils.isNotNull(table) && STQMUtils.isNotNull(kdtSelectManager = table.getSelectManager()) && STQMUtils.isNotNull(arrayList = kdtSelectManager.getBlocks()) && arrayList.size() > 0) {
            int entryCount = 0;
            int blockEntryCount = 0;
            for (int arrayListIndex = 0; arrayListIndex < arrayList.size(); ++arrayListIndex) {
                KDTSelectBlock kdtSelectBlock = (KDTSelectBlock)arrayList.get(arrayListIndex);
                blockEntryCount = kdtSelectBlock.getEndRow() - kdtSelectBlock.getBeginRow() + 1;
                entryCount += blockEntryCount;
            }
            infos = new IObjectValue[entryCount];
            int arrayIndex = 0;
            for (int arrayListIndex = 0; arrayListIndex < arrayList.size(); ++arrayListIndex) {
                KDTSelectBlock kdtSelectBlock = (KDTSelectBlock)arrayList.get(arrayListIndex);
                for (int rowIndex = kdtSelectBlock.getBeginRow(); rowIndex <= kdtSelectBlock.getEndRow(); ++rowIndex) {
                    dataBinder.storeLineFields(table, table.getRow(rowIndex), null);
                    Object o = table.getRow(rowIndex).getUserObject();
                    if (!(o instanceof AbstractObjectValue)) continue;
                    info = (IObjectValue)((AbstractObjectValue)o).clone();
                    infos[arrayIndex++] = info;
                }
            }
        }
        return infos;
    }

    public static void selectFirstRow(KDTable table) {
        if (STQMUtils.isNotNull(table) && table.getRow(0) != null) {
            table.getSelectManager().select(0, 0);
        }
    }

    public static void setAutoAddRow(KDTable table, boolean isClosed) {
        KDTableHelper.updateEnterWithTab((KDTable)table, (boolean)isClosed, null);
        KDTableHelper.downArrowAutoAddRow((KDTable)table, (boolean)isClosed, null);
    }

    public static boolean isRowBlankOnTable(KDTable detailTable, int row, String[] cols) throws Exception {
        if (detailTable == null) {
            throw new Exception(TABLENULLEXCEPTION);
        }
        if (cols == null) {
            return false;
        }
        for (int i = 0; i < cols.length; ++i) {
            if (!STQMUtils.isNotNull(detailTable.getCell(row, cols[i]).getValue())) continue;
            return false;
        }
        return true;
    }

    public static void removeLine(KDTable table, int rowIndex) {
        if (table == null) {
            return;
        }
        if (table.getRow(rowIndex) != null) {
            table.getSelectManager().select(rowIndex, 0, rowIndex, 0, 2);
            IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
            table.removeRow(rowIndex);
            IObjectCollection collection = (IObjectCollection)table.getUserObject();
            if (collection != null && detailData != null) {
                collection.removeObject(detailData);
            }
        }
    }

    public static IRow addLine(KDTable table) {
        if (table == null) {
            return null;
        }
        IRow row = table.addRow();
        return row;
    }

    public static void setKDTableColumnsMaxLength(KDTable table, HashMap columnNames) {
        if (STQMUtils.isNull(table) || STQMUtils.isNull(columnNames)) {
            return;
        }
        Iterator it = columnNames.keySet().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            String columnName = o.toString();
            KDTextField txtInput = new KDTextField();
            txtInput.setMaxLength(new BigDecimal(columnNames.get(columnName).toString()).intValue());
            table.getColumn(columnName).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtInput));
        }
    }

    public static void setKDTableColumnsMaxLength(KDTable table, String[] columnNames, int maxLength) {
        if (STQMUtils.isNull(table) || STQMUtils.isNull(columnNames) || maxLength <= 0) {
            return;
        }
        for (int i = 0; i < columnNames.length; ++i) {
            KDTextField txtInput = new KDTextField();
            txtInput.setMaxLength(maxLength);
            table.getColumn(columnNames[i]).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtInput));
        }
    }

    public static void setKDTableColumnsMaxValue(KDTable table, String[] columnNames, BigDecimal maxValue) {
        if (STQMUtils.isNull(table) || STQMUtils.isNull(columnNames)) {
            return;
        }
        for (int i = 0; i < columnNames.length; ++i) {
            KDFormattedTextField colTxtField = new KDFormattedTextField();
            colTxtField.setDataType(1);
            if (STQMUtils.isNotNull(maxValue)) {
                colTxtField.setMaximumValue((Comparable)maxValue);
            } else {
                colTxtField.setMaximumValue((Comparable)MAXVALUE);
            }
            IColumn column = KDTableUtils.getColumn(table, columnNames[i]);
            if (column == null) continue;
            column.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)colTxtField));
        }
    }

    public static void setPrecision(KDTable kdtTable, String materialColumnName, String unitColumnName, String[] qtyColumnName) throws EASBizException, BOSException {
        int rowCount = kdtTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            KDTableUtils.setPrecision(kdtTable, i, materialColumnName, unitColumnName, qtyColumnName);
        }
    }

    public static void setPrecision(KDTable kdtTable, int rowIndex, String materialColumnName, String unitColumnName, String[] qtyColumnName) throws EASBizException, BOSException {
        Object o = null;
        MaterialInfo materialInfo = null;
        o = kdtTable.getRow(rowIndex).getCell(materialColumnName).getValue();
        if (o instanceof MaterialInfo) {
            materialInfo = (MaterialInfo)o;
        }
        if (STUtils.isNotNull(materialInfo)) {
            int qtyPrecision = 2;
            MeasureUnitInfo measureUnitInfo = null;
            o = kdtTable.getRow(rowIndex).getCell(unitColumnName).getValue();
            if (o instanceof MeasureUnitInfo) {
                measureUnitInfo = (MeasureUnitInfo)o;
            }
            if (STUtils.isNotNull(measureUnitInfo)) {
                qtyPrecision = QtyMultiMeasureUtils.qtyPrecision(materialInfo, measureUnitInfo);
                KDTableUtils.setBigDecimalFieldsPrecision(qtyPrecision, kdtTable, rowIndex, qtyColumnName);
            }
        }
    }

    public static void setRequiredFields(KDTable table, String[] fieldNames, boolean isRequired) {
        if (fieldNames != null) {
            IColumn column = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                column = KDTableUtils.getColumn(table, fieldNames[i]);
                if (column == null) continue;
                column.setRequired(isRequired);
                column.getStyleAttributes().setBackground(isRequired ? STConstant.NECESSARYCOLOR : STConstant.UNNECESSARYCOLOR);
            }
        }
    }

    public static void setKDTableColumnsMinValue(KDTable table, String[] columnNames, BigDecimal minValue) {
        if (STQMUtils.isNull(table) || STQMUtils.isNull(columnNames)) {
            return;
        }
        for (int i = 0; i < columnNames.length; ++i) {
            KDFormattedTextField colTxtField = new KDFormattedTextField();
            colTxtField.setDataType(1);
            if (STQMUtils.isNotNull(minValue)) {
                colTxtField.setMinimumValue((Comparable)minValue);
            } else {
                colTxtField.setMinimumValue((Comparable)MINVALUE);
            }
            IColumn column = KDTableUtils.getColumn(table, columnNames[i]);
            if (column == null) continue;
            column.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)colTxtField));
        }
    }
}

