/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.cm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.cm.util.CSMF7Utils;
import com.kingdee.eas.basedata.cm.util.KDTableUtils;
import com.kingdee.eas.basedata.cm.util.MultiBaseDataProcessor;
import com.kingdee.eas.basedata.cm.util.QtyMultiMeasureUtils;
import com.kingdee.eas.basedata.cm.util.STUtils;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.st.basedata.client.MaterialCodeF7Utils;
import java.awt.Component;
import java.util.Map;

public class MultiMaterialProcessor
extends MultiBaseDataProcessor {
    public static final String MULTIUNITF7_PATH = "com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery";
    public static final int AUTOFILLEDCOLUMNCOUNT = 16;
    public static final int COLUMNINDEX_MATERIALNAME = 0;
    public static final int COLUMNINDEX_MODEL = 1;
    public static final int COLUMNINDEX_UNIT = 2;
    public static final int COLUMNINDEX_BASEUNIT = 3;
    public static final int COLUMNINDEX_QTY1 = 4;
    public static final int COLUMNINDEX_QTY2 = 5;
    public static final int COLUMNINDEX_QTY3 = 6;
    public static final int COLUMNINDEX_BASEQTY1 = 7;
    public static final int COLUMNINDEX_BASEQTY2 = 8;
    public static final int COLUMNINDEX_BASEQTY3 = 9;
    public static final int COLUMNINDEX_PRICE = 10;
    public static final int COLUMNINDEX_ASSISTUNIT = 11;
    public static final int COLUMNINDEX_ASSISTQTY1 = 12;
    public static final int COLUMNINDEX_ASSISTQTY2 = 13;
    public static final int COLUMNINDEX_ASSISTQTY3 = 14;
    public static final int COLUMNINDEX_MATERIALCODE = 15;
    private boolean isProcessPrecision = true;
    private KDTable materialTable = null;
    private boolean isClearQty = false;
    private OrgType mainBizOrgType = null;
    private OrgUnitInfo mainBizOrgUnitInfo = null;
    private Component owner = null;
    private String displayName = "$number$";

    private MultiMaterialProcessor(Component owner, KDTable materialTable) {
        super(materialTable);
        this.owner = owner;
        this.materialTable = materialTable;
        this.autoFilledColumnName = new String[16];
    }

    public static MultiMaterialProcessor getInstance(Component owner, KDTable materialTable, String columnName) throws Exception {
        return MultiMaterialProcessor.getInstance(owner, materialTable, columnName, null, null, false);
    }

    public static MultiMaterialProcessor getInstance(Component owner, KDTable materialTable, String columnName, OrgType mainBizOrgType, OrgUnitInfo mainBizOrgUnitInfo, boolean isClearQty) throws Exception {
        if (null == materialTable) {
            return null;
        }
        IColumn iColumn = materialTable.getColumn(columnName);
        return MultiMaterialProcessor.getInstance(owner, materialTable, iColumn, null, mainBizOrgType, mainBizOrgUnitInfo, isClearQty);
    }

    public static MultiMaterialProcessor getInstance(Component owner, KDTable materialTable, String columnName, OrgType mainBizOrgType, OrgUnitInfo mainBizOrgUnitInfo, boolean isClearQty, boolean isProcessPrecision) throws Exception {
        if (null == materialTable) {
            return null;
        }
        IColumn iColumn = materialTable.getColumn(columnName);
        MultiMaterialProcessor mmp2 = new MultiMaterialProcessor(owner, materialTable);
        mmp2.materialTable = materialTable;
        mmp2.multiBaseDataColumn = iColumn;
        mmp2.isClearQty = isClearQty;
        mmp2.mainBizOrgType = mainBizOrgType;
        mmp2.mainBizOrgUnitInfo = mainBizOrgUnitInfo;
        mmp2.isProcessPrecision = isProcessPrecision;
        return mmp2;
    }

    public static MultiMaterialProcessor getInstance(Component owner, KDTable materialTable, IColumn materialColumn) throws Exception {
        return MultiMaterialProcessor.getInstance(owner, materialTable, materialColumn, null);
    }

    public static MultiMaterialProcessor getInstance(Component owner, KDTable materialTable, IColumn materialColumn, OrgType mainBizOrgType, OrgUnitInfo mainBizOrgUnitInfo, boolean isClearQty) throws Exception {
        return MultiMaterialProcessor.getInstance(owner, materialTable, materialColumn, null, mainBizOrgType, mainBizOrgUnitInfo, isClearQty);
    }

    public static MultiMaterialProcessor getInstance(Component owner, KDTable materialTable, IColumn materialColumn, String queryInfo) throws Exception {
        return MultiMaterialProcessor.getInstance(owner, materialTable, materialColumn, queryInfo, null, null, false);
    }

    public static MultiMaterialProcessor getInstance(Component owner, KDTable materialTable, IColumn materialColumn, String queryInfo, OrgType mainBizOrgType, OrgUnitInfo mainBizOrgUnitInfo, boolean isClearQty) throws Exception {
        MultiMaterialProcessor mmp2 = new MultiMaterialProcessor(owner, materialTable);
        mmp2.materialTable = materialTable;
        mmp2.multiBaseDataColumn = materialColumn;
        mmp2.isClearQty = isClearQty;
        mmp2.mainBizOrgType = mainBizOrgType;
        mmp2.mainBizOrgUnitInfo = mainBizOrgUnitInfo;
        return mmp2;
    }

    protected void setBizF7(KDBizPromptBox bizBaseDataBox) {
        if (this.mainBizOrgType == null || this.mainBizOrgUnitInfo == null) {
            CSMF7Utils.setBizMaterialF7(bizBaseDataBox, this.owner, true, true, this.displayName);
        } else {
            CSMF7Utils.setBizMaterialF7(bizBaseDataBox, this.owner, this.mainBizOrgType, this.mainBizOrgUnitInfo, null, true, true, this.displayName);
        }
        this.autoFillTableData(false);
    }

    public void autoFillTableData(boolean isInitData) {
        if (this.materialTable == null) {
            return;
        }
        int count = this.materialTable.getRowCount();
        for (int rowIdx = 0; rowIdx < count; ++rowIdx) {
            ICell cellMaterial = this.materialTable.getRow(rowIdx).getCell(this.multiBaseDataColumn.getColumnIndex());
            Object o = cellMaterial.getValue();
            MaterialInfo material = null;
            if (!(o instanceof MaterialInfo)) {
                return;
            }
            material = (MaterialInfo)o;
            try {
                this.autoFillColumnData(rowIdx, (DataBaseInfo)material, isInitData);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected void beforeInsertEntries(KDTable table, int rowIdx) throws Exception {
        this.iMMP.beforeLoadEntryFields(this, table, rowIdx);
    }

    protected void afterInsertEntries(KDTable table, int rowIdx, DataBaseInfo[] dataBaseInfos, Map dataMap) throws Exception {
        int index = 0;
        int count = dataBaseInfos.length + rowIdx;
        for (int i = rowIdx; i < count; ++i) {
            this.autoFillColumnData(i, dataBaseInfos[index], true);
            this.iMMP.loadEntryFields(this, table, i);
            ++index;
        }
    }

    private void autoFillColumnData(int rowIdx, DataBaseInfo dataBase, boolean isInitData) throws BOSException, EASBizException {
        ICell cellMaterialCode;
        int qtyPrecision;
        ICell cellAssistUnit;
        ICell cellBaseUnit;
        ICell cellUnit;
        if (dataBase == null) {
            return;
        }
        MaterialInfo material = null;
        if (!(dataBase instanceof MaterialInfo)) {
            return;
        }
        material = (MaterialInfo)dataBase;
        MaterialInfo fullMaterialInfo = null;
        fullMaterialInfo = this.isProcessPrecision ? QtyMultiMeasureUtils.fullUnitMaterialInfo(material) : material;
        if (isInitData && this.getCell(rowIdx, 0) != null) {
            this.getCell(rowIdx, 0).setValue((Object)fullMaterialInfo.getName());
        }
        if (isInitData && this.getCell(rowIdx, 1) != null) {
            this.getCell(rowIdx, 1).setValue((Object)fullMaterialInfo.getModel());
        }
        if ((cellUnit = this.getCell(rowIdx, 2)) != null) {
            this.setMaterialUnitF7(fullMaterialInfo.getId().toString(), cellUnit);
            if (isInitData) {
                cellUnit.setValue((Object)fullMaterialInfo.getBaseUnit());
            }
        }
        if ((cellBaseUnit = this.getCell(rowIdx, 3)) != null) {
            this.setMaterialUnitF7(fullMaterialInfo.getId().toString(), cellBaseUnit);
            if (isInitData) {
                cellBaseUnit.setValue((Object)fullMaterialInfo.getBaseUnit());
            }
        }
        if ((cellAssistUnit = this.getCell(rowIdx, 11)) != null) {
            this.setMaterialUnitF7(fullMaterialInfo.getId().toString(), cellAssistUnit);
            if (isInitData) {
                cellBaseUnit.setValue((Object)fullMaterialInfo.getAssistUnit());
            }
        }
        if (this.getCell(rowIdx, 4) != null) {
            qtyPrecision = QtyMultiMeasureUtils.qtyPrecision(fullMaterialInfo, fullMaterialInfo.getBaseUnit());
            KDTableUtils.setBigDecimalFieldsPrecisionByCell(this.getCell(rowIdx, 4), qtyPrecision);
            if (isInitData && this.isClearQty) {
                this.getCell(rowIdx, 4).setValue(null);
            }
        }
        if (this.getCell(rowIdx, 5) != null) {
            qtyPrecision = QtyMultiMeasureUtils.qtyPrecision(fullMaterialInfo, fullMaterialInfo.getBaseUnit());
            KDTableUtils.setBigDecimalFieldsPrecisionByCell(this.getCell(rowIdx, 5), qtyPrecision);
            if (isInitData && this.isClearQty) {
                this.getCell(rowIdx, 5).setValue(null);
            }
        }
        if (this.getCell(rowIdx, 6) != null) {
            qtyPrecision = QtyMultiMeasureUtils.qtyPrecision(fullMaterialInfo, fullMaterialInfo.getBaseUnit());
            KDTableUtils.setBigDecimalFieldsPrecisionByCell(this.getCell(rowIdx, 6), qtyPrecision);
            if (isInitData && this.isClearQty) {
                this.getCell(rowIdx, 6).setValue(null);
            }
        }
        if (this.getCell(rowIdx, 7) != null) {
            qtyPrecision = QtyMultiMeasureUtils.qtyPrecision(fullMaterialInfo, fullMaterialInfo.getBaseUnit());
            KDTableUtils.setBigDecimalFieldsPrecisionByCell(this.getCell(rowIdx, 7), qtyPrecision);
            if (isInitData && this.isClearQty) {
                this.getCell(rowIdx, 7).setValue(null);
            }
        }
        if (this.getCell(rowIdx, 8) != null) {
            qtyPrecision = QtyMultiMeasureUtils.qtyPrecision(fullMaterialInfo, fullMaterialInfo.getBaseUnit());
            KDTableUtils.setBigDecimalFieldsPrecisionByCell(this.getCell(rowIdx, 8), qtyPrecision);
            if (isInitData && this.isClearQty) {
                this.getCell(rowIdx, 8).setValue(null);
            }
        }
        if (this.getCell(rowIdx, 9) != null) {
            qtyPrecision = QtyMultiMeasureUtils.qtyPrecision(fullMaterialInfo, fullMaterialInfo.getBaseUnit());
            KDTableUtils.setBigDecimalFieldsPrecisionByCell(this.getCell(rowIdx, 9), qtyPrecision);
            if (isInitData && this.isClearQty) {
                this.getCell(rowIdx, 9).setValue(null);
            }
        }
        if (this.getCell(rowIdx, 12) != null) {
            qtyPrecision = QtyMultiMeasureUtils.qtyPrecision(fullMaterialInfo, fullMaterialInfo.getAssistUnit());
            KDTableUtils.setBigDecimalFieldsPrecisionByCell(this.getCell(rowIdx, 12), qtyPrecision);
            if (isInitData && this.isClearQty) {
                this.getCell(rowIdx, 12).setValue(null);
            }
        }
        if (this.getCell(rowIdx, 13) != null) {
            qtyPrecision = QtyMultiMeasureUtils.qtyPrecision(fullMaterialInfo, fullMaterialInfo.getAssistUnit());
            KDTableUtils.setBigDecimalFieldsPrecisionByCell(this.getCell(rowIdx, 13), qtyPrecision);
            if (isInitData && this.isClearQty) {
                this.getCell(rowIdx, 13).setValue(null);
            }
        }
        if (this.getCell(rowIdx, 14) != null) {
            qtyPrecision = QtyMultiMeasureUtils.qtyPrecision(fullMaterialInfo, fullMaterialInfo.getAssistUnit());
            KDTableUtils.setBigDecimalFieldsPrecisionByCell(this.getCell(rowIdx, 14), qtyPrecision);
            if (isInitData && this.isClearQty) {
                this.getCell(rowIdx, 14).setValue(null);
            }
        }
        if (this.getCell(rowIdx, 10) != null) {
            KDTableUtils.setBigDecimalFieldsPrecisionByCell(this.getCell(rowIdx, 10), fullMaterialInfo.getPricePrecision());
        }
        if ((cellMaterialCode = this.getCell(rowIdx, 15)) != null) {
            this.setMaterialCodeF7(fullMaterialInfo, cellMaterialCode, isInitData);
        }
    }

    private ICell getCell(int rowIdx, int columnIndex) {
        ICell iCell = null;
        String columnName = this.autoFilledColumnName[columnIndex];
        if (columnName != null) {
            iCell = this.materialTable.getRow(rowIdx).getCell(columnName);
        }
        return iCell;
    }

    private void setMaterialUnitF7(String materialId, ICell cellUnit) {
        KDBizPromptBox bizUnitBox = new KDBizPromptBox();
        bizUnitBox.setQueryInfo(MULTIUNITF7_PATH);
        bizUnitBox.setEditFormat("$number$");
        bizUnitBox.setDisplayFormat("$name$");
        bizUnitBox.setCommitFormat("$number$");
        this.setF7MeasureUnit(bizUnitBox, materialId);
        cellUnit.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizUnitBox));
    }

    private void setMaterialCodeF7(MaterialInfo material, ICell cellMaterialCode, boolean isInitData) throws BOSException {
        if (STUtils.isNotNull(material)) {
            KDBizPromptBox materialCodeF7 = null;
            materialCodeF7 = MaterialCodeF7Utils.getMaterialCodeF7((MaterialInfo)material);
            if (isInitData) {
                cellMaterialCode.setValue(materialCodeF7.getValue());
            }
            cellMaterialCode.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)materialCodeF7));
        }
    }

    private void setF7MeasureUnit(KDBizPromptBox bizBox, String materialId) {
        if (materialId != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
            filterInfo.setMaskString("#0");
            viewInfo.setFilter(filterInfo);
            bizBox.setEntityViewInfo(viewInfo);
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }
}

