/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.common.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.service.job.IJobService;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobEvent;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.service.job.util.IListener;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.job.JobStateEnum;
import com.kingdee.eas.base.job.app.JobServiceUIFacade;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.common.perf.JobInstExtFactory;
import com.kingdee.eas.basedata.common.perf.JobInstExtInfo;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgCollection;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgFactory;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgInfo;
import com.kingdee.eas.basedata.common.perf.PerfSepException;
import com.kingdee.eas.basedata.common.perf.app.AbstractCreateJobFacadeControllerBean;
import com.kingdee.eas.basedata.common.perf.app.JobQueueStatusRefresh;
import com.kingdee.eas.basedata.common.perf.app.JobStateChangeListener;
import com.kingdee.eas.basedata.common.perf.app.TaskEndListener;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CreateJobFacadeControllerBean
extends AbstractCreateJobFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.common.perf.app.CreateJobFacadeControllerBean");
    private static final String JOBINSTEXT_BOSTYPE = "6F70A51B";
    Map serverMap = null;

    @Override
    protected Object _executeJob(Context ctx, JobConfig jobCfg, Object param) throws BOSException, EASBizException {
        PerfSepCfgCollection psColl;
        if (jobCfg == null) {
            return Collections.EMPTY_MAP;
        }
        String num = jobCfg.getNumber();
        ctx.put((Object)"jobNumber", (Object)num);
        if (StringUtils.isEmpty((String)num)) {
            return Collections.EMPTY_MAP;
        }
        if (param != null && param instanceof Object[]) {
            int paramCount = ((Object[])param).length;
            Object[] newParam = new Object[paramCount + 1];
            for (int i = 0; i < paramCount; ++i) {
                newParam[i] = ((Object[])param)[i];
            }
            ctx.remove((Object)"ServerTimeZone");
            ctx.remove((Object)"messageRefreshTime");
            ctx.remove((Object)"creator");
            ctx.remove((Object)"MyEasSettings");
            ctx.remove((Object)"usedToolStyle");
            ctx.remove((Object)"openModel");
            ctx.remove((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.common.perf.PERFAutoGenerateResource", (String)"0_CreateJobFacadeControllerBean", (Locale)ctx.getLocale()));
            ctx.remove((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.common.perf.PERFAutoGenerateResource", (String)"1_CreateJobFacadeControllerBean", (Locale)ctx.getLocale()));
            ctx.remove((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.common.perf.PERFAutoGenerateResource", (String)"2_CreateJobFacadeControllerBean", (Locale)ctx.getLocale()));
            ctx.remove((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.common.perf.PERFAutoGenerateResource", (String)"3_CreateJobFacadeControllerBean", (Locale)ctx.getLocale()));
            ctx.remove((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.common.perf.PERFAutoGenerateResource", (String)"4_CreateJobFacadeControllerBean", (Locale)ctx.getLocale()));
            ctx.remove((Object)"USBKEY_LOGIN");
            ctx.remove((Object)"QueryServiceURL");
            ctx.remove((Object)"menuCache");
            ctx.remove((Object)"ClientIP");
            ctx.remove((Object)"ClientName");
            ctx.remove((Object)"locals");
            ctx.remove((Object)"OrgUnits");
            ctx.remove((Object)"IsDemoVersion");
            ctx.remove((Object)"dbTypeCode");
            ctx.remove((Object)"CurCompanyId");
            ctx.remove((Object)"6C12B689getValuejava.lang.String");
            ctx.remove((Object)"SwitchToNewLoginFlow");
            newParam[paramCount] = ctx;
            param = newParam;
        }
        if ((psColl = PerfSepCfgFactory.getLocalInstance(ctx).getPerfSepCfgCollection("where number = '" + num + "'")) == null || psColl.size() <= 0) {
            return Collections.EMPTY_MAP;
        }
        PerfSepCfgInfo psInfo = psColl.get(0);
        if (psInfo == null || StringUtils.isEmpty((String)psInfo.getHandler())) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("isStart", new Boolean(psInfo.isIsStart()));
        if (psInfo.isIsStart()) {
            if ((jobCfg = this.createJobCfg(ctx, jobCfg, psInfo)).isNeedCheckTaskType()) {
                boolean hasRunningCommonTask = false;
                try {
                    hasRunningCommonTask = this.checkTask(ctx, jobCfg.getTaskType());
                }
                catch (SQLException exp) {
                    logger.error((Object)exp);
                    throw new BOSException(exp.getMessage(), (Throwable)exp);
                }
                if (hasRunningCommonTask) {
                    throw new PerfSepException(PerfSepException.DUPLICATE_TASK);
                }
            }
            String jobInstExtId = BOSUuid.create((String)JOBINSTEXT_BOSTYPE).toString();
            this.createJobInstExt(ctx, jobCfg, jobInstExtId);
            map.put("jobInstExtId", jobInstExtId);
            String jobId = this.createJob(ctx, jobCfg, param, jobInstExtId);
            Object result = null;
            map.put("isSyn", new Boolean(jobCfg.isSyn()));
            if (!jobCfg.isSyn()) {
                result = this.pollJobState(jobId, ctx);
            }
            map.put("result", result);
            return map;
        }
        IJobHandler jobHandler = null;
        try {
            Class<?> handlerClass = Class.forName(psInfo.getHandler());
            if (!IJobHandler.class.isAssignableFrom(handlerClass)) {
                return null;
            }
            jobHandler = (IJobHandler)handlerClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        Job job = new Job(ctx, jobHandler, (Object)param);
        Object result = null;
        try {
            result = jobHandler.execute(job);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        map.put("result", result);
        return map;
    }

    private String createJobInstExt(Context ctx, JobConfig jobCfg, String jobInstExtId) throws EASBizException, BOSException {
        if (null == jobCfg) {
            return null;
        }
        JobInstExtInfo jobInstExtInfo = new JobInstExtInfo();
        jobInstExtInfo.setId(BOSUuid.read((String)jobInstExtId));
        jobInstExtInfo.setTitle(jobCfg.getTitle());
        jobInstExtInfo.setUserid(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        Timestamp now = new Timestamp(System.currentTimeMillis());
        jobInstExtInfo.setStateChangedTime(now);
        jobInstExtInfo.setState(JobStateEnum.CREATED);
        jobInstExtInfo.setStartedTime(now);
        jobInstExtInfo.setProgress((short)0);
        jobInstExtInfo.setJobType((short)0);
        jobInstExtInfo.setCreatedTime(now);
        IObjectPK pk = JobInstExtFactory.getLocalInstance(ctx).addnew(jobInstExtInfo);
        if (null != pk) {
            return pk.toString();
        }
        return null;
    }

    private String createJob(Context ctx, JobConfig jobCfg, Object params, String jobInstExtId) throws BOSException {
        JobInstanceConfig jobInstance = new JobInstanceConfig((IJobHandler)jobCfg.getiHandler(), true, jobCfg.isSmallJob(), jobCfg.getPriority(), jobCfg.getMutex(), jobCfg.getViewerUI(), JobIsolationLevel.Server, jobCfg.getThreadName(), jobCfg.getThreadCount());
        try {
            this.addListener(jobInstance, jobInstExtId);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        Timestamp scheduledTime = new Timestamp(System.currentTimeMillis());
        Job job = new Job(ctx, jobCfg.getTitle(), jobInstance, params, scheduledTime, null, -1, jobCfg.getServer());
        try {
            this.addNewTask(ctx, job.getId(), jobCfg);
        }
        catch (SQLException exp) {
            logger.error((Object)exp);
            throw new BOSException(exp.getMessage(), (Throwable)exp);
        }
        JobManager.instance().add(job);
        return job.getId();
    }

    private void addListener(JobInstanceConfig jobInst, String jobInstExtId) throws Exception {
        jobInst.addEventListener(JobEvent.OnStateChange, (IListener)new JobStateChangeListener(jobInstExtId));
        TaskEndListener listener = new TaskEndListener();
        jobInst.addEventListener(JobEvent.OnAborted, (IListener)listener);
        jobInst.addEventListener(JobEvent.OnMissed, (IListener)listener);
        jobInst.addEventListener(JobEvent.OnEnd, (IListener)listener);
    }

    private JobConfig createJobCfg(Context ctx, JobConfig jobCfg, PerfSepCfgInfo psInfo) throws BOSException {
        if (jobCfg == null) {
            jobCfg = new JobConfig();
        }
        if (StringUtils.isEmpty((String)jobCfg.getTitle())) {
            jobCfg.setTitle(psInfo.getName() + "_" + psInfo.getNumber());
        } else {
            jobCfg.setTitle(psInfo.getName() + "_" + jobCfg.getTitle());
        }
        jobCfg.setDescription(psInfo.getDescription());
        try {
            Class<?> handlerClass = Class.forName(psInfo.getHandler());
            if (!IJobHandler.class.isAssignableFrom(handlerClass)) {
                return null;
            }
            IJobHandler jobHandler = (IJobHandler)handlerClass.newInstance();
            jobCfg.setiHandler(jobHandler);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        catch (InstantiationException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        jobCfg.setSyn(true);
        jobCfg.setPriority(psInfo.getPriority());
        String server = psInfo.getServer();
        jobCfg.setServer(server);
        jobCfg.setThreadCount(psInfo.getContwholeCount());
        if (psInfo.getContwholeCount() < 1) {
            jobCfg.setMutex(psInfo.getTxtTaskSign());
            jobCfg.setThreadName(null);
        } else {
            jobCfg.setThreadName(psInfo.getTxtTaskSign());
            jobCfg.setMutex(null);
        }
        jobCfg.setViewerUI(psInfo.getViewerUI());
        jobCfg.setSmallJob(psInfo.isIsSmallTransaction());
        return jobCfg;
    }

    private Object pollJobState(String jobId, Context ctx) throws BOSException {
        boolean isInterrupted;
        boolean isFailed;
        Job completeJob;
        block7: {
            if (jobId == null) {
                return null;
            }
            completeJob = null;
            IJobService jobService = JobServiceFactory.getLocalInstance((Context)ctx);
            isFailed = false;
            isInterrupted = false;
            try {
                do {
                    Thread.sleep(7000L);
                    completeJob = jobService.getJobInstance(jobId);
                    if (completeJob != null) continue;
                    isFailed = true;
                    break block7;
                } while (!JobState.Complete.equals((Object)completeJob.getState()) && !JobState.Failed.equals((Object)completeJob.getState()));
                if (JobState.Failed.equals((Object)completeJob.getState())) {
                    isFailed = true;
                    String exceptionStr = completeJob.getException();
                    if (exceptionStr != null && exceptionStr.trim().length() > 0) {
                        throw new BOSException(exceptionStr);
                    }
                }
            }
            catch (InterruptedException e) {
                isInterrupted = true;
                logger.error((Object)e);
                JobLog log = new JobLog(JobLog.Type.Error, e.getMessage());
                if (null == completeJob) break block7;
                completeJob.saveMessage(log);
            }
        }
        if (isInterrupted || isFailed) {
            return null;
        }
        return completeJob.getResult();
    }

    private void loadClusterConfig() throws BOSException {
        if (this.serverMap != null) {
            return;
        }
        this.serverMap = new HashMap();
        String clusterPath = System.getProperty("EAS_HOME") + "/server/cluster/ormrpc_loadbalance.properties";
        File file = new File(clusterPath);
        if (!file.exists()) {
            throw new BOSException("ormrpc_loadbalance.properties not exists,please call Administrator !");
        }
        Properties propertie = new Properties();
        FileInputStream inputFile = null;
        try {
            inputFile = new FileInputStream(file);
            propertie.load(inputFile);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"ormrpc_loadbalance.properties not found", (Throwable)e);
            throw new BOSException(e.getMessage(), e.getCause());
        }
        catch (IOException e) {
            logger.error((Object)"ormrpc_loadbalance.properties load failded", (Throwable)e);
            throw new BOSException(e.getMessage(), e.getCause());
        }
        finally {
            if (null != inputFile) {
                try {
                    inputFile.close();
                }
                catch (IOException e) {
                    logger.error((Object)"close file  failded! ", (Throwable)e);
                }
            }
        }
        this.initServerMap(propertie);
    }

    private void initServerMap(Properties propertie) {
        Iterator<Map.Entry<Object, Object>> iterator = propertie.entrySet().iterator();
        ArrayList<String> nameList = new ArrayList<String>();
        String expression = "loadbalance.\\d+.name";
        Pattern p = Pattern.compile(expression);
        Matcher m = null;
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> e = iterator.next();
            m = p.matcher(e.getKey().toString());
            if (!m.find()) continue;
            nameList.add(e.getKey().toString());
        }
        for (int i = 0; i < nameList.size(); ++i) {
            String serverName = (String)nameList.get(i);
            String serverTcpStr = (String)propertie.get(serverName.replace(".name", ""));
            if (serverTcpStr == null) continue;
            String ipStr = "";
            if (serverTcpStr.indexOf(":") > -1 && serverTcpStr.indexOf(":") < serverTcpStr.length()) {
                ipStr = serverTcpStr.split(":")[1];
                ipStr = ipStr.replace("/", "");
            }
            String serverAddr = propertie.get(serverName) + "@" + ipStr;
            String capability = (String)propertie.get(serverName.replace(".name", "") + ".capability");
            if (capability == null || Integer.parseInt(capability) == 0) continue;
            this.serverMap.put(serverAddr, capability);
            logger.info((Object)(serverAddr + "=" + capability + "**********"));
        }
    }

    private Map getRunningServerMap(Context ctx) throws BOSException {
        HashMap<String, Integer> runMap = new HashMap<String, Integer>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select count(FIsolationBoundary) count, FIsolationBoundary sv ");
        sql.append(" from t_job_inst where FState in('Running','Ready','Created','ReScheduled','Waiting') ");
        sql.append(" and FIsolationBoundary is not null group by FIsolationBoundary order by count asc");
        Connection conn = null;
        ResultSet rs = null;
        Statement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String s = sql.toString();
            statement = conn.createStatement();
            rs = statement.executeQuery(s);
            while (rs.next()) {
                String server = rs.getString("sv");
                if (StringUtils.isEmpty((String)server)) continue;
                runMap.put(server, new Integer(rs.getInt("count")));
            }
        }
        catch (Exception ex) {
            try {
                logger.warn((Object)"load running server info failded", (Throwable)ex);
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return runMap;
    }

    private String getServer(Context ctx) throws BOSException {
        int i;
        ArrayList allSevList = new JobServiceUIFacade(ctx).getJobServiceInstanceKeys();
        this.loadClusterConfig();
        ArrayList serverList = new ArrayList(this.serverMap.entrySet());
        Collections.sort(serverList, new Comparator(){

            public int compare(Object o1, Object o2) {
                Map.Entry obj1 = (Map.Entry)o1;
                Map.Entry obj2 = (Map.Entry)o2;
                return ((String)obj2.getValue()).compareTo((String)obj1.getValue());
            }
        });
        Map runMap = this.getRunningServerMap(ctx);
        for (i = 0; i < serverList.size(); ++i) {
            String server = (String)((Map.Entry)serverList.get(i)).getKey();
            if (runMap.get(server.toString()) != null) continue;
            return server.toString();
        }
        for (i = 0; i < serverList.size(); ++i) {
            String server1 = (String)((Map.Entry)serverList.get(i)).getKey();
            Integer runCount1 = (Integer)runMap.get(server1);
            if (runCount1 == null || runCount1.equals(new Integer(0))) {
                return server1;
            }
            if (i + 1 >= serverList.size()) {
                return server1;
            }
            String server2 = (String)((Map.Entry)serverList.get(i + 1)).getKey();
            Integer runCount2 = (Integer)runMap.get(server2);
            if (runCount2 == null || runCount2.equals(new Integer(0))) {
                return server2;
            }
            BigDecimal server1Capability = new BigDecimal((String)this.serverMap.get(server1));
            BigDecimal server2Capability = new BigDecimal((String)this.serverMap.get(server2));
            BigDecimal run1Capability = new BigDecimal(runCount1);
            BigDecimal run2Capability = new BigDecimal(runCount2);
            if (server1Capability.divide(server2Capability, 4, RoundingMode.HALF_DOWN).compareTo(run1Capability.divide(run2Capability, 4, RoundingMode.HALF_DOWN)) < 0) continue;
            return server1;
        }
        if (allSevList.size() > 0) {
            SecureRandom r = new SecureRandom();
            int idx = r.nextInt(allSevList.size());
            if (idx >= allSevList.size()) {
                idx %= allSevList.size();
            }
            return allSevList.get(idx).toString();
        }
        return null;
    }

    @Override
    protected boolean _checkDuplicateTask(Context ctx, String taskType) throws BOSException, EASBizException {
        try {
            return this.checkTask(ctx, taskType);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkTask(Context ctx, String taskType) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block4: {
            boolean bl;
            if (taskType == null || taskType.trim().length() <= 0) {
                return false;
            }
            String sql = "select fjobid from t_bd_perfSepTask where FTaskType = ? and FState = 0";
            conn = null;
            ps = null;
            rs = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                ps = conn.prepareStatement(sql);
                ps.setString(1, taskType);
                rs = ps.executeQuery();
                if (!rs.next()) break block4;
                bl = true;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
            return bl;
        }
        boolean bl = false;
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewTask(Context ctx, String jobId, JobConfig jc) throws SQLException {
        if (StringUtils.isEmpty((String)jobId) || StringUtils.isEmpty((String)jc.getTaskType())) {
            return;
        }
        String sql = "insert into t_bd_perfSepTask(FTaskType,FName,FJobId,FState,FCreateDate) values(?,?,?,?,?)";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            String title = jc.getTitle();
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, jc.getTaskType());
            if (title == null) {
                ps.setNull(2, 12);
            } else {
                if (title.length() > 200) {
                    title = title.substring(0, 200);
                }
                ps.setString(2, title);
            }
            ps.setString(3, jobId);
            ps.setInt(4, 0);
            ps.setDate(5, new Date(System.currentTimeMillis()));
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(ps, conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    @Override
    protected Map _executeJob(Context ctx, JobParam jobParam, JobConfig jobCfg) throws BOSException, EASBizException {
        if (jobCfg == null || jobParam == null) {
            return Collections.EMPTY_MAP;
        }
        String num = jobCfg.getNumber();
        if (StringUtils.isEmpty((String)num)) {
            return Collections.EMPTY_MAP;
        }
        jobParam.setJobNumber(num);
        PerfSepCfgCollection psColl = PerfSepCfgFactory.getLocalInstance(ctx).getPerfSepCfgCollection("where number = '" + num + "'");
        if (psColl == null || psColl.size() <= 0) {
            return Collections.EMPTY_MAP;
        }
        PerfSepCfgInfo psInfo = psColl.get(0);
        if (psInfo == null || StringUtils.isEmpty((String)psInfo.getHandler())) {
            return Collections.EMPTY_MAP;
        }
        jobParam.setLocale(ctx.getLocale());
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("isStart", new Boolean(psInfo.isIsStart()));
        if (psInfo.isIsStart()) {
            if ((jobCfg = this.createJobCfg(ctx, jobCfg, psInfo)).isNeedCheckTaskType()) {
                boolean hasRunningCommonTask = false;
                try {
                    hasRunningCommonTask = this.checkTask(ctx, jobCfg.getTaskType());
                }
                catch (SQLException exp) {
                    logger.error((Object)exp);
                    throw new BOSException(exp.getMessage(), (Throwable)exp);
                }
                if (hasRunningCommonTask) {
                    throw new PerfSepException(PerfSepException.DUPLICATE_TASK);
                }
            }
            String jobInstExtId = BOSUuid.create((String)JOBINSTEXT_BOSTYPE).toString();
            jobParam.setJobId(jobInstExtId);
            this.createJobInstExt(ctx, jobCfg, jobInstExtId);
            map.put("jobInstExtId", jobInstExtId);
            String jobId = this.createJob(ctx, jobCfg, jobParam, jobInstExtId);
            JobQueueStatusRefresh.refreshAfterCreated(ctx);
            Object result = null;
            map.put("isSyn", new Boolean(jobCfg.isSyn()));
            if (!jobCfg.isSyn()) {
                result = this.pollJobState(jobId, ctx);
            }
            map.put("result", result);
            return map;
        }
        IJobHandler jobHandler = null;
        try {
            Class<?> handlerClass = Class.forName(psInfo.getHandler());
            if (!IJobHandler.class.isAssignableFrom(handlerClass)) {
                return null;
            }
            jobHandler = (IJobHandler)handlerClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        Job job = new Job(ctx, jobHandler, (Object)jobParam);
        Object result = null;
        try {
            result = jobHandler.execute(job);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        map.put("result", result);
        return map;
    }
}

