/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.common.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.job.JobStateEnum;
import com.kingdee.eas.basedata.common.perf.JobInstExtCollection;
import com.kingdee.eas.basedata.common.perf.JobInstExtInfo;
import com.kingdee.eas.basedata.common.perf.PerfSepException;
import com.kingdee.eas.basedata.common.perf.app.AbstractJobInstExtControllerBean;
import com.kingdee.eas.basedata.common.perf.app.JobQueueStatusRefresh;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class JobInstExtControllerBean
extends AbstractJobInstExtControllerBean {
    private static final long serialVersionUID = -4451896419216779453L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.common.perf.app.JobInstExtControllerBean");

    @Override
    protected void _dump(Context ctx, List ids) throws BOSException {
        if (ids == null || ids.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into T_BD_JobInstExtHst ");
        sql.append(" ( FID,FJobInstId,FUserid,FCreatedTime,FStartedTime,FState,FStateChangedTime,FProgress,FJobType,FTitle,FProgressDetail_l1,FProgressDetail_l2,FProgressDetail_l3,fpriority) ");
        sql.append(" select  FID,FJobInstId,FUserid,FCreatedTime,FStartedTime,FState,FStateChangedTime,FProgress,FJobType,FTitle,FProgressDetail_l1,FProgressDetail_l2,FProgressDetail_l3,fpriority");
        sql.append(" from T_BD_JobInstExt where fid in (").append(this.concat(ids)).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("delete from T_BD_JobInstExt where fid in( ").append(this.concat(ids)).append(" )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected int _cancel(Context ctx, List ids) throws BOSException, EASBizException {
        if (null == ids || ids.size() == 0) {
            return -1;
        }
        JobInstExtCollection col = this.getJobInstExtCollection(ctx, ids, new String[]{"id", "jobInstId", "jobType"});
        List asyncJobIds = this.getJobIdListByJobType(col, 0);
        List syncJobIds = this.getJobIdListByJobType(col, 1);
        int result = 0;
        if (asyncJobIds.size() > 0) {
            try {
                result += JobServiceFactory.getLocalInstance((Context)ctx).abort(this.list2Array(asyncJobIds));
            }
            catch (BOSException e) {
                logger.warn((Object)"\u8c03\u5ea6\u5e73\u53f0\u53d6\u6d88\u4efb\u52a1\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                throw new PerfSepException(PerfSepException.RUNNING_OR_END_JOB_CANNOT_ABORT);
            }
        }
        if (syncJobIds.size() > 0) {
            StringBuffer sql = new StringBuffer();
            sql.append(" update T_BD_JOBINSTEXT set fstate='").append(JobState.Aborted).append("',fstatechangedtime=now() ").append(" where fjobinstid in (").append(this.concat(syncJobIds)).append(") and fstate in('").append(JobState.Created).append("','").append(JobState.ReScheduled).append("','").append(JobState.Ready).append("','").append(JobState.Waiting).append("')");
            ArrayList<String> sqls = new ArrayList<String>();
            sqls.add(sql.toString());
            int[] ret = DbUtil.executeBatch((Context)ctx, sqls);
            result += ret[0];
        }
        return result;
    }

    @Override
    protected void _top(Context ctx, String id) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)id)) {
            throw new IllegalArgumentException("id must be not null!");
        }
        ObjectStringPK pk = new ObjectStringPK(id);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("jobInstId");
        selector.add("jobType");
        JobInstExtInfo info = this.getJobInstExtInfo(ctx, (IObjectPK)pk, selector);
        if (null == info || info.getJobType() == 1) {
            throw new PerfSepException(PerfSepException.REPORT_CANNOT_RESCHEDULE);
        }
        try {
            boolean result = JobServiceFactory.getLocalInstance((Context)ctx).reschedule(info.getJobInstId(), -1000000);
            if (!result) {
                throw new PerfSepException(PerfSepException.STATEISCHANGED);
            }
            JobQueueStatusRefresh.refreshAfterReschedule(ctx);
        }
        catch (BOSException e) {
            throw new PerfSepException(PerfSepException.STATEISCHANGED);
        }
    }

    private List getJobIdListByJobType(JobInstExtCollection col, int jobType) {
        ArrayList<String> retList = new ArrayList<String>();
        int size = col.size();
        block4: for (int i = 0; i < size; ++i) {
            JobInstExtInfo info = col.get(i);
            switch (jobType) {
                case 0: {
                    if (info.getJobType() != jobType) continue block4;
                    retList.add(info.getJobInstId());
                    continue block4;
                }
                case 1: {
                    if (info.getJobType() != jobType) continue block4;
                    retList.add(info.getId().toString());
                    continue block4;
                }
            }
        }
        return retList;
    }

    private JobInstExtCollection getJobInstExtCollection(Context ctx, List idList, String[] selectFields) throws BOSException {
        HashSet idSet = new HashSet();
        idSet.addAll(idList);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selectors = new SelectorItemCollection();
        int len = selectFields.length;
        for (int i = 0; i < len; ++i) {
            selectors.add(selectFields[i]);
        }
        view.setSelector(selectors);
        return super.getJobInstExtCollection(ctx, view);
    }

    private String concat(List ids) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ids.size(); ++i) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("'").append(ids.get(i)).append("'");
        }
        return sb.toString();
    }

    private String[] list2Array(List list) {
        if (list == null) {
            return new String[0];
        }
        String[] result = new String[list.size()];
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            result[i] = (String)list.get(i);
        }
        return result;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        JobInstExtInfo jobInfo = (JobInstExtInfo)model;
        if (StringUtils.isEmpty((String)jobInfo.getUserid())) {
            jobInfo.setUserid(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        }
        if (null == jobInfo.getCreatedTime()) {
            jobInfo.setCreatedTime(new Timestamp(System.currentTimeMillis()));
        }
        if (null == jobInfo.getStartedTime()) {
            jobInfo.setStartedTime(new Timestamp(System.currentTimeMillis()));
        }
        if (null == jobInfo.getStateChangedTime()) {
            jobInfo.setStateChangedTime(new Timestamp(System.currentTimeMillis()));
        }
        if (null == jobInfo.getState()) {
            jobInfo.setState(JobStateEnum.CREATED);
        }
        if (jobInfo.getProgress() > 100 || jobInfo.getProgress() <= 0) {
            jobInfo.setProgress((short)0);
            jobInfo.setProgressDetail("", new Locale("l1"));
            jobInfo.setProgressDetail("", new Locale("l2"));
            jobInfo.setProgressDetail("", new Locale("l3"));
        }
        return super._save(ctx, (IObjectValue)jobInfo);
    }

    @Override
    protected void _reschedule(Context ctx, String id, String serverid, int prority, Date scheduleDate) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("jobType");
        selector.add("jobInstId");
        JobInstExtInfo jobInfo = this.getJobInstExtInfo(ctx, (IObjectPK)new ObjectStringPK(id), selector);
        if (jobInfo == null || jobInfo.getJobType() == 1) {
            throw new PerfSepException(PerfSepException.REPORT_CANNOT_RESCHEDULE);
        }
        if (prority == -1) {
            prority = Integer.MIN_VALUE;
        }
        try {
            if (null != scheduleDate) {
                if (StringUtils.isEmpty((String)serverid)) {
                    JobServiceFactory.getLocalInstance((Context)ctx).reschedule(jobInfo.getJobInstId(), prority, scheduleDate);
                } else {
                    JobServiceFactory.getLocalInstance((Context)ctx).reschedule(jobInfo.getJobInstId(), prority, scheduleDate, serverid);
                }
                JobQueueStatusRefresh.refreshAfterReschedule(ctx);
            }
        }
        catch (BOSException e) {
            throw new PerfSepException(PerfSepException.STATEISCHANGED);
        }
    }

    @Override
    protected void _delay(Context ctx, String id, Date scheduleDate) throws BOSException, EASBizException {
        if (null == scheduleDate || scheduleDate.getTime() - System.currentTimeMillis() < 300000L) {
            throw new PerfSepException(PerfSepException.SCHEDULE_TIME_AFTER_5MIN);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("jobType");
        selector.add("jobInstId");
        JobInstExtInfo jobInfo = this.getJobInstExtInfo(ctx, (IObjectPK)new ObjectStringPK(id), selector);
        if (jobInfo == null || jobInfo.getJobType() == 1) {
            throw new PerfSepException(PerfSepException.REPORT_CANNOT_RESCHEDULE);
        }
        try {
            boolean result = JobServiceFactory.getLocalInstance((Context)ctx).reschedule(jobInfo.getJobInstId(), 500, scheduleDate);
            if (!result) {
                throw new PerfSepException(PerfSepException.STATEISCHANGED);
            }
            JobQueueStatusRefresh.refreshAfterReschedule(ctx);
        }
        catch (BOSException e) {
            throw new PerfSepException(PerfSepException.STATEISCHANGED);
        }
    }
}

