/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.common.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.job.JobStateEnum;
import com.kingdee.eas.basedata.common.perf.JobInstExtCollection;
import com.kingdee.eas.basedata.common.perf.JobInstExtFactory;
import com.kingdee.eas.basedata.common.perf.JobInstExtInfo;
import com.kingdee.eas.basedata.common.perf.JobStateInfo;
import com.kingdee.eas.basedata.common.perf.app.AbstractJobInstStatusFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class JobInstStatusFacadeControllerBean
extends AbstractJobInstStatusFacadeControllerBean {
    private static final long serialVersionUID = -108158834944667229L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.common.perf.app.JobInstStatusFacadeControllerBean");

    @Override
    protected List _query(Context ctx) throws BOSException {
        return null;
    }

    @Override
    protected void _cancel(Context ctx, String id) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(id);
        JobInstExtFactory.getLocalInstance(ctx).cancel(list);
    }

    @Override
    protected void _updateProgress(Context ctx, String id, int progress) throws BOSException {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        JobStateEnum state = JobStateEnum.RUNNING;
        if (progress < 0 || progress > 100) {
            return;
        }
        if (progress >= 100) {
            progress = 100;
            state = JobStateEnum.COMPLETE;
        }
        String sql = "update T_BD_JobInstExt set fprogress = ?,fstate = ? where fid = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(progress), state.getValue(), id});
    }

    @Override
    protected void _updateProgress(Context ctx, String id, int progress, String progressDetail_l1, String progressDetail_l2, String progressDetail_l3) throws BOSException {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        JobStateEnum state = JobStateEnum.RUNNING;
        if (progress < 0 || progress > 100) {
            return;
        }
        if (progress >= 100) {
            progress = 100;
            state = JobStateEnum.COMPLETE;
        }
        String sql = "update T_BD_JobInstExt set fprogress = ?,fstate = ?,fprogressdetail_l1=?,fprogressdetail_l2=?,fprogressdetail_l3=? where fid = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(progress), state.getValue(), StringUtils.cnulls((String)progressDetail_l1), StringUtils.cnulls((String)progressDetail_l2), StringUtils.cnulls((String)progressDetail_l3), id});
    }

    @Override
    protected IObjectPK _add(Context ctx, JobInstExtInfo jobStatus) throws BOSException, EASBizException {
        if (null == jobStatus) {
            return null;
        }
        if (jobStatus.getId() == null) {
            BOSUuid id = BOSUuid.create((BOSObjectType)jobStatus.getBOSType());
            jobStatus.setId(id);
        }
        if (jobStatus.getJobInstId() == null) {
            jobStatus.setJobType((short)1);
        }
        return JobInstExtFactory.getLocalInstance(ctx).addnew(jobStatus);
    }

    @Override
    protected boolean _isCancel(Context ctx, String id) throws BOSException {
        if (StringUtils.isEmpty((String)id)) {
            return true;
        }
        String sql = "select 1 from T_BD_JobInstExt where fid = ? and fstate = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id, "Aborted"});
        try {
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.debug((Object)"\u83b7\u53d6\u4efb\u52a1\u7684\u72b6\u6001\u65f6\u51fa\u9519", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected boolean _isFinish(Context ctx, String jobId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)jobId)) {
            throw new BOSException("Invalid parameter ( jobId is null) !");
        }
        ObjectStringPK pk = new ObjectStringPK(jobId);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("jobInstId");
        selector.add("jobType");
        JobInstExtInfo info = JobInstExtFactory.getLocalInstance(ctx).getJobInstExtInfo((IObjectPK)pk, selector);
        if (null == info) {
            return true;
        }
        String sql = null;
        Object[] params = null;
        if (0 == info.getJobType()) {
            sql = "select 1 from T_JOB_Inst where fstate in ('Created','Waiting','Ready','Running','ReScheduled') and fjobinstid = ?";
            params = new Object[]{info.getJobInstId()};
        } else {
            sql = "select 1 from T_BD_JobInstExt where fstate in ('Created','Waiting','Ready','Running','ReScheduled') and fid = ?";
            params = new Object[]{jobId};
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        try {
            if (rowSet.next()) {
                return false;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    @Override
    protected JobStateInfo _queryStateInfo(Context ctx, String jobId) throws BOSException {
        return null;
    }

    @Override
    protected JobInstExtCollection _queryJobInstStatus(Context ctx, String[] ids) throws BOSException {
        JobInstExtCollection result = new JobInstExtCollection();
        if (ids == null || ids.length == 0) {
            return result;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" select instExt.fid fid,instExt.fprogress fprogress, instExt.fjobinstid,").append(this.getLocaleFieldStr("instExt.fprogressdetail", ctx.getLocale())).append(" fprogressdetail,").append(" instExt.fjobtype fjobtype,").append(" case when(instExt.fjobtype = 0) then").append(" (select inst.fstate from t_job_inst inst where inst.fjobinstid = instext.fjobinstid)").append(" else").append(" instExt.fstate").append(" end fstate").append(" from t_bd_jobinstext instExt ").append(" where instExt.fid in ( ").append(this.array2String(ids)).append(" )");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                JobInstExtInfo info = new JobInstExtInfo();
                info.setId(BOSUuid.read((String)rs.getString("fid")));
                info.setJobInstId(rs.getString("fjobinstid"));
                info.setProgress(rs.getShort("fprogress"));
                info.setProgressDetail(rs.getString("fprogressdetail"));
                info.setJobType(rs.getShort("fjobtype"));
                info.setState(JobStateEnum.getEnum((String)rs.getString("fstate")));
                result.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u67e5\u8be2\u6570\u636e\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private String array2String(String[] ids) {
        if (null == ids || ids.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int len = ids.length;
        for (int i = 0; i < len; ++i) {
            sb.append("'").append(ids[i]).append("',");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private String getLocaleFieldStr(String field, Locale locale) {
        if (null == locale) {
            return field + "_l2";
        }
        if ("l2".equalsIgnoreCase(locale.getLanguage())) {
            return field + "_l2";
        }
        if ("l1".equalsIgnoreCase(locale.getLanguage())) {
            return field + "_l1";
        }
        if ("l3".equalsIgnoreCase(locale.getLanguage())) {
            return field + "_l3";
        }
        return field + "_l2";
    }
}

