/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ws.account;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.util.APIPermissionCheckUtil;
import com.kingdee.eas.basedata.ws.account.AbstractImportAccountTableFacadeControllerBean;
import com.kingdee.eas.basedata.ws.common.WsCommonImportUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonTag;
import com.kingdee.eas.basedata.ws.common.WsCommonUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonXMLUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class ImportAccountTableFacadeControllerBean
extends AbstractImportAccountTableFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.ws.account.ImportAccountTableFacadeControllerBean");
    private String billNumber = "";
    private String retstatus = "0";
    private String errorMessage = "";

    @Override
    protected String _importAccountTableData(Context ctx, String xmlData) throws BOSException, EASBizException {
        try {
            Document doc = WsCommonXMLUtil.builderDocument(xmlData);
            if (null != doc) {
                WsCommonXMLUtil.validateRootElement(doc, "DataInfo");
                HashMap headPro = WsCommonXMLUtil.getBillHead(doc, "DataHead");
                this.billNumber = (String)headPro.get("number");
                CtrlUnitInfo cuInfo = WsCommonUtil.getCuInfo(ctx, (String)headPro.get("CU"));
                if (cuInfo == null) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUNOTFOUND", (Context)ctx));
                }
                ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)cuInfo);
                String attributeName = WsCommonXMLUtil.getAttributeValue(doc, "op");
                String bostype = WsCommonXMLUtil.getAttributeValue(doc, "bostype");
                AccountTableInfo accountTableInfo = new AccountTableInfo();
                EntityObjectInfo eo = WsCommonUtil.getEntityObjectInfo(ctx, bostype);
                Map<String, Object> map = WsCommonImportUtil.getBillHeadProperties(eo);
                accountTableInfo = (AccountTableInfo)WsCommonUtil.validateBills(ctx, eo, attributeName, this.billNumber, "", (CoreBaseInfo)accountTableInfo);
                if ("0".equals(attributeName) || "3".equals(attributeName) || "4".equals(attributeName)) {
                    String[] mustValidateHead = WsCommonTag.getMustValidateProsByAccountTableHead();
                    if (!"0".equals(attributeName)) {
                        WsCommonUtil.validateHeadProperty(mustValidateHead, headPro);
                    } else {
                        mustValidateHead = null;
                    }
                    WsCommonImportUtil.buildBillHead(ctx, (CoreBaseInfo)accountTableInfo, map, mustValidateHead, null, headPro, "");
                }
                String comId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
                if (accountTableInfo.getCompany() != null) {
                    comId = accountTableInfo.getCompany().getId().toString();
                }
                APIPermissionCheckUtil.checkPermission(ctx, comId, "bd_account_accountTable_import");
                ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
                WsCommonUtil.operationBills(ctx, eo, (CoreBaseInfo)accountTableInfo, attributeName, headPro, map);
            }
        }
        catch (Exception e) {
            this.retstatus = "1";
            this.errorMessage = e.getMessage();
        }
        return WsCommonXMLUtil.buildResultXml(this.retstatus, this.billNumber, this.errorMessage);
    }
}

