/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ws.common;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.eas.basedata.ws.common.WsCommonUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class WsCommonImportUtil {
    static final Logger logger = Logger.getLogger(WsCommonImportUtil.class);

    public static void buildBillHead(Context ctx, CoreBaseInfo baseinfo, Map<String, Object> map, String[] mustValidate, String[] notBuild, HashMap headMap, String cuId) throws Exception {
        if (null != map) {
            WsCommonImportUtil.buildBill(ctx, map, notBuild, headMap, mustValidate, (PropertyContainer)baseinfo, cuId);
        }
    }

    public static void buildBill(Context ctx, Map<String, Object> map, String[] notBuild, HashMap entiesPro, String[] mustValidate, PropertyContainer info, String cuId) throws Exception {
        for (Map.Entry<String, Object> et : map.entrySet()) {
            String key = et.getKey().toString();
            Object value = et.getValue();
            if (value instanceof EntityObjectInfo) {
                WsCommonUtil.setLinkProperties(ctx, info, mustValidate, key, value, notBuild, entiesPro, cuId);
                continue;
            }
            if (value.toString().equals("Date")) {
                WsCommonUtil.setDateProperties(info, key, entiesPro);
                continue;
            }
            if (value.toString().equals("Time") || value.toString().equals("TimeStamp")) {
                WsCommonUtil.seTimeStampProperties(info, key, entiesPro);
                continue;
            }
            if (value.toString().equals("Integer")) {
                WsCommonUtil.setIntProperties(info, key, entiesPro);
                continue;
            }
            if (value.toString().equals("BigDecimal")) {
                WsCommonUtil.setDeciamlProperties(info, key, entiesPro);
                continue;
            }
            if (value.toString().equals("Boolean")) {
                WsCommonUtil.setBooleanProperties(info, notBuild, key, entiesPro);
                continue;
            }
            if (!value.toString().equals("String")) continue;
            WsCommonUtil.setStrProperties(info, notBuild, key, entiesPro);
        }
    }

    public static Map<String, Object> getBillHeadProperties(EntityObjectInfo eo) {
        HashMap<String, Object> headMapcol = new HashMap<String, Object>();
        if (null != eo) {
            PropertyCollection pc = eo.getPropertiesRuntime();
            LinkPropertyInfo link = null;
            EntityObjectInfo childEntity = null;
            OwnPropertyInfo own = null;
            DataTableInfo table = eo.getTable();
            for (int i = 0; i < pc.size(); ++i) {
                link = null;
                own = null;
                if (pc.get(i) instanceof LinkPropertyInfo) {
                    link = (LinkPropertyInfo)pc.get(i);
                    if (null == link.getMappingField() || "".equals(link.getMappingField().getName())) continue;
                    childEntity = link.getRelationship().getSupplierObject();
                    if (eo.getType().toString().equals(childEntity.getType().toString())) {
                        childEntity = link.getRelationship().getClientObject();
                    }
                    headMapcol.put(link.getName(), childEntity);
                    continue;
                }
                if (!(pc.get(i) instanceof OwnPropertyInfo)) continue;
                own = (OwnPropertyInfo)pc.get(i);
                String ownName = own.getName();
                String dataType = own.getDataType().getName();
                if (own.getDataType().getName().equals("Enum")) {
                    Object[] em = EnumUtils.getEnumList((String)own.getMetaDataRef()).toArray();
                    if (em[0] instanceof StringEnum) {
                        dataType = "String";
                    } else if (em[0] instanceof IntEnum) {
                        dataType = "Integer";
                    }
                }
                headMapcol.put(ownName, dataType);
            }
        }
        return headMapcol;
    }

    private static Map<String, EntityObjectInfo> getEntriesEntityInfo(EntityObjectInfo headEo) {
        HashMap<String, EntityObjectInfo> entriesMap = new HashMap<String, EntityObjectInfo>();
        if (null != headEo) {
            PropertyCollection pc = headEo.getPropertiesRuntime();
            LinkPropertyInfo link = null;
            Object childEntity = null;
            for (int i = 0; i < pc.size(); ++i) {
                link = null;
                childEntity = null;
                if (!(pc.get(i) instanceof LinkPropertyInfo) || null != (link = (LinkPropertyInfo)pc.get(i)).getMappingField() && !"".equals(link.getMappingField().getName())) continue;
                entriesMap.put(link.getName(), link.getRelationship().getSupplierObject());
            }
        }
        return entriesMap;
    }

    public static Map<String, Object> getBillEntiesProperties(Context ctx, String entiesName, EntityObjectInfo eo) {
        EntityObjectInfo entry;
        Map<String, EntityObjectInfo> entriesMap = WsCommonImportUtil.getEntriesEntityInfo(eo);
        if (null != entriesMap && null != (entry = entriesMap.get(entiesName))) {
            return WsCommonImportUtil.getBillHeadProperties(entry);
        }
        return null;
    }
}

