/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ws.country;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.util.APIPermissionCheckUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonImportUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonTag;
import com.kingdee.eas.basedata.ws.common.WsCommonUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonXMLUtil;
import com.kingdee.eas.basedata.ws.country.AbstractImportCountryFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class ImportCountryFacadeControllerBean
extends AbstractImportCountryFacadeControllerBean {
    private static final long serialVersionUID = -3202117712260263861L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.ws.country.ImportCountryFacadeControllerBean");
    private String billNumber = "";
    private String retstatus = "0";
    private String errorMessage = "";

    @Override
    protected String _importCountryData(Context ctx, String xmlData) throws BOSException, EASBizException {
        try {
            Document doc;
            if (APIPermissionCheckUtil.isApiCheckPermission(ctx)) {
                PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), null, "bd_assistant_country_import");
            }
            if (null != (doc = WsCommonXMLUtil.builderDocument(xmlData))) {
                WsCommonXMLUtil.validateRootElement(doc, "DataInfo");
                HashMap headPro = WsCommonXMLUtil.getBillHead(doc, "DataHead");
                this.billNumber = (String)headPro.get("number");
                CtrlUnitInfo cuInfo = WsCommonUtil.getCuInfo(ctx, (String)headPro.get("CU"));
                if (cuInfo == null) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUNOTFOUND", (Context)ctx));
                }
                ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)cuInfo);
                String attributeName = WsCommonXMLUtil.getAttributeValue(doc, "op");
                this.checkPermission(ctx, cuInfo, attributeName);
                String bostype = WsCommonXMLUtil.getAttributeValue(doc, "bostype");
                CountryInfo countryInfo = new CountryInfo();
                EntityObjectInfo eo = WsCommonUtil.getEntityObjectInfo(ctx, bostype);
                Map<String, Object> map = WsCommonImportUtil.getBillHeadProperties(eo);
                countryInfo = (CountryInfo)WsCommonUtil.validateBill(ctx, eo, attributeName, this.billNumber, "", (CoreBaseInfo)countryInfo);
                if ("0".equals(attributeName) || "3".equals(attributeName) || "4".equals(attributeName)) {
                    String[] mustValidateHead = WsCommonTag.getMustValidateProsByCountryHead();
                    if (!"0".equals(attributeName)) {
                        WsCommonUtil.validateHeadProperty(mustValidateHead, headPro);
                    } else {
                        mustValidateHead = null;
                    }
                    WsCommonImportUtil.buildBillHead(ctx, (CoreBaseInfo)countryInfo, map, mustValidateHead, null, headPro, "");
                }
                ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
                WsCommonUtil.operationBill(ctx, eo, (CoreBaseInfo)countryInfo, attributeName, headPro, map, "deletedStatus");
            }
        }
        catch (Exception e) {
            this.retstatus = "1";
            this.errorMessage = e.getMessage();
        }
        return WsCommonXMLUtil.buildResultXml(this.retstatus, this.billNumber, this.errorMessage);
    }

    private void checkPermission(Context ctx, CtrlUnitInfo cuInfo, String opAttributeName) throws BOSException, EASBizException {
        String permItemName = "";
        permItemName = "0".equals(opAttributeName) ? "bd_assistant_country_update" : "bd_assistant_country_import";
        APIPermissionCheckUtil.checkPermission(ctx, cuInfo, permItemName);
    }
}

