/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ws.material;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.util.APIPermissionCheckUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonXMLUtil;
import com.kingdee.eas.basedata.ws.material.AbstractAssignMaterialFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class AssignMaterialFacadeControllerBean
extends AbstractAssignMaterialFacadeControllerBean {
    private static final long serialVersionUID = -6954789078025712673L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.ws.material.AssignMaterialFacadeControllerBean");
    private String retstatus = "0";
    private String errorMessage = "";

    @Override
    protected String _assignMaterial(Context ctx, String xmlData) throws BOSException, EASBizException {
        String sourceCuNum = "";
        String dataBaseNumber = "";
        String[] targerCuNum = null;
        try {
            Document doc = WsCommonXMLUtil.builderDocument(xmlData);
            if (null != doc) {
                WsCommonXMLUtil.validateRootElement(doc, "AssignData");
                HashMap assignHead = WsCommonXMLUtil.getBillHead(doc, "AssignHead");
                ArrayList assignCU = WsCommonXMLUtil.getBillEntries(doc, "AssignCUS//AssignCU");
                if (null == assignHead || assignHead.size() <= 0 || null == assignCU || assignCU.size() <= 0) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"ASSIGNCUNOTNULL", (Context)ctx));
                }
                sourceCuNum = (String)assignHead.get("sourceCU");
                dataBaseNumber = (String)assignHead.get("dataNumber");
                sourceCuNum = WsCommonXMLUtil.getCUtNumberByXML(sourceCuNum);
                this.checkPermission(ctx, sourceCuNum);
                if (null == sourceCuNum || "".equals(sourceCuNum)) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUNOTNULL", (Context)ctx));
                }
                if (null == dataBaseNumber || "".equals(dataBaseNumber)) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"NUMBERNOTNULL", (Context)ctx));
                }
                targerCuNum = WsCommonUtil.getTargetCUNumber(assignCU);
                FullOrgUnitInfo sourceCU = DataImportUtils.getFullOrgUnitInfoFromNumber((Context)ctx, (String)sourceCuNum);
                FullOrgUnitInfo destCU = null;
                MaterialInfo materialInfo = DataImportUtils.getMaterialInfoFromNumber((Context)ctx, (String)dataBaseNumber);
                if (sourceCU == null || !sourceCU.isIsCU()) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUNOTEXISTS", (Context)ctx));
                }
                if (materialInfo == null) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"MATERIALNOTEXISTS", (Context)ctx));
                }
                if (!materialInfo.getCU().getId().equals((Object)sourceCU.getId())) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUNOTHASBASEINFO", (Context)ctx));
                }
                IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
                for (int i = 0; i < targerCuNum.length; ++i) {
                    destCU = DataImportUtils.getFullOrgUnitInfoFromNumber((Context)ctx, (String)targerCuNum[i]);
                    if (destCU == null || !destCU.isIsCU()) continue;
                    iMaterial.batchAssign(sourceCU.getId().toString(), new String[]{materialInfo.getId().toString()}, new String[]{destCU.getId().toString()});
                }
            }
        }
        catch (Exception e) {
            this.retstatus = "1";
            this.errorMessage = e.getMessage();
        }
        return WsCommonXMLUtil.buildResultXml(this.retstatus, dataBaseNumber, this.errorMessage);
    }

    private void checkPermission(Context ctx, String cuInfo) throws BOSException, EASBizException {
        String permItemName = "bd_material_aasign";
        APIPermissionCheckUtil.validatePermission(ctx, cuInfo, permItemName);
    }
}

