/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ws.supplier;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.util.APIPermissionCheckUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonImportUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonTag;
import com.kingdee.eas.basedata.ws.common.WsCommonUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonXMLUtil;
import com.kingdee.eas.basedata.ws.supplier.AbstractImportSupplierCompanyFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.PropertyContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class ImportSupplierCompanyFacadeControllerBean
extends AbstractImportSupplierCompanyFacadeControllerBean {
    private static final long serialVersionUID = 2234306794326361603L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.ws.supplier.ImportSupplierCompanyFacadeControllerBean");
    private String billNumber = "";
    private String retstatus = "0";
    private String errorMessage = "";

    @Override
    protected String _importSupplierCompanyData(Context ctx, String xmlData) throws BOSException, EASBizException {
        try {
            Document doc = WsCommonXMLUtil.builderDocument(xmlData);
            if (null != doc) {
                WsCommonXMLUtil.validateRootElement(doc, "DataInfo");
                HashMap headPro = WsCommonXMLUtil.getBillHead(doc, "DataHead");
                ArrayList entiesPro = WsCommonXMLUtil.getBillEntries(doc, "DataEntries//entry");
                this.billNumber = (String)headPro.get("supplier");
                CtrlUnitInfo cuInfo = WsCommonUtil.getCuInfo(ctx, (String)headPro.get("CU"));
                if (cuInfo == null) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUNOTFOUND", (Context)ctx));
                }
                ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)cuInfo);
                String opAttributeName = WsCommonXMLUtil.getAttributeValue(doc, "op");
                String bostype = WsCommonXMLUtil.getAttributeValue(doc, "bostype");
                SupplierCompanyInfoInfo supplierCompanyInfo = new SupplierCompanyInfoInfo();
                EntityObjectInfo eo = WsCommonUtil.getEntityObjectInfo(ctx, bostype);
                Map<String, Object> map = WsCommonImportUtil.getBillHeadProperties(eo);
                this.checkPermission(ctx, cuInfo, opAttributeName);
                SupplierInfo supplierInfo = WsCommonUtil.getSupplierInfo(ctx, this.billNumber, cuInfo.getId().toString());
                if (null == supplierInfo) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"SUPPLIERNOTEXISTS", (Context)ctx));
                }
                supplierCompanyInfo = this.getSupplierCompanyInfo(ctx, this.billNumber, (String)headPro.get("companyOrgUnit"));
                if ("0".equals(opAttributeName) && null == supplierCompanyInfo) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"COMPANYNOTFOUND", (Context)ctx));
                }
                if (("3".equals(opAttributeName) || "4".equals(opAttributeName)) && null != supplierCompanyInfo) {
                    opAttributeName = "0";
                } else if (("3".equals(opAttributeName) || "4".equals(opAttributeName)) && null == supplierCompanyInfo) {
                    supplierCompanyInfo = null;
                    supplierCompanyInfo = new SupplierCompanyInfoInfo();
                }
                if ("0".equals(opAttributeName) || "3".equals(opAttributeName) || "4".equals(opAttributeName)) {
                    String[] mustValidateHead = WsCommonTag.getMustValidateProsBySupplierCompanyHead();
                    String[] mustValidateEntry = WsCommonTag.getMustValidateProsBySupplierCompanyEntry();
                    if (!"0".equals(opAttributeName)) {
                        WsCommonUtil.validateHeadProperty(mustValidateHead, headPro);
                        WsCommonUtil.validateEntiesProperty(mustValidateEntry, entiesPro);
                    } else {
                        mustValidateHead = null;
                        mustValidateEntry = null;
                    }
                    WsCommonImportUtil.buildBillHead(ctx, (CoreBaseInfo)supplierCompanyInfo, map, mustValidateHead, null, headPro, cuInfo.getId().toString());
                    CoreBaseCollection col = new CoreBaseCollection();
                    this.buildBillEnties(ctx, entiesPro, mustValidateEntry, supplierCompanyInfo, eo, cuInfo.getId().toString(), opAttributeName, col);
                    ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
                    WsCommonUtil.operationBill(ctx, eo, (CoreBaseInfo)supplierCompanyInfo, opAttributeName, headPro, map, "");
                    if ("0".equals(opAttributeName) && null != col && col.size() > 0) {
                        SupplierCompanyBankFactory.getLocalInstance((Context)ctx).save(col);
                    }
                }
            }
        }
        catch (Exception e) {
            this.retstatus = "1";
            this.errorMessage = e.getMessage();
        }
        return WsCommonXMLUtil.buildResultXml(this.retstatus, this.billNumber, this.errorMessage);
    }

    private void buildBillEnties(Context ctx, ArrayList entiesPro, String[] mustValidate, SupplierCompanyInfoInfo supplierCompanyInfo, EntityObjectInfo eo, String cuId, String op, CoreBaseCollection col) throws Exception {
        Map<String, Object> map = WsCommonImportUtil.getBillEntiesProperties(ctx, "supplierBank", eo);
        SupplierCompanyBankInfo supplierCompanyBankInfo = null;
        HashMap entryMap = null;
        if (null != map) {
            SupplierCompanyBankCollection updateCompanyBankCollection = new SupplierCompanyBankCollection();
            int count = entiesPro.size();
            for (int i = 0; i < count; ++i) {
                entryMap = null;
                supplierCompanyBankInfo = null;
                entryMap = (HashMap)entiesPro.get(i);
                supplierCompanyBankInfo = new SupplierCompanyBankInfo();
                WsCommonUtil.setPropertyNumberByXml(ctx, entryMap, "bank", "bank.xml");
                WsCommonImportUtil.buildBill(ctx, map, null, entryMap, mustValidate, (PropertyContainer)supplierCompanyBankInfo, cuId);
                if ("3".equals(op) || "4".equals(op)) {
                    supplierCompanyInfo.getSupplierBank().add(supplierCompanyBankInfo);
                }
                if (!"0".equals(op)) continue;
                if (!this.checkBankIsExits(ctx, supplierCompanyBankInfo.getBankAccount(), supplierCompanyInfo.getId().toString())) {
                    supplierCompanyBankInfo.setSupplierCompanyInfo(supplierCompanyInfo);
                    col.add((CoreBaseInfo)supplierCompanyBankInfo);
                }
                updateCompanyBankCollection.add(supplierCompanyBankInfo);
            }
            if (supplierCompanyInfo.getSupplierBank() != null && "0".equals(op)) {
                supplierCompanyInfo.getSupplierBank().clear();
                supplierCompanyInfo.getSupplierBank().addCollection(updateCompanyBankCollection);
            }
            if (entiesPro.size() == 0 && supplierCompanyInfo.getBankAccount() != null) {
                supplierCompanyBankInfo = new SupplierCompanyBankInfo();
                supplierCompanyBankInfo.setBankAccount(supplierCompanyInfo.getBankAccount());
                supplierCompanyBankInfo.setBank(supplierCompanyInfo.getBankName());
                if ("3".equals(op) || "4".equals(op)) {
                    supplierCompanyInfo.getSupplierBank().add(supplierCompanyBankInfo);
                }
                if ("0".equals(op) && !this.checkBankIsExits(ctx, supplierCompanyBankInfo.getBankAccount(), supplierCompanyInfo.getId().toString())) {
                    supplierCompanyBankInfo.setSupplierCompanyInfo(supplierCompanyInfo);
                    col.add((CoreBaseInfo)supplierCompanyBankInfo);
                }
            }
        }
    }

    private SupplierCompanyInfoInfo getSupplierCompanyInfo(Context ctx, String customerNumber, String companynumber) throws Exception {
        SupplierCompanyInfoInfo companyInfo = null;
        if (null != customerNumber && !"".equals(customerNumber) || null != companynumber && !"".equals(companynumber)) {
            try {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                FilterItemCollection fic = filter.getFilterItems();
                fic.add(new FilterItemInfo("supplier.number", (Object)customerNumber, CompareType.EQUALS));
                fic.add(new FilterItemInfo("companyOrgUnit.number", (Object)companynumber, CompareType.EQUALS));
                view.setFilter(filter);
                SupplierCompanyInfoCollection col = SupplierCompanyInfoFactory.getLocalInstance((Context)ctx).getSupplierCompanyInfoCollection(view);
                if (null != col && col.size() > 0) {
                    companyInfo = col.get(0);
                }
            }
            catch (BOSException e) {
                throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"COMPANYNOTFOUND", (Context)ctx));
            }
        }
        return companyInfo;
    }

    private boolean checkBankIsExits(Context ctx, String bankNum, String supplierCompanyId) {
        if (null == bankNum || "".equals(bankNum) || "".equals(supplierCompanyId) || null == supplierCompanyId) {
            return false;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("supplierCompanyInfo.id", (Object)supplierCompanyId, CompareType.EQUALS));
        fic.add(new FilterItemInfo("bankAccount", (Object)bankNum, CompareType.EQUALS));
        view.setFilter(filter);
        try {
            SupplierCompanyBankCollection col = SupplierCompanyBankFactory.getLocalInstance((Context)ctx).getSupplierCompanyBankCollection(view);
            if (null != col && col.size() > 0) {
                return true;
            }
        }
        catch (BOSException e) {
            return false;
        }
        return false;
    }

    private void checkPermission(Context ctx, CtrlUnitInfo cuInfo, String opAttributeName) throws BOSException, EASBizException {
        String permItemName = "";
        permItemName = "0".equals(opAttributeName) ? "Suppliercompanyinfo_AddNew" : "Suppliercompanyinfo_Update";
        APIPermissionCheckUtil.checkPermission(ctx, cuInfo, permItemName);
    }
}

