/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.batch.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.master.batch.app.AbstractBatchUpdateStrategy;
import com.kingdee.eas.basedata.master.batch.model.EntityModelInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class GeneralBatchUpdateStrategy
extends AbstractBatchUpdateStrategy {
    protected List uptIdList = new ArrayList();

    public GeneralBatchUpdateStrategy() {
    }

    public GeneralBatchUpdateStrategy(EntityModelInfo et, String[] pks, String[] ps, Object vs) {
        super(et, pks, ps, vs);
    }

    @Override
    protected final void batchUpdate(Context ctx, Map params) throws BOSException, EASBizException {
        if (this.idList != null) {
            int size = this.idList.length;
            for (int i = 0; i < size; ++i) {
                this.validateBizLogic(ctx, (IObjectPK)new ObjectStringPK(this.idList[i].toString()), params);
            }
            this.validateBizLogic(ctx, this.idList, params);
            this.log.setRecordCount(this.idList.length);
            if (this.uptIdList != null) {
                this.log.setSuccessRecordCount(this.uptIdList.size());
                this.log.setFailRecordCount(this.idList.length - this.uptIdList.size());
                this.executeUpdate(ctx);
            } else {
                this.log.setFailRecordCount(this.idList.length);
            }
        }
    }

    protected void validateBizLogic(Context ctx, Object[] pks, Map params) throws BOSException, EASBizException {
    }

    protected abstract void validateBizLogic(Context var1, IObjectPK var2, Map var3) throws BOSException, EASBizException;

    protected void executeUpdate(Context ctx) throws BOSException {
        if (this.uptIdList != null && this.values != null && this.values instanceof Map && this.entity != null) {
            StringBuffer strSQL = new StringBuffer();
            strSQL.append(this.entity.createUpdateSQlCommand());
            Collection vs = ((Map)this.values).values();
            ArrayList<Object> ls = new ArrayList<Object>();
            ls.addAll(vs);
            int size = this.uptIdList.size();
            if (vs != null && size != 0) {
                strSQL.append(",flastupdateuserid='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',flastupdatetime=getdate() Where FID In(");
                boolean flag = true;
                for (int i = 0; i < size; ++i) {
                    if (i != 1 && i % 900 == 1) {
                        flag = false;
                    }
                    if (i != 0 && flag) {
                        strSQL.append(",");
                    }
                    flag = true;
                    strSQL.append("?");
                    ls.add(ls.size(), this.uptIdList.get(i).toString());
                    if (i == 0 || i % 900 != 0) continue;
                    strSQL.append(")");
                    this.execute(ctx, strSQL.toString(), ls.toArray());
                    ORMValueCacheService.getInstance().discardType(ctx, this.entity.getBOSType());
                    if (i != size - 1) {
                        strSQL = new StringBuffer();
                        strSQL.append(this.entity.createUpdateSQlCommand());
                        ls = new ArrayList();
                        ls.addAll(vs);
                        strSQL.append(",flastupdateuserid='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',flastupdatetime=getdate() Where FID In(");
                        continue;
                    }
                    return;
                }
                strSQL.append(")");
                this.execute(ctx, strSQL.toString(), ls.toArray());
                ORMValueCacheService.getInstance().discardType(ctx, this.entity.getBOSType());
            }
        }
    }

    protected void execute(Context ctx, String sql, Object[] params) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                if (params[i] != null) {
                    ps.setObject(i + 1, params[i]);
                    continue;
                }
                ps.setNull(i + 1, 12);
            }
            ps.execute();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    protected boolean isCheckLengthError(String[] propertiesToCheck, int length) {
        for (int i = 0; i < propertiesToCheck.length; ++i) {
            String propertyToCheck = propertiesToCheck[i];
            String value = null;
            Object object = ((Map)this.values).get(this.properties[0].toString());
            if (null != object) {
                value = object.toString();
            }
            if (value == null || !propertyToCheck.equals(this.properties[0].toString()) || value.length() <= length) continue;
            return true;
        }
        return false;
    }
}

