/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.batch.model;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.basedata.master.batch.Helper;
import com.kingdee.eas.basedata.master.batch.IHandler;
import com.kingdee.eas.basedata.master.batch.Request;
import com.kingdee.eas.basedata.master.batch.model.EntityModelInfo;
import com.kingdee.eas.basedata.master.batch.model.ILoadMetasCommand;
import com.kingdee.eas.basedata.master.batch.model.PropertyModelInfo;
import com.kingdee.eas.basedata.master.batch.model.xml.XmlRequest;
import com.kingdee.eas.basedata.master.batch.viewer.ViewerFactory;
import com.kingdee.eas.common.SysConstant;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;

public class PropertyModelCollection
extends AbstractObjectCollection
implements IHandler,
ILoadMetasCommand {
    private static final long serialVersionUID = 6934304294083171365L;
    public static final String REQUEST_EXCLUDE = "exclude";
    public static final String REQUEST_INCLUDE = "include";
    private String[] include = null;
    private String[] exclude = null;
    public EntityModelInfo entityModelInfo = null;

    public PropertyModelCollection() {
        super(PropertyModelInfo.class);
    }

    public boolean add(PropertyModelInfo item) {
        return this.addObject((IObjectValue)item);
    }

    public boolean addCollection(PropertyModelCollection item) {
        return this.addObjectCollection((IObjectCollection)item);
    }

    public boolean remove(PropertyModelInfo item) {
        return this.removeObject((IObjectValue)item);
    }

    public PropertyModelInfo get(int index) {
        return (PropertyModelInfo)this.getObject(index);
    }

    public PropertyModelInfo get(Object key) {
        return (PropertyModelInfo)this.getObject(key);
    }

    public void set(int index, PropertyModelInfo item) {
        this.setObject(index, (IObjectValue)item);
    }

    public boolean contains(PropertyModelInfo item) {
        return this.containsObject((IObjectValue)item);
    }

    public boolean contains(Object key) {
        return this.containsKey(key);
    }

    public int indexOf(PropertyModelInfo item) {
        return super.indexOf((IObjectValue)item);
    }

    public PropertyInfo getBosPropertyInfo(String bosId) {
        PropertyInfo p = null;
        if (this.entityModelInfo != null && this.entityModelInfo.getEntityObjectInfo() != null) {
            p = this.entityModelInfo.getEntityObjectInfo().getPropertyByNameRuntime(bosId);
        }
        return p;
    }

    @Override
    public void handleRequest(Request request) {
        if (request instanceof XmlRequest) {
            XmlRequest r = (XmlRequest)request;
            Object ls = null;
            ls = r.getCatalogDetail(REQUEST_INCLUDE);
            if (ls != null) {
                this.include = ls.toString().split(",");
            }
            if ((ls = r.getCatalogDetail(REQUEST_EXCLUDE)) != null) {
                this.exclude = ls.toString().split(",");
            }
        }
    }

    @Override
    public void loadMetasCommand() {
        if (this.include != null && this.include.length != 0) {
            this.execInclude();
        } else if (this.exclude != null && this.exclude.length != 0) {
            this.execExclude();
        }
        PropertyModelInfo o = null;
        Iterator itor = this.iterator();
        while (itor.hasNext()) {
            o = (PropertyModelInfo)itor.next();
            o.setEntityModel(this.entityModelInfo);
            o.loadMetasCommand();
        }
    }

    @Override
    public void loadServerMetasCommand(Context ctx) {
        if (this.include != null && this.include.length != 0) {
            this.execInclude();
        } else if (this.exclude != null && this.exclude.length != 0) {
            this.execExclude();
        }
        PropertyModelInfo o = null;
        Iterator itor = this.iterator();
        while (itor.hasNext()) {
            o = (PropertyModelInfo)itor.next();
            o.setEntityModel(this.entityModelInfo);
            o.loadServerMetasCommand(ctx);
        }
    }

    private void execInclude() {
        PropertyModelInfo p = null;
        if (this.entityModelInfo != null && this.entityModelInfo.getBosProperties() != null) {
            HashMap<String, BigDecimal> m = new HashMap<String, BigDecimal>();
            int size = this.include.length;
            for (int i = 0; i < size; ++i) {
                if (!this.contains(this.include[i]) && Helper.containsBosPropertyName(this.entityModelInfo.getEntityObjectInfo(), this.include[i])) {
                    p = new PropertyModelInfo();
                    p.setBosId(this.include[i]);
                    p.setClassId(this.entityModelInfo.getClassId() + "." + p.getBosId());
                    p.setViewer(ViewerFactory.getInstance().getViewer("simpletextfield"));
                    this.addObject((IObjectValue)p);
                }
                m.put(this.include[i], SysConstant.BIGZERO);
            }
        }
    }

    private void execExclude() {
        PropertyModelInfo p = null;
        if (this.entityModelInfo != null && this.entityModelInfo.getBosProperties() != null) {
            PropertyCollection ps = this.entityModelInfo.getBosProperties();
            HashMap<String, BigDecimal> m = new HashMap<String, BigDecimal>();
            int size = this.exclude.length;
            for (int i = 0; i < size; ++i) {
                this.removeObject(this.exclude[i]);
                m.put(this.exclude[i], SysConstant.BIGZERO);
            }
            String pn = null;
            int count = ps.size();
            for (int index = 0; index < count; ++index) {
                pn = ps.get(index).getName();
                if (this.contains(pn) || m.containsKey(pn)) continue;
                p = new PropertyModelInfo();
                p.setBosId(pn);
                p.setClassId(this.entityModelInfo.getClassId() + "." + p.getBosId());
                p.setViewer(ViewerFactory.getInstance().getViewer("simpletextfield"));
                this.addObject((IObjectValue)p);
            }
        }
    }

    public String[] toPropertyArray() {
        String[] properties = new String[this.size()];
        int i = 0;
        Iterator itor = this.iterator();
        PropertyModelInfo p = null;
        while (itor.hasNext()) {
            p = (PropertyModelInfo)itor.next();
            if (p == null) continue;
            properties[i] = p.getBosId();
            ++i;
        }
        return properties;
    }
}

