/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.batch.viewer;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.eas.basedata.master.batch.client.ClientHelper;
import com.kingdee.eas.basedata.master.batch.viewer.AbstractPropertyViewer;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;

public class EnumViewer
extends AbstractPropertyViewer
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 4013020910367893264L;
    private transient Class enums = null;
    private transient Method iteratorMethod = null;
    private transient Method getValueMethod = null;

    private KDComboBox getComboBox() throws Exception {
        return (KDComboBox)this.controller;
    }

    public String getEnum() {
        return (String)this.get("enum");
    }

    public void setEnum(String item) throws Exception {
        this.put("enum", item);
    }

    public String getInclude() {
        return (String)this.get("include");
    }

    public void setInclude(String item) {
        this.put("include", item);
    }

    public String getExclude() {
        return (String)this.get("exclude");
    }

    public void setExclude(String item) {
        this.put("exclude", item);
    }

    @Override
    protected void initialize(Map uiContext) throws Exception {
        Object v;
        if (this.controller == null) {
            this.setController((JComponent)new KDComboBox());
        }
        KDComboBox list = this.getComboBox();
        this.enums = Class.forName(this.getEnum());
        list.removeAllItems();
        if (this.enums != null && this.iteratorMethod() != null && (v = this.iteratorMethod.invoke((Object)this.enums, null)) != null && v instanceof Iterator) {
            ClientHelper.refreshEnumList((KDComboBox)list, (Iterator)((Iterator)v));
        }
        String include = this.getInclude();
        String exclude = this.getExclude();
        if (include != null && include.length() != 0) {
            this.execInclude(include.split(","));
        } else if (exclude != null && exclude.length() != 0) {
            this.execExclude(exclude.split(","));
        }
        if (list.getItemCount() > 0) {
            Enum iniValue = this.getEnumItem(this.getInitValue());
            if (iniValue != null) {
                list.setSelectedItem((Object)iniValue);
            } else {
                list.setSelectedIndex(0);
            }
        }
    }

    private void execInclude(String[] include) throws Exception {
        KDComboBox list = this.getComboBox();
        if (include != null) {
            int count = include.length;
            for (int i = 0; i < count; ++i) {
                list.addItem((Object)this.getEnumItem(include[i]));
            }
        }
    }

    private void execExclude(String[] exclude) throws Exception {
        KDComboBox list = this.getComboBox();
        if (list.getItemCount() != 0) {
            int count = exclude.length;
            for (int i = 0; i < count; ++i) {
                list.removeItem((Object)this.getEnumItem(exclude[i]));
            }
        }
    }

    private Method iteratorMethod() throws Exception {
        if (this.iteratorMethod == null) {
            this.iteratorMethod = this.enums.getMethod("iterator", null);
        }
        return this.iteratorMethod;
    }

    private Field getEumField() throws Exception {
        return this.enums.getField("getEnum");
    }

    private Method getValueMethod() throws Exception {
        if (this.getValueMethod == null) {
            this.getValueMethod = this.enums.getMethod("getValue", null);
        }
        return this.getValueMethod;
    }

    private Enum getEnumItem(String enumItemName) throws Exception {
        Object o;
        Field field;
        Enum v = null;
        if (enumItemName != null && enumItemName.trim().length() != 0 && (field = this.enums.getField(enumItemName)) != null && (o = field.get(this.enums)) instanceof Enum) {
            v = (Enum)o;
        }
        return v;
    }

    @Override
    public Object getValue() throws Exception {
        return this.getComboBox().getSelectedItem();
    }

    @Override
    public Object getObjectValue() throws Exception {
        return this.getObjectValue(this.getValue());
    }

    @Override
    public Object getObjectValue(Object o) throws Exception {
        Object result = null;
        if (o != null) {
            if (o instanceof StringEnum) {
                result = ((StringEnum)o).getValue();
            } else if (o instanceof IntEnum) {
                result = new Integer(((IntEnum)o).getValue());
            } else if (this.getValueMethod() != null) {
                result = this.getValueMethod.invoke(o, null);
            }
        }
        return result;
    }
}

