/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.batch.viewer;

import com.kingdee.eas.basedata.master.batch.viewer.AbstractPropertyViewer;
import com.kingdee.eas.basedata.master.batch.viewer.DateViewer;
import com.kingdee.eas.basedata.master.batch.viewer.EnumViewer;
import com.kingdee.eas.basedata.master.batch.viewer.F7Viewer;
import com.kingdee.eas.basedata.master.batch.viewer.FormattedViewer;
import com.kingdee.eas.basedata.master.batch.viewer.SpinnerViewer;
import com.kingdee.eas.basedata.master.batch.viewer.TextViewer;

public final class ViewerFactory {
    public static final String VIEWER_TYPE_F7 = "f7viewer";
    public static final String VIEWER_TYPE_ENUM = "enumviewer";
    public static final String VIEWER_TYPE_DATE = "dateviewer";
    public static final String VIEWER_TYPE_FORMATTED = "formattedviewer";
    public static final String VIEWER_TYPE_SPINNER = "spinnerviewer";
    public static final String VIEWER_TYPE_TEXT = "simpletextfield";
    public static final String VIEWER_TYPE_DEFAULT = "simpletextfield";
    private static ViewerFactory factory = new ViewerFactory();

    private ViewerFactory() {
    }

    public static ViewerFactory getInstance() {
        return factory;
    }

    public AbstractPropertyViewer getViewer(String viewerName) {
        AbstractPropertyViewer viewer = new TextViewer();
        if (viewerName != null && viewerName.trim().length() != 0) {
            if (viewerName.equalsIgnoreCase(VIEWER_TYPE_F7)) {
                viewer = new F7Viewer();
            } else if (viewerName.equalsIgnoreCase(VIEWER_TYPE_ENUM)) {
                viewer = new EnumViewer();
            } else if (viewerName.equalsIgnoreCase(VIEWER_TYPE_DATE)) {
                viewer = new DateViewer();
            } else if (viewerName.equalsIgnoreCase(VIEWER_TYPE_FORMATTED)) {
                viewer = new FormattedViewer();
            } else if (viewerName.equalsIgnoreCase(VIEWER_TYPE_SPINNER)) {
                viewer = new SpinnerViewer();
            } else if (viewerName.equalsIgnoreCase("simpletextfield")) {
                viewer = new TextViewer();
            } else if (viewerName.equalsIgnoreCase("simpletextfield")) {
                // empty if block
            }
        }
        return viewer;
    }
}

